/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
export class AboutModalComponent {
    /**
     * @param {?} activeModal
     */
    constructor(activeModal) {
        this.activeModal = activeModal;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
AboutModalComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-about-modal',
                template: `
  <div class="modal-header">
    <h5 class="modal-title">{{ 'nwfjs:aboutProduct' | i18next: {productName: productName} }}</h5>
</div>
<div class="modal-body">
    <div class="nwf-about-main-panel">

        <!-- First row -->
        <div class="nwf-about-row">
            <!-- Content panel
                    This has 3 login cells. 1. Logo, 2. vertical line and 3. company information -->
            <div class="nwf-about-cell">
                <div class="nwf-about-logo-panel">
                    <!-- Application logo-->
                    <div class="nwf-about-row">
                        <div class="nwf-about-logo"></div>
                    </div>
                </div>

            </div>

            <div class="nwf-about-cell">
                <!-- Form panel inline-table-->
                <div class="nwf-about-form-panel">

                    <!-- This is just the one that is handed in -->

                    <!-- Product name -->
                    <div class="nwf-about-row" *ngIf="productName">
                        <p class="nwf-about-product-name" data-netapp-id="aboutDialog-product-name">
                            {{productName}}
                        </p>
                    </div>

                    <!-- Version number -->
                    <div class="nwf-about-row" *ngIf="version">
                        <p class="nwf-about-version-number" data-netapp-id="aboutDialog-version">
                            {{'nwfjs:version' | i18next:{version: version} }}
                        </p>
                    </div>

                    <!-- System ID -->
                    <div class="nwf-about-row" *ngIf="systemId">
                        <p class="nwf-about-version-number" data-netapp-id="aboutDialog-UUID">
                            {{'nwfjs:systemId' | i18next:{systemId: systemId} }}
                        </p>
                    </div>

                    <!-- Session ID -->
                    <div class="nwf-about-row" *ngIf="sessionId">
                        <p class="nwf-about-sessionId" data-netapp-id="aboutDialog-UUID">
                            {{'nwfjs:sessionId' | i18next:{sessionId: sessionId} }}
                        </p>
                    </div>


                    <!-- Confidentiality text -->
                    <div class="nwf-about-row">
                        <p class="nwf-about-confidentiality-text" data-netapp-id="aboutDialog-conftext">
                            {{confText}}
                        </p>
                    </div>

                    <!-- Copyright information  -->
                    <div class="nwf-about-row">
                        <p class="nwf-about-copyright-info">
                            <span class="copyright-symbol">&copy; &nbsp;</span>{{copyright}}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button class="btn btn-primary" (click)="activeModal.close()" data-netapp-id="aboutDialog-ok-button" autofocus>{{'nwfjs:OK' | i18next}}</button>
</div>

  `,
                styles: [".nwf-about-row{display:table-row}.nwf-about-main-panel{display:table;height:100%;width:100%;padding:20px}.nwf-about-header{height:100%;width:100%;margin:0;background-color:#fff;color:#fff;padding:0}.nwf-about-logo{background-image:url(data:image/png;base64,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);background-repeat:no-repeat;width:77px;height:89px;margin-top:6px}.nwf-about-brand-logo{vertical-align:middle;display:inline-block}.nwf-about-vert-line{padding:0 29px}.nwf-about-form-panel{display:inline-table;vertical-align:middle;padding-left:25px}.nwf-about-logo-panel{display:inline-table}.nwf-about-sessionId,.nwf-about-systemId,.nwf-about-version-number{color:#0067c5;display:table-cell;padding-bottom:10px}.nwf-about-product-name{font-size:20px;color:#0067c5;display:table-cell;padding-bottom:10px}.nwf-about-confidentiality-text{color:#454545;text-transform:uppercase;display:table-cell;padding-bottom:10px}.nwf-about-copyright-info{color:#454545;display:table-cell;padding-bottom:10px}.nwf-about-center-cell{display:table-cell;text-align:center}.nwf-about-cell{display:table-cell;vertical-align:top}.copyright-symbol{font-family:Arial,\"Helvetica Neue\",Helvetica,sans-serif;font-size:12px}"]
            }] }
];
/** @nocollapse */
AboutModalComponent.ctorParameters = () => [
    { type: NgbActiveModal }
];
if (false) {
    /** @type {?} */
    AboutModalComponent.prototype.productName;
    /** @type {?} */
    AboutModalComponent.prototype.version;
    /** @type {?} */
    AboutModalComponent.prototype.systemId;
    /** @type {?} */
    AboutModalComponent.prototype.sessionId;
    /** @type {?} */
    AboutModalComponent.prototype.confText;
    /** @type {?} */
    AboutModalComponent.prototype.copyright;
    /** @type {?} */
    AboutModalComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,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