/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService, TransitionService } from '@uirouter/core';
import { forEach, isMatch, reduce } from 'lodash-es';
import { NwfLeftnavService } from './leftnav.service';
export class LeftnavComponent {
    /**
     * @param {?} leftnavService
     * @param {?} transitionService
     * @param {?} stateService
     */
    constructor(leftnavService, transitionService, stateService) {
        this.leftnavService = leftnavService;
        this.transitionService = transitionService;
        this.stateService = stateService;
        this.keepOtherSectionsOpen = true;
    }
    /**
     * @return {?}
     */
    repaintStateHighlight() {
        const { current, params } = this.stateService;
        setTimeout((/**
         * @return {?}
         */
        () => { this.markActiveState(this.navData, current, params); }), 0);
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        // Set my navData on the leftnavService so others (like feature tour ) can open a tree of items programatically.
        this.leftnavService.navData = this.navData;
        /* On Enter I recurse to find out what to highlight */
        this.transitionService.onSuccess({}, (/**
         * @param {?} trans
         * @return {?}
         */
        (trans) => {
            this.repaintStateHighlight();
        }));
        this.closeAll(this.navData);
        /* I have to find out on load where I am as well */
        this.repaintStateHighlight();
    }
    /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    markActiveState(navData, state, params = null) {
        return reduce(navData, (/**
         * @param {?} matched
         * @param {?} item
         * @return {?}
         */
        (matched, item) => {
            /** @type {?} */
            let matchesChild = false;
            if (item.children) {
                matchesChild = this.markActiveState(item.children, state, params);
            }
            if (this.keepOtherSectionsOpen) {
                /* If it's already open leave if; if it needs to be open, do it */
                if (matchesChild) {
                    item.isCollapsed = false;
                }
            }
            else {
                item.isCollapsed = !matchesChild;
            }
            /** @type {?} */
            const hasNameMatch = ((state.name === item.sref) || (state.parent === item.sref));
            /** @type {?} */
            const hasParamMatch = isMatch(params, item.srefParams || {});
            item.isActive = matchesChild
                || (hasNameMatch && hasParamMatch);
            matched = matched || item.isActive;
            return matched;
        }), false);
    }
    /**
     * @param {?} navData
     * @return {?}
     */
    closeAll(navData) {
        forEach(navData, (/**
         * @param {?} item
         * @return {?}
         */
        (item) => {
            item.isCollapsed = true;
            if (navData.children) {
                this.closeAll(navData.children);
            }
        }));
    }
}
LeftnavComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-left-nav',
                template: `
  <dx-scroll-view>
  <nav class="leftnav" role="navigation">
  <ul class="nwf-leftnav-items p-0 m-0">
      <li class="nwf-leftnav-item d-block" *ngFor="let item of navData | keyvalue" nwfLeftnavItem isTopLevel="true" [item]="item.value" attr.data-netapp-id="leftnav-item-{{item.value.label | lowercase}}"></li>
  </ul>
  </nav>
  </dx-scroll-view>
  `,
                styles: ["nav.leftnav{display:flex;flex-direction:column;font-size:90%;top:0;padding-top:25px;overflow-x:hidden;overflow-y:auto;position:-webkit-sticky;position:sticky}"]
            }] }
];
/** @nocollapse */
LeftnavComponent.ctorParameters = () => [
    { type: NwfLeftnavService },
    { type: TransitionService },
    { type: StateService }
];
LeftnavComponent.propDecorators = {
    navData: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LeftnavComponent.prototype.navData;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.keepOtherSectionsOpen;
    /** @type {?} */
    LeftnavComponent.prototype.leftnavService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGVmdG5hdi5jb21wb25lbnQuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AbmV0YXBwL253ZmpzX2FuZ3VsYXJfY29tcG9uZW50cy8iLCJzb3VyY2VzIjpbImxpYi9zaGVsbC9sZWZ0bmF2L2xlZnRuYXYuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBVSxNQUFNLGVBQWUsQ0FBQztBQUN6RCxPQUFPLEVBQW9CLFlBQVksRUFBYyxpQkFBaUIsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQy9GLE9BQU8sRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sRUFBRSxNQUFNLFdBQVcsQ0FBQztBQUNyRCxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQWdCdEQsTUFBTSxPQUFPLGdCQUFnQjs7Ozs7O0lBSzNCLFlBQW1CLGNBQWlDLEVBQVUsaUJBQW9DLEVBQVUsWUFBMEI7UUFBbkgsbUJBQWMsR0FBZCxjQUFjLENBQW1CO1FBQVUsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQUFVLGlCQUFZLEdBQVosWUFBWSxDQUFjO1FBRjlILDBCQUFxQixHQUFHLElBQUksQ0FBQztJQUVxRyxDQUFDOzs7O0lBRXBJLHFCQUFxQjtjQUNwQixFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsR0FBRyxJQUFJLENBQUMsWUFBWTtRQUM3QyxVQUFVOzs7UUFBQyxHQUFHLEVBQUUsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ2hGLENBQUM7Ozs7SUFFTSxRQUFRO1FBRWIsZ0hBQWdIO1FBQ2hILElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFFM0Msc0RBQXNEO1FBQ3RELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLENBQUMsRUFBRTs7OztRQUFFLENBQUMsS0FBaUIsRUFBRSxFQUFFO1lBQ3pELElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO1FBQy9CLENBQUMsRUFBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDNUIsbURBQW1EO1FBQ25ELElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO0lBQy9CLENBQUM7Ozs7Ozs7Ozs7Ozs7SUFRTSxlQUFlLENBQUMsT0FBTyxFQUFFLEtBQXVCLEVBQUUsTUFBTSxHQUFHLElBQUk7UUFFcEUsT0FBTyxNQUFNLENBQUMsT0FBTzs7Ozs7UUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsRUFBRTs7Z0JBQ25DLFlBQVksR0FBRyxLQUFLO1lBRXhCLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtnQkFDakIsWUFBWSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUM7YUFDbkU7WUFFRCxJQUFJLElBQUksQ0FBQyxxQkFBcUIsRUFBRTtnQkFDOUIsa0VBQWtFO2dCQUNsRSxJQUFJLFlBQVksRUFBRTtvQkFDaEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7aUJBQzFCO2FBQ0Y7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLFdBQVcsR0FBRyxDQUFDLFlBQVksQ0FBQzthQUNsQzs7a0JBRUssWUFBWSxHQUFHLENBQUMsQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEtBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDOztrQkFDM0UsYUFBYSxHQUFHLE9BQU8sQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUM7WUFDNUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxZQUFZO21CQUN2QixDQUFDLFlBQVksSUFBSSxhQUFhLENBQUMsQ0FBQztZQUVyQyxPQUFPLEdBQUcsT0FBTyxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDbkMsT0FBTyxPQUFPLENBQUM7UUFDakIsQ0FBQyxHQUFFLEtBQUssQ0FBQyxDQUFDO0lBQ1osQ0FBQzs7Ozs7SUFFTSxRQUFRLENBQUMsT0FBWTtRQUMxQixPQUFPLENBQUMsT0FBTzs7OztRQUFFLENBQUMsSUFBSSxFQUFFLEVBQUU7WUFDeEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7WUFDeEIsSUFBSSxPQUFPLENBQUMsUUFBUSxFQUFFO2dCQUNwQixJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQzthQUNqQztRQUNILENBQUMsRUFBQyxDQUFDO0lBQ0wsQ0FBQzs7O1lBbEZGLFNBQVMsU0FBQztnQkFDVCxRQUFRLEVBQUUsY0FBYztnQkFDeEIsUUFBUSxFQUFFOzs7Ozs7OztHQVFUOzthQUdGOzs7O1lBZlEsaUJBQWlCO1lBRjJCLGlCQUFpQjtZQUEzQyxZQUFZOzs7c0JBbUJwQyxLQUFLOzs7O0lBQU4sbUNBQTZCOzs7OztJQUU3QixpREFBcUM7O0lBRXpCLDBDQUF3Qzs7Ozs7SUFBRSw2Q0FBNEM7Ozs7O0lBQUUsd0NBQWtDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBJbnB1dCwgT25Jbml0IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBTdGF0ZURlY2xhcmF0aW9uLCBTdGF0ZVNlcnZpY2UsIFRyYW5zaXRpb24sIFRyYW5zaXRpb25TZXJ2aWNlIH0gZnJvbSAnQHVpcm91dGVyL2NvcmUnO1xuaW1wb3J0IHsgZm9yRWFjaCwgaXNNYXRjaCwgcmVkdWNlIH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IE53ZkxlZnRuYXZTZXJ2aWNlIH0gZnJvbSAnLi9sZWZ0bmF2LnNlcnZpY2UnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdud2YtbGVmdC1uYXYnLFxuICB0ZW1wbGF0ZTogYFxuICA8ZHgtc2Nyb2xsLXZpZXc+XG4gIDxuYXYgY2xhc3M9XCJsZWZ0bmF2XCIgcm9sZT1cIm5hdmlnYXRpb25cIj5cbiAgPHVsIGNsYXNzPVwibndmLWxlZnRuYXYtaXRlbXMgcC0wIG0tMFwiPlxuICAgICAgPGxpIGNsYXNzPVwibndmLWxlZnRuYXYtaXRlbSBkLWJsb2NrXCIgKm5nRm9yPVwibGV0IGl0ZW0gb2YgbmF2RGF0YSB8IGtleXZhbHVlXCIgbndmTGVmdG5hdkl0ZW0gaXNUb3BMZXZlbD1cInRydWVcIiBbaXRlbV09XCJpdGVtLnZhbHVlXCIgYXR0ci5kYXRhLW5ldGFwcC1pZD1cImxlZnRuYXYtaXRlbS17e2l0ZW0udmFsdWUubGFiZWwgfCBsb3dlcmNhc2V9fVwiPjwvbGk+XG4gIDwvdWw+XG4gIDwvbmF2PlxuICA8L2R4LXNjcm9sbC12aWV3PlxuICBgLFxuICBzdHlsZVVybHM6IFsnLi9sZWZ0bmF2LnNjc3MnXSxcblxufSlcbmV4cG9ydCBjbGFzcyBMZWZ0bmF2Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcbiAgQElucHV0KCkgcHVibGljIG5hdkRhdGE6IGFueTtcblxuICBwcml2YXRlIGtlZXBPdGhlclNlY3Rpb25zT3BlbiA9IHRydWU7XG5cbiAgY29uc3RydWN0b3IocHVibGljIGxlZnRuYXZTZXJ2aWNlOiBOd2ZMZWZ0bmF2U2VydmljZSwgcHJpdmF0ZSB0cmFuc2l0aW9uU2VydmljZTogVHJhbnNpdGlvblNlcnZpY2UsIHByaXZhdGUgc3RhdGVTZXJ2aWNlOiBTdGF0ZVNlcnZpY2UpIHsgfVxuXG4gIHB1YmxpYyByZXBhaW50U3RhdGVIaWdobGlnaHQoKSB7XG4gICAgY29uc3QgeyBjdXJyZW50LCBwYXJhbXMgfSA9IHRoaXMuc3RhdGVTZXJ2aWNlO1xuICAgIHNldFRpbWVvdXQoKCkgPT4geyB0aGlzLm1hcmtBY3RpdmVTdGF0ZSh0aGlzLm5hdkRhdGEsIGN1cnJlbnQsIHBhcmFtcyk7IH0sIDApO1xuICB9XG5cbiAgcHVibGljIG5nT25Jbml0KCkge1xuXG4gICAgLy8gU2V0IG15IG5hdkRhdGEgb24gdGhlIGxlZnRuYXZTZXJ2aWNlIHNvIG90aGVycyAobGlrZSBmZWF0dXJlIHRvdXIgKSBjYW4gb3BlbiBhIHRyZWUgb2YgaXRlbXMgcHJvZ3JhbWF0aWNhbGx5LlxuICAgIHRoaXMubGVmdG5hdlNlcnZpY2UubmF2RGF0YSA9IHRoaXMubmF2RGF0YTtcblxuICAgIC8qIE9uIEVudGVyIEkgcmVjdXJzZSB0byBmaW5kIG91dCB3aGF0IHRvIGhpZ2hsaWdodCAqL1xuICAgIHRoaXMudHJhbnNpdGlvblNlcnZpY2Uub25TdWNjZXNzKHt9LCAodHJhbnM6IFRyYW5zaXRpb24pID0+IHtcbiAgICAgIHRoaXMucmVwYWludFN0YXRlSGlnaGxpZ2h0KCk7XG4gICAgfSk7XG5cbiAgICB0aGlzLmNsb3NlQWxsKHRoaXMubmF2RGF0YSk7XG4gICAgLyogSSBoYXZlIHRvIGZpbmQgb3V0IG9uIGxvYWQgd2hlcmUgSSBhbSBhcyB3ZWxsICovXG4gICAgdGhpcy5yZXBhaW50U3RhdGVIaWdobGlnaHQoKTtcbiAgfVxuXG4gIC8qXG4gICAqIFJlY3Vyc2UgdGhyb3VnaCB0aGUgbmF2RGF0YSwgbWFya2luZyB0aGUgYWN0aXZlIHN0YXRlLCBhbmRcbiAgICogYWxsIGl0cyBwYXJlbnRzLiBSZXR1cm4gdHJ1ZSBpZiB3ZSBmb3VuZCBhIG1hdGNoLlxuICAgKiBBbiBpdGVtIGlzIGFjdGl2ZSBpZiBpdCdzIG5hbWUgYW5kIHBhcmFtcyBtYXRjaGVzXG4gICAqIEFuIGl0ZW0gaXMgYWxzbyBhY3RpdmUgaWYgYW55IG9mIGl0J3MgY2hpbGQgaXMgYWN0aXZlLlxuICAgKi9cbiAgcHVibGljIG1hcmtBY3RpdmVTdGF0ZShuYXZEYXRhLCBzdGF0ZTogU3RhdGVEZWNsYXJhdGlvbiwgcGFyYW1zID0gbnVsbCk6IGJvb2xlYW4ge1xuXG4gICAgcmV0dXJuIHJlZHVjZShuYXZEYXRhLCAobWF0Y2hlZCwgaXRlbSkgPT4ge1xuICAgICAgbGV0IG1hdGNoZXNDaGlsZCA9IGZhbHNlO1xuXG4gICAgICBpZiAoaXRlbS5jaGlsZHJlbikge1xuICAgICAgICBtYXRjaGVzQ2hpbGQgPSB0aGlzLm1hcmtBY3RpdmVTdGF0ZShpdGVtLmNoaWxkcmVuLCBzdGF0ZSwgcGFyYW1zKTtcbiAgICAgIH1cblxuICAgICAgaWYgKHRoaXMua2VlcE90aGVyU2VjdGlvbnNPcGVuKSB7XG4gICAgICAgIC8qIElmIGl0J3MgYWxyZWFkeSBvcGVuIGxlYXZlIGlmOyBpZiBpdCBuZWVkcyB0byBiZSBvcGVuLCBkbyBpdCAqL1xuICAgICAgICBpZiAobWF0Y2hlc0NoaWxkKSB7XG4gICAgICAgICAgaXRlbS5pc0NvbGxhcHNlZCA9IGZhbHNlO1xuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBpdGVtLmlzQ29sbGFwc2VkID0gIW1hdGNoZXNDaGlsZDtcbiAgICAgIH1cblxuICAgICAgY29uc3QgaGFzTmFtZU1hdGNoID0gKChzdGF0ZS5uYW1lID09PSBpdGVtLnNyZWYpIHx8IChzdGF0ZS5wYXJlbnQgPT09IGl0ZW0uc3JlZikpO1xuICAgICAgY29uc3QgaGFzUGFyYW1NYXRjaCA9IGlzTWF0Y2gocGFyYW1zLCBpdGVtLnNyZWZQYXJhbXMgfHwge30pO1xuICAgICAgaXRlbS5pc0FjdGl2ZSA9IG1hdGNoZXNDaGlsZFxuICAgICAgICB8fCAoaGFzTmFtZU1hdGNoICYmIGhhc1BhcmFtTWF0Y2gpO1xuXG4gICAgICBtYXRjaGVkID0gbWF0Y2hlZCB8fCBpdGVtLmlzQWN0aXZlO1xuICAgICAgcmV0dXJuIG1hdGNoZWQ7XG4gICAgfSwgZmFsc2UpO1xuICB9XG5cbiAgcHVibGljIGNsb3NlQWxsKG5hdkRhdGE6IGFueSkge1xuICAgIGZvckVhY2gobmF2RGF0YSwgKGl0ZW0pID0+IHtcbiAgICAgIGl0ZW0uaXNDb2xsYXBzZWQgPSB0cnVlO1xuICAgICAgaWYgKG5hdkRhdGEuY2hpbGRyZW4pIHtcbiAgICAgICAgdGhpcy5jbG9zZUFsbChuYXZEYXRhLmNoaWxkcmVuKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfVxuXG59XG4iXX0=