/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import * as i0 from "@angular/core";
export class NwfLeftnavService {
    constructor() {
        this.navData = [];
        this.leftnavIsCollapsed = false;
        this.leftNav = new Subject();
        this.leftNav$ = this.leftNav.asObservable();
    }
    /**
     * @return {?}
     */
    toggle() {
        this.leftnavIsCollapsed = !this.leftnavIsCollapsed;
        this.leftNav.next(this.leftnavIsCollapsed);
    }
    /* This is used in the feature tour */
    /**
     * @param {?} callback
     * @return {?}
     */
    recurseNavData(callback) {
        /**
         * @param {?} currentNode
         * @return {?}
         */
        function recurse(currentNode) {
            if (currentNode.children) {
                for (let child of currentNode.children) {
                    recurse(child);
                }
                callback(currentNode);
            }
        }
        for (let data of this.navData) {
            recurse(data);
        }
    }
}
NwfLeftnavService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root',
            },] }
];
/** @nocollapse */
NwfLeftnavService.ctorParameters = () => [];
/** @nocollapse */ NwfLeftnavService.ngInjectableDef = i0.defineInjectable({ factory: function NwfLeftnavService_Factory() { return new NwfLeftnavService(); }, token: NwfLeftnavService, providedIn: "root" });
if (false) {
    /** @type {?} */
    NwfLeftnavService.prototype.navData;
    /** @type {?} */
    NwfLeftnavService.prototype.leftnavIsCollapsed;
    /** @type {?} */
    NwfLeftnavService.prototype.leftNav;
    /** @type {?} */
    NwfLeftnavService.prototype.leftNav$;
}
//# sourceMappingURL=data:application/json;base64,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