/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
export class LoginFailedComponent {
    /**
     * @param {?} activeModal
     */
    constructor(activeModal) {
        this.activeModal = activeModal;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
LoginFailedComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-login-failed',
                template: `
  <div class="modal-content">
  <div class="modal-header is-error">
      <nwf-icon *ngIf="errorCode !== 0" iconClass="icon-status-warning"></nwf-icon>
      <nwf-icon *ngIf="errorCode === 0" iconClass="icon-status-error-full"></nwf-icon>
      <h5 class="modal-title" data-netapp-id="loginPage-errorDialog-title">{{'nwfjs:error' | i18next}}</h5>
  </div>
  <div class="modal-body" data-netapp-id="loginPage-errorDialog-msg">
      <p *ngIf="errorCode !== 0">{{'nwfjs:loginFailedAuthenticationFailed' | i18next}}</p>
      <p *ngIf="errorCode === 0">{{'nwfjs:loginFailedUnableAccessServer' | i18next}}</p>
  </div>
  <div class="modal-footer">
      <button class="btn btn-primary" (click)="activeModal.close()" data-netapp-id="loginPage-erroDialog-ok-button" autofocus>{{'nwfjs:OK' | i18next}}</button>
  </div>
</div>
  `
            }] }
];
/** @nocollapse */
LoginFailedComponent.ctorParameters = () => [
    { type: NgbActiveModal }
];
LoginFailedComponent.propDecorators = {
    errorCode: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LoginFailedComponent.prototype.errorCode;
    /** @type {?} */
    LoginFailedComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9naW4tZmFpbGVkLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL3NoZWxsL2xvZ2luL2xvZ2luLWZhaWxlZC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQ3pELE9BQU8sRUFBRSxjQUFjLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQXNCNUQsTUFBTSxPQUFPLG9CQUFvQjs7OztJQUkvQixZQUFtQixXQUEyQjtRQUEzQixnQkFBVyxHQUFYLFdBQVcsQ0FBZ0I7SUFBSSxDQUFDOzs7O0lBRTVDLFFBQVE7SUFDZixDQUFDOzs7WUEzQkYsU0FBUyxTQUFDO2dCQUNULFFBQVEsRUFBRSxrQkFBa0I7Z0JBQzVCLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7O0dBZVQ7YUFFRjs7OztZQXJCUSxjQUFjOzs7d0JBd0JwQixLQUFLOzs7O0lBQU4seUNBQWtDOztJQUV0QiwyQ0FBa0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE5nYkFjdGl2ZU1vZGFsIH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdud2YtbG9naW4tZmFpbGVkJyxcbiAgdGVtcGxhdGU6IGBcbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWNvbnRlbnRcIj5cbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWhlYWRlciBpcy1lcnJvclwiPlxuICAgICAgPG53Zi1pY29uICpuZ0lmPVwiZXJyb3JDb2RlICE9PSAwXCIgaWNvbkNsYXNzPVwiaWNvbi1zdGF0dXMtd2FybmluZ1wiPjwvbndmLWljb24+XG4gICAgICA8bndmLWljb24gKm5nSWY9XCJlcnJvckNvZGUgPT09IDBcIiBpY29uQ2xhc3M9XCJpY29uLXN0YXR1cy1lcnJvci1mdWxsXCI+PC9ud2YtaWNvbj5cbiAgICAgIDxoNSBjbGFzcz1cIm1vZGFsLXRpdGxlXCIgZGF0YS1uZXRhcHAtaWQ9XCJsb2dpblBhZ2UtZXJyb3JEaWFsb2ctdGl0bGVcIj57eydud2ZqczplcnJvcicgfCBpMThuZXh0fX08L2g1PlxuICA8L2Rpdj5cbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWJvZHlcIiBkYXRhLW5ldGFwcC1pZD1cImxvZ2luUGFnZS1lcnJvckRpYWxvZy1tc2dcIj5cbiAgICAgIDxwICpuZ0lmPVwiZXJyb3JDb2RlICE9PSAwXCI+e3snbndmanM6bG9naW5GYWlsZWRBdXRoZW50aWNhdGlvbkZhaWxlZCcgfCBpMThuZXh0fX08L3A+XG4gICAgICA8cCAqbmdJZj1cImVycm9yQ29kZSA9PT0gMFwiPnt7J253ZmpzOmxvZ2luRmFpbGVkVW5hYmxlQWNjZXNzU2VydmVyJyB8IGkxOG5leHR9fTwvcD5cbiAgPC9kaXY+XG4gIDxkaXYgY2xhc3M9XCJtb2RhbC1mb290ZXJcIj5cbiAgICAgIDxidXR0b24gY2xhc3M9XCJidG4gYnRuLXByaW1hcnlcIiAoY2xpY2spPVwiYWN0aXZlTW9kYWwuY2xvc2UoKVwiIGRhdGEtbmV0YXBwLWlkPVwibG9naW5QYWdlLWVycm9EaWFsb2ctb2stYnV0dG9uXCIgYXV0b2ZvY3VzPnt7J253ZmpzOk9LJyB8IGkxOG5leHR9fTwvYnV0dG9uPlxuICA8L2Rpdj5cbjwvZGl2PlxuICBgLFxuICBzdHlsZXM6IFtdLFxufSlcbmV4cG9ydCBjbGFzcyBMb2dpbkZhaWxlZENvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XG5cbiAgQElucHV0KCkgcHVibGljIGVycm9yQ29kZTogbnVtYmVyO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBhY3RpdmVNb2RhbDogTmdiQWN0aXZlTW9kYWwpIHsgfVxuXG4gIHB1YmxpYyBuZ09uSW5pdCgpIHtcbiAgfVxuXG59XG4iXX0=