/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Inject, Input } from '@angular/core';
import { StateService, TargetState } from '@uirouter/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { repeat } from 'lodash-es';
import { interval } from 'rxjs';
import { map } from 'rxjs/operators';
import { NwfTitleService } from '../title/title.service';
import { LoginFailedComponent } from './login-failed.component';
export class LoginComponent {
    /**
     * @param {?} NwfAuthService
     * @param {?} $state
     * @param {?} modalService
     * @param {?} titleService
     */
    constructor(NwfAuthService, $state, modalService, titleService) {
        this.NwfAuthService = NwfAuthService;
        this.$state = $state;
        this.modalService = modalService;
        this.titleService = titleService;
        this.showHelp = true;
        this.isOemVendor = false;
        this.titleElement = null;
        this.username = null;
        this.password = null;
        // Forgot Password is off by default and enabled when I have provided it
        this.hasForgotPassword = false;
        this.hasResetPassword = false;
        this.forgotPasswordMode = false;
        // Reset Password
        this.resetPasswordMode = false;
        this.authToken = null;
        this.resetPasswordMatch = true;
        this.cnter = 0;
        this.loadingObs = interval(1000).pipe(map((/**
         * @param {?} value
         * @return {?}
         */
        (value) => {
            this.cnter++;
            if (this.cnter > 3) {
                this.cnter = 0;
            }
            return repeat('.', this.cnter);
        })));
        this.creds = { username: '', password: '' };
        this.resetCreds = { username: '', newPassword: '', confirmNewPassword: '', authToken: '' };
        this.forgotCreds = { username: '' };
        /* I detect the presence of a forgotPassword and resetPassword methods in the strategy */
        if (NwfAuthService.forgotPassword) {
            this.hasForgotPassword = true;
        }
        if (NwfAuthService.resetPassword) {
            this.hasResetPassword = true;
        }
        this.titleService.setTitle('nwfjs:login');
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        // If the server sends a user and authToken, the only use case we have is that user has send a request to reset the password with this URL.
        // Set the boolean to reset password to be true.
        /** @type {?} */
        const search = document.location.search;
        if (this.hasResetPassword && search) {
            /** @type {?} */
            const split = search.split('?');
            /** @type {?} */
            const $stateParams = split[split.length - 1].split('&');
            /** @type {?} */
            const stateParams = {};
            $stateParams.forEach((/**
             * @param {?} item
             * @return {?}
             */
            function (item) {
                /** @type {?} */
                const pair = item.split('=');
                stateParams[pair[0]] = pair[1];
            }));
            if (stateParams.user !== undefined && stateParams.authToken !== undefined) {
                this.username = stateParams.user;
                this.resetPasswordMode = true;
                this.forgotPasswordMode = false;
                this.authToken = stateParams.authToken;
            }
        }
        this.updateHrefs();
    }
    /**
     * @return {?}
     */
    authenticate() {
        this.inFlight = true;
        /** @type {?} */
        const returnToOriginalState = (/**
         * @return {?}
         */
        () => {
            /** @type {?} */
            const state = this.returnTo.state();
            /** @type {?} */
            const params = this.returnTo.params();
            /** @type {?} */
            const options = Object.assign({}, this.returnTo.options(), { reload: true });
            this.$state.go(state, params, options);
        });
        /** @type {?} */
        const showError = (/**
         * @param {?} error
         * @return {?}
         */
        (error) => {
            /** @type {?} */
            const errorCode = error.status;
            this.inFlight = false;
            /** @type {?} */
            const failedMdl = this.modalService.open(LoginFailedComponent);
            failedMdl.componentInstance.errorCode = errorCode;
        });
        /** @type {?} */
        const stop = (/**
         * @return {?}
         */
        () => this.inFlight = false);
        const { username, password } = this.creds;
        this.NwfAuthService.authenticate(username, password)
            .then(returnToOriginalState)
            .catch(showError)
            .then(stop, stop);
    }
    /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    updateHrefs() {
        /** @type {?} */
        const netappHome = 'http://netapp.com';
        if (!this.homeHref) {
            this.homeHref = netappHome;
        }
        if (!this.supportHref) {
            this.supportHref = 'http://mysupport.netapp.com';
        }
        this.isOemVendor = false;
        if (this.homeHref !== netappHome) {
            this.isOemVendor = true;
        }
    }
    // forgot password on submit.
    /**
     * @return {?}
     */
    forgotPasswordSubmit() {
        /* @todo KM forgotCreds
                return this.authStrategy.forgotPasswordAuthenticateFn(credentials).then(() => {
                    var forgotPasswordToggle = this.$uibModal.open({
                        template: loginForgotPasswordTemplate,
                        controller: ['$scope', 'forgotPasswordName', function ($scope, forgotPasswordName) {
                            $scope.username = forgotPasswordName;
                        }],
                        resolve: {
                            forgotPasswordName: function () {
                                return credentials.username;
                            }
                        }
                    });

                    //Once done do back to the Login form.
                    forgotPasswordToggle.result.then(() => {
                        this.forgotPasswordToggleFn();
                    });
                });
                */
    }
    // Reset password on submit.
    /**
     * @return {?}
     */
    resetPasswordSubmit() {
        // Check if passwords match
        this.resetPasswordMatch = true;
        if (this.resetCreds.newPassword !== this.resetCreds.confirmNewPassword) {
            this.resetPasswordMatch = false;
            return;
        }
        /* wenow haave this.resetCreds.
            var data = {
                user: this.username,
                newPassword: this.newPassword,
                confirmNewPassword: this.confirmNewPassword,
                authToken: this.authToken
            };

            // Controller used by reset password modal instance on success. The user is redirected to login page.
            this.resetPasswordSuccessController = ['$scope', '$uibModalInstance',
                function ($scope, $uibModalInstance) {
                    $scope.ok = function () {
                        $uibModalInstance.close();
                        window.location.href = '/';
                    };
                }
            ];
    */
        /*
        return this.authStrategy.resetPasswordFn(data).then(() => {
            this.message = this.$i18next.t("nwfjs:resetPasswordSucceed");
            this.success = true;

            //Show the modal with success message from the server.
            this.$uibModal.open({
                template: loginResetPasswordResultTemplate,
                scope: this,
                controller: this.resetPasswordSuccessController
            });
        }).catch(function (error) {
            this.message = this.$i18next.t("nwfjs:resetPasswordFailed");
            if (error != null) {
                this.message = error.message;
            }
            this.success = false;
            //Show the  modal with failure message from the server.

            this.$uibModal.open({
                template: loginResetPasswordResultTemplate,
                scope: this,
                controller: this.loginFailedController
            });
        });
        */
    }
    // Reset password on cancel.
    /**
     * @return {?}
     */
    resetPasswordCancelFn() {
        window.location.href = document.location.origin;
    }
}
LoginComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-login',
                template: `
    <div class="nwf-login-overlay">
    <div class="nwf-login-dialog">
    <header class="nwf-login-banner-logo"></header>
    <div class="nwf-login-body">
        <h2 class="nwf-login-dialog-title-primary">{{appTitle}}</h2>
        <h3 class="nwf-login-dialog-title-secondary"></h3>
        <h5>{{message}}</h5>
        <!-- Login form -->
        <form #authForm="ngForm" (ngSubmit)="authForm.valid && authenticate()" *ngIf="!forgotPasswordMode && !resetPasswordMode"
            id="nwf-login-form" class="nwf-validatable" [ngClass]="{'ng-submitted': authForm.submitted }">
            <div class="form-group l-username">
                    <input class="nwf-login-input form-control form-control-lg" name="username" #username="ngModel" [(ngModel)]="creds.username"
                        data-netapp-id="loginPage-username-input" autocomplete="off" autofocus required placeholder="{{'nwfjs:username' | i18next}}">
                    <div *ngIf="username.invalid && (authForm.submitted || username.touched)" class="invalid-feedback">
                        {{ 'nwfjs:emptyMessage' | i18next}}
                    </div>
            </div>
            <div class="form-group">
                    <input class="nwf-login-input form-control form-control-lg" type="password" name="password" #password="ngModel" [(ngModel)]="creds.password"
                        data-netapp-id="loginPage-password-input" autocomplete="off" placeholder="{{'nwfjs:password' | i18next}}"
                        required>
                    <div *ngIf="password.invalid && (authForm.submitted || password.touched)" class="invalid-feedback">
                        {{ 'nwfjs:emptyMessage' | i18next}}
                    </div>
            </div>
            <div class="form-group l-submit-btn mb-0">
                <button type="submit" class="nwf-login-input nwf-login-submit btn btn-primary btn-lg"
                    data-netapp-id="loginPage-signIn-button">
                    <div>{{'nwfjs:signIn' | i18next}} <span class="loading position-absolute" [hidden]="!inFlight">{{loadingObs | async}}</span></div>
                </button>
            </div>
            <p *ngIf="hasForgotPassword" class="nwf-login-forgot">
                <a class="nwf-is-link-like" (click)="this.forgotPasswordMode = !this.forgotPasswordMode" data-netapp-id="loginPage-forgot-password-link">{{'nwfjs:forgetPassword' | i18next}}</a>
            </p>
        </form>

        <!-- Forgot Password Form -->
        <form #forgotFrm="ngForm" class="nwf-validatable" *ngIf="forgotPasswordMode" (ngSubmit)="forgotFrm.valid && forgotPasswordSubmit()" [ngClass]="{'ng-submitted': forgotFrm.submitted }">

            <div class="nwf-forgot-password-title-panel">
                <div class="nwf-forgot-password-text" data-netapp-id="loginPage-forgot-password-text">
                    <h4>{{'nwfjs:enterResetUsername' | i18next}}</h4>
                </div>
            </div>
            <div class="form-group">
                    <input class="nwf-login-input form-control form-control-lg" name="username" #username="ngModel" [(ngModel)]="forgotCreds.username"
                        data-netapp-id="loginPage-username-input" autocomplete="off" placeholder="{{'nwfjs:usernameToReset' | i18next}}"
                        required>
                    <div *ngIf="username.invalid && (forgotFrm.submitted || username.touched)" class="invalid-feedback">
                        {{ 'nwfjs:emptyMessage' | i18next }}
                    </div>
            </div>
            <div class="form-group">
            <!-- Submit/Cancel for Forgot Password  -->
            <div class="nwf-login-row">
                <div class="nwf-login-button-panel">
                    <button class="btn btn-primary mr-2" data-netapp-id="forgotPassword-submit-button">{{'nwfjs:submit' | i18next}}</button>
                    <button class="btn btn-secondary" (click)="forgotPasswordMode = false" data-netapp-id="forgotPassword-cancel-button" type="button">{{'nwfjs:cancel' | i18next}}</button>
                </div>
            </div>
            </div>
        </form>

        <!-- Reset password Form -->
        <form #resetFrm="ngForm"  *ngIf="resetPasswordMode" (ngSubmit)="resetFrm.valid && resetPasswordSubmit()" [ngClass]="{'ng-submitted': resetFrm.submitted }">

            <dl>
                <dt>{{'nwfjs:currentUsername' | i18next}}</dt>
                <dd>
                    <input class="nwf-login-input form-control form-control-lg" name="username" #username="ngModel" autocomplete="off" [(ngModel)]="resetCreds.username"
                        data-netapp-id="loginPage-username-input" title="{{'nwfjs:usernameCannotChange' | i18next}}" required>
                    <div *ngIf="username.invalid && (resetFrm.submitted || username.touched)" class="invalid-feedback">
                        {{ 'nwfjs:emptyMessage' | i18next }}
                    </div>
                </dd>
                <dt>{{'nwfjs:newPassword' | i18next}}</dt>
                <dd>
                    <input class="nwf-login-input form-control form-control-lg" autocomplete="off" name="newPassword" #newPassword="ngModel"
                        type="password" [(ngModel)]="resetCreds.newPassword" data-netapp-id="loginPage-new-password-input" placeholder="{{'nwfjs:typeNewPassword' | i18next}}" required>
                    <div *ngIf="newPassword.invalid && (resetFrm.submitted || newPassword.touched)" class="invalid-feedback">
                        {{ 'nwfjs:emptyMessage' | i18next }}
                    </div>
                </dd>
                <dt>{{'nwfjs:confirmNewPassword' | i18next}}</dt>
                <dd>
                    <input class="nwf-login-input form-control form-control-lg" autocomplete="off" name="confirmNewPassword" #confirmNewPassword="ngModel"
                        type="password" [(ngModel)]="resetCreds.confirmNewPassword" name="confirmNewPassword" data-netapp-id="loginPage-confirm-new-password-input"
                        placeholder="{{'nwfjs:typeNewPasswordAgain' | i18next}}" required>
                    <div *ngIf="confirmNewPassword.invalid && (resetFrm.submitted || confirmNewPassword.touched)" class="invalid-feedback">
                        {{ 'nwfjs:emptyMessage' | i18next }}
                    </div>
                    <div *ngIf="!resetPasswordMatch" class="invalid-feedback">
                        {{'nwfjs:changePasswordNotMatch' | i18next}}
                    </div>
                </dd>
            </dl>

            <div class="nwf-login-button-panel">
                <button class="btn btn-primary mr-2" data-netapp-id="resetPassword-submit-button">{{'nwfjs:submit' | i18next}}</button>
                <button class="btn btn-secondary" data-netapp-id="resetPassword-cancel-button" (click)="resetPasswordCancelFn()" type="button">{{'nwfjs:cancel' | i18next}}</button>
            </div>
        </form>
    </div>
    <footer class="nwf-login-links">
        <!-- support -->
        <a *ngIf="!isOemVendor" [href]="supportHref" target="_blank">{{'nwfjs:netappSupport' | i18next}}</a>
        <a *ngIf="isOemVendor" [href]="supportHref" target="_blank">{{supportLabel}}</a> |
        <!-- help -->
        <span *ngIf=""><a nwf-help showIcon="false" class="nwf-is-link-like">{{'nwfjs:help' | i18next}}</a> |</span>
        <!-- home -->
        <a *ngIf="!isOemVendor" href="http://netapp.com" target="_blank">{{'nwfjs:netapp' | i18next}}</a>
        <a *ngIf="isOemVendor" [href]="homeHref" target="_blank">{{homeLabel}}</a>
    </footer>
    </div>
</div>
    `,
                styles: ["nwf-login{width:100%;height:100%;top:0;background-repeat:no-repeat;background-size:cover;display:flex;justify-content:center;align-items:flex-start}.nwf-login-dialog{padding:40px 40px 25px}.l-username{margin-top:2rem}.l-submit-btn{margin-top:2.5rem}h2{font-size:26px;color:#131313}#nwf-login-form[ng-reflect-klass]{margin-top:20px}#nwf-login-form[ng-reflect-klass] dd{margin-bottom:1.2rem}.nwf-login-submit{position:relative}.nwf-login-banner-logo{background-image:url(data:image/png;base64,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);width:100%;background-repeat:no-repeat;height:24px;align-self:flex-start;margin-bottom:10px}.nwf-login-dialog-title-primary{font-size:24px;margin-top:0;margin-bottom:10px}.nwf-login-input{width:100%;margin:5px 0}.nwf-login-forgot{margin:5px 0;align-self:flex-end}.nwf-login-links{margin-top:10px;text-align:center}.nwf-login-overlay{width:100%;position:fixed;left:0;top:0;z-index:1049;height:100%}.nwf-login-button-panel{display:block;text-align:right}"]
            }] }
];
/** @nocollapse */
LoginComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
    { type: StateService },
    { type: NgbModal },
    { type: NwfTitleService }
];
LoginComponent.propDecorators = {
    returnTo: [{ type: Input }],
    appTitle: [{ type: Input }],
    supportHref: [{ type: Input }],
    supportLabel: [{ type: Input }],
    helpHref: [{ type: Input }],
    helpLabel: [{ type: Input }],
    homeHref: [{ type: Input }],
    homeLabel: [{ type: Input }],
    showHelp: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LoginComponent.prototype.returnTo;
    /** @type {?} */
    LoginComponent.prototype.appTitle;
    /** @type {?} */
    LoginComponent.prototype.supportHref;
    /** @type {?} */
    LoginComponent.prototype.supportLabel;
    /** @type {?} */
    LoginComponent.prototype.helpHref;
    /** @type {?} */
    LoginComponent.prototype.helpLabel;
    /** @type {?} */
    LoginComponent.prototype.homeHref;
    /** @type {?} */
    LoginComponent.prototype.homeLabel;
    /** @type {?} */
    LoginComponent.prototype.showHelp;
    /** @type {?} */
    LoginComponent.prototype.isOemVendor;
    /** @type {?} */
    LoginComponent.prototype.homeVendorHref;
    /** @type {?} */
    LoginComponent.prototype.titleElement;
    /** @type {?} */
    LoginComponent.prototype.username;
    /** @type {?} */
    LoginComponent.prototype.password;
    /** @type {?} */
    LoginComponent.prototype.hasForgotPassword;
    /** @type {?} */
    LoginComponent.prototype.hasResetPassword;
    /** @type {?} */
    LoginComponent.prototype.forgotPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.newPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmNewPassword;
    /** @type {?} */
    LoginComponent.prototype.message;
    /** @type {?} */
    LoginComponent.prototype.success;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.authToken;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMatch;
    /** @type {?} */
    LoginComponent.prototype.cnter;
    /** @type {?} */
    LoginComponent.prototype.loadingObs;
    /** @type {?} */
    LoginComponent.prototype.errorCode;
    /** @type {?} */
    LoginComponent.prototype.inFlight;
    /** @type {?} */
    LoginComponent.prototype.creds;
    /** @type {?} */
    LoginComponent.prototype.resetCreds;
    /** @type {?} */
    LoginComponent.prototype.forgotCreds;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.titleService;
}
//# sourceMappingURL=data:application/json;base64,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