/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
export class ResetPasswordResultComponent {
    /**
     * @param {?} activeModal
     */
    constructor(activeModal) {
        this.activeModal = activeModal;
        this.isSuccess = true;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
ResetPasswordResultComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-reset-password-result',
                template: `
  <div class="modal-content">
  <div class="modal-header is-info" *ngIf="isSuccess">
      <nwf-icon iconClass="icon-Info"></nwf-icon>
      <h5 class="modal-title" data-netapp-id="loginPage-errorDialog-title">{{'nwfjs:info' | i18next}}</h5>
  </div>

  <div class="modal-header is-error" *ngIf="!isSuccess">
      <nwf-icon iconClass="icon-Warning"></nwf-icon>
      <h5 class="modal-title" data-netapp-id="loginPage-errorDialog-title">{{'nwfjs:error' | i18next}}</h5>
  </div>

  <div class="modal-body" data-netapp-id="resetPassword-server-message">
      <p>{{message}}</p>
  </div>

  <div class="modal-footer">
      <button class="btn btn-primary" (click)="activeModal.close()" data-netapp-id="resetPasswordResponse-dialog-ok-button" autofocus>{{'nwfjs:OK' | i18next}}</button>
  </div>
</div>


  `
            }] }
];
/** @nocollapse */
ResetPasswordResultComponent.ctorParameters = () => [
    { type: NgbActiveModal }
];
ResetPasswordResultComponent.propDecorators = {
    message: [{ type: Input }],
    isSuccess: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    ResetPasswordResultComponent.prototype.message;
    /** @type {?} */
    ResetPasswordResultComponent.prototype.isSuccess;
    /** @type {?} */
    ResetPasswordResultComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,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