/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, HostListener, Inject, Input } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { StateService } from '@uirouter/angular';
import { LogoutFailedComponent } from './logout-failed.component';
export class LogoutComponent {
    /**
     * @param {?} NwfAuthService
     * @param {?} modalService
     * @param {?} $state
     */
    constructor(NwfAuthService, modalService, $state) {
        this.NwfAuthService = NwfAuthService;
        this.modalService = modalService;
        this.$state = $state;
    }
    /**
     * @return {?}
     */
    logout() {
        /** @type {?} */
        const showError = (/**
         * @param {?} error
         * @return {?}
         */
        (error) => {
            /** @type {?} */
            const errorCode = error.status;
            /** @type {?} */
            const failedMdl = this.modalService.open(LogoutFailedComponent);
            failedMdl.componentInstance.errorCode = errorCode;
        });
        /** @type {?} */
        const returnToOriginalState = (/**
         * @return {?}
         */
        () => {
            this.$state.go(this.returnState);
        });
        return this.NwfAuthService.logout().then(returnToOriginalState).catch(showError);
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
LogoutComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-logout',
                host: {
                    'class': 'dropdown-item',
                    'data-netapp-id': 'nav-logOut-link',
                },
                template: `
{{'nwfjs:logout' | i18next}}
  `
            }] }
];
/** @nocollapse */
LogoutComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
    { type: NgbModal },
    { type: StateService }
];
LogoutComponent.propDecorators = {
    returnState: [{ type: Input }],
    logout: [{ type: HostListener, args: ['click',] }]
};
if (false) {
    /** @type {?} */
    LogoutComponent.prototype.returnState;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.$state;
}
//# sourceMappingURL=data:application/json;base64,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