/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NwfLeftnavService } from '../leftnav/leftnav.service';
export class MainbodyComponent {
    /**
     * @param {?} leftnavService
     */
    constructor(leftnavService) {
        this.leftnavService = leftnavService;
        this.top = '53px';
        this.asideWidth = '300px';
        this.leftnavWidth = '200px';
        this.isLeftnavVisible = true;
        this.isAsideVisible = false;
        this.leftnavConfig = null;
    }
    /**
     * @return {?}
     */
    get mainPaddingTop() {
        return parseInt(this.top) + 15 + 'px';
    }
    /**
     * @return {?}
     */
    get mainMarginLeft() {
        /** @type {?} */
        let marginLeft = '0px';
        if (this.isLeftnavVisible) {
            marginLeft = this.leftnavWidth;
        }
        return marginLeft;
    }
    /**
     * @return {?}
     */
    get mainMarginRight() {
        /** @type {?} */
        let marginRight = '0px';
        if (this.isAsideVisible) {
            marginRight = this.asideWidth;
        }
        return marginRight;
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.subscription = this.leftnavService.leftNav$.subscribe((/**
         * @param {?} hideLeftNav
         * @return {?}
         */
        (hideLeftNav) => {
            if (hideLeftNav) {
                this.isLeftnavVisible = false;
            }
            else {
                this.isLeftnavVisible = true;
            }
        }));
    }
}
MainbodyComponent.decorators = [
    { type: Component, args: [{
                template: `
  <div class="l-nwf-mainbody">
        <nav class="nwf-sidebar" [hidden]="!isLeftnavVisible" [ngStyle]="{ paddingTop: top, width: leftnavWidth }">
          <ng-content *ngIf="!leftnavConfig" select="nwf-left-nav"></ng-content>
          <nwf-left-nav *ngIf="leftnavConfig" [navData]="leftnavConfig"></nwf-left-nav>
        </nav>
        <main class="px-4" [ngStyle]="{  marginLeft: mainMarginLeft, marginRight: mainMarginRight, paddingTop: mainPaddingTop }" ui-view></main>
        <aside class="" [hidden]="!isAsideVisible" [ngStyle]="{ paddingTop: top, width: asideWidth }"><ng-content select=".aside"></ng-content></aside>
  </div>
  `,
                selector: 'nwf-mainbody',
                host: {
                    class: 'w-100',
                },
                styles: [".nwf-sidebar{position:fixed;top:0;bottom:0;left:0;z-index:100;background-color:#0a2d6c;box-shadow:3px 0 0 0 rgba(0,0,0,.1)}aside{position:fixed;top:0;bottom:0;right:0;background-color:#0a2d6c}[hidden]{display:none!important}"]
            }] }
];
/** @nocollapse */
MainbodyComponent.ctorParameters = () => [
    { type: NwfLeftnavService }
];
MainbodyComponent.propDecorators = {
    top: [{ type: Input }],
    asideWidth: [{ type: Input }],
    leftnavWidth: [{ type: Input }],
    isLeftnavVisible: [{ type: Input }],
    isAsideVisible: [{ type: Input }],
    leftnavConfig: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    MainbodyComponent.prototype.top;
    /** @type {?} */
    MainbodyComponent.prototype.asideWidth;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavWidth;
    /** @type {?} */
    MainbodyComponent.prototype.isLeftnavVisible;
    /** @type {?} */
    MainbodyComponent.prototype.isAsideVisible;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavConfig;
    /** @type {?} */
    MainbodyComponent.prototype.subscription;
    /** @type {?} */
    MainbodyComponent.prototype.leftnavService;
}
//# sourceMappingURL=data:application/json;base64,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