/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Inject, Injectable, Optional } from '@angular/core';
import { DOCUMENT, Title } from '@angular/platform-browser';
import { I18NextPipe } from 'angular-i18next';
import { APP_TITLE_ROOT } from '../../../tokens';
import * as i0 from "@angular/core";
import * as i1 from "angular-i18next";
import * as i2 from "@angular/platform-browser";
import * as i3 from "../../../tokens";
export class NwfTitleService extends Title {
    /**
     * @param {?} i18nextPipe
     * @param {?} doc
     * @param {?} appTitleRoot
     */
    constructor(i18nextPipe, doc, appTitleRoot) {
        super(doc);
        this.i18nextPipe = i18nextPipe;
        this.appTitleRoot = appTitleRoot;
        this.firstTitleSegment = this.appTitleRoot || '';
        this.sep = ' | ';
    }
    /**
     * @param {?} title
     * @return {?}
     */
    setTitle(title) {
        /** @type {?} */
        let titlesPipeSep = '';
        /** @type {?} */
        let titles = [];
        /* If I have a firstTitle, I push it on first */
        if (this.firstTitleSegment != '') {
            titles.push(this.firstTitleSegment);
        }
        /* If I am an array, I concatenate that array, otherwise I am a string and I just push it on */
        if (title instanceof Array) {
            titles = [...titles, ...title];
        }
        else {
            titles.push(title);
        }
        /* finally produce my pipe sep string, passing each over the i18next pipe so they can pass me i18n:keys */
        titlesPipeSep = titles.filter((/**
         * @param {?} item
         * @return {?}
         */
        (item) => item !== '')).map((/**
         * @param {?} item
         * @return {?}
         */
        (item) => {
            return this.i18nextPipe.transform(item);
        })).join(this.sep);
        /* Call the regular super for setTitle, now we just have a normal string */
        return super.setTitle(titlesPipeSep);
    }
}
NwfTitleService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root',
            },] }
];
/** @nocollapse */
NwfTitleService.ctorParameters = () => [
    { type: I18NextPipe },
    { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
    { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [APP_TITLE_ROOT,] }] }
];
/** @nocollapse */ NwfTitleService.ngInjectableDef = i0.defineInjectable({ factory: function NwfTitleService_Factory() { return new NwfTitleService(i0.inject(i1.I18NextPipe), i0.inject(i2.DOCUMENT), i0.inject(i3.APP_TITLE_ROOT, 8)); }, token: NwfTitleService, providedIn: "root" });
if (false) {
    /** @type {?} */
    NwfTitleService.prototype.firstTitleSegment;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.sep;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.i18nextPipe;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.appTitleRoot;
}
//# sourceMappingURL=data:application/json;base64,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