/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
/**
 * Sets the date-time range as provided by the user. The widget has 2 calendars for selecting a set of fromDate and toDate.
 */
import { Component } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
var NwfDatetimeRangePicker = /** @class */ (function () {
    function NwfDatetimeRangePicker() {
    }
    /**
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) { };
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param datetimeRangeValue - any
     * @returns void
     */
    /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    NwfDatetimeRangePicker.prototype.writeValue = /**
     * writeValue() - Sets the fromDate and toDate according to the input.
     * @param {?} datetimeRangeValue - any
     * @return {?} void
     */
    function (datetimeRangeValue) {
        var _a;
        if (datetimeRangeValue) {
            _a = tslib_1.__read(datetimeRangeValue.split('~'), 2), this.fromDateISOString = _a[0], this.toDateISOString = _a[1];
            // setting visible value.
            this.setVisibleValue();
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @param changes - SimpleChanges
     * @returns void
     */
    /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    NwfDatetimeRangePicker.prototype.setDatetimeRange = /**
     * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
     * These dates are updated according to the min and max data provided in the argument of the function.
     * @return {?} void
     */
    function () {
        // create comma-separated range.
        /** @type {?} */
        var newDatetimeRange = this.fromDateISOString + "~" + this.toDateISOString;
        // setting visible value.
        this.setVisibleValue();
        // calling callback with sending the datetime range.
        this._onChange(newDatetimeRange);
    };
    /**
     * @return {?}
     */
    NwfDatetimeRangePicker.prototype.setVisibleValue = /**
     * @return {?}
     */
    function () {
        this.fromDate = new Date(this.fromDateISOString);
        this.toDate = new Date(this.toDateISOString);
    };
    NwfDatetimeRangePicker.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-datetime-range-picker',
                    template: "\n        <ng-template #datetimerangePickerTemplate>\n            <div class=\"d-flex\" data-netapp-id=\"datetime-range-picker\">\n                <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-from-picker\">\n                    From:\n                    <nwf-datetime-picker [(ngModel)]=\"fromDateISOString\" [maxDate]=\"toDateISOString\" (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n                </div>\n                <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-to-picker\">\n                    To:\n                    <nwf-datetime-picker [(ngModel)]=\"toDateISOString\" [minDate]=\"fromDateISOString\" (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n                </div>\n            </div>\n        </ng-template>\n        <button type=\"button\" class=\"btn btn-default datetimepicker-button form-control\" [ngbPopover]=\"datetimerangePickerTemplate\" placement=\"bottom-right\"\n        data-netapp-id=\"filter-widget-btn\">\n            <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n            <span class=\"datetimepicker-value\" data-netapp-id=\"dateTimePicker-widget-label\">\n                {{ fromDate | i18nextFormat: { format: 'datetime' } }} to {{ toDate | i18nextFormat: { format: 'datetime' } }}\n            </span>\n        </button>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: NwfDatetimeRangePicker,
                            multi: true,
                        }],
                    styles: [".datetimepicker-button{width:190px;height:50px!important;display:flex}.datetimepicker-value{white-space:normal;text-align:initial;width:170px;margin:0}"]
                }] }
    ];
    /** @nocollapse */
    NwfDatetimeRangePicker.ctorParameters = function () { return []; };
    return NwfDatetimeRangePicker;
}());
export { NwfDatetimeRangePicker };
if (false) {
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDateISOString;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.fromDate;
    /** @type {?} */
    NwfDatetimeRangePicker.prototype.toDate;
    /**
     * @type {?}
     * @private
     */
    NwfDatetimeRangePicker.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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