/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Directive, ElementRef, HostListener, Input, Renderer2 } from '@angular/core';
import { Subject } from 'rxjs';
import { takeUntil } from 'rxjs/operators';
import { NwfElipsizerResizeService } from './elipsizer-resize.service';
var NwfElipsizer = /** @class */ (function () {
    function NwfElipsizer(el, renderer, elipsizerResizeService) {
        this.el = el;
        this.renderer = renderer;
        this.elipsizerResizeService = elipsizerResizeService;
        this.destroy = new Subject();
    }
    /**
     * @param {?} event
     * @return {?}
     */
    NwfElipsizer.prototype.windowResize = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        this.elipsize(false);
    };
    /**
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // subscribe to service to get resize calls
        this.elipsizerResizeService.resizeEvent$.pipe(takeUntil(this.destroy)).subscribe((/**
         * @return {?}
         */
        function () {
            _this.elipsize(false);
        }));
    };
    /**
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // Complete subject
        this.destroy.next();
        this.destroy.complete();
    };
    /**
     * @param {?} changes
     * @return {?}
     */
    NwfElipsizer.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        this.elipsize(true);
    };
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    /**
     * @param {?} ignoreSizeCheck
     * @return {?}
     */
    NwfElipsizer.prototype.elipsize = 
    // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
    // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
    /**
     * @param {?} ignoreSizeCheck
     * @return {?}
     */
    function (ignoreSizeCheck) {
        /** @type {?} */
        var parentNode = this.renderer.parentNode(this.el.nativeElement);
        /** @type {?} */
        var computedStyle = window.getComputedStyle(parentNode);
        /** @type {?} */
        var myLeftPad = parseInt(computedStyle.getPropertyValue('padding-left'));
        /** @type {?} */
        var myRightPad = parseInt(computedStyle.getPropertyValue('padding-right'));
        /** @type {?} */
        var theBiggestICanBe = parentNode.offsetWidth - myLeftPad - myRightPad;
        if (theBiggestICanBe !== 0 && (ignoreSizeCheck || this.currentSizeOfElement !== theBiggestICanBe)) {
            this.currentSizeOfElement = theBiggestICanBe;
            // Create element off screen
            /** @type {?} */
            var textElement = this.renderer.createText(this.originalText);
            /** @type {?} */
            var tempElement = this.renderer.createElement(this.el.nativeElement.tagName.toLowerCase());
            this.renderer.appendChild(tempElement, textElement);
            this.renderer.setStyle(tempElement, 'width', 'auto');
            this.renderer.setStyle(tempElement, 'white-space', 'nowrap');
            this.renderer.setStyle(tempElement, 'overflow', 'visible');
            this.renderer.setStyle(tempElement, 'position', 'absolute');
            this.renderer.setStyle(tempElement, 'left', '-10000px');
            // this.renderer.appendChild(document.body, tempElement);
            this.renderer.appendChild(parentNode, tempElement);
            // Loop of length of text removing one character at a time until its the proper size
            /** @type {?} */
            var finalName = this.originalText;
            // Total length of string
            /** @type {?} */
            var index = textElement.textContent.length;
            /** @type {?} */
            var start = 0;
            /** @type {?} */
            var end = index;
            if (tempElement.offsetWidth > theBiggestICanBe) {
                while (end - start > 1) {
                    /** @type {?} */
                    var size = Math.round((start + end) / 2.0);
                    /** @type {?} */
                    var half = Math.round(size / 2.0);
                    finalName = this.originalText.slice(0, half) + String.fromCharCode(8230) + this.originalText.slice(index - half);
                    textElement.textContent = finalName;
                    if (tempElement.offsetWidth > theBiggestICanBe) {
                        end = size;
                    }
                    else {
                        start = size;
                    }
                }
            }
            // Set final elipsized text
            this.el.nativeElement.innerText = finalName;
            // console.log('Final text', finalName);
            // Remove element created of screen
            // this.renderer.removeChild(document.body, tempElement);
            this.renderer.removeChild(parentNode, tempElement);
        }
    };
    NwfElipsizer.decorators = [
        { type: Directive, args: [{
                    selector: '[nwfElipsizer]',
                    host: {
                        '[style.white-space]': '"nowrap"',
                        '[style.display]': '"inline-block"',
                    },
                },] }
    ];
    /** @nocollapse */
    NwfElipsizer.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 },
        { type: NwfElipsizerResizeService }
    ]; };
    NwfElipsizer.propDecorators = {
        originalText: [{ type: Input, args: ['nwfElipsizer',] }],
        windowResize: [{ type: HostListener, args: ['window:resize', ['$event'],] }]
    };
    return NwfElipsizer;
}());
export { NwfElipsizer };
if (false) {
    /** @type {?} */
    NwfElipsizer.prototype.originalText;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.currentSizeOfElement;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.destroy;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.el;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.renderer;
    /**
     * @type {?}
     * @private
     */
    NwfElipsizer.prototype.elipsizerResizeService;
}
//# sourceMappingURL=data:application/json;base64,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