/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { NwfHelpConfig } from './help.config.service';
var HelpService = /** @class */ (function () {
    function HelpService(config) {
        this.config = config;
        /** @type {?} */
        var basePath = this.config.helpBasePath;
        /** @type {?} */
        var context = this.config.helpContext;
        //  Beginning of Webworks help API
        /** @type {?} */
        var WWHAPI_Object = (/**
         * @param {?} ParamHelpURL
         * @param {?} ParamTargetWindow
         * @return {?}
         */
        function (ParamHelpURL, ParamTargetWindow) {
            // Location of the WebWorks Help system to be launched.
            // Location should be an absolute URL.
            //
            this.mAPIURL = ParamHelpURL + '/wwhelp/wwhimpl/api.htm';
            this.mWindow = null;
            this.mTargetWindow = ParamTargetWindow;
            this.fLaunchHelp = WWHAPI_LaunchHelp;
            this.fCloseHelp = WWHAPI_CloseHelp;
            this.fDisplayHelp = WWHAPI_DisplayHelp;
            this.fDisplayHelpWithNavigation = WWHAPI_DisplayHelpWithNavigation;
            this.fDisplayHelpWithContents = WWHAPI_DisplayHelpWithContents;
            this.fDisplayHelpWithIndex = WWHAPI_DisplayHelpWithIndex;
            this.fDisplayHelpWithSearch = WWHAPI_DisplayHelpWithSearch;
            this.fDisplayHelpWithFavorites = WWHAPI_DisplayHelpWithFavorites;
            this.fDisplayHelpNavigation = WWHAPI_DisplayHelpNavigation;
            this.fDisplayHelpContents = WWHAPI_DisplayHelpContents;
            this.fDisplayHelpIndex = WWHAPI_DisplayHelpIndex;
            this.fDisplayHelpSearch = WWHAPI_DisplayHelpSearch;
            this.fDisplayHelpFavorites = WWHAPI_DisplayHelpFavorites;
        });
        /**
         * @param {?} bParamSingle
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @param {?} ParamTab
         * @return {?}
         */
        function WWHAPI_LaunchHelp(bParamSingle, ParamContext, ParamTopic, ParamTab) {
            /** @type {?} */
            var VarParameters;
            /** @type {?} */
            var VarURL;
            /** @type {?} */
            var VarIndex;
            /** @type {?} */
            var VarMaxIndex;
            // Define parameters
            //
            VarParameters = new Array();
            if (bParamSingle) {
                VarParameters[VarParameters.length] = 'single=true';
            }
            if (ParamContext != null) {
                VarParameters[VarParameters.length] = 'context=' + ParamContext;
                // Use the global configuration for the help context if one exists
            }
            else if (context != null) {
                VarParameters[VarParameters.length] = 'context=' + context;
            }
            if (ParamTopic != null) {
                VarParameters[VarParameters.length] = 'topic=' + ParamTopic;
            }
            if (ParamTab) {
                VarParameters[VarParameters.length] = 'tab=' + ParamTab;
            }
            // Create URL
            //
            VarURL = this.mAPIURL;
            for (VarIndex = 0, VarMaxIndex = VarParameters.length; VarIndex < VarMaxIndex; VarIndex++) {
                if (VarIndex == 0) {
                    VarURL += '?' + VarParameters[VarIndex];
                }
                else {
                    VarURL += '&' + VarParameters[VarIndex];
                }
            }
            // Check to see if the window exists.  If it does, make the native call directly.
            // Otherwise, initialize the help system at the topic using URL params.
            //
            if ((this.mWindow != null) &&
                (typeof (this.mWindow) != 'undefined') &&
                (!this.mWindow.closed) &&
                (this.mWindow.WWHHelp != null) &&
                (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                this.mWindow.focus();
                this.mWindow.WWHHelp.fSetContextDocument(VarURL);
            }
            else {
                /* Customized this for our needs ! */
                /** @type {?} */
                var netappDesiredWidthAndHeight = 'height=768, width=1024';
                if ((typeof (this.mTargetWindow) != 'undefined') &&
                    (this.mTargetWindow != null)) {
                    this.mWindow = window.open(VarURL, this.mTargetWindow, netappDesiredWidthAndHeight);
                }
                else {
                    this.mWindow = window.open(VarURL, null, netappDesiredWidthAndHeight);
                }
                // Ensure window is brought to the foreground
                //
                this.mWindow.focus();
            }
        }
        /**
         * @return {?}
         */
        function WWHAPI_CloseHelp() {
            if ((this.mWindow != null) &&
                (typeof (this.mWindow) != 'undefined') &&
                (!this.mWindow.closed) &&
                (this.mWindow.WWHHelp != null) &&
                (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                this.mWindow.close();
            }
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelp(ParamContext, ParamTopic) {
            this.fLaunchHelp(true, ParamContext, ParamTopic, null);
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithNavigation(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, null);
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithContents(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'contents');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithIndex(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'index');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithSearch(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'search');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithFavorites(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'favorites');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpNavigation() {
            this.fLaunchHelp(false, null, null, null);
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpContents() {
            this.fLaunchHelp(false, null, null, 'contents');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpIndex() {
            this.fLaunchHelp(false, null, null, 'index');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpSearch() {
            this.fLaunchHelp(false, null, null, 'search');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpFavorites() {
            this.fLaunchHelp(false, null, null, 'favorites');
        }
        // End of Webworks help API
        /* Now create me , we should not have two things, but one to configure. Fix later. */
        this.helpDirectiveWindow = new WWHAPI_Object(basePath + context, 'help_window');
    }
    HelpService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    HelpService.ctorParameters = function () { return [
        { type: NwfHelpConfig }
    ]; };
    return HelpService;
}());
export { HelpService };
if (false) {
    /** @type {?} */
    HelpService.prototype.helpDirectiveWindow;
    /**
     * @type {?}
     * @private
     */
    HelpService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,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