/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, Input } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { TransitionService } from '@uirouter/angular';
import { I18NextPipe } from 'angular-i18next';
import { NwfPageAlertService } from './page-alert.service';
var PageAlertComponent = /** @class */ (function () {
    function PageAlertComponent(element, pageAlertService, sanitizer, transitionService, i18next) {
        var _this = this;
        this.element = element;
        this.sanitizer = sanitizer;
        this.transitionService = transitionService;
        this.i18next = i18next;
        this.message = '';
        this.severity = 'ok';
        this.isShowing = false;
        this.extraInformation = '';
        this.showMoreInfo = false;
        this.subscription = pageAlertService.pageAlert$.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            // TO check whether show is called or hide is called
            if (data.type === 'show') {
                _this.show(data.config);
            }
            else {
                _this.close();
            }
        }));
        /* I want to close when I exit this route */
        transitionService.onExit({
            exiting: '*',
        }, this.close.bind(this));
    }
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () { };
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        // unsubscribe to ensure no memory leaks
        this.subscription.unsubscribe();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    PageAlertComponent.prototype.show = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var message = _a.message, severity = _a.severity, fade = _a.fade;
        this.resetFlags();
        // checking if message is object or not.
        if (typeof message === 'object') {
            // setting extraInformation.
            this.extraInformation = message.extraInformation || '';
            // updating message.
            message = message.message;
        }
        this.message = this.sanitizer.bypassSecurityTrustHtml(message);
        this.severity = severity;
        this.isShowing = true;
        if (fade) {
            setTimeout((/**
             * @return {?}
             */
            function () { return _this.close(); }), fade);
        }
    };
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.close = /**
     * @return {?}
     */
    function () {
        this.isShowing = false;
    };
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.toggleMoreInfoVisibility = /**
     * @return {?}
     */
    function () {
        if (this.showMoreInfo) {
            this.showMoreInfo = false;
            this.showMoreButtonText = this.i18next.transform('nwfjs:showMore');
        }
        else {
            this.showMoreInfo = true;
            this.showMoreButtonText = this.i18next.transform('nwfjs:hide');
        }
    };
    /**
     * @return {?}
     */
    PageAlertComponent.prototype.resetFlags = /**
     * @return {?}
     */
    function () {
        // resetting flags.
        this.extraInformation = '';
        this.showMoreInfo = false;
        this.showMoreButtonText = this.i18next.transform('nwfjs:showMore');
    };
    Object.defineProperty(PageAlertComponent.prototype, "stateClass", {
        get: /**
         * @return {?}
         */
        function () {
            return "is-" + this.severity.toLowerCase();
        },
        enumerable: true,
        configurable: true
    });
    PageAlertComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-page-alert',
                    template: "\n    <div data-netapp-id=\"nwf-pageAlert\" class=\"nwf-page-alert {{stateClass}}\" *ngIf=\"isShowing\" role=\"alert\">\n        <div class=\"l-page-alert-icon\" data-netapp-id=\"pageAlertCtrl-icon\">\n            <nwf-icon [severity]=\"severity\"></nwf-icon>\n        </div>\n        <div class=\"page-alert-message-container\">\n            <div data-netapp-id=\"pageAlertCtrl-message\" class=\"page-alert-message\">\n                <span [innerHTML]=\"message\"></span>\n                <a href=\"javascript:void(0)\" *ngIf=\"extraInformation\" (click)=\"toggleMoreInfoVisibility()\">\n                    {{showMoreButtonText}}\n                </a>\n            </div>\n            <div [hidden]=\"!showMoreInfo\">\n            <div>{{extraInformation}}</div>\n            </div>\n        </div>\n        <div class=\"l-page-alert-close\" data-netapp-id=\"pageAlertCtrl-close-btn\" (click)=\"close()\">\n            <nwf-icon iconClass=\"icon-action-x\"></nwf-icon>\n        </div>\n    </div>\n  ",
                    styles: [":host{width:50%;position:fixed;top:60px;left:50%;z-index:9;margin-left:-25%}.nwf-page-alert{display:flex}.nwf-page-alert a{color:#2d6dde}.nwf-page-alert.is-ok{background-color:#b4e697}.nwf-page-alert.is-error{background-color:#fff}.nwf-page-alert.is-info{background-color:#fff7c0}.nwf-page-alert.is-critical{background-color:#fccdce}.nwf-page-alert.is-warning{background-color:#ffe1a1}.l-page-alert-icon{margin-left:7px;-ms-grid-row-align:center;align-self:center;margin-top:2px}.page-alert-message-container{display:flex;flex:9;flex-direction:column;justify-content:center;padding:10px}.page-alert-message{max-width:676px;overflow:hidden;text-overflow:ellipsis}.l-page-alert-close{display:flex;max-width:30px;cursor:pointer;flex:1;align-items:center;justify-content:center}"]
                }] }
    ];
    /** @nocollapse */
    PageAlertComponent.ctorParameters = function () { return [
        { type: ElementRef },
        { type: NwfPageAlertService },
        { type: DomSanitizer },
        { type: TransitionService },
        { type: I18NextPipe }
    ]; };
    PageAlertComponent.propDecorators = {
        message: [{ type: Input }],
        severity: [{ type: Input }]
    };
    return PageAlertComponent;
}());
export { PageAlertComponent };
if (false) {
    /** @type {?} */
    PageAlertComponent.prototype.message;
    /** @type {?} */
    PageAlertComponent.prototype.severity;
    /** @type {?} */
    PageAlertComponent.prototype.isShowing;
    /** @type {?} */
    PageAlertComponent.prototype.extraInformation;
    /** @type {?} */
    PageAlertComponent.prototype.showMoreInfo;
    /** @type {?} */
    PageAlertComponent.prototype.showMoreButtonText;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.element;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.sanitizer;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.i18next;
}
//# sourceMappingURL=data:application/json;base64,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