/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { DxDataGridComponent } from 'devextreme-angular';
var ColumnVisibilityComponent = /** @class */ (function () {
    function ColumnVisibilityComponent() {
        this.orderedColumns = []; // our array of the columns in asc order
        // our array of the columns in asc order
        this.visible = {}; // our map of visiblity true / false
    }
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.myDrop.openChange.subscribe((/**
         * @return {?}
         */
        function () {
            _this.gridInstance = _this.dataGrid.instance;
            _this.setColumns();
        }));
    };
    /**
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.setColumns = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var columns = this.gridInstance.option('columns');
        columns.forEach((/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var dataField = _a.dataField;
            /** @type {?} */
            var colObj = _this.gridInstance.columnOption(dataField);
            // if columns are shown in columnChooser, then only we toggle the visibility flag and set it as part of ordered columns.
            if (colObj.showInColumnChooser) {
                _this.visible[dataField] = colObj.visible;
                _this.orderedColumns[colObj.visibleIndex] = colObj;
            }
        }));
    };
    /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.notify = /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    function (event, col) {
        // we filter out command(eg checkbox column) columns as visibility only operates on non-command columns.
        // This ensures we dont toggle the visibility of checkbox column.
        /** @type {?} */
        var visibleColumns = this.gridInstance.getVisibleColumns().filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return !item.command; }));
        // if we have more than one visible column, or we are showing a column,
        // only then we toggle the visibility of the column.
        // this ensures we never run into case of having all hidden columns.
        if (visibleColumns.length > 1 || event.target.checked) {
            this.gridInstance.beginUpdate();
            this.gridInstance.columnOption(col, 'visible', event.target.checked);
            this.gridInstance.endUpdate();
        }
        else {
            // this ensures the last checkbox remains checked.
            // so that we can never have all checkbox as unchecked i.e. all columns are unselected/hidden.
            event.target.checked = true;
        }
    };
    /**
     * Unused for now.
     * Can be used if submit needed in any case
     */
    /**
     * Unused for now.
     * Can be used if submit needed in any case
     * @return {?}
     */
    ColumnVisibilityComponent.prototype.submit = /**
     * Unused for now.
     * Can be used if submit needed in any case
     * @return {?}
     */
    function () {
        this.gridInstance.beginUpdate();
        for (var dataField in this.visible) {
            if (this.visible.hasOwnProperty(dataField)) {
                /** @type {?} */
                var columnVisibility = this.visible[dataField];
                this.gridInstance.columnOption(dataField, 'visible', columnVisibility);
            }
        }
        this.gridInstance.endUpdate();
        this.myDrop.close();
    };
    ColumnVisibilityComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-column-visibility',
                    template: "<div ngbDropdown class=\"d-inline-block\" placement=\"bottom-right\" autoClose=\"outside\">\n  <button type=\"button\" class=\"btn btn-flat btn-icon-with-label\" ngbDropdownToggle>\n    <nwf-icon iconClass=\"icon-view-visible\"></nwf-icon><span class=\"nwf-icon-label\">{{'nwfjs:showHide' | i18next}}</span>\n  </button>\n  <div ngbDropdownMenu>\n    <dx-scroll-view>\n      <div class=\"dropdown-checkbox-item pl-4 mb-1\" *ngFor=\"let column of orderedColumns\">\n        <div class=\"custom-control custom-checkbox\" *ngIf=\"column.allowHiding !== false\">\n          <input type=\"checkbox\" [name]=\"column.dataField\" [id]=\"column.dataField\" class=\"custom-control-input\"\n            [(ngModel)]=\"visible[column.dataField]\" (change)=\"notify($event, column.dataField)\">\n          <label class=\"custom-control-label w-100\" [attr.for]=\"column.dataField\">{{column.caption}}</label>\n        </div>\n      </div>\n    </dx-scroll-view>\n  </div>\n</div>",
                    styles: [":host ::ng-deep .dx-scrollable-container{max-height:50vh}.dropdown-menu{padding-top:20px;padding-bottom:20px;max-height:60vh}.dropdown-checkbox-item{margin-right:20px}.custom-control-label{cursor:pointer;white-space:nowrap}"]
                }] }
    ];
    /** @nocollapse */
    ColumnVisibilityComponent.ctorParameters = function () { return []; };
    ColumnVisibilityComponent.propDecorators = {
        myDrop: [{ type: ViewChild, args: [NgbDropdown,] }],
        dataGrid: [{ type: Input }]
    };
    return ColumnVisibilityComponent;
}());
export { ColumnVisibilityComponent };
if (false) {
    /** @type {?} */
    ColumnVisibilityComponent.prototype.myDrop;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.gridInstance;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.orderedColumns;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.visible;
    /**
     * @type {?}
     * @private
     */
    ColumnVisibilityComponent.prototype.dataGrid;
}
//# sourceMappingURL=data:application/json;base64,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