/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { find } from 'lodash-es';
import FilterConfig from '../filter-config';
/**
 * A filter criterion consist of filter property, operator and a value.
 * Each filter-property have a list of operators.
 * Filter criterion row gets a critierion(filter) from parent filterGroup, and it breaks that criterion down into property, operator and a value.
 * Filter property and type means same thing and are interchangeable
 */
var FilterCriterionRowComponent = /** @class */ (function () {
    function FilterCriterionRowComponent() {
        this.deleteCriterion = new EventEmitter();
        this.config = FilterConfig;
    }
    /**
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        // on birth, we set the operator and value based on incoming filter property.
        this.setColumnBasedOnCriteria();
    };
    /**
     * @description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @param id
     */
    /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.updateCriterion = /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    function () {
        // updating the new criterion.
        this.setColumnBasedOnCriteria();
        // resetting the form group with default criteria.
        this.criteria.reset(this.initCriterion(this.selectedColumn));
    };
    /**
     * @param {?} change
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.updateOperator = /**
     * @param {?} change
     * @return {?}
     */
    function (change) {
        var _this = this;
        /** @type {?} */
        var selectedOperator = change.target.value;
        // If there is a default value associate with the selected operator we want to set the criteria to have that value
        /** @type {?} */
        var defaultValue = find(this.config[this.selectedColumn.dataType].options, (/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.value === selectedOperator; })).default;
        if (defaultValue) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: defaultValue });
            // If the current value of the criteria is the same as the default value associated with the previous operator we want to clear it away
        }
        else if (this.previousOperator &&
            find(this.config[this.selectedColumn.dataType].options, (/**
             * @param {?} option
             * @return {?}
             */
            function (option) { return option.value === _this.previousOperator; })).default === this.criteria.controls.value.value) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: '' });
        }
        this.previousOperator = selectedOperator;
    };
    /**
     * Method to get the default filter critierion based on filter property.
     * @param property Filter property (type)
     */
    /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.initCriterion = /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var dataField = _a.dataField, dataType = _a.dataType;
        this.previousOperator = this.config[dataType].options[0].value;
        return {
            property: dataField,
            operator: this.config[dataType].options[0].value,
            value: '',
        };
    };
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     */
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.setColumnBasedOnCriteria = /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        // update property based on new selection.
        this.selectedColumn = this.dxColumns.filter((/**
         * @param {?} prop
         * @return {?}
         */
        function (prop) {
            return prop.dataField === _this.criteria.value.property;
        }))[0];
        // update prevoious operator based on criteria
        this.previousOperator = this.criteria.controls.operator.value;
        // updating operator list based on new filter property.
        this.propertyTypeConfig = this.config[this.selectedColumn.dataType];
    };
    FilterCriterionRowComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-criterion-row',
                    template: "<div [formGroup]=\"criteria\" class=\"d-flex mb-2 w-100\">\n\n    <!-- Property -->\n    <div class=\"filter-criterion-control mr-1\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-type\" (change)=\"updateCriterion()\" formControlName=\"property\">\n            <option *ngFor=\"let dxColumn of dxColumns\" [value]=\"dxColumn.dataField\">{{dxColumn.caption}}</option>\n        </select>\n    </div>\n\n    <!-- Operator -->\n    <div class=\"filter-criterion-control mr-1\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-operator\" (change)=\"updateOperator($event)\" formControlName=\"operator\">\n            <option *ngFor=\"let operator of propertyTypeConfig.options\" [value]=\"operator.value\">{{operator.name | i18next}}\n            </option>\n        </select>\n    </div>\n\n    <!-- Value -->\n    <div class=\"mr-1\" [ngSwitch]=\"propertyTypeConfig.inputType\">\n        <div *ngSwitchCase=\"'text'\" class=\"align-items-center\">\n            <input type=\"text\" [hidden]=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n            class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\" formControlName=\"value\">\n            <div *ngIf=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\" class=\"form-control\">\n                {{'nwfjs:empty' | i18next}}\n            </div>\n        </div>\n\n        <div *ngSwitchCase=\"'number'\" class=\"d-flex align-items-center\">\n            <input type=\"number\" *ngSwitchCase=\"'number'\" class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\" formControlName=\"value\"\n                step=\"any\">\n            <!-- unit -->\n            <div class=\"px-2\" *ngIf=\"selectedColumn.unit\" data-netapp-id=\"filter-widget-unit\">{{selectedColumn.unit}}</div>\n        </div>\n        <select class=\"custom-select filter-criterion-control\" data-netapp-id=\"filter-widget-property-options\" required formControlName=\"value\" *ngSwitchCase=\"'select'\">\n            <option [selected]=\"!criteria.value\" value>{{'nwfjs:choose' | i18next}}</option>\n            <option [selected]=\"criteria.value.value == option.id\" *ngFor=\"let option of selectedColumn.editorOptions\" [value]=\"option.id\">{{option.label}}\n                </option>\n        </select>\n\n        <nwf-grid-filter-multiselect [options]=\"selectedColumn.editorOptions\" required *ngSwitchCase=\"'multiselect'\" formControlName=\"value\">\n        </nwf-grid-filter-multiselect>\n\n        <nwf-grid-filter-criterion-date [operator]=\"criteria.controls.operator.value\" *ngSwitchCase=\"'dateTime'\" formControlName=\"value\"></nwf-grid-filter-criterion-date>\n\n        <div *ngIf=\"criteria.invalid && (criteria.controls.value.touched || criteria.controls.value.dirty)\" class=\"invalid-feedback\">\n            <span *ngSwitchCase=\"'select'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'multiselect'\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</span>\n            <span *ngSwitchCase=\"'dateTime'\">{{'nwfjs:isInvalidTimeMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'text'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'number'\">{{'nwfjs:isNumberInvalidMessage' | i18next}}</span>\n        </div>\n    </div>\n\n    <!-- remove button -->\n    <div class=\"d-flex flex-fill justify-content-end\">\n        <div>\n            <button type=\"button\" class=\"btn btn-default btn-delete-criterion\" data-netapp-id=\"filter-widget-remove-criteria-btn\" (click)=\"deleteCriterion.emit();$event.stopPropagation();\">\n                <nwf-icon iconClass=\"icon-action-delete\"></nwf-icon>\n            </button>\n        </div>\n    </div>\n</div>",
                    styles: [".filter-criterion-control {\n            width: 200px;\n        }"]
                }] }
    ];
    /** @nocollapse */
    FilterCriterionRowComponent.ctorParameters = function () { return []; };
    FilterCriterionRowComponent.propDecorators = {
        dxColumns: [{ type: Input }],
        criteria: [{ type: Input }],
        deleteCriterion: [{ type: Output }]
    };
    return FilterCriterionRowComponent;
}());
export { FilterCriterionRowComponent };
if (false) {
    /** @type {?} */
    FilterCriterionRowComponent.prototype.dxColumns;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.criteria;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.deleteCriterion;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.selectedColumn;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.propertyTypeConfig;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.config;
    /**
     * Track operator changes to set default and remove defaults based on changes
     * @type {?}
     */
    FilterCriterionRowComponent.prototype.previousOperator;
}
//# sourceMappingURL=data:application/json;base64,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