/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NgbCollapse } from '@ng-bootstrap/ng-bootstrap';
import { StateService } from '@uirouter/core';
var LeftnavItemComponent = /** @class */ (function () {
    function LeftnavItemComponent(stateService) {
        this.stateService = stateService;
        this.isTopLevel = false;
    }
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.toggleCollapsed = /**
     * @return {?}
     */
    function () {
        this.item.isCollapsed = !this.item.isCollapsed;
    };
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.onClick = /**
     * @return {?}
     */
    function () {
        if (this.item.children) {
            this.toggleCollapsed();
        }
        else if (this.stateService.$current.parent.name === this.item.sref) {
            this.stateService.go('^', {}, { reload: true });
        }
        else {
            this.stateService.go(this.item.sref, this.item.srefParams);
        }
    };
    LeftnavItemComponent.decorators = [
        { type: Component, args: [{
                    selector: '[nwfLeftnavItem]',
                    template: "\n\n<!-- the item -->\n  <a class=\"nwf-leftnav-item-link flex-grow-1\" (click)=\"onClick()\"\n  attr.data-netapp-id=\"leftnav-item-{{item.label | lowercase}}-link\"\n  [ngClass]=\"{'is-active': item.isActive, 'is-toplevel': isTopLevel, 'is-open': !item.isCollapsed }\"\n  [nwfFeatureTour]=\"item.featureTourComponent ? 'leftNav-' + item.featureTourOrder : null\"\n  [component]=\"item.featureTourComponent || null\"\n  [item]=\"item\">\n  <span *ngIf=\"item.icon && false\" class=\"nwf-leftnav-item-icon\">\n  <nwf-icon [iconClass]=\"item.icon\"></nwf-icon>\n  </span>\n  <span class=\"nwf-leftnav-item-label\">{{item.label | i18next }}</span>\n  <nwf-icon class=\"nwf-leftnav-item-toggler\" *ngIf=\"item.children && item.children.length\" [iconClass]=\"item.isCollapsed ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\"></nwf-icon>\n  </a>\n\n\n  <ul *ngIf=\"item.children?.length\" class=\"nwf-leftnav-items pl-0\" [ngbCollapse]=\"item.isCollapsed\" attr.data-netapp-id=\"leftnav-item-group-{{item.label | lowercase}}\">\n    <li *ngFor=\"let item of item.children | keyvalue\" nwfLeftnavItem [item]=\"item.value\" class=\"nwf-leftnav-item is-submenu d-block flex-grow-1\" attr.data-netapp-id=\"leftnav-item-{{item.value.label | lowercase}}\"></li>\n  </ul>",
                    providers: [NgbCollapse],
                    styles: [":host{color:#fff;line-height:16px}:host:hover{color:#fff}:host[istoplevel]:first-child{border-top:1px solid #08214b}:host[istoplevel] ul{border-bottom:1px solid #08214b}a.nwf-leftnav-item-link{display:flex;align-items:center;padding:8px 8px 8px 12px;text-transform:capitalize;font-weight:400;letter-spacing:0}a.nwf-leftnav-item-link:hover{background:#7ba1e5}a.nwf-leftnav-item-link:hover ::ng-deep #base-layer{fill:#fff}a.nwf-leftnav-item-link.is-active{background-color:#a5bfed;color:#131313}a.nwf-leftnav-item-link.is-open{border-bottom:none!important}a.nwf-leftnav-item-link.is-toplevel{border-bottom:1px solid #08214b;padding:12px;border-left:4px solid transparent;letter-spacing:1px;font-weight:700;text-transform:uppercase}a.nwf-leftnav-item-link.is-toplevel.is-active{color:#fff;background-color:#08214b;border-left-color:#a5bfed}a.nwf-leftnav-item-link.is-toplevel.is-active:hover{background-color:#030d1d}a.nwf-leftnav-item-link:not([href]){cursor:pointer}nwf-icon.nwf-leftnav-item-toggler{margin-right:12px}nwf-icon.nwf-leftnav-item-toggler ::ng-deep #base-layer{fill:#a5bfed}.nwf-leftnav-item-label{margin-left:12px;flex-grow:1}.is-submenu .nwf-leftnav-item-label{margin-left:16px}"]
                }] }
    ];
    /** @nocollapse */
    LeftnavItemComponent.ctorParameters = function () { return [
        { type: StateService }
    ]; };
    LeftnavItemComponent.propDecorators = {
        item: [{ type: Input }],
        isTopLevel: [{ type: Input }]
    };
    return LeftnavItemComponent;
}());
export { LeftnavItemComponent };
if (false) {
    /** @type {?} */
    LeftnavItemComponent.prototype.item;
    /** @type {?} */
    LeftnavItemComponent.prototype.isTopLevel;
    /**
     * @type {?}
     * @private
     */
    LeftnavItemComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,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