/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService, TransitionService } from '@uirouter/core';
import { forEach, isMatch, reduce } from 'lodash-es';
import { NwfLeftnavService } from './leftnav.service';
var LeftnavComponent = /** @class */ (function () {
    function LeftnavComponent(leftnavService, transitionService, stateService) {
        this.leftnavService = leftnavService;
        this.transitionService = transitionService;
        this.stateService = stateService;
        this.keepOtherSectionsOpen = true;
    }
    /**
     * @return {?}
     */
    LeftnavComponent.prototype.repaintStateHighlight = /**
     * @return {?}
     */
    function () {
        var _this = this;
        var _a = this.stateService, current = _a.current, params = _a.params;
        setTimeout((/**
         * @return {?}
         */
        function () { _this.markActiveState(_this.navData, current, params); }), 0);
    };
    /**
     * @return {?}
     */
    LeftnavComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Set my navData on the leftnavService so others (like feature tour ) can open a tree of items programatically.
        this.leftnavService.navData = this.navData;
        /* On Enter I recurse to find out what to highlight */
        this.transitionService.onSuccess({}, (/**
         * @param {?} trans
         * @return {?}
         */
        function (trans) {
            _this.repaintStateHighlight();
        }));
        this.closeAll(this.navData);
        /* I have to find out on load where I am as well */
        this.repaintStateHighlight();
    };
    /*
     * Recurse through the navData, marking the active state, and
     * all its parents. Return true if we found a match.
     * An item is active if it's name and params matches
     * An item is also active if any of it's child is active.
     */
    /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    LeftnavComponent.prototype.markActiveState = /*
       * Recurse through the navData, marking the active state, and
       * all its parents. Return true if we found a match.
       * An item is active if it's name and params matches
       * An item is also active if any of it's child is active.
       */
    /**
     * @param {?} navData
     * @param {?} state
     * @param {?=} params
     * @return {?}
     */
    function (navData, state, params) {
        var _this = this;
        if (params === void 0) { params = null; }
        return reduce(navData, (/**
         * @param {?} matched
         * @param {?} item
         * @return {?}
         */
        function (matched, item) {
            /** @type {?} */
            var matchesChild = false;
            if (item.children) {
                matchesChild = _this.markActiveState(item.children, state, params);
            }
            if (_this.keepOtherSectionsOpen) {
                /* If it's already open leave if; if it needs to be open, do it */
                if (matchesChild) {
                    item.isCollapsed = false;
                }
            }
            else {
                item.isCollapsed = !matchesChild;
            }
            /** @type {?} */
            var hasNameMatch = ((state.name === item.sref) || (state.parent === item.sref));
            /** @type {?} */
            var hasParamMatch = isMatch(params, item.srefParams || {});
            item.isActive = matchesChild
                || (hasNameMatch && hasParamMatch);
            matched = matched || item.isActive;
            return matched;
        }), false);
    };
    /**
     * @param {?} navData
     * @return {?}
     */
    LeftnavComponent.prototype.closeAll = /**
     * @param {?} navData
     * @return {?}
     */
    function (navData) {
        var _this = this;
        forEach(navData, (/**
         * @param {?} item
         * @return {?}
         */
        function (item) {
            item.isCollapsed = true;
            if (navData.children) {
                _this.closeAll(navData.children);
            }
        }));
    };
    LeftnavComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-left-nav',
                    template: "\n  <dx-scroll-view>\n  <nav class=\"leftnav\" role=\"navigation\">\n  <ul class=\"nwf-leftnav-items p-0 m-0\">\n      <li class=\"nwf-leftnav-item d-block\" *ngFor=\"let item of navData | keyvalue\" nwfLeftnavItem isTopLevel=\"true\" [item]=\"item.value\" attr.data-netapp-id=\"leftnav-item-{{item.value.label | lowercase}}\"></li>\n  </ul>\n  </nav>\n  </dx-scroll-view>\n  ",
                    styles: ["nav.leftnav{display:flex;flex-direction:column;font-size:90%;top:0;padding-top:25px;overflow-x:hidden;overflow-y:auto;position:-webkit-sticky;position:sticky}"]
                }] }
    ];
    /** @nocollapse */
    LeftnavComponent.ctorParameters = function () { return [
        { type: NwfLeftnavService },
        { type: TransitionService },
        { type: StateService }
    ]; };
    LeftnavComponent.propDecorators = {
        navData: [{ type: Input }]
    };
    return LeftnavComponent;
}());
export { LeftnavComponent };
if (false) {
    /** @type {?} */
    LeftnavComponent.prototype.navData;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.keepOtherSectionsOpen;
    /** @type {?} */
    LeftnavComponent.prototype.leftnavService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    LeftnavComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,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