/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Inject, Input } from '@angular/core';
import { StateService, TargetState } from '@uirouter/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { repeat } from 'lodash-es';
import { interval } from 'rxjs';
import { map } from 'rxjs/operators';
import { NwfTitleService } from '../title/title.service';
import { LoginFailedComponent } from './login-failed.component';
var LoginComponent = /** @class */ (function () {
    function LoginComponent(NwfAuthService, $state, modalService, titleService) {
        var _this = this;
        this.NwfAuthService = NwfAuthService;
        this.$state = $state;
        this.modalService = modalService;
        this.titleService = titleService;
        this.showHelp = true;
        this.isOemVendor = false;
        this.titleElement = null;
        this.username = null;
        this.password = null;
        // Forgot Password is off by default and enabled when I have provided it
        this.hasForgotPassword = false;
        this.hasResetPassword = false;
        this.forgotPasswordMode = false;
        // Reset Password
        this.resetPasswordMode = false;
        this.authToken = null;
        this.resetPasswordMatch = true;
        this.cnter = 0;
        this.loadingObs = interval(1000).pipe(map((/**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            _this.cnter++;
            if (_this.cnter > 3) {
                _this.cnter = 0;
            }
            return repeat('.', _this.cnter);
        })));
        this.creds = { username: '', password: '' };
        this.resetCreds = { username: '', newPassword: '', confirmNewPassword: '', authToken: '' };
        this.forgotCreds = { username: '' };
        /* I detect the presence of a forgotPassword and resetPassword methods in the strategy */
        if (NwfAuthService.forgotPassword) {
            this.hasForgotPassword = true;
        }
        if (NwfAuthService.resetPassword) {
            this.hasResetPassword = true;
        }
        this.titleService.setTitle('nwfjs:login');
    }
    /**
     * @return {?}
     */
    LoginComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        // If the server sends a user and authToken, the only use case we have is that user has send a request to reset the password with this URL.
        // Set the boolean to reset password to be true.
        /** @type {?} */
        var search = document.location.search;
        if (this.hasResetPassword && search) {
            /** @type {?} */
            var split = search.split('?');
            /** @type {?} */
            var $stateParams = split[split.length - 1].split('&');
            /** @type {?} */
            var stateParams_1 = {};
            $stateParams.forEach((/**
             * @param {?} item
             * @return {?}
             */
            function (item) {
                /** @type {?} */
                var pair = item.split('=');
                stateParams_1[pair[0]] = pair[1];
            }));
            if (stateParams_1.user !== undefined && stateParams_1.authToken !== undefined) {
                this.username = stateParams_1.user;
                this.resetPasswordMode = true;
                this.forgotPasswordMode = false;
                this.authToken = stateParams_1.authToken;
            }
        }
        this.updateHrefs();
    };
    /**
     * @return {?}
     */
    LoginComponent.prototype.authenticate = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.inFlight = true;
        /** @type {?} */
        var returnToOriginalState = (/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var state = _this.returnTo.state();
            /** @type {?} */
            var params = _this.returnTo.params();
            /** @type {?} */
            var options = tslib_1.__assign({}, _this.returnTo.options(), { reload: true });
            _this.$state.go(state, params, options);
        });
        /** @type {?} */
        var showError = (/**
         * @param {?} error
         * @return {?}
         */
        function (error) {
            /** @type {?} */
            var errorCode = error.status;
            _this.inFlight = false;
            /** @type {?} */
            var failedMdl = _this.modalService.open(LoginFailedComponent);
            failedMdl.componentInstance.errorCode = errorCode;
        });
        /** @type {?} */
        var stop = (/**
         * @return {?}
         */
        function () { return _this.inFlight = false; });
        var _a = this.creds, username = _a.username, password = _a.password;
        this.NwfAuthService.authenticate(username, password)
            .then(returnToOriginalState)
            .catch(showError)
            .then(stop, stop);
    };
    /*
    responsible for having the right links and determining if this is vendorized or not
    */
    /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    LoginComponent.prototype.updateHrefs = /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var netappHome = 'http://netapp.com';
        if (!this.homeHref) {
            this.homeHref = netappHome;
        }
        if (!this.supportHref) {
            this.supportHref = 'http://mysupport.netapp.com';
        }
        this.isOemVendor = false;
        if (this.homeHref !== netappHome) {
            this.isOemVendor = true;
        }
    };
    // forgot password on submit.
    // forgot password on submit.
    /**
     * @return {?}
     */
    LoginComponent.prototype.forgotPasswordSubmit = 
    // forgot password on submit.
    /**
     * @return {?}
     */
    function () {
        /* @todo KM forgotCreds
                return this.authStrategy.forgotPasswordAuthenticateFn(credentials).then(() => {
                    var forgotPasswordToggle = this.$uibModal.open({
                        template: loginForgotPasswordTemplate,
                        controller: ['$scope', 'forgotPasswordName', function ($scope, forgotPasswordName) {
                            $scope.username = forgotPasswordName;
                        }],
                        resolve: {
                            forgotPasswordName: function () {
                                return credentials.username;
                            }
                        }
                    });

                    //Once done do back to the Login form.
                    forgotPasswordToggle.result.then(() => {
                        this.forgotPasswordToggleFn();
                    });
                });
                */
    };
    // Reset password on submit.
    // Reset password on submit.
    /**
     * @return {?}
     */
    LoginComponent.prototype.resetPasswordSubmit = 
    // Reset password on submit.
    /**
     * @return {?}
     */
    function () {
        // Check if passwords match
        this.resetPasswordMatch = true;
        if (this.resetCreds.newPassword !== this.resetCreds.confirmNewPassword) {
            this.resetPasswordMatch = false;
            return;
        }
        /* wenow haave this.resetCreds.
            var data = {
                user: this.username,
                newPassword: this.newPassword,
                confirmNewPassword: this.confirmNewPassword,
                authToken: this.authToken
            };

            // Controller used by reset password modal instance on success. The user is redirected to login page.
            this.resetPasswordSuccessController = ['$scope', '$uibModalInstance',
                function ($scope, $uibModalInstance) {
                    $scope.ok = function () {
                        $uibModalInstance.close();
                        window.location.href = '/';
                    };
                }
            ];
    */
        /*
        return this.authStrategy.resetPasswordFn(data).then(() => {
            this.message = this.$i18next.t("nwfjs:resetPasswordSucceed");
            this.success = true;

            //Show the modal with success message from the server.
            this.$uibModal.open({
                template: loginResetPasswordResultTemplate,
                scope: this,
                controller: this.resetPasswordSuccessController
            });
        }).catch(function (error) {
            this.message = this.$i18next.t("nwfjs:resetPasswordFailed");
            if (error != null) {
                this.message = error.message;
            }
            this.success = false;
            //Show the  modal with failure message from the server.

            this.$uibModal.open({
                template: loginResetPasswordResultTemplate,
                scope: this,
                controller: this.loginFailedController
            });
        });
        */
    };
    // Reset password on cancel.
    // Reset password on cancel.
    /**
     * @return {?}
     */
    LoginComponent.prototype.resetPasswordCancelFn = 
    // Reset password on cancel.
    /**
     * @return {?}
     */
    function () {
        window.location.href = document.location.origin;
    };
    LoginComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-login',
                    template: "\n    <div class=\"nwf-login-overlay\">\n    <div class=\"nwf-login-dialog\">\n    <header class=\"nwf-login-banner-logo\"></header>\n    <div class=\"nwf-login-body\">\n        <h2 class=\"nwf-login-dialog-title-primary\">{{appTitle}}</h2>\n        <h3 class=\"nwf-login-dialog-title-secondary\"></h3>\n        <h5>{{message}}</h5>\n        <!-- Login form -->\n        <form #authForm=\"ngForm\" (ngSubmit)=\"authForm.valid && authenticate()\" *ngIf=\"!forgotPasswordMode && !resetPasswordMode\"\n            id=\"nwf-login-form\" class=\"nwf-validatable\" [ngClass]=\"{'ng-submitted': authForm.submitted }\">\n            <div class=\"form-group l-username\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"creds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" autofocus required placeholder=\"{{'nwfjs:username' | i18next}}\">\n                    <div *ngIf=\"username.invalid && (authForm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" type=\"password\" name=\"password\" #password=\"ngModel\" [(ngModel)]=\"creds.password\"\n                        data-netapp-id=\"loginPage-password-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:password' | i18next}}\"\n                        required>\n                    <div *ngIf=\"password.invalid && (authForm.submitted || password.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group l-submit-btn mb-0\">\n                <button type=\"submit\" class=\"nwf-login-input nwf-login-submit btn btn-primary btn-lg\"\n                    data-netapp-id=\"loginPage-signIn-button\">\n                    <div>{{'nwfjs:signIn' | i18next}} <span class=\"loading position-absolute\" [hidden]=\"!inFlight\">{{loadingObs | async}}</span></div>\n                </button>\n            </div>\n            <p *ngIf=\"hasForgotPassword\" class=\"nwf-login-forgot\">\n                <a class=\"nwf-is-link-like\" (click)=\"this.forgotPasswordMode = !this.forgotPasswordMode\" data-netapp-id=\"loginPage-forgot-password-link\">{{'nwfjs:forgetPassword' | i18next}}</a>\n            </p>\n        </form>\n\n        <!-- Forgot Password Form -->\n        <form #forgotFrm=\"ngForm\" class=\"nwf-validatable\" *ngIf=\"forgotPasswordMode\" (ngSubmit)=\"forgotFrm.valid && forgotPasswordSubmit()\" [ngClass]=\"{'ng-submitted': forgotFrm.submitted }\">\n\n            <div class=\"nwf-forgot-password-title-panel\">\n                <div class=\"nwf-forgot-password-text\" data-netapp-id=\"loginPage-forgot-password-text\">\n                    <h4>{{'nwfjs:enterResetUsername' | i18next}}</h4>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"forgotCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:usernameToReset' | i18next}}\"\n                        required>\n                    <div *ngIf=\"username.invalid && (forgotFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n            <!-- Submit/Cancel for Forgot Password  -->\n            <div class=\"nwf-login-row\">\n                <div class=\"nwf-login-button-panel\">\n                    <button class=\"btn btn-primary mr-2\" data-netapp-id=\"forgotPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                    <button class=\"btn btn-secondary\" (click)=\"forgotPasswordMode = false\" data-netapp-id=\"forgotPassword-cancel-button\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n                </div>\n            </div>\n            </div>\n        </form>\n\n        <!-- Reset password Form -->\n        <form #resetFrm=\"ngForm\"  *ngIf=\"resetPasswordMode\" (ngSubmit)=\"resetFrm.valid && resetPasswordSubmit()\" [ngClass]=\"{'ng-submitted': resetFrm.submitted }\">\n\n            <dl>\n                <dt>{{'nwfjs:currentUsername' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" autocomplete=\"off\" [(ngModel)]=\"resetCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" title=\"{{'nwfjs:usernameCannotChange' | i18next}}\" required>\n                    <div *ngIf=\"username.invalid && (resetFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:newPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"newPassword\" #newPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.newPassword\" data-netapp-id=\"loginPage-new-password-input\" placeholder=\"{{'nwfjs:typeNewPassword' | i18next}}\" required>\n                    <div *ngIf=\"newPassword.invalid && (resetFrm.submitted || newPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:confirmNewPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"confirmNewPassword\" #confirmNewPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.confirmNewPassword\" name=\"confirmNewPassword\" data-netapp-id=\"loginPage-confirm-new-password-input\"\n                        placeholder=\"{{'nwfjs:typeNewPasswordAgain' | i18next}}\" required>\n                    <div *ngIf=\"confirmNewPassword.invalid && (resetFrm.submitted || confirmNewPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                    <div *ngIf=\"!resetPasswordMatch\" class=\"invalid-feedback\">\n                        {{'nwfjs:changePasswordNotMatch' | i18next}}\n                    </div>\n                </dd>\n            </dl>\n\n            <div class=\"nwf-login-button-panel\">\n                <button class=\"btn btn-primary mr-2\" data-netapp-id=\"resetPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                <button class=\"btn btn-secondary\" data-netapp-id=\"resetPassword-cancel-button\" (click)=\"resetPasswordCancelFn()\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n            </div>\n        </form>\n    </div>\n    <footer class=\"nwf-login-links\">\n        <!-- support -->\n        <a *ngIf=\"!isOemVendor\" [href]=\"supportHref\" target=\"_blank\">{{'nwfjs:netappSupport' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"supportHref\" target=\"_blank\">{{supportLabel}}</a> |\n        <!-- help -->\n        <span *ngIf=\"\"><a nwf-help showIcon=\"false\" class=\"nwf-is-link-like\">{{'nwfjs:help' | i18next}}</a> |</span>\n        <!-- home -->\n        <a *ngIf=\"!isOemVendor\" href=\"http://netapp.com\" target=\"_blank\">{{'nwfjs:netapp' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"homeHref\" target=\"_blank\">{{homeLabel}}</a>\n    </footer>\n    </div>\n</div>\n    ",
                    styles: ["nwf-login{width:100%;height:100%;top:0;background-repeat:no-repeat;background-size:cover;display:flex;justify-content:center;align-items:flex-start}.nwf-login-dialog{padding:40px 40px 25px}.l-username{margin-top:2rem}.l-submit-btn{margin-top:2.5rem}h2{font-size:26px;color:#131313}#nwf-login-form[ng-reflect-klass]{margin-top:20px}#nwf-login-form[ng-reflect-klass] dd{margin-bottom:1.2rem}.nwf-login-submit{position:relative}.nwf-login-banner-logo{background-image:url(data:image/png;base64,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);width:100%;background-repeat:no-repeat;height:24px;align-self:flex-start;margin-bottom:10px}.nwf-login-dialog-title-primary{font-size:24px;margin-top:0;margin-bottom:10px}.nwf-login-input{width:100%;margin:5px 0}.nwf-login-forgot{margin:5px 0;align-self:flex-end}.nwf-login-links{margin-top:10px;text-align:center}.nwf-login-overlay{width:100%;position:fixed;left:0;top:0;z-index:1049;height:100%}.nwf-login-button-panel{display:block;text-align:right}"]
                }] }
    ];
    /** @nocollapse */
    LoginComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
        { type: StateService },
        { type: NgbModal },
        { type: NwfTitleService }
    ]; };
    LoginComponent.propDecorators = {
        returnTo: [{ type: Input }],
        appTitle: [{ type: Input }],
        supportHref: [{ type: Input }],
        supportLabel: [{ type: Input }],
        helpHref: [{ type: Input }],
        helpLabel: [{ type: Input }],
        homeHref: [{ type: Input }],
        homeLabel: [{ type: Input }],
        showHelp: [{ type: Input }]
    };
    return LoginComponent;
}());
export { LoginComponent };
if (false) {
    /** @type {?} */
    LoginComponent.prototype.returnTo;
    /** @type {?} */
    LoginComponent.prototype.appTitle;
    /** @type {?} */
    LoginComponent.prototype.supportHref;
    /** @type {?} */
    LoginComponent.prototype.supportLabel;
    /** @type {?} */
    LoginComponent.prototype.helpHref;
    /** @type {?} */
    LoginComponent.prototype.helpLabel;
    /** @type {?} */
    LoginComponent.prototype.homeHref;
    /** @type {?} */
    LoginComponent.prototype.homeLabel;
    /** @type {?} */
    LoginComponent.prototype.showHelp;
    /** @type {?} */
    LoginComponent.prototype.isOemVendor;
    /** @type {?} */
    LoginComponent.prototype.homeVendorHref;
    /** @type {?} */
    LoginComponent.prototype.titleElement;
    /** @type {?} */
    LoginComponent.prototype.username;
    /** @type {?} */
    LoginComponent.prototype.password;
    /** @type {?} */
    LoginComponent.prototype.hasForgotPassword;
    /** @type {?} */
    LoginComponent.prototype.hasResetPassword;
    /** @type {?} */
    LoginComponent.prototype.forgotPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.newPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmNewPassword;
    /** @type {?} */
    LoginComponent.prototype.message;
    /** @type {?} */
    LoginComponent.prototype.success;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.authToken;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMatch;
    /** @type {?} */
    LoginComponent.prototype.cnter;
    /** @type {?} */
    LoginComponent.prototype.loadingObs;
    /** @type {?} */
    LoginComponent.prototype.errorCode;
    /** @type {?} */
    LoginComponent.prototype.inFlight;
    /** @type {?} */
    LoginComponent.prototype.creds;
    /** @type {?} */
    LoginComponent.prototype.resetCreds;
    /** @type {?} */
    LoginComponent.prototype.forgotCreds;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.titleService;
}
//# sourceMappingURL=data:application/json;base64,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