/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, HostListener, Inject, Input } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { StateService } from '@uirouter/angular';
import { LogoutFailedComponent } from './logout-failed.component';
var LogoutComponent = /** @class */ (function () {
    function LogoutComponent(NwfAuthService, modalService, $state) {
        this.NwfAuthService = NwfAuthService;
        this.modalService = modalService;
        this.$state = $state;
    }
    /**
     * @return {?}
     */
    LogoutComponent.prototype.logout = /**
     * @return {?}
     */
    function () {
        var _this = this;
        /** @type {?} */
        var showError = (/**
         * @param {?} error
         * @return {?}
         */
        function (error) {
            /** @type {?} */
            var errorCode = error.status;
            /** @type {?} */
            var failedMdl = _this.modalService.open(LogoutFailedComponent);
            failedMdl.componentInstance.errorCode = errorCode;
        });
        /** @type {?} */
        var returnToOriginalState = (/**
         * @return {?}
         */
        function () {
            _this.$state.go(_this.returnState);
        });
        return this.NwfAuthService.logout().then(returnToOriginalState).catch(showError);
    };
    /**
     * @return {?}
     */
    LogoutComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
    };
    LogoutComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-logout',
                    host: {
                        'class': 'dropdown-item',
                        'data-netapp-id': 'nav-logOut-link',
                    },
                    template: "\n{{'nwfjs:logout' | i18next}}\n  "
                }] }
    ];
    /** @nocollapse */
    LogoutComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
        { type: NgbModal },
        { type: StateService }
    ]; };
    LogoutComponent.propDecorators = {
        returnState: [{ type: Input }],
        logout: [{ type: HostListener, args: ['click',] }]
    };
    return LogoutComponent;
}());
export { LogoutComponent };
if (false) {
    /** @type {?} */
    LogoutComponent.prototype.returnState;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LogoutComponent.prototype.$state;
}
//# sourceMappingURL=data:application/json;base64,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