/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Inject, Injectable, Optional } from '@angular/core';
import { DOCUMENT, Title } from '@angular/platform-browser';
import { I18NextPipe } from 'angular-i18next';
import { APP_TITLE_ROOT } from '../../../tokens';
import * as i0 from "@angular/core";
import * as i1 from "angular-i18next";
import * as i2 from "@angular/platform-browser";
import * as i3 from "../../../tokens";
var NwfTitleService = /** @class */ (function (_super) {
    tslib_1.__extends(NwfTitleService, _super);
    function NwfTitleService(i18nextPipe, doc, appTitleRoot) {
        var _this = _super.call(this, doc) || this;
        _this.i18nextPipe = i18nextPipe;
        _this.appTitleRoot = appTitleRoot;
        _this.firstTitleSegment = _this.appTitleRoot || '';
        _this.sep = ' | ';
        return _this;
    }
    /**
     * @param {?} title
     * @return {?}
     */
    NwfTitleService.prototype.setTitle = /**
     * @param {?} title
     * @return {?}
     */
    function (title) {
        var _this = this;
        /** @type {?} */
        var titlesPipeSep = '';
        /** @type {?} */
        var titles = [];
        /* If I have a firstTitle, I push it on first */
        if (this.firstTitleSegment != '') {
            titles.push(this.firstTitleSegment);
        }
        /* If I am an array, I concatenate that array, otherwise I am a string and I just push it on */
        if (title instanceof Array) {
            titles = tslib_1.__spread(titles, title);
        }
        else {
            titles.push(title);
        }
        /* finally produce my pipe sep string, passing each over the i18next pipe so they can pass me i18n:keys */
        titlesPipeSep = titles.filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return item !== ''; })).map((/**
         * @param {?} item
         * @return {?}
         */
        function (item) {
            return _this.i18nextPipe.transform(item);
        })).join(this.sep);
        /* Call the regular super for setTitle, now we just have a normal string */
        return _super.prototype.setTitle.call(this, titlesPipeSep);
    };
    NwfTitleService.decorators = [
        { type: Injectable, args: [{
                    providedIn: 'root',
                },] }
    ];
    /** @nocollapse */
    NwfTitleService.ctorParameters = function () { return [
        { type: I18NextPipe },
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [APP_TITLE_ROOT,] }] }
    ]; };
    /** @nocollapse */ NwfTitleService.ngInjectableDef = i0.defineInjectable({ factory: function NwfTitleService_Factory() { return new NwfTitleService(i0.inject(i1.I18NextPipe), i0.inject(i2.DOCUMENT), i0.inject(i3.APP_TITLE_ROOT, 8)); }, token: NwfTitleService, providedIn: "root" });
    return NwfTitleService;
}(Title));
export { NwfTitleService };
if (false) {
    /** @type {?} */
    NwfTitleService.prototype.firstTitleSegment;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.sep;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.i18nextPipe;
    /**
     * @type {?}
     * @private
     */
    NwfTitleService.prototype.appTitleRoot;
}
//# sourceMappingURL=data:application/json;base64,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