import { OnChanges, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { I18NextPipe } from 'angular-i18next';
export declare class NwfFilterCriterionDateComponent implements OnChanges, ControlValueAccessor {
    operator: string;
    datetime: string;
    datetimeVisibleValue: Date;
    dateRangeList: {
        id: string;
        label: string;
    }[];
    private _onChange;
    constructor(i18NextPipe: I18NextPipe);
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param value
     */
    writeValue(value: any): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param newModelValue
     */
    onValueModelChange(newDateValue: any): void;
}
