#!/bin/sh
':' //; exec "$(command -v nodejs || command -v node)" "$0" "$@"

const [, , mode] = process.argv;
const isDevMode = mode == 'dev' || false;
const { readFileSync, writeFileSync, unlinkSync, existsSync } = require('fs');
const { execSync } = require('child_process');

const packFile = 'package.json';
const packLockFile = 'package-lock.json';
const parentPkg = loadJson(packFile);
const originalParentPkg = JSON.stringify(parentPkg);


//remove the package-lock file.
if (existsSync(packLockFile)) {
    unlinkSync(packLockFile);
}

let nwfMap = {
    "@netapp/nwfjs_angular_components": "../nwfjs/angular/dist",
    "@netapp/nwfjs_theme": "../nwfjs/theme/dist"
};
if("@netapp/nwfjs_angularjs_components" in parentPkg.dependencies){
    nwfMap["@netapp/nwfjs_angularjs_components"] = "../nwfjs/angularjs/dist";
}

let deps = parentPkg.dependencies;

//dev mode means we want to use the virtual path mappings above and npm install those local deps.
if (isDevMode) {
    console.log('##### DEV-MODE ######');
    Object.assign(deps, nwfMap);
    saveJson(packFile, parentPkg);
    console.log('### removing package-lock.json ###');
    if (existsSync(packLockFile)) {
        unlinkSync(packLockFile);
    }
}

//release mode means we are taking the versions from each package and stamping it in.
if (!isDevMode) {
    console.log('##### RELEASE-MODE #####');
    for (var depName in deps) {
        if (depName.startsWith('@netapp')) {
            if(deps[depName].indexOf('..') === -1){
                //we must have a stamped version. skip.
                continue;
            }
            //snarf the package and get the version from the symlink.
            let pckFile = deps[depName];
            const obj = loadJson(`${pckFile}/package.json`);
            let version = obj.version;
            deps[depName] = version;
        }
    }

    // Check if we changed anything
    if (JSON.stringify(parentPkg) !== originalParentPkg) {
        // Save the updated package.json
        saveJson(packFile, parentPkg);
        console.log('#### Updated package.json ####');
    }

    console.log('### removing package-lock.json after ###');
    if (existsSync(packLockFile)) {
        unlinkSync(packLockFile);
    }

    //npm install with real deps
    console.log('#### Bumping version number ####');
    execSync('npm version patch');
    console.log('#### Remember, run >npm i ####');
    console.log('You are now ready to p4 commit package-lock.json');

}


//helpers
function loadJson(filename) {
    const data = readFileSync(filename, { encoding: 'utf8' });
    return JSON.parse(data);
}

function saveJson(filename, data) {
    // If the package.json should have a particular format (e.g., tab or 4-space
    // indent), set it here.
    const text = JSON.stringify(data, null, '  ');
    writeFileSync(filename, text);
}
