"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
exports.DEFAULT_ERROR_CODE = 100;
exports.UNKNOWN_ERROR_CODE = 500;
exports.SOURCE = 'angular';
function _error(api, fn) {
    throw new Error('Could not find API ' + api + ', function ' + fn);
}
function getApiMember(api, func, apiName) {
    return api && api[func] || _error(apiName, func.toString());
}
// Manually check for Compiler CLI availability and supported version.
// This is needed because @ngtools/webpack does not depend directly on @angular/compiler-cli, since
// it is installed as part of global Angular CLI installs and compiler-cli is not of its
// dependencies.
function CompilerCliIsSupported() {
    let version;
    // Check that Angular is available.
    try {
        version = require('@angular/compiler-cli').VERSION;
    }
    catch (e) {
        throw new Error('The "@angular/compiler-cli" package was not properly installed. Error: ' + e);
    }
    // Check that Angular is also not part of this module's node_modules (it should be the project's).
    const compilerCliPath = require.resolve('@angular/compiler-cli');
    if (compilerCliPath.startsWith(path.dirname(__dirname))) {
        throw new Error('The @ngtools/webpack plugin now relies on the project @angular/compiler-cli. '
            + 'Please clean your node_modules and reinstall.');
    }
    // Throw if we're less than 5.x
    if (Number(version.major) < 5) {
        throw new Error('Version of @angular/compiler-cli needs to be 5.0.0 or greater. '
            + `Current version is "${version.full}".`);
    }
}
exports.CompilerCliIsSupported = CompilerCliIsSupported;
// These imports do not exist on a global install for Angular CLI, so we cannot use a static ES6
// import.
let compilerCli = null;
try {
    compilerCli = require('@angular/compiler-cli');
}
catch (_a) {
    // Don't throw an error if the private API does not exist.
    // Instead, the `CompilerCliIsSupported` method should return throw and indicate the
    // plugin cannot be used.
}
exports.VERSION = getApiMember(compilerCli, 'VERSION', 'compiler-cli');
exports.__NGTOOLS_PRIVATE_API_2 = getApiMember(compilerCli, '__NGTOOLS_PRIVATE_API_2', 'compiler-cli');
exports.readConfiguration = getApiMember(compilerCli, 'readConfiguration', 'compiler-cli');
// These imports do not exist on Angular versions lower than 5, so we cannot use a static ES6
// import.
let ngtools2 = null;
try {
    ngtools2 = require('@angular/compiler-cli/ngtools2');
}
catch (_b) {
    // Don't throw an error if the private API does not exist.
}
exports.createProgram = getApiMember(ngtools2, 'createProgram', 'ngtools2');
exports.createCompilerHost = getApiMember(ngtools2, 'createCompilerHost', 'ngtools2');
exports.formatDiagnostics = getApiMember(ngtools2, 'formatDiagnostics', 'ngtools2');
exports.EmitFlags = getApiMember(ngtools2, 'EmitFlags', 'ngtools2');
//# sourceMappingURL=data:application/json;base64,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