"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const semver = require("semver");
function default_1(options) {
    return (tree, context) => {
        const schematicsToRun = [];
        // Create the collection for the package.
        const collection = context.engine.createCollection(options.collection);
        for (const name of collection.listSchematicNames()) {
            const schematic = collection.createSchematic(name, true);
            const description = schematic.description;
            if (typeof description['version'] == 'string') {
                let version = description['version'];
                if (!version.match(/^\d{1,30}\.\d{1,30}\.\d{1,30}$/)) {
                    version += '.0';
                }
                if (!version.match(/^\d{1,30}\.\d{1,30}\.\d{1,30}$/)) {
                    version += '.0';
                }
                if (!semver.valid(version)) {
                    throw new schematics_1.SchematicsException(`Invalid migration version: ${JSON.stringify(description['version'])}`);
                }
                if (semver.gt(version, options.from) && semver.lte(version, options.to)) {
                    schematicsToRun.push({ name, version });
                }
            }
        }
        schematicsToRun.sort((a, b) => {
            const cmp = semver.compare(a.version, b.version);
            // Revert to comparing the names of the collection if the versions are equal.
            return cmp == 0 ? a.name.localeCompare(b.name) : cmp;
        });
        if (schematicsToRun.length > 0) {
            const rules = schematicsToRun.map(x => schematics_1.externalSchematic(options.collection, x.name, {}));
            return schematics_1.chain(rules);
        }
        return tree;
    };
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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