import { Component, ComponentFactoryResolver, Inject, Input, ReflectiveInjector, ViewChild, ViewContainerRef, } from '@angular/core';
import { filter, inArray, isFunction, NATIVE_INJECTOR_TOKEN, parse, ResolveContext, trace, UIRouter, unnestR, } from '@uirouter/core';
import { Ng2ViewConfig } from '../statebuilders/views';
import { MergeInjector } from '../mergeInjector';
/** @hidden */
var id = 0;
/**
 * Given a component class, gets the inputs of styles:
 *
 * - @Input('foo') _foo
 * - `inputs: ['foo']`
 *
 * @internalapi
 */
var ng2ComponentInputs = function (factory) {
    return factory.inputs.map(function (input) { return ({ prop: input.propName, token: input.templateName }); });
};
var ɵ0 = ng2ComponentInputs;
/**
 * A UI-Router viewport directive, which is filled in by a view (component) on a state.
 *
 * ### Selector
 *
 * A `ui-view` directive can be created as an element: `<ui-view></ui-view>` or as an attribute: `<div ui-view></div>`.
 *
 * ### Purpose
 *
 * This directive is used in a Component template (or as the root component) to create a viewport.  The viewport
 * is filled in by a view (as defined by a [[Ng2ViewDeclaration]] inside a [[Ng2StateDeclaration]]) when the view's
 * state has been activated.
 *
 * #### Example:
 * ```js
 * // This app has two states, 'foo' and 'bar'
 * stateRegistry.register({ name: 'foo', url: '/foo', component: FooComponent });
 * stateRegistry.register({ name: 'bar', url: '/bar', component: BarComponent });
 * ```
 * ```html
 * <!-- This ui-view will be filled in by the foo state's component or
 *      the bar state's component when the foo or bar state is activated -->
 * <ui-view></ui-view>
 * ```
 *
 * ### Named ui-views
 *
 * A `ui-view` may optionally be given a name via the attribute value: `<div ui-view='header'></div>`.  *Note:
 * an unnamed `ui-view` is internally named `$default`*.   When a `ui-view` has a name, it will be filled in
 * by a matching named view.
 *
 * #### Example:
 * ```js
 * stateRegistry.register({
 *   name: 'foo',
 *   url: '/foo',
 *   views: { header: HeaderComponent, $default: FooComponent });
 * ```
 * ```html
 * <!-- When 'foo' state is active, filled by HeaderComponent -->
 * <div ui-view="header"></div>
 *
 * <!-- When 'foo' state is active, filled by FooComponent -->
 * <ui-view></ui-view>
 * ```
 */
var UIView = /** @class */ (function () {
    function UIView(router, parent, viewContainerRef) {
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        /** Data about the this UIView */
        this._uiViewData = {};
        this._parent = parent;
    }
    Object.defineProperty(UIView.prototype, "_name", {
        set: function (val) {
            this.name = val;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UIView.prototype, "state", {
        /**
         * @returns the UI-Router `state` that is filling this uiView, or `undefined`.
         */
        get: /**
           * @returns the UI-Router `state` that is filling this uiView, or `undefined`.
           */
        function () {
            return parse('_uiViewData.config.viewDecl.$context.self')(this);
        },
        enumerable: true,
        configurable: true
    });
    UIView.prototype.ngOnInit = function () {
        var _this = this;
        var router = this.router;
        var parentFqn = this._parent.fqn;
        var name = this.name || '$default';
        this._uiViewData = {
            $type: 'ng2',
            id: id++,
            name: name,
            fqn: parentFqn ? parentFqn + '.' + name : name,
            creationContext: this._parent.context,
            configUpdated: this._viewConfigUpdated.bind(this),
            config: undefined,
        };
        this._deregisterUiCanExitHook = router.transitionService.onBefore({}, function (trans) {
            return _this._invokeUiCanExitHook(trans);
        });
        this._deregisterUiOnParamsChangedHook = router.transitionService.onSuccess({}, function (trans) {
            return _this._invokeUiOnParamsChangedHook(trans);
        });
        this._deregisterUIView = router.viewService.registerUIView(this._uiViewData);
    };
    /**
     * For each transition, checks the component loaded in the ui-view for:
     *
     * - has a uiCanExit() component hook
     * - is being exited
     *
     * If both are true, adds the uiCanExit component function as a hook to that singular Transition.
     */
    /**
       * For each transition, checks the component loaded in the ui-view for:
       *
       * - has a uiCanExit() component hook
       * - is being exited
       *
       * If both are true, adds the uiCanExit component function as a hook to that singular Transition.
       */
    UIView.prototype._invokeUiCanExitHook = /**
       * For each transition, checks the component loaded in the ui-view for:
       *
       * - has a uiCanExit() component hook
       * - is being exited
       *
       * If both are true, adds the uiCanExit component function as a hook to that singular Transition.
       */
    function (trans) {
        var instance = this._componentRef && this._componentRef.instance;
        var uiCanExitFn = instance && instance.uiCanExit;
        if (isFunction(uiCanExitFn)) {
            var state = this.state;
            if (trans.exiting().indexOf(state) !== -1) {
                trans.onStart({}, function () {
                    return uiCanExitFn.call(instance, trans);
                });
            }
        }
    };
    /**
     * For each transition, checks if any param values changed and notify component
     */
    /**
       * For each transition, checks if any param values changed and notify component
       */
    UIView.prototype._invokeUiOnParamsChangedHook = /**
       * For each transition, checks if any param values changed and notify component
       */
    function ($transition$) {
        var instance = this._componentRef && this._componentRef.instance;
        var uiOnParamsChanged = instance && instance.uiOnParamsChanged;
        if (isFunction(uiOnParamsChanged)) {
            var viewState = this.state;
            var resolveContext = new ResolveContext(this._uiViewData.config.path);
            var viewCreationTrans = resolveContext.getResolvable('$transition$').data;
            // Exit early if the $transition$ is the same as the view was created within.
            // Exit early if the $transition$ will exit the state the view is for.
            if ($transition$ === viewCreationTrans || $transition$.exiting().indexOf(viewState) !== -1)
                return;
            var toParams_1 = $transition$.params('to');
            var fromParams_1 = $transition$.params('from');
            var getNodeSchema = function (node) { return node.paramSchema; };
            var toSchema = $transition$
                .treeChanges('to')
                .map(getNodeSchema)
                .reduce(unnestR, []);
            var fromSchema_1 = $transition$
                .treeChanges('from')
                .map(getNodeSchema)
                .reduce(unnestR, []);
            // Find the to params that have different values than the from params
            var changedToParams = toSchema.filter(function (param) {
                var idx = fromSchema_1.indexOf(param);
                return idx === -1 || !fromSchema_1[idx].type.equals(toParams_1[param.id], fromParams_1[param.id]);
            });
            // Only trigger callback if a to param has changed or is new
            if (changedToParams.length) {
                var changedKeys_1 = changedToParams.map(function (x) { return x.id; });
                // Filter the params to only changed/new to params.  `$transition$.params()` may be used to get all params.
                var newValues = filter(toParams_1, function (val, key) { return changedKeys_1.indexOf(key) !== -1; });
                instance.uiOnParamsChanged(newValues, $transition$);
            }
        }
    };
    UIView.prototype._disposeLast = function () {
        if (this._componentRef)
            this._componentRef.destroy();
        this._componentRef = null;
    };
    UIView.prototype.ngOnDestroy = function () {
        if (this._deregisterUIView)
            this._deregisterUIView();
        if (this._deregisterUiCanExitHook)
            this._deregisterUiCanExitHook();
        if (this._deregisterUiOnParamsChangedHook)
            this._deregisterUiOnParamsChangedHook();
        this._deregisterUIView = this._deregisterUiCanExitHook = this._deregisterUiOnParamsChangedHook = null;
        this._disposeLast();
    };
    /**
     * The view service is informing us of an updated ViewConfig
     * (usually because a transition activated some state and its views)
     */
    /**
       * The view service is informing us of an updated ViewConfig
       * (usually because a transition activated some state and its views)
       */
    UIView.prototype._viewConfigUpdated = /**
       * The view service is informing us of an updated ViewConfig
       * (usually because a transition activated some state and its views)
       */
    function (config) {
        // The config may be undefined if there is nothing currently targeting this UIView.
        // Dispose the current component, if there is one
        if (!config)
            return this._disposeLast();
        // Only care about Ng2 configs
        if (!(config instanceof Ng2ViewConfig))
            return;
        // The "new" viewconfig is already applied, so exit early
        if (this._uiViewData.config === config)
            return;
        // This is a new ViewConfig.  Dispose the previous component
        this._disposeLast();
        trace.traceUIViewConfigUpdated(this._uiViewData, config && config.viewDecl.$context);
        this._applyUpdatedConfig(config);
        // Initiate change detection for the newly created component
        this._componentRef.changeDetectorRef.markForCheck();
    };
    UIView.prototype._applyUpdatedConfig = function (config) {
        this._uiViewData.config = config;
        // Create the Injector for the routed component
        var context = new ResolveContext(config.path);
        var componentInjector = this._getComponentInjector(context);
        // Get the component class from the view declaration. TODO: allow promises?
        var componentClass = config.viewDecl.component;
        // Create the component
        var compFactoryResolver = componentInjector.get(ComponentFactoryResolver);
        var compFactory = compFactoryResolver.resolveComponentFactory(componentClass);
        this._componentRef = this._componentTarget.createComponent(compFactory, undefined, componentInjector);
        // Wire resolves to @Input()s
        this._applyInputBindings(compFactory, this._componentRef.instance, context, componentClass);
    };
    /**
     * Creates a new Injector for a routed component.
     *
     * Adds resolve values to the Injector
     * Adds providers from the NgModule for the state
     * Adds providers from the parent Component in the component tree
     * Adds a PARENT_INJECT view context object
     *
     * @returns an Injector
     */
    /**
       * Creates a new Injector for a routed component.
       *
       * Adds resolve values to the Injector
       * Adds providers from the NgModule for the state
       * Adds providers from the parent Component in the component tree
       * Adds a PARENT_INJECT view context object
       *
       * @returns an Injector
       */
    UIView.prototype._getComponentInjector = /**
       * Creates a new Injector for a routed component.
       *
       * Adds resolve values to the Injector
       * Adds providers from the NgModule for the state
       * Adds providers from the parent Component in the component tree
       * Adds a PARENT_INJECT view context object
       *
       * @returns an Injector
       */
    function (context) {
        // Map resolves to "useValue: providers"
        var resolvables = context
            .getTokens()
            .map(function (token) { return context.getResolvable(token); })
            .filter(function (r) { return r.resolved; });
        var newProviders = resolvables.map(function (r) { return ({ provide: r.token, useValue: context.injector().get(r.token) }); });
        var parentInject = { context: this._uiViewData.config.viewDecl.$context, fqn: this._uiViewData.fqn };
        newProviders.push({ provide: UIView.PARENT_INJECT, useValue: parentInject });
        var parentComponentInjector = this.viewContainerRef.injector;
        var moduleInjector = context.getResolvable(NATIVE_INJECTOR_TOKEN).data;
        var mergedParentInjector = new MergeInjector(moduleInjector, parentComponentInjector);
        return ReflectiveInjector.resolveAndCreate(newProviders, mergedParentInjector);
    };
    /**
     * Supplies component inputs with resolve data
     *
     * Finds component inputs which match resolves (by name) and sets the input value
     * to the resolve data.
     */
    /**
       * Supplies component inputs with resolve data
       *
       * Finds component inputs which match resolves (by name) and sets the input value
       * to the resolve data.
       */
    UIView.prototype._applyInputBindings = /**
       * Supplies component inputs with resolve data
       *
       * Finds component inputs which match resolves (by name) and sets the input value
       * to the resolve data.
       */
    function (factory, component, context, componentClass) {
        var bindings = this._uiViewData.config.viewDecl['bindings'] || {};
        var explicitBoundProps = Object.keys(bindings);
        // Returns the actual component property for a renamed an input renamed using `@Input('foo') _foo`.
        // return the `_foo` property
        var renamedInputProp = function (prop) {
            var input = factory.inputs.find(function (i) { return i.templateName === prop; });
            return (input && input.propName) || prop;
        };
        // Supply resolve data to component as specified in the state's `bindings: {}`
        var explicitInputTuples = explicitBoundProps.reduce(function (acc, key) { return acc.concat([{ prop: renamedInputProp(key), token: bindings[key] }]); }, []);
        // Supply resolve data to matching @Input('prop') or inputs: ['prop']
        var implicitInputTuples = ng2ComponentInputs(factory).filter(function (tuple) { return !inArray(explicitBoundProps, tuple.prop); });
        var addResolvable = function (tuple) {
            return ({
                prop: tuple.prop,
                resolvable: context.getResolvable(tuple.token),
            });
        };
        var injector = context.injector();
        explicitInputTuples
            .concat(implicitInputTuples)
            .map(addResolvable)
            .filter(function (tuple) { return tuple.resolvable && tuple.resolvable.resolved; })
            .forEach(function (tuple) {
            component[tuple.prop] = injector.get(tuple.resolvable.token);
        });
    };
    UIView.PARENT_INJECT = 'UIView.PARENT_INJECT';
    UIView.decorators = [
        { type: Component, args: [{
                    selector: 'ui-view, [ui-view]',
                    exportAs: 'uiView',
                    template: "\n    <ng-template #componentTarget></ng-template>\n    <ng-content *ngIf=\"!_componentRef\"></ng-content>\n  ",
                },] },
    ];
    /** @nocollapse */
    UIView.ctorParameters = function () { return [
        { type: UIRouter, },
        { type: undefined, decorators: [{ type: Inject, args: [UIView.PARENT_INJECT,] },] },
        { type: ViewContainerRef, },
    ]; };
    UIView.propDecorators = {
        "_componentTarget": [{ type: ViewChild, args: ['componentTarget', { read: ViewContainerRef },] },],
        "name": [{ type: Input, args: ['name',] },],
        "_name": [{ type: Input, args: ['ui-view',] },],
    };
    return UIView;
}());
export { UIView };
export { ɵ0 };
//# sourceMappingURL=uiView.js.map