/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
export class MapChart {
    /**
     * @param {?=} options
     */
    constructor(options = { series: [] }) {
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * @param {?} el
     * @return {?}
     */
    init(el) {
        if (!this.ref) {
            Highcharts.mapChart(el.nativeElement, this.options, chart => {
                this.refSubject.next(chart);
                this.ref = chart;
                this.refSubject.complete();
            });
        }
    }
    /**
     * @return {?}
     */
    destroy() {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    }
}
if (false) {
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.refSubject;
    /** @type {?} */
    MapChart.prototype.ref$;
    /** @type {?} */
    MapChart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,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