/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
var /**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
MapChart = /** @class */ (function () {
    function MapChart(options) {
        if (options === void 0) { options = { series: [] }; }
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * @param {?} el
     * @return {?}
     */
    MapChart.prototype.init = /**
     * @param {?} el
     * @return {?}
     */
    function (el) {
        var _this = this;
        if (!this.ref) {
            Highcharts.mapChart(el.nativeElement, this.options, function (chart) {
                _this.refSubject.next(chart);
                _this.ref = chart;
                _this.refSubject.complete();
            });
        }
    };
    /**
     * @return {?}
     */
    MapChart.prototype.destroy = /**
     * @return {?}
     */
    function () {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    };
    return MapChart;
}());
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
export { MapChart };
if (false) {
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.refSubject;
    /** @type {?} */
    MapChart.prototype.ref$;
    /** @type {?} */
    MapChart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFwY2hhcnQuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9hbmd1bGFyLWhpZ2hjaGFydHMvIiwic291cmNlcyI6WyJsaWIvbWFwY2hhcnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUNBLE9BQU8sS0FBSyxVQUFVLE1BQU0sWUFBWSxDQUFDO0FBRXpDLE9BQU8sRUFBRSxZQUFZLEVBQWMsTUFBTSxNQUFNLENBQUM7Ozs7Ozs7OztBQVVoRDs7Ozs7Ozs7O0lBS0Usa0JBQW9CLE9BQTBDO1FBQTFDLHdCQUFBLEVBQUEsWUFBOEIsTUFBTSxFQUFFLEVBQUUsRUFBRTtRQUExQyxZQUFPLEdBQVAsT0FBTyxDQUFtQztRQUp0RCxlQUFVLEdBQWlDLElBQUksWUFBWSxFQUFFLENBQUM7UUFDdEUsU0FBSSxHQUErQixJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRSxDQUFDO0lBR0QsQ0FBQzs7Ozs7SUFFbEUsdUJBQUk7Ozs7SUFBSixVQUFLLEVBQWM7UUFBbkIsaUJBUUM7UUFQQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRTtZQUNiLFVBQVUsQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQUEsS0FBSztnQkFDdkQsS0FBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQzVCLEtBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO2dCQUNqQixLQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQzdCLENBQUMsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDOzs7O0lBRUQsMEJBQU87OztJQUFQO1FBQ0UsSUFBSSxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ1osSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQztZQUNoQyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxDQUFDO1lBQ25CLElBQUksQ0FBQyxHQUFHLEdBQUcsU0FBUyxDQUFDO1lBRXJCLG1CQUFtQjtZQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7WUFDckMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRSxDQUFDO1NBQzVDO0lBQ0gsQ0FBQztJQUNILGVBQUM7QUFBRCxDQUFDLEFBNUJELElBNEJDOzs7Ozs7Ozs7Ozs7Ozs7SUEzQkMsOEJBQXNFOztJQUN0RSx3QkFBa0U7O0lBQ2xFLHVCQUFvQjs7Ozs7SUFFUiwyQkFBa0QiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBFbGVtZW50UmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgKiBhcyBIaWdoY2hhcnRzIGZyb20gJ2hpZ2hjaGFydHMnO1xuaW1wb3J0ICogYXMgSGlnaG1hcHMgZnJvbSAnaGlnaGNoYXJ0cy9oaWdobWFwcy5zcmMnO1xuaW1wb3J0IHsgQXN5bmNTdWJqZWN0LCBPYnNlcnZhYmxlIH0gZnJvbSAncnhqcyc7XG5cbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBGZWxpeCBJdHplbnBsaXR6LiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0XG4gKiBodHRwczovL2dpdGh1Yi5jb20vY2Vib3IvYW5ndWxhci1oaWdoY2hhcnRzL2Jsb2IvbWFzdGVyL0xJQ0VOU0VcbiAqL1xuZXhwb3J0IGNsYXNzIE1hcENoYXJ0IHtcbiAgcHJpdmF0ZSByZWZTdWJqZWN0OiBBc3luY1N1YmplY3Q8SGlnaG1hcHMuQ2hhcnQ+ID0gbmV3IEFzeW5jU3ViamVjdCgpO1xuICByZWYkOiBPYnNlcnZhYmxlPEhpZ2htYXBzLkNoYXJ0PiA9IHRoaXMucmVmU3ViamVjdC5hc09ic2VydmFibGUoKTtcbiAgcmVmOiBIaWdobWFwcy5DaGFydDtcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIG9wdGlvbnM6IEhpZ2htYXBzLk9wdGlvbnMgPSB7IHNlcmllczogW10gfSkge31cblxuICBpbml0KGVsOiBFbGVtZW50UmVmKTogdm9pZCB7XG4gICAgaWYgKCF0aGlzLnJlZikge1xuICAgICAgSGlnaGNoYXJ0cy5tYXBDaGFydChlbC5uYXRpdmVFbGVtZW50LCB0aGlzLm9wdGlvbnMsIGNoYXJ0ID0+IHtcbiAgICAgICAgdGhpcy5yZWZTdWJqZWN0Lm5leHQoY2hhcnQpO1xuICAgICAgICB0aGlzLnJlZiA9IGNoYXJ0O1xuICAgICAgICB0aGlzLnJlZlN1YmplY3QuY29tcGxldGUoKTtcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxuXG4gIGRlc3Ryb3koKSB7XG4gICAgaWYgKHRoaXMucmVmKSB7XG4gICAgICB0aGlzLm9wdGlvbnMgPSB0aGlzLnJlZi5vcHRpb25zO1xuICAgICAgdGhpcy5yZWYuZGVzdHJveSgpO1xuICAgICAgdGhpcy5yZWYgPSB1bmRlZmluZWQ7XG5cbiAgICAgIC8vIG5ldyBpbml0IHN1YmplY3RcbiAgICAgIHRoaXMucmVmU3ViamVjdCA9IG5ldyBBc3luY1N1YmplY3QoKTtcbiAgICAgIHRoaXMucmVmJCA9IHRoaXMucmVmU3ViamVjdC5hc09ic2VydmFibGUoKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==