import { Inject, Injectable, InjectionToken, NgModule, Pipe } from '@angular/core';
import { addResource, addResourceBundle, addResources, changeLanguage, dir, exists, format, getFixedT, getResource, getResourceBundle, hasResourceBundle, init, language, languages, loadNamespaces, on, options, reloadResources, removeResourceBundle, setDefaultNamespace, t, use } from 'i18next/index';
import * as i18next from 'i18next/index';
import { BehaviorSubject, Subject } from 'rxjs';
import { DOCUMENT, Title } from '@angular/platform-browser';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NEXT_SCOPE = new InjectionToken('I18NEXT_SCOPE');
var I18NEXT_NAMESPACE = new InjectionToken('I18NEXT_NAMESPACE');
var I18NEXT_SERVICE = new InjectionToken('I18NEXT_SERVICE');
var I18NEXT_NAMESPACE_RESOLVER = new InjectionToken('I18NEXT_NAMESPACE_RESOLVER');
var I18NEXT_ERROR_HANDLING_STRATEGY = new InjectionToken('I18NEXT_ERROR_HANDLING_STRATEGY');

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NextPipe = /** @class */ (function () {
    function I18NextPipe(translateI18Next, ns, scope) {
        this.translateI18Next = translateI18Next;
        this.ns = ns;
        this.scope = scope;
    }
    /**
     * @param {?} key
     * @param {?=} options
     * @return {?}
     */
    I18NextPipe.prototype.transform = /**
     * @param {?} key
     * @param {?=} options
     * @return {?}
     */
    function (key, options$$1) {
        options$$1 = this.prepareOptions(options$$1);
        var /** @type {?} */ i18nOpts = this.translateI18Next.options;
        if (options$$1.prependScope === undefined || options$$1.prependScope === true) {
            if (this.scope) {
                key = this.prependScope(key, this.scope, i18nOpts.keySeparator, i18nOpts.nsSeparator);
            }
        }
        if (options$$1.prependNamespace === undefined || options$$1.prependNamespace === true) {
            if (this.ns) {
                key = this.prependNamespace(key, this.ns, i18nOpts.nsSeparator);
            }
        }
        var /** @type {?} */ result = this.translateI18Next.t(key, options$$1);
        if (options$$1.format) {
            if (result) {
                result = this.translateI18Next
                    .format(result, options$$1.format, this.translateI18Next.language);
            }
        }
        return result;
    };
    /**
     * @param {?} key
     * @param {?} scope
     * @param {?} keySeparator
     * @param {?} nsSeparator
     * @return {?}
     */
    I18NextPipe.prototype.prependScope = /**
     * @param {?} key
     * @param {?} scope
     * @param {?} keySeparator
     * @param {?} nsSeparator
     * @return {?}
     */
    function (key, scope, keySeparator, nsSeparator) {
        var _this = this;
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (scope) === 'string') {
            scope = [scope];
        }
        var /** @type {?} */ keysWithScope = [];
        var _loop_1 = function (i) {
            var /** @type {?} */ k = key[i];
            if (!this_1.keyContainsNsSeparator(k, nsSeparator)) {
                // Do not set scope, if key contains a namespace
                keysWithScope.push.apply(// Do not set scope, if key contains a namespace
                keysWithScope, scope.map(function (sc) { return _this.joinStrings(keySeparator, sc, k); }));
            }
            keysWithScope.push(k);
        };
        var this_1 = this;
        for (var /** @type {?} */ i = 0; i < key.length; i++) {
            _loop_1(i);
        }
        return keysWithScope;
    };
    /**
     * @param {?} key
     * @param {?} ns
     * @param {?} nsSeparator
     * @return {?}
     */
    I18NextPipe.prototype.prependNamespace = /**
     * @param {?} key
     * @param {?} ns
     * @param {?} nsSeparator
     * @return {?}
     */
    function (key, ns, nsSeparator) {
        var _this = this;
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (ns) === 'string') {
            ns = [ns];
        }
        var /** @type {?} */ keysWithNamespace = [];
        var _loop_2 = function (i) {
            var /** @type {?} */ k = key[i];
            if (!this_2.keyContainsNsSeparator(k, nsSeparator)) {
                // Do not set namespace, if key contains a namespace
                keysWithNamespace.push.apply(// Do not set namespace, if key contains a namespace
                keysWithNamespace, ns.map(function (n) { return _this.joinStrings(nsSeparator, n, k); }));
            }
            keysWithNamespace.push(k);
        };
        var this_2 = this;
        for (var /** @type {?} */ i = 0; i < key.length; i++) {
            _loop_2(i);
        }
        return keysWithNamespace;
    };
    /**
     * @param {?} separator
     * @param {...?} str
     * @return {?}
     */
    I18NextPipe.prototype.joinStrings = /**
     * @param {?} separator
     * @param {...?} str
     * @return {?}
     */
    function (separator) {
        var str = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            str[_i - 1] = arguments[_i];
        }
        return str.slice().join(separator);
    };
    /**
     * @param {?} key
     * @param {?} nsSeparator
     * @return {?}
     */
    I18NextPipe.prototype.keyContainsNsSeparator = /**
     * @param {?} key
     * @param {?} nsSeparator
     * @return {?}
     */
    function (key, nsSeparator) {
        return key.indexOf(nsSeparator) !== -1;
    };
    /**
     * @param {?} options
     * @return {?}
     */
    I18NextPipe.prototype.prepareOptions = /**
     * @param {?} options
     * @return {?}
     */
    function (options$$1) {
        options$$1 = options$$1 || {};
        if (options$$1.context != null)
            options$$1.context = options$$1.context.toString();
        return options$$1;
    };
    I18NextPipe.decorators = [
        { type: Injectable },
        { type: Pipe, args: [{
                    name: 'i18next'
                },] },
    ];
    /** @nocollapse */
    I18NextPipe.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_SERVICE,] }] },
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_NAMESPACE,] }] },
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_SCOPE,] }] }
    ]; };
    return I18NextPipe;
}());

var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NextCapPipe = /** @class */ (function (_super) {
    __extends(I18NextCapPipe, _super);
    function I18NextCapPipe(translateI18Next, ns, scope) {
        return _super.call(this, translateI18Next, ns, scope) || this;
    }
    /**
     * @param {?} key
     * @param {?=} options
     * @return {?}
     */
    I18NextCapPipe.prototype.transform = /**
     * @param {?} key
     * @param {?=} options
     * @return {?}
     */
    function (key, options$$1) {
        options$$1 = options$$1 || {};
        options$$1.format = 'cap';
        return _super.prototype.transform.call(this, key, options$$1);
    };
    I18NextCapPipe.decorators = [
        { type: Injectable },
        { type: Pipe, args: [{
                    name: 'i18nextCap'
                },] },
    ];
    /** @nocollapse */
    I18NextCapPipe.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_SERVICE,] }] },
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_NAMESPACE,] }] },
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_SCOPE,] }] }
    ]; };
    return I18NextCapPipe;
}(I18NextPipe));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @record
 */

var NativeErrorHandlingStrategy = /** @class */ (function () {
    function NativeErrorHandlingStrategy() {
    }
    /**
     * @param {?} resolve
     * @param {?} reject
     * @return {?}
     */
    NativeErrorHandlingStrategy.prototype.handle = /**
     * @param {?} resolve
     * @param {?} reject
     * @return {?}
     */
    function (resolve, reject) {
        return function (err, t$$1) {
            var /** @type {?} */ result = {
                err: err,
                t: t$$1
            };
            resolve(result);
        };
    };
    return NativeErrorHandlingStrategy;
}());
var StrictErrorHandlingStrategy = /** @class */ (function () {
    function StrictErrorHandlingStrategy() {
    }
    /**
     * @param {?} resolve
     * @param {?} reject
     * @return {?}
     */
    StrictErrorHandlingStrategy.prototype.handle = /**
     * @param {?} resolve
     * @param {?} reject
     * @return {?}
     */
    function (resolve, reject) {
        return function (err, t$$1) {
            var /** @type {?} */ result = {
                err: err,
                t: t$$1
            };
            if (!err) {
                resolve(result);
                return;
            }
            reject(err);
        };
    };
    return StrictErrorHandlingStrategy;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NextFormatPipe = /** @class */ (function () {
    function I18NextFormatPipe(translateI18Next) {
        this.translateI18Next = translateI18Next;
    }
    /**
     * @param {?} value
     * @param {?} options
     * @return {?}
     */
    I18NextFormatPipe.prototype.transform = /**
     * @param {?} value
     * @param {?} options
     * @return {?}
     */
    function (value, options$$1) {
        var /** @type {?} */ opts = typeof (options$$1) === 'string' ? { format: options$$1 } : options$$1;
        return this.translateI18Next.format(value, opts.format, opts.lng);
    };
    I18NextFormatPipe.decorators = [
        { type: Injectable },
        { type: Pipe, args: [{
                    name: 'i18nextFormat'
                },] },
    ];
    /** @nocollapse */
    I18NextFormatPipe.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_SERVICE,] }] }
    ]; };
    return I18NextFormatPipe;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NextEvents = /** @class */ (function () {
    function I18NextEvents() {
        this.initialized = new BehaviorSubject(false);
        this.loaded = new BehaviorSubject(false);
        this.failedLoading = new Subject();
        this.missingKey = new Subject();
        this.added = new Subject();
        this.removed = new Subject();
        this.languageChanged = new BehaviorSubject(null);
    }
    return I18NextEvents;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NextService = /** @class */ (function () {
    function I18NextService(errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.events = new I18NextEvents();
        this.language = '';
        this.languages = [];
    }
    Object.defineProperty(I18NextService.prototype, "options", {
        get: /**
         * @return {?}
         */
        function () {
            return options;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @param {?} plugin
     * @return {?}
     */
    I18NextService.prototype.use = /**
     * @param {?} plugin
     * @return {?}
     */
    function (plugin) {
        use.call(i18next, plugin);
        return this;
    };
    /**
     * @param {?=} options
     * @return {?}
     */
    I18NextService.prototype.init = /**
     * @param {?=} options
     * @return {?}
     */
    function (options$$1) {
        var _this = this;
        options$$1 = options$$1 || {};
        this.subscribeEvents();
        return this.i18nextPromise =
            new Promise(function (resolve, reject) {
                init.call(i18next, Object.assign({}, options$$1), _this.errorHandlingStrategy.handle(resolve, reject));
            });
    };
    /**
     * @param {?} key
     * @param {?=} options
     * @return {?}
     */
    I18NextService.prototype.t = /**
     * @param {?} key
     * @param {?=} options
     * @return {?}
     */
    function (key, options$$1) {
        options$$1 = options$$1 || {};
        return t.call(i18next, /** @type {?} */ (key), options$$1);
    };
    /**
     * @param {?} value
     * @param {?} format
     * @param {?} lng
     * @return {?}
     */
    I18NextService.prototype.format = /**
     * @param {?} value
     * @param {?} format
     * @param {?} lng
     * @return {?}
     */
    function (value, format$$1, lng) {
        return format.call(i18next, value, format$$1, lng);
    };
    /**
     * @param {?} key
     * @param {?} options
     * @return {?}
     */
    I18NextService.prototype.exists = /**
     * @param {?} key
     * @param {?} options
     * @return {?}
     */
    function (key, options$$1) {
        return exists.call(i18next, key, options$$1);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    I18NextService.prototype.getFixedT = /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    function (lng, ns) {
        return getFixedT.call(i18next, lng, ns);
    };
    /**
     * @param {?} ns
     * @return {?}
     */
    I18NextService.prototype.setDefaultNamespace = /**
     * @param {?} ns
     * @return {?}
     */
    function (ns) {
        setDefaultNamespace.call(i18next, ns);
    };
    /**
     * @param {?=} lng
     * @return {?}
     */
    I18NextService.prototype.dir = /**
     * @param {?=} lng
     * @return {?}
     */
    function (lng) {
        if (lng === void 0) { lng = undefined; }
        return dir.call(i18next, lng);
    };
    /**
     * @param {?} lng
     * @return {?}
     */
    I18NextService.prototype.changeLanguage = /**
     * @param {?} lng
     * @return {?}
     */
    function (lng) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            changeLanguage.call(i18next, lng, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    /**
     * @param {?} namespaces
     * @return {?}
     */
    I18NextService.prototype.loadNamespaces = /**
     * @param {?} namespaces
     * @return {?}
     */
    function (namespaces) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            loadNamespaces.call(i18next, namespaces, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    /**
     * @param {?} lngs
     * @param {?} callback
     * @return {?}
     */
    I18NextService.prototype.loadLanguages = /**
     * @param {?} lngs
     * @param {?} callback
     * @return {?}
     */
    function (lngs, callback) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            loadNamespaces.call(i18next, lngs, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    /**
     * @param {...?} params
     * @return {?}
     */
    I18NextService.prototype.reloadResources = /**
     * @param {...?} params
     * @return {?}
     */
    function () {
        var params = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            params[_i] = arguments[_i];
        }
        reloadResources.apply(i18next, params);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} key
     * @param {?} options
     * @return {?}
     */
    I18NextService.prototype.getResource = /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} key
     * @param {?} options
     * @return {?}
     */
    function (lng, ns, key, options$$1) {
        return getResource.call(i18next, lng, ns, key, options$$1);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} key
     * @param {?} value
     * @param {?} options
     * @return {?}
     */
    I18NextService.prototype.addResource = /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} key
     * @param {?} value
     * @param {?} options
     * @return {?}
     */
    function (lng, ns, key, value, options$$1) {
        addResource.call(i18next, lng, ns, key, value, options$$1);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} resources
     * @return {?}
     */
    I18NextService.prototype.addResources = /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} resources
     * @return {?}
     */
    function (lng, ns, resources) {
        addResources.call(i18next, lng, ns, resources);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} resources
     * @param {?} deep
     * @param {?} overwrite
     * @return {?}
     */
    I18NextService.prototype.addResourceBundle = /**
     * @param {?} lng
     * @param {?} ns
     * @param {?} resources
     * @param {?} deep
     * @param {?} overwrite
     * @return {?}
     */
    function (lng, ns, resources, deep, overwrite) {
        addResourceBundle.call(i18next, lng, ns, resources, deep, overwrite);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    I18NextService.prototype.hasResourceBundle = /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    function (lng, ns) {
        return hasResourceBundle.call(i18next, lng, ns);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    I18NextService.prototype.getResourceBundle = /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    function (lng, ns) {
        return getResourceBundle.call(i18next, lng, ns);
    };
    /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    I18NextService.prototype.removeResourceBundle = /**
     * @param {?} lng
     * @param {?} ns
     * @return {?}
     */
    function (lng, ns) {
        removeResourceBundle.call(i18next, lng, ns);
    };
    /**
     * @return {?}
     */
    I18NextService.prototype.subscribeEvents = /**
     * @return {?}
     */
    function () {
        var _this = this;
        on.call(i18next, 'initialized', function (options$$1) {
            _this.language = language;
            _this.languages = languages;
            _this.events.initialized.next(options$$1);
        });
        on.call(i18next, 'loaded', function (loaded) { return _this.events.loaded.next(loaded); });
        on.call(i18next, 'failedLoading', function (lng, ns, msg) { return _this.events.failedLoading.next({ lng: lng, ns: ns, msg: msg }); });
        on.call(i18next, 'languageChanged', function (lng) {
            _this.language = language;
            _this.languages = languages;
            _this.events.languageChanged.next(lng);
        });
        on.call(i18next, 'missingKey', function (lngs, namespace, key, res) { return _this.events.missingKey.next({ lngs: lngs, namespace: namespace, key: key, res: res }); });
        on.call(i18next, 'added', function (lng, ns) { return _this.events.added.next({ lng: lng, ns: ns }); });
        on.call(i18next, 'removed', function (lng, ns) { return _this.events.removed.next({ lng: lng, ns: ns }); });
    };
    I18NextService.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    I18NextService.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [I18NEXT_ERROR_HANDLING_STRATEGY,] }] }
    ]; };
    return I18NextService;
}());

var __extends$1 = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var I18NextTitle = /** @class */ (function (_super) {
    __extends$1(I18NextTitle, _super);
    function I18NextTitle(i18nextPipe, doc) {
        var _this = _super.call(this, doc) || this;
        _this.i18nextPipe = i18nextPipe;
        return _this;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    I18NextTitle.prototype.setTitle = /**
     * @param {?} value
     * @return {?}
     */
    function (value) {
        return _super.prototype.setTitle.call(this, this.translate(value));
    };
    /**
     * @param {?} text
     * @return {?}
     */
    I18NextTitle.prototype.translate = /**
     * @param {?} text
     * @return {?}
     */
    function (text) {
        return this.i18nextPipe.transform(text, { format: 'cap' });
    };
    I18NextTitle.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    I18NextTitle.ctorParameters = function () { return [
        { type: I18NextPipe },
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] }
    ]; };
    return I18NextTitle;
}(Title));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param {?} activatedRouteSnapshot
 * @param {?} routerStateSnapshot
 * @return {?}
 */
function resolver(activatedRouteSnapshot, routerStateSnapshot) {
    var /** @type {?} */ namespaces = [];
    namespaces = activatedRouteSnapshot.data && activatedRouteSnapshot.data.i18nextNamespaces || namespaces;
    return this.loadNamespaces(namespaces.filter(function (n) { return n; }));
}
/**
 * @param {?} i18next
 * @return {?}
 */
function i18nextNamespaceResolverFactory(i18next$$1) {
    return resolver.bind(i18next$$1);
}
var I18NextModule = /** @class */ (function () {
    function I18NextModule() {
    }
    /**
     * @param {?=} params
     * @return {?}
     */
    I18NextModule.forRoot = /**
     * @param {?=} params
     * @return {?}
     */
    function (params) {
        if (params === void 0) { params = {}; }
        return {
            ngModule: I18NextModule,
            providers: [
                {
                    provide: I18NEXT_SERVICE,
                    useClass: I18NextService
                },
                {
                    provide: I18NEXT_ERROR_HANDLING_STRATEGY,
                    useClass: params.errorHandlingStrategy || NativeErrorHandlingStrategy
                },
                I18NextService,
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle,
                {
                    provide: I18NEXT_NAMESPACE_RESOLVER,
                    useFactory: i18nextNamespaceResolverFactory,
                    deps: [I18NEXT_SERVICE]
                }
            ]
        };
    };
    /**
     * @param {?=} customFormat
     * @return {?}
     */
    I18NextModule.interpolationFormat = /**
     * @param {?=} customFormat
     * @return {?}
     */
    function (customFormat) {
        if (customFormat === void 0) { customFormat = null; }
        /**
         * @param {?} value
         * @param {?} format
         * @param {?} lng
         * @return {?}
         */
        function formatDelegate(value, format$$1, lng) {
            var /** @type {?} */ formatedValue = defaultInterpolationFormat(value, format$$1, lng);
            if (customFormat === null)
                return formatedValue;
            return customFormat(formatedValue, format$$1, lng);
        }
        return formatDelegate;
    };
    I18NextModule.decorators = [
        { type: NgModule, args: [{
                    providers: [
                        {
                            provide: I18NEXT_NAMESPACE,
                            useValue: ''
                        },
                        {
                            provide: I18NEXT_SCOPE,
                            useValue: ''
                        },
                        I18NextPipe,
                        I18NextCapPipe,
                        I18NextFormatPipe,
                        I18NextTitle
                    ],
                    declarations: [
                        I18NextPipe,
                        I18NextCapPipe,
                        I18NextFormatPipe
                    ],
                    exports: [
                        I18NextPipe,
                        I18NextCapPipe,
                        I18NextFormatPipe
                    ]
                },] },
    ];
    return I18NextModule;
}());
/**
 * @param {?} value
 * @param {?} format
 * @param {?=} lng
 * @return {?}
 */
function defaultInterpolationFormat(value, format$$1, lng) {
    if (lng === void 0) { lng = undefined; }
    if (!value)
        return value;
    switch (format$$1) {
        case 'upper':
        case 'uppercase':
            return value.toUpperCase();
        case 'lower':
        case 'lowercase':
            return value.toLowerCase();
        case 'cap':
        case 'capitalize':
            return value.charAt(0).toUpperCase() + value.slice(1);
        case null:
        case undefined:
        case 'none':
        default:
            return value;
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Generated bundle index. Do not edit.
 */

export { resolver, i18nextNamespaceResolverFactory, I18NextModule, defaultInterpolationFormat, I18NEXT_SCOPE, I18NEXT_NAMESPACE, I18NEXT_SERVICE, I18NEXT_NAMESPACE_RESOLVER, I18NEXT_ERROR_HANDLING_STRATEGY, I18NextPipe, I18NextCapPipe, I18NextFormatPipe, I18NextService, I18NextTitle, NativeErrorHandlingStrategy, StrictErrorHandlingStrategy };
//# sourceMappingURL=angular-i18next.es5.js.map
