/*!
 * devextreme-angular
 * Version: 18.1.6
 * Build date: Wed Sep 05 2018
 *
 * Copyright (c) 2012 - 2018 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { TransferState } from '@angular/platform-browser';
import { ElementRef, NgZone, OnDestroy, EventEmitter, OnChanges, DoCheck, SimpleChanges } from '@angular/core';
import DevExpress from 'devextreme/bundles/dx.all';
import DxCircularGauge from 'devextreme/viz/circular_gauge';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
/**
 * The CircularGauge is a widget that indicates values on a circular numeric scale.
 */
export declare class DxCircularGaugeComponent extends DxComponent implements OnDestroy, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxCircularGauge;
    /**
     * Specifies animation options.
     */
    animation: {
        duration?: number;
        easing?: string;
        enabled?: boolean;
    };
    /**
     * Specifies the color of the parent page element.
     */
    containerBackgroundColor: string;
    /**
     * Specifies the attributes to be attached to the widget's root element.
     */
    elementAttr: any;
    /**
     * Configures the exporting and printing features.
     */
    export: {
        backgroundColor?: string;
        enabled?: boolean;
        fileName?: string;
        formats?: Array<string>;
        margin?: number;
        printingEnabled?: boolean;
        proxyUrl?: string;
    };
    /**
     * Specifies the options required to set the geometry of the CircularGauge widget.
     */
    geometry: {
        endAngle?: number;
        startAngle?: number;
    };
    /**
     * Configures the loading indicator.
     */
    loadingIndicator: {
        backgroundColor?: string;
        font?: DevExpress.viz.Font;
        show?: boolean;
        text?: string;
    };
    /**
     * Generates space around the widget.
     */
    margin: {
        bottom?: number;
        left?: number;
        right?: number;
        top?: number;
    };
    /**
     * Notifies the widget that it is embedded into an HTML page that uses a tag modifying the path.
     */
    pathModified: boolean;
    /**
     * Specifies gauge range container options.
     */
    rangeContainer: {
        backgroundColor?: string;
        offset?: number;
        orientation?: string;
        palette?: string | Array<string>;
        paletteExtensionMode?: string;
        ranges?: Array<any | {
            color?: string;
            endValue?: number;
            startValue?: number;
        }>;
        width?: number;
    };
    /**
     * Specifies whether to redraw the widget when the size of the parent browser window changes or a mobile device rotates.
     */
    redrawOnResize: boolean;
    /**
     * Switches the widget to a right-to-left representation.
     */
    rtlEnabled: boolean;
    /**
     * Specifies a gauge's scale options.
     */
    scale: {
        allowDecimals?: boolean;
        customMinorTicks?: Array<number>;
        customTicks?: Array<number>;
        endValue?: number;
        hideFirstLabel?: boolean;
        hideFirstTick?: boolean;
        hideLastLabel?: boolean;
        hideLastTick?: boolean;
        label?: {
            customizeText?: Function;
            font?: DevExpress.viz.Font;
            format?: DevExpress.ui.format | string;
            hideFirstOrLast?: string;
            indentFromTick?: number;
            overlappingBehavior?: string | {
                hideFirstOrLast?: string;
                useAutoArrangement?: boolean;
            };
            precision?: number;
            useRangeColors?: boolean;
            visible?: boolean;
        };
        majorTick?: {
            color?: string;
            customTickValues?: Array<number>;
            length?: number;
            showCalculatedTicks?: boolean;
            tickInterval?: number;
            useTicksAutoArrangement?: boolean;
            visible?: boolean;
            width?: number;
        };
        minorTick?: {
            color?: string;
            customTickValues?: Array<number>;
            length?: number;
            opacity?: number;
            showCalculatedTicks?: boolean;
            tickInterval?: number;
            visible?: boolean;
            width?: number;
        };
        minorTickInterval?: number;
        orientation?: string;
        startValue?: number;
        tick?: {
            color?: string;
            length?: number;
            opacity?: number;
            visible?: boolean;
            width?: number;
        };
        tickInterval?: number;
    };
    /**
     * Specifies the widget's size in pixels.
     */
    size: {
        height?: number;
        width?: number;
    };
    /**
     * Use the title.subtitle option instead.
     */
    subtitle: string | {
        font?: DevExpress.viz.Font;
        text?: string;
    };
    /**
     * Specifies the appearance options of subvalue indicators.
     */
    subvalueIndicator: any;
    /**
     * Specifies a set of subvalues to be designated by the subvalue indicators.
     */
    subvalues: Array<number>;
    /**
     * Sets the name of the theme the widget uses.
     */
    theme: string;
    /**
     * Configures the widget's title.
     */
    title: string | {
        font?: DevExpress.viz.Font;
        horizontalAlignment?: string;
        margin?: number | {
            bottom?: number;
            left?: number;
            right?: number;
            top?: number;
        };
        placeholderSize?: number;
        position?: string;
        subtitle?: string | {
            font?: DevExpress.viz.Font;
            text?: string;
        };
        text?: string;
        verticalAlignment?: string;
    };
    /**
     * Configures tooltips.
     */
    tooltip: {
        arrowLength?: number;
        border?: {
            color?: string;
            dashStyle?: string;
            opacity?: number;
            visible?: boolean;
            width?: number;
        };
        color?: string;
        container?: Element | JQuery;
        customizeTooltip?: Function;
        enabled?: boolean;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        opacity?: number;
        paddingLeftRight?: number;
        paddingTopBottom?: number;
        precision?: number;
        shadow?: {
            blur?: number;
            color?: string;
            offsetX?: number;
            offsetY?: number;
            opacity?: number;
        };
        zIndex?: number;
    };
    /**
     * Specifies the main value on a gauge.
     */
    value: number;
    /**
     * Specifies the appearance options of the value indicator.
     */
    valueIndicator: any;
    /**
     * A function that is executed before the widget is disposed of.
     */
    onDisposing: EventEmitter<any>;
    /**
     * A function that is executed when the widget's rendering has finished.
     */
    onDrawn: EventEmitter<any>;
    /**
     * A function that is executed after the widget is exported.
     */
    onExported: EventEmitter<any>;
    /**
     * A function that is executed before the widget is exported.
     */
    onExporting: EventEmitter<any>;
    /**
     * A function that is executed before a file with exported widget is saved to the user's local storage.
     */
    onFileSaving: EventEmitter<any>;
    /**
     * A function that is executed when an error or warning occurs.
     */
    onIncidentOccurred: EventEmitter<any>;
    /**
     * A function that is executed only once, after the widget is initialized.
     */
    onInitialized: EventEmitter<any>;
    /**
     * A function that is executed after a widget option is changed.
     */
    onOptionChanged: EventEmitter<any>;
    /**
     * A function that is executed when a tooltip becomes hidden.
     */
    onTooltipHidden: EventEmitter<any>;
    /**
     * A function that is executed when a tooltip appears.
     */
    onTooltipShown: EventEmitter<any>;
    /**
     * A handler for the animationChange event.
     */
    animationChange: EventEmitter<{
        duration?: number;
        easing?: string;
        enabled?: boolean;
    }>;
    /**
     * A handler for the containerBackgroundColorChange event.
     */
    containerBackgroundColorChange: EventEmitter<string>;
    /**
     * A handler for the elementAttrChange event.
     */
    elementAttrChange: EventEmitter<any>;
    /**
     * A handler for the exportChange event.
     */
    exportChange: EventEmitter<{
        backgroundColor?: string;
        enabled?: boolean;
        fileName?: string;
        formats?: Array<string>;
        margin?: number;
        printingEnabled?: boolean;
        proxyUrl?: string;
    }>;
    /**
     * A handler for the geometryChange event.
     */
    geometryChange: EventEmitter<{
        endAngle?: number;
        startAngle?: number;
    }>;
    /**
     * A handler for the loadingIndicatorChange event.
     */
    loadingIndicatorChange: EventEmitter<{
        backgroundColor?: string;
        font?: DevExpress.viz.Font;
        show?: boolean;
        text?: string;
    }>;
    /**
     * A handler for the marginChange event.
     */
    marginChange: EventEmitter<{
        bottom?: number;
        left?: number;
        right?: number;
        top?: number;
    }>;
    /**
     * A handler for the pathModifiedChange event.
     */
    pathModifiedChange: EventEmitter<boolean>;
    /**
     * A handler for the rangeContainerChange event.
     */
    rangeContainerChange: EventEmitter<{
        backgroundColor?: string;
        offset?: number;
        orientation?: string;
        palette?: string | Array<string>;
        paletteExtensionMode?: string;
        ranges?: Array<any | {
            color?: string;
            endValue?: number;
            startValue?: number;
        }>;
        width?: number;
    }>;
    /**
     * A handler for the redrawOnResizeChange event.
     */
    redrawOnResizeChange: EventEmitter<boolean>;
    /**
     * A handler for the rtlEnabledChange event.
     */
    rtlEnabledChange: EventEmitter<boolean>;
    /**
     * A handler for the scaleChange event.
     */
    scaleChange: EventEmitter<{
        allowDecimals?: boolean;
        customMinorTicks?: Array<number>;
        customTicks?: Array<number>;
        endValue?: number;
        hideFirstLabel?: boolean;
        hideFirstTick?: boolean;
        hideLastLabel?: boolean;
        hideLastTick?: boolean;
        label?: {
            customizeText?: Function;
            font?: DevExpress.viz.Font;
            format?: DevExpress.ui.format | string;
            hideFirstOrLast?: string;
            indentFromTick?: number;
            overlappingBehavior?: string | {
                hideFirstOrLast?: string;
                useAutoArrangement?: boolean;
            };
            precision?: number;
            useRangeColors?: boolean;
            visible?: boolean;
        };
        majorTick?: {
            color?: string;
            customTickValues?: Array<number>;
            length?: number;
            showCalculatedTicks?: boolean;
            tickInterval?: number;
            useTicksAutoArrangement?: boolean;
            visible?: boolean;
            width?: number;
        };
        minorTick?: {
            color?: string;
            customTickValues?: Array<number>;
            length?: number;
            opacity?: number;
            showCalculatedTicks?: boolean;
            tickInterval?: number;
            visible?: boolean;
            width?: number;
        };
        minorTickInterval?: number;
        orientation?: string;
        startValue?: number;
        tick?: {
            color?: string;
            length?: number;
            opacity?: number;
            visible?: boolean;
            width?: number;
        };
        tickInterval?: number;
    }>;
    /**
     * A handler for the sizeChange event.
     */
    sizeChange: EventEmitter<{
        height?: number;
        width?: number;
    }>;
    /**
     * A handler for the subtitleChange event.
     */
    subtitleChange: EventEmitter<string | {
        font?: DevExpress.viz.Font;
        text?: string;
    }>;
    /**
     * A handler for the subvalueIndicatorChange event.
     */
    subvalueIndicatorChange: EventEmitter<any>;
    /**
     * A handler for the subvaluesChange event.
     */
    subvaluesChange: EventEmitter<Array<number>>;
    /**
     * A handler for the themeChange event.
     */
    themeChange: EventEmitter<string>;
    /**
     * A handler for the titleChange event.
     */
    titleChange: EventEmitter<string | {
        font?: DevExpress.viz.Font;
        horizontalAlignment?: string;
        margin?: number | {
            bottom?: number;
            left?: number;
            right?: number;
            top?: number;
        };
        placeholderSize?: number;
        position?: string;
        subtitle?: string | {
            font?: DevExpress.viz.Font;
            text?: string;
        };
        text?: string;
        verticalAlignment?: string;
    }>;
    /**
     * A handler for the tooltipChange event.
     */
    tooltipChange: EventEmitter<{
        arrowLength?: number;
        border?: {
            color?: string;
            dashStyle?: string;
            opacity?: number;
            visible?: boolean;
            width?: number;
        };
        color?: string;
        container?: Element | JQuery;
        customizeTooltip?: Function;
        enabled?: boolean;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        opacity?: number;
        paddingLeftRight?: number;
        paddingTopBottom?: number;
        precision?: number;
        shadow?: {
            blur?: number;
            color?: string;
            offsetX?: number;
            offsetY?: number;
            opacity?: number;
        };
        zIndex?: number;
    }>;
    /**
     * A handler for the valueChange event.
     */
    valueChange: EventEmitter<number>;
    /**
     * A handler for the valueIndicatorChange event.
     */
    valueIndicatorChange: EventEmitter<any>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost, transferState: TransferState, platformId: any);
    protected _createInstance(element: any, options: any): DxCircularGauge;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    setupChanges(prop: string, changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
}
export declare class DxCircularGaugeModule {
}
