/*!
 * devextreme-angular
 * Version: 18.1.6
 * Build date: Wed Sep 05 2018
 *
 * Copyright (c) 2012 - 2018 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { TransferState } from '@angular/platform-browser';
import { ElementRef, NgZone, OnDestroy, EventEmitter, OnInit, AfterViewInit, OnChanges, DoCheck, SimpleChanges } from '@angular/core';
import DevExpress from 'devextreme/bundles/dx.all';
import DxRangeSelector from 'devextreme/viz/range_selector';
import { DxValidatorComponent } from './validator';
import { ControlValueAccessor } from '@angular/forms';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
/**
 * The RangeSelector is a widget that allows a user to select a range of values on a scale.
 */
export declare class DxRangeSelectorComponent extends DxComponent implements OnDestroy, OnInit, AfterViewInit, ControlValueAccessor, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxRangeSelector;
    validator: DxValidatorComponent;
    /**
     * Specifies the options for the range selector's background.
     */
    background: {
        color?: string;
        image?: {
            location?: string;
            url?: string;
        };
        visible?: boolean;
    };
    /**
     * Specifies the RangeSelector's behavior options.
     */
    behavior: {
        allowSlidersSwap?: boolean;
        animationEnabled?: boolean;
        callSelectedRangeChanged?: string;
        callValueChanged?: string;
        manualRangeSelectionEnabled?: boolean;
        moveSelectedRangeByClick?: boolean;
        snapToTicks?: boolean;
    };
    /**
     * Specifies the options required to display a chart as the range selector's background.
     */
    chart: {
        barGroupPadding?: number;
        barGroupWidth?: number;
        barWidth?: number;
        bottomIndent?: number;
        commonSeriesSettings?: any;
        dataPrepareSettings?: {
            checkTypeForAllData?: boolean;
            convertToAxisDataType?: boolean;
            sortingMethod?: boolean | Function;
        };
        equalBarWidth?: boolean;
        negativesAsZeroes?: boolean;
        palette?: string | Array<string>;
        paletteExtensionMode?: string;
        series?: any | Array<any>;
        seriesTemplate?: {
            customizeSeries?: Function;
            nameField?: string;
        };
        topIndent?: number;
        useAggregation?: boolean;
        valueAxis?: {
            inverted?: boolean;
            logarithmBase?: number;
            max?: number;
            min?: number;
            type?: string;
            valueType?: string;
        };
    };
    /**
     * Specifies the color of the parent page element.
     */
    containerBackgroundColor: string;
    /**
     * Specifies a data source for the scale values and for the chart at the background.
     */
    dataSource: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | string | Array<any>;
    /**
     * Specifies the data source field that provides data for the scale.
     */
    dataSourceField: string;
    /**
     * Specifies the attributes to be attached to the widget's root element.
     */
    elementAttr: any;
    /**
     * Configures the exporting and printing features.
     */
    export: {
        backgroundColor?: string;
        enabled?: boolean;
        fileName?: string;
        formats?: Array<string>;
        margin?: number;
        printingEnabled?: boolean;
        proxyUrl?: string;
    };
    /**
     * Range selector's indent options.
     */
    indent: {
        left?: number;
        right?: number;
    };
    /**
     * Configures the loading indicator.
     */
    loadingIndicator: {
        backgroundColor?: string;
        font?: DevExpress.viz.Font;
        show?: boolean;
        text?: string;
    };
    /**
     * Generates space around the widget.
     */
    margin: {
        bottom?: number;
        left?: number;
        right?: number;
        top?: number;
    };
    /**
     * Notifies the widget that it is embedded into an HTML page that uses a tag modifying the path.
     */
    pathModified: boolean;
    /**
     * Specifies whether to redraw the widget when the size of the parent browser window changes or a mobile device rotates.
     */
    redrawOnResize: boolean;
    /**
     * Switches the widget to a right-to-left representation.
     */
    rtlEnabled: boolean;
    /**
     * Specifies options of the range selector's scale.
     */
    scale: {
        aggregationGroupWidth?: number;
        aggregationInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        allowDecimals?: boolean;
        breaks?: Array<DevExpress.viz.ScaleBreak | {
            endValue?: Date | number | string;
            startValue?: Date | number | string;
        }>;
        breakStyle?: {
            color?: string;
            line?: string;
            width?: number;
        };
        categories?: Array<number | string | Date>;
        endOnTick?: boolean;
        endValue?: Date | number | string;
        holidays?: Array<Date | string | number>;
        label?: {
            customizeText?: Function;
            font?: DevExpress.viz.Font;
            format?: DevExpress.ui.format | string;
            overlappingBehavior?: string;
            precision?: number;
            topIndent?: number;
            visible?: boolean;
        };
        logarithmBase?: number;
        majorTickInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            seconds?: number;
            years?: number;
        };
        marker?: {
            label?: {
                customizeText?: Function;
                format?: DevExpress.ui.format | string;
            };
            separatorHeight?: number;
            textLeftIndent?: number;
            textTopIndent?: number;
            topIndent?: number;
            visible?: boolean;
        };
        maxRange?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        minorTick?: {
            color?: string;
            opacity?: number;
            visible?: boolean;
            width?: number;
        };
        minorTickCount?: number;
        minorTickInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        minRange?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        placeholderHeight?: number;
        setTicksAtUnitBeginning?: boolean;
        showCustomBoundaryTicks?: boolean;
        showMinorTicks?: boolean;
        singleWorkdays?: Array<Date | string | number>;
        startValue?: Date | number | string;
        tick?: {
            color?: string;
            opacity?: number;
            width?: number;
        };
        tickInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        type?: string;
        useTicksAutoArrangement?: boolean;
        valueType?: string;
        workdaysOnly?: boolean;
        workWeek?: Array<number>;
    };
    /**
     * Use the value option instead.
     */
    selectedRange: {
        endValue?: Date | number | string;
        startValue?: Date | number | string;
    };
    /**
     * Specifies the color of the selected range.
     */
    selectedRangeColor: string;
    /**
     * Specifies range selector shutter options.
     */
    shutter: {
        color?: string;
        opacity?: number;
    };
    /**
     * Specifies the widget's size in pixels.
     */
    size: {
        height?: number;
        width?: number;
    };
    /**
     * Specifies the appearance of the range selector's slider handles.
     */
    sliderHandle: {
        color?: string;
        opacity?: number;
        width?: number;
    };
    /**
     * Defines the options of the range selector slider markers.
     */
    sliderMarker: {
        color?: string;
        customizeText?: Function;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        invalidRangeColor?: string;
        padding?: number;
        paddingLeftRight?: number;
        paddingTopBottom?: number;
        placeholderHeight?: number;
        placeholderSize?: number | {
            height?: number;
            width?: number | {
                left?: number;
                right?: number;
            };
        };
        precision?: number;
        visible?: boolean;
    };
    /**
     * Sets the name of the theme the widget uses.
     */
    theme: string;
    /**
     * Configures the widget's title.
     */
    title: string | {
        font?: DevExpress.viz.Font;
        horizontalAlignment?: string;
        margin?: number | {
            bottom?: number;
            left?: number;
            right?: number;
            top?: number;
        };
        placeholderSize?: number;
        subtitle?: string | {
            font?: DevExpress.viz.Font;
            text?: string;
        };
        text?: string;
        verticalAlignment?: string;
    };
    /**
     * The selected range, initial or current.
     */
    value: Array<number | string | Date>;
    /**
     * A function that is executed before the widget is disposed of.
     */
    onDisposing: EventEmitter<any>;
    /**
     * A function that is executed when the widget's rendering has finished.
     */
    onDrawn: EventEmitter<any>;
    /**
     * A function that is executed after the widget is exported.
     */
    onExported: EventEmitter<any>;
    /**
     * A function that is executed before the widget is exported.
     */
    onExporting: EventEmitter<any>;
    /**
     * A function that is executed before a file with exported widget is saved to the user's local storage.
     */
    onFileSaving: EventEmitter<any>;
    /**
     * A function that is executed when an error or warning occurs.
     */
    onIncidentOccurred: EventEmitter<any>;
    /**
     * A function that is executed only once, after the widget is initialized.
     */
    onInitialized: EventEmitter<any>;
    /**
     * A function that is executed after a widget option is changed.
     */
    onOptionChanged: EventEmitter<any>;
    /**
     * Use the onValueChanged option instead.
     */
    onSelectedRangeChanged: EventEmitter<any>;
    /**
     * A function that is executed after the widget's value is changed.
     */
    onValueChanged: EventEmitter<any>;
    /**
     * A handler for the backgroundChange event.
     */
    backgroundChange: EventEmitter<{
        color?: string;
        image?: {
            location?: string;
            url?: string;
        };
        visible?: boolean;
    }>;
    /**
     * A handler for the behaviorChange event.
     */
    behaviorChange: EventEmitter<{
        allowSlidersSwap?: boolean;
        animationEnabled?: boolean;
        callSelectedRangeChanged?: string;
        callValueChanged?: string;
        manualRangeSelectionEnabled?: boolean;
        moveSelectedRangeByClick?: boolean;
        snapToTicks?: boolean;
    }>;
    /**
     * A handler for the chartChange event.
     */
    chartChange: EventEmitter<{
        barGroupPadding?: number;
        barGroupWidth?: number;
        barWidth?: number;
        bottomIndent?: number;
        commonSeriesSettings?: any;
        dataPrepareSettings?: {
            checkTypeForAllData?: boolean;
            convertToAxisDataType?: boolean;
            sortingMethod?: boolean | Function;
        };
        equalBarWidth?: boolean;
        negativesAsZeroes?: boolean;
        palette?: string | Array<string>;
        paletteExtensionMode?: string;
        series?: any | Array<any>;
        seriesTemplate?: {
            customizeSeries?: Function;
            nameField?: string;
        };
        topIndent?: number;
        useAggregation?: boolean;
        valueAxis?: {
            inverted?: boolean;
            logarithmBase?: number;
            max?: number;
            min?: number;
            type?: string;
            valueType?: string;
        };
    }>;
    /**
     * A handler for the containerBackgroundColorChange event.
     */
    containerBackgroundColorChange: EventEmitter<string>;
    /**
     * A handler for the dataSourceChange event.
     */
    dataSourceChange: EventEmitter<DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | string | Array<any>>;
    /**
     * A handler for the dataSourceFieldChange event.
     */
    dataSourceFieldChange: EventEmitter<string>;
    /**
     * A handler for the elementAttrChange event.
     */
    elementAttrChange: EventEmitter<any>;
    /**
     * A handler for the exportChange event.
     */
    exportChange: EventEmitter<{
        backgroundColor?: string;
        enabled?: boolean;
        fileName?: string;
        formats?: Array<string>;
        margin?: number;
        printingEnabled?: boolean;
        proxyUrl?: string;
    }>;
    /**
     * A handler for the indentChange event.
     */
    indentChange: EventEmitter<{
        left?: number;
        right?: number;
    }>;
    /**
     * A handler for the loadingIndicatorChange event.
     */
    loadingIndicatorChange: EventEmitter<{
        backgroundColor?: string;
        font?: DevExpress.viz.Font;
        show?: boolean;
        text?: string;
    }>;
    /**
     * A handler for the marginChange event.
     */
    marginChange: EventEmitter<{
        bottom?: number;
        left?: number;
        right?: number;
        top?: number;
    }>;
    /**
     * A handler for the pathModifiedChange event.
     */
    pathModifiedChange: EventEmitter<boolean>;
    /**
     * A handler for the redrawOnResizeChange event.
     */
    redrawOnResizeChange: EventEmitter<boolean>;
    /**
     * A handler for the rtlEnabledChange event.
     */
    rtlEnabledChange: EventEmitter<boolean>;
    /**
     * A handler for the scaleChange event.
     */
    scaleChange: EventEmitter<{
        aggregationGroupWidth?: number;
        aggregationInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        allowDecimals?: boolean;
        breaks?: Array<DevExpress.viz.ScaleBreak | {
            endValue?: Date | number | string;
            startValue?: Date | number | string;
        }>;
        breakStyle?: {
            color?: string;
            line?: string;
            width?: number;
        };
        categories?: Array<number | string | Date>;
        endOnTick?: boolean;
        endValue?: Date | number | string;
        holidays?: Array<Date | string | number>;
        label?: {
            customizeText?: Function;
            font?: DevExpress.viz.Font;
            format?: DevExpress.ui.format | string;
            overlappingBehavior?: string;
            precision?: number;
            topIndent?: number;
            visible?: boolean;
        };
        logarithmBase?: number;
        majorTickInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            seconds?: number;
            years?: number;
        };
        marker?: {
            label?: {
                customizeText?: Function;
                format?: DevExpress.ui.format | string;
            };
            separatorHeight?: number;
            textLeftIndent?: number;
            textTopIndent?: number;
            topIndent?: number;
            visible?: boolean;
        };
        maxRange?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        minorTick?: {
            color?: string;
            opacity?: number;
            visible?: boolean;
            width?: number;
        };
        minorTickCount?: number;
        minorTickInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        minRange?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        placeholderHeight?: number;
        setTicksAtUnitBeginning?: boolean;
        showCustomBoundaryTicks?: boolean;
        showMinorTicks?: boolean;
        singleWorkdays?: Array<Date | string | number>;
        startValue?: Date | number | string;
        tick?: {
            color?: string;
            opacity?: number;
            width?: number;
        };
        tickInterval?: number | string | {
            days?: number;
            hours?: number;
            milliseconds?: number;
            minutes?: number;
            months?: number;
            quarters?: number;
            seconds?: number;
            weeks?: number;
            years?: number;
        };
        type?: string;
        useTicksAutoArrangement?: boolean;
        valueType?: string;
        workdaysOnly?: boolean;
        workWeek?: Array<number>;
    }>;
    /**
     * A handler for the selectedRangeChange event.
     */
    selectedRangeChange: EventEmitter<{
        endValue?: Date | number | string;
        startValue?: Date | number | string;
    }>;
    /**
     * A handler for the selectedRangeColorChange event.
     */
    selectedRangeColorChange: EventEmitter<string>;
    /**
     * A handler for the shutterChange event.
     */
    shutterChange: EventEmitter<{
        color?: string;
        opacity?: number;
    }>;
    /**
     * A handler for the sizeChange event.
     */
    sizeChange: EventEmitter<{
        height?: number;
        width?: number;
    }>;
    /**
     * A handler for the sliderHandleChange event.
     */
    sliderHandleChange: EventEmitter<{
        color?: string;
        opacity?: number;
        width?: number;
    }>;
    /**
     * A handler for the sliderMarkerChange event.
     */
    sliderMarkerChange: EventEmitter<{
        color?: string;
        customizeText?: Function;
        font?: DevExpress.viz.Font;
        format?: DevExpress.ui.format | string;
        invalidRangeColor?: string;
        padding?: number;
        paddingLeftRight?: number;
        paddingTopBottom?: number;
        placeholderHeight?: number;
        placeholderSize?: number | {
            height?: number;
            width?: number | {
                left?: number;
                right?: number;
            };
        };
        precision?: number;
        visible?: boolean;
    }>;
    /**
     * A handler for the themeChange event.
     */
    themeChange: EventEmitter<string>;
    /**
     * A handler for the titleChange event.
     */
    titleChange: EventEmitter<string | {
        font?: DevExpress.viz.Font;
        horizontalAlignment?: string;
        margin?: number | {
            bottom?: number;
            left?: number;
            right?: number;
            top?: number;
        };
        placeholderSize?: number;
        subtitle?: string | {
            font?: DevExpress.viz.Font;
            text?: string;
        };
        text?: string;
        verticalAlignment?: string;
    }>;
    /**
     * A handler for the valueChange event.
     */
    valueChange: EventEmitter<Array<number | string | Date>>;
    onBlur: EventEmitter<any>;
    change(_: any): void;
    touched: (_: any) => void;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost, transferState: TransferState, platformId: any);
    protected _createInstance(element: any, options: any): DxRangeSelector;
    writeValue(value: any): void;
    registerOnChange(fn: (_: any) => void): void;
    registerOnTouched(fn: () => void): void;
    _createWidget(element: any): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    setupChanges(prop: string, changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
    ngOnInit(): void;
    ngAfterViewInit(): void;
}
export declare class DxRangeSelectorModule {
}
