/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 18.1.6
 * Build date: Mon Sep 03 2018
 *
 * Copyright (c) 2012 - 2018 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: false,
            exports: {}
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.l = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
        if (!__webpack_require__.o(exports, name)) {
            Object.defineProperty(exports, name, {
                configurable: false,
                enumerable: true,
                get: getter
            })
        }
    };
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default
        } : function() {
            return module
        };
        __webpack_require__.d(getter, "a", getter);
        return getter
    };
    __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property)
    };
    __webpack_require__.p = "";
    return __webpack_require__(__webpack_require__.s = 753)
}([
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/extend.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isPlainObject = __webpack_require__( /*! ./type */ 1).isPlainObject;
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (source.hasOwnProperty(prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        var extend = function extend(target) {
            target = target || {};
            var i = 1,
                deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var clone, targetValue = target[key],
                        sourceValue = source[key],
                        sourceValueIsArray = false;
                    if (target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && (isPlainObject(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && isPlainObject(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend;
        exports.extendFromObject = extendFromObject
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/type.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var types = {
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Object]": "object",
            "[object String]": "string",
            "[object Null]": "null"
        };
        var type = function(object) {
            var typeOfObject = Object.prototype.toString.call(object);
            return "object" === ("undefined" === typeof object ? "undefined" : _typeof(object)) ? types[typeOfObject] || "object" : "undefined" === typeof object ? "undefined" : _typeof(object)
        };
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        var isDate = function(object) {
            return "date" === type(object)
        };
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        var isFunction = function(object) {
            return "function" === typeof object
        };
        var isString = function(object) {
            return "string" === typeof object
        };
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        var isObject = function(object) {
            return "object" === type(object)
        };
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object),
                ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        var isRenderer = function(object) {
            return !!(object.jquery || object.dxRenderer)
        };
        var isPromise = function(object) {
            return object && isFunction(object.then)
        };
        var isDeferred = function(object) {
            return object && isFunction(object.done) && isFunction(object.fail)
        };
        exports.isBoolean = isBoolean;
        exports.isExponential = isExponential;
        exports.isDate = isDate;
        exports.isDefined = isDefined;
        exports.isFunction = isFunction;
        exports.isString = isString;
        exports.isNumeric = isNumeric;
        exports.isObject = isObject;
        exports.isEmptyObject = isEmptyObject;
        exports.isPlainObject = isPlainObject;
        exports.isPrimitive = isPrimitive;
        exports.isWindow = isWindow;
        exports.isRenderer = isRenderer;
        exports.isPromise = isPromise;
        exports.isDeferred = isDeferred;
        exports.type = type
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/core/renderer.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var rendererBase = __webpack_require__( /*! ./renderer_base */ 224);
        module.exports = rendererBase.get()
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/iterator.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var applyCallback = function(index, values, callback, result) {
            var value = callback(values[index], index);
            if (null != value) {
                result.push(value)
            }
        };
        var map = function(values, callback) {
            var result = [];
            if ("length" in values) {
                for (var index = 0; index < values.length; index++) {
                    applyCallback(index, values, callback, result)
                }
            } else {
                for (var key in values) {
                    applyCallback(key, values, callback, result)
                }
            }
            return [].concat.apply([], result)
        };
        var each = function(values, callback) {
            if (!values) {
                return
            }
            if ("length" in values) {
                for (var i = 0; i < values.length; i++) {
                    if (false === callback.call(values[i], i, values[i])) {
                        break
                    }
                }
            } else {
                for (var key in values) {
                    if (false === callback.call(values[key], key, values[key])) {
                        break
                    }
                }
            }
            return values
        };
        exports.map = map;
        exports.each = each
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/common.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var config = __webpack_require__( /*! ../config */ 29),
            deferredUtils = __webpack_require__( /*! ../utils/deferred */ 7),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            typeUtils = __webpack_require__( /*! ./type */ 1);
        var ensureDefined = function(value, defaultValue) {
            return typeUtils.isDefined(value) ? value : defaultValue
        };
        var executeAsync = function(action, context) {
            var timerId, deferred = new Deferred,
                normalizedContext = context || this,
                task = {
                    promise: deferred.promise(),
                    abort: function() {
                        clearTimeout(timerId);
                        deferred.rejectWith(normalizedContext)
                    }
                },
                callback = function() {
                    var result = action.call(normalizedContext);
                    if (result && result.done && typeUtils.isFunction(result.done)) {
                        result.done(function() {
                            deferred.resolveWith(normalizedContext)
                        })
                    } else {
                        deferred.resolveWith(normalizedContext)
                    }
                };
            timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || new Deferred;
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName,
                    currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [],
                maxMatchCount = 0;
            each(items, function(index, itemSrc) {
                var matchCount = 0,
                    item = mapFn ? mapFn(itemSrc) : itemSrc;
                each(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                each(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            switch ("undefined" === typeof raw ? "undefined" : _typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [raw.x || raw.h, raw.y || raw.v];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var splitQuad = function(raw) {
            switch ("undefined" === typeof raw ? "undefined" : _typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var normalizeKey = function(id) {
            var key = typeUtils.isString(id) ? id : id.toString(),
                arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && each(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        var isArraysEqualByValue = function(array1, array2, deep) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], deep + 1)) {
                    return false
                }
            }
            return true
        };
        var isObjectsEqualByValue = function(object1, object2, deep) {
            for (var propertyName in object1) {
                if (object1.hasOwnProperty(propertyName) && !equalByValue(object1[propertyName], object2[propertyName], deep + 1)) {
                    return false
                }
            }
            for (propertyName in object2) {
                if (!(propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var equalByValue = function(object1, object2, deep) {
            if (object1 === object2) {
                return true
            }
            var maxDeep = 3;
            deep = deep || 0;
            if (deep >= maxDeep) {
                return true
            }
            if (typeUtils.isObject(object1) && typeUtils.isObject(object2)) {
                return isObjectsEqualByValue(object1, object2, deep)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return isArraysEqualByValue(object1, object2, deep)
                } else {
                    if (typeUtils.isDate(object1) && typeUtils.isDate(object2)) {
                        return object1.getTime() === object2.getTime()
                    }
                }
            }
            return false
        };
        var getKeyHash = function(key) {
            if (typeUtils.isObject(key) || Array.isArray(key)) {
                try {
                    var keyHash = JSON.stringify(key);
                    return "{}" === keyHash ? key : keyHash
                } catch (e) {
                    return key
                }
            }
            return key
        };
        var escapeRegExp = function(string) {
            return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
        };
        var applyServerDecimalSeparator = function(value) {
            var separator = config().serverDecimalSeparator;
            if (typeUtils.isDefined(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        var noop = function() {};
        var grep = function(elements, checkFunction, invert) {
            var check, result = [],
                expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        exports.ensureDefined = ensureDefined;
        exports.executeAsync = executeAsync;
        exports.deferRender = deferRender;
        exports.deferRenderer = deferRenderer;
        exports.deferUpdate = deferUpdate;
        exports.deferUpdater = deferUpdater;
        exports.splitPair = splitPair;
        exports.splitQuad = splitQuad;
        exports.findBestMatches = findBestMatches;
        exports.normalizeKey = normalizeKey;
        exports.denormalizeKey = denormalizeKey;
        exports.equalByValue = equalByValue;
        exports.getKeyHash = getKeyHash;
        exports.escapeRegExp = escapeRegExp;
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        exports.noop = noop;
        exports.grep = grep
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/events/core/events_engine.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var registerEventCallbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 111);
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 6);
        var window = windowUtils.getWindow();
        var injector = __webpack_require__( /*! ../../core/utils/dependency_injector */ 55);
        var typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1);
        var Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 20);
        var isWindow = typeUtils.isWindow;
        var isFunction = typeUtils.isFunction;
        var isString = typeUtils.isString;
        var errors = __webpack_require__( /*! ../../core/errors */ 18);
        var WeakMap = __webpack_require__( /*! ../../core/polyfills/weak_map */ 176);
        var hookTouchProps = __webpack_require__( /*! ../../events/core/hook_touch_props */ 225);
        var EMPTY_EVENT_NAME = "dxEmptyEventType";
        var NATIVE_EVENTS_TO_SUBSCRIBE = {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        };
        var NATIVE_EVENTS_TO_TRIGGER = {
            focusin: "focus",
            focusout: "blur"
        };
        var NO_BUBBLE_EVENTS = ["blur", "focusout", "focus", "focusin", "load"];
        var passiveListenerEvents = {
            eventName: "dxpointermove",
            nativeEventName: "touchmove"
        };
        var matchesSafe = function(target, selector) {
            return !isWindow(target) && "#document" !== target.nodeName && domAdapter.elementMatches(target, selector)
        };
        var elementDataMap = new WeakMap;
        var guid = 0;
        var skipEvent;
        var special = function() {
            var specialData = {};
            registerEventCallbacks.add(function(eventName, eventObject) {
                specialData[eventName] = eventObject
            });
            return {
                getField: function(eventName, field) {
                    return specialData[eventName] && specialData[eventName][field]
                },
                callMethod: function(eventName, methodName, context, args) {
                    return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                }
            }
        }();
        var applyForEach = function applyForEach(args, method) {
            var element = args[0];
            if (!element) {
                return
            }
            if (domAdapter.isNode(element) || isWindow(element)) {
                method.apply(eventsEngine, args)
            } else {
                if (!isString(element) && "length" in element) {
                    var itemArgs = Array.prototype.slice.call(args, 0);
                    Array.prototype.forEach.call(element, function(itemElement) {
                        itemArgs[0] = itemElement;
                        applyForEach(itemArgs, method)
                    })
                } else {
                    throw errors.Error("E0025")
                }
            }
        };
        var getHandler = function(method) {
            return function() {
                applyForEach(arguments, method)
            }
        };
        var getHandlersController = function(element, eventName) {
            var elementData = elementDataMap.get(element);
            eventName = eventName || "";
            var eventNameParts = eventName.split(".");
            var namespaces = eventNameParts.slice(1);
            var eventNameIsDefined = !!eventNameParts[0];
            eventName = eventNameParts[0] || EMPTY_EVENT_NAME;
            if (!elementData) {
                elementData = {};
                elementDataMap.set(element, elementData)
            }
            if (!elementData[eventName]) {
                elementData[eventName] = {
                    handleObjects: [],
                    nativeHandler: null
                }
            }
            var eventData = elementData[eventName];
            return {
                addHandler: function(handler, selector, data) {
                    var callHandler = function(e, extraParameters) {
                        var secondaryTargetIsInside, result, handlerArgs = [e],
                            target = e.currentTarget,
                            relatedTarget = e.relatedTarget;
                        if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                            secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || target.contains(relatedTarget))
                        }
                        if (void 0 !== extraParameters) {
                            handlerArgs.push(extraParameters)
                        }
                        special.callMethod(eventName, "handle", element, [e, data]);
                        if (!secondaryTargetIsInside) {
                            result = handler.apply(target, handlerArgs)
                        }
                        if (false === result) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    };
                    var wrappedHandler = function(e, extraParameters) {
                        if (skipEvent && e.type === skipEvent) {
                            return
                        }
                        e.data = data;
                        e.delegateTarget = element;
                        if (selector) {
                            var currentTarget = e.target;
                            while (currentTarget && currentTarget !== element) {
                                if (matchesSafe(currentTarget, selector)) {
                                    e.currentTarget = currentTarget;
                                    callHandler(e, extraParameters)
                                }
                                currentTarget = currentTarget.parentNode
                            }
                        } else {
                            callHandler(e, extraParameters)
                        }
                    };
                    var handleObject = {
                        handler: handler,
                        wrappedHandler: wrappedHandler,
                        selector: selector,
                        type: eventName,
                        data: data,
                        namespace: namespaces.join("."),
                        namespaces: namespaces,
                        guid: ++guid
                    };
                    eventData.handleObjects.push(handleObject);
                    var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                    var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                    var nativeListenerOptions;
                    if (shouldAddNativeListener) {
                        shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                    }
                    if (shouldAddNativeListener) {
                        eventData.nativeHandler = getNativeHandler(eventName);
                        if (eventName === passiveListenerEvents.nativeEventName) {
                            nativeListenerOptions = {
                                passive: false
                            }
                        }
                        eventData.removeListener = domAdapter.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                    }
                    special.callMethod(eventName, "add", element, [handleObject])
                },
                removeHandler: function(handler, selector) {
                    var removeByEventName = function(eventName) {
                        var eventData = elementData[eventName];
                        if (!eventData.handleObjects.length) {
                            delete elementData[eventName];
                            return
                        }
                        var removedHandler;
                        eventData.handleObjects = eventData.handleObjects.filter(function(handleObject) {
                            var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                            if (!skip) {
                                removedHandler = handleObject.handler;
                                special.callMethod(eventName, "remove", element, [handleObject])
                            }
                            return skip
                        });
                        var lastHandlerForTheType = !eventData.handleObjects.length;
                        var shouldRemoveNativeListener = lastHandlerForTheType && eventName !== EMPTY_EVENT_NAME;
                        if (shouldRemoveNativeListener) {
                            special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                            if (eventData.nativeHandler) {
                                eventData.removeListener()
                            }
                            delete elementData[eventName]
                        }
                    };
                    if (eventNameIsDefined) {
                        removeByEventName(eventName)
                    } else {
                        for (var name in elementData) {
                            removeByEventName(name)
                        }
                    }
                    var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                    if (elementDataIsEmpty) {
                        elementDataMap.delete(element)
                    }
                },
                callHandlers: function(event, extraParameters) {
                    var forceStop = false;
                    var handleCallback = function(handleObject) {
                        if (forceStop) {
                            return
                        }
                        if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                            handleObject.wrappedHandler(event, extraParameters);
                            forceStop = event.isImmediatePropagationStopped()
                        }
                    };
                    eventData.handleObjects.forEach(handleCallback);
                    if (namespaces.length && elementData[EMPTY_EVENT_NAME]) {
                        elementData[EMPTY_EVENT_NAME].handleObjects.forEach(handleCallback)
                    }
                }
            }
        };
        var getNativeHandler = function(subscribeName) {
            return function(event, extraParameters) {
                var handlersController = getHandlersController(this, subscribeName);
                event = eventsEngine.Event(event);
                handlersController.callHandlers(event, extraParameters)
            }
        };
        var isSubset = function(original, checked) {
            for (var i = 0; i < checked.length; i++) {
                if (original.indexOf(checked[i]) < 0) {
                    return false
                }
            }
            return true
        };
        var normalizeOnArguments = function(callback) {
            return function(element, eventName, selector, data, handler) {
                if (!handler) {
                    handler = data;
                    data = void 0
                }
                if ("string" !== typeof selector) {
                    data = selector;
                    selector = void 0
                }
                if (!handler && "string" === typeof eventName) {
                    handler = data || selector;
                    selector = void 0;
                    data = void 0
                }
                callback(element, eventName, selector, data, handler)
            }
        };
        var normalizeOffArguments = function(callback) {
            return function(element, eventName, selector, handler) {
                if ("function" === typeof selector) {
                    handler = selector;
                    selector = void 0
                }
                callback(element, eventName, selector, handler)
            }
        };
        var normalizeTriggerArguments = function(callback) {
            return function(element, src, extraParameters) {
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!src.target) {
                    src.target = element
                }
                src.currentTarget = element;
                if (!src.delegateTarget) {
                    src.delegateTarget = element
                }
                if (!src.type && src.originalEvent) {
                    src.type = src.originalEvent.type
                }
                callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
            }
        };
        var normalizeEventArguments = function(callback) {
            return function(src, config) {
                if (!(this instanceof eventsEngine.Event)) {
                    return new eventsEngine.Event(src, config)
                }
                if (!src) {
                    src = {}
                }
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!config) {
                    config = {}
                }
                callback.call(this, src, config)
            }
        };
        var iterate = function(callback) {
            var iterateEventNames = function(element, eventName) {
                if (eventName && eventName.indexOf(" ") > -1) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    eventName.split(" ").forEach(function(eventName) {
                        args[1] = eventName;
                        callback.apply(this, args)
                    })
                } else {
                    callback.apply(this, arguments)
                }
            };
            return function(element, eventName) {
                if ("object" === ("undefined" === typeof eventName ? "undefined" : _typeof(eventName))) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    for (var name in eventName) {
                        args[1] = name;
                        args[args.length - 1] = eventName[name];
                        iterateEventNames.apply(this, args)
                    }
                } else {
                    iterateEventNames.apply(this, arguments)
                }
            }
        };
        var callNativeMethod = function(eventName, element) {
            var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
            var isLinkClickEvent = function(eventName, element) {
                return "click" === eventName && "a" === element.localName
            };
            if (isLinkClickEvent(eventName, element)) {
                return
            }
            if (isFunction(element[nativeMethodName])) {
                skipEvent = eventName;
                element[nativeMethodName]();
                skipEvent = void 0
            }
        };
        var calculateWhich = function(event) {
            var setForMouseEvent = function(event) {
                var mouseEventRegex = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
                return !event.which && void 0 !== event.button && mouseEventRegex.test(event.type)
            };
            var setForKeyEvent = function(event) {
                return null == event.which && 0 === event.type.indexOf("key")
            };
            if (setForKeyEvent(event)) {
                return null != event.charCode ? event.charCode : event.keyCode
            }
            if (setForMouseEvent(event)) {
                var whichByButton = {
                    1: 1,
                    2: 3,
                    3: 1,
                    4: 2
                };
                return whichByButton[event.button]
            }
            return event.which
        };
        var eventsEngine = injector({
            on: getHandler(normalizeOnArguments(iterate(function(element, eventName, selector, data, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.addHandler(handler, selector, data)
            }))),
            one: getHandler(normalizeOnArguments(function(element, eventName, selector, data, handler) {
                var oneTimeHandler = function oneTimeHandler() {
                    eventsEngine.off(element, eventName, selector, oneTimeHandler);
                    handler.apply(this, arguments)
                };
                eventsEngine.on(element, eventName, selector, data, oneTimeHandler)
            })),
            off: getHandler(normalizeOffArguments(iterate(function(element, eventName, selector, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.removeHandler(handler, selector)
            }))),
            trigger: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var eventName = event.type;
                var handlersController = getHandlersController(element, event.type);
                special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                handlersController.callHandlers(event, extraParameters);
                var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || NO_BUBBLE_EVENTS.indexOf(eventName) !== -1;
                if (!noBubble) {
                    var parents = [];
                    var getParents = function getParents(element) {
                        var parent = element.parentNode;
                        if (parent) {
                            parents.push(parent);
                            getParents(parent)
                        }
                    };
                    getParents(element);
                    parents.push(window);
                    var i = 0;
                    while (parents[i] && !event.isPropagationStopped()) {
                        var parentDataByEvent = getHandlersController(parents[i], event.type);
                        parentDataByEvent.callHandlers(extend(event, {
                            currentTarget: parents[i]
                        }), extraParameters);
                        i++
                    }
                }
                if (element.nodeType || isWindow(element)) {
                    special.callMethod(eventName, "_default", element, [event, extraParameters]);
                    callNativeMethod(eventName, element)
                }
            })),
            triggerHandler: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var handlersController = getHandlersController(element, event.type);
                handlersController.callHandlers(event, extraParameters)
            }))
        });
        var initEvent = function(EventClass) {
            if (EventClass) {
                eventsEngine.Event = EventClass;
                eventsEngine.Event.prototype = EventClass.prototype
            }
        };
        initEvent(normalizeEventArguments(function(src, config) {
            var that = this;
            var propagationStopped = false;
            var immediatePropagationStopped = false;
            var defaultPrevented = false;
            extend(that, src);
            if (src instanceof eventsEngine.Event || windowUtils.hasWindow() && src instanceof window.Event) {
                that.originalEvent = src;
                that.currentTarget = void 0
            }
            if (!(src instanceof eventsEngine.Event)) {
                extend(that, {
                    isPropagationStopped: function() {
                        return !!(propagationStopped || that.originalEvent && that.originalEvent.propagationStopped)
                    },
                    stopPropagation: function() {
                        propagationStopped = true;
                        that.originalEvent && that.originalEvent.stopPropagation()
                    },
                    isImmediatePropagationStopped: function() {
                        return immediatePropagationStopped
                    },
                    stopImmediatePropagation: function() {
                        this.stopPropagation();
                        immediatePropagationStopped = true;
                        that.originalEvent && that.originalEvent.stopImmediatePropagation()
                    },
                    isDefaultPrevented: function() {
                        return !!(defaultPrevented || that.originalEvent && that.originalEvent.defaultPrevented)
                    },
                    preventDefault: function() {
                        defaultPrevented = true;
                        that.originalEvent && that.originalEvent.preventDefault()
                    }
                })
            }
            addProperty("which", calculateWhich, that);
            if (0 === src.type.indexOf("touch")) {
                delete config.pageX;
                delete config.pageY
            }
            extend(that, config);
            that.guid = ++guid
        }));
        var addProperty = function(propName, hook, eventInstance) {
            Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                enumerable: true,
                configurable: true,
                get: function() {
                    return this.originalEvent && hook(this.originalEvent)
                },
                set: function(value) {
                    Object.defineProperty(this, propName, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        };
        hookTouchProps(addProperty);
        var beforeSetStrategy = Callbacks();
        var afterSetStrategy = Callbacks();
        eventsEngine.set = function(engine) {
            beforeSetStrategy.fire();
            eventsEngine.inject(engine);
            initEvent(engine.Event);
            afterSetStrategy.fire()
        };
        eventsEngine.subscribeGlobal = function() {
            applyForEach(arguments, normalizeOnArguments(function() {
                var args = arguments;
                eventsEngine.on.apply(this, args);
                beforeSetStrategy.add(function() {
                    var offArgs = Array.prototype.slice.call(args, 0);
                    offArgs.splice(3, 1);
                    eventsEngine.off.apply(this, offArgs)
                });
                afterSetStrategy.add(function() {
                    eventsEngine.on.apply(this, args)
                })
            }))
        };
        eventsEngine.passiveListenerEvents = passiveListenerEvents;
        eventsEngine.elementDataMap = elementDataMap;
        module.exports = eventsEngine
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/window.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var _hasWindow = "undefined" !== typeof window;
        var windowObject = _hasWindow && window;
        if (!windowObject) {
            windowObject = {};
            windowObject.window = windowObject
        }
        module.exports = {
            hasWindow: function() {
                return _hasWindow
            },
            getWindow: function() {
                return windowObject
            },
            hasProperty: function(prop) {
                return this.hasWindow() && prop in windowObject
            },
            defaultScreenFactorFunc: function(width) {
                if (width < 768) {
                    return "xs"
                } else {
                    if (width < 992) {
                        return "sm"
                    } else {
                        if (width < 1200) {
                            return "md"
                        } else {
                            return "lg"
                        }
                    }
                }
            },
            getCurrentScreenFactor: function(screenFactorCallback) {
                var screenFactorFunc = screenFactorCallback || this.defaultScreenFactorFunc;
                var windowWidth = domAdapter.getDocumentElement().clientWidth;
                return screenFactorFunc(windowWidth)
            },
            openWindow: function() {
                if (this.hasProperty("open")) {
                    return windowObject.open()
                }
                return null
            },
            getNavigator: function() {
                return this.hasWindow() ? windowObject.navigator : {
                    userAgent: ""
                }
            }
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/deferred.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ../utils/type */ 1);
        var isPromise = typeUtils.isPromise;
        var isDeferred = typeUtils.isDeferred;
        var extend = __webpack_require__( /*! ../utils/extend */ 0).extend;
        var Callbacks = __webpack_require__( /*! ../utils/callbacks */ 20);
        var deferredConfig = [{
            method: "resolve",
            handler: "done",
            state: "resolved"
        }, {
            method: "reject",
            handler: "fail",
            state: "rejected"
        }, {
            method: "notify",
            handler: "progress"
        }];
        var _Deferred = function() {
            var that = this;
            this._state = "pending";
            this._promise = {};
            deferredConfig.forEach(function(config) {
                var methodName = config.method;
                this[methodName + "Callbacks"] = new Callbacks;
                this[methodName] = function() {
                    return this[methodName + "With"](this._promise, arguments)
                }.bind(this);
                this._promise[config.handler] = function(handler) {
                    if (!handler) {
                        return this
                    }
                    var callbacks = that[methodName + "Callbacks"];
                    if (callbacks.fired()) {
                        handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                    } else {
                        callbacks.add(function(context, args) {
                            handler.apply(context, args)
                        }.bind(this))
                    }
                    return this
                }
            }.bind(this));
            this._promise.always = function(handler) {
                return this.done(handler).fail(handler)
            };
            this._promise.catch = function(handler) {
                return this.then(null, handler)
            };
            this._promise.then = function(resolve, reject) {
                var result = new _Deferred;
                ["done", "fail"].forEach(function(method) {
                    var callback = "done" === method ? resolve : reject;
                    this[method](function() {
                        if (!callback) {
                            result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                            return
                        }
                        var callbackResult = callback && callback.apply(this, arguments);
                        if (isDeferred(callbackResult)) {
                            callbackResult.done(result.resolve).fail(result.reject)
                        } else {
                            if (isPromise(callbackResult)) {
                                callbackResult.then(result.resolve, result.reject)
                            } else {
                                result.resolve.apply(this, callbackResult ? [callbackResult] : arguments)
                            }
                        }
                    })
                }.bind(this));
                return result.promise()
            };
            this._promise.state = function() {
                return that._state
            };
            this._promise.promise = function(args) {
                return args ? extend(args, that._promise) : that._promise
            };
            this._promise.promise(this)
        };
        deferredConfig.forEach(function(config) {
            var methodName = config.method;
            var state = config.state;
            _Deferred.prototype[methodName + "With"] = function(context, args) {
                var callbacks = this[methodName + "Callbacks"];
                if ("pending" === this.state()) {
                    this[methodName + "Args"] = args;
                    this[methodName + "Context"] = context;
                    if (state) {
                        this._state = state
                    }
                    callbacks.fire(context, args)
                }
                return this
            }
        });
        exports.fromPromise = function(promise, context) {
            if (isDeferred(promise)) {
                return promise
            } else {
                if (isPromise(promise)) {
                    var d = new _Deferred;
                    promise.then(function() {
                        d.resolveWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    }, function() {
                        d.rejectWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    });
                    return d
                }
            }
            return (new _Deferred).resolveWith(context, [promise])
        };
        var when = function() {
            if (1 === arguments.length) {
                return exports.fromPromise(arguments[0])
            }
            var values = [].slice.call(arguments),
                contexts = [],
                resolvedCount = 0,
                deferred = new _Deferred;
            var updateState = function(i) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                    resolvedCount++;
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                }
            };
            for (var i = 0; i < values.length; i++) {
                if (isDeferred(values[i])) {
                    values[i].promise().done(updateState(i)).fail(deferred.reject)
                } else {
                    resolvedCount++
                }
            }
            if (resolvedCount === values.length) {
                deferred.resolveWith(contexts, values)
            }
            return deferred.promise()
        };
        exports.setStrategy = function(value) {
            _Deferred = value.Deferred;
            when = value.when
        };
        exports.Deferred = function() {
            return new _Deferred
        };
        exports.when = function() {
            return when.apply(this, arguments)
        }
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2);
        var callbacks = __webpack_require__( /*! ./component_registrator_callbacks */ 142);
        var errors = __webpack_require__( /*! ./errors */ 18);
        var publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 102);
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }
            publicComponentUtils.name(componentClass, name);
            callbacks.fire(name, componentClass)
        };
        var registerRendererComponent = function(name, componentClass) {
            $.fn[name] = function(options) {
                var result, isMemberInvoke = "string" === typeof options;
                if (isMemberInvoke) {
                    var memberName = options,
                        memberArgs = [].slice.call(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw errors.Error("E0009", name)
                        }
                        var member = instance[memberName],
                            memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        callbacks.add(registerRendererComponent);
        module.exports = registerComponent
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/utils.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2);
        var eventsEngine = __webpack_require__( /*! ./core/events_engine */ 5);
        var errors = __webpack_require__( /*! ../core/errors */ 18);
        var focused = __webpack_require__( /*! ../ui/widget/selectors */ 56).focused;
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend;
        var each = __webpack_require__( /*! ../core/utils/iterator */ 3).each;
        var eventSource = function() {
            var EVENT_SOURCES_REGEX = {
                dx: /^dx/i,
                mouse: /(mouse|wheel)/i,
                touch: /^touch/i,
                keyboard: /^key/i,
                pointer: /^(ms)?pointer/i
            };
            return function(e) {
                var result = "other";
                each(EVENT_SOURCES_REGEX, function(key) {
                    if (this.test(e.type)) {
                        result = key;
                        return false
                    }
                });
                return result
            }
        }();
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        var isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        var isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        var isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        var isFakeClickEvent = function(e) {
            return 0 === e.screenX && !e.offsetX && 0 === e.pageX
        };
        var eventData = function(e) {
            return {
                x: e.pageX,
                y: e.pageY,
                time: e.timeStamp
            }
        };
        var eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        var hasTouches = function(e) {
            if (isNativeTouchEvent(e)) {
                return (e.originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (e.pointers || []).length
            }
            return 0
        };
        var needSkipEvent = function(e) {
            var $target = $(e.target);
            var touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if ("dxmousewheel" === e.type) {
                return $target.is("input[type='number'], textarea, select") && $target.is(":focus")
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && focused($target)
            }
        };
        var fixMethod = function(e) {
            return e
        };
        var setEventFixMethod = function(func) {
            fixMethod = func
        };
        var copyEvent = function(originalEvent) {
            return fixMethod(eventsEngine.Event(originalEvent, originalEvent), originalEvent)
        };
        var createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            if (args) {
                extend(event, args)
            }
            return event
        };
        var fireEvent = function(props) {
            var event = createEvent(props.originalEvent, props);
            eventsEngine.trigger(props.delegateTarget || event.target, event);
            return event
        };
        var addNamespace = function addNamespace(eventNames, namespace) {
            if (!namespace) {
                throw errors.Error("E0017")
            }
            if ("string" === typeof eventNames) {
                if (eventNames.indexOf(" ") === -1) {
                    return eventNames + "." + namespace
                }
                return addNamespace(eventNames.split(/\s+/g), namespace)
            }
            each(eventNames, function(index, eventName) {
                eventNames[index] = eventName + "." + namespace
            });
            return eventNames.join(" ")
        };
        module.exports = {
            eventSource: eventSource,
            isPointerEvent: isPointerEvent,
            isMouseEvent: isMouseEvent,
            isTouchEvent: isTouchEvent,
            isKeyboardEvent: isKeyboardEvent,
            isFakeClickEvent: isFakeClickEvent,
            hasTouches: hasTouches,
            eventData: eventData,
            eventDelta: eventDelta,
            needSkipEvent: needSkipEvent,
            createEvent: createEvent,
            fireEvent: fireEvent,
            addNamespace: addNamespace,
            setEventFixMethod: setEventFixMethod
        }
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/core/class.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ./errors */ 18),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1);
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var overridden, memberName, member, that = this;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var argument, name, i, classObj = this;
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    if (name in classObj.prototype) {
                        throw errors.Error("E0002", name)
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            if (this.parent === parentClass) {
                return true
            }
            if (!this.parent || !this.parent.subclassOf) {
                return false
            }
            return this.parent.subclassOf(parentClass)
        };
        var abstract = function() {
            throw errors.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || typeUtils.isWindow(this) || "function" !== typeof this.constructor) {
                    throw errors.Error("E0003")
                }
                var i, instance = this,
                    ctor = instance.ctor,
                    includedCtors = instance.constructor._includedCtors,
                    includedPostCtors = instance.constructor._includedPostCtors;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        module.exports = classImpl
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/array.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            objectUtils = __webpack_require__( /*! ./object */ 51);
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            each(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            each(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {},
                parameterIndex = 0;
            each(items, function(index, item) {
                index = item[indexParameterName];
                if (isDefined(index)) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                    delete item[indexParameterName]
                }
            });
            objectUtils.orderEach(indexedItems, function(index, items) {
                each(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            each(items, function() {
                if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                    this[indexParameterName] = parameterIndex++
                }
            });
            return parameterIndex
        };
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        var merge = function(array1, array2) {
            for (var i = 0; i < array2.length; i++) {
                array1[array1.length] = array2[i]
            }
            return array1
        };
        exports.isEmpty = isEmpty;
        exports.wrapToArray = wrapToArray;
        exports.intersection = intersection;
        exports.removeDuplicates = removeDuplicates;
        exports.normalizeIndexes = normalizeIndexes;
        exports.inArray = inArray;
        exports.merge = merge
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/dom_adapter.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var injector = __webpack_require__( /*! ./utils/dependency_injector */ 55);
        var noop = __webpack_require__( /*! ./utils/common */ 4).noop;
        var nativeDOMAdapterStrategy = {
            querySelectorAll: function(element, selector) {
                return element.querySelectorAll(selector)
            },
            elementMatches: function(element, selector) {
                var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                    var doc = element.document || element.ownerDocument;
                    if (!doc) {
                        return false
                    }
                    var items = this.querySelectorAll(doc, selector);
                    for (var i = 0; i < items.length; i++) {
                        if (items[i] === element) {
                            return true
                        }
                    }
                }.bind(this);
                return matches.call(element, selector)
            },
            createElement: function(tagName, context) {
                context = context || this._document;
                return context.createElement(tagName)
            },
            createElementNS: function(ns, tagName, context) {
                context = context || this._document;
                return context.createElementNS(ns, tagName)
            },
            createTextNode: function(text, context) {
                context = context || this._document;
                return context.createTextNode(text)
            },
            isNode: function(element) {
                return "object" === ("undefined" === typeof element ? "undefined" : _typeof(element)) && "nodeType" in element
            },
            isElementNode: function(element) {
                return element && element.nodeType === Node.ELEMENT_NODE
            },
            isTextNode: function(element) {
                return element && element.nodeType === Node.TEXT_NODE
            },
            isDocument: function(element) {
                return element && element.nodeType === Node.DOCUMENT_NODE
            },
            removeElement: function(element) {
                var parentNode = element && element.parentNode;
                if (parentNode) {
                    parentNode.removeChild(element)
                }
            },
            insertElement: function(parentElement, newElement, nextSiblingElement) {
                if (parentElement && newElement && parentElement !== newElement) {
                    if (nextSiblingElement) {
                        parentElement.insertBefore(newElement, nextSiblingElement)
                    } else {
                        parentElement.appendChild(newElement)
                    }
                }
            },
            setAttribute: function(element, name, value) {
                element.setAttribute(name, value)
            },
            removeAttribute: function(element, name) {
                element.removeAttribute(name)
            },
            setProperty: function(element, name, value) {
                element[name] = value
            },
            setText: function(element, text) {
                if (element) {
                    element.textContent = text
                }
            },
            setClass: function(element, className, isAdd) {
                if (1 === element.nodeType && className) {
                    if (element.classList) {
                        if (isAdd) {
                            element.classList.add(className)
                        } else {
                            element.classList.remove(className)
                        }
                    } else {
                        var classNames = element.className.split(" ");
                        var classIndex = classNames.indexOf(className);
                        if (isAdd && classIndex < 0) {
                            element.className = element.className ? element.className + " " + className : className
                        }
                        if (!isAdd && classIndex >= 0) {
                            classNames.splice(classIndex, 1);
                            element.className = classNames.join(" ")
                        }
                    }
                }
            },
            setStyle: function(element, name, value) {
                element.style[name] = value || ""
            },
            _document: "undefined" === typeof document ? void 0 : document,
            getDocument: function() {
                return this._document
            },
            getActiveElement: function() {
                return this._document.activeElement
            },
            getBody: function() {
                return this._document.body
            },
            createDocumentFragment: function() {
                return this._document.createDocumentFragment()
            },
            getDocumentElement: function() {
                return this._document.documentElement
            },
            getLocation: function() {
                return this._document.location
            },
            getSelection: function() {
                return this._document.selection
            },
            getReadyState: function() {
                return this._document.readyState
            },
            getHead: function() {
                return this._document.head
            },
            hasDocumentProperty: function(property) {
                return property in this._document
            },
            listen: function(element, event, callback, options) {
                if (!element || !("addEventListener" in element)) {
                    return noop
                }
                element.addEventListener(event, callback, options);
                return function() {
                    element.removeEventListener(event, callback)
                }
            }
        };
        module.exports = injector(nativeDOMAdapterStrategy)
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dom.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var elementStrategy, $ = __webpack_require__( /*! ../../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            windowUtils = __webpack_require__( /*! ./window */ 6),
            window = windowUtils.getWindow(),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            errors = __webpack_require__( /*! ../errors */ 18),
            inArray = __webpack_require__( /*! ./array */ 11).inArray,
            typeUtils = __webpack_require__( /*! ./type */ 1),
            isDefined = typeUtils.isDefined,
            isRenderer = typeUtils.isRenderer,
            htmlParser = __webpack_require__( /*! ../../core/utils/html_parser */ 226);
        var resetActiveElement = function() {
            var activeElement = domAdapter.getActiveElement();
            if (activeElement && activeElement !== domAdapter.getBody() && activeElement.blur) {
                activeElement.blur()
            }
        };
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = $(startTarget),
                $endTarget = $(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents(),
                $endParents = $endTarget.parents(),
                startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = $(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    eventsEngine.triggerHandler(changeHandlers[i], eventName)
                }
            }
        };
        var uniqueId = function() {
            var counter = 0;
            return function(prefix) {
                return (prefix || "") + counter++
            }
        }();
        var dataOptionsAttributeName = "data-options";
        var getElementOptions = function(element) {
            var result, optionsString = $(element).attr(dataOptionsAttributeName) || "";
            if ("{" !== optionsString.trim().charAt(0)) {
                optionsString = "{" + optionsString + "}"
            }
            try {
                result = new Function("return " + optionsString)()
            } catch (ex) {
                throw errors.Error("E3018", ex, optionsString)
            }
            return result
        };
        var createComponents = function(elements, componentTypes) {
            var result = [],
                selector = "[" + dataOptionsAttributeName + "]";
            var $items = elements.find(selector).add(elements.filter(selector));
            $items.each(function(index, element) {
                var $element = $(element),
                    options = getElementOptions(element);
                for (var componentName in options) {
                    if (!componentTypes || inArray(componentName, componentTypes) > -1) {
                        if ($element[componentName]) {
                            $element[componentName](options[componentName]);
                            result.push($element[componentName]("instance"))
                        }
                    }
                }
            });
            return result
        };
        var createMarkupFromString = function(str) {
            if (!window.WinJS) {
                return $(htmlParser.parseHTML(str))
            }
            var tempElement = $("<div>");
            window.WinJS.Utilities.setInnerHTMLUnsafe(tempElement.get(0), str);
            return tempElement.contents()
        };
        var normalizeTemplateElement = function normalizeTemplateElement(element) {
            var $element = isDefined(element) && (element.nodeType || isRenderer(element)) ? $(element) : $("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html().trim())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        var toggleAttr = function($target, attr, value) {
            value ? $target.attr(attr, value) : $target.removeAttr(attr)
        };
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        var contains = function(container, element) {
            if (!element) {
                return false
            }
            element = domAdapter.isTextNode(element) ? element.parentNode : element;
            return domAdapter.isDocument(container) ? container.body.contains(element) : container.contains(element)
        };
        var getPublicElement = function($element) {
            return elementStrategy($element)
        };
        var setPublicElementWrapper = function(value) {
            elementStrategy = value
        };
        setPublicElementWrapper(function(element) {
            return element && element.get(0)
        });
        exports.setPublicElementWrapper = setPublicElementWrapper;
        exports.resetActiveElement = resetActiveElement;
        exports.createMarkupFromString = createMarkupFromString;
        exports.triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.getElementOptions = getElementOptions;
        exports.createComponents = createComponents;
        exports.normalizeTemplateElement = normalizeTemplateElement;
        exports.clearSelection = clearSelection;
        exports.uniqueId = uniqueId;
        exports.closestCommonParent = closestCommonParent;
        exports.clipboardText = clipboardText;
        exports.toggleAttr = toggleAttr;
        exports.contains = contains;
        exports.getPublicElement = getPublicElement
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/localization/message.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 55),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            stringFormat = __webpack_require__( /*! ../core/utils/string */ 39).format,
            humanize = __webpack_require__( /*! ../core/utils/inflector */ 35).humanize,
            coreLocalization = __webpack_require__( /*! ./core */ 83);
        __webpack_require__( /*! ./core */ 83);
        var PARENT_LOCALE_SEPARATOR = "-";
        var baseDictionary = extend(true, {}, __webpack_require__( /*! ./default_messages */ 321));
        var parentLocales = __webpack_require__( /*! ./cldr-data/parentLocales */ 322);
        var getParentLocale = function(locale) {
            var parentLocale = parentLocales[locale];
            if (parentLocale) {
                return "root" !== parentLocale && parentLocale
            }
            return locale.substr(0, locale.lastIndexOf(PARENT_LOCALE_SEPARATOR))
        };
        var getDataByLocale = function(localeData, locale) {
            return localeData[locale] || {}
        };
        var getValueByClosestLocale = function(localeData, locale, key) {
            var isRootLocale, value = getDataByLocale(localeData, locale)[key];
            while (!value && !isRootLocale) {
                locale = getParentLocale(locale);
                if (locale) {
                    value = getDataByLocale(localeData, locale)[key]
                } else {
                    isRootLocale = true
                }
            }
            return value
        };
        var newMessages = {};
        var messageLocalization = dependencyInjector({
            _dictionary: baseDictionary,
            load: function(messages) {
                extend(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this,
                    regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g"),
                    escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var result, defaultResult = that._localizablePrefix + localizationKey;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = humanize(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            _messageLoaded: function(key, locale) {
                return void 0 !== getValueByClosestLocale(this._dictionary, locale || coreLocalization.locale(), key)
            },
            localizeNode: function(node) {
                var that = this;
                $(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!$(nodeItem).is("iframe")) {
                            each(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            $(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return extend({}, newMessages, this.getMessagesByLocales()[coreLocalization.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var message = getValueByClosestLocale(this._dictionary, locale || coreLocalization.locale(), key);
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return stringFormat.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                var values = Array.prototype.slice.call(arguments, 1);
                return formatter && formatter.apply(this, values) || ""
            }
        });
        module.exports = messageLocalization
    }, ,
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/devices.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ./utils/window */ 6),
            navigator = windowUtils.getNavigator(),
            window = windowUtils.getWindow(),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 1).isPlainObject,
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ./class */ 10),
            errors = __webpack_require__( /*! ./errors */ 18),
            Callbacks = __webpack_require__( /*! ./utils/callbacks */ 20),
            resizeCallbacks = __webpack_require__( /*! ./utils/resize_callbacks */ 132),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 53),
            SessionStorage = __webpack_require__( /*! ./utils/storage */ 154).sessionStorage,
            viewPort = __webpack_require__( /*! ./utils/view_port */ 72),
            Config = __webpack_require__( /*! ./config */ 29);
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            win8: "MSAppHost",
            win8Phone: "Windows Phone 8.0",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop",
            win10Phone: "Windows Phone 10.0",
            win10: "MSAppHost/3.0"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            win: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            win: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/),
                    isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent),
                    isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                if (!(isPhone || isTablet || isDesktop)) {
                    return
                }
                var matches = userAgent.match(/windows phone (\d+).(\d+)/i) || userAgent.match(/windows nt (\d+).(\d+)/i),
                    version = [];
                if (matches) {
                    version.push(parseInt(matches[1], 10), parseInt(matches[2], 10))
                } else {
                    matches = userAgent.match(/msapphost(\/(\d+).(\d+))?/i);
                    matches && version.push(3 === parseInt(matches[2], 10) ? 10 : 8)
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "win",
                    version: version,
                    grade: "A"
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent),
                    matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [],
                    isIPhone4 = 480 === window.screen.height,
                    grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent),
                    matches = userAgent.match(/android (\d+)\.(\d+)\.?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [],
                    worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4),
                    grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = Class.inherit({
            ctor: function(options) {
                this._window = options && options.window || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this.changed = Callbacks();
                if (windowUtils.hasWindow()) {
                    this._recalculateOrientation();
                    resizeCallbacks.add(this._recalculateOrientation.bind(this))
                }
            },
            current: function(deviceOrName) {
                if (deviceOrName) {
                    this._currentDevice = this._getDevice(deviceOrName);
                    this._forced = true;
                    this.changed.fire();
                    return
                }
                if (!this._currentDevice) {
                    deviceOrName = void 0;
                    try {
                        deviceOrName = this._getDeviceOrNameFromWindowScope()
                    } catch (e) {
                        deviceOrName = this._getDeviceNameFromSessionStorage()
                    } finally {
                        if (!deviceOrName) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        }
                        if (deviceOrName) {
                            this._forced = true
                        }
                    }
                    this._currentDevice = this._getDevice(deviceOrName)
                }
                return this._currentDevice
            },
            real: function() {
                var forceDevice = arguments[0];
                if (isPlainObject(forceDevice)) {
                    extend(this._realDevice, forceDevice);
                    return
                }
                return extend({}, this._realDevice)
            },
            orientation: function() {
                return this._currentOrientation
            },
            isForced: function() {
                return this._forced
            },
            isRippleEmulator: function() {
                return !!this._window.tinyHippos
            },
            _getCssClasses: function(device) {
                var result = [];
                var realDevice = this._realDevice;
                device = device || this.current();
                if (device.deviceType) {
                    result.push("dx-device-" + device.deviceType);
                    if ("desktop" !== device.deviceType) {
                        result.push("dx-device-mobile")
                    }
                }
                result.push("dx-device-" + realDevice.platform);
                if (realDevice.version && realDevice.version.length) {
                    result.push("dx-device-" + realDevice.platform + "-" + realDevice.version[0])
                }
                if (devices.isSimulator()) {
                    result.push("dx-simulator")
                }
                if (Config().rtlEnabled) {
                    result.push("dx-rtl")
                }
                return result
            },
            attachCssClasses: function(element, device) {
                this._deviceClasses = this._getCssClasses(device).join(" ");
                $(element).addClass(this._deviceClasses)
            },
            detachCssClasses: function(element) {
                $(element).removeClass(this._deviceClasses)
            },
            isSimulator: function() {
                try {
                    return this._isSimulator || windowUtils.hasWindow() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                } catch (e) {
                    return false
                }
            },
            forceSimulator: function() {
                this._isSimulator = true
            },
            _getDevice: function(deviceName) {
                if ("genericPhone" === deviceName) {
                    deviceName = {
                        deviceType: "phone",
                        platform: "generic",
                        generic: true
                    }
                }
                if (isPlainObject(deviceName)) {
                    return this._fromConfig(deviceName)
                } else {
                    var ua;
                    if (deviceName) {
                        ua = KNOWN_UA_TABLE[deviceName];
                        if (!ua) {
                            throw errors.Error("E0005")
                        }
                    } else {
                        ua = navigator.userAgent
                    }
                    return this._fromUA(ua)
                }
            },
            _getDeviceOrNameFromWindowScope: function() {
                var result;
                if (windowUtils.hasWindow() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                    result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                }
                return result
            },
            _getDeviceNameFromSessionStorage: function() {
                var sessionStorage = SessionStorage();
                if (!sessionStorage) {
                    return
                }
                var deviceOrName = sessionStorage.getItem("dx-force-device");
                try {
                    return JSON.parse(deviceOrName)
                } catch (ex) {
                    return deviceOrName
                }
            },
            _fromConfig: function(config) {
                var result = extend({}, DEFAULT_DEVICE, this._currentDevice, config),
                    shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        win: "win" === result.platform,
                        generic: "generic" === result.platform
                    };
                return extend(result, shortcuts)
            },
            _fromUA: function(ua) {
                var config;
                each(uaParsers, function(platform, parser) {
                    config = parser(ua);
                    return !config
                });
                if (config) {
                    return this._fromConfig(config)
                }
                var isMac = /(mac os)/.test(ua.toLowerCase()),
                    deviceWithOS = DEFAULT_DEVICE;
                deviceWithOS.mac = isMac;
                return deviceWithOS
            },
            _changeOrientation: function() {
                var $window = $(this._window),
                    orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                if (this._currentOrientation === orientation) {
                    return
                }
                this._currentOrientation = orientation;
                this.fireEvent("orientationChanged", [{
                    orientation: orientation
                }])
            },
            _recalculateOrientation: function() {
                var windowWidth = $(this._window).width();
                if (this._currentWidth === windowWidth) {
                    return
                }
                this._currentWidth = windowWidth;
                this._changeOrientation()
            }
        }).include(EventsMixin);
        var devices = new Devices;
        viewPort.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        if (!devices.isForced() && "win" === devices.current().platform) {
            devices.current({
                version: [10]
            })
        }
        module.exports = devices
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/click.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 13),
            animationFrame = __webpack_require__( /*! ../animation/frame */ 106),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            pointerEvents = __webpack_require__( /*! ./pointer */ 25),
            Emitter = __webpack_require__( /*! ./core/emitter */ 112),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 89),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 60).compare;
        var CLICK_EVENT_NAME = "dxclick",
            TOUCH_BOUNDARY = 10,
            abs = Math.abs;
        var isInput = function(element) {
            return $(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: animationFrame.requestAnimationFrame,
            cancelAnimationFrame: animationFrame.cancelAnimationFrame
        };
        var ClickEmitter = Emitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable($(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = eventUtils.eventData(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === pointerEvents.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    domUtils.resetActiveElement()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target,
                    targetChanged = !domUtils.contains(element, target) && element !== target,
                    gestureDelta = eventUtils.eventDelta(eventUtils.eventData(e), this._startEventData),
                    boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: domUtils.closestCommonParent(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var realDevice = devices.real(),
                useNativeClick = realDevice.generic || realDevice.ios && compareVersions(realDevice.version, [9, 3]) >= 0 || realDevice.android && compareVersions(realDevice.version, [5]) >= 0;
            var isNativeClickEvent = function(target) {
                return useNativeClick || $(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null,
                lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent,
                    eventAlreadyFired = lastFiredEvent !== originalEvent,
                    leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && eventAlreadyFired) {
                    lastFiredEvent = originalEvent;
                    eventUtils.fireEvent({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    eventsEngine.on($element, "click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    eventsEngine.off(this.getElement(), "click", clickHandler)
                }
            });
            exports.useNativeClick = useNativeClick
        }();
        ! function() {
            var desktopDevice = devices.real().generic;
            if (!desktopDevice) {
                var startTarget = null,
                    blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = $(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !$(startTarget).is("label") && isInput($target)) {
                        domUtils.resetActiveElement()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER",
                    document = domAdapter.getDocument();
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler);
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        registerEmitter({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        });
        exports.name = CLICK_EVENT_NAME;
        exports.misc = misc
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ./utils/error */ 104);
        module.exports = errorUtils({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0025: "Unexpected argument type",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}",
            W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
            W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
            W0016: 'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'
        })
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/themes.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            window = windowUtils.getWindow(),
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 7).Deferred,
            errors = __webpack_require__( /*! ./widget/ui.errors */ 21),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 13),
            readyCallbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 52),
            ready = readyCallbacks.add,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 72),
            themeReadyCallback = __webpack_require__( /*! ./themes_callback */ 240),
            viewPort = viewPortUtils.value,
            viewPortChanged = viewPortUtils.changeCallback;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]",
            THEME_ATTR = "data-theme",
            ACTIVE_ATTR = "data-active",
            DX_HAIRLINES_CLASS = "dx-hairlines";
        var context, $activeThemeLink, knownThemes, currentThemeName, pendingThemeName, isMaterialTheme, isAndroid5Theme, isIos7Theme, isGenericTheme, isWin8Theme, isWin10Theme;
        var timerId;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            if (!windowUtils.hasWindow()) {
                return null
            }
            var result, element = $("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            try {
                result = element.css("fontFamily");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName) {
            var waitStartTime;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                themeReadyCallback.fire();
                themeReadyCallback.empty()
            }
            if (isPendingThemeLoaded()) {
                handleLoaded()
            } else {
                waitStartTime = Date.now();
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded(),
                        isTimeout = !isLoaded && Date.now() - waitStartTime > 15e3;
                    if (isTimeout) {
                        errors.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        clearInterval(timerId);
                        timerId = void 0;
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            return !pendingThemeName || readThemeMarker() === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = $(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = $(domUtils.createMarkupFromString("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = $(this, context),
                    fullThemeName = link.attr(THEME_ATTR),
                    url = link.attr("href"),
                    isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName.split("."),
                result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }
                each(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || domAdapter.getDocument());
            if (!context) {
                return
            }
            processMarkup();
            currentThemeName = void 0;
            isMaterialTheme = void 0;
            isAndroid5Theme = void 0;
            isGenericTheme = void 0;
            isIos7Theme = void 0;
            isWin8Theme = void 0;
            isWin10Theme = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var currentThemeData, isAutoInit = options._autoInit,
                loadCallback = options.loadCallback;
            currentThemeName = options.theme || currentThemeName;
            if (isAutoInit && !currentThemeName) {
                currentThemeName = themeNameFromDevice(devices.current())
            }
            currentThemeName = resolveFullThemeName(currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (loadCallback) {
                themeReadyCallback.add(loadCallback)
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if ((themeReadyCallback.has() || options._forceTimeout) && !timerId) {
                    waitForThemeLoad(currentThemeName)
                } else {
                    if (pendingThemeName) {
                        pendingThemeName = currentThemeName
                    }
                }
            } else {
                if (isAutoInit) {
                    themeReadyCallback.fire();
                    themeReadyCallback.empty()
                } else {
                    throw errors.Error("E0021", currentThemeName)
                }
            }
            isMaterialTheme = /material/.test(currentThemeName || readThemeMarker());
            isAndroid5Theme = /android5/.test(currentThemeName || readThemeMarker());
            isIos7Theme = /ios7/.test(currentThemeName || readThemeMarker());
            isGenericTheme = /generic/.test(currentThemeName || readThemeMarker());
            isWin8Theme = /win8/.test(currentThemeName || readThemeMarker());
            isWin10Theme = /win10/.test(currentThemeName || readThemeMarker());
            checkThemeDeprecation();
            attachCssClasses(viewPortUtils.originalViewPort(), currentThemeName)
        }

        function themeNameFromDevice(device) {
            var themeName = device.platform;
            var majorVersion = device.version && device.version[0];
            switch (themeName) {
                case "ios":
                    themeName += "7";
                    break;
                case "android":
                    themeName += "5";
                    break;
                case "win":
                    themeName += majorVersion && 8 === majorVersion ? "8" : "10"
            }
            return themeName
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [],
                themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1] + (isMaterial() ? "-" + themeNameParts[2] : ""))
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            $(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = windowUtils.hasWindow() && window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = $("<div>");
                $tester.css("border", ".5px solid transparent");
                $("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    $(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            $(element).removeClass(themeClasses)
        }

        function themeReady(callback) {
            themeReadyCallback.add(callback)
        }

        function isMaterial() {
            return isMaterialTheme
        }

        function isAndroid5() {
            return isAndroid5Theme
        }

        function isIos7() {
            return isIos7Theme
        }

        function isGeneric() {
            return isGenericTheme
        }

        function isWin8() {
            return isWin8Theme
        }

        function isWin10() {
            return isWin10Theme
        }

        function checkThemeDeprecation() {
            if (isWin8()) {
                errors.log("W0010", "The 'win8' theme", "16.1", "Use the 'generic' theme instead.")
            }
            if (isWin10()) {
                errors.log("W0010", "The 'win10' theme", "17.2", "Use the 'generic' theme instead.")
            }
            if (isAndroid5()) {
                errors.log("W0010", "The 'android5' theme", "18.1", "Use the 'material' theme instead.")
            }
        }
        var initDeferred = new Deferred;

        function autoInit() {
            init({
                _autoInit: true,
                _forceTimeout: true
            });
            if ($(DX_LINK_SELECTOR, context).length) {
                throw errors.Error("E0022")
            }
            initDeferred.resolve()
        }
        if (windowUtils.hasWindow()) {
            autoInit()
        } else {
            ready(autoInit)
        }
        viewPortChanged.add(function(viewPort, prevViewPort) {
            initDeferred.done(function() {
                detachCssClasses(prevViewPort);
                attachCssClasses(viewPort)
            })
        });
        devices.changed.add(function() {
            init({
                _autoInit: true
            })
        });
        exports.current = current;
        exports.ready = themeReady;
        exports.init = init;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.themeNameFromDevice = themeNameFromDevice;
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.isMaterial = isMaterial;
        exports.isAndroid5 = isAndroid5;
        exports.isIos7 = isIos7;
        exports.isGeneric = isGeneric;
        exports.isWin8 = isWin8;
        exports.isWin10 = isWin10;
        exports.resetTheme = function() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null;
            isMaterialTheme = false;
            isAndroid5Theme = false;
            isIos7Theme = false;
            isGenericTheme = false;
            isWin8Theme = false;
            isWin10Theme = false
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/callbacks.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Callback = function(options) {
            this._options = options || {};
            this._list = [];
            this._queue = [];
            this._firing = false;
            this._fired = false;
            this._firingIndexes = []
        };
        Callback.prototype._fireCore = function(context, args) {
            var firingIndexes = this._firingIndexes,
                list = this._list,
                stopOnFalse = this._options.stopOnFalse,
                step = firingIndexes.length;
            for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                var result = list[firingIndexes[step]].apply(context, args);
                if (false === result && stopOnFalse) {
                    break
                }
            }
            firingIndexes.pop()
        };
        Callback.prototype.add = function(fn) {
            if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                this._list.push(fn)
            }
            return this
        };
        Callback.prototype.remove = function(fn) {
            var list = this._list,
                firingIndexes = this._firingIndexes,
                index = list.indexOf(fn);
            if (index > -1) {
                list.splice(index, 1);
                if (this._firing && firingIndexes.length) {
                    for (var step = 0; step < firingIndexes.length; step++) {
                        if (index <= firingIndexes[step]) {
                            firingIndexes[step]--
                        }
                    }
                }
            }
            return this
        };
        Callback.prototype.has = function(fn) {
            var list = this._list;
            return fn ? list.indexOf(fn) > -1 : !!list.length
        };
        Callback.prototype.empty = function(fn) {
            this._list = [];
            return this
        };
        Callback.prototype.fireWith = function(context, args) {
            var queue = this._queue;
            args = args || [];
            args = args.slice ? args.slice() : args;
            if (this._options.syncStrategy) {
                this._firing = true;
                this._fireCore(context, args)
            } else {
                queue.push([context, args]);
                if (this._firing) {
                    return
                }
                this._firing = true;
                while (queue.length) {
                    var memory = queue.shift();
                    this._fireCore(memory[0], memory[1])
                }
            }
            this._firing = false;
            this._fired = true;
            return this
        };
        Callback.prototype.fire = function() {
            this.fireWith(this, arguments)
        };
        Callback.prototype.fired = function() {
            return this._fired
        };
        var Callbacks = function(options) {
            return new Callback(options)
        };
        module.exports = Callbacks
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.errors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../../core/utils/error */ 104),
            errors = __webpack_require__( /*! ../../core/errors */ 18);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1036: "Validation rules are not defined for any form item",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The JSZip script is referenced after the DevExtreme scripts or not referenced at all",
            E1042: 'Deferred selection cannot be performed. Set the "key" field for the data store',
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            E1047: 'The "{0}" field is not found in the fields array',
            E1048: 'The "{0}" operation is not found in the filterOperations array',
            E1049: "Сolumn '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the '{0}' error",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view",
            W1009: "Searching works only if data is specified using the dataSource option",
            W1010: "The capability to select all items works with source data of plain structure only",
            W1011: 'The "keyExpr" option is not applied when dataSource is not an array',
            W1012: "The '{0}' key field is not found in data objects"
        })
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            adjust = __webpack_require__( /*! ./math */ 34).adjust,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            camelize = __webpack_require__( /*! ./inflector */ 35).camelize,
            isObject = typeUtils.isObject,
            isString = typeUtils.isString,
            isDate = typeUtils.isDate,
            isDefined = typeUtils.isDefined;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function toMilliseconds(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime(),
                millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i, dateUnitCount, dateUnitInterval, dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"],
                result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if (isString(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };
        var convertDateUnitToMilliseconds = function(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        };
        var getDateUnitInterval = function(tickInterval) {
            var i, maxInterval = -1;
            if (isString(tickInterval)) {
                return tickInterval
            }
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        };
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };
        var correctDateWithUnitBeginning = function(date, dateInterval, withCorrection, firstDayOfWeek) {
            date = new Date(date.getTime());
            var firstQuarterMonth, oldDate = new Date(date.getTime()),
                dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                    break;
                case "minute":
                    date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                    break;
                case "hour":
                    date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date = getFirstWeekDate(date, firstDayOfWeek || 0);
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    if (date.getMonth() !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0)
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        };
        var trimTime = function(date) {
            return dateUtils.correctDateWithUnitBeginning(date, "day")
        };
        var getDatesDifferences = function(date1, date2) {
            var differences, counter = 0;
            differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            each(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                differences.hour = true;
                counter++
            }
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime()),
                intervalObject = isString(interval) ? getDateIntervalByString(interval.toLowerCase()) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setTime(result.getTime() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return isDate(value) ? addDateInterval(value, interval, dir) : adjust(value + interval * dir, interval)
        };
        var getSequenceByInterval = function(min, max, interval) {
            var cur, intervals = [];
            intervals.push(isDate(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };
        var getLastMonthDay = function(date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        };
        var sameView = function(view, date1, date2) {
            return dateUtils[camelize("same " + view)](date1, date2)
        };
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };
        var getDateIntervalByString = function(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.weeks = 1;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        };
        var sameDate = function(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        };
        var sameMonthAndYear = function(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        };
        var sameYear = function(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        };
        var sameDecade = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10,
                startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100,
                startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };
        var getFirstDecadeInCentury = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        };
        var getFirstYearInDecade = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        };
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth(), 1);
            return newDate
        };
        var getLastMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return newDate
        };
        var getFirstWeekDate = function(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        };
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day"),
                resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var normalizeDate = function(date, min, max) {
            var normalizedDate = date;
            if (!isDefined(date)) {
                return date
            }
            if (isDefined(min) && date < min) {
                normalizedDate = min
            }
            if (isDefined(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        };
        var fixTimezoneGap = function(oldDate, newDate) {
            if (!isDefined(oldDate)) {
                return
            }
            var sign, trial, diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            sign = 1 === diff || diff === -23 ? -1 : 1;
            trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        };
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };
        var getTimezonesDifference = function(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        };
        var makeDate = function(date) {
            return new Date(date)
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            sameView: sameView,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval
        };
        module.exports = dateUtils
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/data.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 18),
            Class = __webpack_require__( /*! ../class */ 10),
            objectUtils = __webpack_require__( /*! ./object */ 51),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            each = __webpack_require__( /*! ./iterator */ 3).each,
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 70),
            unwrapVariable = variableWrapper.unwrap,
            isWrapped = variableWrapper.isWrapped,
            assign = variableWrapper.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName, options) {
            options = options || {};
            if ("this" === propName) {
                return unwrap(obj, options)
            }
            return unwrap(obj[propName], options)
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new errors.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };
        var unwrap = function(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        };
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = [].slice.call(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs,
                        current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            break
                        }
                        var next = unwrap(current[path[i]], options);
                        if (!functionAsIs && typeUtils.isFunction(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if (typeUtils.isFunction(expr)) {
                return expr
            }
        };
        var combineGetters = function(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                each(compiledGetters, function(name) {
                    var current, path, last, i, value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    current = result || (result = {});
                    path = name.split(".");
                    last = path.length - 1;
                    for (i = 0; i < last; i++) {
                        current = current[path[i]] = {}
                    }
                    current[path[i]] = value
                });
                return result
            }
        };
        var ensurePropValueDefined = function(obj, propName, value, options) {
            if (typeUtils.isDefined(value)) {
                return value
            }
            var newValue = {};
            assignPropValue(obj, propName, newValue, options);
            return newValue
        };
        var compileSetter = function(expr) {
            expr = bracketsToDots(expr || "this").split(".");
            var lastLevelIndex = expr.length - 1;
            return function(obj, value, options) {
                options = prepareOptions(options);
                var currentValue = unwrap(obj, options);
                expr.forEach(function(propertyName, levelIndex) {
                    var propertyValue = readPropValue(currentValue, propertyName, options),
                        isPropertyFunc = !options.functionsAsIs && typeUtils.isFunction(propertyValue) && !isWrapped(propertyValue);
                    if (levelIndex === lastLevelIndex) {
                        if (options.merge && typeUtils.isPlainObject(value) && (!typeUtils.isDefined(propertyValue) || typeUtils.isPlainObject(propertyValue))) {
                            propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                            objectUtils.deepExtendArraySafe(propertyValue, value, false, true)
                        } else {
                            if (isPropertyFunc) {
                                currentValue[propertyName](value)
                            } else {
                                assignPropValue(currentValue, propertyName, value, options)
                            }
                        }
                    } else {
                        propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                        if (isPropertyFunc) {
                            propertyValue = propertyValue.call(currentValue)
                        }
                        currentValue = propertyValue
                    }
                })
            }
        };
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof Class && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.compileGetter = compileGetter;
        exports.compileSetter = compileSetter;
        exports.toComparable = toComparable
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/animation/translator.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../core/element_data */ 38),
            type = __webpack_require__( /*! ../core/utils/type */ 1).type;
        var TRANSLATOR_DATA_KEY = "dxTranslator",
            TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/,
            TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };
        var move = function($element, position) {
            var translate, left = position.left,
                top = position.top;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        var isPercentValue = function(value) {
            return "string" === type(value) && "%" === value[value.length - 1]
        };
        var getTranslate = function($element) {
            var result = $element.length ? dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                        x: 0,
                        y: 0
                    }),
                    matrix = transformValue.match(TRANSFORM_MATRIX_REGEX),
                    is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        var cacheTranslate = function($element, translate) {
            if ($element.length) {
                dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        };
        var clearCache = function($element) {
            if ($element.length) {
                dataUtils.removeData($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        var resetPosition = function($element) {
            $element.css({
                left: 0,
                top: 0,
                transform: "none"
            });
            clearCache($element)
        };
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        exports.move = move;
        exports.locate = locate;
        exports.clearCache = clearCache;
        exports.parseTranslate = parseTranslate;
        exports.getTranslate = getTranslate;
        exports.getTranslateCss = getTranslateCss;
        exports.resetPosition = resetPosition
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/events/pointer.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var support = __webpack_require__( /*! ../core/utils/support */ 44),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 63),
            TouchStrategy = __webpack_require__( /*! ./pointer/touch */ 235),
            MsPointerStrategy = __webpack_require__( /*! ./pointer/mspointer */ 318),
            MouseStrategy = __webpack_require__( /*! ./pointer/mouse */ 237),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            MouseAndTouchStrategy = __webpack_require__( /*! ./pointer/mouse_and_touch */ 319);
        var EventStrategy = function() {
            if (support.pointerEvents) {
                return MsPointerStrategy
            }
            var device = devices.real();
            if (support.touch && !(device.tablet || device.phone)) {
                return MouseAndTouchStrategy
            }
            if (support.touch) {
                return TouchStrategy
            }
            return MouseStrategy
        }();
        each(EventStrategy.map, function(pointerEvent, originalEvents) {
            var eventStrategy = new EventStrategy(pointerEvent, originalEvents);
            if (pointerEvent === eventsEngine.passiveListenerEvents.eventName) {
                eventStrategy.setup = function(element, data, namespaces, handler) {
                    domAdapter.listen(element, eventsEngine.passiveListenerEvents.nativeEventName, handler, {
                        passive: false
                    });
                    return true
                }
            }
            registerEvent(pointerEvent, eventStrategy)
        });
        module.exports = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        }
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/data_grid/ui.data_grid.core.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            gridCoreUtils = __webpack_require__( /*! ../grid_core/ui.grid_core.utils */ 45),
            modules = __webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 42);
        extend(exports, modules, gridCoreUtils, {
            modules: []
        })
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.widget.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            errors = __webpack_require__( /*! ./ui.errors */ 21),
            Action = __webpack_require__( /*! ../../core/action */ 79),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 11).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 13),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 57),
            Template = __webpack_require__( /*! ./jquery.template */ 258),
            FunctionTemplate = __webpack_require__( /*! ./function_template */ 94),
            EmptyTemplate = __webpack_require__( /*! ./empty_template */ 114),
            ChildDefaultTemplate = __webpack_require__( /*! ./child_default_template */ 97),
            KeyboardProcessor = __webpack_require__( /*! ./ui.keyboard_processor */ 165),
            selectors = __webpack_require__( /*! ./selectors */ 56),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9),
            hoverEvents = __webpack_require__( /*! ../../events/hover */ 168),
            feedbackEvents = __webpack_require__( /*! ../../events/core/emitter.feedback */ 98),
            clickEvent = __webpack_require__( /*! ../../events/click */ 17),
            inflector = __webpack_require__( /*! ../../core/utils/inflector */ 35);
        var UI_FEEDBACK = "UIFeedback",
            WIDGET_CLASS = "dx-widget",
            ACTIVE_STATE_CLASS = "dx-state-active",
            DISABLED_STATE_CLASS = "dx-state-disabled",
            INVISIBLE_STATE_CLASS = "dx-state-invisible",
            HOVER_STATE_CLASS = "dx-state-hover",
            FOCUSED_STATE_CLASS = "dx-state-focused",
            FEEDBACK_SHOW_TIMEOUT = 30,
            FEEDBACK_HIDE_TIMEOUT = 400,
            FOCUS_NAMESPACE = "Focus",
            ANONYMOUS_TEMPLATE_NAME = "template",
            TEXT_NODE = 3,
            TEMPLATE_SELECTOR = "[data-options*='dxTemplate']",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper";
        var DX_POLYMORPH_WIDGET_TEMPLATE = new FunctionTemplate(function(options) {
            var widgetName = options.model.widget;
            if (widgetName) {
                var widgetElement = $("<div>"),
                    widgetOptions = options.model.options || {};
                if ("button" === widgetName || "tabs" === widgetName || "dropDownMenu" === widgetName) {
                    var deprecatedName = widgetName;
                    widgetName = inflector.camelize("dx-" + widgetName);
                    errors.log("W0001", "dxToolbar - 'widget' item field", deprecatedName, "16.1", "Use: '" + widgetName + "' instead")
                }
                widgetElement[widgetName](widgetOptions);
                return widgetElement
            }
            return $()
        });
        var Widget = DOMComponent.inherit({
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    integrationOptions: {
                        watchMethod: function(fn, callback, options) {
                            options = options || {};
                            if (!options.skipImmediate) {
                                callback(fn())
                            }
                            return commonUtils.noop
                        },
                        templates: {
                            "dx-polymorph-widget": DX_POLYMORPH_WIDGET_TEMPLATE
                        },
                        createTemplate: function(element) {
                            return new Template(element)
                        }
                    },
                    _keyboardProcessor: void 0
                })
            },
            _feedbackShowTimeout: FEEDBACK_SHOW_TIMEOUT,
            _feedbackHideTimeout: FEEDBACK_HIDE_TIMEOUT,
            _init: function() {
                this.callBase();
                this._tempTemplates = [];
                this._defaultTemplates = {};
                this._initTemplates();
                this._initContentReadyAction()
            },
            _initTemplates: function() {
                this._extractTemplates();
                this._extractAnonymousTemplate()
            },
            _extractTemplates: function() {
                var templates = this.option("integrationOptions.templates"),
                    templateElements = this.$element().contents().filter(TEMPLATE_SELECTOR);
                var templatesMap = {};
                templateElements.each(function(_, template) {
                    var templateOptions = domUtils.getElementOptions(template).dxTemplate;
                    if (!templateOptions) {
                        return
                    }
                    if (!templateOptions.name) {
                        throw errors.Error("E0023")
                    }
                    $(template).addClass(TEMPLATE_WRAPPER_CLASS).detach();
                    templatesMap[templateOptions.name] = templatesMap[templateOptions.name] || [];
                    templatesMap[templateOptions.name].push(template)
                });
                each(templatesMap, function(templateName, value) {
                    var deviceTemplate = this._findTemplateByDevice(value);
                    if (deviceTemplate) {
                        templates[templateName] = this._createTemplate(deviceTemplate)
                    }
                }.bind(this))
            },
            _findTemplateByDevice: function(templates) {
                var suitableTemplate = commonUtils.findBestMatches(devices.current(), templates, function(template) {
                    return domUtils.getElementOptions(template).dxTemplate
                })[0];
                each(templates, function(index, template) {
                    if (template !== suitableTemplate) {
                        $(template).remove()
                    }
                });
                return suitableTemplate
            },
            _extractAnonymousTemplate: function() {
                var templates = this.option("integrationOptions.templates"),
                    anonymousTemplateName = this._getAnonymousTemplateName(),
                    $anonymousTemplate = this.$element().contents().detach();
                var $notJunkTemplateContent = $anonymousTemplate.filter(function(_, element) {
                        var isTextNode = element.nodeType === TEXT_NODE,
                            isEmptyText = $(element).text().trim().length < 1;
                        return !(isTextNode && isEmptyText)
                    }),
                    onlyJunkTemplateContent = $notJunkTemplateContent.length < 1;
                if (!templates[anonymousTemplateName] && !onlyJunkTemplateContent) {
                    templates[anonymousTemplateName] = this._createTemplate($anonymousTemplate)
                }
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _getTemplateByOption: function(optionName) {
                return this._getTemplate(this.option(optionName))
            },
            _getTemplate: function(templateSource) {
                if (typeUtils.isFunction(templateSource)) {
                    return new FunctionTemplate(function(options) {
                        var templateSourceResult = templateSource.apply(this, this._getNormalizedTemplateArgs(options));
                        if (!typeUtils.isDefined(templateSourceResult)) {
                            return new EmptyTemplate
                        }
                        var dispose = false;
                        var template = this._acquireTemplate(templateSourceResult, function(templateSource) {
                            if (templateSource.nodeType || typeUtils.isRenderer(templateSource) && !$(templateSource).is("script")) {
                                return new FunctionTemplate(function() {
                                    return templateSource
                                })
                            }
                            dispose = true;
                            return this._createTemplate(templateSource)
                        }.bind(this));
                        var result = template.render(options);
                        dispose && template.dispose && template.dispose();
                        return result
                    }.bind(this))
                }
                return this._acquireTemplate(templateSource, this._createTemplateIfNeeded.bind(this))
            },
            _acquireTemplate: function(templateSource, createTemplate) {
                if (null == templateSource) {
                    return new EmptyTemplate
                }
                if (templateSource instanceof ChildDefaultTemplate) {
                    return this._defaultTemplates[templateSource.name]
                }
                if (typeUtils.isFunction(templateSource.render) && !typeUtils.isRenderer(templateSource)) {
                    return templateSource
                }
                if (templateSource.nodeType || typeUtils.isRenderer(templateSource)) {
                    templateSource = $(templateSource);
                    return createTemplate(templateSource)
                }
                if ("string" === typeof templateSource) {
                    var userTemplate = this.option("integrationOptions.templates")[templateSource];
                    if (userTemplate) {
                        return userTemplate
                    }
                    var dynamicTemplate = this._defaultTemplates[templateSource];
                    if (dynamicTemplate) {
                        return dynamicTemplate
                    }
                    return createTemplate(templateSource)
                }
                return this._acquireTemplate(templateSource.toString(), createTemplate)
            },
            _createTemplateIfNeeded: function(templateSource) {
                var templateKey = function(templateSource) {
                    return typeUtils.isRenderer(templateSource) && templateSource[0] || templateSource
                };
                var cachedTemplate = this._tempTemplates.filter(function(t) {
                    templateSource = templateKey(templateSource);
                    return t.source === templateSource
                })[0];
                if (cachedTemplate) {
                    return cachedTemplate.template
                }
                var template = this._createTemplate(templateSource);
                this._tempTemplates.push({
                    template: template,
                    source: templateKey(templateSource)
                });
                return template
            },
            _createTemplate: function(templateSource) {
                templateSource = "string" === typeof templateSource ? domUtils.normalizeTemplateElement(templateSource) : templateSource;
                return this.option("integrationOptions.createTemplate")(templateSource)
            },
            _getNormalizedTemplateArgs: function(options) {
                var args = [];
                if ("model" in options) {
                    args.push(options.model)
                }
                if ("index" in options) {
                    args.push(options.index)
                }
                args.push(options.container);
                return args
            },
            _cleanTemplates: function() {
                this._tempTemplates.forEach(function(t) {
                    t.template.dispose && t.template.dispose()
                });
                this._tempTemplates = []
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["designMode", "disabled", "readOnly"]
                })
            },
            _initMarkup: function() {
                this.$element().addClass(WIDGET_CLASS);
                this._toggleDisabledState(this.option("disabled"));
                this._toggleVisibility(this.option("visible"));
                this._renderHint();
                if (this._isFocusable()) {
                    this._renderFocusTarget()
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents()
            },
            _renderHint: function() {
                domUtils.toggleAttr(this.$element(), "title", this.option("hint"))
            },
            _renderContent: function() {
                var that = this;
                commonUtils.deferRender(function() {
                    that._renderContentImpl()
                });
                that._fireContentReadyAction()
            },
            _renderContentImpl: commonUtils.noop,
            _fireContentReadyAction: commonUtils.deferRenderer(function() {
                this._contentReadyAction()
            }),
            _dispose: function() {
                this._cleanTemplates();
                this._contentReadyAction = null;
                this.callBase()
            },
            _clean: function() {
                this._cleanFocusState();
                this.callBase();
                this.$element().empty()
            },
            _toggleVisibility: function(visible) {
                this.$element().toggleClass(INVISIBLE_STATE_CLASS, !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (!this._isFocusable()) {
                    return
                }
                this._renderFocusTarget();
                this._attachFocusEvents();
                this._renderAccessKey()
            },
            _renderAccessKey: function() {
                var focusTarget = this._focusTarget();
                focusTarget.attr("accesskey", this.option("accessKey"));
                var clickNamespace = eventUtils.addNamespace(clickEvent.name, UI_FEEDBACK);
                eventsEngine.off(focusTarget, clickNamespace);
                this.option("accessKey") && eventsEngine.on(focusTarget, clickNamespace, function(e) {
                    if (eventUtils.isFakeClickEvent(e)) {
                        e.stopImmediatePropagation();
                        this.focus()
                    }
                }.bind(this))
            },
            _isFocusable: function() {
                return this.option("focusStateEnabled") && !this.option("disabled")
            },
            _eventBindingTarget: function() {
                return this.$element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    activeElement = activeElement.find(this._activeStateUnit).not("." + DISABLED_STATE_CLASS)
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                this._focusTarget().attr("tabIndex", this.option("tabIndex"))
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _detachFocusEvents: function() {
                var $element = this._focusTarget(),
                    namespace = this.NAME + FOCUS_NAMESPACE,
                    focusEvents = eventUtils.addNamespace("focusin", namespace);
                focusEvents = focusEvents + " " + eventUtils.addNamespace("focusout", namespace);
                if (domAdapter.hasDocumentProperty("onbeforeactivate")) {
                    focusEvents = focusEvents + " " + eventUtils.addNamespace("beforeactivate", namespace)
                }
                eventsEngine.off($element, focusEvents)
            },
            _attachFocusEvents: function() {
                var namespace = this.NAME + FOCUS_NAMESPACE,
                    focusInEvent = eventUtils.addNamespace("focusin", namespace),
                    focusOutEvent = eventUtils.addNamespace("focusout", namespace);
                var $focusTarget = this._focusTarget();
                eventsEngine.on($focusTarget, focusInEvent, this._focusInHandler.bind(this));
                eventsEngine.on($focusTarget, focusOutEvent, this._focusOutHandler.bind(this));
                if (domAdapter.hasDocumentProperty("onbeforeactivate")) {
                    var beforeActivateEvent = eventUtils.addNamespace("beforeactivate", namespace);
                    eventsEngine.on(this._focusTarget(), beforeActivateEvent, function(e) {
                        if (!$(e.target).is(selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusInHandler: function(e) {
                var that = this;
                that._createActionByOption("onFocusIn", {
                    beforeExecute: function() {
                        that._updateFocusState(e, true)
                    },
                    excludeValidators: ["readOnly"]
                })({
                    event: e
                })
            },
            _focusOutHandler: function(e) {
                var that = this;
                that._createActionByOption("onFocusOut", {
                    beforeExecute: function() {
                        that._updateFocusState(e, false)
                    },
                    excludeValidators: ["readOnly", "disabled"]
                })({
                    event: e
                })
            },
            _updateFocusState: function(e, isFocused) {
                var target = e.target;
                if (inArray(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, $(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass(FOCUSED_STATE_CLASS, isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = $(element || this._focusTarget());
                return $focusTarget.hasClass(FOCUSED_STATE_CLASS)
            },
            _attachKeyboardEvents: function() {
                var processor = this.option("_keyboardProcessor");
                if (processor) {
                    this._keyboardProcessor = processor.reinitialize(this._keyboardHandler, this)
                } else {
                    if (this.option("focusStateEnabled")) {
                        this._keyboardProcessor = new KeyboardProcessor({
                            element: this._keyboardEventBindingTarget(),
                            handler: this._keyboardHandler,
                            focusTarget: this._focusTarget(),
                            context: this
                        })
                    }
                }
            },
            _keyboardHandler: function(options) {
                var e = options.originalEvent,
                    key = options.key;
                var keys = this._supportedKeys(),
                    func = keys[key];
                if (void 0 !== func) {
                    var handler = func.bind(this);
                    return handler(e) || false
                } else {
                    return true
                }
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                this._detachFocusEvents();
                this._toggleFocusClass(false);
                $element.removeAttr("tabIndex");
                if (this._keyboardProcessor) {
                    this._keyboardProcessor.dispose();
                    delete this._keyboardProcessor
                }
            },
            _attachHoverEvents: function() {
                var that = this,
                    hoverableSelector = that._activeStateUnit,
                    nameStart = eventUtils.addNamespace(hoverEvents.start, UI_FEEDBACK),
                    nameEnd = eventUtils.addNamespace(hoverEvents.end, UI_FEEDBACK);
                eventsEngine.off(that._eventBindingTarget(), nameStart, hoverableSelector);
                eventsEngine.off(that._eventBindingTarget(), nameEnd, hoverableSelector);
                if (that.option("hoverStateEnabled")) {
                    var startAction = new Action(function(args) {
                        that._hoverStartHandler(args.event);
                        that._refreshHoveredElement($(args.element))
                    }, {
                        excludeValidators: ["readOnly"]
                    });
                    var $eventBindingTarget = that._eventBindingTarget();
                    eventsEngine.on($eventBindingTarget, nameStart, hoverableSelector, function(e) {
                        startAction.execute({
                            element: $(e.target),
                            event: e
                        })
                    });
                    eventsEngine.on($eventBindingTarget, nameEnd, hoverableSelector, function(e) {
                        that._hoverEndHandler(e);
                        that._forgetHoveredElement()
                    })
                } else {
                    that._toggleHoverClass(false)
                }
            },
            _hoverStartHandler: commonUtils.noop,
            _hoverEndHandler: commonUtils.noop,
            _attachFeedbackEvents: function() {
                var feedbackAction, feedbackActionDisabled, that = this,
                    feedbackSelector = that._activeStateUnit,
                    activeEventName = eventUtils.addNamespace(feedbackEvents.active, UI_FEEDBACK),
                    inactiveEventName = eventUtils.addNamespace(feedbackEvents.inactive, UI_FEEDBACK);
                eventsEngine.off(that._eventBindingTarget(), activeEventName, feedbackSelector);
                eventsEngine.off(that._eventBindingTarget(), inactiveEventName, feedbackSelector);
                if (that.option("activeStateEnabled")) {
                    var feedbackActionHandler = function(args) {
                        var $element = $(args.element),
                            value = args.value,
                            dxEvent = args.event;
                        that._toggleActiveState($element, value, dxEvent)
                    };
                    eventsEngine.on(that._eventBindingTarget(), activeEventName, feedbackSelector, {
                        timeout: that._feedbackShowTimeout
                    }, function(e) {
                        feedbackAction = feedbackAction || new Action(feedbackActionHandler);
                        feedbackAction.execute({
                            element: $(e.currentTarget),
                            value: true,
                            event: e
                        })
                    });
                    eventsEngine.on(that._eventBindingTarget(), inactiveEventName, feedbackSelector, {
                        timeout: that._feedbackHideTimeout
                    }, function(e) {
                        feedbackActionDisabled = feedbackActionDisabled || new Action(feedbackActionHandler, {
                            excludeValidators: ["disabled", "readOnly"]
                        });
                        feedbackActionDisabled.execute({
                            element: $(e.currentTarget),
                            value: false,
                            event: e
                        })
                    })
                }
            },
            _toggleActiveState: function($element, value) {
                this._toggleHoverClass(!value);
                $element.toggleClass(ACTIVE_STATE_CLASS, value)
            },
            _refreshHoveredElement: function(hoveredElement) {
                var selector = this._activeStateUnit || this._eventBindingTarget();
                this._forgetHoveredElement();
                this._hoveredElement = hoveredElement.closest(selector);
                this._toggleHoverClass(true)
            },
            _forgetHoveredElement: function() {
                this._toggleHoverClass(false);
                delete this._hoveredElement
            },
            _toggleHoverClass: function(value) {
                if (this._hoveredElement) {
                    this._hoveredElement.toggleClass(HOVER_STATE_CLASS, value && this.option("hoverStateEnabled"))
                }
            },
            _toggleDisabledState: function(value) {
                this.$element().toggleClass(DISABLED_STATE_CLASS, Boolean(value));
                this._toggleHoverClass(!value);
                this.setAria("disabled", value || void 0)
            },
            _setWidgetOption: function(widgetName, args) {
                if (!this[widgetName]) {
                    return
                }
                if (typeUtils.isPlainObject(args[0])) {
                    each(args[0], function(option, value) {
                        this._setWidgetOption(widgetName, [option, value])
                    }.bind(this));
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this[widgetName + "OptionMap"];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                        this._toggleDisabledState(args.value);
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        break;
                    case "tabIndex":
                    case "_keyboardProcessor":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "visible":
                        var visible = args.value;
                        this._toggleVisibility(visible);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(args.value ? "shown" : "hiding")
                        }
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                return this.callBase() && this.option("visible")
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                var setAttribute = function(option) {
                    var attrName = "role" === option.name || "id" === option.name ? option.name : "aria-" + option.name,
                        attrValue = option.value;
                    if (null === attrValue || void 0 === attrValue) {
                        attrValue = void 0
                    } else {
                        attrValue = attrValue.toString()
                    }
                    domUtils.toggleAttr(option.target, attrName, attrValue)
                };
                if (!typeUtils.isPlainObject(arguments[0])) {
                    setAttribute({
                        name: arguments[0],
                        value: arguments[1],
                        target: arguments[2] || this._getAriaTarget()
                    })
                } else {
                    var $target = arguments[1] || this._getAriaTarget();
                    each(arguments[0], function(key, value) {
                        setAttribute({
                            name: key,
                            value: value,
                            target: $target
                        })
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                eventsEngine.trigger(this._focusTarget(), "focus")
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys(),
                    addingKeys = {};
                addingKeys[key] = handler;
                this._supportedKeys = function() {
                    return extend(currentKeys, addingKeys)
                }
            }
        });
        module.exports = Widget
    },
    /*!********************************!*\
      !*** external "window.jQuery" ***!
      \********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.jQuery
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/config.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extendUtils = __webpack_require__( /*! ./utils/extend */ 0);
        var config = {
            rtlEnabled: false,
            defaultCurrency: "USD",
            designMode: false,
            serverDecimalSeparator: ".",
            decimalSeparator: ".",
            thousandsSeparator: ",",
            forceIsoDateParsing: true,
            wrapActionsBeforeExecute: true,
            useJQuery: void 0
        };
        var configMethod = function() {
            if (!arguments.length) {
                return config
            }
            extendUtils.extend(config, arguments[0])
        };
        if ("undefined" !== typeof DevExpress && DevExpress.config) {
            configMethod(DevExpress.config)
        }
        module.exports = configMethod
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/browser.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend,
            windowUtils = __webpack_require__( /*! ./window */ 6),
            navigator = windowUtils.getNavigator();
        var webkitRegExp = /(webkit)[ \/]([\w.]+)/,
            ieRegExp = /(msie) (\d{1,2}\.\d)/,
            ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/,
            msEdge = /(edge)\/((\d+)?[\w\.]+)/,
            safari = /(safari)/i,
            mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {},
                matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [],
                browserName = matches[1],
                browserVersion = matches[2];
            if ("webkit" === browserName && ua.indexOf("chrome") < 0 && safari.exec(ua)) {
                browserName = "safari";
                result.webkit = true;
                browserVersion = /Version\/([0-9.]+)/i.exec(ua);
                browserVersion = browserVersion && browserVersion[1]
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        module.exports = extend({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent))
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/tree_list/ui.tree_list.core.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            modules = __webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 42);
        extend(exports, modules, {
            modules: [],
            foreachNodes: function(nodes, callBack) {
                for (var i = 0; i < nodes.length; i++) {
                    if (false !== callBack(nodes[i]) && nodes[i].hasChildren && nodes[i].children.length) {
                        this.foreachNodes(nodes[i].children, callBack)
                    }
                }
            }
        })
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/animation/fx.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            window = __webpack_require__( /*! ../core/utils/window */ 6).getWindow(),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            errors = __webpack_require__( /*! ../core/errors */ 18),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 13).getPublicElement,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            translator = __webpack_require__( /*! ./translator */ 24),
            easing = __webpack_require__( /*! ./easing */ 234),
            animationFrame = __webpack_require__( /*! ./frame */ 106),
            support = __webpack_require__( /*! ../core/utils/support */ 44),
            positionUtils = __webpack_require__( /*! ./position */ 74),
            removeEvent = __webpack_require__( /*! ../core/remove_event */ 134),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 7),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            removeEventName = eventUtils.addNamespace(removeEvent, "dxFX"),
            isFunction = typeUtils.isFunction,
            isPlainObject = typeUtils.isPlainObject,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop;
        var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i,
            ANIM_DATA_KEY = "dxAnimData",
            ANIM_QUEUE_KEY = "dxAnimQueue",
            TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this,
                    deferred = new Deferred,
                    cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            when(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var simulatedEndEventTimer, waitForJSCompleteTimer, that = this,
                    startTime = Date.now() + config.delay,
                    deferred = new Deferred,
                    transitionEndFired = new Deferred,
                    simulatedTransitionEndFired = new Deferred,
                    transitionEndEventName = support.transitionEndEventName() + ".dxFX";
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    eventsEngine.off($element, transitionEndEventName);
                    eventsEngine.off($element, removeEventName)
                };
                eventsEngine.one($element, transitionEndEventName, function() {
                    if (Date.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                });
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    when(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if (isPlainObject(config.to)) {
                        iteratorUtils.each(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = new Deferred,
                    that = this;
                if (!config) {
                    return deferred.reject().promise()
                }
                iteratorUtils.each(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: easing.convertTransitionTimingFuncToEasing(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = extend({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = iteratorUtils.map(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return translator.getTranslateCss(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    if (config.frameAnimation) {
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                iteratorUtils.each(transformString.match(/(\w|\d)+\([^\)]*\)\s*/g), function(i, part) {
                    var translateData = translator.parseTranslate(part),
                        scaleData = part.match(/scale\((.+?)\)/),
                        rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                animationFrame.cancelAnimationFrame(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = animationFrame.requestAnimationFrame(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function calcValueRecursively(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration,
                            t = currentDuration,
                            b = 1 * from[propName],
                            c = to[propName] - from[propName],
                            d = frameAnimation.duration;
                        return easing.getEasing(frameAnimation.easing)(x, t, b, c, d)
                    };
                    iteratorUtils.each(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === ("undefined" === typeof endPropValue ? "undefined" : _typeof(endPropValue)) ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return (new Deferred).resolve().promise()
            },
            stop: noop,
            isSynchronous: true
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var animationStrategies = {
                transition: support.transition() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                frame: FrameAnimationStrategy,
                noAnimation: FallbackToNoAnimationStrategy
            };
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !support.transition()) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            iteratorUtils.each(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw errors.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return isPlainObject(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = translator.locate($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = extend({ of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                translator.clearCache($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = translator.getTranslateCss({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var toOpacity, from = config.from,
                    fromOpacity = isPlainObject(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from,
                    to = config.to,
                    fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity"),
                    toOpacity = "opacity" in to ? to.opacity : 1,
                    fromScale = "scale" in from ? from.scale : 0,
                    toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = translator.getTranslate($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return translator.getTranslateCss(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw errors.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
                type: "custom",
                from: {},
                to: {},
                duration: 400,
                start: noop,
                complete: noop,
                easing: "ease",
                delay: 0
            },
            defaultCssConfig = {
                duration: 400,
                easing: "ease",
                delay: 0
            };
        var setupAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                var element = getPublicElement($element);
                config.start.apply(this, [element, config])
            }
        };
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element,
                config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                var element = getPublicElement($element);
                config.complete.apply(this, [element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = eventUtils.addNamespace(removeEvent, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            eventsEngine.off(animation.element, scopedRemoveEvent);
            eventsEngine.on(animation.element, scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                eventsEngine.off(animation.element, scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig,
                config = extend(true, {}, defaultConfig, initialConfig),
                configurator = getAnimationConfigurator(config),
                strategy = getAnimationStrategy(config),
                animation = {
                    element: $(element),
                    config: config,
                    configurator: configurator,
                    strategy: strategy,
                    isSynchronous: strategy.isSynchronous,
                    setup: setupAnimationOnElement,
                    start: startAnimationOnElement,
                    stop: stopAnimationOnElement,
                    deferred: new Deferred
                };
            if (isFunction(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = $(element);
            if (!$element.length) {
                return (new Deferred).resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };
        var pushInAnimationQueue = function($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        };
        var getAnimQueueData = function($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        };
        var writeAnimQueueData = function($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        };
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };
        var isAnimating = function($element) {
            return !!$element.data(ANIM_DATA_KEY)
        };
        var shiftFromAnimationQueue = function shiftFromAnimationQueue($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        };
        var executeAnimation = function(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        };
        var setupPosition = function($element, config) {
            var win = $(window),
                left = win.scrollLeft(),
                top = win.scrollTop();
            if (!config || !config.position) {
                return
            }
            var position = positionUtils.calculate($element, config.position),
                offset = $element.offset(),
                currentPosition = $element.position();
            extend(config, {
                left: position.h.location - offset.left + currentPosition.left - left,
                top: position.v.location - offset.top + currentPosition.top - top
            });
            delete config.position
        };
        var setProps = function($element, props) {
            iteratorUtils.each(props, function(key, value) {
                try {
                    $element.css(key, typeUtils.isFunction(value) ? value() : value)
                } catch (e) {}
            })
        };
        var stop = function(element, jumpToEnd) {
            var $element = $(element),
                queueData = getAnimQueueData($element);
            iteratorUtils.each(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        module.exports = fx
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/date.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 55),
            isString = __webpack_require__( /*! ../core/utils/type */ 1).isString,
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            getLDMLDateFormatter = __webpack_require__( /*! ./ldml/date.formatter */ 228).getFormatter,
            getLDMLDateFormat = __webpack_require__( /*! ./ldml/date.format */ 229).getFormat,
            getLDMLDateParser = __webpack_require__( /*! ./ldml/date.parser */ 312).getParser,
            defaultDateNames = __webpack_require__( /*! ./default_date_names */ 230),
            numberLocalization = __webpack_require__( /*! ./number */ 49),
            errors = __webpack_require__( /*! ../core/errors */ 18);
        __webpack_require__( /*! ./core */ 83);
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            mediumdatemediumtime: "MMMM d, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = dependencyInjector({
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format,
                    result = [];
                iteratorUtils.each(pattern.split(/\W+/), function(_, formatPart) {
                    iteratorUtils.each(possiblePartPatterns, function(partName, possiblePatterns) {
                        if (inArray(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return defaultDateNames.getMonthNames(format)
            },
            getDayNames: function(format) {
                return defaultDateNames.getDayNames(format)
            },
            getQuarterNames: function(format) {
                return defaultDateNames.getQuarterNames(format)
            },
            getPeriodNames: function(format) {
                return defaultDateNames.getPeriodNames(format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            is24HourFormat: function(format) {
                var amTime = new Date(2017, 0, 20, 11, 0, 0, 0),
                    pmTime = new Date(2017, 0, 20, 23, 0, 0, 0),
                    amTimeFormatted = this.format(amTime, format),
                    pmTimeFormatted = this.format(pmTime, format);
                for (var i = 0; i < amTimeFormatted.length; i++) {
                    if (amTimeFormatted[i] !== pmTimeFormatted[i]) {
                        return !isNaN(parseInt(amTimeFormatted[i]))
                    }
                }
            },
            format: function(date, _format) {
                if (!date) {
                    return
                }
                if (!_format) {
                    return date
                }
                var formatter;
                if ("function" === typeof _format) {
                    formatter = _format
                } else {
                    if (_format.formatter) {
                        formatter = _format.formatter
                    } else {
                        _format = _format.type || _format;
                        if (isString(_format)) {
                            _format = FORMATS_TO_PATTERN_MAP[_format.toLowerCase()] || _format;
                            return numberLocalization.convertDigits(getLDMLDateFormatter(_format, this)(date))
                        }
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var result, ldmlFormat, formatter, that = this;
                if (!text) {
                    return
                }
                if (!format) {
                    return this.parse(text, "shortdate")
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if ("string" === typeof format && !FORMATS_TO_PATTERN_MAP[format.toLowerCase()]) {
                    ldmlFormat = format
                } else {
                    formatter = function(value) {
                        var text = that.format(value, format);
                        return numberLocalization.convertDigits(text, true)
                    };
                    try {
                        ldmlFormat = getLDMLDateFormat(formatter)
                    } catch (e) {}
                }
                if (ldmlFormat) {
                    text = numberLocalization.convertDigits(text, true);
                    return getLDMLDateParser(ldmlFormat, this)(text)
                }
                errors.log("W0012");
                result = new Date(text);
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                return 0
            }
        });
        module.exports = dateLocalization
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/math.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isExponential = __webpack_require__( /*! ./type */ 1).isExponential;
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue,
                isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };

        function getExponent(value) {
            return Math.abs(parseInt(value.toExponential().split("e")[1]))
        }

        function _isEdgeBug() {
            var value = 3e-4,
                correctValue = "0.000300",
                precisionValue = 3;
            return correctValue !== value.toPrecision(precisionValue)
        }

        function adjust(value, interval) {
            var separatedAdjustedValue, precision = getPrecision(interval || 0) + 2,
                separatedValue = value.toString().split("."),
                sourceValue = value,
                absValue = Math.abs(value),
                isExponentValue = isExponential(value),
                integerPart = absValue > 1 ? 10 : 0;
            if (1 === separatedValue.length) {
                return value
            }
            if (!isExponentValue) {
                if (isExponential(interval)) {
                    precision = separatedValue[0].length + getExponent(interval)
                }
                value = absValue;
                value = value - Math.floor(value) + integerPart
            }
            precision = _isEdgeBug() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
            if (!isExponentValue) {
                separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                if (separatedAdjustedValue[0] === integerPart.toString()) {
                    return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                }
            }
            return parseFloat(sourceValue.toPrecision(precision))
        }

        function getPrecision(value) {
            var mantissa, positionOfDelimiter, str = value.toString();
            if (str.indexOf(".") < 0) {
                return 0
            }
            mantissa = str.split(".");
            positionOfDelimiter = mantissa[1].indexOf("e");
            return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
        }
        exports.sign = sign;
        exports.fitIntoRange = fitIntoRange;
        exports.inRange = inRange;
        exports.adjust = adjust;
        exports.getPrecision = getPrecision;
        exports.getExponent = getExponent
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/inflector.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = __webpack_require__( /*! ./iterator */ 3).map;
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return map(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        var camelize = function(text, upperFirst) {
            return map(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        var titleize = function(text) {
            return map(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        var captionize = function(name) {
            var i, char, captionList = [],
                isPrevCharNewWord = false,
                isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char || char in DIGIT_CHARS;
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.dasherize = dasherize;
        exports.camelize = camelize;
        exports.humanize = humanize;
        exports.titleize = titleize;
        exports.underscore = underscore;
        exports.captionize = captionize
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../core/utils/error */ 104),
            coreErrors = __webpack_require__( /*! ../core/errors */ 18),
            handlers = {};
        var errors = errorUtils(coreErrors.ERROR_MESSAGES, {
            E4000: "[DevExpress.data]: {0}",
            E4001: "Unknown aggregating function is detected: '{0}'",
            E4002: "Unsupported OData protocol version is used",
            E4003: "Unknown filter operation is used: {0}",
            E4004: "The thenby() method is called before the sortby() method",
            E4005: "Store requires a key expression for this operation",
            E4006: "ArrayStore 'data' option must be an array",
            E4007: "Compound keys cannot be auto-generated",
            E4008: "Attempt to insert an item with the a duplicated key",
            E4009: "Data item cannot be found",
            E4010: "CustomStore does not support creating queries",
            E4011: "Custom Store method is not implemented or is not a function: {0}",
            E4012: "Custom Store method returns an invalid value: {0}",
            E4013: "Local Store requires the 'name' configuration option is specified",
            E4014: "Unknown data type is specified for ODataStore: {0}",
            E4015: "Unknown entity name or alias is used: {0}",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            E4017: "Keys cannot be modified",
            E4018: "The server has returned a non-numeric value in a response to an item count request",
            E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
            E4020: "Unknown store type is detected: {0}",
            E4021: "The server response does not provide the totalCount value",
            E4022: "The server response does not provide the groupCount value",
            E4023: "Could not parse the following XML: {0}",
            W4000: "Data returned from the server has an incorrect structure",
            W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
            W4002: "Data loading has failed for some cells due to the following error: {0}"
        });

        function handleError(error) {
            var id = "E4000";
            if (error && "__id" in error) {
                id = error.__id
            }
            errors.log(id, error)
        }
        var errorHandler = null;
        var _errorHandler = function(error) {
            handleError(error);
            if (handlers.errorHandler) {
                handlers.errorHandler(error)
            }
        };
        handlers = {
            errors: errors,
            errorHandler: errorHandler,
            _errorHandler: _errorHandler
        };
        module.exports = handlers
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/button.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            iconUtils = __webpack_require__( /*! ../core/utils/icon */ 105),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 13),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            ValidationMixin = __webpack_require__( /*! ./validation/validation_mixin */ 166),
            ValidationEngine = __webpack_require__( /*! ./validation_engine */ 90),
            Widget = __webpack_require__( /*! ./widget/ui.widget */ 27),
            inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 67),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            themes = __webpack_require__( /*! ./themes */ 19),
            clickEvent = __webpack_require__( /*! ../events/click */ 17),
            FunctionTemplate = __webpack_require__( /*! ./widget/function_template */ 94);
        var BUTTON_CLASS = "dx-button",
            BUTTON_CONTENT_CLASS = "dx-button-content",
            BUTTON_HAS_TEXT_CLASS = "dx-button-has-text",
            BUTTON_HAS_ICON_CLASS = "dx-button-has-icon",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper",
            BUTTON_TEXT_CLASS = "dx-button-text",
            ANONYMOUS_TEMPLATE_NAME = "content",
            BUTTON_FEEDBACK_HIDE_TIMEOUT = 100;
        var Button = Widget.inherit({
            _supportedKeys: function() {
                var that = this,
                    click = function(e) {
                        e.preventDefault();
                        that._executeClickAction(e)
                    };
                return extend(this.callBase(), {
                    space: click,
                    enter: click
                })
            },
            _setDeprecatedOptions: function() {
                this.callBase()
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    hoverStateEnabled: true,
                    onClick: null,
                    type: "normal",
                    text: "",
                    icon: "",
                    validationGroup: void 0,
                    activeStateEnabled: true,
                    template: "content",
                    useSubmitBehavior: false,
                    useInkRipple: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        return "desktop" === devices.real().deviceType && !devices.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        return themes.isMaterial() || themes.isAndroid5()
                    },
                    options: {
                        useInkRipple: true
                    }
                }])
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _feedbackHideTimeout: BUTTON_FEEDBACK_HIDE_TIMEOUT,
            _initTemplates: function() {
                this.callBase();
                this._defaultTemplates.content = new FunctionTemplate(function(options) {
                    var data = options.model,
                        $iconElement = iconUtils.getImageContainer(data && data.icon),
                        $textContainer = data && data.text ? $("<span>").text(data.text).addClass(BUTTON_TEXT_CLASS) : void 0;
                    $(options.container).append($iconElement).append($textContainer)
                }, this)
            },
            _initMarkup: function() {
                this.$element().addClass(BUTTON_CLASS);
                this._renderType();
                this.option("useInkRipple") && this._renderInkRipple();
                this._renderClick();
                this.setAria("role", "button");
                this._updateAriaLabel();
                this.callBase();
                this._updateContent()
            },
            _renderInkRipple: function() {
                var isOnlyIconButton = !this.option("text") && this.option("icon") || "back" === this.option("type"),
                    config = {};
                if (isOnlyIconButton) {
                    extend(config, {
                        waveSizeCoefficient: 1,
                        useHoldAnimation: false,
                        isCentered: true
                    })
                }
                this._inkRipple = inkRipple.render(config)
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                if (!this._inkRipple) {
                    return
                }
                var config = {
                    element: this._$content,
                    event: e
                };
                if (value) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _updateContent: function() {
                var $element = this.$element(),
                    data = this._getContentData();
                if (this._$content) {
                    this._$content.empty()
                } else {
                    this._$content = $("<div>").addClass(BUTTON_CONTENT_CLASS).appendTo($element)
                }
                $element.toggleClass(BUTTON_HAS_ICON_CLASS, !!data.icon).toggleClass(BUTTON_HAS_TEXT_CLASS, !!data.text);
                var transclude = this._getAnonymousTemplateName() === this.option("template"),
                    template = this._getTemplateByOption("template"),
                    $result = $(template.render({
                        model: data,
                        container: domUtils.getPublicElement(this._$content),
                        transclude: transclude
                    }));
                if ($result.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                    this._$content.replaceWith($result);
                    this._$content = $result;
                    this._$content.addClass(BUTTON_CONTENT_CLASS)
                }
                if (this.option("useSubmitBehavior")) {
                    this._renderSubmitInput()
                }
            },
            _renderSubmitInput: function() {
                var submitAction = this._createAction(function(args) {
                    var e = args.event,
                        validationGroup = ValidationEngine.getGroupConfig(args.component._findGroup());
                    if (validationGroup && !validationGroup.validate().isValid) {
                        e.preventDefault()
                    }
                    e.stopPropagation()
                });
                this._$submitInput = $("<input>").attr("type", "submit").attr("tabindex", -1).addClass("dx-button-submit-input").appendTo(this._$content);
                eventsEngine.on(this._$submitInput, "click", function(e) {
                    submitAction({
                        event: e
                    })
                })
            },
            _getContentData: function() {
                var icon = this.option("icon"),
                    text = this.option("text"),
                    back = "back" === this.option("type");
                if (back && !icon) {
                    icon = "back"
                }
                return {
                    icon: icon,
                    text: text
                }
            },
            _renderClick: function() {
                var that = this,
                    eventName = eventUtils.addNamespace(clickEvent.name, this.NAME),
                    actionConfig = {};
                if (this.option("useSubmitBehavior")) {
                    actionConfig.afterExecute = function(e) {
                        setTimeout(function() {
                            e.component._$submitInput.get(0).click()
                        })
                    }
                }
                this._clickAction = this._createActionByOption("onClick", actionConfig);
                eventsEngine.off(this.$element(), eventName);
                eventsEngine.on(this.$element(), eventName, function(e) {
                    that._executeClickAction(e)
                })
            },
            _executeClickAction: function(e) {
                this._clickAction({
                    event: e,
                    validationGroup: ValidationEngine.getGroupConfig(this._findGroup())
                })
            },
            _updateAriaLabel: function() {
                var icon = this.option("icon"),
                    text = this.option("text");
                if ("image" === iconUtils.getImageSourceType(icon)) {
                    if (icon.indexOf("base64") === -1) {
                        icon = icon.replace(/.+\/([^\.]+)\..+$/, "$1")
                    } else {
                        icon = "Base64"
                    }
                }
                var ariaLabel = text || icon || "";
                ariaLabel = ariaLabel.toString().trim();
                this.setAria("label", ariaLabel)
            },
            _renderType: function() {
                var type = this.option("type");
                if (type) {
                    this.$element().addClass("dx-button-" + type)
                }
            },
            _refreshType: function(prevType) {
                var type = this.option("type");
                prevType && this.$element().removeClass("dx-button-" + prevType).addClass("dx-button-" + type);
                if (!this.$element().hasClass(BUTTON_HAS_ICON_CLASS) && "back" === type) {
                    this._updateContent()
                }
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onClick":
                        this._renderClick();
                        break;
                    case "icon":
                    case "text":
                        this._updateContent();
                        this._updateAriaLabel();
                        break;
                    case "type":
                        this._refreshType(args.previousValue);
                        this._updateContent();
                        this._updateAriaLabel();
                        break;
                    case "template":
                        this._updateContent();
                        break;
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "useSubmitBehavior":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                this.callBase();
                delete this._$content;
                delete this._inkRipple
            }
        }).include(ValidationMixin);
        registerComponent("dxButton", Button);
        module.exports = Button
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/element_data.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var WeakMap = __webpack_require__( /*! ./polyfills/weak_map */ 176);
        var domAdapter = __webpack_require__( /*! ./dom_adapter */ 12);
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 177);
        var dataMap = new WeakMap;
        var strategy;
        var strategyChanging = new MemorizedCallbacks;
        var beforeCleanData = function() {};
        var afterCleanData = function() {};
        var setDataStrategy = exports.setDataStrategy = function(value) {
            strategyChanging.fire(value);
            strategy = value;
            var cleanData = strategy.cleanData;
            strategy.cleanData = function(nodes) {
                beforeCleanData(nodes);
                var result = cleanData.call(this, nodes);
                afterCleanData(nodes);
                return result
            }
        };
        setDataStrategy({
            data: function() {
                var element = arguments[0];
                var key = arguments[1];
                var value = arguments[2];
                if (!element) {
                    return
                }
                var elementData = dataMap.get(element);
                if (!elementData) {
                    elementData = {};
                    dataMap.set(element, elementData)
                }
                if (void 0 === key) {
                    return elementData
                }
                if (2 === arguments.length) {
                    return elementData[key]
                }
                elementData[key] = value;
                return value
            },
            removeData: function(element, key) {
                if (!element) {
                    return
                }
                if (void 0 === key) {
                    dataMap.delete(element)
                } else {
                    var elementData = dataMap.get(element);
                    if (elementData) {
                        delete elementData[key]
                    }
                }
            },
            cleanData: function(elements) {
                for (var i = 0; i < elements.length; i++) {
                    eventsEngine.off(elements[i]);
                    dataMap.delete(elements[i])
                }
            }
        });
        exports.setDataStrategy = setDataStrategy;
        exports.getDataStrategy = function() {
            return strategy
        };
        exports.data = function() {
            return strategy.data.apply(this, arguments)
        };
        exports.strategyChanging = strategyChanging;
        exports.beforeCleanData = function(callback) {
            beforeCleanData = callback
        };
        exports.afterCleanData = function(callback) {
            afterCleanData = callback
        };
        exports.cleanData = function(nodes) {
            return strategy.cleanData.call(this, nodes)
        };
        exports.removeData = function(element, key) {
            return strategy.removeData.call(this, element, key)
        };
        exports.cleanDataRecursive = function(element, cleanSelf) {
            if (!domAdapter.isElementNode(element)) {
                return
            }
            var childElements = element.getElementsByTagName("*");
            strategy.cleanData(childElements);
            if (cleanSelf) {
                strategy.cleanData([element])
            }
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/string.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            commonUtils = __webpack_require__( /*! ./common */ 4);
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        var pairToObject = function(raw) {
            var pair = commonUtils.splitPair(raw),
                h = parseInt(pair && pair[0], 10),
                v = parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var quadToObject = function(raw) {
            var quad = commonUtils.splitQuad(raw),
                left = parseInt(quad && quad[0], 10),
                top = parseInt(quad && quad[1], 10),
                right = parseInt(quad && quad[2], 10),
                bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        var stringFormat = function() {
            var replaceDollarCount, reg, value, s = arguments[0],
                values = [].slice.call(arguments).slice(1);
            if (typeUtils.isFunction(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === typeUtils.type(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([\+\*\?\\\.\[\^\]\$\(\)\{\}\><\|\=\!\:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.encodeHtml = encodeHtml;
        exports.pairToObject = pairToObject;
        exports.quadToObject = quadToObject;
        exports.format = stringFormat;
        exports.replaceAll = replaceAll;
        exports.isEmpty = isEmpty
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/query.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var arrayQueryImpl = __webpack_require__( /*! ./array_query */ 148),
            remoteQueryImpl = __webpack_require__( /*! ./remote_query */ 345);
        var queryImpl = {
            array: arrayQueryImpl,
            remote: remoteQueryImpl
        };
        var query = function() {
            var impl = Array.isArray(arguments[0]) ? "array" : "remote";
            return queryImpl[impl].apply(this, arguments)
        };
        module.exports = query;
        module.exports.queryImpl = queryImpl
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/utils.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isFunction = __webpack_require__( /*! ../core/utils/type */ 1).isFunction,
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            ready = __webpack_require__( /*! ../core/utils/ready_callbacks */ 52).add,
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            window = windowUtils.getWindow(),
            map = __webpack_require__( /*! ../core/utils/iterator */ 3).map,
            toComparable = __webpack_require__( /*! ../core/utils/data */ 23).toComparable,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 7).Deferred;
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return map(info, function(i) {
                var result = {
                    selector: isFunction(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var textStatusDetails = {
                timeout: "possible causes: the remote host is not accessible, overloaded or is not included into the domain white-list when being run in the native container",
                error: "if the remote host is located on another domain, make sure it properly supports cross-origin resource sharing (CORS), or use the JSONP approach instead",
                parsererror: "the remote host did not respond with valid JSON data"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                result += " (" + textStatusDetails[textStatus] + ")";
                return result
            };
            var unloading;
            ready(function() {
                domAdapter.listen(window, "beforeunload", function() {
                    unloading = true
                })
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockDeferred, lockCount = 0;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = new Deferred
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? (new Deferred).resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|\&\&|\&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var name, names = map(key1, function(v, k) {
                    return k
                });
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if (toComparable(key1[name], true) != toComparable(key2[name], true)) {
                        return false
                    }
                }
                return true
            }
            return toComparable(key1, true) == toComparable(key2, true)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i],
                    octet2 = input[i + 1],
                    octet3 = input[i + 2];
                result += map([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };
        var stringToByteArray = function(str) {
            var code, i, bytes = [];
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        };
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            base64_encode: base64_encode
        };
        module.exports = utils
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled/ui/grid_core/ui.grid_core.modules.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            Class = __webpack_require__( /*! ../../core/class */ 10),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 20),
            grep = __webpack_require__( /*! ../../core/utils/common */ 4).grep,
            isFunction = __webpack_require__( /*! ../../core/utils/type */ 1).isFunction,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 11).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            errors = __webpack_require__( /*! ../widget/ui.errors */ 21),
            messageLocalization = __webpack_require__( /*! ../../localization/message */ 14),
            hasWindow = __webpack_require__( /*! ../../core/utils/window */ 6).hasWindow(),
            WIDGET_WITH_LEGACY_CONTAINER_NAME = "dxDataGrid";
        var ModuleItem = Class.inherit({
            _endUpdateCore: function() {},
            ctor: function(component) {
                var that = this;
                that._updateLockCount = 0;
                that.component = component;
                that._actions = {};
                that._actionConfigs = {};
                each(this.callbackNames() || [], function(index, name) {
                    var flags = that.callbackFlags(name) || {};
                    flags.unique = true, flags.syncStrategy = true;
                    that[this] = Callbacks(flags)
                })
            },
            init: function() {},
            callbackNames: function() {},
            callbackFlags: function() {},
            publicMethods: function() {},
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                if (this._updateLockCount > 0) {
                    this._updateLockCount--;
                    if (!this._updateLockCount) {
                        this._endUpdateCore()
                    }
                }
            },
            option: function(name) {
                var component = this.component,
                    optionCache = component._optionCache;
                if (1 === arguments.length && optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = component.option(name)
                    }
                    return optionCache[name]
                }
                return component.option.apply(component, arguments)
            },
            localize: function(name) {
                var optionCache = this.component._optionCache;
                if (optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = messageLocalization.format(name)
                    }
                    return optionCache[name]
                }
                return messageLocalization.format(name)
            },
            on: function() {
                return this.component.on.apply(this.component, arguments)
            },
            off: function() {
                return this.component.off.apply(this.component, arguments)
            },
            optionChanged: function(args) {
                if (args.name in this._actions) {
                    this.createAction(args.name, this._actionConfigs[args.name]);
                    args.handled = true
                }
            },
            getAction: function(actionName) {
                return this._actions[actionName]
            },
            setAria: function(name, value, $target) {
                var target = $target.get(0),
                    prefix = "role" !== name && "id" !== name ? "aria-" : "";
                if (target.setAttribute) {
                    target.setAttribute(prefix + name, value)
                } else {
                    $target.attr(prefix + name, value)
                }
            },
            _createComponent: function() {
                return this.component._createComponent.apply(this.component, arguments)
            },
            getController: function(name) {
                return this.component._controllers[name]
            },
            createAction: function(actionName, config) {
                var action;
                if (isFunction(actionName)) {
                    action = this.component._createAction(actionName.bind(this), config);
                    return function(e) {
                        action({
                            event: e
                        })
                    }
                } else {
                    this._actions[actionName] = this.component._createActionByOption(actionName, config);
                    this._actionConfigs[actionName] = config
                }
            },
            executeAction: function(actionName, options) {
                var action = this._actions[actionName];
                return action && action(options)
            },
            dispose: function() {
                var that = this;
                each(that.callbackNames() || [], function() {
                    that[this].empty()
                })
            },
            addWidgetPrefix: function(className) {
                var componentName = this.component.NAME;
                return "dx-" + componentName.slice(2).toLowerCase() + (className ? "-" + className : "")
            },
            getWidgetContainerClass: function() {
                var containerName = this.component.NAME === WIDGET_WITH_LEGACY_CONTAINER_NAME ? null : "container";
                return this.addWidgetPrefix(containerName)
            }
        });
        var Controller = ModuleItem;
        var ViewController = Controller.inherit({
            getView: function(name) {
                return this.component._views[name]
            },
            getViews: function() {
                return this.component._views
            }
        });
        var View = ModuleItem.inherit({
            _isReady: function() {
                return this.component.isReady()
            },
            _endUpdateCore: function() {
                this.callBase();
                if (!this._isReady() && this._requireReady) {
                    this._requireRender = false;
                    this.component._requireResize = false
                }
                if (this._requireRender) {
                    this._requireRender = false;
                    this.render(this._$parent)
                }
            },
            _invalidate: function(requireResize, requireReady) {
                this._requireRender = true;
                this.component._requireResize = hasWindow && (this.component._requireResize || requireResize);
                this._requireReady = this._requireReady || requireReady
            },
            _renderCore: function() {},
            _resizeCore: function() {},
            _afterRender: function() {},
            _parentElement: function() {
                return this._$parent
            },
            ctor: function(component) {
                this.callBase(component);
                this.renderCompleted = Callbacks();
                this.resizeCompleted = Callbacks()
            },
            element: function() {
                return this._$element
            },
            getElementHeight: function() {
                var $element = this.element();
                if (!$element) {
                    return 0
                }
                var marginTop = parseFloat($element.css("marginTop")) || 0,
                    marginBottom = parseFloat($element.css("marginBottom")) || 0,
                    offsetHeight = $element.get(0).offsetHeight;
                return offsetHeight + marginTop + marginBottom
            },
            isVisible: function() {
                return true
            },
            getTemplate: function(name) {
                return this.component._getTemplate(name)
            },
            render: function($parent, options) {
                var $element = this._$element,
                    isVisible = this.isVisible();
                if (!$element && !$parent) {
                    return
                }
                this._requireReady = false;
                if (!$element) {
                    $element = this._$element = $("<div>").appendTo($parent);
                    this._$parent = $parent
                }
                $element.toggleClass("dx-hidden", !isVisible);
                if (isVisible) {
                    this.component._optionCache = {};
                    this._renderCore(options);
                    this.component._optionCache = void 0;
                    this._afterRender($parent);
                    this.renderCompleted.fire(options)
                }
            },
            resize: function() {
                this.isResizing = true;
                this._resizeCore();
                this.resizeCompleted.fire();
                this.isResizing = false
            },
            focus: function() {
                eventsEngine.trigger(this.element(), "focus")
            }
        });
        var MODULES_ORDER_MAX_INDEX = 1e6;
        var processModules = function(that, componentClass) {
            var modules = componentClass.modules,
                modulesOrder = componentClass.modulesOrder,
                controllerTypes = componentClass.controllerTypes || {},
                viewTypes = componentClass.viewTypes || {};
            if (!componentClass.controllerTypes) {
                if (modulesOrder) {
                    modules.sort(function(module1, module2) {
                        var orderIndex1 = inArray(module1.name, modulesOrder);
                        var orderIndex2 = inArray(module2.name, modulesOrder);
                        if (orderIndex1 < 0) {
                            orderIndex1 = MODULES_ORDER_MAX_INDEX
                        }
                        if (orderIndex2 < 0) {
                            orderIndex2 = MODULES_ORDER_MAX_INDEX
                        }
                        return orderIndex1 - orderIndex2
                    })
                }
                each(modules, function() {
                    var controllers = this.controllers,
                        moduleName = this.name,
                        views = this.views;
                    controllers && each(controllers, function(name, type) {
                        if (controllerTypes[name]) {
                            throw errors.Error("E1001", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(Controller))) {
                                type.subclassOf(Controller);
                                throw errors.Error("E1002", moduleName, name)
                            }
                        }
                        controllerTypes[name] = type
                    });
                    views && each(views, function(name, type) {
                        if (viewTypes[name]) {
                            throw errors.Error("E1003", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(View))) {
                                throw errors.Error("E1004", moduleName, name)
                            }
                        }
                        viewTypes[name] = type
                    })
                });
                each(modules, function() {
                    var extenders = this.extenders;
                    if (extenders) {
                        extenders.controllers && each(extenders.controllers, function(name, extender) {
                            if (controllerTypes[name]) {
                                controllerTypes[name] = controllerTypes[name].inherit(extender)
                            }
                        });
                        extenders.views && each(extenders.views, function(name, extender) {
                            if (viewTypes[name]) {
                                viewTypes[name] = viewTypes[name].inherit(extender)
                            }
                        })
                    }
                });
                componentClass.controllerTypes = controllerTypes;
                componentClass.viewTypes = viewTypes
            }
            var registerPublicMethods = function(that, name, moduleItem) {
                var publicMethods = moduleItem.publicMethods();
                if (publicMethods) {
                    each(publicMethods, function(index, methodName) {
                        if (moduleItem[methodName]) {
                            if (!that[methodName]) {
                                that[methodName] = function() {
                                    return moduleItem[methodName].apply(moduleItem, arguments)
                                }
                            } else {
                                throw errors.Error("E1005", methodName)
                            }
                        } else {
                            throw errors.Error("E1006", name, methodName)
                        }
                    })
                }
            };
            var createModuleItems = function(moduleTypes) {
                var moduleItems = {};
                each(moduleTypes, function(name, moduleType) {
                    var moduleItem = new moduleType(that);
                    moduleItem.name = name;
                    registerPublicMethods(that, name, moduleItem);
                    moduleItems[name] = moduleItem
                });
                return moduleItems
            };
            that._controllers = createModuleItems(controllerTypes);
            that._views = createModuleItems(viewTypes)
        };
        var callModuleItemsMethod = function(that, methodName, args) {
            args = args || [];
            if (that._controllers) {
                each(that._controllers, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
            if (that._views) {
                each(that._views, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
        };
        module.exports = {
            modules: [],
            View: View,
            ViewController: ViewController,
            Controller: Controller,
            registerModule: function(name, module) {
                var i, modules = this.modules;
                for (i = 0; i < modules.length; i++) {
                    if (modules[i].name === name) {
                        return
                    }
                }
                module.name = name;
                modules.push(module);
                delete this.controllerTypes;
                delete this.viewTypes
            },
            registerModulesOrder: function(moduleNames) {
                this.modulesOrder = moduleNames
            },
            unregisterModule: function(name) {
                this.modules = grep(this.modules, function(module) {
                    return module.name !== name
                });
                delete this.controllerTypes;
                delete this.viewTypes
            },
            processModules: processModules,
            callModuleItemsMethod: callModuleItemsMethod
        }
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/collection/ui.collection_widget.edit.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            BaseCollectionWidget = __webpack_require__( /*! ./ui.collection_widget.base */ 344),
            errors = __webpack_require__( /*! ../widget/ui.errors */ 21),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            isDefined = __webpack_require__( /*! ../../core/utils/type */ 1).isDefined,
            PlainEditStrategy = __webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 187),
            compileGetter = __webpack_require__( /*! ../../core/utils/data */ 23).compileGetter,
            DataSource = __webpack_require__( /*! ../../data/data_source/data_source */ 50).DataSource,
            Selection = __webpack_require__( /*! ../selection/selection */ 262),
            deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 7),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred;
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting",
            NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = BaseCollectionWidget.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule();
                if ("multi" === this.option("selectionMode")) {
                    this._showDeprecatedSelectionMode()
                }
            },
            _initKeyGetter: function() {
                this._keyGetter = compileGetter(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            _getCombinedFilter: function() {
                return this._dataSource && this._dataSource.filter()
            },
            keyOf: function(item) {
                var key = item,
                    store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _initSelectionModule: function() {
                var that = this,
                    itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new Selection({
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args)
                        }
                    },
                    filter: that._getCombinedFilter.bind(that),
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: function() {
                        if (that.option("keyExpr")) {
                            return that.option("keyExpr")
                        }
                        return that._dataSource && that._dataSource.key()
                    },
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        return store ? store.load(options).done(function(items) {
                            that._dataSource._applyMapFunction(items)
                        }) : (new Deferred).resolve([])
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = PlainEditStrategy;
                this._editStrategy = new Strategy(this)
            },
            _getSelectedItemIndices: function(keys) {
                var that = this,
                    indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                that._editStrategy.beginCache();
                each(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                that._editStrategy.endCache();
                return indices
            },
            _initMarkup: function() {
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions();
                    this._normalizeSelectedItems()
                }
                this.callBase();
                var selectedItemIndices = this._getSelectedItemIndices();
                this._renderSelection(selectedItemIndices, [])
            },
            _render: function() {
                this.callBase();
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem, selectedItems, selectedIndex;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if (isDefined(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedItem", selectedItem);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        selectedItems = this.option("selectedItems") || [];
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItems[0]);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            this._syncSelectionOptions("selectedIndex");
                            return
                        }
                        this._setOptionSilent("selectedItem", selectedItems[0]);
                        this._setOptionSilent("selectedIndex", selectedIndex);
                        this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            this._syncSelectionOptions("selectedIndex");
                            return
                        }
                        if (isDefined(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedIndex", selectedIndex);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        var selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired") && !indexExists(this._getIndexByKey(selectedItemKeys[0]))) {
                            this._syncSelectionOptions("selectedIndex");
                            return
                        }
                        this._selection.setSelection(selectedItemKeys)
                }
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var isOptionDefined = function(optionName) {
                    var optionValue = this.option(optionName),
                        length = isDefined(optionValue) && optionValue.length;
                    return length || optionName in this._userOptions
                }.bind(this);
                if (isOptionDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (isOptionDefined("selectedItem")) {
                        optionName = "selectedItem"
                    } else {
                        if (isOptionDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionSilent("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionSilent("selectedItems", [normalizedSelection]);
                            this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
            },
            _renderSelection: noop,
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.event)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: $(e.currentTarget),
                    event: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var $itemElement = $(args.itemElement);
                if (this._isItemSelected(this._editStrategy.getNormalizedIndex($itemElement))) {
                    $itemElement.addClass(this._selectedItemClass());
                    this._setAriaSelected($itemElement, "true")
                } else {
                    this._setAriaSelected($itemElement, "false")
                }
            },
            _updateSelectedItems: function(args) {
                var that = this,
                    addedItemKeys = args.addedItemKeys,
                    removedItemKeys = args.removedItemKeys;
                if (that._rendered && (addedItemKeys.length || removedItemKeys.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var normalizedIndex, i, addedSelection = [],
                            removedSelection = [];
                        that._editStrategy.beginCache();
                        for (i = 0; i < addedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(addedItemKeys[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (i = 0; i < removedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(removedItemKeys[i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._editStrategy.endCache();
                        that._updateSelection(addedSelection, removedSelection)
                    }
                    when(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(args.addedItems, args.removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: function() {
                this._renderSelection.apply(this, arguments)
            },
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    $itemElement.removeClass(this._selectedItemClass());
                    this._setAriaSelected($itemElement, "false");
                    eventsEngine.triggerHandler($itemElement, "stateChanged", false)
                }
            },
            _showDeprecatedSelectionMode: function() {
                errors.log("W0001", this.NAME, "selectionMode: 'multi'", "16.1", "Use selectionMode: 'multiple' instead");
                this.option("selectionMode", "multiple")
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    $itemElement.addClass(this._selectedItemClass());
                    this._setAriaSelected($itemElement, "true");
                    eventsEngine.triggerHandler($itemElement, "stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                if (this._cancelOptionChange === args.name) {
                    return
                }
                switch (args.name) {
                    case "selectionMode":
                        if ("multi" === args.value) {
                            this._showDeprecatedSelectionMode()
                        } else {
                            this._invalidate()
                        }
                        break;
                    case "dataSource":
                        if (!args.value || Array.isArray(args.value) && !args.value.length) {
                            this.option("selectedItemKeys", [])
                        }
                        this.callBase(args);
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name);
                        this._normalizeSelectedItems();
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionSilent("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _setOptionSilent: function(name, value) {
                this._cancelOptionChange = name;
                this.option(name, value);
                this._cancelOptionChange = false
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return (new Deferred).resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = new Deferred,
                    deletingActionArgs = {
                        cancel: false
                    },
                    deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                        excludeValidators: ["disabled", "readOnly"]
                    });
                when(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise,
                        deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state(),
                        argumentsSpecified = !!arguments.length,
                        shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    when(deferredUtils.fromPromise(deletingActionArgs.cancel)).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return (new Deferred).resolve().promise()
                }
                var deferred = new Deferred,
                    disabledState = this.option("disabled"),
                    dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw errors.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = new Deferred;
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _updateIndicesAfterIndex: function(index) {
                var itemElements = this._itemElements();
                for (var i = index + 1; i < itemElements.length; i++) {
                    $(itemElements[i]).data(this._itemIndexKey(), i - 1)
                }
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys");
                    selectedItemKeys.push(key);
                    this._selection.setSelection(selectedItemKeys)
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (!this._selection.isItemSelected(key)) {
                    return
                }
                this._selection.deselect([key])
            },
            deleteItem: function(itemElement) {
                var that = this,
                    deferred = new Deferred,
                    $item = this._editStrategy.getItemElement(itemElement),
                    index = this._editStrategy.getNormalizedIndex(itemElement),
                    changingOption = this._dataSource ? "dataSource" : "items",
                    itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._updateSelectionAfterDelete(index);
                            that._updateIndicesAfterIndex(index);
                            that._editStrategy.deleteItemAtIndex(index);
                            that._simulateOptionChange(changingOption);
                            that._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                                beforeExecute: function() {
                                    $item.detach()
                                },
                                excludeValidators: ["disabled", "readOnly"]
                            });
                            that._renderEmptyMessage();
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = new Deferred,
                    that = this,
                    strategy = this._editStrategy,
                    $movingItem = strategy.getItemElement(itemElement),
                    $destinationItem = strategy.getItemElement(toItemElement),
                    movingIndex = strategy.getNormalizedIndex(itemElement),
                    destinationIndex = strategy.getNormalizedIndex(toItemElement),
                    changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    this._updateIndicesAfterIndex(movingIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        module.exports = CollectionWidget
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/support.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var inArray = __webpack_require__( /*! ./array */ 11).inArray,
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 12),
            callOnce = __webpack_require__( /*! ./call_once */ 68),
            windowUtils = __webpack_require__( /*! ./window */ 6),
            navigator = windowUtils.getNavigator(),
            devices = __webpack_require__( /*! ../devices */ 16),
            styleUtils = __webpack_require__( /*! ./style */ 82);
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var supportProp = function(prop) {
            return !!styleUtils.styleProp(prop)
        };
        var isNativeScrollingSupported = function() {
            var realDevice = devices.real(),
                realPlatform = realDevice.platform,
                realVersion = realDevice.version,
                isObsoleteAndroid = realVersion && realVersion[0] < 4 && "android" === realPlatform,
                isNativeScrollDevice = !isObsoleteAndroid && inArray(realPlatform, ["ios", "android", "win"]) > -1 || realDevice.mac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = domAdapter.createElement("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        var touchEvents = windowUtils.hasProperty("ontouchstart") && !windowUtils.hasProperty("callPhantom"),
            pointerEvents = !!navigator.pointerEnabled || !!navigator.msPointerEnabled,
            touchPointersPresent = !!navigator.maxTouchPoints || !!navigator.msMaxTouchPoints;
        exports.touchEvents = touchEvents;
        exports.pointerEvents = pointerEvents;
        exports.touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.transition = callOnce(function() {
            return supportProp("transition")
        });
        exports.transitionEndEventName = callOnce(function() {
            return transitionEndEventNames[styleUtils.styleProp("transition")]
        });
        exports.animation = callOnce(function() {
            return supportProp("animation")
        });
        exports.nativeScrolling = isNativeScrollingSupported();
        exports.styleProp = styleUtils.styleProp;
        exports.stylePropPrefix = styleUtils.stylePropPrefix;
        exports.supportProp = supportProp;
        exports.inputType = inputType
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/ui/grid_core/ui.grid_core.utils.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            filterUtils = __webpack_require__( /*! ../shared/filtering */ 192),
            stringUtils = __webpack_require__( /*! ../../core/utils/string */ 39),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 0).extendFromObject,
            toComparable = __webpack_require__( /*! ../../core/utils/data */ 23).toComparable,
            LoadPanel = __webpack_require__( /*! ../load_panel */ 197),
            dataUtils = __webpack_require__( /*! ../../data/utils */ 41),
            formatHelper = __webpack_require__( /*! ../../format_helper */ 84),
            objectUtils = __webpack_require__( /*! ../../core/utils/object */ 51),
            window = __webpack_require__( /*! ../../core/utils/window */ 6).getWindow();
        var DATAGRID_SELECTION_DISABLED_CLASS = "dx-selection-disabled",
            DATAGRID_GROUP_OPENED_CLASS = "dx-datagrid-group-opened",
            DATAGRID_GROUP_CLOSED_CLASS = "dx-datagrid-group-closed",
            DATAGRID_EXPAND_CLASS = "dx-datagrid-expand",
            NO_DATA_CLASS = "nodata",
            DATE_INTERVAL_SELECTORS = {
                year: function(value) {
                    return value && value.getFullYear()
                },
                month: function(value) {
                    return value && value.getMonth() + 1
                },
                day: function(value) {
                    return value && value.getDate()
                },
                quarter: function(value) {
                    return value && Math.floor(value.getMonth() / 3) + 1
                },
                hour: function(value) {
                    return value && value.getHours()
                },
                minute: function(value) {
                    return value && value.getMinutes()
                },
                second: function(value) {
                    return value && value.getSeconds()
                }
            };
        module.exports = function() {
            var getIntervalSelector = function() {
                var groupInterval, nameIntervalSelector, data = arguments[1],
                    value = this.calculateCellValue(data);
                if (!typeUtils.isDefined(value)) {
                    return null
                } else {
                    if (isDateType(this.dataType)) {
                        nameIntervalSelector = arguments[0];
                        return DATE_INTERVAL_SELECTORS[nameIntervalSelector](value)
                    } else {
                        if ("number" === this.dataType) {
                            groupInterval = arguments[0];
                            return Math.floor(Number(value) / groupInterval) * groupInterval
                        }
                    }
                }
            };
            var equalSelectors = function(selector1, selector2) {
                if (typeUtils.isFunction(selector1) && typeUtils.isFunction(selector2)) {
                    if (selector1.originalCallback && selector2.originalCallback) {
                        return selector1.originalCallback === selector2.originalCallback
                    }
                }
                return selector1 === selector2
            };
            var isDateType = function(dataType) {
                return "date" === dataType || "datetime" === dataType
            };
            return {
                renderNoDataText: function($element) {
                    var that = this;
                    $element = $element || this.element();
                    if (!$element) {
                        return
                    }
                    var noDataClass = that.addWidgetPrefix(NO_DATA_CLASS),
                        noDataElement = $element.find("." + noDataClass).last(),
                        isVisible = this._dataController.isEmpty(),
                        isLoading = this._dataController.isLoading();
                    if (!noDataElement.length) {
                        noDataElement = $("<span>").addClass(noDataClass).appendTo($element)
                    }
                    if (isVisible && !isLoading) {
                        noDataElement.removeClass("dx-hidden").text(that._getNoDataText())
                    } else {
                        noDataElement.addClass("dx-hidden")
                    }
                },
                renderLoadPanel: function($element, $container, isLocalStore) {
                    var loadPanelOptions, that = this;
                    that._loadPanel && that._loadPanel.$element().remove();
                    loadPanelOptions = that.option("loadPanel");
                    if (loadPanelOptions && ("auto" === loadPanelOptions.enabled ? !isLocalStore : loadPanelOptions.enabled)) {
                        loadPanelOptions = extend({
                            shading: false,
                            message: loadPanelOptions.text,
                            position: function() {
                                if ($element.height() > $(window).height()) {
                                    return { of: $(window),
                                        boundary: $element,
                                        collision: "fit"
                                    }
                                }
                                return { of: $element
                                }
                            },
                            container: $container
                        }, loadPanelOptions);
                        that._loadPanel = that._createComponent($("<div>").appendTo($container), LoadPanel, loadPanelOptions)
                    } else {
                        that._loadPanel = null
                    }
                },
                getIndexByKey: function(key, items, keyName) {
                    var item, index = -1;
                    if (void 0 !== key && Array.isArray(items)) {
                        keyName = arguments.length <= 2 ? "key" : keyName;
                        for (var i = 0; i < items.length; i++) {
                            item = typeUtils.isDefined(keyName) ? items[i][keyName] : items[i];
                            if (commonUtils.equalByValue(key, item)) {
                                index = i;
                                break
                            }
                        }
                    }
                    return index
                },
                combineFilters: function(filters, operation) {
                    var i, resultFilter = [];
                    operation = operation || "and";
                    for (i = 0; i < filters.length; i++) {
                        if (!filters[i]) {
                            continue
                        }
                        if (resultFilter.length) {
                            resultFilter.push(operation)
                        }
                        resultFilter.push(filters[i])
                    }
                    if (1 === resultFilter.length) {
                        resultFilter = resultFilter[0]
                    }
                    if (resultFilter.length) {
                        return resultFilter
                    }
                },
                checkChanges: function(changes, changeNames) {
                    var i, changesWithChangeNamesCount = 0;
                    for (i = 0; i < changeNames.length; i++) {
                        if (changes[changeNames[i]]) {
                            changesWithChangeNamesCount++
                        }
                    }
                    return changes.length && changes.length === changesWithChangeNamesCount
                },
                equalFilterParameters: function(filter1, filter2) {
                    var i;
                    if (Array.isArray(filter1) && Array.isArray(filter2)) {
                        if (filter1.length !== filter2.length) {
                            return false
                        } else {
                            for (i = 0; i < filter1.length; i++) {
                                if (!module.exports.equalFilterParameters(filter1[i], filter2[i])) {
                                    return false
                                }
                            }
                        }
                        return true
                    } else {
                        if (typeUtils.isFunction(filter1) && filter1.columnIndex >= 0 && typeUtils.isFunction(filter2) && filter2.columnIndex >= 0) {
                            return filter1.columnIndex === filter2.columnIndex
                        } else {
                            return toComparable(filter1) == toComparable(filter2)
                        }
                    }
                },
                proxyMethod: function(instance, methodName, defaultResult) {
                    if (!instance[methodName]) {
                        instance[methodName] = function() {
                            var dataSource = this._dataSource;
                            return dataSource ? dataSource[methodName].apply(dataSource, arguments) : defaultResult
                        }
                    }
                },
                formatValue: function(value, options) {
                    var valueText = formatHelper.format(value, options.format, options.precision) || value && value.toString() || "",
                        formatObject = {
                            value: value,
                            valueText: options.getDisplayFormat ? options.getDisplayFormat(valueText) : valueText,
                            target: options.target || "row",
                            groupInterval: options.groupInterval
                        };
                    return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
                },
                getFormatOptionsByColumn: function(column, target) {
                    return {
                        format: column.format,
                        precision: column.precision,
                        getDisplayFormat: column.getDisplayFormat,
                        customizeText: column.customizeText,
                        target: target,
                        trueText: column.trueText,
                        falseText: column.falseText
                    }
                },
                getDisplayValue: function(column, value, data, rowType) {
                    if (column.displayValueMap && void 0 !== column.displayValueMap[value]) {
                        return column.displayValueMap[value]
                    } else {
                        if (column.calculateDisplayValue && data && "group" !== rowType) {
                            return column.calculateDisplayValue(data)
                        } else {
                            if (column.lookup && !("group" === rowType && (column.calculateGroupValue || column.calculateDisplayValue))) {
                                return column.lookup.calculateCellValue(value)
                            }
                        }
                    }
                    return value
                },
                getGroupRowSummaryText: function(summaryItems, summaryTexts) {
                    var i, summaryItem, result = "(";
                    for (i = 0; i < summaryItems.length; i++) {
                        summaryItem = summaryItems[i];
                        result += (i > 0 ? ", " : "") + module.exports.getSummaryText(summaryItem, summaryTexts)
                    }
                    return result += ")"
                },
                getSummaryText: function(summaryItem, summaryTexts) {
                    var displayFormat = summaryItem.displayFormat || summaryItem.columnCaption && summaryTexts[summaryItem.summaryType + "OtherColumn"] || summaryTexts[summaryItem.summaryType];
                    return this.formatValue(summaryItem.value, {
                        format: summaryItem.valueFormat,
                        precision: summaryItem.precision,
                        getDisplayFormat: function(valueText) {
                            return displayFormat ? stringUtils.format(displayFormat, valueText, summaryItem.columnCaption) : valueText
                        },
                        customizeText: summaryItem.customizeText
                    })
                },
                normalizeSortingInfo: function(sort) {
                    sort = sort || [];
                    var result, i;
                    result = dataUtils.normalizeSortingInfo(sort);
                    for (i = 0; i < sort.length; i++) {
                        if (sort && sort[i] && void 0 !== sort[i].isExpanded) {
                            result[i].isExpanded = sort[i].isExpanded
                        }
                        if (sort && sort[i] && void 0 !== sort[i].groupInterval) {
                            result[i].groupInterval = sort[i].groupInterval
                        }
                    }
                    return result
                },
                getFormatByDataType: function(dataType) {
                    switch (dataType) {
                        case "date":
                            return "shortDate";
                        case "datetime":
                            return "shortDateShortTime"
                    }
                },
                getHeaderFilterGroupParameters: function(column, remoteGrouping) {
                    var result = [],
                        dataField = column.dataField || column.name,
                        groupInterval = filterUtils.getGroupInterval(column);
                    if (groupInterval) {
                        iteratorUtils.each(groupInterval, function(index, interval) {
                            result.push(remoteGrouping ? {
                                selector: dataField,
                                groupInterval: interval,
                                isExpanded: index < groupInterval.length - 1
                            } : getIntervalSelector.bind(column, interval))
                        });
                        return result
                    }
                    if (remoteGrouping) {
                        result = [{
                            selector: dataField,
                            isExpanded: false
                        }]
                    } else {
                        result = function result(data) {
                            var result = column.calculateCellValue(data);
                            if (void 0 === result || "" === result) {
                                result = null
                            }
                            return result
                        };
                        if (column.sortingMethod) {
                            result = [{
                                selector: result,
                                compare: column.sortingMethod.bind(column)
                            }]
                        }
                    }
                    return result
                },
                equalSortParameters: function(sortParameters1, sortParameters2, ignoreIsExpanded) {
                    var i;
                    sortParameters1 = module.exports.normalizeSortingInfo(sortParameters1);
                    sortParameters2 = module.exports.normalizeSortingInfo(sortParameters2);
                    if (Array.isArray(sortParameters1) && Array.isArray(sortParameters2)) {
                        if (sortParameters1.length !== sortParameters2.length) {
                            return false
                        } else {
                            for (i = 0; i < sortParameters1.length; i++) {
                                if (!equalSelectors(sortParameters1[i].selector, sortParameters2[i].selector) || sortParameters1[i].desc !== sortParameters2[i].desc || sortParameters1[i].groupInterval !== sortParameters2[i].groupInterval || !ignoreIsExpanded && Boolean(sortParameters1[i].isExpanded) !== Boolean(sortParameters2[i].isExpanded)) {
                                    return false
                                }
                            }
                        }
                        return true
                    } else {
                        return (!sortParameters1 || !sortParameters1.length) === (!sortParameters2 || !sortParameters2.length)
                    }
                },
                getPointsByColumns: function(items, pointCreated, isVertical, startColumnIndex) {
                    var point, i, item, offset, prevItemOffset, rtlEnabled, cellsLength = items.length,
                        notCreatePoint = false,
                        columnIndex = startColumnIndex || 0,
                        result = [];
                    for (i = 0; i <= cellsLength; i++) {
                        if (i < cellsLength) {
                            item = items.eq(i);
                            offset = item.offset();
                            rtlEnabled = "rtl" === item.css("direction")
                        }
                        point = {
                            index: columnIndex,
                            x: offset ? offset.left + (!isVertical && rtlEnabled ^ i === cellsLength ? item.outerWidth() : 0) : 0,
                            y: offset ? offset.top + (isVertical && i === cellsLength ? item.outerHeight() : 0) : 0,
                            columnIndex: columnIndex
                        };
                        if (!isVertical && i > 0) {
                            prevItemOffset = items.eq(i - 1).offset();
                            if (prevItemOffset.top < point.y) {
                                point.y = prevItemOffset.top
                            }
                        }
                        if (pointCreated) {
                            notCreatePoint = pointCreated(point)
                        }
                        if (!notCreatePoint) {
                            result.push(point)
                        }
                        columnIndex++
                    }
                    return result
                },
                createObjectWithChanges: function(target, changes) {
                    var result = target ? Object.create(Object.getPrototypeOf(target)) : {},
                        targetWithoutPrototype = extendFromObject({}, target);
                    objectUtils.deepExtendArraySafe(result, targetWithoutPrototype, true, true);
                    return objectUtils.deepExtendArraySafe(result, changes, true, true)
                },
                getExpandCellTemplate: function() {
                    return {
                        allowRenderToDetachedContainer: true,
                        render: function(container, options) {
                            var rowsView, $container = $(container);
                            if (typeUtils.isDefined(options.value) && !(options.data && options.data.isContinuation) && !options.row.inserted) {
                                rowsView = options.component.getView("rowsView");
                                $container.addClass(DATAGRID_EXPAND_CLASS).addClass(DATAGRID_SELECTION_DISABLED_CLASS);
                                $("<div>").addClass(options.value ? DATAGRID_GROUP_OPENED_CLASS : DATAGRID_GROUP_CLOSED_CLASS).appendTo($container);
                                rowsView.setAria("label", options.value ? rowsView.localize("dxDataGrid-ariaCollapse") : rowsView.localize("dxDataGrid-ariaExpand"), $container)
                            } else {
                                $container.get(0).innerHTML = "&nbsp;"
                            }
                        }
                    }
                },
                isDateType: isDateType,
                getSelectionRange: function(focusedElement) {
                    return focusedElement ? {
                        selectionStart: focusedElement.selectionStart,
                        selectionEnd: focusedElement.selectionEnd
                    } : {}
                },
                setSelectionRange: function(focusedElement, selectionRange) {
                    if (focusedElement && focusedElement.setSelectionRange) {
                        try {
                            focusedElement.setSelectionRange(selectionRange.selectionStart, selectionRange.selectionEnd)
                        } catch (e) {}
                    }
                }
            }
        }()
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/integration/jquery.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var jQuery = __webpack_require__( /*! jquery */ 28);
        var compareVersions = __webpack_require__( /*! ../core/utils/version */ 60).compare;
        var errors = __webpack_require__( /*! ../core/utils/error */ 104);
        var useJQuery = __webpack_require__( /*! ./jquery/use_jquery */ 76)();
        if (useJQuery && compareVersions(jQuery.fn.jquery, [1, 10]) < 0) {
            throw errors.Error("E0012")
        }
        __webpack_require__( /*! ./jquery/renderer */ 331);
        __webpack_require__( /*! ./jquery/hooks */ 332);
        __webpack_require__( /*! ./jquery/deferred */ 333);
        __webpack_require__( /*! ./jquery/hold_ready */ 334);
        __webpack_require__( /*! ./jquery/events */ 335);
        __webpack_require__( /*! ./jquery/easing */ 336);
        __webpack_require__( /*! ./jquery/element_data */ 337);
        __webpack_require__( /*! ./jquery/element */ 338);
        __webpack_require__( /*! ./jquery/component_registrator */ 339);
        __webpack_require__( /*! ./jquery/ajax */ 340)
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/ui/editor/editor.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ../../core/element_data */ 38),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 20),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 6),
            getDefaultAlignment = __webpack_require__( /*! ../../core/utils/position */ 103).getDefaultAlignment,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            Widget = __webpack_require__( /*! ../widget/ui.widget */ 27),
            ValidationMixin = __webpack_require__( /*! ../validation/validation_mixin */ 166),
            Overlay = __webpack_require__( /*! ../overlay */ 69);
        var READONLY_STATE_CLASS = "dx-state-readonly",
            INVALID_CLASS = "dx-invalid",
            INVALID_MESSAGE = "dx-invalid-message",
            INVALID_MESSAGE_AUTO = "dx-invalid-message-auto",
            INVALID_MESSAGE_ALWAYS = "dx-invalid-message-always",
            VALIDATION_TARGET = "dx-validation-target",
            VALIDATION_MESSAGE_MIN_WIDTH = 100;
        var Editor = Widget.inherit({
            _init: function() {
                this.callBase();
                this.validationRequest = Callbacks();
                var $element = this.$element();
                if ($element) {
                    dataUtils.data($element[0], VALIDATION_TARGET, this)
                }
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    }
                })
            },
            _attachKeyboardEvents: function() {
                if (this.option("readOnly")) {
                    return
                }
                this.callBase();
                if (this._keyboardProcessor) {
                    this._attachChildKeyboardEvents()
                }
            },
            _attachChildKeyboardEvents: commonUtils.noop,
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _initMarkup: function() {
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"));
                this.callBase();
                this._renderValidationState()
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    event: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid"),
                    validationError = this.option("validationError"),
                    validationMessageMode = this.option("validationMessageMode"),
                    $element = this.$element();
                $element.toggleClass(INVALID_CLASS, !isValid);
                this.setAria("invalid", !isValid || void 0);
                if (!windowUtils.hasWindow()) {
                    return
                }
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this._$validationMessage = null
                }
                if (!isValid && validationError && validationError.message) {
                    this._$validationMessage = $("<div>").addClass(INVALID_MESSAGE).html(validationError.message).appendTo($element);
                    this._validationMessage = this._createComponent(this._$validationMessage, Overlay, {
                        integrationOptions: {},
                        templatesRenderAsynchronously: false,
                        target: this._getValidationMessageTarget(),
                        shading: false,
                        width: "auto",
                        height: "auto",
                        container: $element,
                        position: this._getValidationMessagePosition("below"),
                        closeOnOutsideClick: false,
                        closeOnTargetScroll: false,
                        animation: null,
                        visible: true,
                        propagateOutsideClick: true,
                        _checkParentVisibility: false
                    });
                    this._$validationMessage.toggleClass(INVALID_MESSAGE_AUTO, "auto" === validationMessageMode).toggleClass(INVALID_MESSAGE_ALWAYS, "always" === validationMessageMode);
                    this._setValidationMessageMaxWidth()
                }
            },
            _setValidationMessageMaxWidth: function() {
                if (!this._validationMessage) {
                    return
                }
                if (0 === this._getValidationMessageTarget().outerWidth()) {
                    this._validationMessage.option("maxWidth", "100%");
                    return
                }
                var validationMessageMaxWidth = Math.max(VALIDATION_MESSAGE_MIN_WIDTH, this._getValidationMessageTarget().outerWidth());
                this._validationMessage.option("maxWidth", validationMessageMaxWidth)
            },
            _getValidationMessageTarget: function() {
                return this.$element()
            },
            _getValidationMessagePosition: function(positionRequest) {
                var rtlEnabled = this.option("rtlEnabled"),
                    messagePositionSide = getDefaultAlignment(rtlEnabled),
                    messageOriginalOffset = this.option("validationMessageOffset"),
                    messageOffset = {
                        h: messageOriginalOffset.h,
                        v: messageOriginalOffset.v
                    },
                    verticalPositions = "below" === positionRequest ? [" top", " bottom"] : [" bottom", " top"];
                if (rtlEnabled) {
                    messageOffset.h = -messageOffset.h
                }
                if ("below" !== positionRequest) {
                    messageOffset.v = -messageOffset.v
                }
                return {
                    offset: messageOffset,
                    boundary: this.option("validationBoundary"),
                    my: messagePositionSide + verticalPositions[0],
                    at: messagePositionSide + verticalPositions[1],
                    collision: "none flip"
                }
            },
            _toggleReadOnlyState: function() {
                this.$element().toggleClass(READONLY_STATE_CLASS, !!this.option("readOnly"));
                this.setAria("readonly", this.option("readOnly") || void 0)
            },
            _dispose: function() {
                var element = this.$element()[0];
                dataUtils.data(element, VALIDATION_TARGET, null);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "isValid":
                    case "validationError":
                    case "validationBoundary":
                    case "validationMessageMode":
                        this._renderValidationState();
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        this._setValidationMessageMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                var defaultOptions = this._getDefaultOptions();
                this.option("value", defaultOptions.value)
            }
        }).include(ValidationMixin);
        module.exports = Editor
    }, ,
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/localization/number.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 55),
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            escapeRegExp = __webpack_require__( /*! ../core/utils/common */ 4).escapeRegExp,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            isPlainObject = __webpack_require__( /*! ../core/utils/type */ 1).isPlainObject,
            ldmlNumber = __webpack_require__( /*! ./ldml/number */ 257),
            config = __webpack_require__( /*! ../core/config */ 29),
            errors = __webpack_require__( /*! ../core/errors */ 18);
        var MAX_LARGE_NUMBER_POWER = 4,
            DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = dependencyInjector({
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatList, formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                formatList = formatType.toLowerCase().split(" ");
                each(formatList, function(index, value) {
                    if (inArray(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value),
                    power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                var powerPostfix;
                var result;
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var powString, power = this._calculateNumberPower(value, DECIMAL_BASE),
                    number = this._getNumberByPower(value, power, DECIMAL_BASE);
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                var sign = value < 0 ? "-" : "";
                value = (Math.abs(value) * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return sign + result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, config().thousandsSeparator) + (parts[1] ? config().decimalSeparator + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : value.toFixed(formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                } else {
                    value = value.toString().replace(".", config().decimalSeparator)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!isPlainObject(format)) {
                    format = {
                        type: format
                    }
                }
                return format
            },
            _getSeparators: function() {
                return {
                    decimalSeparator: this.getDecimalSeparator(),
                    thousandsSeparator: this.getThousandsSeparator()
                }
            },
            getThousandsSeparator: function() {
                return this.format(1e3, "fixedPoint")[1]
            },
            getDecimalSeparator: function() {
                return this.format(1.2, {
                    type: "fixedPoint",
                    precision: 1
                })[1]
            },
            convertDigits: function(value, toStandard) {
                var digits = this.format(90, "decimal");
                if ("string" !== typeof value || "0" === digits[1]) {
                    return value
                }
                var fromFirstDigit = toStandard ? digits[1] : "0",
                    toFirstDigit = toStandard ? "0" : digits[1],
                    fromLastDigit = toStandard ? digits[0] : "9",
                    regExp = new RegExp("[" + fromFirstDigit + "-" + fromLastDigit + "]", "g");
                return value.replace(regExp, function(char) {
                    return String.fromCharCode(char.charCodeAt(0) + (toFirstDigit.charCodeAt(0) - fromFirstDigit.charCodeAt(0)))
                })
            },
            getSign: function(text, format) {
                if ("-" === text.replace(/[^0-9\-]/g, "").charAt(0)) {
                    return -1
                }
                if (!format) {
                    return 1
                }
                var separators = this._getSeparators(),
                    regExp = new RegExp("[0-9" + escapeRegExp(separators.decimalSeparator + separators.thousandsSeparator) + "]+", "g"),
                    negativeEtalon = this.format(-1, format).replace(regExp, "1"),
                    cleanedText = text.replace(regExp, "1");
                return cleanedText === negativeEtalon ? -1 : 1
            },
            format: function(value, _format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof _format) {
                    return value
                }
                _format = _format && _format.formatter || _format;
                if ("function" === typeof _format) {
                    return _format(value)
                }
                _format = this._normalizeFormat(_format);
                if (!_format.type) {
                    _format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(_format.type);
                if (!numberConfig) {
                    return this.convertDigits(ldmlNumber.getFormatter(_format.type, this._getSeparators())(value))
                }
                return this._formatNumber(value, numberConfig, _format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                text = this.convertDigits(text, true);
                if (format && "string" !== typeof format) {
                    errors.log("W0011")
                }
                var decimalSeparator = this.getDecimalSeparator(),
                    regExp = new RegExp("[^0-9" + escapeRegExp(decimalSeparator) + "]", "g"),
                    cleanedText = text.replace(regExp, "").replace(decimalSeparator, ".").replace(/\.$/g, ""),
                    parsed = +cleanedText;
                cleanedText = cleanedText.replace(/^\./g, "");
                if (cleanedText.length > 15) {
                    return NaN
                }
                if ("" === cleanedText) {
                    return null
                }
                return parsed * this.getSign(text, format)
            }
        });
        module.exports = numberLocalization
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/data/data_source/data_source.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../../core/class */ 10),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 71),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            dataUtils = __webpack_require__( /*! ../utils */ 41),
            Store = __webpack_require__( /*! ../abstract_store */ 95),
            ArrayStore = __webpack_require__( /*! ../array_store */ 78),
            CustomStore = __webpack_require__( /*! ../custom_store */ 169),
            EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 53),
            errors = __webpack_require__( /*! ../errors */ 36).errors,
            array = __webpack_require__( /*! ../../core/utils/array */ 11),
            queue = __webpack_require__( /*! ../../core/utils/queue */ 178),
            deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 7),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            __isString = typeUtils.isString,
            __isNumber = typeUtils.isNumeric,
            __isBoolean = typeUtils.isBoolean,
            __isDefined = typeUtils.isDefined;
        var CANCELED_TOKEN = "canceled";

        function OperationManager() {
            this._counter = -1;
            this._deferreds = {}
        }
        OperationManager.prototype.constructor = OperationManager;
        OperationManager.prototype.add = function(deferred) {
            this._counter += 1;
            this._deferreds[this._counter] = deferred;
            return this._counter
        };
        OperationManager.prototype.remove = function(operationId) {
            return delete this._deferreds[operationId]
        };
        OperationManager.prototype.cancel = function(operationId) {
            if (operationId in this._deferreds) {
                this._deferreds[operationId].reject(CANCELED_TOKEN);
                return true
            }
            return false
        };
        OperationManager.prototype.cancelAll = function() {
            while (this._counter > -1) {
                this.cancel(this._counter);
                this._counter--
            }
        };

        function isPending(deferred) {
            return "pending" === deferred.state()
        }

        function normalizeDataSourceOptions(options, normalizationOptions) {
            var store;

            function createCustomStoreFromLoadFunc() {
                var storeConfig = {};
                iteratorUtils.each(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], function() {
                    storeConfig[this] = options[this];
                    delete options[this]
                });
                return new CustomStore(storeConfig)
            }

            function createStoreFromConfig(storeConfig) {
                var alias = storeConfig.type;
                delete storeConfig.type;
                return Store.create(alias, storeConfig)
            }

            function createCustomStoreFromUrl(url) {
                return new CustomStore({
                    load: function() {
                        return ajax.sendRequest({
                            url: url,
                            dataType: "json"
                        })
                    },
                    loadMode: normalizationOptions && normalizationOptions.fromUrlLoadMode
                })
            }
            if ("string" === typeof options) {
                options = {
                    paginate: false,
                    store: createCustomStoreFromUrl(options)
                }
            }
            if (void 0 === options) {
                options = []
            }
            if (Array.isArray(options) || options instanceof Store) {
                options = {
                    store: options
                }
            } else {
                options = extend({}, options)
            }
            if (void 0 === options.store) {
                options.store = []
            }
            store = options.store;
            if ("load" in options) {
                store = createCustomStoreFromLoadFunc()
            } else {
                if (Array.isArray(store)) {
                    store = new ArrayStore(store)
                } else {
                    if (typeUtils.isPlainObject(store)) {
                        store = createStoreFromConfig(extend({}, store))
                    }
                }
            }
            options.store = store;
            return options
        }

        function normalizeStoreLoadOptionAccessorArguments(originalArguments) {
            switch (originalArguments.length) {
                case 0:
                    return;
                case 1:
                    return originalArguments[0]
            }
            return [].slice.call(originalArguments)
        }

        function generateStoreLoadOptionAccessor(optionName) {
            return function() {
                var args = normalizeStoreLoadOptionAccessorArguments(arguments);
                if (void 0 === args) {
                    return this._storeLoadOptions[optionName]
                }
                this._storeLoadOptions[optionName] = args
            }
        }

        function mapDataRespectingGrouping(items, mapper, groupInfo) {
            function mapRecursive(items, level) {
                if (!Array.isArray(items)) {
                    return items
                }
                return level ? mapGroup(items, level) : iteratorUtils.map(items, mapper)
            }

            function mapGroup(group, level) {
                return iteratorUtils.map(group, function(item) {
                    var result = {
                        key: item.key,
                        items: mapRecursive(item.items, level - 1)
                    };
                    if ("aggregates" in item) {
                        result.aggregates = item.aggregates
                    }
                    return result
                })
            }
            return mapRecursive(items, groupInfo ? dataUtils.normalizeSortingInfo(groupInfo).length : 0)
        }
        var DataSource = Class.inherit({
            ctor: function(options) {
                var that = this;
                options = normalizeDataSourceOptions(options);
                this._store = options.store;
                this._storeLoadOptions = this._extractLoadOptions(options);
                this._mapFunc = options.map;
                this._postProcessFunc = options.postProcess;
                this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                this._loadingCount = 0;
                this._loadQueue = this._createLoadQueue();
                this._searchValue = "searchValue" in options ? options.searchValue : null;
                this._searchOperation = options.searchOperation || "contains";
                this._searchExpr = options.searchExpr;
                this._paginate = options.paginate;
                iteratorUtils.each(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                    }
                });
                this._operationManager = new OperationManager;
                this._init()
            },
            _init: function() {
                this._items = [];
                this._userData = {};
                this._totalCount = -1;
                this._isLoaded = false;
                if (!__isDefined(this._paginate)) {
                    this._paginate = !this.group()
                }
                this._isLastPage = !this._paginate
            },
            dispose: function() {
                this._disposeEvents();
                delete this._store;
                if (this._delayedLoadTask) {
                    this._delayedLoadTask.abort()
                }
                this._operationManager.cancelAll();
                this._disposed = true
            },
            _extractLoadOptions: function(options) {
                var result = {},
                    names = ["sort", "filter", "select", "group", "requireTotalCount"],
                    customNames = this._store._customLoadOptions();
                if (customNames) {
                    names = names.concat(customNames)
                }
                iteratorUtils.each(names, function() {
                    result[this] = options[this]
                });
                return result
            },
            loadOptions: function() {
                return this._storeLoadOptions
            },
            items: function() {
                return this._items
            },
            pageIndex: function(newIndex) {
                if (!__isNumber(newIndex)) {
                    return this._pageIndex
                }
                this._pageIndex = newIndex;
                this._isLastPage = !this._paginate
            },
            paginate: function(value) {
                if (!__isBoolean(value)) {
                    return this._paginate
                }
                if (this._paginate !== value) {
                    this._paginate = value;
                    this.pageIndex(0)
                }
            },
            pageSize: function(value) {
                if (!__isNumber(value)) {
                    return this._pageSize
                }
                this._pageSize = value
            },
            isLastPage: function() {
                return this._isLastPage
            },
            sort: generateStoreLoadOptionAccessor("sort"),
            filter: function() {
                var newFilter = normalizeStoreLoadOptionAccessorArguments(arguments);
                if (void 0 === newFilter) {
                    return this._storeLoadOptions.filter
                }
                this._storeLoadOptions.filter = newFilter;
                this.pageIndex(0)
            },
            group: generateStoreLoadOptionAccessor("group"),
            select: generateStoreLoadOptionAccessor("select"),
            requireTotalCount: function(value) {
                if (!__isBoolean(value)) {
                    return this._storeLoadOptions.requireTotalCount
                }
                this._storeLoadOptions.requireTotalCount = value
            },
            searchValue: function(value) {
                if (arguments.length < 1) {
                    return this._searchValue
                }
                this._searchValue = value;
                this.pageIndex(0)
            },
            searchOperation: function(op) {
                if (!__isString(op)) {
                    return this._searchOperation
                }
                this._searchOperation = op;
                this.pageIndex(0)
            },
            searchExpr: function(expr) {
                var argc = arguments.length;
                if (0 === argc) {
                    return this._searchExpr
                }
                if (argc > 1) {
                    expr = [].slice.call(arguments)
                }
                this._searchExpr = expr;
                this.pageIndex(0)
            },
            store: function() {
                return this._store
            },
            key: function() {
                return this._store && this._store.key()
            },
            totalCount: function() {
                return this._totalCount
            },
            isLoaded: function() {
                return this._isLoaded
            },
            isLoading: function() {
                return this._loadingCount > 0
            },
            beginLoading: function() {
                this._changeLoadingCount(1)
            },
            endLoading: function() {
                this._changeLoadingCount(-1)
            },
            _createLoadQueue: function() {
                return queue.create()
            },
            _changeLoadingCount: function(increment) {
                var newLoading, oldLoading = this.isLoading();
                this._loadingCount += increment;
                newLoading = this.isLoading();
                if (oldLoading ^ newLoading) {
                    this.fireEvent("loadingChanged", [newLoading])
                }
            },
            _scheduleLoadCallbacks: function(deferred) {
                var that = this;
                that.beginLoading();
                deferred.always(function() {
                    that.endLoading()
                })
            },
            _scheduleFailCallbacks: function(deferred) {
                var that = this;
                deferred.fail(function() {
                    if (arguments[0] === CANCELED_TOKEN) {
                        return
                    }
                    that.fireEvent("loadError", arguments)
                })
            },
            _scheduleChangedCallbacks: function(deferred) {
                var that = this;
                deferred.done(function() {
                    that.fireEvent("changed")
                })
            },
            loadSingle: function(propName, propValue) {
                var that = this;
                var d = new Deferred,
                    key = this.key(),
                    store = this._store,
                    options = this._createStoreLoadOptions(),
                    handleDone = function(data) {
                        if (!__isDefined(data) || array.isEmpty(data)) {
                            d.reject(new errors.Error("E4009"))
                        } else {
                            if (!Array.isArray(data)) {
                                data = [data]
                            }
                            d.resolve(that._applyMapFunction(data)[0])
                        }
                    };
                this._scheduleFailCallbacks(d);
                if (arguments.length < 2) {
                    propValue = propName;
                    propName = key
                }
                delete options.skip;
                delete options.group;
                delete options.refresh;
                delete options.pageIndex;
                delete options.searchString;

                function shouldForceByKey() {
                    return store instanceof CustomStore && !store._byKeyViaLoad()
                }(function() {
                    if (propName === key || shouldForceByKey()) {
                        return store.byKey(propValue, options)
                    }
                    options.take = 1;
                    options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                    return store.load(options)
                })().fail(d.reject).done(handleDone);
                return d.promise()
            },
            load: function() {
                var loadOperation, that = this,
                    d = new Deferred;

                function loadTask() {
                    if (that._disposed) {
                        return
                    }
                    if (!isPending(d)) {
                        return
                    }
                    return that._loadFromStore(loadOperation, d)
                }
                this._scheduleLoadCallbacks(d);
                this._scheduleFailCallbacks(d);
                this._scheduleChangedCallbacks(d);
                loadOperation = this._createLoadOperation(d);
                this.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                this._loadQueue.add(function() {
                    if ("number" === typeof loadOperation.delay) {
                        that._delayedLoadTask = commonUtils.executeAsync(loadTask, loadOperation.delay)
                    } else {
                        loadTask()
                    }
                    return d.promise()
                });
                return d.promise({
                    operationId: loadOperation.operationId
                })
            },
            _createLoadOperation: function(deferred) {
                var id = this._operationManager.add(deferred),
                    options = this._createStoreLoadOptions();
                deferred.always(function() {
                    this._operationManager.remove(id)
                }.bind(this));
                return {
                    operationId: id,
                    storeLoadOptions: options
                }
            },
            reload: function() {
                var store = this.store();
                if (store instanceof CustomStore) {
                    store.clearRawDataCache()
                }
                this._init();
                return this.load()
            },
            cancel: function(operationId) {
                return this._operationManager.cancel(operationId)
            },
            _addSearchOptions: function(storeLoadOptions) {
                if (this._disposed) {
                    return
                }
                if (this.store()._useDefaultSearch) {
                    this._addSearchFilter(storeLoadOptions)
                } else {
                    storeLoadOptions.searchOperation = this._searchOperation;
                    storeLoadOptions.searchValue = this._searchValue;
                    storeLoadOptions.searchExpr = this._searchExpr
                }
            },
            _createStoreLoadOptions: function() {
                var result = extend({}, this._storeLoadOptions);
                this._addSearchOptions(result);
                if (this._paginate) {
                    if (this._pageSize) {
                        result.skip = this._pageIndex * this._pageSize;
                        result.take = this._pageSize
                    }
                }
                result.userData = this._userData;
                return result
            },
            _addSearchFilter: function(storeLoadOptions) {
                var value = this._searchValue,
                    op = this._searchOperation,
                    selector = this._searchExpr,
                    searchFilter = [];
                if (!value) {
                    return
                }
                if (!selector) {
                    selector = "this"
                }
                if (!Array.isArray(selector)) {
                    selector = [selector]
                }
                iteratorUtils.each(selector, function(i, item) {
                    if (searchFilter.length) {
                        searchFilter.push("or")
                    }
                    searchFilter.push([item, op, value])
                });
                if (storeLoadOptions.filter) {
                    storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                } else {
                    storeLoadOptions.filter = searchFilter
                }
            },
            _loadFromStore: function(loadOptions, pendingDeferred) {
                var that = this;

                function handleSuccess(data, extra) {
                    function processResult() {
                        var loadResult;
                        if (data && !Array.isArray(data) && data.data) {
                            extra = data;
                            data = data.data
                        }
                        if (!Array.isArray(data)) {
                            data = [data]
                        }
                        loadResult = extend({
                            data: data,
                            extra: extra
                        }, loadOptions);
                        that.fireEvent("customizeLoadResult", [loadResult]);
                        when(loadResult.data).done(function(data) {
                            loadResult.data = data;
                            that._processStoreLoadResult(loadResult, pendingDeferred)
                        }).fail(pendingDeferred.reject)
                    }
                    if (that._disposed) {
                        return
                    }
                    if (!isPending(pendingDeferred)) {
                        return
                    }
                    processResult()
                }
                if (loadOptions.data) {
                    return (new Deferred).resolve(loadOptions.data).done(handleSuccess)
                }
                return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
            },
            _processStoreLoadResult: function(loadResult, pendingDeferred) {
                var that = this,
                    data = loadResult.data,
                    extra = loadResult.extra,
                    storeLoadOptions = loadResult.storeLoadOptions;

                function resolvePendingDeferred() {
                    that._isLoaded = true;
                    that._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                    return pendingDeferred.resolve(data, extra)
                }

                function proceedLoadingTotalCount() {
                    that.store().totalCount(storeLoadOptions).done(function(count) {
                        extra.totalCount = count;
                        resolvePendingDeferred()
                    }).fail(pendingDeferred.reject)
                }
                if (that._disposed) {
                    return
                }
                data = that._applyPostProcessFunction(that._applyMapFunction(data));
                if (!typeUtils.isPlainObject(extra)) {
                    extra = {}
                }
                that._items = data;
                if (!data.length || !that._paginate || that._pageSize && data.length < that._pageSize) {
                    that._isLastPage = true
                }
                if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                    proceedLoadingTotalCount()
                } else {
                    resolvePendingDeferred()
                }
            },
            _applyMapFunction: function(data) {
                if (this._mapFunc) {
                    return mapDataRespectingGrouping(data, this._mapFunc, this.group())
                }
                return data
            },
            _applyPostProcessFunction: function(data) {
                if (this._postProcessFunc) {
                    return this._postProcessFunc(data)
                }
                return data
            }
        }).include(EventsMixin);
        exports.DataSource = DataSource;
        exports.normalizeDataSourceOptions = normalizeDataSourceOptions
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/object.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 70);
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        var orderEach = function(map, func) {
            var key, i, keys = [];
            for (key in map) {
                if (map.hasOwnProperty(key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = typeUtils.isNumeric(x),
                    isNumberY = typeUtils.isNumeric(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && variableWrapper.isWrapped(target[property])) {
                variableWrapper.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
            var prevValue, newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if (target === newValue) {
                    continue
                }
                if (typeUtils.isPlainObject(newValue)) {
                    var goDeeper = extendComplexObject ? typeUtils.isObject(prevValue) : typeUtils.isPlainObject(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue && prevValue !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.clone = clone;
        exports.orderEach = orderEach;
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ready_callbacks.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var injector = __webpack_require__( /*! ./dependency_injector */ 55);
        var windowUtils = __webpack_require__( /*! ./window */ 6);
        var callOnce = __webpack_require__( /*! ./call_once */ 68);
        var callbacks = [];
        var isReady = function() {
            return "complete" === domAdapter.getReadyState() || "loading" !== domAdapter.getReadyState() && !domAdapter.getDocumentElement().doScroll
        };
        var subscribeReady = callOnce(function() {
            var removeListener = domAdapter.listen(domAdapter.getDocument(), "DOMContentLoaded", function() {
                readyCallbacks.fire();
                removeListener()
            })
        });
        var readyCallbacks = {
            add: function(callback) {
                var hasWindow = windowUtils.hasWindow();
                if (hasWindow && isReady()) {
                    callback()
                } else {
                    callbacks.push(callback);
                    hasWindow && subscribeReady()
                }
            },
            fire: function() {
                callbacks.forEach(function(callback) {
                    callback()
                })
            }
        };
        module.exports = injector(readyCallbacks)
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/events_mixin.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DefaultEventsStrategy = __webpack_require__( /*! ./events_strategy */ 316),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 1).isPlainObject;
        module.exports = {
            ctor: function() {
                this._events = {};
                this.setEventsStrategy(new DefaultEventsStrategy(this))
            },
            setEventsStrategy: function(strategy) {
                if ("function" === typeof strategy) {
                    strategy = strategy(this)
                }
                this._eventsStrategy = strategy
            },
            hasEvent: function(eventName) {
                return this._eventsStrategy.hasEvent(eventName)
            },
            fireEvent: function(eventName, eventArgs) {
                this._eventsStrategy.fireEvent(eventName, eventArgs);
                return this
            },
            on: function(eventName, eventHandler) {
                if (isPlainObject(eventName)) {
                    each(eventName, function(e, h) {
                        this.on(e, h)
                    }.bind(this))
                } else {
                    this._eventsStrategy.on(eventName, eventHandler)
                }
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            },
            _disposeEvents: function() {
                this._eventsStrategy.dispose()
            }
        }
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/core/guid.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ./class */ 10);
        var Guid = Class.inherit({
            ctor: function(value) {
                if (value) {
                    value = String(value)
                }
                this._value = this._normalize(value || this._generate())
            },
            _normalize: function(value) {
                value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                while (value.length < 32) {
                    value += "0"
                }
                return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
            },
            _generate: function() {
                var value = "";
                for (var i = 0; i < 32; i++) {
                    value += Math.round(15 * Math.random()).toString(16)
                }
                return value
            },
            toString: function() {
                return this._value
            },
            valueOf: function() {
                return this._value
            },
            toJSON: function() {
                return this._value
            }
        });
        module.exports = Guid
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dependency_injector.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = function(object) {
            var extend = __webpack_require__( /*! ./extend */ 0).extend,
                isFunction = __webpack_require__( /*! ./type */ 1).isFunction,
                each = __webpack_require__( /*! ./iterator */ 3).each,
                Class = __webpack_require__( /*! ../class */ 10);
            var BaseClass = Class.inherit(object),
                InjectedClass = BaseClass,
                instance = new InjectedClass(object),
                initialFields = {};
            var injectFields = function(injectionObject, initial) {
                each(injectionObject, function(key) {
                    if (isFunction(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                extend(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/selectors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var _focusable = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase(),
                isTabIndexNotNaN = !isNaN(tabIndex),
                isDisabled = element.disabled,
                isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName),
                isHyperlink = "a" === nodeName,
                isFocusable = true,
                isContentEditable = element.isContentEditable;
            if (isDefaultFocus || isContentEditable) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };
        var visible = function(element) {
            var $element = $(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        };
        module.exports = {
            focusable: function(index, element) {
                return _focusable(element, $(element).attr("tabIndex"))
            },
            tabbable: function(index, element) {
                var tabIndex = $(element).attr("tabIndex");
                return (isNaN(tabIndex) || tabIndex >= 0) && _focusable(element, tabIndex)
            },
            focused: function($element) {
                var element = $($element).get(0);
                return domAdapter.getActiveElement() === element
            }
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/dom_component.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            config = __webpack_require__( /*! ./config */ 29),
            errors = __webpack_require__( /*! ./errors */ 18),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 13).getPublicElement,
            windowResizeCallbacks = __webpack_require__( /*! ../core/utils/resize_callbacks */ 132),
            commonUtils = __webpack_require__( /*! ./utils/common */ 4),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            inArray = __webpack_require__( /*! ./utils/array */ 11).inArray,
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 102),
            dataUtils = __webpack_require__( /*! ./element_data */ 38),
            Component = __webpack_require__( /*! ./component */ 126),
            abstract = Component.abstract;
        var RTL_DIRECTION_CLASS = "dx-rtl",
            VISIBILITY_CHANGE_CLASS = "dx-visibility-change-handler",
            VISIBILITY_CHANGE_EVENTNAMESPACE = "VisibilityChange";
        var DOMComponent = Component.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: config().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                })
            },
            ctor: function(element, options) {
                this._$element = $(element);
                publicComponentUtils.attachInstanceToElement(this._$element, this, this._dispose);
                this.callBase(options)
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && this._convertRulesToOptions(this.constructor._classCustomRules).hasOwnProperty(name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    windowResizeCallbacks.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _renderComponent: function() {
                this._initMarkup();
                if (windowUtils.hasWindow()) {
                    this._render()
                }
            },
            _initMarkup: function() {
                this._renderElementAttributes();
                this._toggleRTLDirection(this.option("rtlEnabled"));
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _render: function() {
                this._attachVisibilityChangeHandlers()
            },
            _renderElementAttributes: function() {
                var attributes = extend({}, this.option("elementAttr")),
                    classNames = attributes.class;
                delete attributes.class;
                this.$element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                this.$element().addClass(VISIBILITY_CHANGE_CLASS)
            },
            _renderDimensions: function() {
                var $element = this.$element();
                var element = $element.get(0);
                var width = this._getOptionValue("width", element);
                var height = this._getOptionValue("height", element);
                if (this._isCssUpdateRequired(element, height, width)) {
                    $element.css({
                        width: width,
                        height: height
                    })
                }
            },
            _isCssUpdateRequired: function(element, height, width) {
                return !!(width || height || element.style.width || element.style.height)
            },
            _attachDimensionChangeHandlers: function() {
                var that = this;
                var resizeEventName = "dxresize." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                eventsEngine.off(that.$element(), resizeEventName);
                eventsEngine.on(that.$element(), resizeEventName, function() {
                    that._dimensionChanged()
                })
            },
            _attachVisibilityChangeHandlers: function() {
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                var that = this;
                var hidingEventName = "dxhiding." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                var shownEventName = "dxshown." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                that._isHidden = !that._isVisible();
                eventsEngine.off(that.$element(), hidingEventName);
                eventsEngine.on(that.$element(), hidingEventName, function() {
                    that._checkVisibilityChanged("hiding")
                });
                eventsEngine.off(that.$element(), shownEventName);
                eventsEngine.on(that.$element(), shownEventName, function() {
                    that._checkVisibilityChanged("shown")
                })
            },
            _isVisible: function() {
                return this.$element().is(":visible")
            },
            _checkVisibilityChanged: function(event) {
                if ("hiding" === event && this._isVisible() && !this._isHidden) {
                    this._visibilityChanged(false);
                    this._isHidden = true
                } else {
                    if ("shown" === event && this._isVisible() && this._isHidden) {
                        this._isHidden = false;
                        this._visibilityChanged(true)
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract && windowUtils.hasWindow()
            },
            _clean: commonUtils.noop,
            _modelByElement: function() {
                var modelByElement = this.option("modelByElement") || commonUtils.noop;
                return modelByElement(this.$element())
            },
            _invalidate: function() {
                if (!this._updateLockCount) {
                    throw errors.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._renderComponent()
            },
            _dispose: function() {
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    windowResizeCallbacks.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                this.$element().toggleClass(RTL_DIRECTION_CLASS, rtl)
            },
            _createComponent: function(element, component, config) {
                var that = this;
                config = config || {};
                var synchronizableOptions = commonUtils.grep(["rtlEnabled", "disabled"], function(value) {
                    return !(value in config)
                });
                var nestedComponentOptions = that.option("nestedComponentOptions") || commonUtils.noop;
                that._extendConfig(config, extend({
                    integrationOptions: this.option("integrationOptions"),
                    rtlEnabled: this.option("rtlEnabled"),
                    disabled: this.option("disabled")
                }, nestedComponentOptions(this)));
                var instance;
                if (typeUtils.isString(component)) {
                    var $element = $(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(args) {
                        if (inArray(args.name, synchronizableOptions) >= 0) {
                            instance.option(args.name, args.value)
                        }
                    };
                    that.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        that.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                each(extendConfig, function(key, value) {
                    config[key] = config.hasOwnProperty(key) ? config[key] : value
                })
            },
            _defaultActionConfig: function() {
                return extend(this.callBase(), {
                    context: this._modelByElement(this.$element())
                })
            },
            _defaultActionArgs: function() {
                var model = this._modelByElement(this.$element());
                return extend(this.callBase(), {
                    element: this.element(),
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                    case "elementAttr":
                        this._invalidate();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _removeAttributes: function(element) {
                var i = element.attributes.length - 1;
                for (; i >= 0; i--) {
                    var attribute = element.attributes[i];
                    if (!attribute) {
                        return
                    }
                    var attributeName = attribute.name;
                    if (0 === attributeName.indexOf("aria-") || attributeName.indexOf("dx-") !== -1 || "role" === attributeName || "style" === attributeName || "tabindex" === attributeName) {
                        element.removeAttribute(attributeName)
                    }
                }
            },
            _removeClasses: function(element) {
                var classes = element.className.split(" ").filter(function(cssClass) {
                    return 0 !== cssClass.lastIndexOf("dx-", 0)
                });
                element.className = classes.join(" ")
            },
            endUpdate: function() {
                var requireRender = !this._initializing && !this._initialized;
                this.callBase.apply(this, arguments);
                if (!this._updateLockCount) {
                    if (requireRender) {
                        this._renderComponent()
                    } else {
                        if (this._requireRefresh) {
                            this._requireRefresh = false;
                            this._refresh()
                        }
                    }
                }
            },
            $element: function() {
                return this._$element
            },
            element: function() {
                return getPublicElement(this.$element())
            },
            dispose: function() {
                var element = this.$element().get(0);
                dataUtils.cleanDataRecursive(element, true);
                element.textContent = "";
                this._removeAttributes(element);
                this._removeClasses(element)
            }
        });
        DOMComponent.getInstance = function(element) {
            return publicComponentUtils.getInstanceByElement($(element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        module.exports = DOMComponent
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.ko
    },
    /*!******************************************!*\
      !*** ./artifacts/transpiled/ui/popup.js ***!
      \******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            window = __webpack_require__( /*! ../core/utils/window */ 6).getWindow(),
            translator = __webpack_require__( /*! ../animation/translator */ 24),
            camelize = __webpack_require__( /*! ../core/utils/inflector */ 35).camelize,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 13).getPublicElement,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            isDefined = __webpack_require__( /*! ../core/utils/type */ 1).isDefined,
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            messageLocalization = __webpack_require__( /*! ../localization/message */ 14),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            Button = __webpack_require__( /*! ./button */ 37),
            themes = __webpack_require__( /*! ./themes */ 19),
            Overlay = __webpack_require__( /*! ./overlay */ 69),
            EmptyTemplate = __webpack_require__( /*! ./widget/empty_template */ 114),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 13),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6);
        __webpack_require__( /*! ./toolbar/ui.toolbar.base */ 281);
        var POPUP_CLASS = "dx-popup",
            POPUP_WRAPPER_CLASS = "dx-popup-wrapper",
            POPUP_FULL_SCREEN_CLASS = "dx-popup-fullscreen",
            POPUP_FULL_SCREEN_WIDTH_CLASS = "dx-popup-fullscreen-width",
            POPUP_NORMAL_CLASS = "dx-popup-normal",
            POPUP_CONTENT_CLASS = "dx-popup-content",
            POPUP_DRAGGABLE_CLASS = "dx-popup-draggable",
            POPUP_TITLE_CLASS = "dx-popup-title",
            POPUP_TITLE_CLOSEBUTTON_CLASS = "dx-closebutton",
            POPUP_BOTTOM_CLASS = "dx-popup-bottom",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper",
            ALLOWED_TOOLBAR_ITEM_ALIASES = ["cancel", "clear", "done"],
            BUTTON_DEFAULT_TYPE = "default",
            BUTTON_NORMAL_TYPE = "normal",
            BUTTON_FLAT_CLASS = "dx-button-flat";
        var getButtonPlace = function(name) {
            var device = devices.current(),
                platform = device.platform,
                toolbar = "bottom",
                location = "before";
            if ("ios" === platform) {
                switch (name) {
                    case "cancel":
                        toolbar = "top";
                        break;
                    case "clear":
                        toolbar = "top";
                        location = "after";
                        break;
                    case "done":
                        location = "after"
                }
            } else {
                if ("win" === platform) {
                    location = "after"
                } else {
                    if ("android" === platform && device.version && parseInt(device.version[0]) > 4) {
                        switch (name) {
                            case "cancel":
                                location = "after";
                                break;
                            case "done":
                                location = "after"
                        }
                    } else {
                        if ("android" === platform) {
                            location = "center"
                        }
                    }
                }
            }
            return {
                toolbar: toolbar,
                location: location
            }
        };
        var Popup = Overlay.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    fullScreen: false,
                    title: "",
                    showTitle: true,
                    titleTemplate: "title",
                    onTitleRendered: null,
                    dragEnabled: false,
                    toolbarItems: [],
                    showCloseButton: false,
                    bottomTemplate: "bottom",
                    useDefaultToolbarButtons: false,
                    useFlatToolbarButtons: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function(_device) {
                        return _device.phone && themes.isWin8()
                    },
                    options: {
                        position: {
                            my: "top center",
                            at: "top center",
                            offset: "0 0"
                        }
                    }
                }, {
                    device: {
                        platform: "ios"
                    },
                    options: {
                        animation: this._iosAnimation
                    }
                }, {
                    device: {
                        platform: "android"
                    },
                    options: {
                        animation: this._androidAnimation
                    }
                }, {
                    device: {
                        platform: "generic"
                    },
                    options: {
                        showCloseButton: true
                    }
                }, {
                    device: function(_device2) {
                        return "generic" === devices.real().platform && "generic" === _device2.platform
                    },
                    options: {
                        dragEnabled: true
                    }
                }, {
                    device: function() {
                        return "desktop" === devices.real().deviceType && !devices.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        return themes.isMaterial()
                    },
                    options: {
                        useDefaultToolbarButtons: true,
                        useFlatToolbarButtons: true
                    }
                }])
            },
            _iosAnimation: {
                show: {
                    type: "slide",
                    duration: 400,
                    from: {
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    },
                    to: {
                        position: {
                            my: "center",
                            at: "center"
                        }
                    }
                },
                hide: {
                    type: "slide",
                    duration: 400,
                    from: {
                        opacity: 1,
                        position: {
                            my: "center",
                            at: "center"
                        }
                    },
                    to: {
                        opacity: 1,
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    }
                }
            },
            _androidAnimation: function() {
                var fullScreenConfig = {
                        show: {
                            type: "slide",
                            duration: 300,
                            from: {
                                top: "30%",
                                opacity: 0
                            },
                            to: {
                                top: 0,
                                opacity: 1
                            }
                        },
                        hide: {
                            type: "slide",
                            duration: 300,
                            from: {
                                top: 0,
                                opacity: 1
                            },
                            to: {
                                top: "30%",
                                opacity: 0
                            }
                        }
                    },
                    defaultConfig = {
                        show: {
                            type: "fade",
                            duration: 400,
                            from: 0,
                            to: 1
                        },
                        hide: {
                            type: "fade",
                            duration: 400,
                            from: 1,
                            to: 0
                        }
                    };
                return this.option("fullScreen") ? fullScreenConfig : defaultConfig
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(POPUP_CLASS);
                this._wrapper().addClass(POPUP_WRAPPER_CLASS);
                this._$popupContent = this._$content.wrapInner($("<div>").addClass(POPUP_CONTENT_CLASS)).children().eq(0)
            },
            _render: function() {
                var isFullscreen = this.option("fullScreen");
                this._toggleFullScreenClass(isFullscreen);
                this.callBase()
            },
            _toggleFullScreenClass: function(value) {
                this._$content.toggleClass(POPUP_FULL_SCREEN_CLASS, value).toggleClass(POPUP_NORMAL_CLASS, !value)
            },
            _initTemplates: function() {
                this.callBase();
                this._defaultTemplates.title = new EmptyTemplate(this);
                this._defaultTemplates.bottom = new EmptyTemplate(this)
            },
            _renderContentImpl: function() {
                this.callBase();
                this._renderTitle();
                this._renderBottom()
            },
            _renderTitle: function() {
                var items = this._getToolbarItems("top"),
                    titleText = this.option("title"),
                    showTitle = this.option("showTitle");
                if (showTitle && !!titleText) {
                    items.unshift({
                        location: devices.current().ios ? "center" : "before",
                        text: titleText
                    })
                }
                if (showTitle || items.length > 0) {
                    this._$title && this._$title.remove();
                    var $title = $("<div>").addClass(POPUP_TITLE_CLASS).insertBefore(this.$content());
                    this._$title = this._renderTemplateByType("titleTemplate", items, $title).addClass(POPUP_TITLE_CLASS);
                    this._renderDrag();
                    this._executeTitleRenderAction(this._$title)
                } else {
                    if (this._$title) {
                        this._$title.detach()
                    }
                }
            },
            _renderTemplateByType: function(optionName, data, $container, additionalToolbarOptions) {
                var template = this._getTemplateByOption(optionName),
                    toolbarTemplate = template instanceof EmptyTemplate;
                if (toolbarTemplate) {
                    var toolbarOptions = extend(additionalToolbarOptions, {
                        items: data,
                        rtlEnabled: this.option("rtlEnabled"),
                        useDefaultButtons: this.option("useDefaultToolbarButtons"),
                        useFlatButtons: this.option("useFlatToolbarButtons")
                    });
                    this._getTemplate("dx-polymorph-widget").render({
                        container: $container,
                        model: {
                            widget: "dxToolbarBase",
                            options: toolbarOptions
                        }
                    });
                    var $toolbar = $container.children("div");
                    $container.replaceWith($toolbar);
                    return $toolbar
                } else {
                    var $result = $(template.render({
                        container: getPublicElement($container)
                    }));
                    if ($result.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                        $container.replaceWith($result);
                        $container = $result
                    }
                    return $container
                }
            },
            _executeTitleRenderAction: function($titleElement) {
                this._getTitleRenderAction()({
                    titleElement: getPublicElement($titleElement)
                })
            },
            _getTitleRenderAction: function() {
                return this._titleRenderAction || this._createTitleRenderAction()
            },
            _createTitleRenderAction: function() {
                return this._titleRenderAction = this._createActionByOption("onTitleRendered", {
                    element: this.element(),
                    excludeValidators: ["designMode", "disabled", "readOnly"]
                })
            },
            _getCloseButton: function() {
                return {
                    toolbar: "top",
                    location: "after",
                    template: this._getCloseButtonRenderer()
                }
            },
            _getCloseButtonRenderer: function() {
                return function(_, __, container) {
                    var $button = $("<div>").addClass(POPUP_TITLE_CLOSEBUTTON_CLASS);
                    this._createComponent($button, Button, {
                        icon: "close",
                        onClick: this._createToolbarItemAction(void 0),
                        integrationOptions: {}
                    });
                    $(container).append($button)
                }.bind(this)
            },
            _getToolbarItems: function(toolbar) {
                var toolbarItems = this.option("toolbarItems");
                var toolbarsItems = [];
                this._toolbarItemClasses = [];
                var currentPlatform = devices.current().platform,
                    index = 0;
                each(toolbarItems, function(_, data) {
                    var isShortcut = isDefined(data.shortcut),
                        item = isShortcut ? getButtonPlace(data.shortcut) : data;
                    if (isShortcut && "ios" === currentPlatform && index < 2) {
                        item.toolbar = "top";
                        index++
                    }
                    item.toolbar = data.toolbar || item.toolbar || "top";
                    if (item && item.toolbar === toolbar) {
                        if (isShortcut) {
                            extend(item, {
                                location: data.location
                            }, this._getToolbarItemByAlias(data))
                        }
                        var isLTROrder = "win" === currentPlatform || "generic" === currentPlatform;
                        if ("done" === data.shortcut && isLTROrder || "cancel" === data.shortcut && !isLTROrder) {
                            toolbarsItems.unshift(item)
                        } else {
                            toolbarsItems.push(item)
                        }
                    }
                }.bind(this));
                if ("top" === toolbar && this.option("showCloseButton") && this.option("showTitle")) {
                    toolbarsItems.push(this._getCloseButton())
                }
                return toolbarsItems
            },
            _getToolbarItemByAlias: function(data) {
                var that = this,
                    itemType = data.shortcut;
                if (inArray(itemType, ALLOWED_TOOLBAR_ITEM_ALIASES) < 0) {
                    return false
                }
                var itemConfig = extend({
                    text: messageLocalization.format(camelize(itemType, true)),
                    onClick: this._createToolbarItemAction(data.onClick),
                    integrationOptions: {},
                    type: that.option("useDefaultToolbarButtons") ? BUTTON_DEFAULT_TYPE : BUTTON_NORMAL_TYPE
                }, data.options || {});
                var itemClass = POPUP_CLASS + "-" + itemType;
                if (that.option("useFlatToolbarButtons")) {
                    itemClass += " " + BUTTON_FLAT_CLASS
                }
                this._toolbarItemClasses.push(itemClass);
                return {
                    template: function(_, __, container) {
                        var $toolbarItem = $("<div>").addClass(itemClass).appendTo(container);
                        that._createComponent($toolbarItem, Button, itemConfig)
                    }
                }
            },
            _createToolbarItemAction: function(clickAction) {
                return this._createAction(clickAction, {
                    afterExecute: function(e) {
                        e.component.hide()
                    }
                })
            },
            _renderBottom: function() {
                var items = this._getToolbarItems("bottom");
                if (items.length) {
                    this._$bottom && this._$bottom.remove();
                    var $bottom = $("<div>").addClass(POPUP_BOTTOM_CLASS).insertAfter(this.$content());
                    this._$bottom = this._renderTemplateByType("bottomTemplate", items, $bottom, {
                        compactMode: true
                    }).addClass(POPUP_BOTTOM_CLASS);
                    this._toggleClasses()
                } else {
                    this._$bottom && this._$bottom.detach()
                }
            },
            _toggleClasses: function() {
                var aliases = ALLOWED_TOOLBAR_ITEM_ALIASES;
                each(aliases, function(_, alias) {
                    var className = POPUP_CLASS + "-" + alias;
                    if (inArray(className, this._toolbarItemClasses) >= 0) {
                        this._wrapper().addClass(className + "-visible");
                        this._$bottom.addClass(className)
                    } else {
                        this._wrapper().removeClass(className + "-visible");
                        this._$bottom.removeClass(className)
                    }
                }.bind(this))
            },
            _getDragTarget: function() {
                return this._$title
            },
            _renderGeometryImpl: function() {
                this._resetContentHeight();
                this.callBase.apply(this, arguments);
                this._setContentHeight()
            },
            _resetContentHeight: function() {
                this._$popupContent.css({
                    height: "auto"
                })
            },
            _renderDrag: function() {
                this.callBase();
                this._$content.toggleClass(POPUP_DRAGGABLE_CLASS, this.option("dragEnabled"))
            },
            _renderResize: function() {
                this.callBase();
                this._resizable.option("onResize", function() {
                    this._setContentHeight();
                    this._actions.onResize(arguments)
                }.bind(this))
            },
            _setContentHeight: function() {
                (this.option("forceApplyBindings") || noop)();
                if (this._disallowUpdateContentHeight()) {
                    return
                }
                var contentPaddings = this._$content.outerHeight() - this._$content.height(),
                    contentHeight = this._$content.get(0).getBoundingClientRect().height - contentPaddings;
                if (this._$title && this._$title.is(":visible")) {
                    contentHeight -= this._$title.get(0).getBoundingClientRect().height || 0
                }
                if (this._$bottom && this._$bottom.is(":visible")) {
                    contentHeight -= this._$bottom.get(0).getBoundingClientRect().height || 0
                }
                this._$popupContent.css("height", contentHeight < 0 ? 0 : contentHeight)
            },
            _disallowUpdateContentHeight: function() {
                var isHeightAuto = "auto" === this._$content.get(0).style.height,
                    maxHeightSpecified = "none" !== this._$content.css("maxHeight"),
                    minHeightSpecified = parseInt(this._$content.css("minHeight")) > 0;
                return isHeightAuto && !(maxHeightSpecified || minHeightSpecified)
            },
            _renderDimensions: function() {
                if (this.option("fullScreen")) {
                    this._$content.css({
                        width: "100%",
                        height: "100%"
                    })
                } else {
                    this.callBase.apply(this, arguments)
                }
                if (windowUtils.hasWindow()) {
                    this._renderFullscreenWidthClass()
                }
            },
            _renderFullscreenWidthClass: function() {
                this.overlayContent().toggleClass(POPUP_FULL_SCREEN_WIDTH_CLASS, this.overlayContent().outerWidth() === $(window).width())
            },
            _renderShadingDimensions: function() {
                if (this.option("fullScreen")) {
                    this._wrapper().css({
                        width: "100%",
                        height: "100%"
                    })
                } else {
                    this.callBase.apply(this, arguments)
                }
            },
            refreshPosition: function() {
                this._renderPosition()
            },
            _renderPosition: function() {
                if (this.option("fullScreen")) {
                    translator.move(this._$content, {
                        top: 0,
                        left: 0
                    })
                } else {
                    (this.option("forceApplyBindings") || noop)();
                    return this.callBase.apply(this, arguments)
                }
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "showTitle":
                    case "title":
                    case "titleTemplate":
                        this._renderTitle();
                        this._renderGeometry();
                        break;
                    case "bottomTemplate":
                        this._renderBottom();
                        this._renderGeometry();
                        break;
                    case "onTitleRendered":
                        this._createTitleRenderAction(args.value);
                        break;
                    case "toolbarItems":
                    case "useDefaultToolbarButtons":
                    case "useFlatToolbarButtons":
                        var isPartialUpdate = args.fullName.search(".options") !== -1;
                        this._renderTitle();
                        this._renderBottom();
                        if (!isPartialUpdate) {
                            this._renderGeometry()
                        }
                        break;
                    case "dragEnabled":
                        this._renderDrag();
                        break;
                    case "fullScreen":
                        this._toggleFullScreenClass(args.value);
                        this._renderGeometry();
                        domUtils.triggerResizeEvent(this._$content);
                        break;
                    case "showCloseButton":
                        this._renderTitle();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            bottomToolbar: function() {
                return this._$bottom
            },
            $content: function() {
                return this._$popupContent
            },
            content: function() {
                return getPublicElement(this._$popupContent)
            },
            overlayContent: function() {
                return this._$content
            }
        });
        registerComponent("dxPopup", Popup);
        module.exports = Popup
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/version.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.compare = function(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10),
                    yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date_serialization.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 29),
            getLDMLFormatter = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 228).getFormatter,
            defaultDateNames = __webpack_require__( /*! ../../localization/default_date_names */ 230),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            isString = typeUtils.isString,
            isDate = typeUtils.isDate,
            isNumber = typeUtils.isNumeric;
        var NUMBER_SERIALIZATION_FORMAT = "number",
            DATE_SERIALIZATION_FORMAT = "yyyy/MM/dd",
            DATETIME_SERIALIZATION_FORMAT = "yyyy/MM/dd HH:mm:ss";
        var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([\+\-])(\d{2})(:)?(\d{2})?)?$/;
        var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
        var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
        var MILLISECOND_LENGHT = 3;
        var dateParser = function(text, skipISO8601Parsing) {
            var result;
            var parsedValue;
            if (isString(text) && !skipISO8601Parsing) {
                result = parseISO8601String(text)
            }
            if (!result) {
                parsedValue = !isDate(text) && Date.parse(text);
                result = isNumber(parsedValue) ? new Date(parsedValue) : text
            }
            return result
        };
        var parseISO8601String = function(text) {
            var parts = text.match(ISO8601_PATTERN);
            var timePart = function(part) {
                return +part || 0
            };
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return new Date(0, 0, 0, timePart(parts[1]), timePart(parts[2]), timePart(parts[4]))
                }
                return
            }
            var year = parts[1],
                month = --parts[3],
                day = parts[5],
                timeZoneHour = 0,
                timeZoneMinute = 0;
            timeZoneHour = timePart(parts[14]);
            timeZoneMinute = timePart(parts[16]);
            if ("-" === parts[13]) {
                timeZoneHour = -timeZoneHour;
                timeZoneMinute = -timeZoneMinute
            }
            var hour = timePart(parts[6]) - timeZoneHour,
                minute = timePart(parts[8]) - timeZoneMinute,
                second = timePart(parts[10]),
                parseMilliseconds = function(part) {
                    part = part || "";
                    return timePart(part) * Math.pow(10, MILLISECOND_LENGHT - part.length)
                },
                millisecond = parseMilliseconds(parts[11]);
            if (!!parts[12]) {
                return new Date(Date.UTC(year, month, day, hour, minute, second, millisecond))
            }
            return new Date(year, month, day, hour, minute, second, millisecond)
        };
        var getIso8601Format = function(text, useUtc) {
            var parts = text.match(ISO8601_PATTERN),
                result = "";
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return parts[3] ? "HH:mm:ss" : "HH:mm"
                }
                return
            }
            for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                if (parts[i]) {
                    result += ISO8601_PATTERN_PARTS[i] || parts[i]
                }
            }
            if ("Z" === parts[12]) {
                result += "'Z'"
            }
            if (parts[14]) {
                if (parts[15]) {
                    result += "xxx"
                } else {
                    if (parts[16]) {
                        result += "xx"
                    } else {
                        result += "x"
                    }
                }
            }
            return result
        };
        var deserializeDate = function(value) {
            if ("number" === typeof value) {
                return new Date(value)
            }
            return dateParser(value, !config().forceIsoDateParsing)
        };
        var serializeDate = function(value, serializationFormat) {
            if (!serializationFormat) {
                return value
            }
            if (!isDate(value)) {
                return null
            }
            if (serializationFormat === NUMBER_SERIALIZATION_FORMAT) {
                return value && value.valueOf ? value.valueOf() : null
            }
            return getLDMLFormatter(serializationFormat, defaultDateNames)(value)
        };
        var getDateSerializationFormat = function(value) {
            if ("number" === typeof value) {
                return NUMBER_SERIALIZATION_FORMAT
            } else {
                if (isString(value)) {
                    var format;
                    if (config().forceIsoDateParsing) {
                        format = getIso8601Format(value)
                    }
                    if (format) {
                        return format
                    } else {
                        if (value.indexOf(":") >= 0) {
                            return DATETIME_SERIALIZATION_FORMAT
                        } else {
                            return DATE_SERIALIZATION_FORMAT
                        }
                    }
                } else {
                    if (value) {
                        return null
                    }
                }
            }
        };
        module.exports = {
            dateParser: dateParser,
            deserializeDate: deserializeDate,
            serializeDate: serializeDate,
            getDateSerializationFormat: getDateSerializationFormat
        }
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/bindable_template.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 77),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            removeEvent = __webpack_require__( /*! ../../core/remove_event */ 134),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            isPrimitive = __webpack_require__( /*! ../../core/utils/type */ 1).isPrimitive;
        var watchChanges = function() {
            var start = function(rawData, watchMethod, fields, fieldsMap, callback) {
                var globalDispose, fieldsDispose;
                globalDispose = globalWatch(rawData, watchMethod, function(dataWithRawFields) {
                    fieldsDispose && fieldsDispose();
                    if (isPrimitive(dataWithRawFields)) {
                        callback(dataWithRawFields);
                        return
                    }
                    fieldsDispose = fieldsWatch(dataWithRawFields, watchMethod, fields, fieldsMap, function(data) {
                        callback(data)
                    })
                });
                return function() {
                    fieldsDispose && fieldsDispose();
                    globalDispose && globalDispose()
                }
            };
            var globalWatch = function(data, watchMethod, callback) {
                return watchMethod(function() {
                    return data
                }, callback)
            };
            var fieldsWatch = function(data, watchMethod, fields, fieldsMap, callback) {
                var resolvedData = {},
                    missedFields = fields.slice();
                var watchHandlers = iteratorUtils.map(fields, function(name) {
                    var fieldGetter = fieldsMap[name];
                    return watchMethod(fieldGetter ? function() {
                        return fieldGetter(data)
                    } : function() {
                        return data[name]
                    }, function(value) {
                        resolvedData[name] = value;
                        if (missedFields.length) {
                            var index = missedFields.indexOf(name);
                            if (index >= 0) {
                                missedFields.splice(index, 1)
                            }
                        }
                        if (!missedFields.length) {
                            callback(resolvedData)
                        }
                    })
                });
                return function() {
                    iteratorUtils.each(watchHandlers, function(_, dispose) {
                        dispose()
                    })
                }
            };
            return start
        }();
        module.exports = TemplateBase.inherit({
            ctor: function(render, fields, watchMethod, fieldsMap) {
                this._render = render;
                this._fields = fields;
                this._fieldsMap = fieldsMap || {};
                this._watchMethod = watchMethod
            },
            _renderCore: function(options) {
                var $container = $(options.container);
                var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, function(data) {
                    $container.empty();
                    this._render($container, data, options.model)
                }.bind(this));
                eventsEngine.on($container, removeEvent, dispose);
                return $container.contents()
            }
        })
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            callbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 111);
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }
            each(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = [].slice.call(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            callbacks.fire(name, strategy)
        };
        registerEvent.callbacks = callbacks;
        module.exports = registerEvent
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/framework/errors.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../core/utils/error */ 104),
            errors = __webpack_require__( /*! ../core/errors */ 18);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E3001: "Routing rule is not found for the '{0}' URI.",
            E3002: "The passed object cannot be formatted into a URI string by the application's router. An appropriate route should be registered.",
            E3003: "Unable to navigate. Application is being initialized.",
            E3004: "Cannot execute the command: {0}.",
            E3005: "The '{0}' command {1} is not registered in the application's command mapping. Go to http://dxpr.es/1bTjfj1 for more details.",
            E3006: "Unknown navigation target: '{0}'. Use the 'current', 'back' or 'blank' values.",
            E3007: "Error while restoring the application state. The state has been cleared. Refresh the page.",
            E3008: "Unable to go back.",
            E3009: "Unable to go forward.",
            E3010: "The command's 'id' option should be specified.\r\nProcessed markup: {0}\n",
            E3011: "Layout controller cannot be resolved. There are no appropriate layout controllers for the current context. Check browser console for details.",
            E3012: "Layout controller cannot be resolved. Two or more layout controllers suit the current context. Check browser console for details.",
            E3013: "The '{0}' template with the '{1}' name is not found. Make sure the case is correct in the specified view name and the template fits the current context.",
            E3014: "All the children of the dxView element should be either of the dxCommand or dxContent type.\r\nProcessed markup: {0}",
            E3015: "The 'exec' method should be called before the 'finalize' method.",
            E3016: "Unknown transition type '{0}'.",
            E3018: "Unable to parse options.\nMessage: {0};\nOptions value: {1}.",
            E3019: "View templates should be updated according to the 13.1 changes. Go to http://dxpr.es/15ikrJA for more details.",
            E3020: "Concurrent templates are found:\r\n{0}Target device:\r\n{1}.",
            E3021: "Remote template cannot be loaded.\r\nUrl:{0}\r\nError:{1}.",
            E3022: "Cannot initialize the HtmlApplication component.",
            E3023: "Navigation item is not found",
            E3024: "Layout controller is not initialized",
            W3001: "A view with the '{0}' key doesn't exist.",
            W3002: "A view with the '{0}' key has already been released.",
            W3003: "Layout resolving context:\n{0}\nAvailable layout controller registrations:\n{1}\n",
            W3004: "Layout resolving context:\n{0}\nConcurent layout controller registrations for the context:\n{1}\n",
            W3005: 'Direct hash-based navigation is detected in a mobile application. Use data-bind="dxAction: url" instead of href="#url" to avoid navigation issues.\nFound markup:\n{0}\n'
        })
    },
    /*!***********************************************************************!*\
      !*** ./artifacts/transpiled/framework/html/view_engine_components.js ***!
      \***********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 64),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 13),
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 8),
            MarkupComponent = __webpack_require__( /*! ./markup_component */ 182).MarkupComponent;
        __webpack_require__( /*! ../../integration/knockout */ 113);
        var View = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null,
                    title: null
                })
            },
            ctor: function() {
                this._id = domUtils.uniqueId();
                this.callBase.apply(this, arguments)
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-view");
                this.element().attr("dx-data-template-id", this._id)
            },
            getId: function() {
                return this._id
            }
        });
        var Layout = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null
                })
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-layout")
            }
        });
        var ViewPlaceholder = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    viewName: null
                })
            },
            _render: function() {
                this.callBase();
                this.element().addClass("dx-view-placeholder")
            }
        });
        var setupTransitionElement = function($element, transitionType, transitionName, contentCssPosition) {
            if ("absolute" === contentCssPosition) {
                $element.addClass("dx-transition-absolute")
            } else {
                $element.addClass("dx-transition-static")
            }
            $element.addClass("dx-transition").addClass("dx-transition-" + transitionName).addClass("dx-transition-" + transitionType).attr("data-dx-transition-type", transitionType).attr("data-dx-transition-name", transitionName)
        };
        var setupTransitionInnerElement = function($element) {
            $element.addClass("dx-transition-inner-wrapper")
        };
        var Transition = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null,
                    type: void 0,
                    animation: "slide"
                })
            },
            _render: function() {
                this.callBase();
                var element = this.element();
                setupTransitionElement(element, this.option("type") || this.option("animation"), this.option("name"), "absolute");
                element.wrapInner("<div>");
                setupTransitionInnerElement(element.children());
                if (this.option("type")) {
                    errors.log("W0003", "dxTransition", "type", "15.1", "Use the 'animation' property instead")
                }
            },
            _clean: function() {
                this.callBase();
                this.element().empty()
            }
        });
        var ContentPlaceholder = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    name: null,
                    transition: void 0,
                    animation: "none",
                    contentCssPosition: "absolute"
                })
            },
            _render: function() {
                this.callBase();
                var $element = this.element();
                $element.addClass("dx-content-placeholder").addClass("dx-content-placeholder-" + this.option("name"));
                $element.attr("data-dx-content-placeholder-name", this.option("name"));
                setupTransitionElement($element, this.option("transition") || this.option("animation"), this.option("name"), this.option("contentCssPosition"));
                if (this.option("transition")) {
                    errors.log("W0003", "dxContentPlaceholder", "transition", "15.1", "Use the 'animation' property instead")
                }
            }
        });
        var Content = MarkupComponent.inherit({
            _setDefaultOptions: function() {
                this.callBase();
                this.option({
                    targetPlaceholder: null
                })
            },
            _optionChanged: function() {
                this._refresh()
            },
            _clean: function() {
                this.callBase();
                this.element().removeClass(this._currentClass)
            },
            _render: function() {
                this.callBase();
                var element = this.element();
                element.addClass("dx-content");
                this._currentClass = "dx-content-" + this.option("targetPlaceholder");
                element.attr("data-dx-target-placeholder-id", this.option("targetPlaceholder"));
                element.addClass(this._currentClass);
                setupTransitionInnerElement(element)
            }
        });
        registerComponent("dxView", View);
        registerComponent("dxLayout", Layout);
        registerComponent("dxViewPlaceholder", ViewPlaceholder);
        registerComponent("dxContentPlaceholder", ContentPlaceholder);
        registerComponent("dxTransition", Transition);
        registerComponent("dxContent", Content);
        exports.dxView = View;
        exports.dxLayout = Layout;
        exports.dxViewPlaceholder = ViewPlaceholder;
        exports.dxContentPlaceholder = ContentPlaceholder;
        exports.dxTransition = Transition;
        exports.dxContent = Content
    },
    /*!***********************************!*\
      !*** external "window.Globalize" ***!
      \***********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.Globalize
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/utils.ink_ripple.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var INKRIPPLE_CLASS = "dx-inkripple",
            INKRIPPLE_WAVE_CLASS = "dx-inkripple-wave",
            INKRIPPLE_SHOWING_CLASS = "dx-inkripple-showing",
            INKRIPPLE_HIDING_CLASS = "dx-inkripple-hiding";
        var DEFAULT_WAVE_SIZE_COEFFICIENT = 2,
            MAX_WAVE_SIZE = 4e3,
            ANIMATION_DURATION = 300,
            HOLD_ANIMATION_DURATION = 1e3,
            DEFAULT_WAVE_INDEX = 0;
        var render = function(args) {
            args = args || {};
            if (void 0 === args.useHoldAnimation) {
                args.useHoldAnimation = true
            }
            var config = {
                waveSizeCoefficient: args.waveSizeCoefficient || DEFAULT_WAVE_SIZE_COEFFICIENT,
                isCentered: args.isCentered || false,
                wavesNumber: args.wavesNumber || 1,
                durations: getDurations(args.useHoldAnimation)
            };
            return {
                showWave: showWave.bind(this, config),
                hideWave: hideWave.bind(this, config)
            }
        };
        var getInkRipple = function(element) {
            var result = element.children("." + INKRIPPLE_CLASS);
            if (0 === result.length) {
                result = $("<div>").addClass(INKRIPPLE_CLASS).appendTo(element)
            }
            return result
        };
        var getWaves = function(element, wavesNumber) {
            var inkRipple = getInkRipple(element),
                result = inkRipple.children("." + INKRIPPLE_WAVE_CLASS).toArray();
            for (var i = result.length; i < wavesNumber; i++) {
                var $currentWave = $("<div>").appendTo(inkRipple).addClass(INKRIPPLE_WAVE_CLASS);
                result.push($currentWave[0])
            }
            return $(result)
        };
        var getWaveStyleConfig = function(args, config) {
            var left, top, element = config.element,
                elementWidth = element.outerWidth(),
                elementHeight = element.outerHeight(),
                elementDiagonal = parseInt(Math.sqrt(elementWidth * elementWidth + elementHeight * elementHeight)),
                waveSize = Math.min(MAX_WAVE_SIZE, parseInt(elementDiagonal * args.waveSizeCoefficient));
            if (args.isCentered) {
                left = (elementWidth - waveSize) / 2;
                top = (elementHeight - waveSize) / 2
            } else {
                var event = config.event,
                    position = config.element.offset(),
                    x = event.pageX - position.left,
                    y = event.pageY - position.top;
                left = x - waveSize / 2;
                top = y - waveSize / 2
            }
            return {
                left: left,
                top: top,
                height: waveSize,
                width: waveSize
            }
        };
        var showWave = function(args, config) {
            var $wave = getWaves(config.element, args.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX);
            args.hidingTimeout && clearTimeout(args.hidingTimeout);
            hideSelectedWave($wave);
            $wave.css(getWaveStyleConfig(args, config));
            args.showingTimeout = setTimeout(showingWaveHandler.bind(this, args, $wave), 0)
        };
        var showingWaveHandler = function(args, $wave) {
            var durationCss = args.durations.showingScale + "ms";
            $wave.addClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss)
        };
        var getDurations = function(useHoldAnimation) {
            return {
                showingScale: useHoldAnimation ? HOLD_ANIMATION_DURATION : ANIMATION_DURATION,
                hidingScale: ANIMATION_DURATION,
                hidingOpacity: ANIMATION_DURATION
            }
        };
        var hideSelectedWave = function($wave) {
            $wave.removeClass(INKRIPPLE_HIDING_CLASS).css("transitionDuration", "")
        };
        var hideWave = function(args, config) {
            args.showingTimeout && clearTimeout(args.showingTimeout);
            var $wave = getWaves(config.element, config.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX),
                durations = args.durations,
                durationCss = durations.hidingScale + "ms, " + durations.hidingOpacity + "ms";
            $wave.addClass(INKRIPPLE_HIDING_CLASS).removeClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss);
            var animationDuration = Math.max(durations.hidingScale, durations.hidingOpacity);
            args.hidingTimeout = setTimeout(hideSelectedWave.bind(this, $wave), animationDuration)
        };
        module.exports = {
            render: render
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/call_once.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var callOnce = function(handler) {
            var result;
            var _wrappedHandler = function() {
                result = handler.apply(this, arguments);
                _wrappedHandler = function() {
                    return result
                };
                return result
            };
            return function() {
                return _wrappedHandler.apply(this, arguments)
            }
        };
        module.exports = callOnce
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/ui/overlay.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            ready = __webpack_require__( /*! ../core/utils/ready_callbacks */ 52).add,
            window = windowUtils.getWindow(),
            navigator = windowUtils.getNavigator(),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            fx = __webpack_require__( /*! ../animation/fx */ 32),
            translator = __webpack_require__( /*! ../animation/translator */ 24),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 60).compare,
            viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 72),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 13).getPublicElement,
            viewPortChanged = viewPortUtils.changeCallback,
            hideTopOverlayCallback = __webpack_require__( /*! ../mobile/hide_top_overlay */ 135).hideCallback,
            positionUtils = __webpack_require__( /*! ../animation/position */ 74),
            fitIntoRange = __webpack_require__( /*! ../core/utils/math */ 34).fitIntoRange,
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 13),
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            browser = __webpack_require__( /*! ../core/utils/browser */ 30),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            Widget = __webpack_require__( /*! ./widget/ui.widget */ 27),
            KeyboardProcessor = __webpack_require__( /*! ./widget/ui.keyboard_processor */ 165),
            selectors = __webpack_require__( /*! ./widget/selectors */ 56),
            dragEvents = __webpack_require__( /*! ../events/drag */ 75),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            pointerEvents = __webpack_require__( /*! ../events/pointer */ 25),
            Resizable = __webpack_require__( /*! ./resizable */ 203),
            EmptyTemplate = __webpack_require__( /*! ./widget/empty_template */ 114),
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 7).Deferred;
        var OVERLAY_CLASS = "dx-overlay",
            OVERLAY_WRAPPER_CLASS = "dx-overlay-wrapper",
            OVERLAY_CONTENT_CLASS = "dx-overlay-content",
            OVERLAY_SHADER_CLASS = "dx-overlay-shader",
            OVERLAY_MODAL_CLASS = "dx-overlay-modal",
            INVISIBLE_STATE_CLASS = "dx-state-invisible",
            ANONYMOUS_TEMPLATE_NAME = "content",
            RTL_DIRECTION_CLASS = "dx-rtl",
            ACTIONS = ["onShowing", "onShown", "onHiding", "onHidden", "onPositioning", "onPositioned", "onResizeStart", "onResize", "onResizeEnd"],
            FIRST_Z_INDEX = 1500,
            OVERLAY_STACK = [],
            DISABLED_STATE_CLASS = "dx-state-disabled",
            TAB_KEY = 9,
            POSITION_ALIASES = {
                top: {
                    my: "top center",
                    at: "top center"
                },
                bottom: {
                    my: "bottom center",
                    at: "bottom center"
                },
                right: {
                    my: "right center",
                    at: "right center"
                },
                left: {
                    my: "left center",
                    at: "left center"
                },
                center: {
                    my: "center",
                    at: "center"
                },
                "right bottom": {
                    my: "right bottom",
                    at: "right bottom"
                },
                "right top": {
                    my: "right top",
                    at: "right top"
                },
                "left bottom": {
                    my: "left bottom",
                    at: "left bottom"
                },
                "left top": {
                    my: "left top",
                    at: "left top"
                }
            };
        var realDevice = devices.real(),
            realVersion = realDevice.version,
            firefoxDesktop = browser.mozilla && "desktop" === realDevice.deviceType,
            iOS = "ios" === realDevice.platform,
            iOS7_0andBelow = iOS && compareVersions(realVersion, [7, 1]) < 0,
            android4_0nativeBrowser = "android" === realDevice.platform && 0 === compareVersions(realVersion, [4, 0], 2) && navigator.userAgent.indexOf("Chrome") === -1;
        var forceRepaint = function($element) {
            if (iOS7_0andBelow || firefoxDesktop) {
                $element.width()
            }
            if (android4_0nativeBrowser) {
                var $parents = $element.parents(),
                    inScrollView = $parents.is(".dx-scrollable-native");
                if (!inScrollView) {
                    $parents.css("backfaceVisibility", "hidden");
                    $parents.css("backfaceVisibility");
                    $parents.css("backfaceVisibility", "visible")
                }
            }
        };
        var getElement = function(value) {
            return value && $(value.target || value)
        };
        ready(function() {
            eventsEngine.subscribeGlobal(domAdapter.getDocument(), pointerEvents.down, function(e) {
                for (var i = OVERLAY_STACK.length - 1; i >= 0; i--) {
                    if (!OVERLAY_STACK[i]._proxiedDocumentDownHandler(e)) {
                        return
                    }
                }
            })
        });
        var Overlay = Widget.inherit({
            _supportedKeys: function() {
                var offsetSize = 5,
                    move = function(top, left, e) {
                        if (!this.option("dragEnabled")) {
                            return
                        }
                        e.preventDefault();
                        e.stopPropagation();
                        var allowedOffsets = this._allowedOffsets();
                        var offset = {
                            top: fitIntoRange(top, -allowedOffsets.top, allowedOffsets.bottom),
                            left: fitIntoRange(left, -allowedOffsets.left, allowedOffsets.right)
                        };
                        this._changePosition(offset)
                    };
                return extend(this.callBase(), {
                    escape: function() {
                        this.hide()
                    },
                    upArrow: move.bind(this, -offsetSize, 0),
                    downArrow: move.bind(this, offsetSize, 0),
                    leftArrow: move.bind(this, 0, -offsetSize),
                    rightArrow: move.bind(this, 0, offsetSize)
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    activeStateEnabled: false,
                    visible: false,
                    deferRendering: true,
                    shading: true,
                    shadingColor: "",
                    position: {
                        my: "center",
                        at: "center"
                    },
                    width: function() {
                        return .8 * $(window).width()
                    },
                    minWidth: null,
                    maxWidth: null,
                    height: function() {
                        return .8 * $(window).height()
                    },
                    minHeight: null,
                    maxHeight: null,
                    animation: {
                        show: {
                            type: "pop",
                            duration: 300,
                            from: {
                                scale: .55
                            }
                        },
                        hide: {
                            type: "pop",
                            duration: 300,
                            to: {
                                opacity: 0,
                                scale: .55
                            },
                            from: {
                                opacity: 1,
                                scale: 1
                            }
                        }
                    },
                    closeOnOutsideClick: false,
                    closeOnBackButton: true,
                    onShowing: null,
                    onShown: null,
                    onHiding: null,
                    onHidden: null,
                    contentTemplate: "content",
                    dragEnabled: false,
                    resizeEnabled: false,
                    onResizeStart: null,
                    onResize: null,
                    onResizeEnd: null,
                    target: void 0,
                    container: void 0,
                    hideTopOverlayHandler: void 0,
                    closeOnTargetScroll: false,
                    onPositioned: null,
                    boundaryOffset: {
                        h: 0,
                        v: 0
                    },
                    propagateOutsideClick: false,
                    _checkParentVisibility: true
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        var realDevice = devices.real(),
                            realPlatform = realDevice.platform,
                            realVersion = realDevice.version;
                        return "android" === realPlatform && compareVersions(realVersion, [4, 2]) < 0
                    },
                    options: {
                        animation: {
                            show: {
                                type: "fade",
                                duration: 400
                            },
                            hide: {
                                type: "fade",
                                duration: 400,
                                to: {
                                    opacity: 0
                                },
                                from: {
                                    opacity: 1
                                }
                            }
                        }
                    }
                }, {
                    device: function() {
                        return !windowUtils.hasWindow()
                    },
                    options: {
                        width: null,
                        height: null,
                        animation: null,
                        _checkParentVisibility: false
                    }
                }])
            },
            _setOptionsByReference: function() {
                this.callBase();
                extend(this._optionsByReference, {
                    animation: true
                })
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _wrapper: function() {
                return this._$wrapper
            },
            _container: function() {
                return this._$content
            },
            _eventBindingTarget: function() {
                return this._$content
            },
            _init: function() {
                this.callBase();
                this._initActions();
                this._initCloseOnOutsideClickHandler();
                this._initTabTerminatorHandler();
                this._$wrapper = $("<div>").addClass(OVERLAY_WRAPPER_CLASS);
                this._$content = $("<div>").addClass(OVERLAY_CONTENT_CLASS);
                var $element = this.$element();
                this._$wrapper.addClass($element.attr("class"));
                $element.addClass(OVERLAY_CLASS);
                this._$wrapper.attr("data-bind", "dxControlsDescendantBindings: true");
                eventsEngine.on(this._$wrapper, "MSPointerDown", noop);
                eventsEngine.on(this._$wrapper, "focusin", function(e) {
                    e.stopPropagation()
                });
                this._toggleViewPortSubscription(true)
            },
            _initOptions: function(options) {
                this._initTarget(options.target);
                this._initContainer(options.container);
                this._initHideTopOverlayHandler(options.hideTopOverlayHandler);
                this.callBase(options)
            },
            _initTarget: function(target) {
                if (!typeUtils.isDefined(target)) {
                    return
                }
                var options = this.option();
                each(["position.of", "animation.show.from.position.of", "animation.show.to.position.of", "animation.hide.from.position.of", "animation.hide.to.position.of"], function(_, path) {
                    var pathParts = path.split(".");
                    var option = options;
                    while (option) {
                        if (1 === pathParts.length) {
                            if (typeUtils.isPlainObject(option)) {
                                option[pathParts.shift()] = target
                            }
                            break
                        } else {
                            option = option[pathParts.shift()]
                        }
                    }
                })
            },
            _initContainer: function(container) {
                container = void 0 === container ? viewPortUtils.value() : container;
                var $element = this.$element(),
                    $container = $element.closest(container);
                if (!$container.length) {
                    $container = $(container).first()
                }
                this._$container = $container.length ? $container : $element.parent()
            },
            _initHideTopOverlayHandler: function(handler) {
                this._hideTopOverlayHandler = void 0 !== handler ? handler : this._defaultHideTopOverlayHandler.bind(this)
            },
            _defaultHideTopOverlayHandler: function() {
                this.hide()
            },
            _initActions: function() {
                this._actions = {};
                each(ACTIONS, function(_, action) {
                    this._actions[action] = this._createActionByOption(action, {
                        excludeValidators: ["disabled", "readOnly"]
                    }) || noop
                }.bind(this))
            },
            _initCloseOnOutsideClickHandler: function() {
                var that = this;
                this._proxiedDocumentDownHandler = function() {
                    return that._documentDownHandler.apply(that, arguments)
                }
            },
            _documentDownHandler: function(e) {
                if (this._showAnimationProcessing) {
                    this._stopAnimation()
                }
                var closeOnOutsideClick = this.option("closeOnOutsideClick");
                if (typeUtils.isFunction(closeOnOutsideClick)) {
                    closeOnOutsideClick = closeOnOutsideClick(e)
                }
                var $container = this._$content,
                    isAttachedTarget = $(window.document).is(e.target) || domUtils.contains(window.document, e.target),
                    outsideClick = isAttachedTarget && !($container.is(e.target) || domUtils.contains($container.get(0), e.target));
                if (!outsideClick) {
                    return false
                }
                if (closeOnOutsideClick) {
                    if (this.option("shading")) {
                        e.preventDefault()
                    }
                    this.hide()
                }
                return this.option("propagateOutsideClick")
            },
            _initTemplates: function() {
                this.callBase();
                this._defaultTemplates.content = new EmptyTemplate(this)
            },
            _isTopOverlay: function() {
                var overlayStack = this._overlayStack();
                for (var i = overlayStack.length - 1; i >= 0; i--) {
                    var $tabbableElements = overlayStack[i]._findTabbableElements();
                    if ($tabbableElements.length) {
                        return overlayStack[i] === this
                    }
                }
                return false
            },
            _overlayStack: function() {
                return OVERLAY_STACK
            },
            _zIndexInitValue: function() {
                return FIRST_Z_INDEX
            },
            _toggleViewPortSubscription: function(toggle) {
                viewPortChanged.remove(this._viewPortChangeHandle);
                if (toggle) {
                    this._viewPortChangeHandle = this._viewPortChangeHandler.bind(this);
                    viewPortChanged.add(this._viewPortChangeHandle)
                }
            },
            _viewPortChangeHandler: function() {
                this._initContainer(this.option("container"));
                this._refresh()
            },
            _renderVisibilityAnimate: function(visible) {
                this._stopAnimation();
                return visible ? this._show() : this._hide()
            },
            _normalizePosition: function() {
                var position = this.option("position");
                this._position = "function" === typeof position ? position() : position
            },
            _getAnimationConfig: function() {
                var animation = this.option("animation");
                if (typeUtils.isFunction(animation)) {
                    animation = animation.call(this)
                }
                return animation
            },
            _show: function() {
                var that = this,
                    deferred = new Deferred;
                this._parentHidden = this._isParentHidden();
                deferred.done(function() {
                    delete that._parentHidden
                });
                if (this._parentHidden) {
                    return deferred.resolve()
                }
                if (this._currentVisible) {
                    return (new Deferred).resolve().promise()
                }
                this._currentVisible = true;
                this._normalizePosition();
                var animation = that._getAnimationConfig() || {},
                    showAnimation = this._normalizeAnimation(animation.show, "to"),
                    startShowAnimation = showAnimation && showAnimation.start || noop,
                    completeShowAnimation = showAnimation && showAnimation.complete || noop;
                if (this._isHidingActionCanceled) {
                    delete this._isHidingActionCanceled;
                    deferred.resolve()
                } else {
                    var show = function() {
                        this._renderVisibility(true);
                        this._animate(showAnimation, function() {
                            if (that.option("focusStateEnabled")) {
                                eventsEngine.trigger(that._focusTarget(), "focus")
                            }
                            completeShowAnimation.apply(this, arguments);
                            that._showAnimationProcessing = false;
                            that._actions.onShown();
                            deferred.resolve()
                        }, function() {
                            startShowAnimation.apply(this, arguments);
                            that._showAnimationProcessing = true
                        })
                    }.bind(this);
                    if (this.option("templatesRenderAsynchronously")) {
                        this._asyncShowTimeout = setTimeout(show)
                    } else {
                        show()
                    }
                }
                return deferred.promise()
            },
            _normalizeAnimation: function(animation, prop) {
                if (animation) {
                    animation = extend({
                        type: "slide"
                    }, animation);
                    if (animation[prop] && "object" === _typeof(animation[prop])) {
                        extend(animation[prop], {
                            position: this._position
                        })
                    }
                }
                return animation
            },
            _hide: function() {
                if (!this._currentVisible) {
                    return (new Deferred).resolve().promise()
                }
                this._currentVisible = false;
                var that = this,
                    deferred = new Deferred,
                    animation = that._getAnimationConfig() || {},
                    hideAnimation = this._normalizeAnimation(animation.hide, "from"),
                    startHideAnimation = hideAnimation && hideAnimation.start || noop,
                    completeHideAnimation = hideAnimation && hideAnimation.complete || noop,
                    hidingArgs = {
                        cancel: false
                    };
                this._actions.onHiding(hidingArgs);
                if (hidingArgs.cancel) {
                    this._isHidingActionCanceled = true;
                    this.option("visible", true);
                    deferred.resolve()
                } else {
                    this._forceFocusLost();
                    this._toggleShading(false);
                    this._toggleSubscriptions(false);
                    this._animate(hideAnimation, function() {
                        that._$content.css("pointerEvents", "");
                        that._renderVisibility(false);
                        completeHideAnimation.apply(this, arguments);
                        that._actions.onHidden();
                        deferred.resolve()
                    }, function() {
                        that._$content.css("pointerEvents", "none");
                        startHideAnimation.apply(this, arguments)
                    })
                }
                return deferred.promise()
            },
            _forceFocusLost: function() {
                var activeElement = domAdapter.getActiveElement();
                activeElement && this._$content.find(activeElement).length && activeElement.blur()
            },
            _animate: function(animation, completeCallback, startCallback) {
                if (animation) {
                    startCallback = startCallback || animation.start || noop;
                    fx.animate(this._$content, extend({}, animation, {
                        start: startCallback,
                        complete: completeCallback
                    }))
                } else {
                    completeCallback()
                }
            },
            _stopAnimation: function() {
                fx.stop(this._$content, true)
            },
            _renderVisibility: function(visible) {
                if (visible && this._isParentHidden()) {
                    return
                }
                this._currentVisible = visible;
                this._stopAnimation();
                clearTimeout(this._asyncShowTimeout);
                if (!visible) {
                    domUtils.triggerHidingEvent(this._$content)
                }
                this._toggleVisibility(visible);
                this._$content.toggleClass(INVISIBLE_STATE_CLASS, !visible);
                this._updateZIndexStackPosition(visible);
                if (visible) {
                    this._renderContent();
                    this._actions.onShowing();
                    this._moveToContainer();
                    this._renderGeometry();
                    domUtils.triggerShownEvent(this._$content);
                    domUtils.triggerResizeEvent(this._$content)
                } else {
                    this._moveFromContainer()
                }
                this._toggleShading(visible);
                this._toggleSubscriptions(visible)
            },
            _updateZIndexStackPosition: function(pushToStack) {
                var overlayStack = this._overlayStack(),
                    index = inArray(this, overlayStack);
                if (pushToStack) {
                    if (index === -1) {
                        var length = overlayStack.length;
                        this._zIndex = (length ? overlayStack[length - 1]._zIndex : this._zIndexInitValue()) + 1;
                        overlayStack.push(this)
                    }
                    this._$wrapper.css("zIndex", this._zIndex);
                    this._$content.css("zIndex", this._zIndex)
                } else {
                    if (index !== -1) {
                        overlayStack.splice(index, 1)
                    }
                }
            },
            _toggleShading: function(visible) {
                this._$wrapper.toggleClass(OVERLAY_MODAL_CLASS, this.option("shading") && !this.option("container"));
                this._$wrapper.toggleClass(OVERLAY_SHADER_CLASS, visible && this.option("shading"));
                this._$wrapper.css("backgroundColor", this.option("shading") ? this.option("shadingColor") : "");
                this._toggleTabTerminator(visible && this.option("shading"))
            },
            _initTabTerminatorHandler: function() {
                var that = this;
                this._proxiedTabTerminatorHandler = function() {
                    that._tabKeyHandler.apply(that, arguments)
                }
            },
            _toggleTabTerminator: function(enabled) {
                var eventName = eventUtils.addNamespace("keydown", this.NAME);
                if (enabled) {
                    eventsEngine.on(domAdapter.getDocument(), eventName, this._proxiedTabTerminatorHandler)
                } else {
                    eventsEngine.off(domAdapter.getDocument(), eventName, this._proxiedTabTerminatorHandler)
                }
            },
            _findTabbableElements: function() {
                return this._$wrapper.find("*").filter(selectors.tabbable)
            },
            _tabKeyHandler: function(e) {
                if (e.keyCode !== TAB_KEY || !this._isTopOverlay()) {
                    return
                }
                var tabbableElements = this._findTabbableElements(),
                    $firstTabbable = tabbableElements.first(),
                    $lastTabbable = tabbableElements.last(),
                    isTabOnLast = !e.shiftKey && e.target === $lastTabbable.get(0),
                    isShiftTabOnFirst = e.shiftKey && e.target === $firstTabbable.get(0),
                    isEmptyTabList = 0 === tabbableElements.length,
                    isOutsideTarget = inArray(e.target, tabbableElements) === -1;
                if (isTabOnLast || isShiftTabOnFirst || isEmptyTabList || isOutsideTarget) {
                    e.preventDefault();
                    var $focusElement = e.shiftKey ? $lastTabbable : $firstTabbable;
                    eventsEngine.trigger($focusElement, "focusin");
                    eventsEngine.trigger($focusElement, "focus")
                }
            },
            _toggleSubscriptions: function(enabled) {
                if (windowUtils.hasWindow()) {
                    this._toggleHideTopOverlayCallback(enabled);
                    this._toggleParentsScrollSubscription(enabled)
                }
            },
            _toggleHideTopOverlayCallback: function(subscribe) {
                if (!this._hideTopOverlayHandler) {
                    return
                }
                if (subscribe && this.option("closeOnBackButton")) {
                    hideTopOverlayCallback.add(this._hideTopOverlayHandler)
                } else {
                    hideTopOverlayCallback.remove(this._hideTopOverlayHandler)
                }
            },
            _toggleParentsScrollSubscription: function(subscribe) {
                if (!this._position) {
                    return
                }
                var target = this._position.of || $(),
                    closeOnScroll = this.option("closeOnTargetScroll"),
                    $parents = getElement(target).parents(),
                    scrollEvent = eventUtils.addNamespace("scroll", this.NAME);
                if ("generic" === devices.real().platform) {
                    $parents = $parents.add(window)
                }
                this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function(e) {
                    this._targetParentsScrollHandler(e)
                }.bind(this);
                eventsEngine.off($().add(this._$prevTargetParents), scrollEvent, this._proxiedTargetParentsScrollHandler);
                if (subscribe && closeOnScroll) {
                    eventsEngine.on($parents, scrollEvent, this._proxiedTargetParentsScrollHandler);
                    this._$prevTargetParents = $parents
                }
            },
            _targetParentsScrollHandler: function(e) {
                var closeHandled = false,
                    closeOnScroll = this.option("closeOnTargetScroll");
                if (typeUtils.isFunction(closeOnScroll)) {
                    closeHandled = closeOnScroll(e)
                }
                if (!closeHandled && !this._showAnimationProcessing) {
                    this.hide()
                }
            },
            _render: function() {
                this.callBase();
                this._$content.appendTo(this.$element());
                this._renderVisibilityAnimate(this.option("visible"))
            },
            _renderContent: function() {
                var shouldDeferRendering = !this._currentVisible && this.option("deferRendering");
                var isParentHidden = this.option("visible") && this._isParentHidden();
                if (isParentHidden) {
                    this._isHidden = true;
                    return
                }
                if (this._contentAlreadyRendered || shouldDeferRendering) {
                    return
                }
                this._contentAlreadyRendered = true;
                this.callBase()
            },
            _isParentHidden: function() {
                if (!this.option("_checkParentVisibility")) {
                    return false
                }
                if (void 0 !== this._parentHidden) {
                    return this._parentHidden
                }
                var $parent = this.$element().parent();
                if ($parent.is(":visible")) {
                    return false
                }
                var isHidden = false;
                $parent.add($parent.parents()).each(function() {
                    var $element = $(this);
                    if ("none" === $element.css("display")) {
                        isHidden = true;
                        return false
                    }
                });
                return isHidden || !domAdapter.getBody().contains($parent.get(0))
            },
            _renderContentImpl: function() {
                var $element = this.$element();
                this._$content.appendTo($element);
                var contentTemplateOption = this.option("contentTemplate"),
                    contentTemplate = this._getTemplate(contentTemplateOption),
                    transclude = this._getAnonymousTemplateName() === contentTemplateOption;
                contentTemplate && contentTemplate.render({
                    container: getPublicElement(this.$content()),
                    noModel: true,
                    transclude: transclude
                });
                this._renderDrag();
                this._renderResize();
                this._renderScrollTerminator()
            },
            _renderDrag: function() {
                var $dragTarget = this._getDragTarget();
                if (!$dragTarget) {
                    return
                }
                var startEventName = eventUtils.addNamespace(dragEvents.start, this.NAME),
                    updateEventName = eventUtils.addNamespace(dragEvents.move, this.NAME);
                eventsEngine.off($dragTarget, startEventName);
                eventsEngine.off($dragTarget, updateEventName);
                if (!this.option("dragEnabled")) {
                    return
                }
                eventsEngine.on($dragTarget, startEventName, this._dragStartHandler.bind(this));
                eventsEngine.on($dragTarget, updateEventName, this._dragUpdateHandler.bind(this))
            },
            _renderResize: function() {
                this._resizable = this._createComponent(this._$content, Resizable, {
                    handles: this.option("resizeEnabled") ? "all" : "none",
                    onResizeEnd: this._resizeEndHandler.bind(this),
                    onResize: this._actions.onResize.bind(this),
                    onResizeStart: this._actions.onResizeStart.bind(this),
                    minHeight: 100,
                    minWidth: 100,
                    area: this._getDragResizeContainer()
                })
            },
            _resizeEndHandler: function() {
                this._positionChangeHandled = true;
                var width = this._resizable.option("width"),
                    height = this._resizable.option("height");
                width && this.option("width", width);
                height && this.option("height", height);
                this._actions.onResizeEnd()
            },
            _renderScrollTerminator: function() {
                var $scrollTerminator = this._wrapper();
                var terminatorEventName = eventUtils.addNamespace(dragEvents.move, this.NAME);
                eventsEngine.off($scrollTerminator, terminatorEventName);
                eventsEngine.on($scrollTerminator, terminatorEventName, {
                    validate: function() {
                        return true
                    },
                    getDirection: function() {
                        return "both"
                    },
                    _toggleGestureCover: noop,
                    _clearSelection: noop,
                    isNative: true
                }, function(e) {
                    var originalEvent = e.originalEvent.originalEvent;
                    e._cancelPreventDefault = true;
                    if (originalEvent && "mousemove" !== originalEvent.type) {
                        e.preventDefault()
                    }
                })
            },
            _getDragTarget: function() {
                return this.$content()
            },
            _dragStartHandler: function(e) {
                e.targetElements = [];
                this._prevOffset = {
                    x: 0,
                    y: 0
                };
                var allowedOffsets = this._allowedOffsets();
                e.maxTopOffset = allowedOffsets.top;
                e.maxBottomOffset = allowedOffsets.bottom;
                e.maxLeftOffset = allowedOffsets.left;
                e.maxRightOffset = allowedOffsets.right
            },
            _getDragResizeContainer: function() {
                var isContainerDefined = viewPortUtils.originalViewPort().get(0) || this.option("container"),
                    $container = !isContainerDefined ? $(window) : this._$container;
                return $container
            },
            _deltaSize: function() {
                var $content = this._$content,
                    $container = this._getDragResizeContainer();
                var contentWidth = $content.outerWidth(),
                    contentHeight = $content.outerHeight(),
                    containerWidth = $container.outerWidth(),
                    containerHeight = $container.outerHeight();
                if (this._isWindow($container)) {
                    var document = domAdapter.getDocument(),
                        fullPageHeight = Math.max($(document).outerHeight(), containerHeight),
                        fullPageWidth = Math.max($(document).outerWidth(), containerWidth);
                    containerHeight = fullPageHeight;
                    containerWidth = fullPageWidth
                }
                return {
                    width: containerWidth - contentWidth,
                    height: containerHeight - contentHeight
                }
            },
            _dragUpdateHandler: function(e) {
                var offset = e.offset,
                    prevOffset = this._prevOffset,
                    targetOffset = {
                        top: offset.y - prevOffset.y,
                        left: offset.x - prevOffset.x
                    };
                this._changePosition(targetOffset);
                this._prevOffset = offset
            },
            _changePosition: function(offset) {
                var position = translator.locate(this._$content);
                translator.move(this._$content, {
                    left: position.left + offset.left,
                    top: position.top + offset.top
                });
                this._positionChangeHandled = true
            },
            _allowedOffsets: function() {
                var position = translator.locate(this._$content),
                    deltaSize = this._deltaSize(),
                    isAllowedDrag = deltaSize.height >= 0 && deltaSize.width >= 0,
                    shaderOffset = this.option("shading") && !this.option("container") && !this._isWindow(this._getContainer()) ? translator.locate(this._$wrapper) : {
                        top: 0,
                        left: 0
                    },
                    boundaryOffset = this.option("boundaryOffset");
                return {
                    top: isAllowedDrag ? position.top + shaderOffset.top + boundaryOffset.v : 0,
                    bottom: isAllowedDrag ? -position.top - shaderOffset.top + deltaSize.height - boundaryOffset.v : 0,
                    left: isAllowedDrag ? position.left + shaderOffset.left + boundaryOffset.h : 0,
                    right: isAllowedDrag ? -position.left - shaderOffset.left + deltaSize.width - boundaryOffset.h : 0
                }
            },
            _fireContentReadyAction: function() {
                if (this.option("visible")) {
                    this._moveToContainer()
                }
                this.callBase.apply(this, arguments)
            },
            _moveFromContainer: function() {
                this._$content.appendTo(this.$element());
                this._detachWrapperToContainer()
            },
            _detachWrapperToContainer: function() {
                this._$wrapper.detach()
            },
            _moveToContainer: function() {
                this._attachWrapperToContainer();
                this._$content.appendTo(this._$wrapper)
            },
            _attachWrapperToContainer: function() {
                var $element = this.$element();
                if (this._$container && this._$container[0] !== $element.parent()[0]) {
                    this._$wrapper.appendTo(this._$container)
                } else {
                    this._$wrapper.appendTo($element)
                }
            },
            _renderGeometry: function() {
                if (this.option("visible") && windowUtils.hasWindow()) {
                    this._renderGeometryImpl()
                }
            },
            _renderGeometryImpl: function() {
                this._stopAnimation();
                this._normalizePosition();
                this._renderShading();
                this._renderDimensions();
                var resultPosition = this._renderPosition();
                this._actions.onPositioned({
                    position: resultPosition
                })
            },
            _renderShading: function() {
                var $wrapper = this._$wrapper,
                    $container = this._getContainer();
                $wrapper.css("position", this._isWindow($container) && !iOS ? "fixed" : "absolute");
                this._renderShadingDimensions();
                this._renderShadingPosition()
            },
            _renderShadingPosition: function() {
                if (this.option("shading")) {
                    var $container = this._getContainer();
                    positionUtils.setup(this._$wrapper, {
                        my: "top left",
                        at: "top left",
                        of: $container
                    })
                }
            },
            _renderShadingDimensions: function() {
                var wrapperWidth, wrapperHeight;
                if (this.option("shading")) {
                    var $container = this._getContainer();
                    wrapperWidth = this._isWindow($container) ? "100%" : $container.outerWidth(), wrapperHeight = this._isWindow($container) ? "100%" : $container.outerHeight()
                } else {
                    wrapperWidth = "";
                    wrapperHeight = ""
                }
                this._$wrapper.css({
                    width: wrapperWidth,
                    height: wrapperHeight
                })
            },
            _isWindow: function($element) {
                return !!$element && typeUtils.isWindow($element.get(0))
            },
            _getContainer: function() {
                var position = this._position,
                    container = this.option("container"),
                    positionOf = position ? position.of || window : null;
                return getElement(container || positionOf)
            },
            _renderDimensions: function() {
                var content = this._$content.get(0);
                this._$content.css({
                    minWidth: this._getOptionValue("minWidth", content),
                    maxWidth: this._getOptionValue("maxWidth", content),
                    minHeight: this._getOptionValue("minHeight", content),
                    maxHeight: this._getOptionValue("maxHeight", content),
                    width: this._getOptionValue("width", content),
                    height: this._getOptionValue("height", content)
                })
            },
            _renderPosition: function() {
                if (this._positionChangeHandled) {
                    var allowedOffsets = this._allowedOffsets();
                    this._changePosition({
                        top: fitIntoRange(0, -allowedOffsets.top, allowedOffsets.bottom),
                        left: fitIntoRange(0, -allowedOffsets.left, allowedOffsets.right)
                    })
                } else {
                    this._renderOverlayBoundaryOffset();
                    translator.resetPosition(this._$content);
                    var position = this._transformStringPosition(this._position, POSITION_ALIASES),
                        resultPosition = positionUtils.setup(this._$content, position);
                    forceRepaint(this._$content);
                    this._actions.onPositioning();
                    return resultPosition
                }
            },
            _transformStringPosition: function(position, positionAliases) {
                if (typeUtils.isString(position)) {
                    position = extend({}, positionAliases[position])
                }
                return position
            },
            _renderOverlayBoundaryOffset: function() {
                var boundaryOffset = this.option("boundaryOffset");
                this._$content.css("margin", boundaryOffset.v + "px " + boundaryOffset.h + "px")
            },
            _focusTarget: function() {
                return this._$content
            },
            _attachKeyboardEvents: function() {
                this._keyboardProcessor = new KeyboardProcessor({
                    element: this._$content,
                    handler: this._keyboardHandler,
                    context: this
                })
            },
            _keyboardHandler: function(options) {
                var e = options.originalEvent,
                    $target = $(e.target);
                if ($target.is(this._$content)) {
                    this.callBase.apply(this, arguments)
                }
            },
            _isVisible: function() {
                return this.option("visible")
            },
            _visibilityChanged: function(visible) {
                if (visible) {
                    if (this.option("visible")) {
                        this._renderVisibilityAnimate(visible)
                    }
                } else {
                    this._renderVisibilityAnimate(visible)
                }
            },
            _dimensionChanged: function() {
                this._renderGeometry()
            },
            _clean: function() {
                if (!this._contentAlreadyRendered) {
                    this.$content().empty()
                }
                this._renderVisibility(false);
                this._cleanFocusState()
            },
            _dispose: function() {
                fx.stop(this._$content, false);
                clearTimeout(this._deferShowTimer);
                this._toggleViewPortSubscription(false);
                this._toggleSubscriptions(false);
                this._updateZIndexStackPosition(false);
                this._toggleTabTerminator(false);
                this._actions = null;
                this.callBase();
                this._$wrapper.remove();
                this._$content.remove()
            },
            _toggleDisabledState: function(value) {
                this.callBase.apply(this, arguments);
                this._$content.toggleClass(DISABLED_STATE_CLASS, Boolean(value))
            },
            _toggleRTLDirection: function(rtl) {
                this._$content.toggleClass(RTL_DIRECTION_CLASS, rtl)
            },
            _optionChanged: function(args) {
                var value = args.value;
                if (inArray(args.name, ACTIONS) > -1) {
                    this._initActions();
                    return
                }
                switch (args.name) {
                    case "dragEnabled":
                        this._renderDrag();
                        this._renderGeometry();
                        break;
                    case "resizeEnabled":
                        this._renderResize();
                        this._renderGeometry();
                        break;
                    case "shading":
                    case "shadingColor":
                        this._toggleShading(this.option("visible"));
                        break;
                    case "width":
                    case "height":
                    case "minWidth":
                    case "maxWidth":
                    case "minHeight":
                    case "maxHeight":
                    case "position":
                    case "boundaryOffset":
                        this._renderGeometry();
                        break;
                    case "visible":
                        this._renderVisibilityAnimate(value).done(function() {
                            if (!this._animateDeferred) {
                                return
                            }
                            this._animateDeferred.resolveWith(this)
                        }.bind(this));
                        break;
                    case "target":
                        this._initTarget(value);
                        this._invalidate();
                        break;
                    case "container":
                        this._initContainer(value);
                        this._invalidate();
                        break;
                    case "deferRendering":
                    case "contentTemplate":
                        this._contentAlreadyRendered = false;
                        this._invalidate();
                        break;
                    case "closeOnBackButton":
                        this._toggleHideTopOverlayCallback(this.option("visible"));
                        break;
                    case "closeOnTargetScroll":
                        this._toggleParentsScrollSubscription(this.option("visible"));
                        break;
                    case "closeOnOutsideClick":
                    case "animation":
                    case "propagateOutsideClick":
                        break;
                    case "rtlEnabled":
                        this._contentAlreadyRendered = false;
                        this.option("visible", false);
                        this.callBase(args);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            toggle: function(showing) {
                showing = void 0 === showing ? !this.option("visible") : showing;
                if (showing === this.option("visible")) {
                    return (new Deferred).resolve().promise()
                }
                var animateDeferred = new Deferred;
                this._animateDeferred = animateDeferred;
                this.option("visible", showing);
                return animateDeferred.promise().done(function() {
                    delete this._animateDeferred
                }.bind(this))
            },
            $content: function() {
                return this._$content
            },
            show: function() {
                return this.toggle(true)
            },
            hide: function() {
                return this.toggle(false)
            },
            content: function() {
                return getPublicElement(this._$content)
            },
            repaint: function() {
                this._renderGeometry()
            }
        });
        Overlay.baseZIndex = function(zIndex) {
            FIRST_Z_INDEX = zIndex
        };
        registerComponent("dxOverlay", Overlay);
        module.exports = Overlay
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/variable_wrapper.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var logger = __webpack_require__( /*! ./console */ 73).logger,
            dependencyInjector = __webpack_require__( /*! ./dependency_injector */ 55);
        module.exports = dependencyInjector({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        })
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ajax.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Deferred = __webpack_require__( /*! ./deferred */ 7).Deferred;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12);
        var httpRequest = __webpack_require__( /*! ../../core/http_request */ 314);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 6);
        var window = windowUtils.getWindow();
        var extendFromObject = __webpack_require__( /*! ./extend */ 0).extendFromObject;
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined;
        var Promise = __webpack_require__( /*! ../polyfills/promise */ 99);
        var injector = __webpack_require__( /*! ./dependency_injector */ 55);
        var SUCCESS = "success",
            ERROR = "error",
            TIMEOUT = "timeout",
            NO_CONTENT = "nocontent",
            PARSER_ERROR = "parsererror";
        var isStatusSuccess = function(status) {
            return 200 <= status && status < 300
        };
        var hasContent = function(status) {
            return 204 !== status
        };
        var paramsConvert = function(params) {
            var result = [];
            for (var name in params) {
                var value = params[name];
                if (void 0 === value) {
                    continue
                }
                if (null === value) {
                    value = ""
                }
                result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
            }
            return result.join("&")
        };
        var createScript = function(options) {
            var script = domAdapter.createElement("script");
            for (var name in options) {
                script[name] = options[name]
            }
            return script
        };
        var removeScript = function(scriptNode) {
            scriptNode.parentNode.removeChild(scriptNode)
        };
        var appendToHead = function(element) {
            return domAdapter.getHead().appendChild(element)
        };
        var evalScript = function(code) {
            var script = createScript({
                text: code
            });
            appendToHead(script);
            removeScript(script)
        };
        var evalCrossDomainScript = function(url) {
            var script = createScript({
                src: url
            });
            return new Promise(function(resolve, reject) {
                var events = {
                    load: resolve,
                    error: reject
                };
                var loadHandler = function(e) {
                    events[e.type]();
                    removeScript(script)
                };
                for (var event in events) {
                    domAdapter.listen(script, event, loadHandler)
                }
                appendToHead(script)
            })
        };
        var getAcceptHeader = function(options) {
            var dataType = options.dataType || "*",
                scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",
                accepts = {
                    "*": "*/*",
                    text: "text/plain",
                    html: "text/html",
                    xml: "application/xml, text/xml",
                    json: "application/json, text/javascript",
                    jsonp: scriptAccept,
                    script: scriptAccept
                };
            extendFromObject(accepts, options.accepts, true);
            return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
        };
        var getContentTypeHeader = function(options) {
            var defaultContentType;
            if (options.data && !options.upload && "GET" !== getMethod(options)) {
                defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
            }
            return options.contentType || defaultContentType
        };
        var getDataFromResponse = function(xhr) {
            return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
        };
        var postProcess = function(deferred, xhr, dataType) {
            var data = getDataFromResponse(xhr);
            switch (dataType) {
                case "jsonp":
                    evalScript(data);
                    break;
                case "script":
                    evalScript(data);
                    deferred.resolve(data, SUCCESS, xhr);
                    break;
                case "json":
                    try {
                        deferred.resolve(JSON.parse(data), SUCCESS, xhr)
                    } catch (e) {
                        deferred.reject(xhr, PARSER_ERROR, e)
                    }
                    break;
                default:
                    deferred.resolve(data, SUCCESS, xhr)
            }
        };
        var isCrossDomain = function(url) {
            if (!windowUtils.hasWindow()) {
                return true
            }
            var crossDomain = false,
                originAnchor = domAdapter.createElement("a"),
                urlAnchor = domAdapter.createElement("a");
            originAnchor.href = window.location.href;
            try {
                urlAnchor.href = url;
                urlAnchor.href = urlAnchor.href;
                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
            } catch (e) {
                crossDomain = true
            }
            return crossDomain
        };
        var setHttpTimeout = function(timeout, xhr) {
            return timeout && setTimeout(function() {
                xhr.customStatus = TIMEOUT;
                xhr.abort()
            }, timeout)
        };
        var getJsonpOptions = function(options) {
            if ("jsonp" === options.dataType) {
                var random = Math.random().toString().replace(/\D/g, ""),
                    callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random,
                    callbackParameter = options.jsonp || "callback";
                options.data = options.data || {};
                options.data[callbackParameter] = callbackName;
                return callbackName
            }
        };
        var getRequestOptions = function(options, headers) {
            var params = options.data,
                paramsAlreadyString = "string" === typeof params,
                url = options.url || window.location.href;
            if (!paramsAlreadyString && !options.cache) {
                params = params || {};
                params._ = Date.now()
            }
            if (params && !options.upload) {
                if (!paramsAlreadyString) {
                    params = paramsConvert(params)
                }
                if ("GET" === getMethod(options)) {
                    if ("" !== params) {
                        url += (url.indexOf("?") > -1 ? "&" : "?") + params
                    }
                    params = null
                } else {
                    if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                        params = params.replace(/%20/g, "+")
                    }
                }
            }
            return {
                url: url,
                parameters: params
            }
        };
        var getMethod = function(options) {
            return (options.method || "GET").toUpperCase()
        };
        var getRequestHeaders = function(options) {
            var headers = options.headers || {};
            headers["Content-Type"] = headers["Content-Type"] || getContentTypeHeader(options);
            headers.Accept = headers.Accept || getAcceptHeader(options);
            if (!options.crossDomain && !headers["X-Requested-With"]) {
                headers["X-Requested-With"] = "XMLHttpRequest"
            }
            return headers
        };
        var sendRequest = function(options) {
            var timeoutId, xhr = httpRequest.getXhr(),
                d = new Deferred,
                result = d.promise(),
                async = isDefined(options.async) ? options.async : true, dataType = options.dataType, timeout = options.timeout || 0;
            options.crossDomain = isCrossDomain(options.url);
            var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
            if (void 0 === options.cache) {
                options.cache = !needScriptEvaluation
            }
            var callbackName = getJsonpOptions(options),
                headers = getRequestHeaders(options),
                requestOptions = getRequestOptions(options, headers),
                url = requestOptions.url,
                parameters = requestOptions.parameters;
            if (callbackName) {
                window[callbackName] = function(data) {
                    d.resolve(data, SUCCESS, xhr)
                }
            }
            if (options.crossDomain && needScriptEvaluation) {
                var reject = function() {
                        d.reject(xhr, ERROR)
                    },
                    resolve = function() {
                        if ("jsonp" === dataType) {
                            return
                        }
                        d.resolve(null, SUCCESS, xhr)
                    };
                evalCrossDomainScript(url).then(resolve, reject);
                return result
            }
            if (options.crossDomain && !("withCredentials" in xhr)) {
                d.reject(xhr, ERROR);
                return result
            }
            xhr.open(getMethod(options), url, async, options.username, options.password);
            if (async) {
                xhr.timeout = timeout;
                timeoutId = setHttpTimeout(timeout, xhr, d)
            }
            xhr.onreadystatechange = function(e) {
                if (4 === xhr.readyState) {
                    clearTimeout(timeoutId);
                    if (isStatusSuccess(xhr.status)) {
                        if (hasContent(xhr.status)) {
                            postProcess(d, xhr, dataType)
                        } else {
                            d.resolve(null, NO_CONTENT, xhr)
                        }
                    } else {
                        d.reject(xhr, xhr.customStatus || ERROR)
                    }
                }
            };
            if (options.upload) {
                xhr.upload.onprogress = options.upload.onprogress;
                xhr.upload.onloadstart = options.upload.onloadstart;
                xhr.upload.onabort = options.upload.onabort
            }
            if (options.xhrFields) {
                for (var field in options.xhrFields) {
                    xhr[field] = options.xhrFields[field]
                }
            }
            if ("arraybuffer" === options.responseType) {
                xhr.responseType = options.responseType
            }
            for (var name in headers) {
                if (headers.hasOwnProperty(name) && isDefined(headers[name])) {
                    xhr.setRequestHeader(name, headers[name])
                }
            }
            if (options.beforeSend) {
                options.beforeSend(xhr)
            }
            xhr.send(parameters);
            result.abort = function() {
                xhr.abort()
            };
            return result
        };
        module.exports = injector({
            sendRequest: sendRequest
        })
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/view_port.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../renderer */ 2),
            readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 52),
            ready = readyCallbacks.add,
            changeCallback = __webpack_require__( /*! ./callbacks */ 20)(),
            $originalViewPort = $();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = $(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : $("body");
                changeCallback.fire(isNewViewportFound ? value() : $(), prevViewPort)
            }
        }();
        ready(function() {
            value(".dx-viewport")
        });
        exports.value = value;
        exports.changeCallback = changeCallback;
        exports.originalViewPort = function() {
            return $originalViewPort
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/console.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isFunction = __webpack_require__( /*! ./type */ 1).isFunction;
        var noop = function() {};
        var getConsoleMethod = function(method) {
            if ("undefined" === typeof console || !isFunction(console[method])) {
                return noop
            }
            return console[method].bind(console)
        };
        var logger = {
            info: getConsoleMethod("info"),
            warn: getConsoleMethod("warn"),
            error: getConsoleMethod("error")
        };
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.logger = logger;
        exports.debug = debug
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/animation/position.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            window = windowUtils.getWindow(),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            isWindow = __webpack_require__( /*! ../core/utils/type */ 1).isWindow,
            stringUtils = __webpack_require__( /*! ../core/utils/string */ 39),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            translator = __webpack_require__( /*! ./translator */ 24),
            support = __webpack_require__( /*! ../core/utils/support */ 44);
        var horzRe = /left|right/,
            vertRe = /top|bottom/,
            collisionRe = /fit|flip|none/;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = commonUtils.splitPair(raw);
            if (pair) {
                each(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return stringUtils.pairToObject(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = commonUtils.splitPair(raw),
                h = String(pair && pair[0]).toLowerCase(),
                v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = extend({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = $("<div>").css({
                    width: 100,
                    height: 100,
                    overflow: "scroll",
                    position: "absolute",
                    top: -9999
                }).appendTo($("body")),
                result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = $(what),
                currentOffset = $what.offset(),
                result = extend(true, {}, defaultPositionResult, {
                    h: {
                        location: currentOffset.left
                    },
                    v: {
                        location: currentOffset.top
                    }
                });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my),
                at = normalizeAlign(options.at),
                of = $(options.of).length && options.of || window,
                offset = normalizeOffset(options.offset),
                collision = normalizeCollision(options.collision),
                boundary = options.boundary,
                boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else { of = $( of );
                if (isWindow( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    h.atSize = of [0].innerWidth > of [0].outerWidth ? of [0].innerWidth : of .width();
                    v.atSize = of [0].innerHeight > of [0].outerHeight ? of [0].innerHeight : of .height()
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var o = of .offset();
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = of .outerWidth();
                        v.atSize = of .outerHeight()
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = $(window),
                    windowWidth = win.width(),
                    windowHeight = win.height(),
                    left = win.scrollLeft(),
                    top = win.scrollTop(),
                    documentElement = domAdapter.getDocumentElement(),
                    hZoomLevel = support.touch ? documentElement.clientWidth / windowWidth : 1,
                    vZoomLevel = support.touch ? documentElement.clientHeight / windowHeight : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth,
                    boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = $(boundary),
                        boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            extend(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var position = function(what, options) {
            var $what = $(what);
            if (!options) {
                return $what.offset()
            }
            translator.resetPosition($what);
            var offset = $what.offset(),
                targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            translator.move($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = $(element).get(0);
            if (isWindow(element)) {
                return null
            } else {
                if (element && "pageY" in element && "pageX" in element) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return $(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        module.exports = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/drag.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ../core/element_data */ 38),
            wrapToArray = __webpack_require__( /*! ../core/utils/array */ 11).wrapToArray,
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            contains = __webpack_require__( /*! ../core/utils/dom */ 13).contains,
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 63),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            GestureEmitter = __webpack_require__( /*! ./gesture/emitter.gesture */ 151),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 89);
        var DRAG_START_EVENT = "dxdragstart",
            DRAG_EVENT = "dxdrag",
            DRAG_END_EVENT = "dxdragend",
            DRAG_ENTER_EVENT = "dxdragenter",
            DRAG_LEAVE_EVENT = "dxdragleave",
            DROP_EVENT = "dxdrop",
            DX_DRAG_EVENTS_COUNT_KEY = "dxDragEventsCount";
        var knownDropTargets = [],
            knownDropTargetSelectors = [],
            knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = inArray(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = inArray(element, knownDropTargets);
                this.updateEventsCounter(element, handleObj.type, 1);
                var selector = handleObj.selector;
                if (inArray(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            updateEventsCounter: function(element, event, value) {
                if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                    var eventsCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY) || 0;
                    dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY, Math.max(0, eventsCount + value))
                }
            },
            remove: function(element, handleObj) {
                this.updateEventsCounter(element, handleObj.type, -1)
            },
            teardown: function(element) {
                var handlersCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY);
                if (!handlersCount) {
                    var index = inArray(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1);
                    dataUtils.removeData(element, DX_DRAG_EVENTS_COUNT_KEY)
                }
            }
        };
        registerEvent(DRAG_ENTER_EVENT, dropTargetRegistration);
        registerEvent(DRAG_LEAVE_EVENT, dropTargetRegistration);
        registerEvent(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets),
                dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex];
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if (inArray(void 0, dropTargetSelectors) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.get(0).getBoundingClientRect().width,
                height: $element.get(0).getBoundingClientRect().height
            }
        };
        var DragEmitter = GestureEmitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = wrapToArray(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = iteratorUtils.map(dropTargets, function(element) {
                    return $(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = eventUtils.eventData(e),
                    dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e),
                    sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                eventUtils.fireEvent(eventData)
            },
            _findDropTarget: function(e) {
                var result, that = this;
                iteratorUtils.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = $(target);
                    iteratorUtils.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = $(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                iteratorUtils.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || contains(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, e) {
                var isDraggingElement = $target.get(0) === this._$element.get(0);
                if (isDraggingElement) {
                    return false
                }
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = eventUtils.eventData(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        registerEmitter({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        });
        exports.dropTargets = knownDropTargets;
        exports.move = DRAG_EVENT;
        exports.start = DRAG_START_EVENT;
        exports.end = DRAG_END_EVENT;
        exports.enter = DRAG_ENTER_EVENT;
        exports.leave = DRAG_LEAVE_EVENT;
        exports.drop = DROP_EVENT
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/integration/jquery/use_jquery.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var jQuery = __webpack_require__( /*! jquery */ 28);
        var config = __webpack_require__( /*! ../../core/config */ 29);
        var useJQuery = config().useJQuery;
        if (jQuery && false !== useJQuery) {
            config({
                useJQuery: true
            })
        }
        module.exports = function() {
            return jQuery && config().useJQuery
        }
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.template_base.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 20),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 13),
            Class = __webpack_require__( /*! ../../core/class */ 10),
            abstract = Class.abstract;
        var renderedCallbacks = Callbacks();
        var TemplateBase = Class.inherit({
            render: function(options) {
                options = options || {};
                var $result = this._renderCore(options);
                this._ensureResultInContainer($result, options.container);
                renderedCallbacks.fire($result, options.container);
                return $result
            },
            _ensureResultInContainer: function($result, container) {
                if (!container) {
                    return
                }
                var $container = $(container);
                var resultInContainer = domUtils.contains($container.get(0), $result.get(0));
                $container.append($result);
                if (resultInContainer) {
                    return
                }
                var resultInBody = domAdapter.getBody().contains($container.get(0));
                if (!resultInBody) {
                    return
                }
                domUtils.triggerShownEvent($result)
            },
            _renderCore: abstract
        });
        module.exports = TemplateBase;
        module.exports.renderedCallbacks = renderedCallbacks
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_store.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            Guid = __webpack_require__( /*! ../core/guid */ 54),
            objectUtils = __webpack_require__( /*! ../core/utils/object */ 51),
            keysEqual = __webpack_require__( /*! ./utils */ 41).keysEqual,
            Query = __webpack_require__( /*! ./query */ 40),
            errors = __webpack_require__( /*! ./errors */ 36).errors,
            Store = __webpack_require__( /*! ./abstract_store */ 95),
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 7).Deferred;
        var hasKey = function(target, keyOrKeys) {
            var key, keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
            while (keys.length) {
                key = keys.shift();
                if (key in target) {
                    return true
                }
            }
            return false
        };
        var trivialPromise = function() {
            var d = new Deferred;
            return d.resolve.apply(d, arguments).promise()
        };
        var rejectedPromise = function() {
            var d = new Deferred;
            return d.reject.apply(d, arguments).promise()
        };
        var ArrayStore = Store.inherit({
            ctor: function(options) {
                if (Array.isArray(options)) {
                    options = {
                        data: options
                    }
                } else {
                    options = options || {}
                }
                this.callBase(options);
                var initialArray = options.data;
                if (initialArray && !Array.isArray(initialArray)) {
                    throw errors.Error("E4006")
                }
                this._array = initialArray || []
            },
            createQuery: function() {
                return Query(this._array, {
                    errorHandler: this._errorHandler
                })
            },
            _byKeyImpl: function(key) {
                var index = this._indexByKey(key);
                if (index === -1) {
                    return rejectedPromise(errors.Error("E4009"))
                }
                return trivialPromise(this._array[index])
            },
            _insertImpl: function(values) {
                var keyValue, obj, keyExpr = this.key();
                if (typeUtils.isPlainObject(values)) {
                    obj = extend({}, values)
                } else {
                    obj = values
                }
                if (keyExpr) {
                    keyValue = this.keyOf(obj);
                    if (void 0 === keyValue || "object" === ("undefined" === typeof keyValue ? "undefined" : _typeof(keyValue)) && typeUtils.isEmptyObject(keyValue)) {
                        if (Array.isArray(keyExpr)) {
                            throw errors.Error("E4007")
                        }
                        keyValue = obj[keyExpr] = String(new Guid)
                    } else {
                        if (void 0 !== this._array[this._indexByKey(keyValue)]) {
                            return rejectedPromise(errors.Error("E4008"))
                        }
                    }
                } else {
                    keyValue = obj
                }
                this._array.push(obj);
                return trivialPromise(values, keyValue)
            },
            _updateImpl: function(key, values) {
                var index, target, keyExpr = this.key(),
                    extendComplexObject = true;
                if (keyExpr) {
                    if (hasKey(values, keyExpr) && !keysEqual(keyExpr, key, this.keyOf(values))) {
                        return rejectedPromise(errors.Error("E4017"))
                    }
                    index = this._indexByKey(key);
                    if (index < 0) {
                        return rejectedPromise(errors.Error("E4009"))
                    }
                    target = this._array[index]
                } else {
                    target = key
                }
                objectUtils.deepExtendArraySafe(target, values, extendComplexObject);
                return trivialPromise(key, values)
            },
            _removeImpl: function(key) {
                var index = this._indexByKey(key);
                if (index > -1) {
                    this._array.splice(index, 1)
                }
                return trivialPromise(key)
            },
            _indexByKey: function(key) {
                for (var i = 0, arrayLength = this._array.length; i < arrayLength; i++) {
                    if (keysEqual(this.key(), this.keyOf(this._array[i]), key)) {
                        return i
                    }
                }
                return -1
            },
            clear: function() {
                this.fireEvent("modifying");
                this._array = [];
                this.fireEvent("modified")
            }
        }, "array");
        module.exports = ArrayStore
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/action.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2),
            config = __webpack_require__( /*! ./config */ 29),
            window = __webpack_require__( /*! ./utils/window */ 6).getWindow(),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ./class */ 10),
            errors = __webpack_require__( /*! ./errors */ 18);
        var Action = Class.inherit({
            ctor: function(action, config) {
                config = config || {};
                this._action = action;
                this._context = config.context || window;
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            },
            execute: function() {
                var e = {
                    action: this._action,
                    args: Array.prototype.slice.call(arguments),
                    context: this._context,
                    component: this._component,
                    validatingTargetName: this._validatingTargetName,
                    cancel: false,
                    handled: false
                };
                var beforeExecute = this._beforeExecute,
                    afterExecute = this._afterExecute;
                var argsBag = e.args[0] || {};
                if ("jQueryEvent" in argsBag && !argsBag.event) {
                    throw "The jQueryEvent field is deprecated. Please, use the `event` field instead"
                }
                if (!("jQueryEvent" in argsBag) && argsBag.event && config().useJQuery) {
                    Object.defineProperty(argsBag, "jQueryEvent", {
                        get: function() {
                            errors.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                            return argsBag.event
                        },
                        set: function(value) {
                            errors.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                            argsBag.event = value
                        }
                    })
                }
                if (!this._validateAction(e)) {
                    return
                }
                beforeExecute && beforeExecute.call(this._context, e);
                if (e.cancel) {
                    return
                }
                var result = this._executeAction(e);
                if (argsBag.cancel) {
                    return
                }
                afterExecute && afterExecute.call(this._context, e);
                return result
            },
            _validateAction: function(e) {
                var excludeValidators = this._excludeValidators,
                    executors = Action.executors;
                for (var name in executors) {
                    if (!excludeValidators[name]) {
                        var executor = executors[name];
                        if (executor.validate) {
                            executor.validate(e)
                        }
                        if (e.cancel) {
                            return false
                        }
                    }
                }
                return true
            },
            _executeAction: function(e) {
                var result, executors = Action.executors;
                for (var name in executors) {
                    var executor = executors[name];
                    if (executor.execute) {
                        executor.execute(e)
                    }
                    if (e.handled) {
                        result = e.result;
                        break
                    }
                }
                return result
            }
        });
        Action.executors = {};
        Action.registerExecutor = function(name, executor) {
            if (typeUtils.isPlainObject(name)) {
                each(name, Action.registerExecutor);
                return
            }
            Action.executors[name] = executor
        };
        Action.unregisterExecutor = function() {
            var args = [].slice.call(arguments);
            each(args, function() {
                delete Action.executors[this]
            })
        };
        Action.registerExecutor({
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if (typeUtils.isFunction(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        });
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0],
                    element = args[e.validatingTargetName] || args.element;
                if (element && condition($(element))) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            designMode: {
                validate: function(e) {
                    if (config().designMode) {
                        e.cancel = true
                    }
                }
            },
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *")
                })
            }
        });
        module.exports = Action
    }, ,
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/data/store_helper.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var grep = __webpack_require__( /*! ../core/utils/common */ 4).grep,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            arrayQuery = __webpack_require__( /*! ./array_query */ 148),
            normalizeSortingInfo = __webpack_require__( /*! ./utils */ 41).normalizeSortingInfo;

        function multiLevelGroup(query, groupInfo) {
            query = query.groupBy(groupInfo[0].selector);
            if (groupInfo.length > 1) {
                query = query.select(function(g) {
                    return extend({}, g, {
                        items: multiLevelGroup(arrayQuery(g.items), groupInfo.slice(1)).toArray()
                    })
                })
            }
            return query
        }

        function arrangeSortingInfo(groupInfo, sortInfo) {
            var filteredGroup = [];
            each(groupInfo, function(_, group) {
                var collision = grep(sortInfo, function(sort) {
                    return group.selector === sort.selector
                });
                if (collision.length < 1) {
                    filteredGroup.push(group)
                }
            });
            return filteredGroup.concat(sortInfo)
        }

        function queryByOptions(query, options, isCountQuery) {
            options = options || {};
            var filter = options.filter,
                sort = options.sort,
                select = options.select,
                group = options.group,
                skip = options.skip,
                take = options.take;
            if (filter) {
                query = query.filter(filter)
            }
            if (group) {
                group = normalizeSortingInfo(group)
            }
            if (!isCountQuery) {
                if (sort || group) {
                    sort = normalizeSortingInfo(sort || []);
                    if (group) {
                        sort = arrangeSortingInfo(group, sort)
                    }
                    each(sort, function(index) {
                        query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                    })
                }
                if (select) {
                    query = query.select(select)
                }
            }
            if (group) {
                query = multiLevelGroup(query, group)
            }
            if (!isCountQuery) {
                if (take || skip) {
                    query = query.slice(skip || 0, take)
                }
            }
            return query
        }
        module.exports = {
            multiLevelGroup: multiLevelGroup,
            arrangeSortingInfo: arrangeSortingInfo,
            queryByOptions: queryByOptions
        }
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/style.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var camelize = __webpack_require__( /*! ./inflector */ 35).camelize,
            callOnce = __webpack_require__( /*! ./call_once */ 68),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 12);
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"],
            cssPrefixes = {
                "": "",
                Webkit: "-webkit-",
                Moz: "-moz-",
                O: "-o-",
                ms: "-ms-"
            },
            getStyles = callOnce(function() {
                return domAdapter.createElement("dx").style
            });
        var forEachPrefixes = function(prop, callBack) {
            prop = camelize(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = camelize(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result || ""
        };
        var styleProp = function(name) {
            if (name in getStyles()) {
                return name
            }
            var originalName = name;
            name = name.charAt(0).toUpperCase() + name.substr(1);
            for (var i = 1; i < jsPrefixes.length; i++) {
                var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                if (prefixedProp in getStyles()) {
                    return prefixedProp
                }
            }
            return originalName
        };
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in getStyles()) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
        var normalizeStyleProp = function(prop, value) {
            if (typeUtils.isNumeric(value) && pxExceptions.indexOf(prop) === -1) {
                value += "px"
            }
            return value
        };
        var setDimensionProperty = function(elements, propertyName, value) {
            if (elements) {
                value = typeUtils.isNumeric(value) ? value += "px" : value;
                for (var i = 0; i < elements.length; ++i) {
                    elements[i].style[propertyName] = value
                }
            }
        };
        var setWidth = function(elements, value) {
            setDimensionProperty(elements, "width", value)
        };
        var setHeight = function(elements, value) {
            setDimensionProperty(elements, "height", value)
        };
        exports.styleProp = styleProp;
        exports.stylePropPrefix = stylePropPrefix;
        exports.normalizeStyleProp = normalizeStyleProp;
        exports.setWidth = setWidth;
        exports.setHeight = setHeight
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/core.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dependencyInjector = __webpack_require__( /*! ../core/utils/dependency_injector */ 55);
        module.exports = dependencyInjector({
            locale: function() {
                var currentLocale = "en";
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }()
        })
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/format_helper.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./core/utils/type */ 1),
            dateUtils = __webpack_require__( /*! ./core/utils/date */ 22),
            numberLocalization = __webpack_require__( /*! ./localization/number */ 49),
            dateLocalization = __webpack_require__( /*! ./localization/date */ 33),
            dependencyInjector = __webpack_require__( /*! ./core/utils/dependency_injector */ 55),
            logger = __webpack_require__( /*! ./core/utils/console */ 73).logger;
        __webpack_require__( /*! ./localization/currency */ 141);
        module.exports = dependencyInjector({
            format: function(value, _format, precision) {
                var formatIsValid = typeUtils.isString(_format) && "" !== _format || typeUtils.isPlainObject(_format) || typeUtils.isFunction(_format),
                    valueIsValid = typeUtils.isNumeric(value) || typeUtils.isDate(value);
                if (!formatIsValid || !valueIsValid) {
                    return typeUtils.isDefined(value) ? value.toString() : ""
                }
                if (typeUtils.isFunction(_format)) {
                    return _format(value)
                }
                if (void 0 !== precision) {
                    logger.warn("Option 'precision' is deprecated. Use field 'precision' of a format object instead.")
                }
                if (typeUtils.isString(_format)) {
                    _format = {
                        type: _format,
                        precision: precision
                    }
                }
                if (typeUtils.isNumeric(value)) {
                    return numberLocalization.format(value, _format)
                }
                if (typeUtils.isDate(value)) {
                    return dateLocalization.format(value, _format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return dateLocalization.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                var resultFormat = [],
                    needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                if (needSpecialSecondFormatter) {
                    var secondFormatter = function(date) {
                        return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                    };
                    resultFormat.push(secondFormatter)
                } else {
                    if (dateDifferences.millisecond) {
                        resultFormat.push("millisecond")
                    }
                }
                if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat && "month" === intervalFormat) {
                        return "monthandyear"
                    } else {
                        resultFormat.unshift("shortdate");
                        return this._normalizeFormat(resultFormat)
                    }
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat) {
                        var monthDayFormatter = function(date) {
                            return dateLocalization.getMonthNames("abbreviated")[date.getMonth()] + " " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(monthDayFormatter)
                    } else {
                        resultFormat.unshift("monthandday")
                    }
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    if (intervalFormat) {
                        resultFormat.unshift("day")
                    } else {
                        var dayFormatter = function(date) {
                            return dateLocalization.format(date, "dayofweek") + ", " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(dayFormatter)
                    }
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var resultFormat, maxDiff, currentDiff, i;
                if (ticks.length > 1) {
                    maxDiff = dateUtils.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = dateUtils.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var resultFormat, dateDifferences, dateUnitInterval, dateDifferencesConverter = {
                        week: "day"
                    },
                    correctDateDifferences = function(dateDifferences, tickInterval, value) {
                        switch (tickInterval) {
                            case "year":
                            case "quarter":
                                dateDifferences.month = value;
                            case "month":
                                dateDifferences.day = value;
                            case "week":
                            case "day":
                                dateDifferences.hour = value;
                            case "hour":
                                dateDifferences.minute = value;
                            case "minute":
                                dateDifferences.second = value;
                            case "second":
                                dateDifferences.millisecond = value
                        }
                    },
                    correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                        if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                            if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                                differences.millisecond = true;
                                differences.second = false
                            }
                        } else {
                            if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                                if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                    differences.second = true;
                                    differences.minute = false
                                }
                            } else {
                                if (!maxDate.getMinutes() && maxDate.getHours()) {
                                    if (maxDate.getHours() - minDate.getHours() === 1) {
                                        differences.minute = true;
                                        differences.hour = false
                                    }
                                } else {
                                    if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                        if (maxDate.getDate() - minDate.getDate() === 1) {
                                            differences.hour = true;
                                            differences.day = false
                                        }
                                    } else {
                                        if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                            if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                                differences.day = true;
                                                differences.month = false
                                            }
                                        } else {
                                            if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                                if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                    differences.month = true;
                                                    differences.year = false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    };
                tickInterval = typeUtils.isString(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                dateDifferences = dateUtils.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = dateUtils.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = dateUtils.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        })
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/framework/view_cache.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ../core/class */ 10),
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 53);
        var ViewCache = Class.inherit({
            ctor: function() {
                this._cache = {}
            },
            setView: function(key, viewInfo) {
                this._cache[key] = viewInfo
            },
            getView: function(key) {
                return this._cache[key]
            },
            removeView: function(key) {
                var result = this._cache[key];
                if (result) {
                    delete this._cache[key];
                    this.fireEvent("viewRemoved", [{
                        viewInfo: result
                    }])
                }
                return result
            },
            clear: function() {
                var that = this;
                each(this._cache, function(key) {
                    that.removeView(key)
                })
            },
            hasView: function(key) {
                return key in this._cache
            }
        }).include(EventsMixin);
        var NullViewCache = ViewCache.inherit({
            setView: function(key, viewInfo) {
                this.callBase(key, viewInfo);
                this.removeView(key)
            }
        });

        function delegateEvent(eventName, source, target) {
            source.on(eventName, function() {
                target.fireEvent(eventName, arguments)
            })
        }
        var ConditionalViewCacheDecorator = Class.inherit({
            ctor: function(options) {
                this._filter = options.filter;
                this._viewCache = options.viewCache;
                this.viewRemoved = this._viewCache.viewRemoved;
                delegateEvent("viewRemoved", this._viewCache, this)
            },
            setView: function(key, viewInfo) {
                this._viewCache.setView(key, viewInfo);
                if (!this._filter(key, viewInfo)) {
                    this._viewCache.removeView(key)
                }
            },
            getView: function(key) {
                return this._viewCache.getView(key)
            },
            removeView: function(key) {
                return this._viewCache.removeView(key)
            },
            clear: function() {
                return this._viewCache.clear()
            },
            hasView: function(key) {
                return this._viewCache.hasView(key)
            }
        }).include(EventsMixin);
        var DEFAULT_VIEW_CACHE_CAPACITY = 5;
        var CapacityViewCacheDecorator = Class.inherit({
            ctor: function(options) {
                this._keys = [];
                this._size = options.size || DEFAULT_VIEW_CACHE_CAPACITY;
                this._viewCache = options.viewCache;
                this.viewRemoved = this._viewCache.viewRemoved;
                delegateEvent("viewRemoved", this._viewCache, this)
            },
            setView: function(key, viewInfo) {
                if (!this.hasView(key)) {
                    if (this._keys.length === this._size) {
                        this.removeView(this._keys[0])
                    }
                    this._keys.push(key)
                }
                this._viewCache.setView(key, viewInfo)
            },
            getView: function(key) {
                var index = inArray(key, this._keys);
                if (index < 0) {
                    return null
                }
                this._keys.push(key);
                this._keys.splice(index, 1);
                return this._viewCache.getView(key)
            },
            removeView: function(key) {
                var index = inArray(key, this._keys);
                if (index > -1) {
                    this._keys.splice(index, 1)
                }
                return this._viewCache.removeView(key)
            },
            clear: function() {
                this._keys = [];
                return this._viewCache.clear()
            },
            hasView: function(key) {
                return this._viewCache.hasView(key)
            }
        }).include(EventsMixin);
        var HistoryDependentViewCacheDecorator = Class.inherit({
            ctor: function(options) {
                this._viewCache = options.viewCache || new ViewCache;
                this._navigationManager = options.navigationManager;
                this._navigationManager.on("itemRemoved", this._onNavigationItemRemoved.bind(this));
                this.viewRemoved = this._viewCache.viewRemoved;
                delegateEvent("viewRemoved", this._viewCache, this)
            },
            _onNavigationItemRemoved: function(item) {
                this.removeView(item.key)
            },
            setView: function(key, viewInfo) {
                this._viewCache.setView(key, viewInfo)
            },
            getView: function(key) {
                return this._viewCache.getView(key)
            },
            removeView: function(key) {
                return this._viewCache.removeView(key)
            },
            clear: function() {
                return this._viewCache.clear()
            },
            hasView: function(key) {
                return this._viewCache.hasView(key)
            }
        }).include(EventsMixin);
        module.exports = ViewCache;
        module.exports.NullViewCache = NullViewCache;
        module.exports.ConditionalViewCacheDecorator = ConditionalViewCacheDecorator;
        module.exports.CapacityViewCacheDecorator = CapacityViewCacheDecorator;
        module.exports.HistoryDependentViewCacheDecorator = HistoryDependentViewCacheDecorator
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/ui/load_indicator.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            navigator = windowUtils.getNavigator(),
            support = __webpack_require__( /*! ../core/utils/support */ 44),
            themes = __webpack_require__( /*! ./themes */ 19),
            browser = __webpack_require__( /*! ../core/utils/browser */ 30),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            Widget = __webpack_require__( /*! ./widget/ui.widget */ 27);
        var LOADINDICATOR_CLASS = "dx-loadindicator",
            LOADINDICATOR_WRAPPER_CLASS = "dx-loadindicator-wrapper",
            LOADINDICATOR_CONTENT_CLASS = "dx-loadindicator-content",
            LOADINDICATOR_ICON_CLASS = "dx-loadindicator-icon",
            LOADINDICATOR_SEGMENT_CLASS = "dx-loadindicator-segment",
            LOADINDICATOR_SEGMENT_INNER_CLASS = "dx-loadindicator-segment-inner",
            LOADINDICATOR_IMAGE_CLASS = "dx-loadindicator-image";
        var LoadIndicator = Widget.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    indicatorSrc: "",
                    activeStateEnabled: false,
                    hoverStateEnabled: false,
                    _animatingSegmentCount: 1,
                    _animatingSegmentInner: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        var realDevice = devices.real(),
                            obsoleteAndroid = "android" === realDevice.platform && !/chrome/i.test(navigator.userAgent);
                        return browser.msie && browser.version < 10 || obsoleteAndroid
                    },
                    options: {
                        viaImage: true
                    }
                }, {
                    device: function() {
                        return themes.isWin8() || themes.isWin10()
                    },
                    options: {
                        _animatingSegmentCount: 5
                    }
                }, {
                    device: function() {
                        return themes.isIos7()
                    },
                    options: {
                        _animatingSegmentCount: 11
                    }
                }, {
                    device: function() {
                        return themes.isMaterial() || themes.isAndroid5()
                    },
                    options: {
                        _animatingSegmentCount: 2,
                        _animatingSegmentInner: true
                    }
                }, {
                    device: function() {
                        return themes.isGeneric()
                    },
                    options: {
                        _animatingSegmentCount: 7
                    }
                }])
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(LOADINDICATOR_CLASS)
            },
            _initMarkup: function() {
                this.callBase();
                this._renderWrapper();
                this._renderIndicatorContent();
                this._renderMarkup()
            },
            _renderWrapper: function() {
                this._$wrapper = $("<div>").addClass(LOADINDICATOR_WRAPPER_CLASS);
                this.$element().append(this._$wrapper)
            },
            _renderIndicatorContent: function() {
                this._$content = $("<div>").addClass(LOADINDICATOR_CONTENT_CLASS);
                this._$wrapper.append(this._$content)
            },
            _renderMarkup: function() {
                if (support.animation() && !this.option("viaImage") && !this.option("indicatorSrc")) {
                    this._renderMarkupForAnimation()
                } else {
                    this._renderMarkupForImage()
                }
            },
            _renderMarkupForAnimation: function() {
                var animatingSegmentInner = this.option("_animatingSegmentInner");
                this._$indicator = $("<div>").addClass(LOADINDICATOR_ICON_CLASS);
                this._$content.append(this._$indicator);
                for (var i = this.option("_animatingSegmentCount"); i >= 0; --i) {
                    var $segment = $("<div>").addClass(LOADINDICATOR_SEGMENT_CLASS).addClass(LOADINDICATOR_SEGMENT_CLASS + i);
                    if (animatingSegmentInner) {
                        $segment.append($("<div>").addClass(LOADINDICATOR_SEGMENT_INNER_CLASS))
                    }
                    this._$indicator.append($segment)
                }
            },
            _renderMarkupForImage: function() {
                var indicatorSrc = this.option("indicatorSrc");
                this._$wrapper.addClass(LOADINDICATOR_IMAGE_CLASS);
                if (indicatorSrc) {
                    this._$wrapper.css("backgroundImage", "url(" + indicatorSrc + ")")
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._updateContentSizeForAnimation()
            },
            _updateContentSizeForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                var width = this.option("width"),
                    height = this.option("height");
                if (width || height) {
                    width = this.$element().width();
                    height = this.$element().height();
                    var minDimension = Math.min(height, width);
                    this._$wrapper.css({
                        height: minDimension,
                        width: minDimension,
                        fontSize: minDimension
                    })
                }
            },
            _clean: function() {
                this.callBase();
                this._removeMarkupForAnimation();
                this._removeMarkupForImage()
            },
            _removeMarkupForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                this._$indicator.remove();
                delete this._$indicator
            },
            _removeMarkupForImage: function() {
                this._$wrapper.css("backgroundImage", "none")
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_animatingSegmentCount":
                    case "_animatingSegmentInner":
                    case "indicatorSrc":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        registerComponent("dxLoadIndicator", LoadIndicator);
        module.exports = LoadIndicator
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled/ui/pivot_grid/ui.pivot_grid.utils.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 71),
            dataCoreUtils = __webpack_require__( /*! ../../core/utils/data */ 23),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            isDefined = __webpack_require__( /*! ../../core/utils/type */ 1).isDefined,
            dateLocalization = __webpack_require__( /*! ../../localization/date */ 33),
            formatHelper = __webpack_require__( /*! ../../format_helper */ 84),
            DataSourceModule = __webpack_require__( /*! ../../data/data_source/data_source */ 50),
            ArrayStore = __webpack_require__( /*! ../../data/array_store */ 78),
            deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 7),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred;
        var setFieldProperty = exports.setFieldProperty = function(field, property, value, isInitialization) {
            var initProperties = field._initProperties = field._initProperties || {},
                initValue = isInitialization ? value : field[property];
            if (!initProperties.hasOwnProperty(property) || isInitialization) {
                initProperties[property] = initValue
            }
            field[property] = value
        };
        exports.sendRequest = function(options) {
            return ajax.sendRequest(options)
        };
        var foreachTreeAsyncDate = new Date;

        function createForeachTreeFunc(isAsync) {
            var foreachTreeFunc = function foreachTreeFunc(items, callback, parentAtFirst, members, index, isChildrenProcessing) {
                members = members || [];
                items = items || [];
                var item, i, deferred, childrenDeferred;
                index = index || 0;

                function createForeachTreeAsyncHandler(deferred, i, isChildrenProcessing) {
                    when(foreachTreeFunc(items, callback, parentAtFirst, members, i, isChildrenProcessing)).done(deferred.resolve)
                }
                for (i = index; i < items.length; i++) {
                    if (isAsync && i > index && i % 1e4 === 0 && new Date - foreachTreeAsyncDate >= 300) {
                        foreachTreeAsyncDate = new Date;
                        deferred = new Deferred;
                        setTimeout(createForeachTreeAsyncHandler(deferred, i, false), 0);
                        return deferred
                    }
                    item = items[i];
                    if (!isChildrenProcessing) {
                        members.unshift(item);
                        if (parentAtFirst && false === callback(members, i)) {
                            return
                        }
                        if (item.children) {
                            childrenDeferred = foreachTreeFunc(item.children, callback, parentAtFirst, members);
                            if (isAsync && childrenDeferred) {
                                deferred = new Deferred;
                                childrenDeferred.done(createForeachTreeAsyncHandler(deferred, i, true));
                                return deferred
                            }
                        }
                    }
                    isChildrenProcessing = false;
                    if (!parentAtFirst && false === callback(members, i)) {
                        return
                    }
                    members.shift();
                    if (items[i] !== item) {
                        i--
                    }
                }
            };
            return foreachTreeFunc
        }
        exports.foreachTree = createForeachTreeFunc(false);
        exports.foreachTreeAsync = createForeachTreeFunc(true);
        exports.findField = function(fields, id) {
            var i, field;
            if (fields && typeUtils.isDefined(id)) {
                for (i = 0; i < fields.length; i++) {
                    field = fields[i];
                    if (field.name === id || field.caption === id || field.dataField === id || field.index === id) {
                        return i
                    }
                }
            }
            return -1
        };
        exports.formatValue = function(value, options) {
            var formatObject = {
                value: value,
                valueText: formatHelper.format(value, options.format, options.precision) || ""
            };
            return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
        };
        exports.getCompareFunction = function(valueSelector) {
            return function(a, b) {
                var result = 0,
                    valueA = valueSelector(a),
                    valueB = valueSelector(b),
                    aIsDefined = isDefined(valueA),
                    bIsDefined = isDefined(valueB);
                if (aIsDefined && bIsDefined) {
                    if (valueA > valueB) {
                        result = 1
                    } else {
                        if (valueA < valueB) {
                            result = -1
                        }
                    }
                }
                if (aIsDefined && !bIsDefined) {
                    result = 1
                }
                if (!aIsDefined && bIsDefined) {
                    result = -1
                }
                return result
            }
        };
        exports.createPath = function(items) {
            var i, result = [];
            for (i = items.length - 1; i >= 0; i--) {
                result.push(items[i].key || items[i].value)
            }
            return result
        };
        exports.foreachDataLevel = function foreachDataLevel(data, callback, index, childrenField) {
            var item, i;
            index = index || 0;
            childrenField = childrenField || "children";
            if (data.length) {
                callback(data, index)
            }
            for (i = 0; i < data.length; i++) {
                item = data[i];
                if (item[childrenField] && item[childrenField].length) {
                    foreachDataLevel(item[childrenField], callback, index + 1, childrenField)
                }
            }
        };
        exports.mergeArraysByMaxValue = function(values1, values2) {
            var i, result = [];
            for (i = 0; i < values1.length; i++) {
                result.push(Math.max(values1[i] || 0, values2[i] || 0))
            }
            return result
        };
        exports.getExpandedLevel = function(options, axisName) {
            var dimensions = options[axisName],
                expandLevel = 0,
                expandedPaths = ("columns" === axisName ? options.columnExpandedPaths : options.rowExpandedPaths) || [];
            if (options.headerName === axisName) {
                expandLevel = options.path.length
            } else {
                iteratorUtils.each(expandedPaths, function(_, path) {
                    expandLevel = Math.max(expandLevel, path.length)
                })
            }
            while (dimensions[expandLevel + 1] && dimensions[expandLevel].expanded) {
                expandLevel++
            }
            return expandLevel
        };

        function createGroupFields(item) {
            return iteratorUtils.map(["year", "quarter", "month"], function(value, index) {
                return extend({}, item, {
                    groupInterval: value,
                    groupIndex: index
                })
            })
        }

        function parseFields(dataSource, fieldsList, path, fieldsDataType) {
            var result = [];
            iteratorUtils.each(fieldsList || [], function(field, value) {
                if (field && 0 === field.indexOf("__")) {
                    return
                }
                var items, dataIndex = 1,
                    currentPath = path.length ? path + "." + field : field,
                    dataType = fieldsDataType[currentPath],
                    getter = dataCoreUtils.compileGetter(currentPath);
                while (!typeUtils.isDefined(value) && dataSource[dataIndex]) {
                    value = getter(dataSource[dataIndex]);
                    dataIndex++
                }
                if (!dataType && typeUtils.isDefined(value)) {
                    dataType = typeUtils.type(value)
                }
                items = [{
                    dataField: currentPath,
                    dataType: dataType,
                    groupName: "date" === dataType ? field : void 0,
                    groupInterval: void 0,
                    displayFolder: path
                }];
                if ("date" === dataType) {
                    items = items.concat(createGroupFields(items[0]))
                } else {
                    if ("object" === dataType) {
                        items = parseFields(dataSource, value, currentPath, fieldsDataType)
                    }
                }
                result.push.apply(result, items)
            });
            return result
        }
        exports.discoverObjectFields = function(items, fields) {
            var fieldsDataType = exports.getFieldsDataType(fields);
            return parseFields(items, items[0], "", fieldsDataType)
        };
        exports.getFieldsDataType = function(fields) {
            var result = {};
            iteratorUtils.each(fields, function(_, field) {
                result[field.dataField] = result[field.dataField] || field.dataType
            });
            return result
        };
        var DATE_INTERVAL_FORMATS = {
            month: function(value) {
                return dateLocalization.getMonthNames()[value - 1]
            },
            quarter: function(value) {
                return dateLocalization.format(new Date(2e3, 3 * value - 1), "quarter")
            },
            dayOfWeek: function(value) {
                return dateLocalization.getDayNames()[value]
            }
        };
        exports.setDefaultFieldValueFormatting = function(field) {
            if ("date" === field.dataType) {
                if (!field.format) {
                    setFieldProperty(field, "format", DATE_INTERVAL_FORMATS[field.groupInterval])
                }
            } else {
                if ("number" === field.dataType) {
                    var groupInterval = typeUtils.isNumeric(field.groupInterval) && field.groupInterval > 0 && field.groupInterval;
                    if (groupInterval && !field.customizeText) {
                        setFieldProperty(field, "customizeText", function(formatObject) {
                            var secondValue = formatObject.value + groupInterval,
                                secondValueText = formatHelper.format(secondValue, field.format, field.precision);
                            return formatObject.valueText && secondValueText ? formatObject.valueText + " - " + secondValueText : ""
                        })
                    }
                }
            }
        };
        exports.getFiltersByPath = function(fields, path) {
            var result = [];
            path = path || [];
            for (var i = 0; i < path.length; i++) {
                result.push(extend({}, fields[i], {
                    groupIndex: null,
                    groupName: null,
                    filterType: "include",
                    filterValues: [path[i]]
                }))
            }
            return result
        };
        exports.storeDrillDownMixin = {
            createDrillDownDataSource: function(descriptions, params) {
                function createCustomStoreMethod(methodName) {
                    return function(options) {
                        var d;
                        if (arrayStore) {
                            d = arrayStore[methodName](options)
                        } else {
                            d = new Deferred;
                            when(items).done(function(data) {
                                arrayStore = new ArrayStore(data);
                                arrayStore[methodName](options).done(d.resolve).fail(d.reject)
                            }).fail(d.reject)
                        }
                        return d
                    }
                }
                var arrayStore, items = this.getDrillDownItems(descriptions, params),
                    dataSource = new DataSourceModule.DataSource({
                        load: createCustomStoreMethod("load"),
                        totalCount: createCustomStoreMethod("totalCount"),
                        key: this.key()
                    });
                return dataSource
            }
        };
        exports.capitalizeFirstLetter = function(string) {
            return string.charAt(0).toUpperCase() + string.slice(1)
        }
    },
    /*!***************************************!*\
      !*** ./artifacts/transpiled/color.js ***!
      \***************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    v = parseInt(colorString[3], 10),
                    rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    l = parseInt(colorString[3], 10),
                    rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var str, i = 0,
                ii = standardColorTypes.length;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var H, S, V, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                delta = max - min;
            V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var vDec, vInc, vMin, index, a, r, g, b;
            index = Math.floor(h % 360 / 60);
            vMin = (100 - s) * v / 100;
            a = (v - vMin) * (h % 60 / 60);
            vInc = vMin + a;
            vDec = v - a;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var h, s, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                maxMinSum = max + min,
                l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r, g, b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s,
                    p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        var _round = Math.round;
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor),
                    result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false,
            fromHSL: function(hsl) {
                var color = new Color,
                    rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                color.r = rgb[0];
                color.g = rgb[1];
                color.b = rgb[2];
                return color
            }
        };
        module.exports = Color
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter_registrator.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 52),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            dataUtils = __webpack_require__( /*! ../../core/element_data */ 38),
            Class = __webpack_require__( /*! ../../core/class */ 10),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 11).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            registerEvent = __webpack_require__( /*! ./event_registrator */ 63),
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            pointerEvents = __webpack_require__( /*! ../pointer */ 25),
            wheelEvent = __webpack_require__( /*! ./wheel */ 109);
        var MANAGER_EVENT = "dxEventManager",
            EMITTER_DATA = "dxEmitter";
        var EventManager = Class.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                readyCallbacks.add(function() {
                    var document = domAdapter.getDocument();
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, MANAGER_EVENT), this._pointerDownHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace([pointerEvents.up, pointerEvents.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(wheelEvent.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
                }.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if (eventUtils.isMouseEvent(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                each(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this,
                    result = [],
                    $element = $(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = dataUtils.data($element.get(0), EMITTER_DATA) || [];
                    each(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = inArray(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e),
                    verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction,
                    prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter,
                emitterName = emitterConfig.events[0],
                emitterEvents = emitterConfig.events;
            each(emitterEvents, function(_, eventName) {
                registerEvent(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA) || {},
                            emitters = dataUtils.data(element, EMITTER_DATA) || {},
                            emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        dataUtils.data(element, EMITTER_DATA, emitters);
                        dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = dataUtils.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        emitter.configure(extend({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA),
                            emitters = dataUtils.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        each(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        module.exports = registerEmitter
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/ui/validation_engine.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 10),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 53),
            errors = __webpack_require__( /*! ../core/errors */ 18),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            numberLocalization = __webpack_require__( /*! ../localization/number */ 49),
            messageLocalization = __webpack_require__( /*! ../localization/message */ 14);
        var BaseRuleValidator = Class.inherit({
            NAME: "base",
            defaultMessage: function(value) {
                return messageLocalization.getFormatter("validation-" + this.NAME)(value)
            },
            defaultFormattedMessage: function(value) {
                return messageLocalization.getFormatter("validation-" + this.NAME + "-formatted")(value)
            },
            validate: function(value, rule) {
                var valueArray = Array.isArray(value) ? value : [value],
                    result = true;
                if (valueArray.length) {
                    valueArray.every(function(itemValue) {
                        result = this._validate(itemValue, rule);
                        return result
                    }, this)
                } else {
                    result = this._validate(null, rule)
                }
                return result
            }
        });
        var RequiredRuleValidator = BaseRuleValidator.inherit({
            NAME: "required",
            _validate: function(value, rule) {
                if (!typeUtils.isDefined(value)) {
                    return false
                }
                if (false === value) {
                    return false
                }
                value = String(value);
                if (rule.trim || !typeUtils.isDefined(rule.trim)) {
                    value = value.trim()
                }
                return "" !== value
            }
        });
        var NumericRuleValidator = BaseRuleValidator.inherit({
            NAME: "numeric",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                if (rule.useCultureSettings && typeUtils.isString(value)) {
                    return !isNaN(numberLocalization.parse(value))
                } else {
                    return typeUtils.isNumeric(value)
                }
            }
        });
        var RangeRuleValidator = BaseRuleValidator.inherit({
            NAME: "range",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                var validNumber = rulesValidators.numeric.validate(value, rule),
                    validValue = typeUtils.isDefined(value),
                    number = validNumber ? parseFloat(value) : validValue && value.valueOf(),
                    min = rule.min,
                    max = rule.max;
                if (!(validNumber || typeUtils.isDate(value)) && !validValue) {
                    return false
                }
                if (typeUtils.isDefined(min)) {
                    if (typeUtils.isDefined(max)) {
                        return number >= min && number <= max
                    }
                    return number >= min
                } else {
                    if (typeUtils.isDefined(max)) {
                        return number <= max
                    } else {
                        throw errors.Error("E0101")
                    }
                }
            }
        });
        var StringLengthRuleValidator = BaseRuleValidator.inherit({
            NAME: "stringLength",
            _validate: function(value, rule) {
                value = typeUtils.isDefined(value) ? String(value) : "";
                if (rule.trim || !typeUtils.isDefined(rule.trim)) {
                    value = value.trim()
                }
                return rulesValidators.range.validate(value.length, extend({}, rule))
            }
        });
        var CustomRuleValidator = BaseRuleValidator.inherit({
            NAME: "custom",
            validate: function(value, rule) {
                var validator = rule.validator,
                    dataGetter = validator && typeUtils.isFunction(validator.option) && validator.option("dataGetter"),
                    data = typeUtils.isFunction(dataGetter) && dataGetter(),
                    params = {
                        value: value,
                        validator: validator,
                        rule: rule
                    };
                if (data) {
                    params.data = data
                }
                return rule.validationCallback(params)
            }
        });
        var CompareRuleValidator = BaseRuleValidator.inherit({
            NAME: "compare",
            _validate: function(value, rule) {
                if (!rule.comparisonTarget) {
                    throw errors.Error("E0102")
                }
                extend(rule, {
                    reevaluate: true
                });
                var otherValue = rule.comparisonTarget(),
                    type = rule.comparisonType || "==";
                switch (type) {
                    case "==":
                        return value == otherValue;
                    case "!=":
                        return value != otherValue;
                    case "===":
                        return value === otherValue;
                    case "!==":
                        return value !== otherValue;
                    case ">":
                        return value > otherValue;
                    case ">=":
                        return value >= otherValue;
                    case "<":
                        return value < otherValue;
                    case "<=":
                        return value <= otherValue
                }
            }
        });
        var PatternRuleValidator = BaseRuleValidator.inherit({
            NAME: "pattern",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                var pattern = rule.pattern;
                if (typeUtils.isString(pattern)) {
                    pattern = new RegExp(pattern)
                }
                return pattern.test(value)
            }
        });
        var EmailRuleValidator = BaseRuleValidator.inherit({
            NAME: "email",
            _validate: function(value, rule) {
                if (!rulesValidators.required.validate(value, {})) {
                    return true
                }
                return rulesValidators.pattern.validate(value, extend({}, rule, {
                    pattern: /^[\d\w\._\-]+@([\d\w\._\-]+\.)+[\w]+$/i
                }))
            }
        });
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = Class.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = []
            },
            validate: function() {
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: []
                };
                each(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRule) {
                        result.brokenRules.push(validatorResult.brokenRule)
                    }
                    result.validators.push(validator)
                });
                this.fireEvent("validated", [{
                    validators: result.validators,
                    brokenRules: result.brokenRules,
                    isValid: result.isValid
                }]);
                return result
            },
            reset: function() {
                each(this.validators, function(_, validator) {
                    validator.reset()
                })
            }
        }).include(EventsMixin);
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = commonUtils.grep(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group),
                    index = inArray(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(rule, validator, name) {
                if (!typeUtils.isDefined(rule.message)) {
                    if (validator.defaultFormattedMessage && typeUtils.isDefined(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            validate: function(value, rules, name) {
                var result = {
                        name: name,
                        value: value,
                        brokenRule: null,
                        isValid: true,
                        validationRules: rules
                    },
                    that = this;
                each(rules || [], function(_, rule) {
                    var ruleValidationResult, ruleValidator = rulesValidators[rule.type];
                    if (ruleValidator) {
                        if (typeUtils.isDefined(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                result.brokenRule = rule;
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            that._setDefaultMessage(rule, ruleValidator, name);
                            result.brokenRule = rule
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw errors.Error("E0100")
                    }
                });
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                if (inArray(validator, groupConfig.validators) < 0) {
                    groupConfig.validators.push(validator)
                }
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group,
                    isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group),
                    validatorsInGroup = config && config.validators;
                var index = inArray(validator, validatorsInGroup);
                if (index > -1) {
                    validatorsInGroup.splice(index, 1);
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw errors.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw errors.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        module.exports = ValidationEngine
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/hold.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventUtils = __webpack_require__( /*! ./utils */ 9),
            Emitter = __webpack_require__( /*! ./core/emitter */ 112),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 89),
            abs = Math.abs;
        var HOLD_EVENT_NAME = "dxhold",
            HOLD_TIMEOUT = 750,
            TOUCH_BOUNDARY = 5;
        var HoldEmitter = Emitter.inherit({
            start: function(e) {
                this._startEventData = eventUtils.eventData(e);
                this._startTimer(e)
            },
            _startTimer: function(e) {
                var holdTimeout = "timeout" in this ? this.timeout : HOLD_TIMEOUT;
                this._holdTimer = setTimeout(function() {
                    this._requestAccept(e);
                    this._fireEvent(HOLD_EVENT_NAME, e, {
                        target: e.target
                    });
                    this._forgetAccept()
                }.bind(this), holdTimeout)
            },
            move: function(e) {
                if (this._touchWasMoved(e)) {
                    this._cancel(e)
                }
            },
            _touchWasMoved: function(e) {
                var delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e));
                return abs(delta.x) > TOUCH_BOUNDARY || abs(delta.y) > TOUCH_BOUNDARY
            },
            end: function() {
                this._stopTimer()
            },
            _stopTimer: function() {
                clearTimeout(this._holdTimer)
            },
            cancel: function() {
                this._stopTimer()
            },
            dispose: function() {
                this._stopTimer()
            }
        });
        registerEmitter({
            emitter: HoldEmitter,
            bubble: true,
            events: [HOLD_EVENT_NAME]
        });
        module.exports = {
            name: HOLD_EVENT_NAME
        }
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/list/ui.list.edit.decorator_registry.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        exports.registry = {};
        exports.register = function(option, type, decoratorClass) {
            var decoratorsRegistry = exports.registry;
            var decoratorConfig = {};
            decoratorConfig[option] = decoratorsRegistry[option] ? decoratorsRegistry[option] : {};
            decoratorConfig[option][type] = decoratorClass;
            decoratorsRegistry = extend(decoratorsRegistry, decoratorConfig)
        }
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/ui/date_box/ui.date_utils.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            dateSerialization = __webpack_require__( /*! ../../core/utils/date_serialization */ 61),
            isDate = __webpack_require__( /*! ../../core/utils/type */ 1).isDate,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            dateLocalization = __webpack_require__( /*! ../../localization/date */ 33);
        var dateComponents = function() {
            return ["year", "day", "month", "day"]
        };
        var ONE_MINUTE = 6e4;
        var ONE_DAY = 60 * ONE_MINUTE * 24;
        var ONE_YEAR = 365 * ONE_DAY;
        var getStringFormat = function(format) {
            var formatType = "undefined" === typeof format ? "undefined" : _typeof(format);
            if ("string" === formatType) {
                return "format"
            }
            if ("object" === formatType && void 0 !== format.type) {
                return format.type
            }
            return null
        };
        var dateUtils = {
            SUPPORTED_FORMATS: ["date", "time", "datetime"],
            DATE_COMPONENT_TEXT_FORMATTER: function(value, name) {
                var $container = $("<div>").addClass("dx-dateview-formatter-container");
                $("<span>").text(value).addClass("dx-dateview-value-formatter").appendTo($container);
                $("<span>").text(name).addClass("dx-dateview-name-formatter").appendTo($container);
                return $container
            },
            ONE_MINUTE: ONE_MINUTE,
            ONE_DAY: ONE_DAY,
            ONE_YEAR: ONE_YEAR,
            MIN_DATEVIEW_DEFAULT_DATE: new Date(1900, 0, 1),
            MAX_DATEVIEW_DEFAULT_DATE: function() {
                var newDate = new Date;
                return new Date(newDate.getFullYear() + 50, newDate.getMonth(), newDate.getDate(), 23, 59, 59)
            }(),
            FORMATS_INFO: {
                date: {
                    getStandardPattern: function() {
                        return "yyyy-MM-dd"
                    },
                    components: dateComponents()
                },
                time: {
                    getStandardPattern: function() {
                        return "HH:mm"
                    },
                    components: ["hours", "minutes", "seconds", "milliseconds"]
                },
                datetime: {
                    getStandardPattern: function() {
                        var standardPattern;
                        ! function() {
                            var androidFormatPattern = "yyyy-MM-ddTHH:mmZ",
                                testDateString = "2000-01-01T01:01Z";
                            var $input = $("<input>").attr("type", "datetime");
                            $input.val(testDateString);
                            if ($input.val()) {
                                standardPattern = androidFormatPattern
                            }
                        }();
                        if (!standardPattern) {
                            standardPattern = "yyyy-MM-ddTHH:mm:ssZ"
                        }
                        dateUtils.FORMATS_INFO.datetime.getStandardPattern = function() {
                            return standardPattern
                        };
                        return standardPattern
                    },
                    components: dateComponents().concat(["hours", "minutes", "seconds", "milliseconds"])
                },
                "datetime-local": {
                    getStandardPattern: function() {
                        return "yyyy-MM-ddTHH:mm:ss"
                    },
                    components: dateComponents().concat(["hours", "minutes", "seconds"])
                }
            },
            FORMATS_MAP: {
                date: "shortdate",
                time: "shorttime",
                datetime: "shortdateshorttime"
            },
            SUBMIT_FORMATS_MAP: {
                date: "date",
                time: "time",
                datetime: "datetime-local"
            },
            toStandardDateFormat: function(date, type) {
                var pattern = dateUtils.FORMATS_INFO[type].getStandardPattern();
                return dateSerialization.serializeDate(date, pattern)
            },
            fromStandardDateFormat: function(text) {
                var date = dateSerialization.dateParser(text);
                return isDate(date) ? date : void 0
            },
            getMaxMonthDay: function(year, month) {
                return new Date(year, month + 1, 0).getDate()
            },
            mergeDates: function(oldValue, newValue, format) {
                if (!newValue) {
                    return newValue || null
                }
                if (!oldValue || isNaN(oldValue.getTime())) {
                    var now = new Date(null);
                    oldValue = new Date(now.getFullYear(), now.getMonth(), now.getDate())
                }
                var result = new Date(oldValue.valueOf());
                var formatInfo = dateUtils.FORMATS_INFO[format];
                each(formatInfo.components, function() {
                    var componentInfo = dateUtils.DATE_COMPONENTS_INFO[this];
                    result[componentInfo.setter](newValue[componentInfo.getter]())
                });
                return result
            },
            getLongestCaptionIndex: function(captionArray) {
                var i, longestIndex = 0,
                    longestCaptionLength = 0;
                for (i = 0; i < captionArray.length; ++i) {
                    if (captionArray[i].length > longestCaptionLength) {
                        longestIndex = i;
                        longestCaptionLength = captionArray[i].length
                    }
                }
                return longestIndex
            },
            formatUsesMonthName: function(format) {
                return dateLocalization.formatUsesMonthName(format)
            },
            formatUsesDayName: function(format) {
                return dateLocalization.formatUsesDayName(format)
            },
            getLongestDate: function(format, monthNames, dayNames) {
                var stringFormat = getStringFormat(format),
                    month = 9;
                if (!stringFormat || dateUtils.formatUsesMonthName(stringFormat)) {
                    month = dateUtils.getLongestCaptionIndex(monthNames)
                }
                var longestDate = new Date(1888, month, 21, 23, 59, 59, 999);
                if (!stringFormat || dateUtils.formatUsesDayName(stringFormat)) {
                    var date = longestDate.getDate() - longestDate.getDay() + dateUtils.getLongestCaptionIndex(dayNames);
                    longestDate.setDate(date)
                }
                return longestDate
            },
            normalizeTime: function(date) {
                date.setSeconds(0);
                date.setMilliseconds(0)
            }
        };
        dateUtils.DATE_COMPONENTS_INFO = {
            year: {
                getter: "getFullYear",
                setter: "setFullYear",
                formatter: function(value, showNames, date) {
                    var formatDate = new Date(date.getTime());
                    formatDate.setFullYear(value);
                    return dateLocalization.format(formatDate, "yyyy")
                },
                startValue: void 0,
                endValue: void 0
            },
            day: {
                getter: "getDate",
                setter: "setDate",
                formatter: function(value, showNames, date) {
                    var formatDate = new Date(date.getTime());
                    formatDate.setDate(value);
                    if (!showNames) {
                        return dateLocalization.format(formatDate, "d")
                    }
                    return dateUtils.DATE_COMPONENT_TEXT_FORMATTER(value, dateLocalization.getDayNames()[formatDate.getDay()])
                },
                startValue: 1,
                endValue: void 0
            },
            month: {
                getter: "getMonth",
                setter: "setMonth",
                formatter: function(value, showNames) {
                    var monthName = dateLocalization.getMonthNames()[value];
                    return showNames ? dateUtils.DATE_COMPONENT_TEXT_FORMATTER(value + 1, monthName) : monthName
                },
                startValue: 0,
                endValue: 11
            },
            hours: {
                getter: "getHours",
                setter: "setHours",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, value), "hour")
                },
                startValue: 0,
                endValue: 23
            },
            minutes: {
                getter: "getMinutes",
                setter: "setMinutes",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, value), "minute")
                },
                startValue: 0,
                endValue: 59
            },
            seconds: {
                getter: "getSeconds",
                setter: "setSeconds",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, 0, value), "second")
                },
                startValue: 0,
                endValue: 59
            },
            milliseconds: {
                getter: "getMilliseconds",
                setter: "setMilliseconds",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, 0, 0, value), "millisecond")
                },
                startValue: 0,
                endValue: 999
            }
        };
        module.exports = dateUtils
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/function_template.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var TemplateBase = __webpack_require__( /*! ./ui.template_base */ 77),
            domUtils = __webpack_require__( /*! ../../core/utils/dom */ 13);
        var FunctionTemplate = TemplateBase.inherit({
            ctor: function(render) {
                this._render = render
            },
            _renderCore: function(options) {
                return domUtils.normalizeTemplateElement(this._render(options))
            }
        });
        module.exports = FunctionTemplate
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/data/abstract_store.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 10),
            abstract = Class.abstract,
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 53),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            errorsModule = __webpack_require__( /*! ./errors */ 36),
            dataUtils = __webpack_require__( /*! ./utils */ 41),
            compileGetter = __webpack_require__( /*! ../core/utils/data */ 23).compileGetter,
            storeHelper = __webpack_require__( /*! ./store_helper */ 81),
            queryByOptions = storeHelper.queryByOptions,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 7).Deferred,
            storeImpl = {};
        var Store = Class.inherit({
            ctor: function(options) {
                var that = this;
                options = options || {};
                each(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onRemoved", "onRemoving", "onModified", "onModifying"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.slice(2).toLowerCase(), options[optionName])
                    }
                });
                this._key = options.key;
                this._errorHandler = options.errorHandler;
                this._useDefaultSearch = true
            },
            _customLoadOptions: function() {
                return null
            },
            key: function() {
                return this._key
            },
            keyOf: function(obj) {
                if (!this._keyGetter) {
                    this._keyGetter = compileGetter(this.key())
                }
                return this._keyGetter(obj)
            },
            _requireKey: function() {
                if (!this.key()) {
                    throw errorsModule.errors.Error("E4005")
                }
            },
            load: function(options) {
                var that = this;
                options = options || {};
                this.fireEvent("loading", [options]);
                return this._withLock(this._loadImpl(options)).done(function(result) {
                    that.fireEvent("loaded", [result, options])
                })
            },
            _loadImpl: function(options) {
                return queryByOptions(this.createQuery(options), options).enumerate()
            },
            _withLock: function(task) {
                var result = new Deferred;
                task.done(function() {
                    var that = this,
                        args = arguments;
                    dataUtils.processRequestResultLock.promise().done(function() {
                        result.resolveWith(that, args)
                    })
                }).fail(function() {
                    result.rejectWith(this, arguments)
                });
                return result
            },
            createQuery: abstract,
            totalCount: function(options) {
                return this._totalCountImpl(options)
            },
            _totalCountImpl: function(options) {
                return queryByOptions(this.createQuery(options), options, true).count()
            },
            byKey: function(key, extraOptions) {
                return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
            },
            _byKeyImpl: abstract,
            insert: function(values) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("inserting", [values]);
                return that._addFailHandlers(that._insertImpl(values).done(function(callbackValues, callbackKey) {
                    that.fireEvent("inserted", [callbackValues, callbackKey]);
                    that.fireEvent("modified")
                }))
            },
            _insertImpl: abstract,
            update: function(key, values) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("updating", [key, values]);
                return that._addFailHandlers(that._updateImpl(key, values).done(function(callbackKey, callbackValues) {
                    that.fireEvent("updated", [callbackKey, callbackValues]);
                    that.fireEvent("modified")
                }))
            },
            _updateImpl: abstract,
            remove: function(key) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("removing", [key]);
                return that._addFailHandlers(that._removeImpl(key).done(function(callbackKey) {
                    that.fireEvent("removed", [callbackKey]);
                    that.fireEvent("modified")
                }))
            },
            _removeImpl: abstract,
            _addFailHandlers: function(deferred) {
                return deferred.fail(this._errorHandler).fail(errorsModule._errorHandler)
            }
        }).include(EventsMixin);
        Store.create = function(alias, options) {
            if (!(alias in storeImpl)) {
                throw errorsModule.errors.Error("E4020", alias)
            }
            return new storeImpl[alias](options)
        };
        Store.inherit = function(inheritor) {
            return function(members, alias) {
                var type = inheritor.apply(this, [members]);
                if (alias) {
                    storeImpl[alias] = type
                }
                return type
            }
        }(Store.inherit);
        module.exports = Store
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/ui/text_box.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./text_box/text_box */ 450)
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/child_default_template.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var TemplateBase = __webpack_require__( /*! ./ui.template_base */ 77);
        module.exports = TemplateBase.inherit({
            ctor: function(name) {
                this.name = name
            }
        })
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter.feedback.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../../core/class */ 10),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            contains = __webpack_require__( /*! ../../core/utils/dom */ 13).contains,
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            pointerEvents = __webpack_require__( /*! ../pointer */ 25),
            Emitter = __webpack_require__( /*! ./emitter */ 112),
            registerEmitter = __webpack_require__( /*! ./emitter_registrator */ 89);
        var ACTIVE_EVENT_NAME = "dxactive",
            INACTIVE_EVENT_NAME = "dxinactive",
            ACTIVE_TIMEOUT = 30,
            INACTIVE_TIMEOUT = 400;
        var FeedbackEvent = Class.inherit({
            ctor: function(timeout, fire) {
                this._timeout = timeout;
                this._fire = fire
            },
            start: function() {
                var that = this;
                this._schedule(function() {
                    that.force()
                })
            },
            _schedule: function(fn) {
                this.stop();
                this._timer = setTimeout(fn, this._timeout)
            },
            stop: function() {
                clearTimeout(this._timer)
            },
            force: function() {
                if (this._fired) {
                    return
                }
                this.stop();
                this._fire();
                this._fired = true
            },
            fired: function() {
                return this._fired
            }
        });
        var activeFeedback;
        var FeedbackEmitter = Emitter.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._active = new FeedbackEvent(0, commonUtils.noop);
                this._inactive = new FeedbackEvent(0, commonUtils.noop)
            },
            configure: function(data, eventName) {
                switch (eventName) {
                    case ACTIVE_EVENT_NAME:
                        data.activeTimeout = data.timeout;
                        break;
                    case INACTIVE_EVENT_NAME:
                        data.inactiveTimeout = data.timeout
                }
                this.callBase(data)
            },
            start: function(e) {
                if (activeFeedback) {
                    var activeChildExists = contains(this.getElement().get(0), activeFeedback.getElement().get(0));
                    var childJustActivated = !activeFeedback._active.fired();
                    if (activeChildExists && childJustActivated) {
                        this._cancel();
                        return
                    }
                    activeFeedback._inactive.force()
                }
                activeFeedback = this;
                this._initEvents(e);
                this._active.start()
            },
            _initEvents: function(e) {
                var that = this,
                    eventTarget = this._getEmitterTarget(e),
                    mouseEvent = eventUtils.isMouseEvent(e),
                    isSimulator = devices.isSimulator(),
                    deferFeedback = isSimulator || !mouseEvent,
                    activeTimeout = commonUtils.ensureDefined(this.activeTimeout, ACTIVE_TIMEOUT),
                    inactiveTimeout = commonUtils.ensureDefined(this.inactiveTimeout, INACTIVE_TIMEOUT);
                this._active = new FeedbackEvent(deferFeedback ? activeTimeout : 0, function() {
                    that._fireEvent(ACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    })
                });
                this._inactive = new FeedbackEvent(deferFeedback ? inactiveTimeout : 0, function() {
                    that._fireEvent(INACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    });
                    activeFeedback = null
                })
            },
            cancel: function(e) {
                this.end(e)
            },
            end: function(e) {
                var skipTimers = e.type !== pointerEvents.up;
                if (skipTimers) {
                    this._active.stop()
                } else {
                    this._active.force()
                }
                this._inactive.start();
                if (skipTimers) {
                    this._inactive.force()
                }
            },
            dispose: function() {
                this._active.stop();
                this._inactive.stop();
                this.callBase()
            },
            lockInactive: function() {
                this._active.force();
                this._inactive.stop();
                activeFeedback = null;
                this._cancel();
                return this._inactive.force.bind(this._inactive)
            }
        });
        FeedbackEmitter.lock = function(deferred) {
            var lockInactive = activeFeedback ? activeFeedback.lockInactive() : commonUtils.noop;
            deferred.done(lockInactive)
        };
        registerEmitter({
            emitter: FeedbackEmitter,
            events: [ACTIVE_EVENT_NAME, INACTIVE_EVENT_NAME]
        });
        exports.lock = FeedbackEmitter.lock;
        exports.active = ACTIVE_EVENT_NAME;
        exports.inactive = INACTIVE_EVENT_NAME
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled/core/polyfills/promise.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 7),
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 6),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            promise = windowUtils.hasWindow() ? windowUtils.getWindow().Promise : Promise;
        if (!promise) {
            promise = function(resolver) {
                var d = new Deferred;
                resolver(d.resolve.bind(this), d.reject.bind(this));
                return d.promise()
            };
            promise.resolve = function(val) {
                return (new Deferred).resolve(val).promise()
            };
            promise.reject = function(val) {
                return (new Deferred).reject(val).promise()
            };
            promise.all = function(promises) {
                return when.apply(this, promises).then(function() {
                    return [].slice.call(arguments)
                })
            }
        }
        module.exports = promise
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/odata/utils.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var Class = __webpack_require__( /*! ../../core/class */ 10),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 71),
            _Guid = __webpack_require__( /*! ../../core/guid */ 54),
            isDefined = typeUtils.isDefined,
            Deferred = __webpack_require__( /*! ../../core/utils/deferred */ 7).Deferred,
            errors = __webpack_require__( /*! ../errors */ 36).errors,
            dataUtils = __webpack_require__( /*! ../utils */ 41);
        var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
        var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
        var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
        var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";

        function formatISO8601(date, skipZeroTime, skipTimezone) {
            var bag = [];
            var pad = function(n) {
                if (n < 10) {
                    return "0".concat(n)
                }
                return String(n)
            };
            var isZeroTime = function() {
                return date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1
            };
            bag.push(date.getFullYear());
            bag.push("-");
            bag.push(pad(date.getMonth() + 1));
            bag.push("-");
            bag.push(pad(date.getDate()));
            if (!(skipZeroTime && isZeroTime())) {
                bag.push("T");
                bag.push(pad(date.getHours()));
                bag.push(":");
                bag.push(pad(date.getMinutes()));
                bag.push(":");
                bag.push(pad(date.getSeconds()));
                if (date.getMilliseconds()) {
                    bag.push(".");
                    bag.push(date.getMilliseconds())
                }
                if (!skipTimezone) {
                    bag.push("Z")
                }
            }
            return bag.join("")
        }

        function parseISO8601(isoString) {
            var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3),
                chunks = isoString.replace("Z", "").split("T"),
                date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]),
                time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
            result.setFullYear(Number(date[1]));
            result.setMonth(Number(date[2]) - 1);
            result.setDate(Number(date[3]));
            if (Array.isArray(time) && time.length) {
                result.setHours(Number(time[1]));
                result.setMinutes(Number(time[2]));
                result.setSeconds(Number(time[3]));
                result.setMilliseconds(Number(String(time[4]).substr(0, 3)) || 0)
            }
            return result
        }

        function isAbsoluteUrl(url) {
            return /^(?:[a-z]+:)?\/\//i.test(url)
        }

        function toAbsoluteUrl(basePath, relativePath) {
            var part;
            var baseParts = stripParams(basePath).split("/");
            var relativeParts = relativePath.split("/");

            function stripParams(url) {
                var index = url.indexOf("?");
                if (index > -1) {
                    return url.substr(0, index)
                }
                return url
            }
            baseParts.pop();
            while (relativeParts.length) {
                part = relativeParts.shift();
                if (".." === part) {
                    baseParts.pop()
                } else {
                    baseParts.push(part)
                }
            }
            return baseParts.join("/")
        }
        var param = function(params) {
            var result = [];
            for (var name in params) {
                result.push(name + "=" + params[name])
            }
            return result.join("&")
        };
        var ajaxOptionsForRequest = function(protocolVersion, request, options) {
            request = extend({
                async: true,
                method: "get",
                url: "",
                params: {},
                payload: null,
                headers: {},
                timeout: 3e4
            }, request);
            options = options || {};
            var beforeSend = options.beforeSend;
            if (beforeSend) {
                beforeSend(request)
            }
            var method = (request.method || "get").toLowerCase(),
                isGet = "get" === method,
                useJsonp = isGet && options.jsonp,
                params = extend({}, request.params),
                ajaxData = isGet ? params : formatPayload(request.payload),
                qs = !isGet && param(params),
                url = request.url,
                contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
            if (qs) {
                url += (url.indexOf("?") > -1 ? "&" : "?") + qs
            }
            if (useJsonp) {
                ajaxData.$format = "json"
            }
            return {
                url: url,
                data: ajaxData,
                dataType: useJsonp ? "jsonp" : "json",
                jsonp: useJsonp && "$callback",
                method: method,
                async: request.async,
                timeout: request.timeout,
                headers: request.headers,
                contentType: contentType,
                accepts: {
                    json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                },
                xhrFields: {
                    withCredentials: options.withCredentials
                }
            };

            function formatPayload(payload) {
                return JSON.stringify(payload, function(key, value) {
                    if (!(this[key] instanceof Date)) {
                        return value
                    }
                    value = formatISO8601(this[key]);
                    switch (protocolVersion) {
                        case 2:
                            return value.substr(0, value.length - 1);
                        case 3:
                        case 4:
                            return value;
                        default:
                            throw errors.Error("E4002")
                    }
                })
            }
        };
        var sendRequest = function sendRequest(protocolVersion, request, options) {
            var d = new Deferred;
            var ajaxOptions = ajaxOptionsForRequest(protocolVersion, request, options);
            ajax.sendRequest(ajaxOptions).always(function(obj, textStatus) {
                var extra, transformOptions = {
                        deserializeDates: options.deserializeDates,
                        fieldTypes: options.fieldTypes
                    },
                    tuple = interpretJsonFormat(obj, textStatus, transformOptions),
                    error = tuple.error,
                    data = tuple.data,
                    nextUrl = tuple.nextUrl;
                if (error) {
                    if (error.message !== dataUtils.XHR_ERROR_UNLOAD) {
                        d.reject(error)
                    }
                } else {
                    if (options.countOnly) {
                        if (isFinite(tuple.count)) {
                            d.resolve(tuple.count)
                        } else {
                            d.reject(new errors.Error("E4018"))
                        }
                    } else {
                        if (nextUrl && !options.isPaged) {
                            if (!isAbsoluteUrl(nextUrl)) {
                                nextUrl = toAbsoluteUrl(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done(function(nextData) {
                                d.resolve(data.concat(nextData))
                            })
                        } else {
                            if (isFinite(tuple.count)) {
                                extra = {
                                    totalCount: tuple.count
                                }
                            }
                            d.resolve(data, extra)
                        }
                    }
                }
            });
            return d.promise()
        };
        var formatDotNetError = function(errorObj) {
            var message, currentError = errorObj;
            if ("message" in errorObj) {
                if (errorObj.message.value) {
                    message = errorObj.message.value
                } else {
                    message = errorObj.message
                }
            }
            while (currentError = currentError.innererror || currentError.internalexception) {
                message = currentError.message;
                if (currentError.internalexception && message.indexOf("inner exception") === -1) {
                    break
                }
            }
            return message
        };
        var errorFromResponse = function(obj, textStatus) {
            if ("nocontent" === textStatus) {
                return null
            }
            var httpStatus = 200,
                message = "Unknown error",
                response = obj;
            if ("success" !== textStatus) {
                httpStatus = obj.status;
                message = dataUtils.errorMessageFromXhr(obj, textStatus);
                try {
                    response = JSON.parse(obj.responseText)
                } catch (x) {}
            }
            var errorObj = response && (response.then && response || response.error || response["odata.error"] || response["@odata.error"]);
            if (errorObj) {
                message = formatDotNetError(errorObj) || message;
                if (200 === httpStatus) {
                    httpStatus = 500
                }
                if (errorObj.code) {
                    httpStatus = Number(errorObj.code)
                }
                return extend(Error(message), {
                    httpStatus: httpStatus,
                    errorDetails: errorObj
                })
            } else {
                if (200 !== httpStatus) {
                    return extend(Error(message), {
                        httpStatus: httpStatus
                    })
                }
            }
        };
        var interpretJsonFormat = function(obj, textStatus, transformOptions) {
            var value, error = errorFromResponse(obj, textStatus);
            if (error) {
                return {
                    error: error
                }
            }
            if (!typeUtils.isPlainObject(obj)) {
                return {
                    data: obj
                }
            }
            if ("d" in obj && (Array.isArray(obj.d) || typeUtils.isObject(obj.d))) {
                value = interpretVerboseJsonFormat(obj, textStatus)
            } else {
                value = interpretLightJsonFormat(obj, textStatus)
            }
            transformTypes(value, transformOptions);
            return value
        };
        var interpretVerboseJsonFormat = function(obj) {
            var data = obj.d;
            if (!isDefined(data)) {
                return {
                    error: Error("Malformed or unsupported JSON response received")
                }
            }
            data = data;
            if (isDefined(data.results)) {
                data = data.results
            }
            return {
                data: data,
                nextUrl: obj.d.__next,
                count: parseInt(obj.d.__count, 10)
            }
        };
        var interpretLightJsonFormat = function(obj) {
            var data = obj;
            if (isDefined(data.value)) {
                data = data.value
            }
            return {
                data: data,
                nextUrl: obj["@odata.nextLink"],
                count: parseInt(obj["@odata.count"], 10)
            }
        };
        var EdmLiteral = Class.inherit({
            ctor: function(value) {
                this._value = value
            },
            valueOf: function() {
                return this._value
            }
        });
        var transformTypes = function transformTypes(obj, options) {
            options = options || {};
            each(obj, function(key, value) {
                if (null !== value && "object" === ("undefined" === typeof value ? "undefined" : _typeof(value))) {
                    if ("results" in value) {
                        obj[key] = value.results
                    }
                    transformTypes(obj[key], options)
                } else {
                    if ("string" === typeof value) {
                        var fieldTypes = options.fieldTypes,
                            canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                        if (canBeGuid && GUID_REGEX.test(value)) {
                            obj[key] = new _Guid(value)
                        }
                        if (false !== options.deserializeDates) {
                            if (value.match(VERBOSE_DATE_REGEX)) {
                                var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                            } else {
                                if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }
                }
            })
        };
        var serializeDate = function(date) {
            return "datetime'" + formatISO8601(date, true, true) + "'"
        };
        var serializeString = function(value) {
            return "'" + value.replace(/'/g, "''") + "'"
        };
        var serializePropName = function(propName) {
            if (propName instanceof EdmLiteral) {
                return propName.valueOf()
            }
            return propName.replace(/\./g, "/")
        };
        var serializeValueV4 = function serializeValueV4(value) {
            if (value instanceof Date) {
                return formatISO8601(value, false, false)
            }
            if (value instanceof _Guid) {
                return value.valueOf()
            }
            if (Array.isArray(value)) {
                return "[" + value.map(function(item) {
                    return serializeValueV4(item)
                }).join(",") + "]"
            }
            return serializeValueV2(value)
        };
        var serializeValueV2 = function(value) {
            if (value instanceof Date) {
                return serializeDate(value)
            }
            if (value instanceof _Guid) {
                return "guid'" + value + "'"
            }
            if (value instanceof EdmLiteral) {
                return value.valueOf()
            }
            if ("string" === typeof value) {
                return serializeString(value)
            }
            return String(value)
        };
        var serializeValue = function(value, protocolVersion) {
            switch (protocolVersion) {
                case 2:
                case 3:
                    return serializeValueV2(value);
                case 4:
                    return serializeValueV4(value);
                default:
                    throw errors.Error("E4002")
            }
        };
        var serializeKey = function(key, protocolVersion) {
            if (typeUtils.isPlainObject(key)) {
                var parts = [];
                each(key, function(k, v) {
                    parts.push(serializePropName(k) + "=" + serializeValue(v, protocolVersion))
                });
                return parts.join()
            }
            return serializeValue(key, protocolVersion)
        };
        var keyConverters = {
            String: function(value) {
                return value + ""
            },
            Int32: function(value) {
                return Math.floor(value)
            },
            Int64: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "L")
            },
            Guid: function(value) {
                if (value instanceof _Guid) {
                    return value
                }
                return new _Guid(value)
            },
            Boolean: function(value) {
                return !!value
            },
            Single: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "f")
            },
            Decimal: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "m")
            }
        };
        var convertPrimitiveValue = function(type, value) {
            if (null === value) {
                return null
            }
            var converter = keyConverters[type];
            if (!converter) {
                throw errors.Error("E4014", type)
            }
            return converter(value)
        };
        exports.sendRequest = sendRequest;
        exports.serializePropName = serializePropName;
        exports.serializeValue = serializeValue;
        exports.serializeKey = serializeKey;
        exports.keyConverters = keyConverters;
        exports.convertPrimitiveValue = convertPrimitiveValue;
        exports.EdmLiteral = EdmLiteral;
        exports.OData__internals = {
            interpretJsonFormat: interpretJsonFormat
        }
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/ui/scroll_view/ui.scrollable.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            support = __webpack_require__( /*! ../../core/utils/support */ 44),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 30),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            getPublicElement = __webpack_require__( /*! ../../core/utils/dom */ 13).getPublicElement,
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 6),
            navigator = windowUtils.getNavigator(),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 8),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 57),
            selectors = __webpack_require__( /*! ../widget/selectors */ 56),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9),
            scrollEvents = __webpack_require__( /*! ./ui.events.emitter.gesture.scroll */ 469),
            simulatedStrategy = __webpack_require__( /*! ./ui.scrollable.simulated */ 288),
            NativeStrategy = __webpack_require__( /*! ./ui.scrollable.native */ 172),
            when = __webpack_require__( /*! ../../core/utils/deferred */ 7).when;
        var SCROLLABLE = "dxScrollable",
            SCROLLABLE_STRATEGY = "dxScrollableStrategy",
            SCROLLABLE_CLASS = "dx-scrollable",
            SCROLLABLE_DISABLED_CLASS = "dx-scrollable-disabled",
            SCROLLABLE_CONTAINER_CLASS = "dx-scrollable-container",
            SCROLLABLE_WRAPPER_CLASS = "dx-scrollable-wrapper",
            SCROLLABLE_CONTENT_CLASS = "dx-scrollable-content",
            VERTICAL = "vertical",
            HORIZONTAL = "horizontal",
            BOTH = "both";
        var deviceDependentOptions = function() {
            return [{
                device: function() {
                    return !support.nativeScrolling
                },
                options: {
                    useNative: false
                }
            }, {
                device: function(_device) {
                    return !devices.isSimulator() && "generic" === devices.real().platform && "generic" === _device.platform
                },
                options: {
                    bounceEnabled: false,
                    scrollByThumb: true,
                    scrollByContent: support.touch,
                    showScrollbar: "onHover"
                }
            }]
        };
        var Scrollable = DOMComponent.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    disabled: false,
                    onScroll: null,
                    direction: VERTICAL,
                    showScrollbar: "onScroll",
                    useNative: true,
                    bounceEnabled: true,
                    scrollByContent: true,
                    scrollByThumb: false,
                    onUpdated: null,
                    onStart: null,
                    onEnd: null,
                    onBounce: null,
                    onStop: null,
                    useSimulatedScrollbar: false,
                    useKeyboard: true,
                    inertiaEnabled: true,
                    pushBackValue: 0,
                    updateManually: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat(deviceDependentOptions(), [{
                    device: function() {
                        return support.nativeScrolling && "android" === devices.real().platform && !browser.mozilla
                    },
                    options: {
                        useSimulatedScrollbar: true
                    }
                }, {
                    device: function() {
                        return "ios" === devices.real().platform
                    },
                    options: {
                        pushBackValue: 1
                    }
                }])
            },
            _initOptions: function(options) {
                this.callBase(options);
                if (!("useSimulatedScrollbar" in options)) {
                    this._setUseSimulatedScrollbar()
                }
            },
            _setUseSimulatedScrollbar: function() {
                if (!this.initialOption("useSimulatedScrollbar")) {
                    this.option("useSimulatedScrollbar", !this.option("useNative"))
                }
            },
            _init: function() {
                this.callBase();
                this._initScrollableMarkup();
                this._locked = false
            },
            _visibilityChanged: function(visible) {
                if (visible) {
                    this.update();
                    this._updateRtlPosition(this.option("rtlEnabled"));
                    this._savedScrollOffset && this.scrollTo(this._savedScrollOffset);
                    delete this._savedScrollOffset
                } else {
                    this._savedScrollOffset = this.scrollOffset()
                }
            },
            _initScrollableMarkup: function() {
                var $element = this.$element().addClass(SCROLLABLE_CLASS),
                    $container = this._$container = $("<div>").addClass(SCROLLABLE_CONTAINER_CLASS),
                    $wrapper = this._$wrapper = $("<div>").addClass(SCROLLABLE_WRAPPER_CLASS),
                    $content = this._$content = $("<div>").addClass(SCROLLABLE_CONTENT_CLASS);
                if (domAdapter.hasDocumentProperty("onbeforeactivate") && browser.msie && browser.version < 12) {
                    eventsEngine.on($element, eventUtils.addNamespace("beforeactivate", SCROLLABLE), function(e) {
                        if (!$(e.target).is(selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
                $content.append($element.contents()).appendTo($container);
                $container.appendTo($wrapper);
                $wrapper.appendTo($element)
            },
            _dimensionChanged: function() {
                this.update()
            },
            _attachNativeScrollbarsCustomizationCss: function() {
                if ("desktop" === devices.real().deviceType && !(navigator.platform.indexOf("Mac") > -1 && browser.webkit)) {
                    this.$element().addClass("dx-scrollable-customizable-scrollbars")
                }
            },
            _initMarkup: function() {
                this.callBase();
                this._renderDirection()
            },
            _render: function() {
                this._renderStrategy();
                this._attachNativeScrollbarsCustomizationCss();
                this._attachEventHandlers();
                this._renderDisabledState();
                this._createActions();
                this.update();
                this.callBase();
                this._updateRtlPosition(this.option("rtlEnabled"))
            },
            _updateRtlPosition: function(rtl) {
                var that = this;
                this._updateBounds();
                if (rtl && this.option("direction") !== VERTICAL) {
                    commonUtils.deferUpdate(function() {
                        var left = that.scrollWidth() - that.clientWidth();
                        commonUtils.deferRender(function() {
                            that.scrollTo({
                                left: left
                            })
                        })
                    })
                }
            },
            _updateBounds: function() {
                this._strategy.updateBounds()
            },
            _attachEventHandlers: function() {
                var strategy = this._strategy;
                var initEventData = {
                    getDirection: strategy.getDirection.bind(strategy),
                    validate: this._validate.bind(this),
                    isNative: this.option("useNative"),
                    scrollTarget: this._$container
                };
                eventsEngine.off(this._$wrapper, "." + SCROLLABLE);
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.init, SCROLLABLE), initEventData, this._initHandler.bind(this));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.start, SCROLLABLE), strategy.handleStart.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.move, SCROLLABLE), strategy.handleMove.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.end, SCROLLABLE), strategy.handleEnd.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.cancel, SCROLLABLE), strategy.handleCancel.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.stop, SCROLLABLE), strategy.handleStop.bind(strategy));
                eventsEngine.off(this._$container, "." + SCROLLABLE);
                eventsEngine.on(this._$container, eventUtils.addNamespace("scroll", SCROLLABLE), strategy.handleScroll.bind(strategy))
            },
            _validate: function(e) {
                if (this._isLocked()) {
                    return false
                }
                this._updateIfNeed();
                return this._strategy.validate(e)
            },
            _initHandler: function() {
                var strategy = this._strategy;
                strategy.handleInit.apply(strategy, arguments)
            },
            _renderDisabledState: function() {
                this.$element().toggleClass(SCROLLABLE_DISABLED_CLASS, this.option("disabled"));
                if (this.option("disabled")) {
                    this._lock()
                } else {
                    this._unlock()
                }
            },
            _renderDirection: function() {
                this.$element().removeClass("dx-scrollable-" + HORIZONTAL).removeClass("dx-scrollable-" + VERTICAL).removeClass("dx-scrollable-" + BOTH).addClass("dx-scrollable-" + this.option("direction"))
            },
            _renderStrategy: function() {
                this._createStrategy();
                this._strategy.render();
                this.$element().data(SCROLLABLE_STRATEGY, this._strategy)
            },
            _createStrategy: function() {
                this._strategy = this.option("useNative") ? new NativeStrategy(this) : new simulatedStrategy.SimulatedStrategy(this)
            },
            _createActions: function() {
                this._strategy && this._strategy.createActions()
            },
            _clean: function() {
                this._strategy && this._strategy.dispose()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onStart":
                    case "onEnd":
                    case "onStop":
                    case "onUpdated":
                    case "onScroll":
                    case "onBounce":
                        this._createActions();
                        break;
                    case "direction":
                        this._resetInactiveDirection();
                        this._invalidate();
                        break;
                    case "useNative":
                        this._setUseSimulatedScrollbar();
                        this._invalidate();
                        break;
                    case "inertiaEnabled":
                    case "scrollByContent":
                    case "scrollByThumb":
                    case "bounceEnabled":
                    case "useKeyboard":
                    case "showScrollbar":
                    case "useSimulatedScrollbar":
                    case "pushBackValue":
                        this._invalidate();
                        break;
                    case "disabled":
                        this._renderDisabledState();
                        this._strategy && this._strategy.disabledChanged();
                        break;
                    case "updateManually":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _resetInactiveDirection: function() {
                var inactiveProp = this._getInactiveProp();
                if (!inactiveProp || !windowUtils.hasWindow()) {
                    return
                }
                var scrollOffset = this.scrollOffset();
                scrollOffset[inactiveProp] = 0;
                this.scrollTo(scrollOffset)
            },
            _getInactiveProp: function() {
                var direction = this.option("direction");
                if (direction === VERTICAL) {
                    return "left"
                }
                if (direction === HORIZONTAL) {
                    return "top"
                }
            },
            _location: function() {
                return this._strategy.location()
            },
            _normalizeLocation: function(location) {
                if (typeUtils.isPlainObject(location)) {
                    var left = commonUtils.ensureDefined(location.left, location.x);
                    var top = commonUtils.ensureDefined(location.top, location.y);
                    return {
                        left: typeUtils.isDefined(left) ? -left : void 0,
                        top: typeUtils.isDefined(top) ? -top : void 0
                    }
                } else {
                    var direction = this.option("direction");
                    return {
                        left: direction !== VERTICAL ? -location : void 0,
                        top: direction !== HORIZONTAL ? -location : void 0
                    }
                }
            },
            _isLocked: function() {
                return this._locked
            },
            _lock: function() {
                this._locked = true
            },
            _unlock: function() {
                if (!this.option("disabled")) {
                    this._locked = false
                }
            },
            _isDirection: function(direction) {
                var current = this.option("direction");
                if (direction === VERTICAL) {
                    return current !== HORIZONTAL
                }
                if (direction === HORIZONTAL) {
                    return current !== VERTICAL
                }
                return current === direction
            },
            _updateAllowedDirection: function() {
                var allowedDirections = this._strategy._allowedDirections();
                if (this._isDirection(BOTH) && allowedDirections.vertical && allowedDirections.horizontal) {
                    this._allowedDirectionValue = BOTH
                } else {
                    if (this._isDirection(HORIZONTAL) && allowedDirections.horizontal) {
                        this._allowedDirectionValue = HORIZONTAL
                    } else {
                        if (this._isDirection(VERTICAL) && allowedDirections.vertical) {
                            this._allowedDirectionValue = VERTICAL
                        } else {
                            this._allowedDirectionValue = null
                        }
                    }
                }
            },
            _allowedDirection: function() {
                return this._allowedDirectionValue
            },
            _container: function() {
                return this._$container
            },
            $content: function() {
                return this._$content
            },
            content: function() {
                return getPublicElement(this._$content)
            },
            scrollOffset: function() {
                var location = this._location();
                return {
                    top: -location.top,
                    left: -location.left
                }
            },
            scrollTop: function() {
                return this.scrollOffset().top
            },
            scrollLeft: function() {
                return this.scrollOffset().left
            },
            clientHeight: function() {
                return this._$container.height()
            },
            scrollHeight: function() {
                return this.$content().outerHeight() - 2 * this._strategy.verticalOffset()
            },
            clientWidth: function() {
                return this._$container.width()
            },
            scrollWidth: function() {
                return this.$content().outerWidth()
            },
            update: function() {
                if (!this._strategy) {
                    return
                }
                return when(this._strategy.update()).done(function() {
                    this._updateAllowedDirection()
                }.bind(this))
            },
            scrollBy: function(distance) {
                distance = this._normalizeLocation(distance);
                if (!distance.top && !distance.left) {
                    return
                }
                this._updateIfNeed();
                this._strategy.scrollBy(distance)
            },
            scrollTo: function(targetLocation) {
                targetLocation = this._normalizeLocation(targetLocation);
                this._updateIfNeed();
                var location = this._location();
                var distance = this._normalizeLocation({
                    left: location.left - commonUtils.ensureDefined(targetLocation.left, location.left),
                    top: location.top - commonUtils.ensureDefined(targetLocation.top, location.top)
                });
                if (!distance.top && !distance.left) {
                    return
                }
                this._strategy.scrollBy(distance)
            },
            scrollToElement: function(element, offset) {
                offset = offset || {};
                var $element = $(element);
                var elementInsideContent = this.$content().find(element).length;
                var elementIsInsideContent = $element.parents("." + SCROLLABLE_CLASS).length - $element.parents("." + SCROLLABLE_CONTENT_CLASS).length === 0;
                if (!elementInsideContent || !elementIsInsideContent) {
                    return
                }
                var scrollPosition = {
                    top: 0,
                    left: 0
                };
                var direction = this.option("direction");
                if (direction !== VERTICAL) {
                    scrollPosition.left = this._scrollToElementPosition($element, HORIZONTAL, offset)
                }
                if (direction !== HORIZONTAL) {
                    scrollPosition.top = this._scrollToElementPosition($element, VERTICAL, offset)
                }
                this.scrollTo(scrollPosition)
            },
            _scrollToElementPosition: function($element, direction, offset) {
                var isVertical = direction === VERTICAL;
                var startOffset = (isVertical ? offset.top : offset.left) || 0;
                var endOffset = (isVertical ? offset.bottom : offset.right) || 0;
                var pushBackOffset = isVertical ? this._strategy.verticalOffset() : 0;
                var elementPositionRelativeToContent = this._elementPositionRelativeToContent($element, isVertical ? "top" : "left");
                var elementPosition = elementPositionRelativeToContent - pushBackOffset;
                var elementSize = $element[isVertical ? "outerHeight" : "outerWidth"]();
                var scrollLocation = isVertical ? this.scrollTop() : this.scrollLeft();
                var clientSize = isVertical ? this.clientHeight() : this.clientWidth();
                var startDistance = scrollLocation - elementPosition + startOffset;
                var endDistance = scrollLocation - elementPosition - elementSize + clientSize - endOffset;
                if (startDistance <= 0 && endDistance >= 0) {
                    return scrollLocation
                }
                return scrollLocation - (Math.abs(startDistance) > Math.abs(endDistance) ? endDistance : startDistance)
            },
            _elementPositionRelativeToContent: function($element, prop) {
                var result = 0;
                while (this._hasScrollContent($element)) {
                    result += $element.position()[prop];
                    $element = $element.offsetParent()
                }
                return result
            },
            _hasScrollContent: function($element) {
                var $content = this.$content();
                return $element.closest($content).length && !$element.is($content)
            },
            _updateIfNeed: function() {
                if (!this.option("updateManually")) {
                    this.update()
                }
            }
        });
        registerComponent(SCROLLABLE, Scrollable);
        module.exports = Scrollable;
        module.exports.deviceDependentOptions = deviceDependentOptions
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/public_component.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../../core/element_data */ 38),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            WeakMap = __webpack_require__( /*! ../polyfills/weak_map */ 176),
            isDefined = __webpack_require__( /*! ./type */ 1).isDefined,
            removeEvent = __webpack_require__( /*! ../remove_event */ 134);
        var COMPONENT_NAMES_DATA_KEY = "dxComponents",
            ANONYMOUS_COMPONENT_DATA_KEY = "dxPrivateComponent";
        var componentNames = new WeakMap,
            nextAnonymousComponent = 0;
        var getName = exports.name = function(componentClass, newName) {
            if (isDefined(newName)) {
                componentNames.set(componentClass, newName);
                return
            }
            if (!componentNames.has(componentClass)) {
                var generatedName = ANONYMOUS_COMPONENT_DATA_KEY + nextAnonymousComponent++;
                componentNames.set(componentClass, generatedName);
                return generatedName
            }
            return componentNames.get(componentClass)
        };
        exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
            var data = dataUtils.data($element.get(0)),
                name = getName(componentInstance.constructor);
            data[name] = componentInstance;
            if (disposeFn) {
                eventsEngine.one($element, removeEvent, function() {
                    disposeFn.call(componentInstance)
                })
            }
            if (!data[COMPONENT_NAMES_DATA_KEY]) {
                data[COMPONENT_NAMES_DATA_KEY] = []
            }
            data[COMPONENT_NAMES_DATA_KEY].push(name)
        };
        exports.getInstanceByElement = function($element, componentClass) {
            var name = getName(componentClass);
            return dataUtils.data($element.get(0), name)
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/position.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 29);
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = isRtlEnabled || config().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        exports.getDefaultAlignment = getDefaultAlignment
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/error.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend,
            consoleUtils = __webpack_require__( /*! ./console */ 73),
            stringUtils = __webpack_require__( /*! ./string */ 39),
            version = __webpack_require__( /*! ../version */ 131);
        var ERROR_URL = "http://js.devexpress.com/error/" + version.split(".").slice(0, 2).join("_") + "/";
        module.exports = function(baseErrors, errors) {
            var exports = {
                ERROR_MESSAGES: extend(errors, baseErrors),
                Error: function() {
                    return makeError([].slice.call(arguments))
                },
                log: function(id) {
                    var method = "log";
                    if (/^E\d+$/.test(id)) {
                        method = "error"
                    } else {
                        if (/^W\d+$/.test(id)) {
                            method = "warn"
                        }
                    }
                    consoleUtils.logger[method]("log" === method ? id : combineMessage([].slice.call(arguments)))
                }
            };
            var combineMessage = function(args) {
                var id = args[0];
                args = args.slice(1);
                return formatMessage(id, formatDetails(id, args))
            };
            var formatDetails = function(id, args) {
                args = [exports.ERROR_MESSAGES[id]].concat(args);
                return stringUtils.format.apply(this, args).replace(/\.*\s*?$/, "")
            };
            var formatMessage = function(id, details) {
                return stringUtils.format.apply(this, ["{0} - {1}. See:\n{2}", id, details, ERROR_URL + id])
            };
            var makeError = function(args) {
                var id, details, message;
                id = args[0];
                args = args.slice(1);
                details = formatDetails(id, args);
                message = formatMessage(id, details);
                return extend(new Error(message), {
                    __id: id,
                    __details: details
                })
            };
            return exports
        }
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/icon.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/data:.*base64|\.|\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            return "fontIcon"
        };
        var getImageContainer = function(source) {
            var imageType = getImageSourceType(source),
                ICON_CLASS = "dx-icon";
            switch (imageType) {
                case "image":
                    return $("<img>").attr("src", source).addClass(ICON_CLASS);
                case "fontIcon":
                    return $("<i>").addClass(ICON_CLASS + " " + source);
                case "dxIcon":
                    return $("<i>").addClass(ICON_CLASS + " " + ICON_CLASS + "-" + source);
                default:
                    return null
            }
        };
        exports.getImageSourceType = getImageSourceType;
        exports.getImageContainer = getImageContainer
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/animation/frame.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            window = windowUtils.hasWindow() ? windowUtils.getWindow() : {},
            callOnce = __webpack_require__( /*! ../core/utils/call_once */ 68);
        var FRAME_ANIMATION_STEP_TIME = 1e3 / 60,
            request = function(callback) {
                return setTimeout(callback, FRAME_ANIMATION_STEP_TIME)
            },
            cancel = function(requestID) {
                clearTimeout(requestID)
            };
        var setAnimationFrameMethods = callOnce(function() {
            var nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame,
                nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
            if (nativeRequest && nativeCancel) {
                request = nativeRequest;
                cancel = nativeCancel
            }
            if (nativeRequest && !nativeCancel) {
                var canceledRequests = {};
                request = function(callback) {
                    var requestId = nativeRequest.call(window, function() {
                        try {
                            if (requestId in canceledRequests) {
                                return
                            }
                            callback.apply(this, arguments)
                        } finally {
                            delete canceledRequests[requestId]
                        }
                    });
                    return requestId
                };
                cancel = function(requestId) {
                    canceledRequests[requestId] = true
                }
            }
        });
        exports.requestAnimationFrame = function() {
            setAnimationFrameMethods();
            return request.apply(window, arguments)
        };
        exports.cancelAnimationFrame = function() {
            setAnimationFrameMethods();
            cancel.apply(window, arguments)
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data_helper.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DataSource = __webpack_require__( /*! ./data/data_source/data_source */ 50).DataSource,
            extend = __webpack_require__( /*! ./core/utils/extend */ 0).extend,
            normalizeDataSourceOptions = __webpack_require__( /*! ./data/data_source/data_source */ 50).normalizeDataSourceOptions;
        var DATA_SOURCE_OPTIONS_METHOD = "_dataSourceOptions",
            DATA_SOURCE_CHANGED_METHOD = "_dataSourceChangedHandler",
            DATA_SOURCE_LOAD_ERROR_METHOD = "_dataSourceLoadErrorHandler",
            DATA_SOURCE_LOADING_CHANGED_METHOD = "_dataSourceLoadingChangedHandler",
            DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD = "_dataSourceFromUrlLoadMode",
            SPECIFIC_DATA_SOURCE_OPTION = "_getSpecificDataSourceOption";
        var DataHelperMixin = {
            postCtor: function() {
                this.on("disposing", function() {
                    this._disposeDataSource()
                }.bind(this))
            },
            _refreshDataSource: function() {
                this._initDataSource();
                this._loadDataSource()
            },
            _initDataSource: function() {
                var widgetDataSourceOptions, dataSourceType, dataSourceOptions = SPECIFIC_DATA_SOURCE_OPTION in this ? this[SPECIFIC_DATA_SOURCE_OPTION]() : this.option("dataSource");
                this._disposeDataSource();
                if (dataSourceOptions) {
                    if (dataSourceOptions instanceof DataSource) {
                        this._isSharedDataSource = true;
                        this._dataSource = dataSourceOptions
                    } else {
                        widgetDataSourceOptions = DATA_SOURCE_OPTIONS_METHOD in this ? this[DATA_SOURCE_OPTIONS_METHOD]() : {};
                        dataSourceType = this._dataSourceType ? this._dataSourceType() : DataSource;
                        dataSourceOptions = normalizeDataSourceOptions(dataSourceOptions, {
                            fromUrlLoadMode: DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD in this && this[DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD]()
                        });
                        this._dataSource = new dataSourceType(extend(true, {}, widgetDataSourceOptions, dataSourceOptions))
                    }
                    this._addDataSourceHandlers()
                }
            },
            _addDataSourceHandlers: function() {
                if (DATA_SOURCE_CHANGED_METHOD in this) {
                    this._addDataSourceChangeHandler()
                }
                if (DATA_SOURCE_LOAD_ERROR_METHOD in this) {
                    this._addDataSourceLoadErrorHandler()
                }
                if (DATA_SOURCE_LOADING_CHANGED_METHOD in this) {
                    this._addDataSourceLoadingChangedHandler()
                }
                this._addReadyWatcher()
            },
            _addReadyWatcher: function() {
                this._dataSource.on("loadingChanged", function(isLoading) {
                    this._ready && this._ready(!isLoading)
                }.bind(this))
            },
            _addDataSourceChangeHandler: function() {
                var dataSource = this._dataSource;
                this._proxiedDataSourceChangedHandler = function() {
                    this[DATA_SOURCE_CHANGED_METHOD](dataSource.items())
                }.bind(this);
                dataSource.on("changed", this._proxiedDataSourceChangedHandler)
            },
            _addDataSourceLoadErrorHandler: function() {
                this._proxiedDataSourceLoadErrorHandler = this[DATA_SOURCE_LOAD_ERROR_METHOD].bind(this);
                this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
            },
            _addDataSourceLoadingChangedHandler: function() {
                this._proxiedDataSourceLoadingChangedHandler = this[DATA_SOURCE_LOADING_CHANGED_METHOD].bind(this);
                this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
            },
            _loadDataSource: function() {
                if (this._dataSource) {
                    var dataSource = this._dataSource;
                    if (dataSource.isLoaded()) {
                        this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                    } else {
                        dataSource.load()
                    }
                }
            },
            _loadSingle: function(key, value) {
                key = "this" === key ? this._dataSource.key() || "this" : key;
                return this._dataSource.loadSingle(key, value)
            },
            _isLastPage: function() {
                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
            },
            _isDataSourceLoading: function() {
                return this._dataSource && this._dataSource.isLoading()
            },
            _disposeDataSource: function() {
                if (this._dataSource) {
                    if (this._isSharedDataSource) {
                        delete this._isSharedDataSource;
                        this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                        this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                        this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    } else {
                        this._dataSource.dispose()
                    }
                    delete this._dataSource;
                    delete this._proxiedDataSourceChangedHandler;
                    delete this._proxiedDataSourceLoadErrorHandler;
                    delete this._proxiedDataSourceLoadingChangedHandler
                }
            },
            getDataSource: function() {
                return this._dataSource || null
            }
        };
        module.exports = DataHelperMixin
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled/events/gesture/swipeable.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var swipeEvents = __webpack_require__( /*! ../swipe */ 118),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 57),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            publicComponentUtils = __webpack_require__( /*! ../../core/utils/public_component */ 102);
        var DX_SWIPEABLE = "dxSwipeable",
            SWIPEABLE_CLASS = "dx-swipeable",
            ACTION_TO_EVENT_MAP = {
                onStart: swipeEvents.start,
                onUpdated: swipeEvents.swipe,
                onEnd: swipeEvents.end,
                onCancel: "dxswipecancel"
            };
        var Swipeable = DOMComponent.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    elastic: true,
                    immediate: false,
                    direction: "horizontal",
                    itemSizeFunc: null,
                    onStart: null,
                    onUpdated: null,
                    onEnd: null,
                    onCancel: null
                })
            },
            _render: function() {
                this.callBase();
                this.$element().addClass(SWIPEABLE_CLASS);
                this._attachEventHandlers()
            },
            _attachEventHandlers: function() {
                this._detachEventHandlers();
                if (this.option("disabled")) {
                    return
                }
                var NAME = this.NAME;
                this._createEventData();
                each(ACTION_TO_EVENT_MAP, function(actionName, eventName) {
                    var action = this._createActionByOption(actionName, {
                        context: this
                    });
                    eventName = eventUtils.addNamespace(eventName, NAME);
                    eventsEngine.on(this.$element(), eventName, this._eventData, function(e) {
                        return action({
                            event: e
                        })
                    })
                }.bind(this))
            },
            _createEventData: function() {
                this._eventData = {
                    elastic: this.option("elastic"),
                    itemSizeFunc: this.option("itemSizeFunc"),
                    direction: this.option("direction"),
                    immediate: this.option("immediate")
                }
            },
            _detachEventHandlers: function() {
                eventsEngine.off(this.$element(), "." + DX_SWIPEABLE)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                    case "onStart":
                    case "onUpdated":
                    case "onEnd":
                    case "onCancel":
                    case "elastic":
                    case "immediate":
                    case "itemSizeFunc":
                    case "direction":
                        this._detachEventHandlers();
                        this._attachEventHandlers();
                        break;
                    case "rtlEnabled":
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        publicComponentUtils.name(Swipeable, DX_SWIPEABLE);
        module.exports = Swipeable
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/events/core/wheel.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            callOnce = __webpack_require__( /*! ../../core/utils/call_once */ 68),
            registerEvent = __webpack_require__( /*! ./event_registrator */ 63),
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var EVENT_NAME = "dxmousewheel",
            EVENT_NAMESPACE = "dxWheel";
        var getWheelEventName = callOnce(function() {
            return domAdapter.hasDocumentProperty("onwheel") ? "wheel" : "mousewheel"
        });
        var wheel = {
            setup: function(element) {
                var $element = $(element);
                eventsEngine.on($element, eventUtils.addNamespace(getWheelEventName(), EVENT_NAMESPACE), wheel._wheelHandler.bind(wheel))
            },
            teardown: function(element) {
                eventsEngine.off(element, "." + EVENT_NAMESPACE)
            },
            _wheelHandler: function(e) {
                var delta = this._getWheelDelta(e.originalEvent);
                eventUtils.fireEvent({
                    type: EVENT_NAME,
                    originalEvent: e,
                    delta: delta,
                    pointerType: "mouse"
                });
                e.stopPropagation()
            },
            _getWheelDelta: function(event) {
                return event.wheelDelta ? event.wheelDelta : 30 * -event.deltaY
            }
        };
        registerEvent(EVENT_NAME, wheel);
        exports.name = EVENT_NAME
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/ui/number_box.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./number_box/number_box */ 480)
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator_callbacks.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var MemorizedCallbacks = __webpack_require__( /*! ../../core/memorized_callbacks */ 177);
        module.exports = new MemorizedCallbacks
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            Class = __webpack_require__( /*! ../../core/class */ 10),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 20),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var Emitter = Class.inherit({
            ctor: function(element) {
                this._$element = $(element);
                this._cancelCallback = Callbacks();
                this._acceptCallback = Callbacks()
            },
            getElement: function() {
                return this._$element
            },
            validate: function(e) {
                return "dxmousewheel" !== e.type
            },
            validatePointers: function(e) {
                return 1 === eventUtils.hasTouches(e)
            },
            allowInterruptionByMouseWheel: function() {
                return true
            },
            configure: function(data) {
                extend(this, data)
            },
            addCancelCallback: function(callback) {
                this._cancelCallback.add(callback)
            },
            removeCancelCallback: function() {
                this._cancelCallback.empty()
            },
            _cancel: function(e) {
                this._cancelCallback.fire(this, e)
            },
            addAcceptCallback: function(callback) {
                this._acceptCallback.add(callback)
            },
            removeAcceptCallback: function() {
                this._acceptCallback.empty()
            },
            _accept: function(e) {
                this._acceptCallback.fire(this, e)
            },
            _requestAccept: function(e) {
                this._acceptRequestEvent = e
            },
            _forgetAccept: function() {
                this._accept(this._acceptRequestEvent);
                this._acceptRequestEvent = null
            },
            start: noop,
            move: noop,
            end: noop,
            cancel: noop,
            reset: function() {
                if (this._acceptRequestEvent) {
                    this._accept(this._acceptRequestEvent)
                }
            },
            _fireEvent: function(eventName, e, params) {
                var eventData = extend({
                    type: eventName,
                    originalEvent: e,
                    target: this._getEmitterTarget(e),
                    delegateTarget: this.getElement().get(0)
                }, params);
                e = eventUtils.fireEvent(eventData);
                if (e.cancel) {
                    this._cancel(e)
                }
                return e
            },
            _getEmitterTarget: function(e) {
                return (this.delegateSelector ? $(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
            },
            dispose: noop
        });
        module.exports = Emitter
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/integration/knockout.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var ko = __webpack_require__( /*! knockout */ 58);
        if (ko) {
            var errors = __webpack_require__( /*! ../core/errors */ 18),
                compareVersion = __webpack_require__( /*! ../core/utils/version */ 60).compare;
            if (compareVersion(ko.version, [2, 3]) < 0) {
                throw errors.Error("E0013")
            }
            __webpack_require__( /*! ./knockout/component_registrator */ 324);
            __webpack_require__( /*! ./knockout/event_registrator */ 325);
            __webpack_require__( /*! ./knockout/components */ 326);
            __webpack_require__( /*! ./knockout/validation */ 327);
            __webpack_require__( /*! ./knockout/variable_wrapper_utils */ 328);
            __webpack_require__( /*! ./knockout/clean_node */ 329);
            __webpack_require__( /*! ./knockout/clean_node_old */ 330)
        }
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/empty_template.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            TemplateBase = __webpack_require__( /*! ./ui.template_base */ 77);
        var EmptyTemplate = TemplateBase.inherit({
            _renderCore: function() {
                return $()
            }
        });
        module.exports = EmptyTemplate
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/framework/utils.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var ko = __webpack_require__( /*! knockout */ 58),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            KoTemplate = __webpack_require__( /*! ../integration/knockout/template */ 238);
        var mergeWithReplace = function(targetArray, arrayToMerge, needReplaceFn) {
            var result = [];
            for (var i = 0, length = targetArray.length; i < length; i++) {
                if (!needReplaceFn(targetArray[i], arrayToMerge)) {
                    result.push(targetArray[i])
                }
            }
            result.push.apply(result, arrayToMerge);
            return result
        };
        var prepareCommandToReplace = function(targetCommand, commandsToMerge) {
            var needToReplace = false;
            each(commandsToMerge, function(_, commandToMerge) {
                var idEqual = targetCommand.option("id") === commandToMerge.option("id") && commandToMerge.option("id"),
                    behaviorEqual = targetCommand.option("behavior") === commandToMerge.option("behavior") && targetCommand.option("behavior");
                needToReplace = idEqual || behaviorEqual;
                if (behaviorEqual && null === commandToMerge.option("onExecute")) {
                    commandToMerge.option("onExecute", targetCommand.option("onExecute"))
                }
                if (needToReplace) {
                    targetCommand.$element().remove();
                    return false
                }
            });
            return needToReplace
        };
        var mergeCommands = function(targetCommands, commandsToMerge) {
            return mergeWithReplace(targetCommands, commandsToMerge, prepareCommandToReplace)
        };
        var resolvePropertyValue = function(command, containerOptions, propertyName, defaultValue) {
            var containerOption = containerOptions ? containerOptions[propertyName] : void 0,
                defaultOption = void 0 === containerOption ? defaultValue : containerOption,
                commandOption = command.option(propertyName);
            return void 0 === commandOption || commandOption === defaultValue ? defaultOption : commandOption
        };
        var resolveTextValue = function(command, containerOptions) {
            var showText = resolvePropertyValue(command, containerOptions, "showText"),
                hasIcon = !!command.option("icon"),
                titleValue = resolvePropertyValue(command, containerOptions, "title", "");
            return showText || !hasIcon ? titleValue : ""
        };
        var resolveIconValue = function(command, containerOptions) {
            var showIcon = resolvePropertyValue(command, containerOptions, "showIcon"),
                hasText = !!command.option("title"),
                iconValue = resolvePropertyValue(command, containerOptions, "icon", "");
            return showIcon || !hasText ? iconValue : ""
        };
        exports.utils = {
            mergeCommands: mergeCommands,
            commandToContainer: {
                resolveIconValue: resolveIconValue,
                resolveTextValue: resolveTextValue,
                resolvePropertyValue: resolvePropertyValue
            }
        };
        exports.templateProvider = {
            createTemplate: function(element) {
                return new KoTemplate(element)
            },
            applyTemplate: function(element, model) {
                ko.applyBindings(model, element)
            }
        }
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/framework/navigation_manager.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        __webpack_require__( /*! ../integration/jquery */ 46);
        var $ = __webpack_require__( /*! jquery */ 28),
            Class = __webpack_require__( /*! ../core/class */ 10),
            Callbacks = __webpack_require__( /*! ../core/utils/callbacks */ 20),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            isPlainObject = __webpack_require__( /*! ../core/utils/type */ 1).isPlainObject,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            navigationDevices = __webpack_require__( /*! ./navigation_devices */ 146),
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 53),
            errors = __webpack_require__( /*! ./errors */ 64),
            hardwareBackButton = __webpack_require__( /*! ../mobile/process_hardware_back_button */ 233).processCallback,
            hideTopOverlay = __webpack_require__( /*! ../mobile/hide_top_overlay */ 135),
            when = __webpack_require__( /*! ../core/utils/deferred */ 7).when;
        var NAVIGATION_TARGETS = {
                current: "current",
                blank: "blank",
                back: "back"
            },
            STORAGE_HISTORY_KEY = "__history";
        var HistoryBasedNavigationManager = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this._currentItem = void 0;
                this._previousItem = void 0;
                this._createNavigationDevice(options)
            },
            _createNavigationDevice: function(options) {
                this._navigationDevice = options.navigationDevice || new navigationDevices.HistoryBasedNavigationDevice;
                this._navigationDevice.uriChanged.add(this._uriChangedHandler.bind(this))
            },
            _uriChangedHandler: function(uri) {
                while (hideTopOverlay()) {}
                this.navigate(uri)
            },
            _syncUriWithCurrentNavigationItem: function() {
                var currentUri = this._currentItem && this._currentItem.uri;
                this._navigationDevice.setUri(currentUri, true)
            },
            _cancelNavigation: function(args) {
                this._syncUriWithCurrentNavigationItem();
                this.fireEvent("navigationCanceled", [args])
            },
            _getDefaultOptions: function() {
                return {
                    direction: "none",
                    target: NAVIGATION_TARGETS.blank
                }
            },
            _updateHistory: function(uri, options) {
                this._previousItem = this._currentItem;
                this._currentItem = {
                    uri: uri,
                    key: uri
                };
                this._navigationDevice.setUri(uri, options.target === NAVIGATION_TARGETS.current)
            },
            _setCurrentItem: function(item) {
                this._currentItem = item
            },
            navigate: function(uri, options) {
                options = options || {};
                var args, that = this,
                    isFirstNavigate = !that._currentItem,
                    currentItem = that._currentItem || {},
                    targetItem = options.item || {},
                    currentUri = currentItem.uri,
                    currentKey = currentItem.key,
                    targetKey = targetItem.key;
                if (void 0 === uri) {
                    uri = that._navigationDevice.getUri()
                }
                if (/^_back$/.test(uri)) {
                    that.back();
                    return
                }
                options = extend(that._getDefaultOptions(), options || {});
                if (isFirstNavigate) {
                    options.target = NAVIGATION_TARGETS.current
                }
                args = {
                    currentUri: currentUri,
                    uri: uri,
                    cancel: false,
                    navigateWhen: [],
                    options: options
                };
                that.fireEvent("navigating", [args]);
                uri = args.uri;
                if (args.cancel || currentUri === uri && (void 0 === targetKey || targetKey === currentKey) && !that._forceNavigate) {
                    that._cancelNavigation(args)
                } else {
                    that._forceNavigate = false;
                    when.apply($, args.navigateWhen).done(function() {
                        commonUtils.executeAsync(function() {
                            that._updateHistory(uri, options);
                            that.fireEvent("navigated", [{
                                uri: uri,
                                previousUri: currentUri,
                                options: options,
                                item: that._currentItem
                            }])
                        })
                    })
                }
            },
            back: function() {
                return this._navigationDevice.back()
            },
            previousItem: function() {
                return this._previousItem
            },
            currentItem: function(item) {
                if (arguments.length > 0) {
                    if (!item) {
                        throw errors.Error("E3023")
                    }
                    this._setCurrentItem(item)
                } else {
                    return this._currentItem
                }
            },
            rootUri: function() {
                return this._currentItem && this._currentItem.uri
            },
            canBack: function() {
                return true
            },
            saveState: commonUtils.noop,
            restoreState: commonUtils.noop,
            removeState: commonUtils.noop
        }).include(EventsMixin);
        var StackBasedNavigationManager = HistoryBasedNavigationManager.inherit({
            ctor: function(options) {
                options = options || {};
                this.callBase(options);
                this._createNavigationStacks(options);
                hardwareBackButton.add(this._deviceBackInitiated.bind(this));
                this._stateStorageKey = options.stateStorageKey || STORAGE_HISTORY_KEY
            },
            init: function() {
                return this._navigationDevice.init()
            },
            _createNavigationDevice: function(options) {
                if (!options.navigationDevice) {
                    options.navigationDevice = new navigationDevices.StackBasedNavigationDevice
                }
                this.callBase(options);
                this._navigationDevice.backInitiated.add(this._deviceBackInitiated.bind(this))
            },
            _uriChangedHandler: function(uri) {
                this.navigate(uri)
            },
            _createNavigationStacks: function(options) {
                this.navigationStacks = {};
                this._keepPositionInStack = options.keepPositionInStack;
                this.currentStack = new NavigationStack
            },
            _deviceBackInitiated: function() {
                if (!hideTopOverlay()) {
                    this.back({
                        isHardwareButton: true
                    })
                } else {
                    this._syncUriWithCurrentNavigationItem()
                }
            },
            _getDefaultOptions: function() {
                return {
                    target: NAVIGATION_TARGETS.blank
                }
            },
            _createNavigationStack: function() {
                var result = new NavigationStack;
                result.itemsRemoved.add(this._removeItems.bind(this));
                return result
            },
            _setCurrentItem: function(item) {
                this._setCurrentStack(item.stack);
                this.currentStack.currentItem(item);
                this.callBase(item);
                this._syncUriWithCurrentNavigationItem()
            },
            _setCurrentStack: function(stackOrStackKey) {
                var stack, stackKey;
                if ("string" === typeof stackOrStackKey) {
                    stackKey = stackOrStackKey;
                    if (!(stackKey in this.navigationStacks)) {
                        this.navigationStacks[stackKey] = this._createNavigationStack()
                    }
                    stack = this.navigationStacks[stackKey]
                } else {
                    stack = stackOrStackKey;
                    stackKey = iteratorUtils.map(this.navigationStacks, function(stack, key) {
                        if (stack === stackOrStackKey) {
                            return key
                        }
                        return null
                    })[0]
                }
                this.currentStack = stack;
                this.currentStackKey = stackKey
            },
            _getViewTargetStackKey: function(uri, isRoot) {
                var result;
                if (isRoot) {
                    if (void 0 !== this.navigationStacks[uri]) {
                        result = uri
                    } else {
                        for (var stackKey in this.navigationStacks) {
                            if (this.navigationStacks[stackKey].items[0].uri === uri) {
                                result = stackKey;
                                break
                            }
                        }
                        result = result || uri
                    }
                } else {
                    result = this.currentStackKey || uri
                }
                return result
            },
            _updateHistory: function(uri, options) {
                var isRoot = options.root,
                    forceIsRoot = isRoot,
                    forceToRoot = false,
                    previousStack = this.currentStack,
                    keepPositionInStack = void 0 !== options.keepPositionInStack ? options.keepPositionInStack : this._keepPositionInStack;
                options.stack = options.stack || this._getViewTargetStackKey(uri, isRoot);
                this._setCurrentStack(options.stack);
                if (isRoot || !this.currentStack.items.length) {
                    forceToRoot = this.currentStack === previousStack;
                    forceIsRoot = true
                }
                if (isRoot && this.currentStack.items.length) {
                    if (!keepPositionInStack || forceToRoot) {
                        this.currentStack.currentIndex = 0;
                        if (this.currentItem().uri !== uri) {
                            this.currentStack.navigate(uri, true)
                        }
                    }
                    options.direction = options.direction || "none"
                } else {
                    var prevIndex = this.currentStack.currentIndex,
                        prevItem = this.currentItem() || {};
                    switch (options.target) {
                        case NAVIGATION_TARGETS.blank:
                            this.currentStack.navigate(uri);
                            break;
                        case NAVIGATION_TARGETS.current:
                            this.currentStack.navigate(uri, true);
                            break;
                        case NAVIGATION_TARGETS.back:
                            if (this.currentStack.currentIndex > 0) {
                                this.currentStack.back(uri)
                            } else {
                                this.currentStack.navigate(uri, true)
                            }
                            break;
                        default:
                            throw errors.Error("E3006", options.target)
                    }
                    if (void 0 === options.direction) {
                        var indexDelta = this.currentStack.currentIndex - prevIndex;
                        if (indexDelta < 0) {
                            options.direction = this.currentStack.currentItem().backDirection || "backward"
                        } else {
                            if (indexDelta > 0 && this.currentStack.currentIndex > 0) {
                                options.direction = "forward"
                            } else {
                                options.direction = "none"
                            }
                        }
                    }
                    prevItem.backDirection = "forward" === options.direction ? "backward" : "none"
                }
                options.root = forceIsRoot;
                this._currentItem = this.currentStack.currentItem();
                this._syncUriWithCurrentNavigationItem()
            },
            _removeItems: function(items) {
                var that = this;
                iteratorUtils.each(items, function(index, item) {
                    that.fireEvent("itemRemoved", [item])
                })
            },
            back: function(options) {
                options = options || {};
                var navigatingBackArgs = extend({
                    cancel: false
                }, options);
                this.fireEvent("navigatingBack", [navigatingBackArgs]);
                if (navigatingBackArgs.cancel) {
                    this._syncUriWithCurrentNavigationItem();
                    return
                }
                var item = this.previousItem(navigatingBackArgs.stack);
                if (item) {
                    this.navigate(item.uri, {
                        stack: navigatingBackArgs.stack,
                        target: NAVIGATION_TARGETS.back,
                        item: item
                    })
                } else {
                    this.callBase()
                }
            },
            rootUri: function() {
                return this.currentStack.items.length ? this.currentStack.items[0].uri : this.callBase()
            },
            canBack: function(stackKey) {
                var stack = stackKey ? this.navigationStacks[stackKey] : this.currentStack;
                return stack ? stack.canBack() : false
            },
            saveState: function(storage) {
                if (this.currentStack.items.length) {
                    var state = {
                        navigationStacks: {},
                        currentStackKey: this.currentStackKey
                    };
                    iteratorUtils.each(this.navigationStacks, function(stackKey, stack) {
                        var stackState = {};
                        state.navigationStacks[stackKey] = stackState;
                        stackState.currentIndex = stack.currentIndex;
                        stackState.items = iteratorUtils.map(stack.items, function(item) {
                            return {
                                key: item.key,
                                uri: item.uri
                            }
                        })
                    });
                    var json = JSON.stringify(state);
                    storage.setItem(this._stateStorageKey, json)
                } else {
                    this.removeState(storage)
                }
            },
            restoreState: function(storage) {
                if (this.disableRestoreState) {
                    return
                }
                var json = storage.getItem(this._stateStorageKey);
                if (json) {
                    try {
                        var that = this,
                            state = JSON.parse(json);
                        iteratorUtils.each(state.navigationStacks, function(stackKey, stackState) {
                            var stack = that._createNavigationStack();
                            that.navigationStacks[stackKey] = stack;
                            stack.currentIndex = stackState.currentIndex;
                            stack.items = iteratorUtils.map(stackState.items, function(item) {
                                item.stack = stack;
                                return item
                            })
                        });
                        this.currentStackKey = state.currentStackKey;
                        this.currentStack = this.navigationStacks[this.currentStackKey];
                        this._currentItem = this.currentStack.currentItem();
                        this._navigationDevice.setUri(this.currentItem().uri);
                        this._forceNavigate = true
                    } catch (e) {
                        this.removeState(storage);
                        throw errors.Error("E3007")
                    }
                }
            },
            removeState: function(storage) {
                storage.removeItem(this._stateStorageKey)
            },
            currentIndex: function() {
                return this.currentStack.currentIndex
            },
            previousItem: function(stackKey) {
                var stack = this.navigationStacks[stackKey] || this.currentStack;
                return stack.previousItem()
            },
            getItemByIndex: function(index) {
                return this.currentStack.items[index]
            },
            clearHistory: function() {
                this._createNavigationStacks({
                    keepPositionInStack: this._keepPositionInStack
                })
            },
            itemByKey: function(itemKey) {
                var result;
                iteratorUtils.each(this.navigationStacks, function(stackKey, stack) {
                    var item = stack.itemByKey(itemKey);
                    if (item) {
                        result = item;
                        return false
                    }
                });
                return result
            },
            currentItem: function(itemOrItemKey) {
                var item;
                if (arguments.length > 0) {
                    if ("string" === typeof itemOrItemKey) {
                        item = this.itemByKey(itemOrItemKey)
                    } else {
                        if (isPlainObject(itemOrItemKey)) {
                            item = itemOrItemKey
                        }
                    }
                    this.callBase(item)
                } else {
                    return this.callBase()
                }
            }
        });
        var NavigationStack = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this.itemsRemoved = Callbacks();
                this.clear()
            },
            currentItem: function(item) {
                if (item) {
                    for (var i = 0; i < this.items.length; i++) {
                        if (item === this.items[i]) {
                            this.currentIndex = i;
                            break
                        }
                    }
                } else {
                    return this.items[this.currentIndex]
                }
            },
            previousItem: function() {
                return this.items.length > 1 ? this.items[this.currentIndex - 1] : void 0
            },
            canBack: function() {
                return this.currentIndex > 0
            },
            clear: function() {
                this._deleteItems(this.items);
                this.items = [];
                this.currentIndex = -1
            },
            back: function(uri) {
                this.currentIndex--;
                if (this.currentIndex < 0) {
                    throw errors.Error("E3008")
                }
                var currentItem = this.currentItem();
                if (currentItem.uri !== uri) {
                    this._updateItem(this.currentIndex, uri)
                }
            },
            forward: function() {
                this.currentIndex++;
                if (this.currentIndex >= this.items.length) {
                    throw errors.Error("E3009")
                }
            },
            navigate: function(uri, replaceCurrent) {
                if (this.currentIndex < this.items.length && this.currentIndex > -1 && this.items[this.currentIndex].uri === uri) {
                    return
                }
                if (replaceCurrent && this.currentIndex > -1) {
                    this.currentIndex--
                }
                if (this.currentIndex + 1 < this.items.length && this.items[this.currentIndex + 1].uri === uri) {
                    this.currentIndex++
                } else {
                    var toDelete = this.items.splice(this.currentIndex + 1, this.items.length - this.currentIndex - 1);
                    this.items.push({
                        stack: this
                    });
                    this.currentIndex++;
                    this._updateItem(this.currentIndex, uri);
                    this._deleteItems(toDelete)
                }
                return this.currentItem()
            },
            itemByKey: function(key) {
                for (var i = 0; i < this.items.length; i++) {
                    var item = this.items[i];
                    if (item.key === key) {
                        return item
                    }
                }
            },
            _updateItem: function(index, uri) {
                var item = this.items[index];
                item.uri = uri;
                item.key = this.items[0].uri + "_" + index + "_" + uri
            },
            _deleteItems: function(items) {
                if (items) {
                    this.itemsRemoved.fire(items)
                }
            }
        });
        HistoryBasedNavigationManager.NAVIGATION_TARGETS = NAVIGATION_TARGETS;
        exports.HistoryBasedNavigationManager = HistoryBasedNavigationManager;
        exports.StackBasedNavigationManager = StackBasedNavigationManager;
        exports.NavigationStack = NavigationStack
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/localization/globalize/core.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Globalize = __webpack_require__( /*! globalize */ 66),
            coreLocalization = __webpack_require__( /*! ../core */ 83);
        if (Globalize && Globalize.load) {
            var likelySubtags = {
                supplemental: {
                    version: {
                        _cldrVersion: "28",
                        _unicodeVersion: "8.0.0",
                        _number: "$Revision: 11965 $"
                    },
                    likelySubtags: {
                        en: "en-Latn-US",
                        de: "de-Latn-DE",
                        ru: "ru-Cyrl-RU",
                        ja: "ja-Jpan-JP"
                    }
                }
            };
            if (!Globalize.locale()) {
                Globalize.load(likelySubtags);
                Globalize.locale("en")
            }
            coreLocalization.inject({
                locale: function(_locale) {
                    if (!_locale) {
                        return Globalize.locale().locale
                    }
                    Globalize.locale(_locale)
                }
            })
        }
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/swipe.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventUtils = __webpack_require__( /*! ./utils */ 9),
            GestureEmitter = __webpack_require__( /*! ./gesture/emitter.gesture */ 151),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 89);
        var SWIPE_START_EVENT = "dxswipestart",
            SWIPE_EVENT = "dxswipe",
            SWIPE_END_EVENT = "dxswipeend";
        var HorizontalStrategy = {
            defaultItemSizeFunc: function() {
                return this.getElement().width()
            },
            getBounds: function() {
                return [this._maxLeftOffset, this._maxRightOffset]
            },
            calcOffsetRatio: function(e) {
                var endEventData = eventUtils.eventData(e);
                return (endEventData.x - (this._savedEventData && this._savedEventData.x || 0)) / this._itemSizeFunc().call(this, e)
            },
            isFastSwipe: function(e) {
                var endEventData = eventUtils.eventData(e);
                return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(endEventData.x - this._tickData.x) >= endEventData.time - this._tickData.time
            }
        };
        var VerticalStrategy = {
            defaultItemSizeFunc: function() {
                return this.getElement().height()
            },
            getBounds: function() {
                return [this._maxTopOffset, this._maxBottomOffset]
            },
            calcOffsetRatio: function(e) {
                var endEventData = eventUtils.eventData(e);
                return (endEventData.y - (this._savedEventData && this._savedEventData.y || 0)) / this._itemSizeFunc().call(this, e)
            },
            isFastSwipe: function(e) {
                var endEventData = eventUtils.eventData(e);
                return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(endEventData.y - this._tickData.y) >= endEventData.time - this._tickData.time
            }
        };
        var STRATEGIES = {
            horizontal: HorizontalStrategy,
            vertical: VerticalStrategy
        };
        var SwipeEmitter = GestureEmitter.inherit({
            TICK_INTERVAL: 300,
            FAST_SWIPE_SPEED_LIMIT: 10,
            ctor: function(element) {
                this.callBase(element);
                this.direction = "horizontal";
                this.elastic = true
            },
            _getStrategy: function() {
                return STRATEGIES[this.direction]
            },
            _defaultItemSizeFunc: function() {
                return this._getStrategy().defaultItemSizeFunc.call(this)
            },
            _itemSizeFunc: function() {
                return this.itemSizeFunc || this._defaultItemSizeFunc
            },
            _init: function(e) {
                this._tickData = eventUtils.eventData(e)
            },
            _start: function(e) {
                this._savedEventData = eventUtils.eventData(e);
                e = this._fireEvent(SWIPE_START_EVENT, e);
                if (!e.cancel) {
                    this._maxLeftOffset = e.maxLeftOffset;
                    this._maxRightOffset = e.maxRightOffset;
                    this._maxTopOffset = e.maxTopOffset;
                    this._maxBottomOffset = e.maxBottomOffset
                }
            },
            _move: function(e) {
                var strategy = this._getStrategy(),
                    moveEventData = eventUtils.eventData(e),
                    offset = strategy.calcOffsetRatio.call(this, e);
                offset = this._fitOffset(offset, this.elastic);
                if (moveEventData.time - this._tickData.time > this.TICK_INTERVAL) {
                    this._tickData = moveEventData
                }
                this._fireEvent(SWIPE_EVENT, e, {
                    offset: offset
                });
                e.preventDefault()
            },
            _end: function(e) {
                var strategy = this._getStrategy(),
                    offsetRatio = strategy.calcOffsetRatio.call(this, e),
                    isFast = strategy.isFastSwipe.call(this, e),
                    startOffset = offsetRatio,
                    targetOffset = this._calcTargetOffset(offsetRatio, isFast);
                startOffset = this._fitOffset(startOffset, this.elastic);
                targetOffset = this._fitOffset(targetOffset, false);
                this._fireEvent(SWIPE_END_EVENT, e, {
                    offset: startOffset,
                    targetOffset: targetOffset
                })
            },
            _fitOffset: function(offset, elastic) {
                var strategy = this._getStrategy(),
                    bounds = strategy.getBounds.call(this);
                if (offset < -bounds[0]) {
                    return elastic ? (-2 * bounds[0] + offset) / 3 : -bounds[0]
                }
                if (offset > bounds[1]) {
                    return elastic ? (2 * bounds[1] + offset) / 3 : bounds[1]
                }
                return offset
            },
            _calcTargetOffset: function(offsetRatio, isFast) {
                var result;
                if (isFast) {
                    result = Math.ceil(Math.abs(offsetRatio));
                    if (offsetRatio < 0) {
                        result = -result
                    }
                } else {
                    result = Math.round(offsetRatio)
                }
                return result
            }
        });
        registerEmitter({
            emitter: SwipeEmitter,
            events: [SWIPE_START_EVENT, SWIPE_EVENT, SWIPE_END_EVENT]
        });
        exports.swipe = SWIPE_EVENT;
        exports.start = SWIPE_START_EVENT;
        exports.end = SWIPE_END_EVENT
    },
    /*!*****************************************!*\
      !*** ./artifacts/transpiled/ui/list.js ***!
      \*****************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var ListEdit = __webpack_require__( /*! ./list/ui.list.edit.search */ 454),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8);
        registerComponent("dxList", ListEdit);
        module.exports = ListEdit
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/ui/check_box.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 67),
            Editor = __webpack_require__( /*! ./editor/editor */ 47),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            themes = __webpack_require__( /*! ./themes */ 19),
            clickEvent = __webpack_require__( /*! ../events/click */ 17);
        var CHECKBOX_CLASS = "dx-checkbox",
            CHECKBOX_ICON_CLASS = "dx-checkbox-icon",
            CHECKBOX_CHECKED_CLASS = "dx-checkbox-checked",
            CHECKBOX_CONTAINER_CLASS = "dx-checkbox-container",
            CHECKBOX_TEXT_CLASS = "dx-checkbox-text",
            CHECKBOX_HAS_TEXT_CLASS = "dx-checkbox-has-text",
            CHECKBOX_INDETERMINATE_CLASS = "dx-checkbox-indeterminate",
            CHECKBOX_FEEDBACK_HIDE_TIMEOUT = 100;
        var CheckBox = Editor.inherit({
            _supportedKeys: function() {
                var click = function(e) {
                    e.preventDefault();
                    this._clickAction({
                        event: e
                    })
                };
                return extend(this.callBase(), {
                    space: click
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    hoverStateEnabled: true,
                    activeStateEnabled: true,
                    value: false,
                    text: "",
                    useInkRipple: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        return "desktop" === devices.real().deviceType && !devices.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        return themes.isAndroid5()
                    },
                    options: {
                        useInkRipple: true
                    }
                }])
            },
            _feedbackHideTimeout: CHECKBOX_FEEDBACK_HIDE_TIMEOUT,
            _initMarkup: function() {
                this._renderSubmitElement();
                this._$container = $("<div>").addClass(CHECKBOX_CONTAINER_CLASS);
                this.setAria("role", "checkbox");
                this.$element().addClass(CHECKBOX_CLASS);
                this._renderValue();
                this._renderIcon();
                this._renderText();
                this.option("useInkRipple") && this._renderInkRipple();
                this.$element().append(this._$container);
                this.callBase()
            },
            _render: function() {
                this._renderClick();
                this.callBase()
            },
            _renderSubmitElement: function() {
                this._$submitElement = $("<input>").attr("type", "hidden").appendTo(this.$element())
            },
            _getSubmitElement: function() {
                return this._$submitElement
            },
            _renderInkRipple: function() {
                this._inkRipple = inkRipple.render({
                    waveSizeCoefficient: 2.5,
                    useHoldAnimation: false,
                    wavesNumber: 2,
                    isCentered: true
                })
            },
            _renderInkWave: function(element, dxEvent, doRender, waveIndex) {
                if (!this._inkRipple) {
                    return
                }
                var config = {
                    element: element,
                    event: dxEvent,
                    wave: waveIndex
                };
                if (doRender) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _updateFocusState: function(e, value) {
                this.callBase.apply(this, arguments);
                this._renderInkWave(this._$icon, e, value, 0)
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                this._renderInkWave(this._$icon, e, value, 1)
            },
            _renderIcon: function() {
                this._$icon = $("<span>").addClass(CHECKBOX_ICON_CLASS).prependTo(this._$container)
            },
            _renderText: function() {
                var textValue = this.option("text");
                if (!textValue) {
                    if (this._$text) {
                        this._$text.remove();
                        this.$element().removeClass(CHECKBOX_HAS_TEXT_CLASS)
                    }
                    return
                }
                if (!this._$text) {
                    this._$text = $("<span>").addClass(CHECKBOX_TEXT_CLASS)
                }
                this._$text.text(textValue);
                this._$container.append(this._$text);
                this.$element().addClass(CHECKBOX_HAS_TEXT_CLASS)
            },
            _renderClick: function() {
                var that = this,
                    eventName = eventUtils.addNamespace(clickEvent.name, that.NAME);
                that._clickAction = that._createAction(that._clickHandler);
                eventsEngine.off(that.$element(), eventName);
                eventsEngine.on(that.$element(), eventName, function(e) {
                    that._clickAction({
                        event: e
                    })
                })
            },
            _clickHandler: function(args) {
                var that = args.component;
                that._saveValueChangeEvent(args.event);
                that.option("value", !that.option("value"))
            },
            _renderValue: function() {
                var $element = this.$element(),
                    checked = this.option("value"),
                    indeterminate = void 0 === checked;
                $element.toggleClass(CHECKBOX_CHECKED_CLASS, Boolean(checked));
                $element.toggleClass(CHECKBOX_INDETERMINATE_CLASS, indeterminate);
                this._$submitElement.val(checked);
                this.setAria("checked", indeterminate ? "mixed" : checked || "false")
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "value":
                        this._renderValue();
                        this.callBase(args);
                        break;
                    case "text":
                        this._renderText();
                        this._renderDimensions();
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        registerComponent("dxCheckBox", CheckBox);
        module.exports = CheckBox
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/ui/select_box.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            isDefined = typeUtils.isDefined,
            isPromise = typeUtils.isPromise,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 7),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 13).getPublicElement,
            Deferred = deferredUtils.Deferred,
            errors = __webpack_require__( /*! ../core/errors */ 18),
            inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 67),
            messageLocalization = __webpack_require__( /*! ../localization/message */ 14),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            dataQuery = __webpack_require__( /*! ../data/query */ 40),
            DropDownList = __webpack_require__( /*! ./drop_down_editor/ui.drop_down_list */ 207),
            themes = __webpack_require__( /*! ./themes */ 19),
            clickEvent = __webpack_require__( /*! ../events/click */ 17);
        var DISABLED_STATE_SELECTOR = ".dx-state-disabled",
            SELECTBOX_CLASS = "dx-selectbox",
            SELECTBOX_POPUP_CLASS = "dx-selectbox-popup",
            SELECTBOX_CONTAINER_CLASS = "dx-selectbox-container",
            SELECTBOX_POPUP_WRAPPER_CLASS = "dx-selectbox-popup-wrapper";
        var SelectBox = DropDownList.inherit({
            _supportedKeys: function() {
                var that = this,
                    parent = this.callBase(),
                    clearSelectBox = function(e) {
                        var isEditable = this._isEditable();
                        if (!isEditable) {
                            if (this.option("showClearButton")) {
                                e.preventDefault();
                                this.reset()
                            }
                        } else {
                            if (this._valueSubstituted()) {
                                this._preventFiltering = true
                            }
                        }
                        this._preventSubstitution = true
                    };
                var searchIfNeeded = function() {
                    if (that.option("searchEnabled") && that._valueSubstituted()) {
                        that._searchHandler()
                    }
                };
                return extend({}, parent, {
                    tab: function() {
                        if (this.option("opened") && "instantly" === this.option("applyValueMode")) {
                            this._cleanInputSelection()
                        }
                        if (this._wasSearch()) {
                            this._clearFilter()
                        }
                        parent.tab.apply(this, arguments)
                    },
                    upArrow: function() {
                        if (parent.upArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(-1)
                            }
                            return true
                        }
                    },
                    downArrow: function() {
                        if (parent.downArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(1)
                            }
                            return true
                        }
                    },
                    leftArrow: function() {
                        searchIfNeeded();
                        parent.leftArrow.apply(this, arguments)
                    },
                    rightArrow: function() {
                        searchIfNeeded();
                        parent.rightArrow.apply(this, arguments)
                    },
                    home: function() {
                        searchIfNeeded();
                        parent.home.apply(this, arguments)
                    },
                    end: function() {
                        searchIfNeeded();
                        parent.end.apply(this, arguments)
                    },
                    escape: function() {
                        parent.escape.apply(this, arguments);
                        this._cancelEditing()
                    },
                    enter: function(e) {
                        if ("" === this._input().val() && this.option("value") && this.option("allowClearing")) {
                            this.option({
                                selectedItem: null,
                                value: null
                            });
                            this.close()
                        } else {
                            if (this.option("acceptCustomValue")) {
                                e.preventDefault();
                                return this.option("opened")
                            }
                            if (parent.enter.apply(this, arguments)) {
                                return this.option("opened")
                            }
                        }
                    },
                    backspace: clearSelectBox,
                    del: clearSelectBox
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    placeholder: messageLocalization.format("Select"),
                    fieldTemplate: null,
                    valueChangeEvent: "change",
                    acceptCustomValue: false,
                    onCustomItemCreating: function(e) {
                        if (!isDefined(e.customItem)) {
                            e.customItem = e.text
                        }
                    },
                    showSelectionControls: false,
                    autocompletionEnabled: true,
                    allowClearing: true,
                    tooltipEnabled: false,
                    openOnFieldClick: true,
                    showDropDownButton: true,
                    displayCustomValue: false,
                    _isAdaptablePopupPosition: false,
                    useInkRipple: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        return themes.isWin8()
                    },
                    options: {
                        _isAdaptablePopupPosition: true,
                        popupPosition: {
                            at: "left top",
                            offset: {
                                h: 0,
                                v: 0
                            }
                        }
                    }
                }, {
                    device: function() {
                        return themes.isAndroid5()
                    },
                    options: {
                        _isAdaptablePopupPosition: true,
                        popupPosition: {
                            offset: {
                                h: -16,
                                v: -8
                            }
                        },
                        useInkRipple: true
                    }
                }])
            },
            _init: function() {
                this.callBase();
                this._initCustomItemCreatingAction()
            },
            _initMarkup: function() {
                this._renderSubmitElement();
                this.$element().addClass(SELECTBOX_CLASS);
                this._renderTooltip();
                this.option("useInkRipple") && this._renderInkRipple();
                this.callBase();
                this._$container.addClass(SELECTBOX_CONTAINER_CLASS)
            },
            _renderSubmitElement: function() {
                this._$submitElement = $("<input>").attr("type", "hidden").appendTo(this.$element())
            },
            _renderInkRipple: function() {
                this._inkRipple = inkRipple.render()
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                if (!this._inkRipple || this._isEditable()) {
                    return
                }
                var config = {
                    element: this._inputWrapper(),
                    event: e
                };
                if (value) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _createPopup: function() {
                this.callBase();
                this._popup.$element().addClass(SELECTBOX_POPUP_CLASS)
            },
            _popupWrapperClass: function() {
                return this.callBase() + " " + SELECTBOX_POPUP_WRAPPER_CLASS
            },
            _cancelEditing: function() {
                if (!this.option("searchEnabled") && this._list) {
                    this._focusListElement(null);
                    this._updateField(this.option("selectedItem"))
                }
            },
            _closeOutsideDropDownHandler: function(e) {
                this._cancelEditing();
                return this.callBase(e)
            },
            _renderOpenedState: function() {
                this.callBase();
                if (this.option("opened")) {
                    this._scrollToSelectedItem();
                    this._focusSelectedElement()
                }
            },
            _focusSelectedElement: function() {
                var searchValue = this._searchValue();
                if (!searchValue) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements(),
                    index = inArray(this.option("selectedItem"), this.option("items")),
                    focusedElement = index >= 0 && !this._isCustomItemSelected() ? $listItems.eq(index) : null;
                this._focusListElement(focusedElement)
            },
            _renderFocusedElement: function() {
                if (!this._list) {
                    return
                }
                var searchValue = this._searchValue();
                if (!searchValue || this.option("acceptCustomValue")) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements(),
                    focusedElement = $listItems.not(DISABLED_STATE_SELECTOR).eq(0);
                this._focusListElement(focusedElement)
            },
            _focusListElement: function(element) {
                this._preventInputValueRender = true;
                this._list.option("focusedElement", getPublicElement(element));
                delete this._preventInputValueRender
            },
            _scrollToSelectedItem: function() {
                this._list && this._list.scrollToItem(this._list.option("selectedItem"))
            },
            _listContentReadyHandler: function() {
                this.callBase();
                var isPaginate = this._dataSource && this._dataSource.paginate();
                if (isPaginate && this._needPopupRepaint()) {
                    return
                }
                this._scrollToSelectedItem()
            },
            _renderValue: function() {
                this._renderInputValue();
                this._setSubmitValue()
            },
            _setSubmitValue: function() {
                var value = this.option("value"),
                    submitValue = "this" === this.option("valueExpr") ? this._displayGetter(value) : value;
                this._$submitElement.val(submitValue)
            },
            _getSubmitElement: function() {
                return this._$submitElement
            },
            _renderInputValue: function() {
                return this.callBase().always(function() {
                    this._renderInputValueAsync()
                }.bind(this))
            },
            _renderInputValueAsync: function() {
                this._renderTooltip();
                this._renderInputValueImpl();
                this._refreshSelected()
            },
            _renderInputValueImpl: function() {
                this._renderInputAddons()
            },
            _fitIntoRange: function(value, start, end) {
                if (value > end) {
                    return start
                }
                if (value < start) {
                    return end
                }
                return value
            },
            _setNextValue: function(step) {
                var dataSourceIsLoaded = this._dataSource.isLoaded() ? (new Deferred).resolve() : this._dataSource.load();
                dataSourceIsLoaded.done(function() {
                    var item = this._calcNextItem(step),
                        value = this._valueGetter(item);
                    this._setValue(value)
                }.bind(this))
            },
            _calcNextItem: function(step) {
                var items = this._items();
                var nextIndex = this._fitIntoRange(this._getSelectedIndex() + step, 0, items.length - 1);
                return items[nextIndex]
            },
            _items: function() {
                var items = this._getPlainItems(!this._list && this._dataSource.items());
                var availableItems = new dataQuery(items).filter("disabled", "<>", true).toArray();
                return availableItems
            },
            _getSelectedIndex: function() {
                var items = this._items();
                var selectedItem = this.option("selectedItem");
                var result = -1;
                each(items, function(index, item) {
                    if (this._isValueEquals(item, selectedItem)) {
                        result = index;
                        return false
                    }
                }.bind(this));
                return result
            },
            _setSelectedItem: function(item) {
                var isUnknownItem = !this._isCustomValueAllowed() && void 0 === item;
                this.callBase(isUnknownItem ? null : item)
            },
            _isCustomValueAllowed: function() {
                return this.option("acceptCustomValue") || this.callBase()
            },
            _displayValue: function(item) {
                item = !isDefined(item) && this._isCustomValueAllowed() ? this.option("value") : item;
                return this.callBase(item)
            },
            _listConfig: function() {
                var result = extend(this.callBase(), {
                    pageLoadMode: "scrollBottom",
                    onSelectionChanged: this._getSelectionChangeHandler(),
                    selectedItem: this.option("selectedItem"),
                    onFocusedItemChanged: this._listFocusedItemChangeHandler.bind(this)
                });
                if (this.option("showSelectionControls")) {
                    extend(result, {
                        showSelectionControls: true,
                        selectionByClick: true
                    })
                }
                return result
            },
            _listFocusedItemChangeHandler: function(e) {
                if (this._preventInputValueRender) {
                    return
                }
                var list = e.component,
                    focusedElement = $(list.option("focusedElement")),
                    focusedItem = list._getItemData(focusedElement);
                this._updateField(focusedItem)
            },
            _updateField: function(item) {
                var fieldTemplate = this._getTemplateByOption("fieldTemplate");
                if (!(fieldTemplate && this.option("fieldTemplate"))) {
                    this._renderDisplayText(this._displayGetter(item));
                    return
                }
                this._renderInputAddons()
            },
            _getSelectionChangeHandler: function() {
                return this.option("showSelectionControls") ? this._selectionChangeHandler.bind(this) : commonUtils.noop
            },
            _selectionChangeHandler: function(e) {
                each(e.addedItems || [], function(_, addedItem) {
                    this._setValue(this._valueGetter(addedItem))
                }.bind(this))
            },
            _getActualSearchValue: function() {
                return this._dataSource.searchValue()
            },
            _toggleOpenState: function(isVisible) {
                if (this.option("disabled")) {
                    return
                }
                isVisible = arguments.length ? isVisible : !this.option("opened");
                if (!isVisible) {
                    this._restoreInputText()
                }
                if (this._wasSearch() && isVisible) {
                    this._wasSearch(false);
                    if (this.option("showDataBeforeSearch") || 0 === this.option("minSearchLength")) {
                        if (this._searchTimer) {
                            return
                        }
                        var searchValue = this._getActualSearchValue();
                        searchValue && this._wasSearch(true);
                        this._filterDataSource(searchValue || null)
                    } else {
                        this._setListOption("items", [])
                    }
                }
                if (isVisible) {
                    this._scrollToSelectedItem()
                }
                this.callBase(isVisible)
            },
            _renderTooltip: function() {
                if (this.option("tooltipEnabled")) {
                    this.$element().attr("title", this.option("displayValue"))
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._setPopupOption("width")
            },
            _restoreInputText: function() {
                this._loadItemDeferred && this._loadItemDeferred.always(function() {
                    if (this.option("acceptCustomValue")) {
                        return
                    }
                    if (this.option("searchEnabled")) {
                        if (!this._searchValue() && this.option("allowClearing")) {
                            this._clearTextValue();
                            return
                        }
                    }
                    var oldSelectedItem = this.option("selectedItem");
                    if ((this._displayGetter(oldSelectedItem) || "").toString() === this._searchValue()) {
                        return
                    }
                    this._renderInputValue().always(function(selectedItem) {
                        var newSelectedItem = commonUtils.ensureDefined(selectedItem, oldSelectedItem);
                        this._setSelectedItem(newSelectedItem);
                        this._updateField(newSelectedItem);
                        this._clearFilter()
                    }.bind(this))
                }.bind(this))
            },
            _focusOutHandler: function(e) {
                this.callBase(e);
                this._restoreInputText()
            },
            _clearTextValue: function() {
                this.option("value", null)
            },
            _renderValueChangeEvent: function() {
                if (this._isEditable()) {
                    this.callBase()
                }
            },
            _isEditable: function() {
                return this.option("acceptCustomValue") || this.option("searchEnabled")
            },
            _fieldRenderData: function() {
                var $listFocused = this._list && this.option("opened") && $(this._list.option("focusedElement"));
                if ($listFocused && $listFocused.length) {
                    return this._list._getItemData($listFocused)
                }
                return this.option("selectedItem")
            },
            _readOnlyPropValue: function() {
                return !this._isEditable() || this.option("readOnly")
            },
            _isSelectedValue: function(value) {
                return this._isValueEquals(value, this.option("value"))
            },
            _shouldCloseOnItemClick: function() {
                return !(this.option("showSelectionControls") && "single" !== this.option("selectionMode"))
            },
            _listItemClickHandler: function(e) {
                var previousValue = this._getCurrentValue();
                this._saveValueChangeEvent(e.event);
                if (this._wasSearch()) {
                    this._clearFilter()
                }
                this._completeSelection(this._valueGetter(e.itemData));
                if (this._shouldCloseOnItemClick()) {
                    this.option("opened", false)
                }
                if (this.option("searchEnabled") && previousValue === this._valueGetter(e.itemData)) {
                    this._updateField(e.itemData)
                }
            },
            _completeSelection: function(value) {
                this._setValue(value)
            },
            _loadItem: function(value, cache) {
                var that = this,
                    deferred = new Deferred;
                this.callBase(value, cache).done(function(item) {
                    deferred.resolve(item)
                }.bind(this)).fail(function() {
                    var selectedItem = that.option("selectedItem");
                    if (that.option("acceptCustomValue") && value === that._valueGetter(selectedItem)) {
                        deferred.resolve(selectedItem)
                    } else {
                        deferred.reject()
                    }
                }.bind(this));
                return deferred.promise()
            },
            _loadInputValue: function(value, callback) {
                this._loadItemDeferred = this._loadItem(value).always(callback);
                return this._loadItemDeferred
            },
            _isCustomItemSelected: function() {
                var selectedItem = this.option("selectedItem"),
                    searchValue = this._searchValue(),
                    selectedItemText = this._displayGetter(selectedItem);
                return !selectedItemText || searchValue !== selectedItemText.toString()
            },
            _valueChangeEventHandler: function() {
                if (this.option("acceptCustomValue") && this._isCustomItemSelected()) {
                    this._customItemAddedHandler()
                }
            },
            _initCustomItemCreatingAction: function() {
                this._customItemCreatingAction = this._createActionByOption("onCustomItemCreating")
            },
            _createCustomItem: function(text) {
                var params = {
                        text: text
                    },
                    actionResult = this._customItemCreatingAction(params),
                    item = commonUtils.ensureDefined(actionResult, params.customItem);
                if (isDefined(actionResult)) {
                    errors.log("W0015", "onCustomItemCreating", "customItem")
                }
                return item
            },
            _customItemAddedHandler: function() {
                var searchValue = this._searchValue(),
                    item = this._createCustomItem(searchValue);
                if (void 0 === item) {
                    this._renderValue();
                    throw errors.Error("E0121")
                }
                if (isPromise(item)) {
                    deferredUtils.fromPromise(item).done(this._setCustomItem.bind(this)).fail(this._setCustomItem.bind(this, null))
                } else {
                    this._setCustomItem(item)
                }
            },
            _setCustomItem: function(item) {
                if (this._disposed) {
                    return
                }
                item = item || null;
                this.option("selectedItem", item);
                this._setValue(this._valueGetter(item));
                this._renderDisplayText(this._displayGetter(item));
                if (null === item && this._wasSearch()) {
                    this._filterDataSource(null)
                }
            },
            _createClearButton: function() {
                var eventName = eventUtils.addNamespace(clickEvent.name, this.NAME);
                var $clearButton = this.callBase();
                eventsEngine.on($clearButton, eventName, function() {
                    return false
                });
                return $clearButton
            },
            _wasSearch: function(value) {
                if (!arguments.length) {
                    return this._wasSearchValue
                }
                this._wasSearchValue = value
            },
            _searchHandler: function(e) {
                if (this._preventFiltering) {
                    delete this._preventFiltering;
                    return
                }
                if (this._needPassDataSourceToList()) {
                    this._wasSearch(true)
                }
                this.callBase(e)
            },
            _dataSourceFiltered: function(searchValue) {
                this.callBase();
                if (null !== searchValue) {
                    this._renderInputSubstitution();
                    this._renderFocusedElement()
                }
            },
            _valueSubstituted: function() {
                var input = this._input().get(0),
                    isAllSelected = 0 === input.selectionStart && input.selectionEnd === this._searchValue().length,
                    inputHasSelection = input.selectionStart !== input.selectionEnd;
                return this._wasSearch() && inputHasSelection && !isAllSelected
            },
            _shouldSubstitutionBeRendered: function() {
                return this.option("autocompletionEnabled") && !this._preventSubstitution && this.option("searchEnabled") && !this.option("acceptCustomValue") && "startswith" === this.option("searchMode")
            },
            _renderInputSubstitution: function() {
                if (!this._shouldSubstitutionBeRendered()) {
                    delete this._preventSubstitution;
                    return
                }
                var item = this._list && this._getPlainItems(this._list.option("items"))[0];
                if (!item) {
                    return
                }
                var $input = this._input(),
                    valueLength = $input.val().length;
                if (0 === valueLength) {
                    return
                }
                var inputElement = $input.get(0),
                    displayValue = this._displayGetter(item).toString();
                inputElement.value = displayValue;
                this._caret({
                    start: valueLength,
                    end: displayValue.length
                })
            },
            _cleanInputSelection: function() {
                var inputElement = this._input().get(0),
                    endPosition = inputElement.value.length;
                inputElement.selectionStart = endPosition;
                inputElement.selectionEnd = endPosition
            },
            _dispose: function() {
                this._renderInputValueAsync = commonUtils.noop;
                delete this._loadItemDeferred;
                this.callBase()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_isAdaptablePopupPosition":
                    case "autocompletionEnabled":
                        break;
                    case "onCustomItemCreating":
                        this._initCustomItemCreatingAction();
                        break;
                    case "tooltipEnabled":
                        this._renderTooltip();
                        break;
                    case "displayCustomValue":
                    case "acceptCustomValue":
                    case "showSelectionControls":
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "selectedItem":
                        if (args.previousValue !== args.value) {
                            this.callBase(args)
                        }
                        break;
                    case "allowClearing":
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        registerComponent("dxSelectBox", SelectBox);
        module.exports = SelectBox
    }, , , , ,
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/component.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }
        var Config = __webpack_require__( /*! ./config */ 29),
            domAdapter = __webpack_require__( /*! ./dom_adapter */ 12),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            Class = __webpack_require__( /*! ./class */ 10),
            Action = __webpack_require__( /*! ./action */ 79),
            errors = __webpack_require__( /*! ./errors */ 18),
            coreDataUtils = __webpack_require__( /*! ./utils/data */ 23),
            commonUtils = __webpack_require__( /*! ./utils/common */ 4),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 7),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            map = __webpack_require__( /*! ../core/utils/iterator */ 3).map,
            Callbacks = __webpack_require__( /*! ./utils/callbacks */ 20),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 53),
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 102),
            devices = __webpack_require__( /*! ./devices */ 16),
            isFunction = typeUtils.isFunction,
            noop = commonUtils.noop;
        var cachedGetters = {};
        var cachedSetters = {};
        var PostponedOperations = function() {
            function PostponedOperations() {
                _classCallCheck(this, PostponedOperations);
                this._postponedOperations = {}
            }
            _createClass(PostponedOperations, [{
                key: "add",
                value: function(key, fn, postponedPromise) {
                    if (key in this._postponedOperations) {
                        postponedPromise && this._postponedOperations[key].promises.push(postponedPromise)
                    } else {
                        var completePromise = new Deferred;
                        this._postponedOperations[key] = {
                            fn: fn,
                            completePromise: completePromise,
                            promises: postponedPromise ? [postponedPromise] : []
                        }
                    }
                    return this._postponedOperations[key].completePromise.promise()
                }
            }, {
                key: "callPostponedOperations",
                value: function() {
                    for (var key in this._postponedOperations) {
                        var operation = this._postponedOperations[key];
                        if (operation.promises && operation.promises.length) {
                            when.apply(void 0, _toConsumableArray(operation.promises)).done(operation.fn).then(operation.completePromise.resolve)
                        } else {
                            operation.fn().done(operation.completePromise.resolve)
                        }
                    }
                    this._postponedOperations = {}
                }
            }]);
            return PostponedOperations
        }();
        var Component = Class.inherit({
            _setDeprecatedOptions: function() {
                this._deprecatedOptions = {}
            },
            _getDeprecatedOptions: function() {
                return this._deprecatedOptions
            },
            _getOptionAliasesByName: function(optionName) {
                return map(this._deprecatedOptions, function(deprecate, aliasName) {
                    return optionName === deprecate.alias ? aliasName : void 0
                })
            },
            _getDefaultOptions: function() {
                return {
                    onInitialized: null,
                    onOptionChanged: null,
                    onDisposing: null,
                    defaultOptionsRules: null
                }
            },
            _setDefaultOptions: function() {
                this._options = this._getDefaultOptions()
            },
            _defaultOptionsRules: function() {
                return []
            },
            _setOptionsByDevice: function(customRules) {
                var rules = this._defaultOptionsRules();
                if (Array.isArray(customRules)) {
                    rules = rules.concat(customRules)
                }
                var rulesOptions = this._convertRulesToOptions(rules);
                extend(true, this._options, rulesOptions);
                for (var fieldName in this._optionsByReference) {
                    if (rulesOptions.hasOwnProperty(fieldName)) {
                        this._options[fieldName] = rulesOptions[fieldName]
                    }
                }
            },
            _convertRulesToOptions: function(rules) {
                var options = {};
                var currentDevice = devices.current();
                var deviceMatch = function(device, filter) {
                    var filterArray = [];
                    Array.prototype.push.call(filterArray, filter);
                    return 1 === filterArray.length && typeUtils.isEmptyObject(filterArray[0]) || commonUtils.findBestMatches(device, filterArray).length > 0
                };
                for (var i = 0; i < rules.length; i++) {
                    var match, rule = rules[i],
                        deviceFilter = rule.device || {};
                    if (isFunction(deviceFilter)) {
                        match = deviceFilter(currentDevice)
                    } else {
                        match = deviceMatch(currentDevice, deviceFilter)
                    }
                    if (match) {
                        extend(options, rule.options)
                    }
                }
                return options
            },
            _isInitialOptionValue: function(name) {
                var optionValue = this.option(name),
                    initialOptionValue = this.initialOption(name),
                    isInitialOption = isFunction(optionValue) && isFunction(initialOptionValue) ? optionValue.toString() === initialOptionValue.toString() : commonUtils.equalByValue(optionValue, initialOptionValue);
                return isInitialOption
            },
            _setOptionsByReference: function() {
                this._optionsByReference = {}
            },
            _getOptionsByReference: function() {
                return this._optionsByReference
            },
            ctor: function(options) {
                this.NAME = publicComponentUtils.name(this.constructor);
                options = options || {};
                if (options.eventsStrategy) {
                    this.setEventsStrategy(options.eventsStrategy)
                }
                this._options = {};
                this._updateLockCount = 0;
                this._optionChangedCallbacks = options._optionChangedCallbacks || Callbacks();
                this._disposingCallbacks = options._disposingCallbacks || Callbacks();
                this.postponedOperations = new PostponedOperations;
                this.beginUpdate();
                try {
                    this._suppressDeprecatedWarnings();
                    this._setOptionsByReference();
                    this._setDeprecatedOptions();
                    this._setDefaultOptions();
                    if (options && options.onInitializing) {
                        options.onInitializing.apply(this, [options])
                    }
                    this._setOptionsByDevice(options.defaultOptionsRules);
                    this._resumeDeprecatedWarnings();
                    this._initOptions(options)
                } finally {
                    this.endUpdate()
                }
            },
            _initOptions: function(options) {
                this.option(options)
            },
            _optionValuesEqual: function(name, oldValue, newValue) {
                oldValue = coreDataUtils.toComparable(oldValue, true);
                newValue = coreDataUtils.toComparable(newValue, true);
                if (oldValue && newValue && typeUtils.isRenderer(oldValue) && typeUtils.isRenderer(newValue)) {
                    return newValue.is(oldValue)
                }
                var oldValueIsNaN = oldValue !== oldValue,
                    newValueIsNaN = newValue !== newValue;
                if (oldValueIsNaN && newValueIsNaN) {
                    return true
                }
                if (null === oldValue || "object" !== ("undefined" === typeof oldValue ? "undefined" : _typeof(oldValue)) || domAdapter.isElementNode(oldValue)) {
                    return oldValue === newValue
                }
                return false
            },
            _init: function() {
                this._createOptionChangedAction();
                this.on("disposing", function(args) {
                    this._disposingCallbacks.fireWith(this, [args])
                }.bind(this))
            },
            _createOptionChangedAction: function() {
                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                    excludeValidators: ["disabled", "readOnly", "designMode"]
                })
            },
            _createDisposingAction: function() {
                this._disposingAction = this._createActionByOption("onDisposing", {
                    excludeValidators: ["disabled", "readOnly", "designMode"]
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onDisposing":
                    case "onInitialized":
                        break;
                    case "onOptionChanged":
                        this._createOptionChangedAction();
                        break;
                    case "defaultOptionsRules":
                }
            },
            _dispose: function() {
                this._optionChangedCallbacks.empty();
                this._createDisposingAction();
                this._disposingAction();
                this._disposeEvents();
                this._disposed = true
            },
            instance: function() {
                return this
            },
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                this._updateLockCount = Math.max(this._updateLockCount - 1, 0);
                if (!this._updateLockCount) {
                    this.postponedOperations.callPostponedOperations();
                    if (!this._initializing && !this._initialized) {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._updateLockCount++;
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly", "designMode"]
                            })();
                            this._updateLockCount--;
                            this._initialized = true
                        }
                    }
                }
            },
            _logWarningIfDeprecated: function(option) {
                var info = this._deprecatedOptions[option];
                if (info && !this._deprecatedOptionsSuppressed) {
                    this._logDeprecatedWarning(option, info)
                }
            },
            _logDeprecatedWarningCount: 0,
            _logDeprecatedWarning: function(option, info) {
                var message = info.message || "Use the '" + info.alias + "' option instead";
                errors.log("W0001", this.NAME, option, info.since, message);
                ++this._logDeprecatedWarningCount
            },
            _suppressDeprecatedWarnings: function() {
                this._deprecatedOptionsSuppressed = true
            },
            _resumeDeprecatedWarnings: function() {
                this._deprecatedOptionsSuppressed = false
            },
            _optionChanging: noop,
            _notifyOptionChanged: function(option, value, previousValue) {
                var that = this;
                if (this._initialized) {
                    var optionNames = [option].concat(that._getOptionAliasesByName(option));
                    for (var i = 0; i < optionNames.length; i++) {
                        var name = optionNames[i],
                            args = {
                                name: name.split(/[.\[]/)[0],
                                fullName: name,
                                value: value,
                                previousValue: previousValue
                            };
                        that._optionChangedCallbacks.fireWith(that, [extend(that._defaultActionArgs(), args)]);
                        that._optionChangedAction(extend({}, args));
                        if (!that._disposed) {
                            that._optionChanged(args)
                        }
                    }
                }
            },
            initialOption: function(optionName) {
                var currentOptions, currentInitialized = this._initialized;
                if (!this._initialOptions) {
                    currentOptions = this._options;
                    this._options = {};
                    this._initialized = false;
                    this._setDefaultOptions();
                    this._setOptionsByDevice(currentOptions.defaultOptionsRules);
                    this._initialOptions = this._options;
                    this._options = currentOptions;
                    this._initialized = currentInitialized
                }
                return this._initialOptions[optionName]
            },
            _defaultActionConfig: function() {
                return {
                    context: this,
                    component: this
                }
            },
            _defaultActionArgs: function() {
                return {
                    component: this
                }
            },
            _createAction: function(actionSource, config) {
                var action, that = this;
                return function(e) {
                    if (!arguments.length) {
                        e = {}
                    }
                    if (!typeUtils.isPlainObject(e)) {
                        e = {
                            actionValue: e
                        }
                    }
                    action = action || new Action(actionSource, extend(config, that._defaultActionConfig()));
                    return action.execute.call(action, extend(e, that._defaultActionArgs()))
                }
            },
            _createActionByOption: function(optionName, config) {
                var action, eventName, actionFunc, that = this;
                var result = function() {
                    if (!eventName) {
                        config = config || {};
                        if ("string" !== typeof optionName) {
                            throw errors.Error("E0008")
                        }
                        if (0 === optionName.indexOf("on")) {
                            eventName = that._getEventName(optionName)
                        }
                        if (0 !== optionName.indexOf("on")) {
                            throw Error("The '" + optionName + "' option name should start with 'on' prefix")
                        }
                        actionFunc = that.option(optionName)
                    }
                    if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !that.hasEvent(eventName)) {
                        return
                    }
                    if (!action) {
                        var beforeExecute = config.beforeExecute;
                        config.beforeExecute = function(args) {
                            beforeExecute && beforeExecute.apply(that, arguments);
                            that.fireEvent(eventName, args.args)
                        };
                        that._suppressDeprecatedWarnings();
                        action = that._createAction(actionFunc, config);
                        that._resumeDeprecatedWarnings()
                    }
                    if (Config().wrapActionsBeforeExecute) {
                        var beforeActionExecute = that.option("beforeActionExecute") || noop;
                        var wrappedAction = beforeActionExecute(that, action, config) || action;
                        return wrappedAction.apply(that, arguments)
                    }
                    return action.apply(that, arguments)
                };
                if (!Config().wrapActionsBeforeExecute) {
                    var onActionCreated = that.option("onActionCreated") || noop;
                    result = onActionCreated(that, result, config) || result
                }
                return result
            },
            _getEventName: function(actionName) {
                return actionName.charAt(2).toLowerCase() + actionName.substr(3)
            },
            hasActionSubscription: function(actionName) {
                return !!this.option(actionName) || this.hasEvent(this._getEventName(actionName))
            },
            isOptionDeprecated: function(name) {
                var deprecatedOptions = this._getDeprecatedOptions();
                return deprecatedOptions.hasOwnProperty(name)
            },
            option: function() {
                var normalizeOptionName = function(that, name) {
                    var deprecate;
                    if (name) {
                        if (!that._cachedDeprecateNames) {
                            that._cachedDeprecateNames = [];
                            for (var optionName in that._deprecatedOptions) {
                                that._cachedDeprecateNames.push(optionName)
                            }
                        }
                        for (var i = 0; i < that._cachedDeprecateNames.length; i++) {
                            if (that._cachedDeprecateNames[i] === name) {
                                deprecate = that._deprecatedOptions[name];
                                break
                            }
                        }
                        if (deprecate) {
                            that._logWarningIfDeprecated(name);
                            var alias = deprecate.alias;
                            if (alias) {
                                name = alias
                            }
                        }
                    }
                    return name
                };
                var getPreviousName = function(fullName) {
                    var splitNames = fullName.split(".");
                    splitNames.pop();
                    return splitNames.join(".")
                };
                var getFieldName = function(fullName) {
                    var splitNames = fullName.split(".");
                    return splitNames[splitNames.length - 1]
                };
                var getOptionValue = function(options, name, unwrapObservables) {
                    var getter = cachedGetters[name];
                    if (!getter) {
                        getter = cachedGetters[name] = coreDataUtils.compileGetter(name)
                    }
                    return getter(options, {
                        functionsAsIs: true,
                        unwrapObservables: unwrapObservables
                    })
                };
                var clearOptionsField = function(options, name) {
                    delete options[name];
                    var previousFieldName = getPreviousName(name),
                        fieldName = getFieldName(name),
                        fieldObject = previousFieldName ? getOptionValue(options, previousFieldName, false) : options;
                    if (fieldObject) {
                        delete fieldObject[fieldName]
                    }
                };
                var setOptionsField = function(options, fullName, value) {
                    var fieldObject, fieldName = "";
                    do {
                        if (fieldName) {
                            fieldName = "." + fieldName
                        }
                        fieldName = getFieldName(fullName) + fieldName;
                        fullName = getPreviousName(fullName);
                        fieldObject = fullName ? getOptionValue(options, fullName, false) : options
                    } while (!fieldObject);
                    fieldObject[fieldName] = value
                };
                var normalizeOptionValue = function(that, options, name, value) {
                    if (name) {
                        var alias = normalizeOptionName(that, name);
                        if (alias && alias !== name) {
                            setOptionsField(options, alias, value);
                            clearOptionsField(options, name)
                        }
                    }
                };
                var prepareOption = function prepareOption(that, options, name, value) {
                    if (typeUtils.isPlainObject(value)) {
                        for (var valueName in value) {
                            prepareOption(that, options, name + "." + valueName, value[valueName])
                        }
                    }
                    normalizeOptionValue(that, options, name, value)
                };
                var setOptionValue = function(that, name, value) {
                    if (!cachedSetters[name]) {
                        cachedSetters[name] = coreDataUtils.compileSetter(name)
                    }
                    var path = name.split(/[.\[]/);
                    cachedSetters[name](that._options, value, {
                        functionsAsIs: true,
                        merge: !that._getOptionsByReference()[name],
                        unwrapObservables: path.length > 1 && !!that._getOptionsByReference()[path[0]]
                    })
                };
                var setOption = function(that, name, value) {
                    var previousValue = getOptionValue(that._options, name, false);
                    if (that._optionValuesEqual(name, previousValue, value)) {
                        return
                    }
                    if (that._initialized) {
                        that._optionChanging(name, previousValue, value)
                    }
                    setOptionValue(that, name, value);
                    that._notifyOptionChanged(name, value, previousValue)
                };
                return function(options, value) {
                    var that = this,
                        name = options;
                    if (arguments.length < 2 && "object" !== typeUtils.type(name)) {
                        name = normalizeOptionName(that, name);
                        return getOptionValue(that._options, name)
                    }
                    if ("string" === typeof name) {
                        options = {};
                        options[name] = value
                    }
                    that.beginUpdate();
                    try {
                        var optionName;
                        for (optionName in options) {
                            prepareOption(that, options, optionName, options[optionName])
                        }
                        for (optionName in options) {
                            setOption(that, optionName, options[optionName])
                        }
                    } finally {
                        that.endUpdate()
                    }
                }
            }(),
            _getOptionValue: function(name, context) {
                var value = this.option(name);
                if (isFunction(value)) {
                    return value.bind(context)()
                }
                return value
            }
        }).include(EventsMixin);
        module.exports = Component;
        module.exports.PostponedOperations = PostponedOperations
    },
    /*!***********************************************************************************!*\
      !*** ./artifacts/transpiled/animation/transition_executor/transition_executor.js ***!
      \***********************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            Class = __webpack_require__( /*! ../../core/class */ 10),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            fx = __webpack_require__( /*! ../fx */ 32),
            animationPresetsModule = __webpack_require__( /*! ../presets/presets */ 143),
            deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 7),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred;
        var directionPostfixes = {
                forward: " dx-forward",
                backward: " dx-backward",
                none: " dx-no-direction",
                undefined: " dx-no-direction"
            },
            DX_ANIMATING_CLASS = "dx-animating";
        var TransitionExecutor = Class.inherit({
            ctor: function() {
                this._accumulatedDelays = {
                    enter: 0,
                    leave: 0
                };
                this._animations = [];
                this.reset()
            },
            _createAnimations: function($elements, initialConfig, configModifier, type) {
                var animationConfig, that = this,
                    result = [];
                configModifier = configModifier || {};
                animationConfig = this._prepareElementAnimationConfig(initialConfig, configModifier, type);
                if (animationConfig) {
                    $elements.each(function() {
                        var animation = that._createAnimation($(this), animationConfig, configModifier);
                        if (animation) {
                            animation.element.addClass(DX_ANIMATING_CLASS);
                            animation.setup();
                            result.push(animation)
                        }
                    })
                }
                return result
            },
            _prepareElementAnimationConfig: function(config, configModifier, type) {
                var result;
                if ("string" === typeof config) {
                    var presetName = config;
                    config = animationPresetsModule.presets.getPreset(presetName)
                }
                if (!config) {
                    result = void 0
                } else {
                    if (typeUtils.isFunction(config[type])) {
                        result = config[type]
                    } else {
                        result = extend({
                            skipElementInitialStyles: true,
                            cleanupWhen: this._completePromise
                        }, config, configModifier);
                        if (!result.type || "css" === result.type) {
                            var cssClass = "dx-" + type,
                                extraCssClasses = (result.extraCssClasses ? " " + result.extraCssClasses : "") + directionPostfixes[result.direction];
                            result.type = "css";
                            result.from = (result.from || cssClass) + extraCssClasses;
                            result.to = result.to || cssClass + "-active"
                        }
                        result.staggerDelay = result.staggerDelay || 0;
                        result.delay = result.delay || 0;
                        if (result.staggerDelay) {
                            result.delay += this._accumulatedDelays[type];
                            this._accumulatedDelays[type] += result.staggerDelay
                        }
                    }
                }
                return result
            },
            _createAnimation: function($element, animationConfig, configModifier) {
                var result;
                if (typeUtils.isPlainObject(animationConfig)) {
                    result = fx.createAnimation($element, animationConfig)
                } else {
                    if (typeUtils.isFunction(animationConfig)) {
                        result = animationConfig($element, configModifier)
                    }
                }
                return result
            },
            _startAnimations: function() {
                var animations = this._animations;
                for (var i = 0; i < animations.length; i++) {
                    animations[i].start()
                }
            },
            _stopAnimations: function(jumpToEnd) {
                var animations = this._animations;
                for (var i = 0; i < animations.length; i++) {
                    animations[i].stop(jumpToEnd)
                }
            },
            _clearAnimations: function() {
                var animations = this._animations;
                for (var i = 0; i < animations.length; i++) {
                    animations[i].element.removeClass(DX_ANIMATING_CLASS)
                }
                this._animations.length = 0
            },
            reset: function() {
                this._accumulatedDelays.enter = 0;
                this._accumulatedDelays.leave = 0;
                this._clearAnimations();
                this._completeDeferred = new Deferred;
                this._completePromise = this._completeDeferred.promise()
            },
            enter: function($elements, animationConfig, configModifier) {
                var animations = this._createAnimations($elements, animationConfig, configModifier, "enter");
                this._animations.push.apply(this._animations, animations)
            },
            leave: function($elements, animationConfig, configModifier) {
                var animations = this._createAnimations($elements, animationConfig, configModifier, "leave");
                this._animations.push.apply(this._animations, animations)
            },
            start: function() {
                var result, that = this;
                if (!this._animations.length) {
                    that.reset();
                    result = (new Deferred).resolve().promise()
                } else {
                    var animationDeferreds = iteratorUtils.map(this._animations, function(animation) {
                        var result = new Deferred;
                        animation.deferred.always(function() {
                            result.resolve()
                        });
                        return result.promise()
                    });
                    result = when.apply($, animationDeferreds).always(function() {
                        that._completeDeferred.resolve();
                        that.reset()
                    });
                    commonUtils.executeAsync(function() {
                        that._startAnimations()
                    })
                }
                return result
            },
            stop: function(jumpToEnd) {
                this._stopAnimations(jumpToEnd)
            }
        });
        exports.TransitionExecutor = TransitionExecutor
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/list/ui.list.edit.decorator.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            Class = __webpack_require__( /*! ../../core/class */ 10),
            swipeEvents = __webpack_require__( /*! ../../events/swipe */ 118),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9);
        var LIST_EDIT_DECORATOR = "dxListEditDecorator",
            SWIPE_START_EVENT_NAME = eventUtils.addNamespace(swipeEvents.start, LIST_EDIT_DECORATOR),
            SWIPE_UPDATE_EVENT_NAME = eventUtils.addNamespace(swipeEvents.swipe, LIST_EDIT_DECORATOR),
            SWIPE_END_EVENT_NAME = eventUtils.addNamespace(swipeEvents.end, LIST_EDIT_DECORATOR);
        var EditDecorator = Class.inherit({
            ctor: function(list) {
                this._list = list;
                this._init()
            },
            _init: noop,
            _shouldHandleSwipe: false,
            _attachSwipeEvent: function(config) {
                var swipeConfig = {
                    itemSizeFunc: function() {
                        if (this._clearSwipeCache) {
                            this._itemWidthCache = this._list.$element().width();
                            this._clearSwipeCache = false
                        }
                        return this._itemWidthCache
                    }.bind(this)
                };
                eventsEngine.on(config.$itemElement, SWIPE_START_EVENT_NAME, swipeConfig, this._itemSwipeStartHandler.bind(this));
                eventsEngine.on(config.$itemElement, SWIPE_UPDATE_EVENT_NAME, this._itemSwipeUpdateHandler.bind(this));
                eventsEngine.on(config.$itemElement, SWIPE_END_EVENT_NAME, this._itemSwipeEndHandler.bind(this))
            },
            _itemSwipeStartHandler: function(e) {
                var $itemElement = $(e.currentTarget);
                if ($itemElement.is(".dx-state-disabled, .dx-state-disabled *")) {
                    e.cancel = true;
                    return
                }
                clearTimeout(this._list._inkRippleTimer);
                this._swipeStartHandler($itemElement, e)
            },
            _itemSwipeUpdateHandler: function(e) {
                var $itemElement = $(e.currentTarget);
                this._swipeUpdateHandler($itemElement, e)
            },
            _itemSwipeEndHandler: function(e) {
                var $itemElement = $(e.currentTarget);
                this._swipeEndHandler($itemElement, e);
                this._clearSwipeCache = true
            },
            beforeBag: noop,
            afterBag: noop,
            _commonOptions: function() {
                return {
                    activeStateEnabled: this._list.option("activeStateEnabled"),
                    hoverStateEnabled: this._list.option("hoverStateEnabled"),
                    focusStateEnabled: this._list.option("focusStateEnabled")
                }
            },
            modifyElement: function(config) {
                if (this._shouldHandleSwipe) {
                    this._attachSwipeEvent(config);
                    this._clearSwipeCache = true
                }
            },
            afterRender: noop,
            handleClick: noop,
            handleKeyboardEvents: noop,
            handleEnterPressing: noop,
            handleContextMenu: noop,
            _swipeStartHandler: noop,
            _swipeUpdateHandler: noop,
            _swipeEndHandler: noop,
            visibilityChange: noop,
            getExcludedSelectors: noop,
            dispose: noop
        });
        module.exports = EditDecorator
    }, ,
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/bundles/modules/core.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 6);
        var window = windowUtils.getWindow();
        var DevExpress = window.DevExpress = window.DevExpress || {};
        var errors = DevExpress.errors = __webpack_require__( /*! ../../core/errors */ 18);
        if (DevExpress._DEVEXTREME_BUNDLE_INITIALIZED) {
            throw errors.Error("E0024")
        }
        DevExpress._DEVEXTREME_BUNDLE_INITIALIZED = true;
        DevExpress.clientExporter = __webpack_require__( /*! ../../client_exporter */ 175);
        DevExpress.VERSION = __webpack_require__( /*! ../../core/version */ 131);
        DevExpress.Class = __webpack_require__( /*! ../../core/class */ 10);
        DevExpress.DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 57);
        DevExpress.Component = __webpack_require__( /*! ../../core/component */ 126);
        DevExpress.registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 8);
        DevExpress.devices = __webpack_require__( /*! ../../core/devices */ 16);
        DevExpress.Color = __webpack_require__( /*! ../../color */ 88);
        var animationFrame = __webpack_require__( /*! ../../animation/frame */ 106);
        DevExpress.EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 53);
        DevExpress.utils = {};
        DevExpress.utils.requestAnimationFrame = animationFrame.requestAnimationFrame;
        DevExpress.utils.cancelAnimationFrame = animationFrame.cancelAnimationFrame;
        DevExpress.utils.initMobileViewport = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 232).initMobileViewport;
        DevExpress.utils.extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 0).extendFromObject;
        DevExpress.utils.createComponents = __webpack_require__( /*! ../../core/utils/dom */ 13).createComponents;
        DevExpress.utils.triggerShownEvent = __webpack_require__( /*! ../../core/utils/dom */ 13).triggerShownEvent;
        DevExpress.utils.triggerHidingEvent = __webpack_require__( /*! ../../core/utils/dom */ 13).triggerHidingEvent;
        DevExpress.utils.resetActiveElement = __webpack_require__( /*! ../../core/utils/dom */ 13).resetActiveElement;
        DevExpress.utils.findBestMatches = __webpack_require__( /*! ../../core/utils/common */ 4).findBestMatches;
        DevExpress.createQueue = __webpack_require__( /*! ../../core/utils/queue */ 178).create;
        DevExpress.utils.dom = __webpack_require__( /*! ../../core/utils/dom */ 13);
        DevExpress.utils.common = __webpack_require__( /*! ../../core/utils/common */ 4);
        DevExpress.utils.date = __webpack_require__( /*! ../../core/utils/date */ 22);
        DevExpress.utils.browser = __webpack_require__( /*! ../../core/utils/browser */ 30);
        DevExpress.utils.inflector = __webpack_require__( /*! ../../core/utils/inflector */ 35);
        DevExpress.utils.iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        DevExpress.utils.resizeCallbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 132);
        DevExpress.utils.console = __webpack_require__( /*! ../../core/utils/console */ 73);
        DevExpress.utils.string = __webpack_require__( /*! ../../core/utils/string */ 39);
        DevExpress.utils.support = __webpack_require__( /*! ../../core/utils/support */ 44);
        DevExpress.processHardwareBackButton = __webpack_require__( /*! ../../mobile/process_hardware_back_button */ 233);
        DevExpress.viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 72).value;
        DevExpress.hideTopOverlay = __webpack_require__( /*! ../../mobile/hide_top_overlay */ 135);
        DevExpress.formatHelper = __webpack_require__( /*! ../../format_helper */ 84);
        DevExpress.config = __webpack_require__( /*! ../../core/config */ 29);
        DevExpress.animationPresets = __webpack_require__( /*! ../../animation/presets/presets */ 143).presets;
        DevExpress.fx = __webpack_require__( /*! ../../animation/fx */ 32);
        DevExpress.TransitionExecutor = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 127).TransitionExecutor;
        DevExpress.AnimationPresetCollection = __webpack_require__( /*! ../../animation/presets/presets */ 143).PresetCollection;
        DevExpress.events = __webpack_require__( /*! ../../events */ 317);
        DevExpress.events.click = __webpack_require__( /*! ../../events/click */ 17);
        DevExpress.events.utils = __webpack_require__( /*! ../../events/utils */ 9);
        DevExpress.events.GestureEmitter = __webpack_require__( /*! ../../events/gesture/emitter.gesture */ 151);
        DevExpress.localization = __webpack_require__( /*! ../../localization */ 320);
        module.exports = DevExpress
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/version.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = "18.1.6"
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/resize_callbacks.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ./window */ 6),
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 12),
            Callbacks = __webpack_require__( /*! ./callbacks */ 20),
            readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 52),
            callOnce = __webpack_require__( /*! ./call_once */ 68);
        var resizeCallbacks = function() {
            var prevSize, callbacks = Callbacks(),
                originalCallbacksAdd = callbacks.add,
                originalCallbacksRemove = callbacks.remove;
            if (!windowUtils.hasWindow()) {
                return callbacks
            }
            var formatSize = function() {
                var documentElement = domAdapter.getDocumentElement();
                return {
                    width: documentElement.clientWidth,
                    height: documentElement.clientHeight
                }
            };
            var handleResize = function() {
                var now = formatSize();
                if (now.width === prevSize.width && now.height === prevSize.height) {
                    return
                }
                var changedDimension;
                if (now.width === prevSize.width) {
                    changedDimension = "height"
                }
                if (now.height === prevSize.height) {
                    changedDimension = "width"
                }
                prevSize = now;
                callbacks.fire(changedDimension)
            };
            var setPrevSize = callOnce(function() {
                prevSize = formatSize()
            });
            var removeListener;
            callbacks.add = function() {
                var result = originalCallbacksAdd.apply(callbacks, arguments);
                setPrevSize();
                readyCallbacks.add(function() {
                    if (!removeListener && callbacks.has()) {
                        removeListener = domAdapter.listen(windowUtils.getWindow(), "resize", handleResize)
                    }
                });
                return result
            };
            callbacks.remove = function() {
                var result = originalCallbacksRemove.apply(callbacks, arguments);
                if (!callbacks.has() && removeListener) {
                    removeListener();
                    removeListener = void 0
                }
                return result
            };
            return callbacks
        }();
        module.exports = resizeCallbacks
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/ui/popover.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 6),
            window = windowUtils.getWindow(),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 12),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            stringUtils = __webpack_require__( /*! ../core/utils/string */ 39),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            translator = __webpack_require__( /*! ../animation/translator */ 24),
            positionUtils = __webpack_require__( /*! ../animation/position */ 74),
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            mathUtils = __webpack_require__( /*! ../core/utils/math */ 34),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            Popup = __webpack_require__( /*! ./popup */ 59);
        var POPOVER_CLASS = "dx-popover",
            POPOVER_WRAPPER_CLASS = "dx-popover-wrapper",
            POPOVER_ARROW_CLASS = "dx-popover-arrow",
            POPOVER_WITHOUT_TITLE_CLASS = "dx-popover-without-title",
            POSITION_FLIP_MAP = {
                left: "right",
                top: "bottom",
                right: "left",
                bottom: "top",
                center: "center"
            },
            WEIGHT_OF_SIDES = {
                left: -1,
                top: -1,
                center: 0,
                right: 1,
                bottom: 1
            },
            POSITION_ALIASES = {
                top: {
                    my: "bottom center",
                    at: "top center",
                    collision: "fit flip"
                },
                bottom: {
                    my: "top center",
                    at: "bottom center",
                    collision: "fit flip"
                },
                right: {
                    my: "left center",
                    at: "right center",
                    collision: "flip fit"
                },
                left: {
                    my: "right center",
                    at: "left center",
                    collision: "flip fit"
                }
            },
            SIDE_BORDER_WIDTH_STYLES = {
                left: "borderLeftWidth",
                top: "borderTopWidth",
                right: "borderRightWidth",
                bottom: "borderBottomWidth"
            },
            getEventName = function(that, optionName) {
                var optionValue = that.option(optionName);
                return getEventNameByOption(optionValue)
            },
            getEventNameByOption = function(optionValue) {
                return typeUtils.isObject(optionValue) ? optionValue.name : optionValue
            },
            getEventDelay = function(that, optionName) {
                var optionValue = that.option(optionName);
                return typeUtils.isObject(optionValue) && optionValue.delay
            },
            attachEvent = function(that, name) {
                var delay, action, handler, eventName, target = that.option("target"),
                    event = getEventName(that, name + "Event");
                if (!event || that.option("disabled")) {
                    return
                }
                eventName = eventUtils.addNamespace(event, that.NAME);
                action = that._createAction(function() {
                    delay = getEventDelay(that, name + "Event");
                    this._clearEventTimeout("hide" === name);
                    if (delay) {
                        this._timeouts[name] = setTimeout(function() {
                            that[name]()
                        }, delay)
                    } else {
                        that[name]()
                    }
                }.bind(that), {
                    validatingTargetName: "target"
                });
                handler = function(e) {
                    action({
                        event: e,
                        target: $(e.currentTarget)
                    })
                };
                if (target.jquery || target.nodeType || typeUtils.isWindow(target)) {
                    that["_" + name + "EventHandler"] = void 0;
                    eventsEngine.on(target, eventName, handler)
                } else {
                    that["_" + name + "EventHandler"] = handler;
                    eventsEngine.on(domAdapter.getDocument(), eventName, target, handler)
                }
            },
            detachEvent = function(that, target, name, event) {
                var eventName = event || getEventName(that, name + "Event");
                if (!eventName) {
                    return
                }
                eventName = eventUtils.addNamespace(eventName, that.NAME);
                if (that["_" + name + "EventHandler"]) {
                    eventsEngine.off(domAdapter.getDocument(), eventName, target, that["_" + name + "EventHandler"])
                } else {
                    eventsEngine.off($(target), eventName)
                }
            };
        var Popover = Popup.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    target: window,
                    shading: false,
                    position: "bottom",
                    closeOnOutsideClick: true,
                    animation: {
                        show: {
                            type: "fade",
                            from: 0,
                            to: 1
                        },
                        hide: {
                            type: "fade",
                            to: 0
                        }
                    },
                    showTitle: false,
                    width: "auto",
                    height: "auto",
                    dragEnabled: false,
                    resizeEnabled: false,
                    fullScreen: false,
                    closeOnTargetScroll: true,
                    arrowPosition: "",
                    arrowOffset: 0,
                    boundaryOffset: {
                        h: 10,
                        v: 10
                    }
                })
            },
            _defaultOptionsRules: function() {
                return [{
                    device: {
                        platform: "ios"
                    },
                    options: {
                        arrowPosition: {
                            boundaryOffset: {
                                h: 20,
                                v: -10
                            },
                            collision: "fit"
                        }
                    }
                }, {
                    device: function() {
                        return !windowUtils.hasWindow()
                    },
                    options: {
                        animation: null
                    }
                }]
            },
            _init: function() {
                this.callBase();
                this._renderArrow();
                this._timeouts = {};
                this.$element().addClass(POPOVER_CLASS);
                this._wrapper().addClass(POPOVER_WRAPPER_CLASS)
            },
            _render: function() {
                this.callBase.apply(this, arguments);
                this._detachEvents(this.option("target"));
                this._attachEvents()
            },
            _detachEvents: function(target) {
                detachEvent(this, target, "show");
                detachEvent(this, target, "hide")
            },
            _attachEvents: function() {
                attachEvent(this, "show");
                attachEvent(this, "hide")
            },
            _renderArrow: function() {
                this._$arrow = $("<div>").addClass(POPOVER_ARROW_CLASS).prependTo(this.overlayContent())
            },
            _documentDownHandler: function(e) {
                if (this._isOutsideClick(e)) {
                    return this.callBase(e)
                }
                return true
            },
            _isOutsideClick: function(e) {
                return !$(e.target).closest(this.option("target")).length
            },
            _animate: function(animation) {
                if (animation && animation.to && "object" === _typeof(animation.to)) {
                    extend(animation.to, {
                        position: this._getContainerPosition()
                    })
                }
                this.callBase.apply(this, arguments)
            },
            _stopAnimation: function() {
                this.callBase.apply(this, arguments)
            },
            _renderTitle: function() {
                this._wrapper().toggleClass(POPOVER_WITHOUT_TITLE_CLASS, !this.option("showTitle"));
                this.callBase()
            },
            _renderPosition: function() {
                this.callBase();
                this._renderOverlayPosition()
            },
            _renderOverlayBoundaryOffset: noop,
            _renderOverlayPosition: function() {
                this._resetOverlayPosition();
                this._updateContentSize();
                var contentPosition = this._getContainerPosition();
                var resultLocation = positionUtils.setup(this._$content, contentPosition);
                var positionSide = this._getSideByLocation(resultLocation);
                this._togglePositionClass("dx-position-" + positionSide);
                this._toggleFlippedClass(resultLocation.h.flip, resultLocation.v.flip);
                this._renderArrowPosition(positionSide)
            },
            _resetOverlayPosition: function() {
                this._setContentHeight(true);
                this._togglePositionClass("dx-position-" + this._positionSide);
                translator.move(this._$content, {
                    left: 0,
                    top: 0
                });
                this._$arrow.css({
                    top: "auto",
                    right: "auto",
                    bottom: "auto",
                    left: "auto"
                })
            },
            _updateContentSize: function() {
                if (!this._$popupContent) {
                    return
                }
                var containerLocation = positionUtils.calculate(this._$content, this._getContainerPosition());
                if (containerLocation.h.oversize > 0 && this._isHorizontalSide() && !containerLocation.h.fit) {
                    var newContainerWidth = this._$content.width() - containerLocation.h.oversize;
                    this._$content.width(newContainerWidth)
                }
                if (containerLocation.v.oversize > 0 && this._isVerticalSide() && !containerLocation.v.fit) {
                    var newOverlayContentHeight = this._$content.height() - containerLocation.v.oversize,
                        newPopupContentHeight = this._$popupContent.height() - containerLocation.v.oversize;
                    this._$content.height(newOverlayContentHeight);
                    this._$popupContent.height(newPopupContentHeight)
                }
            },
            _getContainerPosition: function() {
                var offset = stringUtils.pairToObject(this._position.offset || "");
                var hOffset = offset.h;
                var vOffset = offset.v;
                var isPopoverInside = this._isPopoverInside();
                var sign = (isPopoverInside ? -1 : 1) * WEIGHT_OF_SIDES[this._positionSide];
                var arrowSizeCorrection = this._getContentBorderWidth(this._positionSide);
                if (this._isVerticalSide()) {
                    vOffset += sign * (this._$arrow.height() - arrowSizeCorrection)
                } else {
                    if (this._isHorizontalSide()) {
                        hOffset += sign * (this._$arrow.width() - arrowSizeCorrection)
                    }
                }
                return extend({}, this._position, {
                    offset: hOffset + " " + vOffset
                })
            },
            _getContentBorderWidth: function(side) {
                var borderWidth = this._$content.css(SIDE_BORDER_WIDTH_STYLES[side]);
                return parseInt(borderWidth) || 0
            },
            _getSideByLocation: function(location) {
                var isFlippedByVertical = location.v.flip;
                var isFlippedByHorizontal = location.h.flip;
                return this._isVerticalSide() && isFlippedByVertical || this._isHorizontalSide() && isFlippedByHorizontal || this._isPopoverInside() ? POSITION_FLIP_MAP[this._positionSide] : this._positionSide
            },
            _togglePositionClass: function(positionClass) {
                this._$wrapper.removeClass("dx-position-left dx-position-right dx-position-top dx-position-bottom").addClass(positionClass)
            },
            _toggleFlippedClass: function(isFlippedHorizontal, isFlippedVertical) {
                this._$wrapper.toggleClass("dx-popover-flipped-horizontal", isFlippedHorizontal).toggleClass("dx-popover-flipped-vertical", isFlippedVertical)
            },
            _renderArrowPosition: function(side) {
                this._$arrow.css(POSITION_FLIP_MAP[side], -(this._isVerticalSide(side) ? this._$arrow.height() : this._$arrow.width()));
                var axis = this._isVerticalSide(side) ? "left" : "top";
                var sizeProperty = this._isVerticalSide(side) ? "outerWidth" : "outerHeight";
                var $target = $(this._position.of);
                var targetOffset = positionUtils.offset($target) || {
                    top: 0,
                    left: 0
                };
                var contentOffset = positionUtils.offset(this._$content);
                var arrowSize = this._$arrow[sizeProperty]();
                var contentLocation = contentOffset[axis];
                var contentSize = this._$content[sizeProperty]();
                var targetLocation = targetOffset[axis];
                var targetSize = $target.get(0).preventDefault ? 0 : $target[sizeProperty]();
                var min = Math.max(contentLocation, targetLocation);
                var max = Math.min(contentLocation + contentSize, targetLocation + targetSize);
                var arrowLocation;
                if ("start" === this.option("arrowPosition")) {
                    arrowLocation = min - contentLocation
                } else {
                    if ("end" === this.option("arrowPosition")) {
                        arrowLocation = max - contentLocation - arrowSize
                    } else {
                        arrowLocation = (min + max) / 2 - contentLocation - arrowSize / 2
                    }
                }
                var borderWidth = this._getContentBorderWidth(side);
                var finalArrowLocation = mathUtils.fitIntoRange(arrowLocation - borderWidth + this.option("arrowOffset"), borderWidth, contentSize - arrowSize - 2 * borderWidth);
                this._$arrow.css(axis, finalArrowLocation)
            },
            _isPopoverInside: function() {
                var position = this._transformStringPosition(this.option("position"), POSITION_ALIASES);
                var my = positionUtils.setup.normalizeAlign(position.my);
                var at = positionUtils.setup.normalizeAlign(position.at);
                return my.h === at.h && my.v === at.v
            },
            _setContentHeight: function(fullUpdate) {
                if (fullUpdate) {
                    this.callBase()
                }
            },
            _renderShadingPosition: function() {
                if (this.option("shading")) {
                    this._$wrapper.css({
                        top: 0,
                        left: 0
                    })
                }
            },
            _renderShadingDimensions: function() {
                if (this.option("shading")) {
                    this._$wrapper.css({
                        width: "100%",
                        height: "100%"
                    })
                }
            },
            _normalizePosition: function() {
                var position = extend({}, this._transformStringPosition(this.option("position"), POSITION_ALIASES));
                if (!position.of) {
                    position.of = this.option("target")
                }
                if (!position.collision) {
                    position.collision = "flip"
                }
                if (!position.boundaryOffset) {
                    position.boundaryOffset = this.option("boundaryOffset")
                }
                this._positionSide = this._getDisplaySide(position);
                this._position = position
            },
            _getDisplaySide: function(position) {
                var my = positionUtils.setup.normalizeAlign(position.my),
                    at = positionUtils.setup.normalizeAlign(position.at);
                var weightSign = WEIGHT_OF_SIDES[my.h] === WEIGHT_OF_SIDES[at.h] && WEIGHT_OF_SIDES[my.v] === WEIGHT_OF_SIDES[at.v] ? -1 : 1,
                    horizontalWeight = Math.abs(WEIGHT_OF_SIDES[my.h] - weightSign * WEIGHT_OF_SIDES[at.h]),
                    verticalWeight = Math.abs(WEIGHT_OF_SIDES[my.v] - weightSign * WEIGHT_OF_SIDES[at.v]);
                return horizontalWeight > verticalWeight ? at.h : at.v
            },
            _isVerticalSide: function(side) {
                side = side || this._positionSide;
                return "top" === side || "bottom" === side
            },
            _isHorizontalSide: function(side) {
                side = side || this._positionSide;
                return "left" === side || "right" === side
            },
            _clearEventTimeout: function(visibility) {
                clearTimeout(this._timeouts[visibility ? "show" : "hide"])
            },
            _clean: function() {
                this._detachEvents(this.option("target"));
                this.callBase.apply(this, arguments)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "showTitle":
                    case "title":
                    case "titleTemplate":
                        this.callBase(args);
                        this._renderGeometry();
                        break;
                    case "boundaryOffset":
                    case "arrowPosition":
                    case "arrowOffset":
                        this._renderGeometry();
                        break;
                    case "fullScreen":
                        if (args.value) {
                            this.option("fullScreen", false)
                        }
                        break;
                    case "target":
                        args.previousValue && this._detachEvents(args.previousValue);
                        this.callBase(args);
                        break;
                    case "showEvent":
                    case "hideEvent":
                        var name = args.name.substring(0, 4),
                            event = getEventNameByOption(args.previousValue);
                        this.hide();
                        detachEvent(this, this.option("target"), name, event);
                        attachEvent(this, name);
                        break;
                    case "visible":
                        this._clearEventTimeout(args.value);
                        this.callBase(args);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            show: function(target) {
                if (target) {
                    this.option("target", target)
                }
                return this.callBase()
            }
        });
        registerComponent("dxPopover", Popover);
        module.exports = Popover
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/remove_event.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2);
        var beforeCleanData = __webpack_require__( /*! ./element_data */ 38).beforeCleanData;
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var registerEvent = __webpack_require__( /*! ../events/core/event_registrator */ 63);
        var eventName = "dxremove";
        var eventPropName = "dxRemoveEvent";
        beforeCleanData(function(elements) {
            elements = [].slice.call(elements);
            for (var i = 0; i < elements.length; i++) {
                var $element = $(elements[i]);
                if ($element.prop(eventPropName)) {
                    $element[0][eventPropName] = null;
                    eventsEngine.triggerHandler($element, eventName)
                }
            }
        });
        registerEvent(eventName, {
            noBubble: true,
            setup: function(element) {
                $(element).prop(eventPropName, true)
            }
        });
        module.exports = eventName
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled/mobile/hide_top_overlay.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray;
        var hideCallback = function() {
            var callbacks = [];
            return {
                add: function(callback) {
                    var indexOfCallback = inArray(callback, callbacks);
                    if (indexOfCallback === -1) {
                        callbacks.push(callback)
                    }
                },
                remove: function(callback) {
                    var indexOfCallback = inArray(callback, callbacks);
                    if (indexOfCallback !== -1) {
                        callbacks.splice(indexOfCallback, 1)
                    }
                },
                fire: function() {
                    var callback = callbacks.pop(),
                        result = !!callback;
                    if (result) {
                        callback()
                    }
                    return result
                },
                hasCallback: function() {
                    return callbacks.length > 0
                },
                reset: function() {
                    callbacks = []
                }
            }
        }();
        module.exports = function() {
            return hideCallback.fire()
        };
        module.exports.hideCallback = hideCallback
    },
    /*!***************************************************************************!*\
      !*** ./artifacts/transpiled/ui/scheduler/ui.scheduler.publisher_mixin.js ***!
      \***************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var publisherMixin = {
            notifyObserver: function(subject, args) {
                var observer = this.option("observer");
                if (observer) {
                    observer.fire(subject, args)
                }
            },
            invoke: function() {
                var observer = this.option("observer");
                if (observer) {
                    return observer.fire.apply(observer, arguments)
                }
            }
        };
        module.exports = publisherMixin
    }, , , , ,
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/localization/currency.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            numberLocalization = __webpack_require__( /*! ./number */ 49);
        numberLocalization.inject({
            _formatNumberCore: function(value, format, formatConfig) {
                if ("currency" === format) {
                    formatConfig.precision = formatConfig.precision || 0;
                    var result = this.format(value, extend({}, formatConfig, {
                            type: "fixedpoint"
                        })),
                        currencyPart = this.getCurrencySymbol().symbol.replace("$", "$$$$");
                    result = result.replace(/^(\D*)(\d.*)/, "$1" + currencyPart + "$2");
                    return result
                }
                return this.callBase.apply(this, arguments)
            },
            getCurrencySymbol: function() {
                return {
                    symbol: "$"
                }
            },
            getOpenXmlCurrencyFormat: function() {
                return "$#,##0{0}_);\\($#,##0{0}\\)"
            }
        })
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator_callbacks.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 177);
        module.exports = new MemorizedCallbacks
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/animation/presets/presets.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Component = __webpack_require__( /*! ../../core/component */ 126),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            fx = __webpack_require__( /*! ../fx */ 32);
        var directionPostfixes = {
            forward: " dx-forward",
            backward: " dx-backward",
            none: " dx-no-direction",
            undefined: " dx-no-direction"
        };
        var optionPrefix = "preset_";
        var AnimationPresetCollection = Component.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._registeredPresets = [];
                this.resetToDefaults()
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    defaultAnimationDuration: 400,
                    defaultAnimationDelay: 0,
                    defaultStaggerAnimationDuration: 300,
                    defaultStaggerAnimationDelay: 40,
                    defaultStaggerAnimationStartDelay: 500
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function(_device) {
                        return _device.phone
                    },
                    options: {
                        defaultStaggerAnimationDuration: 350,
                        defaultStaggerAnimationDelay: 50,
                        defaultStaggerAnimationStartDelay: 0
                    }
                }, {
                    device: function() {
                        return devices.current().android || devices.real.android
                    },
                    options: {
                        defaultAnimationDelay: 100
                    }
                }])
            },
            _getPresetOptionName: function(animationName) {
                return optionPrefix + animationName
            },
            _createAndroidSlideAnimationConfig: function(throughOpacity, widthMultiplier) {
                var that = this;
                var createBaseConfig = function(configModifier) {
                    return {
                        type: "slide",
                        delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                        duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                    }
                };
                return {
                    enter: function($element, configModifier) {
                        var width = $element.parent().width() * widthMultiplier,
                            direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.to = {
                            left: 0,
                            opacity: 1
                        };
                        if ("forward" === direction) {
                            config.from = {
                                left: width,
                                opacity: throughOpacity
                            }
                        } else {
                            if ("backward" === direction) {
                                config.from = {
                                    left: -width,
                                    opacity: throughOpacity
                                }
                            } else {
                                config.from = {
                                    left: 0,
                                    opacity: 0
                                }
                            }
                        }
                        return fx.createAnimation($element, config)
                    },
                    leave: function($element, configModifier) {
                        var width = $element.parent().width() * widthMultiplier,
                            direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.from = {
                            left: 0,
                            opacity: 1
                        };
                        if ("forward" === direction) {
                            config.to = {
                                left: -width,
                                opacity: throughOpacity
                            }
                        } else {
                            if ("backward" === direction) {
                                config.to = {
                                    left: width,
                                    opacity: throughOpacity
                                }
                            } else {
                                config.to = {
                                    left: 0,
                                    opacity: 0
                                }
                            }
                        }
                        return fx.createAnimation($element, config)
                    }
                }
            },
            _createOpenDoorConfig: function() {
                var that = this;
                var createBaseConfig = function(configModifier) {
                    return {
                        type: "css",
                        extraCssClasses: "dx-opendoor-animation",
                        delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                        duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                    }
                };
                return {
                    enter: function($element, configModifier) {
                        var direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.delay = "none" === direction ? config.delay : config.duration;
                        config.from = "dx-enter dx-opendoor-animation" + directionPostfixes[direction];
                        config.to = "dx-enter-active";
                        return fx.createAnimation($element, config)
                    },
                    leave: function($element, configModifier) {
                        var direction = configModifier.direction,
                            config = createBaseConfig(configModifier);
                        config.from = "dx-leave dx-opendoor-animation" + directionPostfixes[direction];
                        config.to = "dx-leave-active";
                        return fx.createAnimation($element, config)
                    }
                }
            },
            _createWinPopConfig: function() {
                var that = this,
                    baseConfig = {
                        type: "css",
                        extraCssClasses: "dx-win-pop-animation",
                        duration: that.option("defaultAnimationDuration")
                    };
                return {
                    enter: function($element, configModifier) {
                        var config = baseConfig,
                            direction = configModifier.direction;
                        config.delay = "none" === direction ? that.option("defaultAnimationDelay") : that.option("defaultAnimationDuration") / 2;
                        config.from = "dx-enter dx-win-pop-animation" + directionPostfixes[direction];
                        config.to = "dx-enter-active";
                        return fx.createAnimation($element, config)
                    },
                    leave: function($element, configModifier) {
                        var config = baseConfig,
                            direction = configModifier.direction;
                        config.delay = that.option("defaultAnimationDelay");
                        config.from = "dx-leave dx-win-pop-animation" + directionPostfixes[direction];
                        config.to = "dx-leave-active";
                        return fx.createAnimation($element, config)
                    }
                }
            },
            resetToDefaults: function() {
                this.clear();
                this.registerDefaultPresets();
                this.applyChanges()
            },
            clear: function(name) {
                var that = this,
                    newRegisteredPresets = [];
                each(this._registeredPresets, function(index, preset) {
                    if (!name || name === preset.name) {
                        that.option(that._getPresetOptionName(preset.name), void 0)
                    } else {
                        newRegisteredPresets.push(preset)
                    }
                });
                this._registeredPresets = newRegisteredPresets;
                this.applyChanges()
            },
            registerPreset: function(name, config) {
                this._registeredPresets.push({
                    name: name,
                    config: config
                })
            },
            applyChanges: function() {
                var that = this;
                var customRules = [];
                each(this._registeredPresets, function(index, preset) {
                    var rule = {
                        device: preset.config.device,
                        options: {}
                    };
                    rule.options[that._getPresetOptionName(preset.name)] = preset.config.animation;
                    customRules.push(rule)
                });
                this._setOptionsByDevice(customRules)
            },
            getPreset: function(name) {
                var result = name;
                while ("string" === typeof result) {
                    result = this.option(this._getPresetOptionName(result))
                }
                return result
            },
            registerDefaultPresets: function() {
                this.registerPreset("pop", {
                    animation: {
                        extraCssClasses: "dx-android-pop-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("openDoor", {
                    animation: this._createOpenDoorConfig()
                });
                this.registerPreset("win-pop", {
                    animation: this._createWinPopConfig()
                });
                this.registerPreset("fade", {
                    animation: {
                        extraCssClasses: "dx-fade-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("slide", {
                    device: function() {
                        return devices.current().android || devices.real.android
                    },
                    animation: this._createAndroidSlideAnimationConfig(1, 1)
                });
                this.registerPreset("slide", {
                    device: function() {
                        return !devices.current().android && !devices.real.android
                    },
                    animation: {
                        extraCssClasses: "dx-slide-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("ios7-slide", {
                    animation: {
                        extraCssClasses: "dx-ios7-slide-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("overflow", {
                    animation: {
                        extraCssClasses: "dx-overflow-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("ios7-toolbar", {
                    device: function() {
                        return !devices.current().android && !devices.real.android
                    },
                    animation: {
                        extraCssClasses: "dx-ios7-toolbar-animation",
                        delay: this.option("defaultAnimationDelay"),
                        duration: this.option("defaultAnimationDuration")
                    }
                });
                this.registerPreset("ios7-toolbar", {
                    device: function() {
                        return devices.current().android || devices.real.android
                    },
                    animation: this._createAndroidSlideAnimationConfig(0, .4)
                });
                this.registerPreset("stagger-fade", {
                    animation: {
                        extraCssClasses: "dx-fade-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-slide", {
                    animation: {
                        extraCssClasses: "dx-slide-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-slide", {
                    animation: {
                        extraCssClasses: "dx-fade-slide-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-drop", {
                    animation: {
                        extraCssClasses: "dx-drop-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-drop", {
                    animation: {
                        extraCssClasses: "dx-fade-drop-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-rise", {
                    animation: {
                        extraCssClasses: "dx-fade-rise-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-3d-drop", {
                    animation: {
                        extraCssClasses: "dx-3d-drop-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                });
                this.registerPreset("stagger-fade-zoom", {
                    animation: {
                        extraCssClasses: "dx-fade-zoom-animation",
                        staggerDelay: this.option("defaultStaggerAnimationDelay"),
                        duration: this.option("defaultStaggerAnimationDuration"),
                        delay: this.option("defaultStaggerAnimationStartDelay")
                    }
                })
            }
        });
        exports.PresetCollection = AnimationPresetCollection;
        var animationPresets = new AnimationPresetCollection;
        exports.presets = animationPresets
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/pointer/base.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 30),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 12),
            Class = __webpack_require__( /*! ../../core/class */ 10),
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var POINTER_EVENTS_NAMESPACE = "dxPointerEvents";
        var BaseStrategy = Class.inherit({
            ctor: function(eventName, originalEvents) {
                this._eventName = eventName;
                this._originalEvents = eventUtils.addNamespace(originalEvents, POINTER_EVENTS_NAMESPACE);
                this._handlerCount = 0;
                this.noBubble = this._isNoBubble()
            },
            _isNoBubble: function() {
                var eventName = this._eventName;
                return "dxpointerenter" === eventName || "dxpointerleave" === eventName
            },
            _handler: function(e) {
                var delegateTarget = this._getDelegateTarget(e);
                return this._fireEvent({
                    type: this._eventName,
                    pointerType: e.pointerType || eventUtils.eventSource(e),
                    originalEvent: e,
                    delegateTarget: delegateTarget,
                    timeStamp: browser.mozilla ? (new Date).getTime() : e.timeStamp
                })
            },
            _getDelegateTarget: function(e) {
                var delegateTarget;
                if (this.noBubble) {
                    delegateTarget = e.delegateTarget
                }
                return delegateTarget
            },
            _fireEvent: function(args) {
                return eventUtils.fireEvent(args)
            },
            _setSelector: function(handleObj) {
                this._selector = this.noBubble && handleObj ? handleObj.selector : null
            },
            _getSelector: function() {
                return this._selector
            },
            setup: function() {
                return true
            },
            add: function(element, handleObj) {
                if (this._handlerCount <= 0 || this.noBubble) {
                    element = this.noBubble ? element : domAdapter.getDocument();
                    this._setSelector(handleObj);
                    var that = this;
                    eventsEngine.on(element, this._originalEvents, this._getSelector(), function(e) {
                        that._handler(e)
                    })
                }
                if (!this.noBubble) {
                    this._handlerCount++
                }
            },
            remove: function(handleObj) {
                this._setSelector(handleObj);
                if (!this.noBubble) {
                    this._handlerCount--
                }
            },
            teardown: function(element) {
                if (this._handlerCount && !this.noBubble) {
                    return
                }
                element = this.noBubble ? element : domAdapter.getDocument();
                if (this._originalEvents !== "." + POINTER_EVENTS_NAMESPACE) {
                    eventsEngine.off(element, this._originalEvents, this._getSelector())
                }
            },
            dispose: function(element) {
                element = this.noBubble ? element : domAdapter.getDocument();
                eventsEngine.off(element, this._originalEvents)
            }
        });
        module.exports = BaseStrategy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/framework/router.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            inArray = __webpack_require__( /*! ../core/utils/array */ 11).inArray,
            Class = __webpack_require__( /*! ../core/class */ 10);
        var JSON_URI_PREFIX = encodeURIComponent("json:");
        var Route = Class.inherit({
            _trimSeparators: function(str) {
                return str.replace(/^[\/.]+|\/+$/g, "")
            },
            _escapeRe: function(str) {
                return str.replace(/[^-\w]/g, "\\$1")
            },
            _checkConstraint: function(param, constraint) {
                param = String(param);
                if ("string" === typeof constraint) {
                    constraint = new RegExp(constraint)
                }
                var match = constraint.exec(param);
                if (!match || match[0] !== param) {
                    return false
                }
                return true
            },
            _ensureReady: function() {
                var that = this;
                if (this._patternRe) {
                    return false
                }
                this._pattern = this._trimSeparators(this._pattern);
                this._patternRe = "";
                this._params = [];
                this._segments = [];
                this._separators = [];
                this._pattern.replace(/[^\/]+/g, function(segment, index) {
                    that._segments.push(segment);
                    if (index) {
                        that._separators.push(that._pattern.substr(index - 1, 1))
                    }
                });
                iteratorUtils.each(this._segments, function(index) {
                    var segment = this,
                        separator = index ? that._separators[index - 1] : "";
                    if (":" === segment.charAt(0)) {
                        segment = segment.substr(1);
                        that._params.push(segment);
                        that._patternRe += "(?:" + separator + "([^/]*))";
                        if (segment in that._defaults) {
                            that._patternRe += "?"
                        }
                    } else {
                        that._patternRe += separator + that._escapeRe(segment)
                    }
                });
                this._patternRe = new RegExp("^" + this._patternRe + "$")
            },
            ctor: function(pattern, defaults, constraints) {
                this._pattern = pattern || "";
                this._defaults = defaults || {};
                this._constraints = constraints || {}
            },
            parse: function(uri) {
                var that = this;
                this._ensureReady();
                var matches = this._patternRe.exec(uri);
                if (!matches) {
                    return false
                }
                var result = extend({}, this._defaults);
                iteratorUtils.each(this._params, function(i) {
                    var index = i + 1;
                    if (matches.length >= index && matches[index]) {
                        result[this] = that.parseSegment(matches[index])
                    }
                });
                iteratorUtils.each(this._constraints, function(key) {
                    if (!that._checkConstraint(result[key], that._constraints[key])) {
                        result = false;
                        return false
                    }
                });
                return result
            },
            format: function(routeValues) {
                var that = this,
                    query = "";
                this._ensureReady();
                var mergeValues = extend({}, this._defaults),
                    useStatic = 0,
                    result = [],
                    dels = [],
                    unusedRouteValues = {};
                iteratorUtils.each(routeValues, function(paramName, paramValue) {
                    routeValues[paramName] = that.formatSegment(paramValue);
                    if (!(paramName in mergeValues)) {
                        unusedRouteValues[paramName] = true
                    }
                });
                iteratorUtils.each(this._segments, function(index, segment) {
                    result[index] = index ? that._separators[index - 1] : "";
                    if (":" === segment.charAt(0)) {
                        var paramName = segment.substr(1);
                        if (!(paramName in routeValues) && !(paramName in that._defaults)) {
                            result = null;
                            return false
                        }
                        if (paramName in that._constraints && !that._checkConstraint(routeValues[paramName], that._constraints[paramName])) {
                            result = null;
                            return false
                        }
                        if (paramName in routeValues) {
                            if (void 0 !== routeValues[paramName]) {
                                mergeValues[paramName] = routeValues[paramName];
                                result[index] += routeValues[paramName];
                                useStatic = index
                            }
                            delete unusedRouteValues[paramName]
                        } else {
                            if (paramName in mergeValues) {
                                result[index] += mergeValues[paramName];
                                dels.push(index)
                            }
                        }
                    } else {
                        result[index] += segment;
                        useStatic = index
                    }
                });
                iteratorUtils.each(mergeValues, function(key, value) {
                    if (!!value && inArray(":" + key, that._segments) === -1 && routeValues[key] !== value) {
                        result = null;
                        return false
                    }
                });
                var unusedCount = 0;
                if (!typeUtils.isEmptyObject(unusedRouteValues)) {
                    query = "?";
                    iteratorUtils.each(unusedRouteValues, function(key) {
                        query += key + "=" + routeValues[key] + "&";
                        unusedCount++
                    });
                    query = query.substr(0, query.length - 1)
                }
                if (null === result) {
                    return false
                }
                if (dels.length) {
                    iteratorUtils.map(dels, function(i) {
                        if (i >= useStatic) {
                            result[i] = ""
                        }
                    })
                }
                var path = result.join("");
                path = path.replace(/\/+$/, "");
                return {
                    uri: path + query,
                    unusedCount: unusedCount
                }
            },
            formatSegment: function(value) {
                if (Array.isArray(value) || typeUtils.isPlainObject(value)) {
                    return JSON_URI_PREFIX + encodeURIComponent(JSON.stringify(value))
                }
                return encodeURIComponent(value)
            },
            parseSegment: function(value) {
                if (value.substr(0, JSON_URI_PREFIX.length) === JSON_URI_PREFIX) {
                    try {
                        return JSON.parse(decodeURIComponent(value.substr(JSON_URI_PREFIX.length)))
                    } catch (x) {}
                }
                return decodeURIComponent(value)
            }
        });
        var Router = Class.inherit({
            ctor: function() {
                this._registry = []
            },
            _trimSeparators: function(str) {
                return str.replace(/^[\/.]+|\/+$/g, "")
            },
            _createRoute: function(pattern, defaults, constraints) {
                return new Route(pattern, defaults, constraints)
            },
            register: function(pattern, defaults, constraints) {
                this._registry.push(this._createRoute(pattern, defaults, constraints))
            },
            _parseQuery: function(query) {
                var result = {},
                    values = query.split("&");
                iteratorUtils.each(values, function(index, value) {
                    var keyValuePair = value.split("=");
                    result[keyValuePair[0]] = decodeURIComponent(keyValuePair[1])
                });
                return result
            },
            parse: function(uri) {
                var result, that = this;
                uri = this._trimSeparators(uri);
                var parts = uri.split("?", 2),
                    path = parts[0],
                    query = parts[1];
                iteratorUtils.each(this._registry, function() {
                    var parseResult = this.parse(path);
                    if (false !== parseResult) {
                        result = parseResult;
                        if (query) {
                            result = extend(result, that._parseQuery(query))
                        }
                        return false
                    }
                });
                return result ? result : false
            },
            format: function(obj) {
                var result = false,
                    minUnusedCount = 99999;
                obj = obj || {};
                iteratorUtils.each(this._registry, function() {
                    var toFormat = extend(true, {}, obj);
                    var formatResult = this.format(toFormat);
                    if (false !== formatResult) {
                        if (minUnusedCount > formatResult.unusedCount) {
                            minUnusedCount = formatResult.unusedCount;
                            result = formatResult.uri
                        }
                    }
                });
                return result
            }
        });
        Route.__internals = {
            JSON_URI_PREFIX: JSON_URI_PREFIX
        };
        module.exports = Router;
        module.exports.Route = Route
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/framework/navigation_devices.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        __webpack_require__( /*! ../integration/jquery */ 46);
        var $ = __webpack_require__( /*! jquery */ 28),
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            window = __webpack_require__( /*! ../core/utils/window */ 6).getWindow(),
            Class = __webpack_require__( /*! ../core/class */ 10),
            Callbacks = __webpack_require__( /*! ../core/utils/callbacks */ 20),
            browserAdapters = __webpack_require__( /*! ./browser_adapters */ 244),
            SessionStorage = __webpack_require__( /*! ../core/utils/storage */ 154).sessionStorage,
            devices = __webpack_require__( /*! ../core/devices */ 16);
        var SESSION_KEY = "dxPhoneJSApplication";
        var HistoryBasedNavigationDevice = Class.inherit({
            ctor: function(options) {
                options = options || {};
                this._browserAdapter = options.browserAdapter || this._createBrowserAdapter(options);
                this.uriChanged = Callbacks();
                this._browserAdapter.popState.add(this._onPopState.bind(this))
            },
            init: noop,
            getUri: function() {
                return this._browserAdapter.getHash()
            },
            setUri: function(uri, replaceCurrent) {
                if (replaceCurrent) {
                    return this._browserAdapter.replaceState(uri)
                } else {
                    if (uri !== this.getUri()) {
                        return this._browserAdapter.pushState(uri)
                    } else {
                        return $.Deferred().resolve().promise()
                    }
                }
            },
            back: function() {
                return this._browserAdapter.back()
            },
            _onPopState: function() {
                this.uriChanged.fire(this.getUri())
            },
            _isBuggyAndroid2: function() {
                var realDevice = devices.real();
                var version = realDevice.version;
                return "android" === realDevice.platform && version.length > 1 && (2 === version[0] && version[1] < 4 || version[0] < 2)
            },
            _isBuggyAndroid4: function() {
                var realDevice = devices.real();
                var version = realDevice.version;
                return "android" === realDevice.platform && version.length > 1 && 4 === version[0] && 0 === version[1]
            },
            _isWindowsPhone8: function() {
                var realDevice = devices.real();
                return "win" === realDevice.platform && realDevice.phone
            },
            _createBrowserAdapter: function(options) {
                var result, sourceWindow = options.window || window,
                    supportPushReplace = sourceWindow.history.replaceState && sourceWindow.history.pushState;
                if (this._isWindowsPhone8()) {
                    result = new browserAdapters.BuggyCordovaWP81BrowserAdapter(options)
                } else {
                    if (sourceWindow !== sourceWindow.top) {
                        result = new browserAdapters.HistorylessBrowserAdapter(options)
                    } else {
                        if (this._isBuggyAndroid4()) {
                            result = new browserAdapters.BuggyAndroidBrowserAdapter(options)
                        } else {
                            if (this._isBuggyAndroid2() || !supportPushReplace) {
                                result = new browserAdapters.OldBrowserAdapter(options)
                            } else {
                                result = new browserAdapters.DefaultBrowserAdapter(options)
                            }
                        }
                    }
                }
                return result
            }
        });
        var StackBasedNavigationDevice = HistoryBasedNavigationDevice.inherit({
            ctor: function(options) {
                this.callBase(options);
                this.backInitiated = Callbacks();
                this._rootStateHandler = null;
                $(window).on("unload", this._saveBrowserState)
            },
            init: function() {
                var that = this;
                if (that._browserAdapter.canWorkInPureBrowser) {
                    return that._initRootPage().done(function() {
                        if (that._browserAdapter.isRootPage()) {
                            that._browserAdapter.pushState("")
                        }
                    })
                } else {
                    return $.Deferred().resolve().promise()
                }
            },
            setUri: function(uri) {
                return this.callBase(uri, !this._browserAdapter.isRootPage())
            },
            _saveBrowserState: function() {
                var sessionStorage = SessionStorage();
                if (sessionStorage) {
                    sessionStorage.setItem(SESSION_KEY, true)
                }
            },
            _initRootPage: function() {
                var hash = this.getUri(),
                    sessionStorage = SessionStorage();
                if (!sessionStorage || sessionStorage.getItem(SESSION_KEY)) {
                    return $.Deferred().resolve().promise()
                }
                sessionStorage.removeItem(SESSION_KEY);
                this._browserAdapter.createRootPage();
                return this._browserAdapter.pushState(hash)
            },
            _onPopState: function() {
                if (this._browserAdapter.isRootPage()) {
                    if (this._rootStateHandler) {
                        this._rootStateHandler()
                    } else {
                        this.backInitiated.fire()
                    }
                } else {
                    if (!this._rootStateHandler) {
                        this._createRootStateHandler()
                    }
                    this.back()
                }
            },
            _createRootStateHandler: function() {
                var uri = this.getUri();
                this._rootStateHandler = function() {
                    this.uriChanged.fire(uri);
                    this._rootStateHandler = null
                }
            }
        });
        exports.HistoryBasedNavigationDevice = HistoryBasedNavigationDevice;
        exports.StackBasedNavigationDevice = StackBasedNavigationDevice
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled/framework/html/presets.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.layoutSets = {};
        exports.animationSets = {
            "native": {
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "none",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            },
            "default": {
                "layout-change": [{
                    animation: "none"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "pop",
                    device: {
                        platform: "android"
                    }
                }, {
                    animation: "openDoor",
                    device: {
                        deviceType: "phone",
                        platform: "win",
                        version: [8]
                    }
                }, {
                    animation: "win-pop",
                    device: {
                        deviceType: "phone",
                        platform: "win"
                    }
                }],
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-content-rendered": [{
                    animation: "fade"
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-top": [{
                    animation: "stagger-fade-drop"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }, {
                    animation: "none",
                    device: {
                        platform: "win",
                        version: [10]
                    }
                }],
                "command-rendered-bottom": [{
                    animation: "stagger-fade-rise"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }, {
                    animation: "none",
                    device: {
                        platform: "win",
                        version: [10]
                    }
                }],
                "list-item-rendered": [{
                    animation: "stagger-3d-drop",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "detail-item-rendered": [{
                    animation: "stagger-3d-drop",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "edit-item-rendered": [{
                    animation: "stagger-3d-drop",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            },
            slide: {
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-content-rendered": [{
                    animation: "fade"
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-top": [{
                    animation: "stagger-fade-drop"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-bottom": [{
                    animation: "stagger-fade-rise"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "list-item-rendered": [{
                    animation: "stagger-fade-slide",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "detail-item-rendered": [{
                    animation: "stagger-fade-slide",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "edit-item-rendered": [{
                    animation: "stagger-fade-slide",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            },
            zoom: {
                "view-content-change": [{
                    animation: "slide"
                }, {
                    animation: "ios7-slide",
                    device: {
                        platform: "ios"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop",
                        platform: "generic"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-content-rendered": [{
                    animation: "fade"
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "view-header-toolbar": [{
                    animation: "ios7-toolbar"
                }, {
                    animation: "slide",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-top": [{
                    animation: "stagger-fade-zoom"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "command-rendered-bottom": [{
                    animation: "stagger-fade-zoom"
                }, {
                    animation: "fade",
                    device: {
                        grade: "B"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "list-item-rendered": [{
                    animation: "stagger-fade-zoom",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "detail-item-rendered": [{
                    animation: "stagger-fade-zoom",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }],
                "edit-item-rendered": [{
                    animation: "stagger-fade-zoom",
                    device: {
                        grade: "A"
                    }
                }, {
                    animation: "fade",
                    device: {
                        deviceType: "desktop"
                    }
                }, {
                    animation: "none",
                    device: {
                        grade: "C"
                    }
                }]
            }
        }
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_query.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 10),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            compileGetter = __webpack_require__( /*! ../core/utils/data */ 23).compileGetter,
            toComparable = __webpack_require__( /*! ../core/utils/data */ 23).toComparable,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 7).Deferred,
            errorsModule = __webpack_require__( /*! ./errors */ 36),
            dataUtils = __webpack_require__( /*! ./utils */ 41);
        var Iterator = Class.inherit({
            toArray: function() {
                var result = [];
                this.reset();
                while (this.next()) {
                    result.push(this.current())
                }
                return result
            },
            countable: function() {
                return false
            }
        });
        var ArrayIterator = Iterator.inherit({
            ctor: function(array) {
                this.array = array;
                this.index = -1
            },
            next: function() {
                if (this.index + 1 < this.array.length) {
                    this.index++;
                    return true
                }
                return false
            },
            current: function() {
                return this.array[this.index]
            },
            reset: function() {
                this.index = -1
            },
            toArray: function() {
                return this.array.slice(0)
            },
            countable: function() {
                return true
            },
            count: function() {
                return this.array.length
            }
        });
        var WrappedIterator = Iterator.inherit({
            ctor: function(iter) {
                this.iter = iter
            },
            next: function() {
                return this.iter.next()
            },
            current: function() {
                return this.iter.current()
            },
            reset: function() {
                return this.iter.reset()
            }
        });
        var MapIterator = WrappedIterator.inherit({
            ctor: function(iter, mapper) {
                this.callBase(iter);
                this.index = -1;
                this.mapper = mapper
            },
            current: function() {
                return this.mapper(this.callBase(), this.index)
            },
            next: function() {
                var hasNext = this.callBase();
                if (hasNext) {
                    this.index++
                }
                return hasNext
            }
        });
        var defaultCompare = function(xValue, yValue) {
            xValue = toComparable(xValue);
            yValue = toComparable(yValue);
            if (null === xValue && null !== yValue) {
                return -1
            }
            if (null !== xValue && null === yValue) {
                return 1
            }
            if (void 0 === xValue && void 0 !== yValue) {
                return 1
            }
            if (void 0 !== xValue && void 0 === yValue) {
                return -1
            }
            if (xValue < yValue) {
                return -1
            }
            if (xValue > yValue) {
                return 1
            }
            return 0
        };
        var SortIterator = Iterator.inherit({
            ctor: function(iter, getter, desc, compare) {
                if (!(iter instanceof MapIterator)) {
                    iter = new MapIterator(iter, this._wrap)
                }
                this.iter = iter;
                this.rules = [{
                    getter: getter,
                    desc: desc,
                    compare: compare
                }]
            },
            thenBy: function(getter, desc, compare) {
                var result = new SortIterator(this.sortedIter || this.iter, getter, desc, compare);
                if (!this.sortedIter) {
                    result.rules = this.rules.concat(result.rules)
                }
                return result
            },
            next: function() {
                this._ensureSorted();
                return this.sortedIter.next()
            },
            current: function() {
                this._ensureSorted();
                return this.sortedIter.current()
            },
            reset: function() {
                delete this.sortedIter
            },
            countable: function() {
                return this.sortedIter || this.iter.countable()
            },
            count: function() {
                if (this.sortedIter) {
                    return this.sortedIter.count()
                }
                return this.iter.count()
            },
            _ensureSorted: function() {
                var that = this;
                if (that.sortedIter) {
                    return
                }
                iteratorUtils.each(that.rules, function() {
                    this.getter = compileGetter(this.getter)
                });
                that.sortedIter = new MapIterator(new ArrayIterator(this.iter.toArray().sort(function(x, y) {
                    return that._compare(x, y)
                })), that._unwrap)
            },
            _wrap: function(record, index) {
                return {
                    index: index,
                    value: record
                }
            },
            _unwrap: function(wrappedItem) {
                return wrappedItem.value
            },
            _compare: function(x, y) {
                var xIndex = x.index,
                    yIndex = y.index;
                x = x.value;
                y = y.value;
                if (x === y) {
                    return xIndex - yIndex
                }
                for (var i = 0, rulesCount = this.rules.length; i < rulesCount; i++) {
                    var rule = this.rules[i],
                        xValue = rule.getter(x),
                        yValue = rule.getter(y),
                        compare = rule.compare || defaultCompare,
                        compareResult = compare(xValue, yValue);
                    if (compareResult) {
                        return rule.desc ? -compareResult : compareResult
                    }
                }
                return xIndex - yIndex
            }
        });
        var compileCriteria = function() {
            var compileGroup = function(crit) {
                var ops = [];
                var isConjunctiveOperator = false;
                var isConjunctiveNextOperator = false;
                iteratorUtils.each(crit, function() {
                    if (Array.isArray(this) || typeUtils.isFunction(this)) {
                        if (ops.length > 1 && isConjunctiveOperator !== isConjunctiveNextOperator) {
                            throw new errorsModule.errors.Error("E4019")
                        }
                        ops.push(compileCriteria(this));
                        isConjunctiveOperator = isConjunctiveNextOperator;
                        isConjunctiveNextOperator = true
                    } else {
                        isConjunctiveNextOperator = dataUtils.isConjunctiveOperator(this)
                    }
                });
                return function(d) {
                    var result = isConjunctiveOperator;
                    for (var i = 0; i < ops.length; i++) {
                        if (ops[i](d) !== isConjunctiveOperator) {
                            result = !isConjunctiveOperator;
                            break
                        }
                    }
                    return result
                }
            };
            var toString = function(value) {
                return typeUtils.isDefined(value) ? value.toString() : ""
            };
            var compileBinary = function(crit) {
                crit = dataUtils.normalizeBinaryCriterion(crit);
                var getter = compileGetter(crit[0]),
                    op = crit[1],
                    value = crit[2];
                value = toComparable(value);
                switch (op.toLowerCase()) {
                    case "=":
                        return compileEquals(getter, value);
                    case "<>":
                        return compileEquals(getter, value, true);
                    case ">":
                        return function(obj) {
                            return toComparable(getter(obj)) > value
                        };
                    case "<":
                        return function(obj) {
                            return toComparable(getter(obj)) < value
                        };
                    case ">=":
                        return function(obj) {
                            return toComparable(getter(obj)) >= value
                        };
                    case "<=":
                        return function(obj) {
                            return toComparable(getter(obj)) <= value
                        };
                    case "startswith":
                        return function(obj) {
                            return 0 === toComparable(toString(getter(obj))).indexOf(value)
                        };
                    case "endswith":
                        return function(obj) {
                            var getterValue = toComparable(toString(getter(obj))),
                                searchValue = toString(value);
                            if (getterValue.length < searchValue.length) {
                                return false
                            }
                            return getterValue.lastIndexOf(value) === getterValue.length - value.length
                        };
                    case "contains":
                        return function(obj) {
                            return toComparable(toString(getter(obj))).indexOf(value) > -1
                        };
                    case "notcontains":
                        return function(obj) {
                            return toComparable(toString(getter(obj))).indexOf(value) === -1
                        }
                }
                throw errorsModule.errors.Error("E4003", op)
            };

            function compileEquals(getter, value, negate) {
                return function(obj) {
                    obj = toComparable(getter(obj));
                    var result = useStrictComparison(value) ? obj === value : obj == value;
                    if (negate) {
                        result = !result
                    }
                    return result
                }
            }

            function useStrictComparison(value) {
                return "" === value || 0 === value || false === value
            }

            function compileUnary(crit) {
                var op = crit[0],
                    criteria = compileCriteria(crit[1]);
                if ("!" === op) {
                    return function(obj) {
                        return !criteria(obj)
                    }
                }
                throw errorsModule.errors.Error("E4003", op)
            }
            return function(crit) {
                if (typeUtils.isFunction(crit)) {
                    return crit
                }
                if (Array.isArray(crit[0])) {
                    return compileGroup(crit)
                }
                if (dataUtils.isUnaryOperation(crit)) {
                    return compileUnary(crit)
                }
                return compileBinary(crit)
            }
        }();
        var FilterIterator = WrappedIterator.inherit({
            ctor: function(iter, criteria) {
                this.callBase(iter);
                this.criteria = compileCriteria(criteria)
            },
            next: function() {
                while (this.iter.next()) {
                    if (this.criteria(this.current())) {
                        return true
                    }
                }
                return false
            }
        });
        var GroupIterator = Iterator.inherit({
            ctor: function(iter, getter) {
                this.iter = iter;
                this.getter = getter
            },
            next: function() {
                this._ensureGrouped();
                return this.groupedIter.next()
            },
            current: function() {
                this._ensureGrouped();
                return this.groupedIter.current()
            },
            reset: function() {
                delete this.groupedIter
            },
            countable: function() {
                return !!this.groupedIter
            },
            count: function() {
                return this.groupedIter.count()
            },
            _ensureGrouped: function() {
                if (this.groupedIter) {
                    return
                }
                var hash = {},
                    keys = [],
                    iter = this.iter,
                    getter = compileGetter(this.getter);
                iter.reset();
                while (iter.next()) {
                    var current = iter.current(),
                        key = getter(current);
                    if (key in hash) {
                        hash[key].push(current)
                    } else {
                        hash[key] = [current];
                        keys.push(key)
                    }
                }
                this.groupedIter = new ArrayIterator(iteratorUtils.map(keys, function(key) {
                    return {
                        key: key,
                        items: hash[key]
                    }
                }))
            }
        });
        var SelectIterator = WrappedIterator.inherit({
            ctor: function(iter, getter) {
                this.callBase(iter);
                this.getter = compileGetter(getter)
            },
            current: function() {
                return this.getter(this.callBase())
            },
            countable: function() {
                return this.iter.countable()
            },
            count: function() {
                return this.iter.count()
            }
        });
        var SliceIterator = WrappedIterator.inherit({
            ctor: function(iter, skip, take) {
                this.callBase(iter);
                this.skip = Math.max(0, skip);
                this.take = Math.max(0, take);
                this.pos = 0
            },
            next: function() {
                if (this.pos >= this.skip + this.take) {
                    return false
                }
                while (this.pos < this.skip && this.iter.next()) {
                    this.pos++
                }
                this.pos++;
                return this.iter.next()
            },
            reset: function() {
                this.callBase();
                this.pos = 0
            },
            countable: function() {
                return this.iter.countable()
            },
            count: function() {
                return Math.min(this.iter.count() - this.skip, this.take)
            }
        });
        var arrayQueryImpl = function arrayQueryImpl(iter, queryOptions) {
            queryOptions = queryOptions || {};
            if (!(iter instanceof Iterator)) {
                iter = new ArrayIterator(iter)
            }
            var handleError = function(error) {
                var handler = queryOptions.errorHandler;
                if (handler) {
                    handler(error)
                }
                errorsModule._errorHandler(error)
            };
            var aggregateCore = function(aggregator) {
                var seed, d = (new Deferred).fail(handleError),
                    step = aggregator.step,
                    finalize = aggregator.finalize;
                try {
                    iter.reset();
                    if ("seed" in aggregator) {
                        seed = aggregator.seed
                    } else {
                        seed = iter.next() ? iter.current() : NaN
                    }
                    var a