"use strict";

var Luci = Luci || {};

Luci.Readonly = function() {
  const readonlyCheckbox = document.querySelectorAll('input[type="checkbox"].luci-form__input--readonly');
  const readonlyRadioButton = document.querySelectorAll('input[type="radio"].luci-form__input--readonly');
  const readonlySelectMenu = document.querySelectorAll('select.luci-form__input--readonly');

  function setCheckedState(el) {
    if (!el.checked) {
      el.checked = true;
    }
  }

  function keepChecked(e) {
    e.preventDefault();
  }

  const init = function init() {
    readonlyCheckbox.forEach(function (el) {
      setCheckedState(el);
      el.addEventListener('click', keepChecked);
    });

    readonlyRadioButton.forEach(function (el) {
      setCheckedState(el);
      el.setAttribute("name", "readonly-" + Math.random() + "");
    });

    readonlySelectMenu.forEach(function (el) {
      el.addEventListener('mousedown', function(e) {
        e.preventDefault();
      });
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Readonly.init();
});
