"use strict";

var Luci = Luci || {};

Luci.Notification = function() {
  const notificationButton = document.querySelectorAll('.luci-notification-button--close');
  const fadeOutClass = 'luci-notification--is-hidden';

  function closeNotificationMessage() {
    const notification = Luci.Utils.getClosestParent(this, '.luci-notification');
    notification.classList.add(fadeOutClass);
    setTimeout(function() {
      notification.style.display = 'none';
    }, 300);
  }

  const init = function init() {
    notificationButton.forEach(function (el) {
      el.addEventListener('click', closeNotificationMessage);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Notification.init();
});
