"use strict";

var Luci = Luci || {};

Luci.DataTable = function() {
  // code goes here
  const selectRowCheckbox = document.querySelectorAll('tbody .luci-checkbox__button'),
        selectedRowClass = 'luci-table__row--selected';

  function toggleSelectedRow(checkbox) {
    const selectedRow = Luci.Utils.getClosestParent(checkbox, '.luci-table__row--select');
    if (selectedRow.classList.contains(selectedRowClass)) {
      selectedRow.classList.remove(selectedRowClass);
    } else {
      selectedRow.classList.add(selectedRowClass);
    }
  }

  function handleSelectedRow() {
    toggleSelectedRow(this);
  }

  const init = function init() {
    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('click', handleSelectedRow);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.DataTable.init();
});
