'use strict';
module.exports = {
    codeNamespace: "luci",
    markupSourceExtension: ".nunjucks",
    copyTasks: [
        {
            name: "script-dependencies",
            sources: ["node_modules/svg4everybody/dist/svg4everybody.min.js",
            "node_modules/dialog-polyfill/dialog-polyfill.js",
            "node_modules/interactjs/dist/interact.min.js"],
            destination: "_site/latest/scripts/dependencies"
        },
        {
            name: "style-dependencies",
            sources: ["node_modules/dialog-polyfill/dialog-polyfill.css"],
            destination: "_site/latest/styles/dependencies"
        }
    ],
    manageNunjucksEnv: function(env) {
        env.addFilter('is_string', function(obj) {
          return typeof obj === 'string';
        });

        env.addFilter('is_array', function(obj) {
          return Array.isArray(obj);
        });

        env.addFilter('is_object', function(obj) {
            return typeof obj === 'object';
        });

        env.addGlobal('getContext', function(name) {
            return name ? this.ctx[name] : this.ctx;
        });
    }
};
