// DO NOT EDIT: This file is automatically generated by the project's build task
// This is where global styles will go
"use strict";
var Luci = Luci || {};
// https://gist.github.com/cferdinandi/277a322cd7d1e898d9ee
Luci.Utils = function() {
  const getClosestParent = function getClosestParent(elem, selector) {
    const firstChar = selector.charAt(0);

    for (; elem && elem !== document; elem = elem.parentNode) {
      if (firstChar === '.') {
        if (elem.classList.contains(selector.substr(1))) {
          return elem;
        }
      } else if (firstChar === '#') {
        if (elem.id === selector.substr(1)) {
          return elem;
        }
      } else if (firstChar === '[') {
        if (elem.hasAttribute(selector.substr(1, selector.length - 1))) {
          return elem;
        }
      }
    }
    return false;
  };

  return {
    getClosestParent: getClosestParent
  };
}();

"use strict";

var Luci = Luci || {};

Luci.Button = function() {
  const buttonToggleIcon = document.querySelectorAll('.luci-button--toggle-icon');

  function toggleButtonIcon(e) {
    e.preventDefault();
    let iconOn = this.dataset.toggleIconOn;
    let iconOff = this.dataset.toggleIconOff;
    let iconElement = this.querySelector('.luci-icon use');
    let currentIcon = iconElement.getAttribute('xlink:href');

    if (currentIcon === '/icons/luci.svg#' + iconOff) {
      iconElement.setAttribute('xlink:href', '/icons/luci.svg#' + iconOn);
    } else {
      iconElement.setAttribute('xlink:href', '/icons/luci.svg#' + iconOff);
    }
  }

  const init = function init() {
    buttonToggleIcon.forEach(function (el) {
      el.addEventListener('click', toggleButtonIcon);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Button.init();
});

"use strict";

var Luci = Luci || {};

Luci.Readonly = function() {
  const readonlyCheckbox = document.querySelectorAll('input[type="checkbox"].luci-form__input--readonly');
  const readonlyRadioButton = document.querySelectorAll('input[type="radio"].luci-form__input--readonly');
  const readonlySelectMenu = document.querySelectorAll('select.luci-form__input--readonly');

  function setCheckedState(el) {
    if (!el.checked) {
      el.checked = true;
    }
  }

  function keepChecked(e) {
    e.preventDefault();
  }

  const init = function init() {
    readonlyCheckbox.forEach(function (el) {
      setCheckedState(el);
      el.addEventListener('click', keepChecked);
    });

    readonlyRadioButton.forEach(function (el) {
      setCheckedState(el);
      el.setAttribute("name", "readonly-" + Math.random() + "");
    });

    readonlySelectMenu.forEach(function (el) {
      el.addEventListener('mousedown', function(e) {
        e.preventDefault();
      });
    });
  };

  return {
    init: init
  };
}();

function luciComboBox() {
    const comboBox = document.querySelectorAll('.luci-form__combo-box'),
        comboBoxInput = document.querySelectorAll('.luci-form__combo-box-input'),
        comboBoxMenu = document.querySelectorAll('.luci-form__combo-box-menu'),
        comboBoxClose = document.querySelectorAll('.luci-form__combo-box-close'),
        comboBoxOpenClass = 'luci-form__combo-box--is-open',
        comboBoxLink = document.querySelectorAll('.luci-form__combo-box .luci-list-group__element--link');

    let i;

    function closeAllComboBoxes() {
        for (i = 0; i < comboBox.length; i++) {
            comboBox[i].classList.remove(comboBoxOpenClass);
        }
        if (comboBoxLink.length) {
            for (i = 0; i < comboBoxLink.length; i++) {
                comboBoxLink[i].blur();
            }
        }
        for (i = 0; i < comboBoxInput.length; i++) {
            comboBoxInput[i].setAttribute('aria-expanded', false);
        }
        for (i = 0; i < comboBoxMenu.length; i++) {
            comboBoxMenu[i].setAttribute('aria-hidden', true);
        }
        for (i = 0; i < comboBoxClose.length; i++) {
            comboBoxClose[i].setAttribute('tabindex', '-1');
        }
    }

    function handleComboBoxInputChange() {
      let target = this.closest('.luci-form__combo-box');
      let menu = target.querySelector('.luci-form__combo-box-menu');
      let closeButton = target.querySelector('.luci-form__combo-box-close');

      closeAllComboBoxes();

      if (this.value.length >= 3) {
          target.classList.add(comboBoxOpenClass);
          this.setAttribute('aria-expanded', true);
          menu.setAttribute('aria-hidden', false);
          closeButton.setAttribute('tabindex', '0');
      }
    }

    comboBoxInput.forEach(function(e){
        e.addEventListener('click', handleComboBoxInputChange);
        e.addEventListener('input', handleComboBoxInputChange);
    });

    function handleComboBoxCloseClick(e) {
        e.preventDefault();
        e.stopPropagation();
        let target = this.closest('.luci-form__combo-box');
        let targetInput = target.querySelector('.luci-form__combo-box-input');
        targetInput.value = '';
        targetInput.focus();
        closeAllComboBoxes();
    }

    comboBoxClose.forEach(function(e){
      e.addEventListener('click', handleComboBoxCloseClick);
    });

    function handleComboBoxLinkClick(e) {
        e.preventDefault();
        e.stopPropagation();
        let target = this.closest('.luci-form__combo-box');
        let targetInput = target.querySelector('.luci-form__combo-box-input');
        let newText = this.textContent.trim();

        targetInput.value = newText;
        closeAllComboBoxes();
    }

    comboBoxLink.forEach(function(e){
      e.addEventListener('click', handleComboBoxLinkClick);
    });

    //Stop Propagation on Combo Box Input and Content elements
    for (i = 0; i < comboBoxInput.length; i++) {
        comboBoxInput[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < comboBoxMenu.length; i++) {
        comboBoxMenu[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Comboboxes on body click
    document.addEventListener('click', function(event) {
      closeAllComboBoxes();
    });

    function handleDocumentKeydown(e) {
        //Esc key pressed
        if (e.keyCode === 27) {
            closeAllComboBoxes();
        }
    }

    document.addEventListener('keydown', handleDocumentKeydown);
}

document.addEventListener('DOMContentLoaded', function() {
  Luci.Readonly.init();
  luciComboBox();
});

"use strict";

function luciMenu() {
    const menuObject = document.querySelectorAll('.luci-menu'),
        menuButton = document.querySelectorAll('.luci-menu__trigger'),
        menuContent = document.querySelectorAll('.luci-menu__content'),
        menuOpenClass = 'luci-menu--is-open',
        menuLink = document.querySelectorAll('.luci-menu .luci-link');

    var i;

    function closeAllMenus() {
        for (i = 0; i < menuObject.length; i++) {
            menuObject[i].classList.remove(menuOpenClass);
        }
        if (menuLink.length) {
            for (i = 0; i < menuLink.length; i++) {
                menuLink[i].blur();
            }
        }
        for (i = 0; i < menuButton.length; i++) {
            menuButton[i].setAttribute('aria-expanded', false);
        }
        for (i = 0; i < menuContent.length; i++) {
            menuContent[i].setAttribute('aria-hidden', true);
        }
    }

    function toggleMenu(menu) {
        var target = menu.closest('.luci-menu');
        var content = target.querySelector('.luci-menu__content');

        if (target.classList.contains(menuOpenClass)) {
            closeAllMenus();
        } else {
            closeAllMenus();
            target.classList.add(menuOpenClass);
            menu.setAttribute('aria-expanded', true);
            content.setAttribute('aria-hidden', false);
        }
    }

    function handleMenuButtonClick(e) {
        e.preventDefault();
        toggleMenu(this);
    }

    menuButton.forEach(function(e){
        e.addEventListener('click', handleMenuButtonClick);
    });

    //Stop Propagation on Menu Button and Content elements
    for (i = 0; i < menuButton.length; i++) {
        menuButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < menuContent.length; i++) {
        menuContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Menus on body click
    document.addEventListener('click', function(event) {
      closeAllMenus();
    });

    function handleDocumentKeydown(e) {
        //Esc key pressed
        if (e.keyCode === 27) {
            closeAllMenus();
        }
    }

    document.addEventListener('keydown', handleDocumentKeydown);
}

document.addEventListener('DOMContentLoaded', function() {
    luciMenu();
});

"use strict";

var Luci = Luci || {};

Luci.Notification = function() {
  const notificationButton = document.querySelectorAll('.luci-notification__button--close');
  const fadeOutClass = 'luci-notification--is-hidden';

  function closeNotificationMessage() {
    const notification = Luci.Utils.getClosestParent(this, '.luci-notification');
    notification.classList.add(fadeOutClass);
    setTimeout(function() {
      notification.style.display = 'none';
    }, 300);
  }

  const init = function init() {
    notificationButton.forEach(function (el) {
      el.addEventListener('click', closeNotificationMessage);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Notification.init();
});

"use strict";

function luciPopover() {
    const popoverButton = document.querySelectorAll('.luci-popover__button'),
        popoverObject = document.querySelectorAll('.luci-popover'),
        popoverContent = document.querySelectorAll('.luci-popover__content'),
        popoverOpenClass = 'luci-popover--is-open',
        popoverCheckbox = document.querySelectorAll('.luci-popover .luci-checkbox__label input[type="checkbox"]'),
        popoverLink = document.querySelectorAll('.luci-popover__list-item .luci-link');

    var i;

    function closeAllPopovers() {
        for (i = 0; i < popoverObject.length; i++) {
            popoverObject[i].classList.remove(popoverOpenClass);
        }
        if (popoverCheckbox.length) {
            for (i = 0; i < popoverCheckbox.length; i++) {
                popoverCheckbox[i].blur();
            }
        }
        if (popoverLink.length) {
            for (i = 0; i < popoverLink.length; i++) {
                popoverLink[i].blur();
            }
        }
    }

    function togglePopover(popover) {
        var target = popover.closest('.luci-popover');

        if (target.classList.contains(popoverOpenClass)) {
            closeAllPopovers();
        } else {
            closeAllPopovers();
            target.classList.add(popoverOpenClass);
        }
    }

    function handlePopoverButtonClick() {
        togglePopover(this);
    }

    popoverButton.forEach(function(t){
        t.addEventListener('click', handlePopoverButtonClick);
    });

    //Close All Popovers on esc key press
    document.onkeydown = function(e) {
        e = e || window.event;
        var isEscape = false;
        if ("key" in e) {
            isEscape = e.key === "Escape" || e.key === "Esc";
        } else {
            isEscape = e.keyCode === 27;
        }
        if (isEscape) {
            closeAllPopovers();
        }
    };

    //Stop Propagation on Popover Button and Content elements
    for (i = 0; i < popoverButton.length; i++) {
        popoverButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < popoverContent.length; i++) {
        popoverContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Popovers on body click
    document.addEventListener('click', function(event) {
      closeAllPopovers();
    });
}

document.addEventListener('DOMContentLoaded', function() {
    luciPopover();
});

"use strict";

var Luci = Luci || {};

Luci.Tabs = function() {
  const tabNavLinks = document.querySelectorAll('.luci-tab__nav .luci-tab__list-item');
  const nestedTabTitles = document.querySelectorAll('.luci-tab__list--nested .luci-tab__list-item');
  const tabTitleActiveClass = 'luci-tab__list-item--is-active';
  const tabPanelActiveClass = 'luci-tab__panel--is-active';

  function updateLinkAttributes(tabTitle) {
    const tabLink = tabTitle.querySelector('.luci-link');
    tabLink.setAttribute("aria-selected", false);
    tabLink.setAttribute("tab-index", "-1");
  }

  function closeAllTabs(tabTitles, tabPanels) {
    tabTitles.forEach(function (tabTitle) {
      updateLinkAttributes(tabTitle);
      tabTitle.classList.remove(tabTitleActiveClass);
    });

    tabPanels.forEach(function (tabPanel) {
      tabPanel.classList.remove(tabPanelActiveClass);
    });
  }

  function setLinkAttributes(tabTitle) {
    const tabLink = tabTitle.querySelector('.luci-link');

    tabLink.setAttribute("aria-selected", true);
    tabLink.setAttribute("tab-index", "0");
  }

  function openTab(event) {
    event.preventDefault();
    const tabId = this.querySelector('.luci-link').getAttribute('href');
    const tabPanel = document.querySelector(tabId + '.luci-tab__panel');
    const tab = Luci.Utils.getClosestParent(this, '.luci-tab');
    const tabTitles = tab.querySelectorAll('.luci-tab__list-item');
    const tabPanels = tab.querySelectorAll('.luci-tab__panel, .luci-tab__panel--nested');

    closeAllTabs(tabTitles, tabPanels);
    setLinkAttributes(this);
    this.classList.add(tabTitleActiveClass);
    tabPanel.classList.add(tabPanelActiveClass);

    if (tabPanel.querySelector('.luci-tab__panel--nested')) {
      const firstNestedTabListItem = tabPanel.querySelector('.luci-tab__list--nested .luci-tab__list-item');
      const firstNestedTabPanel = tabPanel.querySelector('.luci-tab__panel--nested');
      firstNestedTabListItem.classList.add(tabTitleActiveClass);
      firstNestedTabPanel.classList.add(tabPanelActiveClass);
    }
  }

  function openNestedTab(event) {
    event.preventDefault();
    const tabId = this.querySelector('.luci-link').getAttribute('href');
    const tabPanel = document.querySelector(tabId + '.luci-tab__panel--nested');
    const tab = Luci.Utils.getClosestParent(this, '.luci-tab__panel');
    const tabTitles = tab.querySelectorAll('.luci-tab__list-item');
    const tabPanels = tab.querySelectorAll('.luci-tab__panel--nested');

    closeAllTabs(tabTitles, tabPanels);
    setLinkAttributes(this);
    this.classList.add(tabTitleActiveClass);
    tabPanel.classList.add(tabPanelActiveClass);
  }

  const init = function init() {
    tabNavLinks.forEach(function (tabTitle) {
      setLinkAttributes(tabTitle);
      tabTitle.addEventListener('click', openTab);
    });

    nestedTabTitles.forEach(function (tabTitle) {
      setLinkAttributes(tabTitle);
      tabTitle.addEventListener('click', openNestedTab);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function () {
  Luci.Tabs.init();
});

"use strict";

var Luci = Luci || {};

Luci.DataTable = function() {
  // code goes here
  const selectRowCheckbox = document.querySelectorAll('tbody .luci-checkbox__label input'),
        selectHeadCheckbox = document.querySelectorAll('thead .luci-checkbox__label input'),
        selectedRowClass = 'luci-table__row--selected',
        expanableRowAction = document.querySelectorAll('.luci-table--expand-button'),
        inlineAction = document.querySelectorAll('.luci-list-group__element--table-inline-action'),
        inlineActionEdit = document.querySelectorAll('.luci-table__action--inline-edit'),
        inlineActionDelete = document.querySelectorAll('.luci-table__action--inline-delete'),
        inlineActionClone = document.querySelectorAll('.luci-table__action--inline-clone'),
        inlineEditButtonSave = document.querySelectorAll('.luci-button--inline-edit-success'),
        inlineEditButtonCancel = document.querySelectorAll('.luci-button--inline-edit-close'),
        editModeRowClass = 'luci-table__row--edit-mode';

  function toggleSelectedRow(checkbox) {
    const selectedRow = Luci.Utils.getClosestParent(checkbox, '.luci-table__row--select');
    if (selectedRow.classList.contains(selectedRowClass)) {
      selectedRow.classList.remove(selectedRowClass);
    } else {
      selectedRow.classList.add(selectedRowClass);
    }
  }

  function handleSelectedRow() {
    toggleSelectedRow(this);
  }

  function handleToggleAllRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let targetRows = targetTable.querySelectorAll('tbody tr');

    if (this.checked === true) {
      targetCheckboxes.forEach(function (el) {
        el.checked = true;
      });
      targetRows.forEach(function (el) {
        el.classList.add(selectedRowClass);
      });
    } else {
      targetCheckboxes.forEach(function (el) {
        el.checked = false;
      });
      targetRows.forEach(function (el) {
        el.classList.remove(selectedRowClass);
      });
    }
  }

  function watchCheckedRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let toggleAllCheckboxes = targetTable.querySelector('thead .luci-checkbox__label input');
    let totalCheckboxes = targetCheckboxes.length;
    let totalChecked = 0;

    targetCheckboxes.forEach(function (el) {
      if (el.checked === true) {
        totalChecked += 1;
      }
    });

    if (totalChecked === totalCheckboxes) {
      toggleAllCheckboxes.checked = true;
    } else {
      toggleAllCheckboxes.checked = false;
    }
  }

  function handleExpandableRow() {
    let expandable_row = this.closest('.luci-table__row--expandable');
    let child_row = expandable_row.nextElementSibling;

    if (expandable_row.classList.contains('luci-table__row--is-expanded')) {
      expandable_row.classList.remove('luci-table__row--is-expanded');
      child_row.classList.remove('luci-table__row--is-expanded');
    } else {
      expandable_row.classList.add('luci-table__row--is-expanded');
    }
  }

  function handleInlineAction(e) {
    e.preventDefault();
    let menu = this.closest('.luci-menu');
    let menuTrigger = menu.querySelector('.luci-menu__trigger');

    menuTrigger.click();
  }

  function handleInlineActionEdit() {
    let row = this.closest('tr');
    let editableCells = row.querySelectorAll('.luci-table__cell--inline-edit');
    let radioCells = row.querySelectorAll('.luci-table__cell--inline-edit-radio');
    let saveButton = row.querySelector('.luci-button--inline-edit-success');
    let cancelButton = row.querySelector('.luci-button--inline-edit-close');

    function handleInlineEdit(e) {
      if (e.keyCode === 13) {
        saveButton.click();
      }
      if (e.keyCode === 27) {
        cancelButton.click();
      }
    }

    if (!row.classList.contains(editModeRowClass)) {
      row.classList.add(editModeRowClass);

      editableCells.forEach(function (el) {
        let oldText = el.textContent.trim();

        el.dataset.oldText = oldText;

        el.innerHTML = '<input type="text" name="small" class="luci-form__input luci-form__input--sm" value="' + oldText + '">';
      });

      let inlineEdit = row.querySelectorAll('.luci-table__cell--inline-edit .luci-form__input');

      inlineEdit.forEach(function (el) {
        el.addEventListener('keyup', handleInlineEdit);
      });

      inlineEdit[0].focus();
      inlineEdit[0].select();

      radioCells.forEach(function (el) {
        let oldValue = el.querySelector('span').textContent.trim();
        let randomIdOn = Math.floor(Math.random() * 3000);
        let randomIdOff = Math.floor(Math.random() * 3000);
        let onIsCheked = oldValue === "ON" ? "checked" : null;
        let offIsCheked = oldValue === "OFF" ? "checked" : null;

        el.dataset.oldValue = oldValue;

        el.innerHTML = `
          <span class="luci-form__radio">
            <label for="luci-input-on-` + randomIdOn + `" class="luci-radio__label">
              <input class="luci-table__radio" type="radio" name="options-` + randomIdOn + `" id="luci-input-on-` + randomIdOn + `" value="ON" ` + onIsCheked + `>
              <span class="luci-radio__button"></span>
              <span class="luci-radio__label-text">On</span>
            </label>
          </span>
          <span class="luci-form__radio">
            <label for="luci-input-off-` + randomIdOff + `" class="luci-radio__label">
              <input class="luci-table__radio" type="radio" name="options-` + randomIdOn + `" id="luci-input-off-` + randomIdOff + `" value="OFF" ` + offIsCheked + `>
              <span class="luci-radio__button"></span>
              <span class="luci-radio__label-text">Off</span>
            </label>
          </span>
        `;
      });

      let inlineRadio = row.querySelectorAll('.luci-table__cell--inline-edit-radio .luci-table__radio');

      inlineRadio.forEach(function (el) {
        el.addEventListener('keyup', handleInlineEdit);
      });
    }
  }

  function handleInlineEditButtonSave() {
    let row = this.closest('tr');
    let editableCells = row.querySelectorAll('.luci-table__cell--inline-edit');
    let radioCells = row.querySelectorAll('.luci-table__cell--inline-edit-radio');

    row.classList.remove(editModeRowClass);

    editableCells.forEach(function (el) {
      let newText = el.querySelector('.luci-form__input').value;

      el.innerHTML = newText;

      el.removeAttribute('data-old-text');
    });

    radioCells.forEach(function (el) {
      let newValue = el.querySelector('.luci-table__radio:checked').value;

      el.innerHTML = "<span>" + newValue + "</span> | <a href='#'>Action</a>";

      el.removeAttribute('data-old-value');
    });
  }

  function handleInlineEditButtonCancel() {
    let row = this.closest('tr');
    let editableCells = row.querySelectorAll('.luci-table__cell--inline-edit');
    let radioCells = row.querySelectorAll('.luci-table__cell--inline-edit-radio');

    row.classList.remove(editModeRowClass);

    editableCells.forEach(function (el) {
      let oldText = el.dataset.oldText;

      el.innerHTML = oldText;

      el.removeAttribute('data-old-text');
    });

    radioCells.forEach(function (el) {
      el.innerHTML = "<span>" + el.dataset.oldValue + "</span> | <a href='#'>Action</a>";

      el.removeAttribute('data-old-value');
    });
  }

  function handleInlineActionDelete() {
    let row = this.closest('tr');

    row.classList.add('luci-table__row--fadeout');

    setTimeout(function(){
        row.remove();
    }, 500);
  }

  function handleInlineActionClone() {
    let row = this.closest('tr');
    let newClone = row.cloneNode(true);

    newClone.classList.add('luci-table__row--fadein');

    row.parentNode.insertBefore(newClone, row.nextSibling);

    const inlineActionEditClone = newClone.querySelector('.luci-table__action--inline-edit'),
        inlineActionDeleteClone = newClone.querySelector('.luci-table__action--inline-delete'),
        inlineActionCloneClone = newClone.querySelector('.luci-table__action--inline-clone'),
        inlineEditButtonSaveClone = newClone.querySelector('.luci-button--inline-edit-success'),
        inlineEditButtonCancelClone = newClone.querySelector('.luci-button--inline-edit-close');

    inlineActionEditClone.addEventListener('click', handleInlineActionEdit);
    inlineEditButtonSaveClone.addEventListener('click', handleInlineEditButtonSave);
    inlineEditButtonCancelClone.addEventListener('click', handleInlineEditButtonCancel);
    inlineActionDeleteClone.addEventListener('click', handleInlineActionDelete);
    inlineActionCloneClone.addEventListener('click', handleInlineActionClone);
  }

  const init = function init() {
    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('click', handleSelectedRow);
    });

    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('change', watchCheckedRows);
    });

    selectHeadCheckbox.forEach(function (el) {
      el.addEventListener('change', handleToggleAllRows);
    });

    expanableRowAction.forEach(function (el) {
      el.addEventListener('click', handleExpandableRow);
    });

    inlineAction.forEach(function (el) {
      el.addEventListener('click', handleInlineAction);
    });

    inlineActionEdit.forEach(function (el) {
      el.addEventListener('click', handleInlineActionEdit);
    });

    inlineEditButtonSave.forEach(function (el) {
      el.addEventListener('click', handleInlineEditButtonSave);
    });

    inlineEditButtonCancel.forEach(function (el) {
      el.addEventListener('click', handleInlineEditButtonCancel);
    });

    inlineActionDelete.forEach(function (el) {
      el.addEventListener('click', handleInlineActionDelete);
    });

    inlineActionClone.forEach(function (el) {
      el.addEventListener('click', handleInlineActionClone);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.DataTable.init();
});

"use strict";

function luciTooltip() {
    const clickableTooltips = document.querySelectorAll('.luci-tooltip'),
            tooltipVisibleClass = 'luci-tooltip--visible';

    function toggleTooltipVisibility(tooltip) {
        if (tooltip.classList.contains(tooltipVisibleClass)) {
            tooltip.classList.remove(tooltipVisibleClass);
        } else {
            tooltip.classList.add(tooltipVisibleClass);
        }
    }

    function handleClickableTooltipClick() {
        toggleTooltipVisibility(this);
    }

    clickableTooltips.forEach(function(t){
        t.addEventListener('click', handleClickableTooltipClick);
    });
}

document.addEventListener('DOMContentLoaded', function() {
    luciTooltip();
});

"use strict";

var Luci = Luci || {};

Luci.Dialog = function() {
  const modalButtonToggle = document.querySelectorAll("[data-luci-toggle='modal']");
  const modalButtonDismiss = document.querySelectorAll("[data-luci-dismiss='modal']");
  const modalDialog = document.querySelector("dialog:not([luci-dialog--non-modal])");

  function dragModal(modalWindow) {
    // http://interactjs.io/
    /* eslint no-unused-vars: 0, no-undef: 0 */
    interact(modalWindow).draggable({
      allowFrom: '.luci-dialog__content',
      onmove: dragMoveListener,
      onend: function(event) {
        modalWindow.classList.remove('luci-dialog--is-dragging');
      }
    });
  }

  function dragMoveListener(event) {
    let target = event.target,
        x = (parseFloat(target.getAttribute('data-luci-x')) || 0) + event.dx,
        y = (parseFloat(target.getAttribute('data-luci-y')) || 0) + event.dy;

    target.style.webkitTransform = target.style.transform = 'translate(' + x + 'px, ' + y + 'px)';
    target.setAttribute('data-luci-x', x);
    target.setAttribute('data-luci-y', y);
    target.classList.add('luci-dialog--is-dragging');
  }

  function closeModal() {
    const modalWindow = Luci.Utils.getClosestParent(this, '.luci-dialog');
    modalWindow.setAttribute('aria-hidden', 'true');
    modalWindow.close();
  }

  function showModal() {
    const modalId = this.dataset.luciTarget;
    const modalWindow = document.querySelector(modalId);
    // Polyfill dialog element https://github.com/GoogleChrome/dialog-polyfill
    dialogPolyfill.registerDialog(modalWindow);
    modalWindow.setAttribute('aria-hidden', 'false');
    if (modalWindow.classList.contains('luci-dialog--non-modal')) {
      modalWindow.show();
      // Enable drag on non-modal
      dragModal(modalWindow);
    } else {
      modalWindow.showModal();
    }
  }

  const init = function init() {
    modalButtonToggle.forEach(function (el) {
      el.addEventListener('click', showModal);
    });

    modalButtonDismiss.forEach(function (el) {
      el.addEventListener('click', closeModal);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Dialog.init();
});
