"use strict";

var Luci = Luci || {};

Luci.Dialog = function() {
  const modalButtonToggle = document.querySelectorAll("[data-luci-toggle='modal']");
  const modalButtonDismiss = document.querySelectorAll("[data-luci-dismiss='modal']");
  const modalDialog = document.querySelector("dialog:not([luci-dialog--non-modal])");

  function dragModal(modalWindow) {
    // http://interactjs.io/
    /* eslint no-unused-vars: 0, no-undef: 0 */
    interact(modalWindow).draggable({
      allowFrom: '.luci-dialog__content',
      onmove: dragMoveListener,
      onend: function(event) {
        modalWindow.classList.remove('luci-dialog--is-dragging');
      }
    });
  }

  function dragMoveListener(event) {
    let target = event.target,
        x = (parseFloat(target.getAttribute('data-luci-x')) || 0) + event.dx,
        y = (parseFloat(target.getAttribute('data-luci-y')) || 0) + event.dy;

    target.style.webkitTransform = target.style.transform = 'translate(' + x + 'px, ' + y + 'px)';
    target.setAttribute('data-luci-x', x);
    target.setAttribute('data-luci-y', y);
    target.classList.add('luci-dialog--is-dragging');
  }

  function closeModal() {
    const modalWindow = Luci.Utils.getClosestParent(this, '.luci-dialog');
    modalWindow.setAttribute('aria-hidden', 'true');
    modalWindow.close();
  }

  function showModal() {
    const modalId = this.dataset.luciTarget;
    const modalWindow = document.querySelector(modalId);
    // Polyfill dialog element https://github.com/GoogleChrome/dialog-polyfill
    dialogPolyfill.registerDialog(modalWindow);
    modalWindow.setAttribute('aria-hidden', 'false');
    if (modalWindow.classList.contains('luci-dialog--non-modal')) {
      modalWindow.show();
      // Enable drag on non-modal
      dragModal(modalWindow);
    } else {
      modalWindow.showModal();
    }
  }

  const init = function init() {
    modalButtonToggle.forEach(function (el) {
      el.addEventListener('click', showModal);
    });

    modalButtonDismiss.forEach(function (el) {
      el.addEventListener('click', closeModal);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Dialog.init();
});
