"use strict";

function luciPopover() {
    const popoverButton = document.querySelectorAll('.luci-popover__button'),
        popoverObject = document.querySelectorAll('.luci-popover'),
        popoverContent = document.querySelectorAll('.luci-popover__content'),
        popoverOpenClass = 'luci-popover--is-open',
        popoverCheckbox = document.querySelectorAll('.luci-popover .luci-checkbox__label input[type="checkbox"]'),
        popoverLink = document.querySelectorAll('.luci-popover__list-item .luci-link');

    var i;

    function closeAllPopovers() {
        for (i = 0; i < popoverObject.length; i++) {
            popoverObject[i].classList.remove(popoverOpenClass);
        }
        if (popoverCheckbox.length) {
            for (i = 0; i < popoverCheckbox.length; i++) {
                popoverCheckbox[i].blur();
            }
        }
        if (popoverLink.length) {
            for (i = 0; i < popoverLink.length; i++) {
                popoverLink[i].blur();
            }
        }
    }

    function togglePopover(popover) {
        var target = popover.closest('.luci-popover');

        if (target.classList.contains(popoverOpenClass)) {
            closeAllPopovers();
        } else {
            closeAllPopovers();
            target.classList.add(popoverOpenClass);
        }
    }

    function handlePopoverButtonClick() {
        togglePopover(this);
    }

    popoverButton.forEach(function(t){
        t.addEventListener('click', handlePopoverButtonClick);
    });

    //Close All Popovers on esc key press
    document.onkeydown = function(e) {
        e = e || window.event;
        var isEscape = false;
        if ("key" in e) {
            isEscape = e.key === "Escape" || e.key === "Esc";
        } else {
            isEscape = e.keyCode === 27;
        }
        if (isEscape) {
            closeAllPopovers();
        }
    };

    //Stop Propagation on Popover Button and Content elements
    for (i = 0; i < popoverButton.length; i++) {
        popoverButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < popoverContent.length; i++) {
        popoverContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Popovers on body click
    document.addEventListener('click', function(event) {
      closeAllPopovers();
    });
}

document.addEventListener('DOMContentLoaded', function() {
    luciPopover();
});
