"use strict";

var Luci = Luci || {};

Luci.DataTable = function() {
  // code goes here
  const selectRowCheckbox = document.querySelectorAll('tbody .luci-checkbox__label input'),
        selectHeadCheckbox = document.querySelectorAll('thead .luci-checkbox__label input'),
        selectedRowClass = 'luci-table__row--selected',
        expanableRowAction = document.querySelectorAll('.luci-table--expand-button');

  function toggleSelectedRow(checkbox) {
    const selectedRow = Luci.Utils.getClosestParent(checkbox, '.luci-table__row--select');
    if (selectedRow.classList.contains(selectedRowClass)) {
      selectedRow.classList.remove(selectedRowClass);
    } else {
      selectedRow.classList.add(selectedRowClass);
    }
  }

  function handleSelectedRow() {
    toggleSelectedRow(this);
  }

  function handleToggleAllRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let targetRows = targetTable.querySelectorAll('tbody tr');

    if (this.checked === true) {
      targetCheckboxes.forEach(function (el) {
        el.checked = true;
      });
      targetRows.forEach(function (el) {
        el.classList.add(selectedRowClass);
      });
    } else {
      targetCheckboxes.forEach(function (el) {
        el.checked = false;
      });
      targetRows.forEach(function (el) {
        el.classList.remove(selectedRowClass);
      });
    }
  }

  function watchCheckedRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let toggleAllCheckboxes = targetTable.querySelector('thead .luci-checkbox__label input');
    let totalCheckboxes = targetCheckboxes.length;
    let totalChecked = 0;

    targetCheckboxes.forEach(function (el) {
      if (el.checked === true) {
        totalChecked += 1;
      }
    });

    if (totalChecked === totalCheckboxes) {
      toggleAllCheckboxes.checked = true;
    } else {
      toggleAllCheckboxes.checked = false;
    }
  }

  function handleExpandableRow() {
    let expandable_row = this.closest('.luci-table__row--expandable');
    let child_row = expandable_row.nextElementSibling;

    if (expandable_row.classList.contains('luci-table__row--is-expanded')) {
      expandable_row.classList.remove('luci-table__row--is-expanded');
      child_row.classList.remove('luci-table__row--is-expanded');
    } else {
      expandable_row.classList.add('luci-table__row--is-expanded');
    }
  }

  const init = function init() {
    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('click', handleSelectedRow);
    });

    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('change', watchCheckedRows);
    });

    selectHeadCheckbox.forEach(function (el) {
      el.addEventListener('change', handleToggleAllRows);
    });

    expanableRowAction.forEach(function (el) {
      el.addEventListener('click', handleExpandableRow);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.DataTable.init();
});
