// DO NOT EDIT: This file is automatically generated by the project's build task
// This is where global styles will go
"use strict";
var Luci = Luci || {};
// https://gist.github.com/cferdinandi/277a322cd7d1e898d9ee
Luci.Utils = function() {
  const getClosestParent = function getClosestParent(elem, selector) {
    const firstChar = selector.charAt(0);

    for (; elem && elem !== document; elem = elem.parentNode) {
      if (firstChar === '.') {
        if (elem.classList.contains(selector.substr(1))) {
          return elem;
        }
      } else if (firstChar === '#') {
        if (elem.id === selector.substr(1)) {
          return elem;
        }
      } else if (firstChar === '[') {
        if (elem.hasAttribute(selector.substr(1, selector.length - 1))) {
          return elem;
        }
      }
    }
    return false;
  };

  return {
    getClosestParent: getClosestParent
  };
}();

"use strict";

var Luci = Luci || {};

Luci.Dialog = function() {
  const modalButtonToggle = document.querySelectorAll("[data-luci-toggle='modal']");
  const modalButtonDismiss = document.querySelectorAll("[data-luci-dismiss='modal']");
  const modalDialog = document.querySelector("dialog:not([luci-dialog--non-modal])");

  function dragModal(modalWindow) {
    // http://interactjs.io/
    /* eslint no-unused-vars: 0, no-undef: 0 */
    interact(modalWindow).draggable({
      allowFrom: '.luci-dialog__content',
      onmove: dragMoveListener,
      onend: function(event) {
        modalWindow.classList.remove('luci-dialog--is-dragging');
      }
    });
  }

  function dragMoveListener(event) {
    let target = event.target,
        x = (parseFloat(target.getAttribute('data-luci-x')) || 0) + event.dx,
        y = (parseFloat(target.getAttribute('data-luci-y')) || 0) + event.dy;

    target.style.webkitTransform = target.style.transform = 'translate(' + x + 'px, ' + y + 'px)';
    target.setAttribute('data-luci-x', x);
    target.setAttribute('data-luci-y', y);
    target.classList.add('luci-dialog--is-dragging');
  }

  function closeModal() {
    const modalWindow = Luci.Utils.getClosestParent(this, '.luci-dialog');
    modalWindow.setAttribute('aria-hidden', 'true');
    modalWindow.close();
  }

  function showModal() {
    const modalId = this.dataset.luciTarget;
    const modalWindow = document.querySelector(modalId);
    // Polyfill dialog element https://github.com/GoogleChrome/dialog-polyfill
    dialogPolyfill.registerDialog(modalWindow);
    modalWindow.setAttribute('aria-hidden', 'false');
    if (modalWindow.classList.contains('luci-dialog--non-modal')) {
      modalWindow.show();
      // Enable drag on non-modal
      dragModal(modalWindow);
    } else {
      modalWindow.showModal();
    }
  }

  const init = function init() {
    modalButtonToggle.forEach(function (el) {
      el.addEventListener('click', showModal);
    });

    modalButtonDismiss.forEach(function (el) {
      el.addEventListener('click', closeModal);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Dialog.init();
});

"use strict";

var Luci = Luci || {};

Luci.Readonly = function() {
  const readonlyCheckbox = document.querySelectorAll('input[type="checkbox"].luci-form__input--readonly');
  const readonlyRadioButton = document.querySelectorAll('input[type="radio"].luci-form__input--readonly');
  const readonlySelectMenu = document.querySelectorAll('select.luci-form__input--readonly');

  function setCheckedState(el) {
    if (!el.checked) {
      el.checked = true;
    }
  }

  function keepChecked(e) {
    e.preventDefault();
  }

  const init = function init() {
    readonlyCheckbox.forEach(function (el) {
      setCheckedState(el);
      el.addEventListener('click', keepChecked);
    });

    readonlyRadioButton.forEach(function (el) {
      setCheckedState(el);
      el.setAttribute("name", "readonly-" + Math.random() + "");
    });

    readonlySelectMenu.forEach(function (el) {
      el.addEventListener('mousedown', function(e) {
        e.preventDefault();
      });
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Readonly.init();
});

"use strict";

function luciMenu() {
    const menuObject = document.querySelectorAll('.luci-menu'),
        menuButton = document.querySelectorAll('.luci-menu__trigger'),
        menuContent = document.querySelectorAll('.luci-menu__content'),
        menuOpenClass = 'luci-menu--is-open',
        menuLink = document.querySelectorAll('.luci-menu .luci-link');

    var i;

    function closeAllMenus() {
        for (i = 0; i < menuObject.length; i++) {
            menuObject[i].classList.remove(menuOpenClass);
        }
        if (menuLink.length) {
            for (i = 0; i < menuLink.length; i++) {
                menuLink[i].blur();
            }
        }
        for (i = 0; i < menuButton.length; i++) {
            menuButton[i].setAttribute('aria-expanded', false);
        }
        for (i = 0; i < menuContent.length; i++) {
            menuContent[i].setAttribute('aria-hidden', true);
        }
    }

    function toggleMenu(menu) {
        var target = menu.closest('.luci-menu');
        var content = target.querySelector('.luci-menu__content');

        if (target.classList.contains(menuOpenClass)) {
            closeAllMenus();
        } else {
            closeAllMenus();
            target.classList.add(menuOpenClass);
            menu.setAttribute('aria-expanded', true);
            content.setAttribute('aria-hidden', false);
        }
    }

    function handleMenuButtonClick(e) {
        e.preventDefault();
        toggleMenu(this);
    }

    menuButton.forEach(function(e){
        e.addEventListener('click', handleMenuButtonClick);
    });

    //Stop Propagation on Menu Button and Content elements
    for (i = 0; i < menuButton.length; i++) {
        menuButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < menuContent.length; i++) {
        menuContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Menus on body click
    document.addEventListener('click', function(event) {
      closeAllMenus();
    });

    function handleDocumentKeydown(e) {
        //Esc key pressed
        if (e.keyCode === 27) {
            closeAllMenus();
        }
    }

    document.addEventListener('keydown', handleDocumentKeydown);
}

document.addEventListener('DOMContentLoaded', function() {
    luciMenu();
});

"use strict";

var Luci = Luci || {};

Luci.Notification = function() {
  const notificationButton = document.querySelectorAll('.luci-notification-button--close');
  const fadeOutClass = 'luci-notification--is-hidden';

  function closeNotificationMessage() {
    const notification = Luci.Utils.getClosestParent(this, '.luci-notification');
    notification.classList.add(fadeOutClass);
    setTimeout(function() {
      notification.style.display = 'none';
    }, 300);
  }

  const init = function init() {
    notificationButton.forEach(function (el) {
      el.addEventListener('click', closeNotificationMessage);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Notification.init();
});

"use strict";

var Luci = Luci || {};

Luci.DataTable = function() {
  // code goes here
  const selectRowCheckbox = document.querySelectorAll('tbody .luci-checkbox__label input'),
        selectHeadCheckbox = document.querySelectorAll('thead .luci-checkbox__label input'),
        selectedRowClass = 'luci-table__row--selected',
        expanableRowAction = document.querySelectorAll('.luci-table--expand-button');

  function toggleSelectedRow(checkbox) {
    const selectedRow = Luci.Utils.getClosestParent(checkbox, '.luci-table__row--select');
    if (selectedRow.classList.contains(selectedRowClass)) {
      selectedRow.classList.remove(selectedRowClass);
    } else {
      selectedRow.classList.add(selectedRowClass);
    }
  }

  function handleSelectedRow() {
    toggleSelectedRow(this);
  }

  function handleToggleAllRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let targetRows = targetTable.querySelectorAll('tbody tr');

    if (this.checked === true) {
      targetCheckboxes.forEach(function (el) {
        el.checked = true;
      });
      targetRows.forEach(function (el) {
        el.classList.add(selectedRowClass);
      });
    } else {
      targetCheckboxes.forEach(function (el) {
        el.checked = false;
      });
      targetRows.forEach(function (el) {
        el.classList.remove(selectedRowClass);
      });
    }
  }

  function watchCheckedRows() {
    let targetTable = this.closest('.luci-table__table');
    let targetCheckboxes = targetTable.querySelectorAll('tbody .luci-checkbox__label input');
    let toggleAllCheckboxes = targetTable.querySelector('thead .luci-checkbox__label input');
    let totalCheckboxes = targetCheckboxes.length;
    let totalChecked = 0;

    targetCheckboxes.forEach(function (el) {
      if (el.checked === true) {
        totalChecked += 1;
      }
    });

    if (totalChecked === totalCheckboxes) {
      toggleAllCheckboxes.checked = true;
    } else {
      toggleAllCheckboxes.checked = false;
    }
  }

  function handleExpandableRow() {
    let expandable_row = this.closest('.luci-table__row--expandable');
    let child_row = expandable_row.nextElementSibling;

    if (expandable_row.classList.contains('luci-table__row--is-expanded')) {
      expandable_row.classList.remove('luci-table__row--is-expanded');
      child_row.classList.remove('luci-table__row--is-expanded');
    } else {
      expandable_row.classList.add('luci-table__row--is-expanded');
    }
  }

  const init = function init() {
    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('click', handleSelectedRow);
    });

    selectRowCheckbox.forEach(function (el) {
      el.addEventListener('change', watchCheckedRows);
    });

    selectHeadCheckbox.forEach(function (el) {
      el.addEventListener('change', handleToggleAllRows);
    });

    expanableRowAction.forEach(function (el) {
      el.addEventListener('click', handleExpandableRow);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.DataTable.init();
});

"use strict";

function luciPopover() {
    const popoverButton = document.querySelectorAll('.luci-popover__button'),
        popoverObject = document.querySelectorAll('.luci-popover'),
        popoverContent = document.querySelectorAll('.luci-popover__content'),
        popoverOpenClass = 'luci-popover--is-open',
        popoverCheckbox = document.querySelectorAll('.luci-popover .luci-checkbox__label input[type="checkbox"]'),
        popoverLink = document.querySelectorAll('.luci-popover__list-item .luci-link');

    var i;

    function closeAllPopovers() {
        for (i = 0; i < popoverObject.length; i++) {
            popoverObject[i].classList.remove(popoverOpenClass);
        }
        if (popoverCheckbox.length) {
            for (i = 0; i < popoverCheckbox.length; i++) {
                popoverCheckbox[i].blur();
            }
        }
        if (popoverLink.length) {
            for (i = 0; i < popoverLink.length; i++) {
                popoverLink[i].blur();
            }
        }
    }

    function togglePopover(popover) {
        var target = popover.closest('.luci-popover');

        if (target.classList.contains(popoverOpenClass)) {
            closeAllPopovers();
        } else {
            closeAllPopovers();
            target.classList.add(popoverOpenClass);
        }
    }

    function handlePopoverButtonClick() {
        togglePopover(this);
    }

    popoverButton.forEach(function(t){
        t.addEventListener('click', handlePopoverButtonClick);
    });

    //Close All Popovers on esc key press
    document.onkeydown = function(e) {
        e = e || window.event;
        var isEscape = false;
        if ("key" in e) {
            isEscape = e.key === "Escape" || e.key === "Esc";
        } else {
            isEscape = e.keyCode === 27;
        }
        if (isEscape) {
            closeAllPopovers();
        }
    };

    //Stop Propagation on Popover Button and Content elements
    for (i = 0; i < popoverButton.length; i++) {
        popoverButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < popoverContent.length; i++) {
        popoverContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Popovers on body click
    document.addEventListener('click', function(event) {
      closeAllPopovers();
    });
}

document.addEventListener('DOMContentLoaded', function() {
    luciPopover();
});

"use strict";

function luciTooltip() {
    const clickableTooltips = document.querySelectorAll('.luci-tooltip'),
            tooltipVisibleClass = 'luci-tooltip--visible';

    function toggleTooltipVisibility(tooltip) {
        if (tooltip.classList.contains(tooltipVisibleClass)) {
            tooltip.classList.remove(tooltipVisibleClass);
        } else {
            tooltip.classList.add(tooltipVisibleClass);
        }
    }

    function handleClickableTooltipClick() {
        toggleTooltipVisibility(this);
    }

    clickableTooltips.forEach(function(t){
        t.addEventListener('click', handleClickableTooltipClick);
    });
}

document.addEventListener('DOMContentLoaded', function() {
    luciTooltip();
});
