// This is where global styles will go
"use strict";
var Luci = Luci || {};
// https://gist.github.com/cferdinandi/277a322cd7d1e898d9ee
Luci.Utils = function() {
  const getClosestParent = function getClosestParent(elem, selector) {
    const firstChar = selector.charAt(0);

    for (; elem && elem !== document; elem = elem.parentNode) {
      if (firstChar === '.') {
        if (elem.classList.contains(selector.substr(1))) {
          return elem;
        }
      } else if (firstChar === '#') {
        if (elem.id === selector.substr(1)) {
          return elem;
        }
      } else if (firstChar === '[') {
        if (elem.hasAttribute(selector.substr(1, selector.length - 1))) {
          return elem;
        }
      }
    }
    return false;
  };

  return {
    getClosestParent: getClosestParent
  };
}();
