# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AssociatedWorkspace(msrest.serialization.Model):
    """The list of Log Analytics workspaces associated with the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar workspace_id: The id of the assigned workspace.
    :vartype workspace_id: str
    :ivar workspace_name: The name id the assigned workspace.
    :vartype workspace_name: str
    :ivar resource_id: The ResourceId id the assigned workspace.
    :vartype resource_id: str
    :ivar associate_date: The time of workspace association.
    :vartype associate_date: str
    """

    _validation = {
        'workspace_id': {'readonly': True},
        'workspace_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'associate_date': {'readonly': True},
    }

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'associate_date': {'key': 'associateDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssociatedWorkspace, self).__init__(**kwargs)
        self.workspace_id = None
        self.workspace_name = None
        self.resource_id = None
        self.associate_date = None


class AvailableServiceTier(msrest.serialization.Model):
    """Service Tier details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_tier: The name of the Service Tier. Possible values include: "Free", "Standard",
     "Premium", "PerNode", "PerGB2018", "Standalone", "CapacityReservation".
    :vartype service_tier: str or ~azure.mgmt.loganalytics.models.SkuNameEnum
    :ivar enabled: True if the Service Tier is enabled for the workspace.
    :vartype enabled: bool
    :ivar minimum_retention: The minimum retention for the Service Tier, in days.
    :vartype minimum_retention: long
    :ivar maximum_retention: The maximum retention for the Service Tier, in days.
    :vartype maximum_retention: long
    :ivar default_retention: The default retention for the Service Tier, in days.
    :vartype default_retention: long
    :ivar capacity_reservation_level: The capacity reservation level in GB per day. Returned for
     the Capacity Reservation Service Tier.
    :vartype capacity_reservation_level: long
    :ivar last_sku_update: Time when the sku was last updated for the workspace. Returned for the
     Capacity Reservation Service Tier.
    :vartype last_sku_update: str
    """

    _validation = {
        'service_tier': {'readonly': True},
        'enabled': {'readonly': True},
        'minimum_retention': {'readonly': True},
        'maximum_retention': {'readonly': True},
        'default_retention': {'readonly': True},
        'capacity_reservation_level': {'readonly': True},
        'last_sku_update': {'readonly': True},
    }

    _attribute_map = {
        'service_tier': {'key': 'serviceTier', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'minimum_retention': {'key': 'minimumRetention', 'type': 'long'},
        'maximum_retention': {'key': 'maximumRetention', 'type': 'long'},
        'default_retention': {'key': 'defaultRetention', 'type': 'long'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'long'},
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableServiceTier, self).__init__(**kwargs)
        self.service_tier = None
        self.enabled = None
        self.minimum_retention = None
        self.maximum_retention = None
        self.default_retention = None
        self.capacity_reservation_level = None
        self.last_sku_update = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class CapacityReservationProperties(msrest.serialization.Model):
    """The Capacity Reservation properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_sku_update: The last time Sku was updated.
    :vartype last_sku_update: str
    :ivar min_capacity: Minimum CapacityReservation value in GB.
    :vartype min_capacity: long
    """

    _validation = {
        'last_sku_update': {'readonly': True},
        'min_capacity': {'readonly': True},
    }

    _attribute_map = {
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
        'min_capacity': {'key': 'minCapacity', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacityReservationProperties, self).__init__(**kwargs)
        self.last_sku_update = None
        self.min_capacity = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Cluster(TrackedResource):
    """The top level Log Analytics cluster resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.loganalytics.models.Identity
    :param sku: The sku properties.
    :type sku: ~azure.mgmt.loganalytics.models.ClusterSku
    :ivar cluster_id: The ID associated with the cluster.
    :vartype cluster_id: str
    :ivar provisioning_state: The provisioning state of the cluster. Possible values include:
     "Creating", "Succeeded", "Failed", "Canceled", "Deleting", "ProvisioningAccount", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.loganalytics.models.ClusterEntityStatus
    :param is_double_encryption_enabled: Configures whether cluster will use double encryption.
     This Property can not be modified after cluster creation. Default value is 'true'.
    :type is_double_encryption_enabled: bool
    :param is_availability_zones_enabled: Sets whether the cluster will support availability zones.
     This can be set as true only in regions where Azure Data Explorer support Availability Zones.
     This Property can not be modified after cluster creation. Default value is 'true' if region
     supports Availability Zones.
    :type is_availability_zones_enabled: bool
    :param billing_type: The cluster's billing type. Possible values include: "Cluster",
     "Workspaces".
    :type billing_type: str or ~azure.mgmt.loganalytics.models.BillingType
    :param key_vault_properties: The associated key properties.
    :type key_vault_properties: ~azure.mgmt.loganalytics.models.KeyVaultProperties
    :ivar last_modified_date: The last time the cluster was updated.
    :vartype last_modified_date: str
    :ivar created_date: The cluster creation time.
    :vartype created_date: str
    :param associated_workspaces: The list of Log Analytics workspaces associated with the cluster.
    :type associated_workspaces: list[~azure.mgmt.loganalytics.models.AssociatedWorkspace]
    :param capacity_reservation_properties: Additional properties for capacity reservation.
    :type capacity_reservation_properties:
     ~azure.mgmt.loganalytics.models.CapacityReservationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'cluster_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_modified_date': {'readonly': True},
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_double_encryption_enabled': {'key': 'properties.isDoubleEncryptionEnabled', 'type': 'bool'},
        'is_availability_zones_enabled': {'key': 'properties.isAvailabilityZonesEnabled', 'type': 'bool'},
        'billing_type': {'key': 'properties.billingType', 'type': 'str'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'last_modified_date': {'key': 'properties.lastModifiedDate', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'associated_workspaces': {'key': 'properties.associatedWorkspaces', 'type': '[AssociatedWorkspace]'},
        'capacity_reservation_properties': {'key': 'properties.capacityReservationProperties', 'type': 'CapacityReservationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.cluster_id = None
        self.provisioning_state = None
        self.is_double_encryption_enabled = kwargs.get('is_double_encryption_enabled', None)
        self.is_availability_zones_enabled = kwargs.get('is_availability_zones_enabled', None)
        self.billing_type = kwargs.get('billing_type', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.last_modified_date = None
        self.created_date = None
        self.associated_workspaces = kwargs.get('associated_workspaces', None)
        self.capacity_reservation_properties = kwargs.get('capacity_reservation_properties', None)


class ClusterListResult(msrest.serialization.Model):
    """The list clusters operation response.

    :param next_link: The link used to get the next page of recommendations.
    :type next_link: str
    :param value: A list of Log Analytics clusters.
    :type value: list[~azure.mgmt.loganalytics.models.Cluster]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Cluster]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ClusterPatch(msrest.serialization.Model):
    """The top level Log Analytics cluster resource container.

    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.loganalytics.models.Identity
    :param sku: The sku properties.
    :type sku: ~azure.mgmt.loganalytics.models.ClusterSku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param key_vault_properties: The associated key properties.
    :type key_vault_properties: ~azure.mgmt.loganalytics.models.KeyVaultProperties
    :param billing_type: The cluster's billing type. Possible values include: "Cluster",
     "Workspaces".
    :type billing_type: str or ~azure.mgmt.loganalytics.models.BillingType
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'billing_type': {'key': 'properties.billingType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterPatch, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.billing_type = kwargs.get('billing_type', None)


class ClusterSku(msrest.serialization.Model):
    """The cluster sku definition.

    :param capacity: The capacity value. Possible values include: 500, 1000, 2000, 5000.
    :type capacity: str or ~azure.mgmt.loganalytics.models.Capacity
    :param name: The name of the SKU. Possible values include: "CapacityReservation".
    :type name: str or ~azure.mgmt.loganalytics.models.ClusterSkuNameEnum
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterSku, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.name = kwargs.get('name', None)


class CoreSummary(msrest.serialization.Model):
    """The core summary of a search.

    All required parameters must be populated in order to send to Azure.

    :param status: The status of a core summary.
    :type status: str
    :param number_of_documents: Required. The number of documents of a core summary.
    :type number_of_documents: long
    """

    _validation = {
        'number_of_documents': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'number_of_documents': {'key': 'numberOfDocuments', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CoreSummary, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.number_of_documents = kwargs['number_of_documents']


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class DataExport(ProxyResource):
    """The top level data export resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param data_export_id: The data export rule ID.
    :type data_export_id: str
    :param table_names: An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
    :type table_names: list[str]
    :param enable: Active when enabled.
    :type enable: bool
    :param created_date: The latest data export rule modification time.
    :type created_date: str
    :param last_modified_date: Date and time when the export was last modified.
    :type last_modified_date: str
    :param resource_id: The destination resource ID. This can be copied from the Properties entry
     of the destination resource in Azure.
    :type resource_id: str
    :ivar type_properties_destination_type: The type of the destination resource. Possible values
     include: "StorageAccount", "EventHub".
    :vartype type_properties_destination_type: str or ~azure.mgmt.loganalytics.models.Type
    :param event_hub_name: Optional. Allows to define an Event Hub name. Not applicable when
     destination is Storage Account.
    :type event_hub_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_properties_destination_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_export_id': {'key': 'properties.dataExportId', 'type': 'str'},
        'table_names': {'key': 'properties.tableNames', 'type': '[str]'},
        'enable': {'key': 'properties.enable', 'type': 'bool'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'last_modified_date': {'key': 'properties.lastModifiedDate', 'type': 'str'},
        'resource_id': {'key': 'properties.destination.resourceId', 'type': 'str'},
        'type_properties_destination_type': {'key': 'properties.destination.type', 'type': 'str'},
        'event_hub_name': {'key': 'properties.destination.metaData.eventHubName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataExport, self).__init__(**kwargs)
        self.data_export_id = kwargs.get('data_export_id', None)
        self.table_names = kwargs.get('table_names', None)
        self.enable = kwargs.get('enable', None)
        self.created_date = kwargs.get('created_date', None)
        self.last_modified_date = kwargs.get('last_modified_date', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.type_properties_destination_type = None
        self.event_hub_name = kwargs.get('event_hub_name', None)


class DataExportListResult(msrest.serialization.Model):
    """Result of the request to list data exports.

    :param value: List of data export instances within a workspace..
    :type value: list[~azure.mgmt.loganalytics.models.DataExport]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataExport]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataExportListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DataSource(ProxyResource):
    """Datasources under OMS Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param properties: Required. The data source properties in raw json format, each kind of data
     source have it's own schema.
    :type properties: any
    :param etag: The ETag of the data source.
    :type etag: str
    :param kind: Required. The kind of the DataSource. Possible values include: "WindowsEvent",
     "WindowsPerformanceCounter", "IISLogs", "LinuxSyslog", "LinuxSyslogCollection",
     "LinuxPerformanceObject", "LinuxPerformanceCollection", "CustomLog", "CustomLogCollection",
     "AzureAuditLog", "AzureActivityLog", "GenericDataSource", "ChangeTrackingCustomPath",
     "ChangeTrackingPath", "ChangeTrackingServices", "ChangeTrackingDataTypeConfiguration",
     "ChangeTrackingDefaultRegistry", "ChangeTrackingRegistry", "ChangeTrackingLinuxPath",
     "LinuxChangeTrackingPath", "ChangeTrackingContentLocation", "WindowsTelemetry", "Office365",
     "SecurityWindowsBaselineConfiguration", "SecurityCenterSecurityWindowsBaselineConfiguration",
     "SecurityEventCollectionConfiguration", "SecurityInsightsSecurityEventCollectionConfiguration",
     "ImportComputerGroup", "NetworkMonitoring", "Itsm", "DnsAnalytics", "ApplicationInsights",
     "SqlDataClassification".
    :type kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSource, self).__init__(**kwargs)
        self.properties = kwargs['properties']
        self.etag = kwargs.get('etag', None)
        self.kind = kwargs['kind']
        self.tags = kwargs.get('tags', None)


class DataSourceFilter(msrest.serialization.Model):
    """DataSource filter. Right now, only filter by kind is supported.

    :param kind: The kind of the DataSource. Possible values include: "WindowsEvent",
     "WindowsPerformanceCounter", "IISLogs", "LinuxSyslog", "LinuxSyslogCollection",
     "LinuxPerformanceObject", "LinuxPerformanceCollection", "CustomLog", "CustomLogCollection",
     "AzureAuditLog", "AzureActivityLog", "GenericDataSource", "ChangeTrackingCustomPath",
     "ChangeTrackingPath", "ChangeTrackingServices", "ChangeTrackingDataTypeConfiguration",
     "ChangeTrackingDefaultRegistry", "ChangeTrackingRegistry", "ChangeTrackingLinuxPath",
     "LinuxChangeTrackingPath", "ChangeTrackingContentLocation", "WindowsTelemetry", "Office365",
     "SecurityWindowsBaselineConfiguration", "SecurityCenterSecurityWindowsBaselineConfiguration",
     "SecurityEventCollectionConfiguration", "SecurityInsightsSecurityEventCollectionConfiguration",
     "ImportComputerGroup", "NetworkMonitoring", "Itsm", "DnsAnalytics", "ApplicationInsights",
     "SqlDataClassification".
    :type kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSourceFilter, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)


class DataSourceListResult(msrest.serialization.Model):
    """The list data source by workspace operation response.

    :param value: A list of datasources.
    :type value: list[~azure.mgmt.loganalytics.models.DataSource]
    :param next_link: The link (url) to the next page of datasources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataSource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.loganalytics.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.loganalytics.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.loganalytics.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: Required. Type of managed service identity. Possible values include:
     "SystemAssigned", "UserAssigned", "None".
    :type type: str or ~azure.mgmt.loganalytics.models.IdentityType
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.loganalytics.models.UserIdentityProperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class IntelligencePack(msrest.serialization.Model):
    """Intelligence Pack containing a string name and boolean indicating if it's enabled.

    :param name: The name of the intelligence pack.
    :type name: str
    :param enabled: The enabled boolean for the intelligence pack.
    :type enabled: bool
    :param display_name: The display name of the intelligence pack.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntelligencePack, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.enabled = kwargs.get('enabled', None)
        self.display_name = kwargs.get('display_name', None)


class KeyVaultProperties(msrest.serialization.Model):
    """The key vault properties.

    :param key_vault_uri: The Key Vault uri which holds they key associated with the Log Analytics
     cluster.
    :type key_vault_uri: str
    :param key_name: The name of the key associated with the Log Analytics cluster.
    :type key_name: str
    :param key_version: The version of the key associated with the Log Analytics cluster.
    :type key_version: str
    :param key_rsa_size: Selected key minimum required size.
    :type key_rsa_size: int
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'key_rsa_size': {'key': 'keyRsaSize', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_vault_uri = kwargs.get('key_vault_uri', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)
        self.key_rsa_size = kwargs.get('key_rsa_size', None)


class LinkedService(ProxyResource):
    """The top level Linked service resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param resource_id: The resource id of the resource that will be linked to the workspace. This
     should be used for linking resources which require read access.
    :type resource_id: str
    :param write_access_resource_id: The resource id of the resource that will be linked to the
     workspace. This should be used for linking resources which require write access.
    :type write_access_resource_id: str
    :param provisioning_state: The provisioning state of the linked service. Possible values
     include: "Succeeded", "Deleting", "ProvisioningAccount", "Updating".
    :type provisioning_state: str or ~azure.mgmt.loganalytics.models.LinkedServiceEntityStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'write_access_resource_id': {'key': 'properties.writeAccessResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedService, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.write_access_resource_id = kwargs.get('write_access_resource_id', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class LinkedServiceListResult(msrest.serialization.Model):
    """The list linked service operation response.

    :param value: The list of linked service instances.
    :type value: list[~azure.mgmt.loganalytics.models.LinkedService]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkedService]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedServiceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class LinkedStorageAccountsListResult(msrest.serialization.Model):
    """The list linked storage accounts service operation response.

    :param value: A list of linked storage accounts instances.
    :type value: list[~azure.mgmt.loganalytics.models.LinkedStorageAccountsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkedStorageAccountsResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedStorageAccountsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class LinkedStorageAccountsResource(ProxyResource):
    """Linked storage accounts top level resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar data_source_type: Linked storage accounts type. Possible values include: "CustomLogs",
     "AzureWatson", "Query", "Alerts".
    :vartype data_source_type: str or ~azure.mgmt.loganalytics.models.DataSourceType
    :param storage_account_ids: Linked storage accounts resources ids.
    :type storage_account_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_source_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_source_type': {'key': 'properties.dataSourceType', 'type': 'str'},
        'storage_account_ids': {'key': 'properties.storageAccountIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedStorageAccountsResource, self).__init__(**kwargs)
        self.data_source_type = None
        self.storage_account_ids = kwargs.get('storage_account_ids', None)


class ManagementGroup(msrest.serialization.Model):
    """A management group that is connected to a workspace.

    :param server_count: The number of servers connected to the management group.
    :type server_count: int
    :param is_gateway: Gets or sets a value indicating whether the management group is a gateway.
    :type is_gateway: bool
    :param name: The name of the management group.
    :type name: str
    :param id: The unique ID of the management group.
    :type id: str
    :param created: The datetime that the management group was created.
    :type created: ~datetime.datetime
    :param data_received: The last datetime that the management group received data.
    :type data_received: ~datetime.datetime
    :param version: The version of System Center that is managing the management group.
    :type version: str
    :param sku: The SKU of System Center that is managing the management group.
    :type sku: str
    """

    _attribute_map = {
        'server_count': {'key': 'properties.serverCount', 'type': 'int'},
        'is_gateway': {'key': 'properties.isGateway', 'type': 'bool'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'data_received': {'key': 'properties.dataReceived', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroup, self).__init__(**kwargs)
        self.server_count = kwargs.get('server_count', None)
        self.is_gateway = kwargs.get('is_gateway', None)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.created = kwargs.get('created', None)
        self.data_received = kwargs.get('data_received', None)
        self.version = kwargs.get('version', None)
        self.sku = kwargs.get('sku', None)


class MetricName(msrest.serialization.Model):
    """The name of a metric.

    :param value: The system name of the metric.
    :type value: str
    :param localized_value: The localized name of the metric.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class Operation(msrest.serialization.Model):
    """Supported operation of OperationalInsights resource provider.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.loganalytics.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft OperationsManagement.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list solution operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of solution operations supported by the OperationsManagement resource
     provider.
    :type value: list[~azure.mgmt.loganalytics.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class OperationStatus(msrest.serialization.Model):
    """The status of operation.

    :param id: The operation Id.
    :type id: str
    :param name: The operation name.
    :type name: str
    :param start_time: The start time of the operation.
    :type start_time: str
    :param end_time: The end time of the operation.
    :type end_time: str
    :param status: The status of the operation.
    :type status: str
    :param error: The error detail of the operation if any.
    :type error: ~azure.mgmt.loganalytics.models.ErrorResponse
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatus, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class PrivateLinkScopedResource(msrest.serialization.Model):
    """The private link scope resource reference.

    :param resource_id: The full resource Id of the private link scope resource.
    :type resource_id: str
    :param scope_id: The private link scope unique Identifier.
    :type scope_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'scope_id': {'key': 'scopeId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkScopedResource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.scope_id = kwargs.get('scope_id', None)


class SavedSearch(ProxyResource):
    """Value object for saved search results.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param etag: The ETag of the saved search. To override an existing saved search, use "*" or
     specify the current Etag.
    :type etag: str
    :param category: Required. The category of the saved search. This helps the user to find a
     saved search faster.
    :type category: str
    :param display_name: Required. Saved search display name.
    :type display_name: str
    :param query: Required. The query expression for the saved search.
    :type query: str
    :param function_alias: The function alias if query serves as a function.
    :type function_alias: str
    :param function_parameters: The optional function parameters if query serves as a function.
     Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2
     = default_value2'. For more examples and proper syntax please refer to
     https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
    :type function_parameters: str
    :param version: The version number of the query language. The current version is 2 and is the
     default.
    :type version: long
    :param tags: A set of tags. The tags attached to the saved search.
    :type tags: list[~azure.mgmt.loganalytics.models.Tag]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category': {'required': True},
        'display_name': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'function_alias': {'key': 'properties.functionAlias', 'type': 'str'},
        'function_parameters': {'key': 'properties.functionParameters', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'long'},
        'tags': {'key': 'properties.tags', 'type': '[Tag]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SavedSearch, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.category = kwargs['category']
        self.display_name = kwargs['display_name']
        self.query = kwargs['query']
        self.function_alias = kwargs.get('function_alias', None)
        self.function_parameters = kwargs.get('function_parameters', None)
        self.version = kwargs.get('version', None)
        self.tags = kwargs.get('tags', None)


class SavedSearchesListResult(msrest.serialization.Model):
    """The saved search list operation response.

    :param value: The array of result values.
    :type value: list[~azure.mgmt.loganalytics.models.SavedSearch]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SavedSearch]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SavedSearchesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SearchGetSchemaResponse(msrest.serialization.Model):
    """The get schema operation response.

    :param metadata: The metadata from search results.
    :type metadata: ~azure.mgmt.loganalytics.models.SearchMetadata
    :param value: The array of result values.
    :type value: list[~azure.mgmt.loganalytics.models.SearchSchemaValue]
    """

    _attribute_map = {
        'metadata': {'key': 'metadata', 'type': 'SearchMetadata'},
        'value': {'key': 'value', 'type': '[SearchSchemaValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchGetSchemaResponse, self).__init__(**kwargs)
        self.metadata = kwargs.get('metadata', None)
        self.value = kwargs.get('value', None)


class SearchMetadata(msrest.serialization.Model):
    """Metadata for search results.

    :param search_id: The request id of the search.
    :type search_id: str
    :param result_type: The search result type.
    :type result_type: str
    :param total: The total number of search results.
    :type total: long
    :param top: The number of top search results.
    :type top: long
    :param id: The id of the search results request.
    :type id: str
    :param core_summaries: The core summaries.
    :type core_summaries: list[~azure.mgmt.loganalytics.models.CoreSummary]
    :param status: The status of the search results.
    :type status: str
    :param start_time: The start time for the search.
    :type start_time: ~datetime.datetime
    :param last_updated: The time of last update.
    :type last_updated: ~datetime.datetime
    :param e_tag: The ETag of the search results.
    :type e_tag: str
    :param sort: How the results are sorted.
    :type sort: list[~azure.mgmt.loganalytics.models.SearchSort]
    :param request_time: The request time.
    :type request_time: long
    :param aggregated_value_field: The aggregated value field.
    :type aggregated_value_field: str
    :param aggregated_grouping_fields: The aggregated grouping fields.
    :type aggregated_grouping_fields: str
    :param sum: The sum of all aggregates returned in the result set.
    :type sum: long
    :param max: The max of all aggregates returned in the result set.
    :type max: long
    :param schema: The schema.
    :type schema: ~azure.mgmt.loganalytics.models.SearchMetadataSchema
    """

    _attribute_map = {
        'search_id': {'key': 'requestId', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'total': {'key': 'total', 'type': 'long'},
        'top': {'key': 'top', 'type': 'long'},
        'id': {'key': 'id', 'type': 'str'},
        'core_summaries': {'key': 'coreSummaries', 'type': '[CoreSummary]'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'sort': {'key': 'sort', 'type': '[SearchSort]'},
        'request_time': {'key': 'requestTime', 'type': 'long'},
        'aggregated_value_field': {'key': 'aggregatedValueField', 'type': 'str'},
        'aggregated_grouping_fields': {'key': 'aggregatedGroupingFields', 'type': 'str'},
        'sum': {'key': 'sum', 'type': 'long'},
        'max': {'key': 'max', 'type': 'long'},
        'schema': {'key': 'schema', 'type': 'SearchMetadataSchema'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchMetadata, self).__init__(**kwargs)
        self.search_id = kwargs.get('search_id', None)
        self.result_type = kwargs.get('result_type', None)
        self.total = kwargs.get('total', None)
        self.top = kwargs.get('top', None)
        self.id = kwargs.get('id', None)
        self.core_summaries = kwargs.get('core_summaries', None)
        self.status = kwargs.get('status', None)
        self.start_time = kwargs.get('start_time', None)
        self.last_updated = kwargs.get('last_updated', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.sort = kwargs.get('sort', None)
        self.request_time = kwargs.get('request_time', None)
        self.aggregated_value_field = kwargs.get('aggregated_value_field', None)
        self.aggregated_grouping_fields = kwargs.get('aggregated_grouping_fields', None)
        self.sum = kwargs.get('sum', None)
        self.max = kwargs.get('max', None)
        self.schema = kwargs.get('schema', None)


class SearchMetadataSchema(msrest.serialization.Model):
    """Schema metadata for search.

    :param name: The name of the metadata schema.
    :type name: str
    :param version: The version of the metadata schema.
    :type version: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchMetadataSchema, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)


class SearchSchemaValue(msrest.serialization.Model):
    """Value object for schema results.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the schema.
    :type name: str
    :param display_name: The display name of the schema.
    :type display_name: str
    :param type: The type.
    :type type: str
    :param indexed: Required. The boolean that indicates the field is searchable as free text.
    :type indexed: bool
    :param stored: Required. The boolean that indicates whether or not the field is stored.
    :type stored: bool
    :param facet: Required. The boolean that indicates whether or not the field is a facet.
    :type facet: bool
    :param owner_type: The array of workflows containing the field.
    :type owner_type: list[str]
    """

    _validation = {
        'indexed': {'required': True},
        'stored': {'required': True},
        'facet': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'indexed': {'key': 'indexed', 'type': 'bool'},
        'stored': {'key': 'stored', 'type': 'bool'},
        'facet': {'key': 'facet', 'type': 'bool'},
        'owner_type': {'key': 'ownerType', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchSchemaValue, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)
        self.indexed = kwargs['indexed']
        self.stored = kwargs['stored']
        self.facet = kwargs['facet']
        self.owner_type = kwargs.get('owner_type', None)


class SearchSort(msrest.serialization.Model):
    """The sort parameters for search.

    :param name: The name of the field the search query is sorted on.
    :type name: str
    :param order: The sort order of the search. Possible values include: "asc", "desc".
    :type order: str or ~azure.mgmt.loganalytics.models.SearchSortEnum
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchSort, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.order = kwargs.get('order', None)


class SharedKeys(msrest.serialization.Model):
    """The shared keys for a workspace.

    :param primary_shared_key: The primary shared key of a workspace.
    :type primary_shared_key: str
    :param secondary_shared_key: The secondary shared key of a workspace.
    :type secondary_shared_key: str
    """

    _attribute_map = {
        'primary_shared_key': {'key': 'primarySharedKey', 'type': 'str'},
        'secondary_shared_key': {'key': 'secondarySharedKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SharedKeys, self).__init__(**kwargs)
        self.primary_shared_key = kwargs.get('primary_shared_key', None)
        self.secondary_shared_key = kwargs.get('secondary_shared_key', None)


class StorageAccount(msrest.serialization.Model):
    """Describes a storage account connection.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Azure Resource Manager ID of the storage account resource.
    :type id: str
    :param key: Required. The storage account key.
    :type key: str
    """

    _validation = {
        'id': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.key = kwargs['key']


class StorageInsight(ProxyResource):
    """The top level storage insight resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param e_tag: The ETag of the storage insight.
    :type e_tag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param containers: The names of the blob containers that the workspace should read.
    :type containers: list[str]
    :param tables: The names of the Azure tables that the workspace should read.
    :type tables: list[str]
    :param storage_account: The storage account connection details.
    :type storage_account: ~azure.mgmt.loganalytics.models.StorageAccount
    :ivar status: The status of the storage insight.
    :vartype status: ~azure.mgmt.loganalytics.models.StorageInsightStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'containers': {'key': 'properties.containers', 'type': '[str]'},
        'tables': {'key': 'properties.tables', 'type': '[str]'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccount'},
        'status': {'key': 'properties.status', 'type': 'StorageInsightStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageInsight, self).__init__(**kwargs)
        self.e_tag = kwargs.get('e_tag', None)
        self.tags = kwargs.get('tags', None)
        self.containers = kwargs.get('containers', None)
        self.tables = kwargs.get('tables', None)
        self.storage_account = kwargs.get('storage_account', None)
        self.status = None


class StorageInsightListResult(msrest.serialization.Model):
    """The list storage insights operation response.

    :param value: A list of storage insight items.
    :type value: list[~azure.mgmt.loganalytics.models.StorageInsight]
    :param odata_next_link: The link (url) to the next page of results.
    :type odata_next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageInsight]'},
        'odata_next_link': {'key': '@odata\\.nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageInsightListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.odata_next_link = kwargs.get('odata_next_link', None)


class StorageInsightStatus(msrest.serialization.Model):
    """The status of the storage insight.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. The state of the storage insight connection to the workspace. Possible
     values include: "OK", "ERROR".
    :type state: str or ~azure.mgmt.loganalytics.models.StorageInsightState
    :param description: Description of the state of the storage insight.
    :type description: str
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageInsightStatus, self).__init__(**kwargs)
        self.state = kwargs['state']
        self.description = kwargs.get('description', None)


class Table(ProxyResource):
    """Workspace data table definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param retention_in_days: The data table data retention in days, between 7 and 730. Setting
     this property to null will default to the workspace retention.
    :type retention_in_days: int
    :ivar is_troubleshooting_allowed: Specifies if IsTroubleshootingEnabled property can be set for
     this table.
    :vartype is_troubleshooting_allowed: bool
    :param is_troubleshoot_enabled: Enable or disable troubleshoot for this table.
    :type is_troubleshoot_enabled: bool
    :ivar last_troubleshoot_date: Last time when troubleshooting was set for this table.
    :vartype last_troubleshoot_date: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'retention_in_days': {'maximum': 730, 'minimum': 7},
        'is_troubleshooting_allowed': {'readonly': True},
        'last_troubleshoot_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'is_troubleshooting_allowed': {'key': 'properties.isTroubleshootingAllowed', 'type': 'bool'},
        'is_troubleshoot_enabled': {'key': 'properties.isTroubleshootEnabled', 'type': 'bool'},
        'last_troubleshoot_date': {'key': 'properties.lastTroubleshootDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Table, self).__init__(**kwargs)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.is_troubleshooting_allowed = None
        self.is_troubleshoot_enabled = kwargs.get('is_troubleshoot_enabled', None)
        self.last_troubleshoot_date = None


class TablesListResult(msrest.serialization.Model):
    """The list tables operation response.

    :param value: A list of data tables.
    :type value: list[~azure.mgmt.loganalytics.models.Table]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Table]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TablesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Tag(msrest.serialization.Model):
    """A tag of a saved search.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The tag name.
    :type name: str
    :param value: Required. The tag value.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Tag, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']


class UsageMetric(msrest.serialization.Model):
    """A metric describing the usage of a resource.

    :param name: The name of the metric.
    :type name: ~azure.mgmt.loganalytics.models.MetricName
    :param unit: The units used for the metric.
    :type unit: str
    :param current_value: The current value of the metric.
    :type current_value: float
    :param limit: The quota limit for the metric.
    :type limit: float
    :param next_reset_time: The time that the metric's value will reset.
    :type next_reset_time: ~datetime.datetime
    :param quota_period: The quota period that determines the length of time between value resets.
    :type quota_period: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageMetric, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.unit = kwargs.get('unit', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.quota_period = kwargs.get('quota_period', None)


class UserIdentityProperties(msrest.serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Workspace(TrackedResource):
    """The top level Workspace resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param e_tag: The ETag of the workspace.
    :type e_tag: str
    :param provisioning_state: The provisioning state of the workspace. Possible values include:
     "Creating", "Succeeded", "Failed", "Canceled", "Deleting", "ProvisioningAccount", "Updating".
    :type provisioning_state: str or ~azure.mgmt.loganalytics.models.WorkspaceEntityStatus
    :ivar customer_id: This is a read-only property. Represents the ID associated with the
     workspace.
    :vartype customer_id: str
    :param sku: The SKU of the workspace.
    :type sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
    :param retention_in_days: The workspace data retention in days. Allowed values are per pricing
     plan. See pricing tiers documentation for details.
    :type retention_in_days: int
    :param workspace_capping: The daily volume cap for ingestion.
    :type workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
    :ivar created_date: Workspace creation date.
    :vartype created_date: str
    :ivar modified_date: Workspace modification date.
    :vartype modified_date: str
    :param public_network_access_for_ingestion: The network access type for accessing Log Analytics
     ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access_for_ingestion: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :param public_network_access_for_query: The network access type for accessing Log Analytics
     query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access_for_query: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :param force_cmk_for_query: Indicates whether customer managed storage is mandatory for query
     management.
    :type force_cmk_for_query: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.loganalytics.models.PrivateLinkScopedResource]
    :param features: Workspace features.
    :type features: ~azure.mgmt.loganalytics.models.WorkspaceFeatures
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'customer_id': {'readonly': True},
        'created_date': {'readonly': True},
        'modified_date': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'WorkspaceSku'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'workspace_capping': {'key': 'properties.workspaceCapping', 'type': 'WorkspaceCapping'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'modified_date': {'key': 'properties.modifiedDate', 'type': 'str'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'force_cmk_for_query': {'key': 'properties.forceCmkForQuery', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.privateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'features': {'key': 'properties.features', 'type': 'WorkspaceFeatures'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workspace, self).__init__(**kwargs)
        self.e_tag = kwargs.get('e_tag', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.customer_id = None
        self.sku = kwargs.get('sku', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.workspace_capping = kwargs.get('workspace_capping', None)
        self.created_date = None
        self.modified_date = None
        self.public_network_access_for_ingestion = kwargs.get('public_network_access_for_ingestion', "Enabled")
        self.public_network_access_for_query = kwargs.get('public_network_access_for_query', "Enabled")
        self.force_cmk_for_query = kwargs.get('force_cmk_for_query', None)
        self.private_link_scoped_resources = None
        self.features = kwargs.get('features', None)


class WorkspaceCapping(msrest.serialization.Model):
    """The daily volume cap for ingestion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param daily_quota_gb: The workspace daily quota for ingestion.
    :type daily_quota_gb: float
    :ivar quota_next_reset_time: The time when the quota will be rest.
    :vartype quota_next_reset_time: str
    :ivar data_ingestion_status: The status of data ingestion for this workspace. Possible values
     include: "RespectQuota", "ForceOn", "ForceOff", "OverQuota", "SubscriptionSuspended",
     "ApproachingQuota".
    :vartype data_ingestion_status: str or ~azure.mgmt.loganalytics.models.DataIngestionStatus
    """

    _validation = {
        'quota_next_reset_time': {'readonly': True},
        'data_ingestion_status': {'readonly': True},
    }

    _attribute_map = {
        'daily_quota_gb': {'key': 'dailyQuotaGb', 'type': 'float'},
        'quota_next_reset_time': {'key': 'quotaNextResetTime', 'type': 'str'},
        'data_ingestion_status': {'key': 'dataIngestionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceCapping, self).__init__(**kwargs)
        self.daily_quota_gb = kwargs.get('daily_quota_gb', None)
        self.quota_next_reset_time = None
        self.data_ingestion_status = None


class WorkspaceFeatures(msrest.serialization.Model):
    """Workspace features.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param enable_data_export: Flag that indicate if data should be exported.
    :type enable_data_export: bool
    :param immediate_purge_data_on30_days: Flag that describes if we want to remove the data after
     30 days.
    :type immediate_purge_data_on30_days: bool
    :param enable_log_access_using_only_resource_permissions: Flag that indicate which permission
     to use - resource or workspace or both.
    :type enable_log_access_using_only_resource_permissions: bool
    :param cluster_resource_id: Dedicated LA cluster resourceId that is linked to the workspaces.
    :type cluster_resource_id: str
    :param disable_local_auth: Disable Non-AAD based Auth.
    :type disable_local_auth: bool
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'enable_data_export': {'key': 'enableDataExport', 'type': 'bool'},
        'immediate_purge_data_on30_days': {'key': 'immediatePurgeDataOn30Days', 'type': 'bool'},
        'enable_log_access_using_only_resource_permissions': {'key': 'enableLogAccessUsingOnlyResourcePermissions', 'type': 'bool'},
        'cluster_resource_id': {'key': 'clusterResourceId', 'type': 'str'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceFeatures, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.enable_data_export = kwargs.get('enable_data_export', None)
        self.immediate_purge_data_on30_days = kwargs.get('immediate_purge_data_on30_days', None)
        self.enable_log_access_using_only_resource_permissions = kwargs.get('enable_log_access_using_only_resource_permissions', None)
        self.cluster_resource_id = kwargs.get('cluster_resource_id', None)
        self.disable_local_auth = kwargs.get('disable_local_auth', None)


class WorkspaceListManagementGroupsResult(msrest.serialization.Model):
    """The list workspace management groups operation response.

    :param value: Gets or sets a list of management groups attached to the workspace.
    :type value: list[~azure.mgmt.loganalytics.models.ManagementGroup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceListManagementGroupsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class WorkspaceListResult(msrest.serialization.Model):
    """The list workspaces operation response.

    :param value: A list of workspaces.
    :type value: list[~azure.mgmt.loganalytics.models.Workspace]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workspace]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class WorkspaceListUsagesResult(msrest.serialization.Model):
    """The list workspace usages operation response.

    :param value: Gets or sets a list of usage metrics for a workspace.
    :type value: list[~azure.mgmt.loganalytics.models.UsageMetric]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UsageMetric]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceListUsagesResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class WorkspacePatch(AzureEntityResource):
    """The top level Workspace resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param tags: A set of tags. Resource tags. Optional.
    :type tags: dict[str, str]
    :param provisioning_state: The provisioning state of the workspace. Possible values include:
     "Creating", "Succeeded", "Failed", "Canceled", "Deleting", "ProvisioningAccount", "Updating".
    :type provisioning_state: str or ~azure.mgmt.loganalytics.models.WorkspaceEntityStatus
    :ivar customer_id: This is a read-only property. Represents the ID associated with the
     workspace.
    :vartype customer_id: str
    :param sku: The SKU of the workspace.
    :type sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
    :param retention_in_days: The workspace data retention in days. Allowed values are per pricing
     plan. See pricing tiers documentation for details.
    :type retention_in_days: int
    :param workspace_capping: The daily volume cap for ingestion.
    :type workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
    :ivar created_date: Workspace creation date.
    :vartype created_date: str
    :ivar modified_date: Workspace modification date.
    :vartype modified_date: str
    :param public_network_access_for_ingestion: The network access type for accessing Log Analytics
     ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access_for_ingestion: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :param public_network_access_for_query: The network access type for accessing Log Analytics
     query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access_for_query: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :param force_cmk_for_query: Indicates whether customer managed storage is mandatory for query
     management.
    :type force_cmk_for_query: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.loganalytics.models.PrivateLinkScopedResource]
    :param features: Workspace features.
    :type features: ~azure.mgmt.loganalytics.models.WorkspaceFeatures
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'customer_id': {'readonly': True},
        'created_date': {'readonly': True},
        'modified_date': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'WorkspaceSku'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'workspace_capping': {'key': 'properties.workspaceCapping', 'type': 'WorkspaceCapping'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'modified_date': {'key': 'properties.modifiedDate', 'type': 'str'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'force_cmk_for_query': {'key': 'properties.forceCmkForQuery', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.privateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'features': {'key': 'properties.features', 'type': 'WorkspaceFeatures'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.customer_id = None
        self.sku = kwargs.get('sku', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.workspace_capping = kwargs.get('workspace_capping', None)
        self.created_date = None
        self.modified_date = None
        self.public_network_access_for_ingestion = kwargs.get('public_network_access_for_ingestion', "Enabled")
        self.public_network_access_for_query = kwargs.get('public_network_access_for_query', "Enabled")
        self.force_cmk_for_query = kwargs.get('force_cmk_for_query', None)
        self.private_link_scoped_resources = None
        self.features = kwargs.get('features', None)


class WorkspacePurgeBody(msrest.serialization.Model):
    """Describes the body of a purge request for an App Insights Workspace.

    All required parameters must be populated in order to send to Azure.

    :param table: Required. Table from which to purge data.
    :type table: str
    :param filters: Required. The set of columns and filters (queries) to run over them to purge
     the resulting data.
    :type filters: list[~azure.mgmt.loganalytics.models.WorkspacePurgeBodyFilters]
    """

    _validation = {
        'table': {'required': True},
        'filters': {'required': True},
    }

    _attribute_map = {
        'table': {'key': 'table', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[WorkspacePurgeBodyFilters]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePurgeBody, self).__init__(**kwargs)
        self.table = kwargs['table']
        self.filters = kwargs['filters']


class WorkspacePurgeBodyFilters(msrest.serialization.Model):
    """User-defined filters to return data which will be purged from the table.

    :param column: The column of the table over which the given query should run.
    :type column: str
    :param operator: A query operator to evaluate over the provided column and value(s). Supported
     operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would
     in a KQL query.
    :type operator: str
    :param value: the value for the operator to function over. This can be a number (e.g., > 100),
     a string (timestamp >= '2017-09-01') or array of values.
    :type value: any
    :param key: When filtering over custom dimensions, this key will be used as the name of the
     custom dimension.
    :type key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePurgeBodyFilters, self).__init__(**kwargs)
        self.column = kwargs.get('column', None)
        self.operator = kwargs.get('operator', None)
        self.value = kwargs.get('value', None)
        self.key = kwargs.get('key', None)


class WorkspacePurgeResponse(msrest.serialization.Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Id to use when querying for status for a particular purge
     operation.
    :type operation_id: str
    """

    _validation = {
        'operation_id': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePurgeResponse, self).__init__(**kwargs)
        self.operation_id = kwargs['operation_id']


class WorkspacePurgeStatusResponse(msrest.serialization.Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Status of the operation represented by the requested Id. Possible
     values include: "pending", "completed".
    :type status: str or ~azure.mgmt.loganalytics.models.PurgeState
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePurgeStatusResponse, self).__init__(**kwargs)
        self.status = kwargs['status']


class WorkspaceSku(msrest.serialization.Model):
    """The SKU (tier) of a workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Possible values include: "Free", "Standard",
     "Premium", "PerNode", "PerGB2018", "Standalone", "CapacityReservation", "LACluster".
    :type name: str or ~azure.mgmt.loganalytics.models.WorkspaceSkuNameEnum
    :param capacity_reservation_level: The capacity reservation level in GB for this workspace,
     when CapacityReservation sku is selected. Possible values include: 100, 200, 300, 400, 500,
     1000, 2000, 5000.
    :type capacity_reservation_level: str or
     ~azure.mgmt.loganalytics.models.CapacityReservationLevel
    :ivar last_sku_update: The last time when the sku was updated.
    :vartype last_sku_update: str
    """

    _validation = {
        'name': {'required': True},
        'last_sku_update': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'int'},
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceSku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.capacity_reservation_level = kwargs.get('capacity_reservation_level', None)
        self.last_sku_update = None
