# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.databoundaries.aio import DataBoundaryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.live_test_only
class TestDataBoundaryMgmtDataBoundariesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoundaryMgmtClient, is_async=True)

    @pytest.mark.skip(reason='can not pass')
    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_put(self, resource_group):
        response = await self.client.data_boundaries.put(
            default="default",
            data_boundary_definition={"properties": {"dataBoundary": "EU"}},
        )

        assert response
        

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_tenant(self, resource_group):
        response = await self.client.data_boundaries.get_tenant(
            default="default",
        )

        assert response
