## How to contribute to the Task Scheduler Managed Wrapper Project

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/dahall/TaskScheduler/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/dahall/TaskScheduler/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability will generally not be accepted.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [Task Scheduler Enhancement Requests topic](https://groups.google.com/forum/#!topic/taskscheduler/sEMbPqySAX0).

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* Ask any question about how to use Task Scheduler Managed Wrapper in the [Forum](https://groups.google.com/forum/#!forum/taskscheduler).

#### **Do you want to contribute to the documentation?**

* The help files are automatically generated using XML comments within the code. To enhance the help documentation, please follow the same process as contributing to the code.

* If you wish to contribute to the site documentation wiki, please contact the project coordinator.

This is a volunteer effort. We encourage you to pitch in and contribute!