/*
 * $Id: common.h 1.1 2001/06/26 22:15:38Z aperelma Exp aperelma $
 *
 * Fibre Channel Managment API Routines C-language header
 *
 *
 * COPYRIGHT  1997, 1998, 1999, 2000, EMULEX CORPORATION
 * 3535 Harbor Boulevard, Costa Mesa, CA  92626
 *
 * This computer program and related documentation ("Program") is provided
 * under a non-exclusive, worldwide, royalty-free, perpetual, transferable
 * license to use, copy, compile, modify or have modified, display,
 * distribute or have distributed, with the exception of limitations
 * associated with the subsidiary program ("Subsidiary") contained therein.
 * The Subsidiary will be provided in object code only and may not be
 * modified, displayed, decompiled, or reverse engineered. The Subsidiary
 * is confidential and a trade secret of EMULEX CORPORATION. Any distribution
 * of the Program without this copyright notice is a violation of the
 * copyright laws and may subject you to criminal prosecution. THE PROGRAM
 * IS LICENSED AS IS, WITHOUT ANY WARRANTY, INCLUDING THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND AGAINST
 * INFRINGEMENT.
*/


#ifdef _SOLARIS
#if defined(sparc)
typedef unsigned int     ULONG;
#else
typedef unsigned long    ULONG;
#endif
#else
#ifdef _HPUX_COMBO
typedef unsigned int     ULONG;
#else
typedef unsigned long    ULONG;
#endif
#endif
#ifndef _WINDOWS_NT
typedef unsigned int     UWORD;
#endif
typedef unsigned short   USHORT;
#if !defined(_HPUX_COMBO) && !defined(_SOLARIS)
typedef unsigned short   ushort;
#endif
typedef unsigned char    BYTE;
typedef unsigned char    UCHAR;
typedef void *           PVOID;

#ifndef UINT16
typedef unsigned short UINT16;
#endif
#if _WINDOWS_NT || defined(_HPUX_COMBO) || defined(AIX_COMBO)
typedef unsigned long uint32;
#endif

#define FALSE            0
#define TRUE             1

#if _WINDOWS_NT
#define LITTLE_ENDIAN   1	 /* Host bit ordering - set to 0 or 1 */
#endif

#if _DOS
#define LITTLE_ENDIAN   1	 /* Host bit ordering - set to 0 or 1 */
#endif

#ifdef _HPUX_COMBO
/* Platform defines - select one from each group */
#define _WINDOWS_NT     0
#define _AIX            0
#define _DOS            0
#define _SOLARIS_SPARC  0
#define _SOLARIS_X86    0
#define LITTLE_ENDIAN   0	 /* Host bit ordering - set to 0 or 1 */
#endif

#if defined(_LINUX) || defined(_VMWARE)
#define _WINDOWS_NT     0
#define _AIX            0
#define _DOS            0
#define _SOLARIS_SPARC  0
#define _SOLARIS_X86    0
#ifdef __powerpc__
#define LITTLE_ENDIAN   0	 /* Host bit ordering - set to 0 or 1 */
#else
#define LITTLE_ENDIAN   1	 /* Host bit ordering - set to 0 or 1 */
#endif
#endif

#ifdef _SOLARIS
#ifdef  i386
/* Platform defines - select one from each group */
#define _WINDOWS_NT     0
#define _AIX            0
#define _DOS            0
#define _SOLARIS_SPARC  0
#define _SOLARIS_X86    1
#define LITTLE_ENDIAN   1	 /* Host bit ordering - set to 0 or 1 */
#else
/* Platform defines - select one from each group */
#define _WINDOWS_NT     0
#define _AIX            0
#define _DOS            0
#define _SOLARIS_SPARC  1
#define _SOLARIS_X86    0
#define LITTLE_ENDIAN   0	 /* Host bit ordering - set to 0 or 1 */
#endif
#endif
#ifdef _AIX_COMBO			 /* 32-bit AIX platform */
#ifdef __ia64
/* Platform defines - select one from each group */
#define _WINDOWS_NT     0
#define _AIX            1
#define _DOS            0
#define _SOLARIS_SPARC  0
#define _SOLARIS_X86    0
#define LITTLE_ENDIAN   1	 /* Host bit ordering - set to 1 for L.E. */
#else
/* Platform defines - select one from each group */
#define _WINDOWS_NT     0
#define _AIX            1
#define _DOS            0
#define _SOLARIS_SPARC  0
#define _SOLARIS_X86    0
#define LITTLE_ENDIAN   0	 /* Host bit ordering - set to 0 for B.E. */
#endif
#endif
#ifdef _UW
/* Platform defines - select one from each group */
#define _WINDOWS_NT     0
#define _AIX            0
#define _DOS            0
#define _SOLARIS_SPARC  0
#define _SOLARIS_X86    0
#define LITTLE_ENDIAN   1	 /* Host bit ordering - set to 0 or 1 */
#endif

#if _WINDOWS_NT
typedef UCHAR           BIT;
#else
typedef unsigned        BIT;
#endif

#if defined(_SOLARIS) || defined(_LINUX) || defined(_HPUX_COMBO) || defined(_AIX_COMBO) || defined(_VMWARE)
#else
#define bcopy(s, d, l)  RtlMoveMemory(d, s, l)
#define bzero(b, l)     RtlZeroMemory(b, l)
#define bcmp(s1, s2, l) (l != RtlCompareMemory(s1, s2, l))

#define swap_bcopy(s, d, l) {\
   int i; char *sp = s; char *dp = d;        \
   for (i=0; i<(l); i++) sp[i ^ 3] = dp[i];  \
   }
#endif

