/*
 * COPYRIGHT  1997, 1998, 1999, 2000, EMULEX CORPORATION
 * 3535 Harbor Boulevard, Costa Mesa, CA  92626
 *
 * This computer program and related documentation ("Program") is provided
 * under a non-exclusive, worldwide, royalty-free, perpetual, transferable
 * license to use, copy, compile, modify or have modified, display,
 * distribute or have distributed, with the exception of limitations
 * associated with the subsidiary program ("Subsidiary") contained therein.
 * The Subsidiary will be provided in object code only and may not be
 * modified, displayed, decompiled, or reverse engineered. The Subsidiary
 * is confidential and a trade secret of EMULEX CORPORATION. Any distribution
 * of the Program without this copyright notice is a violation of the
 * copyright laws and may subject you to criminal prosecution. THE PROGRAM
 * IS LICENSED AS IS, WITHOUT ANY WARRANTY, INCLUDING THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND AGAINST
 * INFRINGEMENT.
 *
 * Fibre Channel SCSI LAN header file
 *
 */

#ifndef _H_FC_HW
#define _H_FC_HW



#ifdef _STUB
/* Must define LITTLE_ENDIAN_HW or BIG_ENDIAN_HW */
/* Fixup these typedefs for your environment, if needed */
#endif

#ifdef _LH6000
typedef unsigned  int   u32bit;
typedef unsigned  short u16bit;
typedef unsigned  char  u8bit;
#else
typedef unsigned        u32bit;
typedef unsigned        u16bit;
typedef unsigned        u8bit;
#endif

#ifdef _LH6000
#define LITTLE_ENDIAN_HW 1
#endif

#if defined(_LINUX) || defined(_VMWARE)
#define LITTLE_ENDIAN_HW 1
#endif

#ifdef _AIX_COMBO
#ifdef BIU_BSE
#define LITTLE_ENDIAN_HW 1
#else
#define BIG_ENDIAN_HW 1
#endif
#endif

/* For UNIXWARE, BIU_BSE is NOT implemented yet */
#ifdef _UW
#define LITTLE_ENDIAN_HW 1
#endif

/* For SOLARIS, BIU_BSE is implemented in dev_attr */
#ifdef _SOLARIS
#if     defined(sparc)
#define BIG_ENDIAN_HW 1
#endif
#if     defined(i386)
#define LITTLE_ENDIAN_HW 1
#endif
#endif

#if defined(WIN32)
typedef unsigned short ushort;
typedef unsigned char uchar;
#endif


/*
 * Well-known address identifiers for services.
 */
#define BROADCAST_SERVER	0xffffff
#define F_PORT_SERVER		0xfffffe
#define FABRIC_CONTROLLER	0xfffffd
#define NAME_SERVER		0xfffffc
#define TIME_SERVER		0xfffffb
#define MANAGEMENT_SERVER	0xfffffa
#define QUALITY_OF_SERVICE_FACILITATOR	0xfffff9
#define ALIAS_SERVER		0xfffff8
#define SECURITY_KEY_DISTRIBUTION_SERVICE 0xfffff7
#define CLOCK_SYNCHRONIZATION_SERVER	0xfffff6
#define MULTICAST_SERVER	0xfffff5



#define SCR_DID         ((uint32)0xfffffd)
#define Fabric_DID      ((uint32)0xfffffe)
#define Bcast_DID       ((uint32)0xffffff)
#define Mask_DID        ((uint32)0xffffff)

/*
 *  Common Transport structures and definitions
 *
 */

union CtRevisionId {
   /* Structure is in Big Endian format */
   struct {
      u32bit Revision:    8;
      u32bit InId:       24;
   } bits;
   uint32 word;
};

union CtCommandResponse {
   /* Structure is in Big Endian format */
   struct {
      u32bit CmdRsp:  16;
      u32bit Size:    16;
   } bits;
   uint32 word;
};

typedef struct FcCtCmdHdr
{
    /* Structure is in Big Endian format */
    uchar revision;	/* Revision level of the FC-CT protocol. */
    uchar IN_ID[3];	/* Unused by sender. */
    uchar fsType;	/* Fibre channel service type. */
    uchar fsSubType;	/* Fibre channel service sub-type. */
    uchar options;	/* FC-CT options. 0 for synchronous mode. */
    uchar reserved1;
    ushort cmdRspCode;	/* Command/response code. */
    uchar Rsrvd2[3];
    uchar reasonCode;	/* Rejection information. */
    uchar explanation;	/* Reason code explanation. */
    uchar vendorUnique;	/* Vendor unique reason code information. */
} FC_CT_CMD_HDR;

/*************************************************************************
 * CtPassThru command and acceptance structures.
 *************************************************************************/
typedef struct rsnnNnCmd
{
    uchar nodeName[8];
    uchar stringLength;
    uchar symbolicNodeName[255];
} RSNN_NN_CMD;

typedef struct rspnNnCmd
{
    uint32 portfcid;
    uchar stringLength;
    uchar symbolicPortName[255];
} RSPN_NN_CMD;

typedef struct rpnNnCmd
{
    uint32 portfcid;
    uchar portName[8];
} RPN_NN_CMD;

typedef struct rnnNnCmd
{
    uint32 portfcid;
    uchar nodeName[8];
} RNN_NN_CMD;

typedef struct gpiNnCmd
{
    uint32 portfcid;
} GPI_NN_CMD;

typedef struct gsnnNnCmd
{
    uchar nodeName[8];
} GSNN_NN_CMD;

typedef struct rsnnNnAcc
{
    uchar stringLength;
    uchar symbolicNodeName[255];

} RSNN_NN_ACC;


/************************************************************
 * Get All Next - GA_NXT command and acceptance structures.
 ***********************************************************/
typedef struct gaNxtCmd
{
    uchar reserved1;
    uint32 portId: 24;
} GA_NXT_CMD;

typedef struct gaNxtAcc
{
    uchar portType;
    uint32 portId: 24;
    uchar portName[8];
    uchar portNameLength;
    uchar symbolicPortName[255];
    uchar nodeName[8];
    uchar nodeNameLength;
    uchar symbolicNodeName[255];
    uchar initialProcessAssociator[8];
    uint32 classOfService;
    uchar fc4ProtocolTypes[32];
} GA_NXT_ACC;

/*****************************************************************
 * Get Port Identifiers - GID_FT command and acceptance structures.
 ****************************************************************/
typedef struct gidFtCmd
{
    uchar reserved1[3];
    uchar fc4Type;
} GID_FT_CMD;

typedef struct gidFtAcc
{
  struct port_id
  {
      uchar control;
      uint32 port: 24;
  } portId[256];
} GID_FT_ACC;


typedef union FcCtCmdBody
{
    RSNN_NN_CMD rsnnNn;
    RSPN_NN_CMD rspnNn;
    RPN_NN_CMD rpnNn;
	RNN_NN_CMD rnnNn;
    GPI_NN_CMD gpiNn;
    GSNN_NN_CMD gsnnNn;
    GA_NXT_CMD gaNxt;
    GID_FT_CMD gidFt;
    uchar body1[320];
} FC_CT_CMD_BODY;

typedef struct FcCtCmd
{
    FC_CT_CMD_HDR hdr;
    FC_CT_CMD_BODY body;
} FC_CT_CMD;

typedef union FcCtAccBody
{
    RSNN_NN_ACC rsnnNn;
    GA_NXT_ACC gaNxt;
    GID_FT_ACC gidFt;
    uchar body1[320];
} FC_CT_ACC_BODY;

typedef struct FcCtAcc
{
    FC_CT_CMD_HDR hdr;
    FC_CT_ACC_BODY body;
} FC_CT_ACC;





#define  FC_CT_REVISION        0x01



typedef struct SliCtRequest {
   /* Structure is in Big Endian format */
   union CtRevisionId RevisionId;
   uchar FsType;
   uchar FsSubType;
   uchar Options;
   uchar Rsrvd1;
   union CtCommandResponse CommandResponse;
   uchar Rsrvd2;
   uchar ReasonCode;
   uchar Explanation;
   uchar VendorUnique;

   union {
      uint32   PortID;
      struct gid {
         uchar PortType;            /* for GID_PT requests */
         uchar DomainScope;
         uchar AreaScope;
         uchar Fc4Type;             /* for GID_FT requests */
      } gid;
      struct rft {
         uint32 PortId;             /* For RFT_ID requests */
#if BIG_ENDIAN_HW
         u32bit rsvd0:   16;
         u32bit rsvd1:   7;
         u32bit fcpReg:  1;           /* Type 8 */
         u32bit rsvd2:   2;
         u32bit ipReg:   1;           /* Type 5 */
         u32bit rsvd3:   5;
#endif
#if LITTLE_ENDIAN_HW
         u32bit rsvd0:   16;
         u32bit fcpReg:  1;           /* Type 8 */
         u32bit rsvd1:   7;
         u32bit rsvd3:   5;
         u32bit ipReg:   1;           /* Type 5 */
         u32bit rsvd2:   2;
#endif
         uint32 rsvd[7];
      } rft;
   } un;
} SLI_CT_REQUEST, *PSLI_CT_REQUEST;

typedef struct CtRequest {
   /* Structure is in Big Endian format */
   union CtRevisionId RevisionId;
   uchar FsType;
   uchar FsSubType;
   uchar Options;
   uchar Rsrvd1;
   union CtCommandResponse CommandResponse;
   uchar Rsrvd2;
   uchar ReasonCode;
   uchar Explanation;
   uchar VendorUnique;

   union {
      HBA_UINT32   PortID;   /* 4 bytes */
      HBA_WWN      wwn;      /* 8 bytes */
   } un;
} CT_REQUEST;

#define  GSPN_REQUEST_SZ         (sizeof(CT_REQUEST) - 4)
#define  GSNN_REQUEST_SZ         (sizeof(CT_REQUEST))

typedef struct CTrspPID {
	/* Structure is in Big Endian format */
	u32bit last_id : 1;
	u32bit rsvd    : 7;
	u32bit port_id :24;
} CT_RSP_PID;

#define  SLI_CT_REVISION        1
#define  GID_REQUEST_SZ         (sizeof(SLI_CT_REQUEST))
#define  RFT_REQUEST_SZ         (sizeof(SLI_CT_REQUEST))


/*
 * FsType Definitions
 */

#define  SLI_CT_KEY_SERVICE               0xF7
#define  SLI_CT_ALIAS_SERVICE             0xF8
#define  SLI_CT_QUALITY_OF_SERVICE_FACILITATOR 0xF9
#define  SLI_CT_MANAGEMENT_SERVICE        0xFA
#define  SLI_CT_TIME_SERVICE              0xFB
#define  SLI_CT_DIRECTORY_SERVICE         0xFC
#define  SLI_CT_FABRIC_CONTROLLER_SERVICE 0xFD
#define  SLI_CT_NO_SERVICE		  0x0
/*
 * Options
 */

#define  SLI_CT_EXCHANGE_MAPPING_OPTS     0x80
#define  SLI_CT_PARTIAL_RSP_OPTS	  0x40
#define  SLI_CT_EXTND_PREAMBLE_OPTS	  0x20

/*
 * Directory Service Subtypes
 */

#define  SLI_CT_DIRECTORY_NAME_SERVER     0x02

/*
 * Response Codes
 */

#define  SLI_CT_RESPONSE_FS_RJT           0x8001
#define  SLI_CT_RESPONSE_FS_ACC           0x8002

/*
 * Reason Codes
 */

#define  SLI_CT_INVALID_COMMAND           0x01
#define  SLI_CT_INVALID_VERSION           0x02
#define  SLI_CT_LOGICAL_ERROR             0x03
#define  SLI_CT_INVALID_IU_SIZE           0x04
#define  SLI_CT_LOGICAL_BUSY              0x05
#define  SLI_CT_PROTOCOL_ERROR            0x07
#define  SLI_CT_UNABLE_TO_PERFORM_REQ     0x09
#define  SLI_CT_REQ_NOT_SUPPORTED         0x0b
#define  SLI_CT_VENDOR_UNIQUE             0xff

/*
 * Name Server SLI_CT_UNABLE_TO_PERFORM_REQ Explanations
 */

#define  SLI_CT_NO_PORT_ID                0x01
#define  SLI_CT_NO_PORT_NAME              0x02
#define  SLI_CT_NO_NODE_NAME              0x03
#define  SLI_CT_NO_CLASS_OF_SERVICE       0x04
#define  SLI_CT_NO_IP_ADDRESS             0x05
#define  SLI_CT_NO_IPA                    0x06
#define  SLI_CT_NO_FC4_TYPES              0x07
#define  SLI_CT_NO_SYMBOLIC_PORT_NAME     0x08
#define  SLI_CT_NO_SYMBOLIC_NODE_NAME     0x09
#define  SLI_CT_NO_PORT_TYPE              0x0A
#define  SLI_CT_ACCESS_DENIED             0x10
#define  SLI_CT_INVALID_PORT_ID           0x11
#define  SLI_CT_DATABASE_EMPTY            0x12

/* Generic #define for no command */
#define SLI_CT_NO_COMMAND 0x00


/*
 * Name Server Command Codes
 */

#define  SLI_CTNS_GA_NXT      0x0100
#define  SLI_CTNS_GPN_ID      0x0112
#define  SLI_CTNS_GNN_ID      0x0113
#define  SLI_CTNS_GCS_ID      0x0114
#define  SLI_CTNS_GFT_ID      0x0117
#define  SLI_CTNS_GSPN_ID     0x0118
#define  SLI_CTNS_GPT_ID      0x011A
#define  SLI_CTNS_GID_PN      0x0121
#define  SLI_CTNS_GID_NN      0x0131
#define  SLI_CTNS_GIP_NN      0x0135
#define  SLI_CTNS_GIPA_NN     0x0136
#define  SLI_CTNS_GSNN_NN     0x0139
#define  SLI_CTNS_GNN_IP      0x0153
#define  SLI_CTNS_GIPA_IP     0x0156
#define  SLI_CTNS_GID_FT      0x0171
#define  SLI_CTNS_GID_PT      0x01A1
#define  SLI_CTNS_RPN_ID      0x0212
#define  SLI_CTNS_RNN_ID      0x0213
#define  SLI_CTNS_RCS_ID      0x0214
#define  SLI_CTNS_RFT_ID      0x0217
#define  SLI_CTNS_RSPN_ID     0x0218
#define  SLI_CTNS_RPT_ID      0x021A
#define  SLI_CTNS_RIP_NN      0x0235
#define  SLI_CTNS_RIPA_NN     0x0236
#define  SLI_CTNS_RSNN_NN     0x0239
#define  SLI_CTNS_DA_ID       0x0300


/* Time server commands */
#define SLI_CTTS_GET_TIME	0x00b1	/* Get time request. */


/* Quality of service facilitator commands */
#define SLI_CTQS_QoSR	0x40	/* Quality of service request. */
#define SLI_CTQS_RVCS	0x41	/* Read virtual circuit status. */


/* Alias server commands */
#define SLI_CTAS_JNA	0x0001  /* Join alias group. */
#define SLI_CTAS_RMA	0x0002	/* Remove from alias group. */
#define SLI_CTAS_LSN	0x0003	/* Listen request. */
#define SLI_CTAS_SLSN	0x0004	/* Stop listen request. */
#define SLI_CTAS_RAG	0x0005	/* Read alias group. */
#define SLI_CTAS_ELS_GAID	0x30	/* Get Alias_ID. */
#define SLI_CTAS_ELS_FACT	0x31	/* Fabric activate Alias_ID. */
#define SLI_CTAS_ELS_FDACT	0x32	/* Fabric deactivate Alias_ID. */
#define SLI_CTAS_ELS_NACT	0x33	/* N_Port activate Alias_ID. */
#define SLI_CTAS_ELS_NDACT	0x34	/* N_Port deactivate Alias_ID. */


/* Security key distribution server commands */
#define SLI_CTSKDS_SKE_REQKEY	0x1000	/* Request key request. */
#define SLI_CTSKDS_SKE_KEYEXC	0x1100	/* Key exchange. */
#define SLI_CTSKDS_KEYAUT	0x1200	/* Key authenticate. */







/*
 * Port Types
 */

#define  SLI_CTPT_N_PORT      0x01
#define  SLI_CTPT_NL_PORT     0x02
#define  SLI_CTPT_FNL_PORT    0x03
#define  SLI_CTPT_FCP         0x08
#define  SLI_CTPT_NX_PORT     0x7F
#define  SLI_CTPT_F_PORT      0x81
#define  SLI_CTPT_FL_PORT     0x82
#define  SLI_CTPT_E_PORT      0x84

#define SLI_CT_LAST_ENTRY     0x80000000

#ifdef WIN32
typedef _int64 uint64;
#else
typedef long long uint64;
#endif



/*
 * Mgmt Info (Revised) used on output of SendRNID
 */

typedef struct HBA_MgmtInfo2 {
	uint64		wwn;
	uint64		wwn_reserved;
	uint32 			unittype;
	uint32 			PortId;
	uint32 			NumberOfAttachedNodes;
	ushort 			IPVersion;
	ushort 			UDPPort;
	uchar			IPAddress[16];
	ushort			reserved;
	ushort 			TopologyDiscoveryFlags;
} HBA_MGMTINFO2, *PHBA_MGMTINFO2;


/*
 *  SendRNID output structure
 */

/* The following is the layout of an ELS RNID response. */
typedef struct
{
    HBA_UINT8  GlobalID[16];
    HBA_UINT32 unittype;
    HBA_UINT32 PortId;
    HBA_UINT32 NumberOfAttachedNodes;
    HBA_UINT16 IPVersion;
    HBA_UINT16 UDPPort;
    HBA_UINT8 IPAddress[16];
    HBA_UINT16 reserved;
    HBA_UINT16 TopologyDiscoveryFlags;
} RNID_SPECIFIC_NODE_ID;

typedef struct
{
	HBA_WWN 				portName;
	HBA_WWN 				nodeName;
	RNID_SPECIFIC_NODE_ID 	specificNodeId;
}RNID_WITH_COMMON_NODE_ID;

typedef struct
{
	RNID_SPECIFIC_NODE_ID 	specificNodeId;
	HBA_UINT8 				unused[16];
}RNID_WITHOUT_COMMON_NODE_ID;

typedef struct
{
	HBA_UINT8  nodeIdDataFormat;
	HBA_UINT8  commonNodeIdDataLen;
	HBA_UINT8  reserved;
	HBA_UINT8  specificNodeIdDataLen;
    union
    {
        RNID_WITH_COMMON_NODE_ID    spNodeIdC;
        RNID_WITHOUT_COMMON_NODE_ID	spNodeId;
    }spNode;
} ELS_SEND_RNID;

typedef struct
{
    HBA_WWN wwnDestination;
    HBA_UINT16 wwnType;
    HBA_UINT32 status;
    HBA_UINT32 outSize;
    ELS_SEND_RNID elsSendRnid;
} IOCTL_SEND_RNID;

typedef struct
{
	HBA_WWN wwn;
	HBA_WWNTYPE wwntype;
	ULONG rsplen;
	UCHAR rspbuf;
} IOCTL_SEND_RNID_MINI;

typedef struct RNID_INFO {
	uchar		format;
	uchar		ComLen;
	uchar		rsrvd1;
	uchar		SpecLen;
	uint64	PortName;
	uint64	NodeName;
	HBA_MGMTINFO2		MI2;
} RNID_INFO, *PRNID_INFO;

// LUN Reporting

typedef struct {
	HBA_UINT8	opCode;
	HBA_UINT8   reserved0[5];
	HBA_UINT32  allocLength;
	HBA_UINT8   reserved1;
	HBA_UINT8   control;
} REPORT_LUNS_REQ;

typedef struct {
	HBA_UINT64		lun;
} LUN_ENTRY;

typedef struct {
	HBA_UINT32		lunListLength;
	HBA_UINT32		reserved;
	LUN_ENTRY 		entry[1]; /* Variable length array */
} LUN_MAP;



/*
 * SCSI Inquiry Data
 *
 * Format of data returned as a result of an INQUIRY command.
 *
 */
#ifdef SOLARIS

#if defined(_BIT_FIELDS_LTOH)
struct scsi_inquiry {

	/*
	 * byte 0
	 *
	 * Bits 7-5 are the Peripheral Device Qualifier
	 * Bits 4-0 are the Peripheral Device Type
	 *
	 */

	uchar_t	inq_dtype;

	/* byte 1 */
	uchar_t	inq_qual	: 7,	/* device type qualifier	*/
		inq_rmb		: 1;	/* removable media		*/

	/* byte 2 */
	uchar_t	inq_ansi	: 3,	/* ANSI version 		*/
		inq_ecma	: 3,	/* ECMA version 		*/
		inq_iso		: 2;	/* ISO version 			*/

	/* byte 3 */
	uchar_t	inq_rdf		: 4,	/* response data format 	*/
				: 1,	/* reserved 			*/
		inq_normaca	: 1,	/* setting NACA bit supported */
		inq_trmiop	: 1,	/* TERMINATE I/O PROC msg 	*/
		inq_aenc	: 1;	/* async event notification cap. */

	/* bytes 4-7 */

	uchar_t	inq_len;		/* additional length 		*/

	uchar_t			: 8;	/* reserved 			*/

	uchar_t	inq_addr16	: 1,	/* supports 16 bit wide SCSI addr */
		inq_addr32	: 1,	/* supports 32 bit wide SCSI addr */
		inq_ackqreqq	: 1,	/* data tranfer on Q cable */
		inq_mchngr	: 1,	/* embedded/attached to medium chngr */
		inq_dualp	: 1,	/* dual port device */
		inq_port	: 1,	/* port receiving inquiry cmd */
				: 2;	/* reserved 			*/

	uchar_t	inq_sftre	: 1,	/* supports Soft Reset option 	*/
		inq_cmdque	: 1,	/* supports command queueing 	*/
		inq_trandis	: 1,	/* supports transfer disable messages */
		inq_linked	: 1,	/* supports linked commands 	*/
		inq_sync	: 1,	/* supports synchronous data xfers */
		inq_wbus16	: 1,	/* supports 16 bit wide data xfers */
		inq_wbus32	: 1,	/* supports 32 bit wide data xfers */
		inq_reladdr	: 1;	/* supports relative addressing */

	/* bytes 8-35 */

	char	inq_vid[8];		/* vendor ID 			*/
	char	inq_pid[16];		/* product ID 			*/
	char	inq_revision[4];	/* revision level 		*/
	char	inq_serial[12];
	/*
	 * Bytes 36-55 are vendor-specific.
	 * Bytes 56-95 are reserved.
	 * 96 to 'n' are vendor-specific parameter bytes
	 */
};

#elif defined(_BIT_FIELDS_HTOL)

struct scsi_inquiry {

	/*
	 * byte 0
	 *
	 * Bits 7-5 are the Peripheral Device Qualifier
	 * Bits 4-0 are the Peripheral Device Type
	 *
	 */


	uchar_t	inq_dtype;

	/* byte 1 */
	uchar_t	inq_rmb		: 1,	/* removable media */
		inq_qual	: 7;	/* device type qualifier */

	/* byte 2 */
	uchar_t	inq_iso		: 2,	/* ISO version */
		inq_ecma	: 3,	/* ECMA version */
		inq_ansi	: 3;	/* ANSI version */

	/* byte 3 */
	uchar_t	inq_aenc	: 1,	/* async event notification cap. */
		inq_trmiop	: 1,	/* supports TERMINATE I/O PROC msg */
		inq_normaca	: 1,	/* setting NACA bit supported */
				: 1,	/* reserved */
		inq_rdf		: 4;	/* response data format */

	/* bytes 4-7 */

	uchar_t	inq_len;		/* additional length */

	uchar_t			: 8;	/* reserved */

	uchar_t			: 2,	/* reserved 			*/
		inq_port	: 1,	/* port receiving inquiry cmd */
		inq_dualp	: 1,	/* dual port device */
		inq_mchngr	: 1,	/* embedded/attached to medium chngr */
		inq_ackqreqq	: 1,	/* data tranfer on Q cable */
		inq_addr32	: 1,	/* supports 32 bit wide SCSI addr */
		inq_addr16	: 1;	/* supports 16 bit wide SCSI addr */

	uchar_t	inq_reladdr	: 1,	/* supports relative addressing */
		inq_wbus32	: 1,	/* supports 32 bit wide data xfers */
		inq_wbus16	: 1,	/* supports 16 bit wide data xfers */
		inq_sync	: 1,	/* supports synchronous data xfers */
		inq_linked	: 1,	/* supports linked commands */
		inq_trandis	: 1,	/* supports transfer disable messages */
		inq_cmdque	: 1,	/* supports command queueing */
		inq_sftre	: 1;	/* supports Soft Reset option */

	/* bytes 8-35 */

	char	inq_vid[8];		/* vendor ID */

	char	inq_pid[16];		/* product ID */

	char	inq_revision[4];	/* revision level */

	char	inq_serial[12];		/* serial number */
	/*
	 * Bytes 36-55 are vendor-specific.
	 * Bytes 56-95 are reserved.
	 * 96 to 'n' are vendor-specific parameter bytes
	 */
};
#else
#error	One of _BIT_FIELDS_LTOH or _BIT_FIELDS_HTOL must be defined
#endif	/* _BIT_FIELDS_LTOH */

#endif /* SOLARIS */


#endif  /* _H_FC_HW */
