// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package auditmanager

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAssessmentReportEvidenceFolder = "AssociateAssessmentReportEvidenceFolder"

// AssociateAssessmentReportEvidenceFolderRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAssessmentReportEvidenceFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAssessmentReportEvidenceFolder for more information on using the AssociateAssessmentReportEvidenceFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAssessmentReportEvidenceFolderRequest method.
//    req, resp := client.AssociateAssessmentReportEvidenceFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder
func (c *AuditManager) AssociateAssessmentReportEvidenceFolderRequest(input *AssociateAssessmentReportEvidenceFolderInput) (req *request.Request, output *AssociateAssessmentReportEvidenceFolderOutput) {
	op := &request.Operation{
		Name:       opAssociateAssessmentReportEvidenceFolder,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/associateToAssessmentReport",
	}

	if input == nil {
		input = &AssociateAssessmentReportEvidenceFolderInput{}
	}

	output = &AssociateAssessmentReportEvidenceFolderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateAssessmentReportEvidenceFolder API operation for AWS Audit Manager.
//
// Associates an evidence folder to the specified assessment report in AWS Audit
// Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation AssociateAssessmentReportEvidenceFolder for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder
func (c *AuditManager) AssociateAssessmentReportEvidenceFolder(input *AssociateAssessmentReportEvidenceFolderInput) (*AssociateAssessmentReportEvidenceFolderOutput, error) {
	req, out := c.AssociateAssessmentReportEvidenceFolderRequest(input)
	return out, req.Send()
}

// AssociateAssessmentReportEvidenceFolderWithContext is the same as AssociateAssessmentReportEvidenceFolder with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAssessmentReportEvidenceFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) AssociateAssessmentReportEvidenceFolderWithContext(ctx aws.Context, input *AssociateAssessmentReportEvidenceFolderInput, opts ...request.Option) (*AssociateAssessmentReportEvidenceFolderOutput, error) {
	req, out := c.AssociateAssessmentReportEvidenceFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateAssessmentReportEvidence = "BatchAssociateAssessmentReportEvidence"

// BatchAssociateAssessmentReportEvidenceRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateAssessmentReportEvidence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateAssessmentReportEvidence for more information on using the BatchAssociateAssessmentReportEvidence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchAssociateAssessmentReportEvidenceRequest method.
//    req, resp := client.BatchAssociateAssessmentReportEvidenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence
func (c *AuditManager) BatchAssociateAssessmentReportEvidenceRequest(input *BatchAssociateAssessmentReportEvidenceInput) (req *request.Request, output *BatchAssociateAssessmentReportEvidenceOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateAssessmentReportEvidence,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/batchAssociateToAssessmentReport",
	}

	if input == nil {
		input = &BatchAssociateAssessmentReportEvidenceInput{}
	}

	output = &BatchAssociateAssessmentReportEvidenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAssociateAssessmentReportEvidence API operation for AWS Audit Manager.
//
// Associates a list of evidence to an assessment report in an AWS Audit Manager
// assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation BatchAssociateAssessmentReportEvidence for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence
func (c *AuditManager) BatchAssociateAssessmentReportEvidence(input *BatchAssociateAssessmentReportEvidenceInput) (*BatchAssociateAssessmentReportEvidenceOutput, error) {
	req, out := c.BatchAssociateAssessmentReportEvidenceRequest(input)
	return out, req.Send()
}

// BatchAssociateAssessmentReportEvidenceWithContext is the same as BatchAssociateAssessmentReportEvidence with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateAssessmentReportEvidence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) BatchAssociateAssessmentReportEvidenceWithContext(ctx aws.Context, input *BatchAssociateAssessmentReportEvidenceInput, opts ...request.Option) (*BatchAssociateAssessmentReportEvidenceOutput, error) {
	req, out := c.BatchAssociateAssessmentReportEvidenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateDelegationByAssessment = "BatchCreateDelegationByAssessment"

// BatchCreateDelegationByAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateDelegationByAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateDelegationByAssessment for more information on using the BatchCreateDelegationByAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateDelegationByAssessmentRequest method.
//    req, resp := client.BatchCreateDelegationByAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment
func (c *AuditManager) BatchCreateDelegationByAssessmentRequest(input *BatchCreateDelegationByAssessmentInput) (req *request.Request, output *BatchCreateDelegationByAssessmentOutput) {
	op := &request.Operation{
		Name:       opBatchCreateDelegationByAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/assessments/{assessmentId}/delegations",
	}

	if input == nil {
		input = &BatchCreateDelegationByAssessmentInput{}
	}

	output = &BatchCreateDelegationByAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateDelegationByAssessment API operation for AWS Audit Manager.
//
// Create a batch of delegations for a specified assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation BatchCreateDelegationByAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment
func (c *AuditManager) BatchCreateDelegationByAssessment(input *BatchCreateDelegationByAssessmentInput) (*BatchCreateDelegationByAssessmentOutput, error) {
	req, out := c.BatchCreateDelegationByAssessmentRequest(input)
	return out, req.Send()
}

// BatchCreateDelegationByAssessmentWithContext is the same as BatchCreateDelegationByAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateDelegationByAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) BatchCreateDelegationByAssessmentWithContext(ctx aws.Context, input *BatchCreateDelegationByAssessmentInput, opts ...request.Option) (*BatchCreateDelegationByAssessmentOutput, error) {
	req, out := c.BatchCreateDelegationByAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteDelegationByAssessment = "BatchDeleteDelegationByAssessment"

// BatchDeleteDelegationByAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteDelegationByAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteDelegationByAssessment for more information on using the BatchDeleteDelegationByAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteDelegationByAssessmentRequest method.
//    req, resp := client.BatchDeleteDelegationByAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment
func (c *AuditManager) BatchDeleteDelegationByAssessmentRequest(input *BatchDeleteDelegationByAssessmentInput) (req *request.Request, output *BatchDeleteDelegationByAssessmentOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteDelegationByAssessment,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/delegations",
	}

	if input == nil {
		input = &BatchDeleteDelegationByAssessmentInput{}
	}

	output = &BatchDeleteDelegationByAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteDelegationByAssessment API operation for AWS Audit Manager.
//
// Deletes the delegations in the specified AWS Audit Manager assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation BatchDeleteDelegationByAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment
func (c *AuditManager) BatchDeleteDelegationByAssessment(input *BatchDeleteDelegationByAssessmentInput) (*BatchDeleteDelegationByAssessmentOutput, error) {
	req, out := c.BatchDeleteDelegationByAssessmentRequest(input)
	return out, req.Send()
}

// BatchDeleteDelegationByAssessmentWithContext is the same as BatchDeleteDelegationByAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteDelegationByAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) BatchDeleteDelegationByAssessmentWithContext(ctx aws.Context, input *BatchDeleteDelegationByAssessmentInput, opts ...request.Option) (*BatchDeleteDelegationByAssessmentOutput, error) {
	req, out := c.BatchDeleteDelegationByAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateAssessmentReportEvidence = "BatchDisassociateAssessmentReportEvidence"

// BatchDisassociateAssessmentReportEvidenceRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateAssessmentReportEvidence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateAssessmentReportEvidence for more information on using the BatchDisassociateAssessmentReportEvidence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisassociateAssessmentReportEvidenceRequest method.
//    req, resp := client.BatchDisassociateAssessmentReportEvidenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence
func (c *AuditManager) BatchDisassociateAssessmentReportEvidenceRequest(input *BatchDisassociateAssessmentReportEvidenceInput) (req *request.Request, output *BatchDisassociateAssessmentReportEvidenceOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateAssessmentReportEvidence,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/batchDisassociateFromAssessmentReport",
	}

	if input == nil {
		input = &BatchDisassociateAssessmentReportEvidenceInput{}
	}

	output = &BatchDisassociateAssessmentReportEvidenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisassociateAssessmentReportEvidence API operation for AWS Audit Manager.
//
// Disassociates a list of evidence from the specified assessment report in
// AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation BatchDisassociateAssessmentReportEvidence for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence
func (c *AuditManager) BatchDisassociateAssessmentReportEvidence(input *BatchDisassociateAssessmentReportEvidenceInput) (*BatchDisassociateAssessmentReportEvidenceOutput, error) {
	req, out := c.BatchDisassociateAssessmentReportEvidenceRequest(input)
	return out, req.Send()
}

// BatchDisassociateAssessmentReportEvidenceWithContext is the same as BatchDisassociateAssessmentReportEvidence with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateAssessmentReportEvidence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) BatchDisassociateAssessmentReportEvidenceWithContext(ctx aws.Context, input *BatchDisassociateAssessmentReportEvidenceInput, opts ...request.Option) (*BatchDisassociateAssessmentReportEvidenceOutput, error) {
	req, out := c.BatchDisassociateAssessmentReportEvidenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchImportEvidenceToAssessmentControl = "BatchImportEvidenceToAssessmentControl"

// BatchImportEvidenceToAssessmentControlRequest generates a "aws/request.Request" representing the
// client's request for the BatchImportEvidenceToAssessmentControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchImportEvidenceToAssessmentControl for more information on using the BatchImportEvidenceToAssessmentControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchImportEvidenceToAssessmentControlRequest method.
//    req, resp := client.BatchImportEvidenceToAssessmentControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl
func (c *AuditManager) BatchImportEvidenceToAssessmentControlRequest(input *BatchImportEvidenceToAssessmentControlInput) (req *request.Request, output *BatchImportEvidenceToAssessmentControlOutput) {
	op := &request.Operation{
		Name:       opBatchImportEvidenceToAssessmentControl,
		HTTPMethod: "POST",
		HTTPPath:   "/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}/evidence",
	}

	if input == nil {
		input = &BatchImportEvidenceToAssessmentControlInput{}
	}

	output = &BatchImportEvidenceToAssessmentControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchImportEvidenceToAssessmentControl API operation for AWS Audit Manager.
//
// Uploads one or more pieces of evidence to the specified control in the assessment
// in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation BatchImportEvidenceToAssessmentControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl
func (c *AuditManager) BatchImportEvidenceToAssessmentControl(input *BatchImportEvidenceToAssessmentControlInput) (*BatchImportEvidenceToAssessmentControlOutput, error) {
	req, out := c.BatchImportEvidenceToAssessmentControlRequest(input)
	return out, req.Send()
}

// BatchImportEvidenceToAssessmentControlWithContext is the same as BatchImportEvidenceToAssessmentControl with the addition of
// the ability to pass a context and additional request options.
//
// See BatchImportEvidenceToAssessmentControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) BatchImportEvidenceToAssessmentControlWithContext(ctx aws.Context, input *BatchImportEvidenceToAssessmentControlInput, opts ...request.Option) (*BatchImportEvidenceToAssessmentControlOutput, error) {
	req, out := c.BatchImportEvidenceToAssessmentControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssessment = "CreateAssessment"

// CreateAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssessment for more information on using the CreateAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssessmentRequest method.
//    req, resp := client.CreateAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment
func (c *AuditManager) CreateAssessmentRequest(input *CreateAssessmentInput) (req *request.Request, output *CreateAssessmentOutput) {
	op := &request.Operation{
		Name:       opCreateAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/assessments",
	}

	if input == nil {
		input = &CreateAssessmentInput{}
	}

	output = &CreateAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssessment API operation for AWS Audit Manager.
//
// Creates an assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation CreateAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment
func (c *AuditManager) CreateAssessment(input *CreateAssessmentInput) (*CreateAssessmentOutput, error) {
	req, out := c.CreateAssessmentRequest(input)
	return out, req.Send()
}

// CreateAssessmentWithContext is the same as CreateAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) CreateAssessmentWithContext(ctx aws.Context, input *CreateAssessmentInput, opts ...request.Option) (*CreateAssessmentOutput, error) {
	req, out := c.CreateAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssessmentFramework = "CreateAssessmentFramework"

// CreateAssessmentFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssessmentFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssessmentFramework for more information on using the CreateAssessmentFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssessmentFrameworkRequest method.
//    req, resp := client.CreateAssessmentFrameworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework
func (c *AuditManager) CreateAssessmentFrameworkRequest(input *CreateAssessmentFrameworkInput) (req *request.Request, output *CreateAssessmentFrameworkOutput) {
	op := &request.Operation{
		Name:       opCreateAssessmentFramework,
		HTTPMethod: "POST",
		HTTPPath:   "/assessmentFrameworks",
	}

	if input == nil {
		input = &CreateAssessmentFrameworkInput{}
	}

	output = &CreateAssessmentFrameworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssessmentFramework API operation for AWS Audit Manager.
//
// Creates a custom framework in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation CreateAssessmentFramework for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework
func (c *AuditManager) CreateAssessmentFramework(input *CreateAssessmentFrameworkInput) (*CreateAssessmentFrameworkOutput, error) {
	req, out := c.CreateAssessmentFrameworkRequest(input)
	return out, req.Send()
}

// CreateAssessmentFrameworkWithContext is the same as CreateAssessmentFramework with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssessmentFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) CreateAssessmentFrameworkWithContext(ctx aws.Context, input *CreateAssessmentFrameworkInput, opts ...request.Option) (*CreateAssessmentFrameworkOutput, error) {
	req, out := c.CreateAssessmentFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssessmentReport = "CreateAssessmentReport"

// CreateAssessmentReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssessmentReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssessmentReport for more information on using the CreateAssessmentReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssessmentReportRequest method.
//    req, resp := client.CreateAssessmentReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport
func (c *AuditManager) CreateAssessmentReportRequest(input *CreateAssessmentReportInput) (req *request.Request, output *CreateAssessmentReportOutput) {
	op := &request.Operation{
		Name:       opCreateAssessmentReport,
		HTTPMethod: "POST",
		HTTPPath:   "/assessments/{assessmentId}/reports",
	}

	if input == nil {
		input = &CreateAssessmentReportInput{}
	}

	output = &CreateAssessmentReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssessmentReport API operation for AWS Audit Manager.
//
// Creates an assessment report for the specified assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation CreateAssessmentReport for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport
func (c *AuditManager) CreateAssessmentReport(input *CreateAssessmentReportInput) (*CreateAssessmentReportOutput, error) {
	req, out := c.CreateAssessmentReportRequest(input)
	return out, req.Send()
}

// CreateAssessmentReportWithContext is the same as CreateAssessmentReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssessmentReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) CreateAssessmentReportWithContext(ctx aws.Context, input *CreateAssessmentReportInput, opts ...request.Option) (*CreateAssessmentReportOutput, error) {
	req, out := c.CreateAssessmentReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateControl = "CreateControl"

// CreateControlRequest generates a "aws/request.Request" representing the
// client's request for the CreateControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateControl for more information on using the CreateControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateControlRequest method.
//    req, resp := client.CreateControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl
func (c *AuditManager) CreateControlRequest(input *CreateControlInput) (req *request.Request, output *CreateControlOutput) {
	op := &request.Operation{
		Name:       opCreateControl,
		HTTPMethod: "POST",
		HTTPPath:   "/controls",
	}

	if input == nil {
		input = &CreateControlInput{}
	}

	output = &CreateControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateControl API operation for AWS Audit Manager.
//
// Creates a new custom control in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation CreateControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl
func (c *AuditManager) CreateControl(input *CreateControlInput) (*CreateControlOutput, error) {
	req, out := c.CreateControlRequest(input)
	return out, req.Send()
}

// CreateControlWithContext is the same as CreateControl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) CreateControlWithContext(ctx aws.Context, input *CreateControlInput, opts ...request.Option) (*CreateControlOutput, error) {
	req, out := c.CreateControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssessment = "DeleteAssessment"

// DeleteAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssessment for more information on using the DeleteAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssessmentRequest method.
//    req, resp := client.DeleteAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment
func (c *AuditManager) DeleteAssessmentRequest(input *DeleteAssessmentInput) (req *request.Request, output *DeleteAssessmentOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assessments/{assessmentId}",
	}

	if input == nil {
		input = &DeleteAssessmentInput{}
	}

	output = &DeleteAssessmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssessment API operation for AWS Audit Manager.
//
// Deletes an assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DeleteAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment
func (c *AuditManager) DeleteAssessment(input *DeleteAssessmentInput) (*DeleteAssessmentOutput, error) {
	req, out := c.DeleteAssessmentRequest(input)
	return out, req.Send()
}

// DeleteAssessmentWithContext is the same as DeleteAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DeleteAssessmentWithContext(ctx aws.Context, input *DeleteAssessmentInput, opts ...request.Option) (*DeleteAssessmentOutput, error) {
	req, out := c.DeleteAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssessmentFramework = "DeleteAssessmentFramework"

// DeleteAssessmentFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssessmentFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssessmentFramework for more information on using the DeleteAssessmentFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssessmentFrameworkRequest method.
//    req, resp := client.DeleteAssessmentFrameworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework
func (c *AuditManager) DeleteAssessmentFrameworkRequest(input *DeleteAssessmentFrameworkInput) (req *request.Request, output *DeleteAssessmentFrameworkOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessmentFramework,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assessmentFrameworks/{frameworkId}",
	}

	if input == nil {
		input = &DeleteAssessmentFrameworkInput{}
	}

	output = &DeleteAssessmentFrameworkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssessmentFramework API operation for AWS Audit Manager.
//
// Deletes a custom framework in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DeleteAssessmentFramework for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework
func (c *AuditManager) DeleteAssessmentFramework(input *DeleteAssessmentFrameworkInput) (*DeleteAssessmentFrameworkOutput, error) {
	req, out := c.DeleteAssessmentFrameworkRequest(input)
	return out, req.Send()
}

// DeleteAssessmentFrameworkWithContext is the same as DeleteAssessmentFramework with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssessmentFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DeleteAssessmentFrameworkWithContext(ctx aws.Context, input *DeleteAssessmentFrameworkInput, opts ...request.Option) (*DeleteAssessmentFrameworkOutput, error) {
	req, out := c.DeleteAssessmentFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssessmentReport = "DeleteAssessmentReport"

// DeleteAssessmentReportRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssessmentReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssessmentReport for more information on using the DeleteAssessmentReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssessmentReportRequest method.
//    req, resp := client.DeleteAssessmentReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport
func (c *AuditManager) DeleteAssessmentReportRequest(input *DeleteAssessmentReportInput) (req *request.Request, output *DeleteAssessmentReportOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessmentReport,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assessments/{assessmentId}/reports/{assessmentReportId}",
	}

	if input == nil {
		input = &DeleteAssessmentReportInput{}
	}

	output = &DeleteAssessmentReportOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssessmentReport API operation for AWS Audit Manager.
//
// Deletes an assessment report from an assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DeleteAssessmentReport for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport
func (c *AuditManager) DeleteAssessmentReport(input *DeleteAssessmentReportInput) (*DeleteAssessmentReportOutput, error) {
	req, out := c.DeleteAssessmentReportRequest(input)
	return out, req.Send()
}

// DeleteAssessmentReportWithContext is the same as DeleteAssessmentReport with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssessmentReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DeleteAssessmentReportWithContext(ctx aws.Context, input *DeleteAssessmentReportInput, opts ...request.Option) (*DeleteAssessmentReportOutput, error) {
	req, out := c.DeleteAssessmentReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteControl = "DeleteControl"

// DeleteControlRequest generates a "aws/request.Request" representing the
// client's request for the DeleteControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteControl for more information on using the DeleteControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteControlRequest method.
//    req, resp := client.DeleteControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl
func (c *AuditManager) DeleteControlRequest(input *DeleteControlInput) (req *request.Request, output *DeleteControlOutput) {
	op := &request.Operation{
		Name:       opDeleteControl,
		HTTPMethod: "DELETE",
		HTTPPath:   "/controls/{controlId}",
	}

	if input == nil {
		input = &DeleteControlInput{}
	}

	output = &DeleteControlOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteControl API operation for AWS Audit Manager.
//
// Deletes a custom control in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DeleteControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl
func (c *AuditManager) DeleteControl(input *DeleteControlInput) (*DeleteControlOutput, error) {
	req, out := c.DeleteControlRequest(input)
	return out, req.Send()
}

// DeleteControlWithContext is the same as DeleteControl with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DeleteControlWithContext(ctx aws.Context, input *DeleteControlInput, opts ...request.Option) (*DeleteControlOutput, error) {
	req, out := c.DeleteControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterAccount = "DeregisterAccount"

// DeregisterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterAccount for more information on using the DeregisterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterAccountRequest method.
//    req, resp := client.DeregisterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount
func (c *AuditManager) DeregisterAccountRequest(input *DeregisterAccountInput) (req *request.Request, output *DeregisterAccountOutput) {
	op := &request.Operation{
		Name:       opDeregisterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/account/deregisterAccount",
	}

	if input == nil {
		input = &DeregisterAccountInput{}
	}

	output = &DeregisterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterAccount API operation for AWS Audit Manager.
//
// Deregisters an account in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DeregisterAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount
func (c *AuditManager) DeregisterAccount(input *DeregisterAccountInput) (*DeregisterAccountOutput, error) {
	req, out := c.DeregisterAccountRequest(input)
	return out, req.Send()
}

// DeregisterAccountWithContext is the same as DeregisterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DeregisterAccountWithContext(ctx aws.Context, input *DeregisterAccountInput, opts ...request.Option) (*DeregisterAccountOutput, error) {
	req, out := c.DeregisterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterOrganizationAdminAccount = "DeregisterOrganizationAdminAccount"

// DeregisterOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterOrganizationAdminAccount for more information on using the DeregisterOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterOrganizationAdminAccountRequest method.
//    req, resp := client.DeregisterOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount
func (c *AuditManager) DeregisterOrganizationAdminAccountRequest(input *DeregisterOrganizationAdminAccountInput) (req *request.Request, output *DeregisterOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDeregisterOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/account/deregisterOrganizationAdminAccount",
	}

	if input == nil {
		input = &DeregisterOrganizationAdminAccountInput{}
	}

	output = &DeregisterOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterOrganizationAdminAccount API operation for AWS Audit Manager.
//
// Deregisters the delegated AWS administrator account from the AWS organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DeregisterOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount
func (c *AuditManager) DeregisterOrganizationAdminAccount(input *DeregisterOrganizationAdminAccountInput) (*DeregisterOrganizationAdminAccountOutput, error) {
	req, out := c.DeregisterOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DeregisterOrganizationAdminAccountWithContext is the same as DeregisterOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DeregisterOrganizationAdminAccountWithContext(ctx aws.Context, input *DeregisterOrganizationAdminAccountInput, opts ...request.Option) (*DeregisterOrganizationAdminAccountOutput, error) {
	req, out := c.DeregisterOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAssessmentReportEvidenceFolder = "DisassociateAssessmentReportEvidenceFolder"

// DisassociateAssessmentReportEvidenceFolderRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAssessmentReportEvidenceFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAssessmentReportEvidenceFolder for more information on using the DisassociateAssessmentReportEvidenceFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateAssessmentReportEvidenceFolderRequest method.
//    req, resp := client.DisassociateAssessmentReportEvidenceFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder
func (c *AuditManager) DisassociateAssessmentReportEvidenceFolderRequest(input *DisassociateAssessmentReportEvidenceFolderInput) (req *request.Request, output *DisassociateAssessmentReportEvidenceFolderOutput) {
	op := &request.Operation{
		Name:       opDisassociateAssessmentReportEvidenceFolder,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/disassociateFromAssessmentReport",
	}

	if input == nil {
		input = &DisassociateAssessmentReportEvidenceFolderInput{}
	}

	output = &DisassociateAssessmentReportEvidenceFolderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAssessmentReportEvidenceFolder API operation for AWS Audit Manager.
//
// Disassociates an evidence folder from the specified assessment report in
// AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation DisassociateAssessmentReportEvidenceFolder for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder
func (c *AuditManager) DisassociateAssessmentReportEvidenceFolder(input *DisassociateAssessmentReportEvidenceFolderInput) (*DisassociateAssessmentReportEvidenceFolderOutput, error) {
	req, out := c.DisassociateAssessmentReportEvidenceFolderRequest(input)
	return out, req.Send()
}

// DisassociateAssessmentReportEvidenceFolderWithContext is the same as DisassociateAssessmentReportEvidenceFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAssessmentReportEvidenceFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) DisassociateAssessmentReportEvidenceFolderWithContext(ctx aws.Context, input *DisassociateAssessmentReportEvidenceFolderInput, opts ...request.Option) (*DisassociateAssessmentReportEvidenceFolderOutput, error) {
	req, out := c.DisassociateAssessmentReportEvidenceFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountStatus = "GetAccountStatus"

// GetAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountStatus for more information on using the GetAccountStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountStatusRequest method.
//    req, resp := client.GetAccountStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus
func (c *AuditManager) GetAccountStatusRequest(input *GetAccountStatusInput) (req *request.Request, output *GetAccountStatusOutput) {
	op := &request.Operation{
		Name:       opGetAccountStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/account/status",
	}

	if input == nil {
		input = &GetAccountStatusInput{}
	}

	output = &GetAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountStatus API operation for AWS Audit Manager.
//
// Returns the registration status of an account in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetAccountStatus for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus
func (c *AuditManager) GetAccountStatus(input *GetAccountStatusInput) (*GetAccountStatusOutput, error) {
	req, out := c.GetAccountStatusRequest(input)
	return out, req.Send()
}

// GetAccountStatusWithContext is the same as GetAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetAccountStatusWithContext(ctx aws.Context, input *GetAccountStatusInput, opts ...request.Option) (*GetAccountStatusOutput, error) {
	req, out := c.GetAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssessment = "GetAssessment"

// GetAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the GetAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssessment for more information on using the GetAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssessmentRequest method.
//    req, resp := client.GetAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment
func (c *AuditManager) GetAssessmentRequest(input *GetAssessmentInput) (req *request.Request, output *GetAssessmentOutput) {
	op := &request.Operation{
		Name:       opGetAssessment,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}",
	}

	if input == nil {
		input = &GetAssessmentInput{}
	}

	output = &GetAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssessment API operation for AWS Audit Manager.
//
// Returns an assessment from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment
func (c *AuditManager) GetAssessment(input *GetAssessmentInput) (*GetAssessmentOutput, error) {
	req, out := c.GetAssessmentRequest(input)
	return out, req.Send()
}

// GetAssessmentWithContext is the same as GetAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetAssessmentWithContext(ctx aws.Context, input *GetAssessmentInput, opts ...request.Option) (*GetAssessmentOutput, error) {
	req, out := c.GetAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssessmentFramework = "GetAssessmentFramework"

// GetAssessmentFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the GetAssessmentFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssessmentFramework for more information on using the GetAssessmentFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssessmentFrameworkRequest method.
//    req, resp := client.GetAssessmentFrameworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework
func (c *AuditManager) GetAssessmentFrameworkRequest(input *GetAssessmentFrameworkInput) (req *request.Request, output *GetAssessmentFrameworkOutput) {
	op := &request.Operation{
		Name:       opGetAssessmentFramework,
		HTTPMethod: "GET",
		HTTPPath:   "/assessmentFrameworks/{frameworkId}",
	}

	if input == nil {
		input = &GetAssessmentFrameworkInput{}
	}

	output = &GetAssessmentFrameworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssessmentFramework API operation for AWS Audit Manager.
//
// Returns a framework from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetAssessmentFramework for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework
func (c *AuditManager) GetAssessmentFramework(input *GetAssessmentFrameworkInput) (*GetAssessmentFrameworkOutput, error) {
	req, out := c.GetAssessmentFrameworkRequest(input)
	return out, req.Send()
}

// GetAssessmentFrameworkWithContext is the same as GetAssessmentFramework with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssessmentFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetAssessmentFrameworkWithContext(ctx aws.Context, input *GetAssessmentFrameworkInput, opts ...request.Option) (*GetAssessmentFrameworkOutput, error) {
	req, out := c.GetAssessmentFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssessmentReportUrl = "GetAssessmentReportUrl"

// GetAssessmentReportUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetAssessmentReportUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssessmentReportUrl for more information on using the GetAssessmentReportUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssessmentReportUrlRequest method.
//    req, resp := client.GetAssessmentReportUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl
func (c *AuditManager) GetAssessmentReportUrlRequest(input *GetAssessmentReportUrlInput) (req *request.Request, output *GetAssessmentReportUrlOutput) {
	op := &request.Operation{
		Name:       opGetAssessmentReportUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/reports/{assessmentReportId}/url",
	}

	if input == nil {
		input = &GetAssessmentReportUrlInput{}
	}

	output = &GetAssessmentReportUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssessmentReportUrl API operation for AWS Audit Manager.
//
// Returns the URL of a specified assessment report in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetAssessmentReportUrl for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl
func (c *AuditManager) GetAssessmentReportUrl(input *GetAssessmentReportUrlInput) (*GetAssessmentReportUrlOutput, error) {
	req, out := c.GetAssessmentReportUrlRequest(input)
	return out, req.Send()
}

// GetAssessmentReportUrlWithContext is the same as GetAssessmentReportUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssessmentReportUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetAssessmentReportUrlWithContext(ctx aws.Context, input *GetAssessmentReportUrlInput, opts ...request.Option) (*GetAssessmentReportUrlOutput, error) {
	req, out := c.GetAssessmentReportUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeLogs = "GetChangeLogs"

// GetChangeLogsRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChangeLogs for more information on using the GetChangeLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChangeLogsRequest method.
//    req, resp := client.GetChangeLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs
func (c *AuditManager) GetChangeLogsRequest(input *GetChangeLogsInput) (req *request.Request, output *GetChangeLogsOutput) {
	op := &request.Operation{
		Name:       opGetChangeLogs,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/changelogs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetChangeLogsInput{}
	}

	output = &GetChangeLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeLogs API operation for AWS Audit Manager.
//
// Returns a list of changelogs from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetChangeLogs for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs
func (c *AuditManager) GetChangeLogs(input *GetChangeLogsInput) (*GetChangeLogsOutput, error) {
	req, out := c.GetChangeLogsRequest(input)
	return out, req.Send()
}

// GetChangeLogsWithContext is the same as GetChangeLogs with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetChangeLogsWithContext(ctx aws.Context, input *GetChangeLogsInput, opts ...request.Option) (*GetChangeLogsOutput, error) {
	req, out := c.GetChangeLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetChangeLogsPages iterates over the pages of a GetChangeLogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetChangeLogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetChangeLogs operation.
//    pageNum := 0
//    err := client.GetChangeLogsPages(params,
//        func(page *auditmanager.GetChangeLogsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) GetChangeLogsPages(input *GetChangeLogsInput, fn func(*GetChangeLogsOutput, bool) bool) error {
	return c.GetChangeLogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetChangeLogsPagesWithContext same as GetChangeLogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetChangeLogsPagesWithContext(ctx aws.Context, input *GetChangeLogsInput, fn func(*GetChangeLogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetChangeLogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetChangeLogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetChangeLogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetControl = "GetControl"

// GetControlRequest generates a "aws/request.Request" representing the
// client's request for the GetControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetControl for more information on using the GetControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetControlRequest method.
//    req, resp := client.GetControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl
func (c *AuditManager) GetControlRequest(input *GetControlInput) (req *request.Request, output *GetControlOutput) {
	op := &request.Operation{
		Name:       opGetControl,
		HTTPMethod: "GET",
		HTTPPath:   "/controls/{controlId}",
	}

	if input == nil {
		input = &GetControlInput{}
	}

	output = &GetControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetControl API operation for AWS Audit Manager.
//
// Returns a control from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl
func (c *AuditManager) GetControl(input *GetControlInput) (*GetControlOutput, error) {
	req, out := c.GetControlRequest(input)
	return out, req.Send()
}

// GetControlWithContext is the same as GetControl with the addition of
// the ability to pass a context and additional request options.
//
// See GetControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetControlWithContext(ctx aws.Context, input *GetControlInput, opts ...request.Option) (*GetControlOutput, error) {
	req, out := c.GetControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDelegations = "GetDelegations"

// GetDelegationsRequest generates a "aws/request.Request" representing the
// client's request for the GetDelegations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDelegations for more information on using the GetDelegations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDelegationsRequest method.
//    req, resp := client.GetDelegationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations
func (c *AuditManager) GetDelegationsRequest(input *GetDelegationsInput) (req *request.Request, output *GetDelegationsOutput) {
	op := &request.Operation{
		Name:       opGetDelegations,
		HTTPMethod: "GET",
		HTTPPath:   "/delegations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDelegationsInput{}
	}

	output = &GetDelegationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDelegations API operation for AWS Audit Manager.
//
// Returns a list of delegations from an audit owner to a delegate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetDelegations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations
func (c *AuditManager) GetDelegations(input *GetDelegationsInput) (*GetDelegationsOutput, error) {
	req, out := c.GetDelegationsRequest(input)
	return out, req.Send()
}

// GetDelegationsWithContext is the same as GetDelegations with the addition of
// the ability to pass a context and additional request options.
//
// See GetDelegations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetDelegationsWithContext(ctx aws.Context, input *GetDelegationsInput, opts ...request.Option) (*GetDelegationsOutput, error) {
	req, out := c.GetDelegationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDelegationsPages iterates over the pages of a GetDelegations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDelegations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDelegations operation.
//    pageNum := 0
//    err := client.GetDelegationsPages(params,
//        func(page *auditmanager.GetDelegationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) GetDelegationsPages(input *GetDelegationsInput, fn func(*GetDelegationsOutput, bool) bool) error {
	return c.GetDelegationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDelegationsPagesWithContext same as GetDelegationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetDelegationsPagesWithContext(ctx aws.Context, input *GetDelegationsInput, fn func(*GetDelegationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDelegationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDelegationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDelegationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEvidence = "GetEvidence"

// GetEvidenceRequest generates a "aws/request.Request" representing the
// client's request for the GetEvidence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvidence for more information on using the GetEvidence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEvidenceRequest method.
//    req, resp := client.GetEvidenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence
func (c *AuditManager) GetEvidenceRequest(input *GetEvidenceInput) (req *request.Request, output *GetEvidenceOutput) {
	op := &request.Operation{
		Name:       opGetEvidence,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence/{evidenceId}",
	}

	if input == nil {
		input = &GetEvidenceInput{}
	}

	output = &GetEvidenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvidence API operation for AWS Audit Manager.
//
// Returns evidence from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetEvidence for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence
func (c *AuditManager) GetEvidence(input *GetEvidenceInput) (*GetEvidenceOutput, error) {
	req, out := c.GetEvidenceRequest(input)
	return out, req.Send()
}

// GetEvidenceWithContext is the same as GetEvidence with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvidence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceWithContext(ctx aws.Context, input *GetEvidenceInput, opts ...request.Option) (*GetEvidenceOutput, error) {
	req, out := c.GetEvidenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEvidenceByEvidenceFolder = "GetEvidenceByEvidenceFolder"

// GetEvidenceByEvidenceFolderRequest generates a "aws/request.Request" representing the
// client's request for the GetEvidenceByEvidenceFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvidenceByEvidenceFolder for more information on using the GetEvidenceByEvidenceFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEvidenceByEvidenceFolderRequest method.
//    req, resp := client.GetEvidenceByEvidenceFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder
func (c *AuditManager) GetEvidenceByEvidenceFolderRequest(input *GetEvidenceByEvidenceFolderInput) (req *request.Request, output *GetEvidenceByEvidenceFolderOutput) {
	op := &request.Operation{
		Name:       opGetEvidenceByEvidenceFolder,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEvidenceByEvidenceFolderInput{}
	}

	output = &GetEvidenceByEvidenceFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvidenceByEvidenceFolder API operation for AWS Audit Manager.
//
// Returns all evidence from a specified evidence folder in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetEvidenceByEvidenceFolder for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder
func (c *AuditManager) GetEvidenceByEvidenceFolder(input *GetEvidenceByEvidenceFolderInput) (*GetEvidenceByEvidenceFolderOutput, error) {
	req, out := c.GetEvidenceByEvidenceFolderRequest(input)
	return out, req.Send()
}

// GetEvidenceByEvidenceFolderWithContext is the same as GetEvidenceByEvidenceFolder with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvidenceByEvidenceFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceByEvidenceFolderWithContext(ctx aws.Context, input *GetEvidenceByEvidenceFolderInput, opts ...request.Option) (*GetEvidenceByEvidenceFolderOutput, error) {
	req, out := c.GetEvidenceByEvidenceFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEvidenceByEvidenceFolderPages iterates over the pages of a GetEvidenceByEvidenceFolder operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEvidenceByEvidenceFolder method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEvidenceByEvidenceFolder operation.
//    pageNum := 0
//    err := client.GetEvidenceByEvidenceFolderPages(params,
//        func(page *auditmanager.GetEvidenceByEvidenceFolderOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) GetEvidenceByEvidenceFolderPages(input *GetEvidenceByEvidenceFolderInput, fn func(*GetEvidenceByEvidenceFolderOutput, bool) bool) error {
	return c.GetEvidenceByEvidenceFolderPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEvidenceByEvidenceFolderPagesWithContext same as GetEvidenceByEvidenceFolderPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceByEvidenceFolderPagesWithContext(ctx aws.Context, input *GetEvidenceByEvidenceFolderInput, fn func(*GetEvidenceByEvidenceFolderOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEvidenceByEvidenceFolderInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEvidenceByEvidenceFolderRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEvidenceByEvidenceFolderOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEvidenceFolder = "GetEvidenceFolder"

// GetEvidenceFolderRequest generates a "aws/request.Request" representing the
// client's request for the GetEvidenceFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvidenceFolder for more information on using the GetEvidenceFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEvidenceFolderRequest method.
//    req, resp := client.GetEvidenceFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder
func (c *AuditManager) GetEvidenceFolderRequest(input *GetEvidenceFolderInput) (req *request.Request, output *GetEvidenceFolderOutput) {
	op := &request.Operation{
		Name:       opGetEvidenceFolder,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}",
	}

	if input == nil {
		input = &GetEvidenceFolderInput{}
	}

	output = &GetEvidenceFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvidenceFolder API operation for AWS Audit Manager.
//
// Returns an evidence folder from the specified assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetEvidenceFolder for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder
func (c *AuditManager) GetEvidenceFolder(input *GetEvidenceFolderInput) (*GetEvidenceFolderOutput, error) {
	req, out := c.GetEvidenceFolderRequest(input)
	return out, req.Send()
}

// GetEvidenceFolderWithContext is the same as GetEvidenceFolder with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvidenceFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceFolderWithContext(ctx aws.Context, input *GetEvidenceFolderInput, opts ...request.Option) (*GetEvidenceFolderOutput, error) {
	req, out := c.GetEvidenceFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEvidenceFoldersByAssessment = "GetEvidenceFoldersByAssessment"

// GetEvidenceFoldersByAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEvidenceFoldersByAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvidenceFoldersByAssessment for more information on using the GetEvidenceFoldersByAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEvidenceFoldersByAssessmentRequest method.
//    req, resp := client.GetEvidenceFoldersByAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment
func (c *AuditManager) GetEvidenceFoldersByAssessmentRequest(input *GetEvidenceFoldersByAssessmentInput) (req *request.Request, output *GetEvidenceFoldersByAssessmentOutput) {
	op := &request.Operation{
		Name:       opGetEvidenceFoldersByAssessment,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/evidenceFolders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEvidenceFoldersByAssessmentInput{}
	}

	output = &GetEvidenceFoldersByAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvidenceFoldersByAssessment API operation for AWS Audit Manager.
//
// Returns the evidence folders from a specified assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetEvidenceFoldersByAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment
func (c *AuditManager) GetEvidenceFoldersByAssessment(input *GetEvidenceFoldersByAssessmentInput) (*GetEvidenceFoldersByAssessmentOutput, error) {
	req, out := c.GetEvidenceFoldersByAssessmentRequest(input)
	return out, req.Send()
}

// GetEvidenceFoldersByAssessmentWithContext is the same as GetEvidenceFoldersByAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvidenceFoldersByAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceFoldersByAssessmentWithContext(ctx aws.Context, input *GetEvidenceFoldersByAssessmentInput, opts ...request.Option) (*GetEvidenceFoldersByAssessmentOutput, error) {
	req, out := c.GetEvidenceFoldersByAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEvidenceFoldersByAssessmentPages iterates over the pages of a GetEvidenceFoldersByAssessment operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEvidenceFoldersByAssessment method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEvidenceFoldersByAssessment operation.
//    pageNum := 0
//    err := client.GetEvidenceFoldersByAssessmentPages(params,
//        func(page *auditmanager.GetEvidenceFoldersByAssessmentOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) GetEvidenceFoldersByAssessmentPages(input *GetEvidenceFoldersByAssessmentInput, fn func(*GetEvidenceFoldersByAssessmentOutput, bool) bool) error {
	return c.GetEvidenceFoldersByAssessmentPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEvidenceFoldersByAssessmentPagesWithContext same as GetEvidenceFoldersByAssessmentPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceFoldersByAssessmentPagesWithContext(ctx aws.Context, input *GetEvidenceFoldersByAssessmentInput, fn func(*GetEvidenceFoldersByAssessmentOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEvidenceFoldersByAssessmentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEvidenceFoldersByAssessmentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEvidenceFoldersByAssessmentOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEvidenceFoldersByAssessmentControl = "GetEvidenceFoldersByAssessmentControl"

// GetEvidenceFoldersByAssessmentControlRequest generates a "aws/request.Request" representing the
// client's request for the GetEvidenceFoldersByAssessmentControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvidenceFoldersByAssessmentControl for more information on using the GetEvidenceFoldersByAssessmentControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEvidenceFoldersByAssessmentControlRequest method.
//    req, resp := client.GetEvidenceFoldersByAssessmentControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl
func (c *AuditManager) GetEvidenceFoldersByAssessmentControlRequest(input *GetEvidenceFoldersByAssessmentControlInput) (req *request.Request, output *GetEvidenceFoldersByAssessmentControlOutput) {
	op := &request.Operation{
		Name:       opGetEvidenceFoldersByAssessmentControl,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments/{assessmentId}/evidenceFolders-by-assessment-control/{controlSetId}/{controlId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEvidenceFoldersByAssessmentControlInput{}
	}

	output = &GetEvidenceFoldersByAssessmentControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvidenceFoldersByAssessmentControl API operation for AWS Audit Manager.
//
// Returns a list of evidence folders associated with a specified control of
// an assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetEvidenceFoldersByAssessmentControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl
func (c *AuditManager) GetEvidenceFoldersByAssessmentControl(input *GetEvidenceFoldersByAssessmentControlInput) (*GetEvidenceFoldersByAssessmentControlOutput, error) {
	req, out := c.GetEvidenceFoldersByAssessmentControlRequest(input)
	return out, req.Send()
}

// GetEvidenceFoldersByAssessmentControlWithContext is the same as GetEvidenceFoldersByAssessmentControl with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvidenceFoldersByAssessmentControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceFoldersByAssessmentControlWithContext(ctx aws.Context, input *GetEvidenceFoldersByAssessmentControlInput, opts ...request.Option) (*GetEvidenceFoldersByAssessmentControlOutput, error) {
	req, out := c.GetEvidenceFoldersByAssessmentControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEvidenceFoldersByAssessmentControlPages iterates over the pages of a GetEvidenceFoldersByAssessmentControl operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEvidenceFoldersByAssessmentControl method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEvidenceFoldersByAssessmentControl operation.
//    pageNum := 0
//    err := client.GetEvidenceFoldersByAssessmentControlPages(params,
//        func(page *auditmanager.GetEvidenceFoldersByAssessmentControlOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) GetEvidenceFoldersByAssessmentControlPages(input *GetEvidenceFoldersByAssessmentControlInput, fn func(*GetEvidenceFoldersByAssessmentControlOutput, bool) bool) error {
	return c.GetEvidenceFoldersByAssessmentControlPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEvidenceFoldersByAssessmentControlPagesWithContext same as GetEvidenceFoldersByAssessmentControlPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetEvidenceFoldersByAssessmentControlPagesWithContext(ctx aws.Context, input *GetEvidenceFoldersByAssessmentControlInput, fn func(*GetEvidenceFoldersByAssessmentControlOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEvidenceFoldersByAssessmentControlInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEvidenceFoldersByAssessmentControlRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEvidenceFoldersByAssessmentControlOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOrganizationAdminAccount = "GetOrganizationAdminAccount"

// GetOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationAdminAccount for more information on using the GetOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOrganizationAdminAccountRequest method.
//    req, resp := client.GetOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount
func (c *AuditManager) GetOrganizationAdminAccountRequest(input *GetOrganizationAdminAccountInput) (req *request.Request, output *GetOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationAdminAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/account/organizationAdminAccount",
	}

	if input == nil {
		input = &GetOrganizationAdminAccountInput{}
	}

	output = &GetOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationAdminAccount API operation for AWS Audit Manager.
//
// Returns the name of the delegated AWS administrator account for the AWS organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount
func (c *AuditManager) GetOrganizationAdminAccount(input *GetOrganizationAdminAccountInput) (*GetOrganizationAdminAccountOutput, error) {
	req, out := c.GetOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// GetOrganizationAdminAccountWithContext is the same as GetOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetOrganizationAdminAccountWithContext(ctx aws.Context, input *GetOrganizationAdminAccountInput, opts ...request.Option) (*GetOrganizationAdminAccountOutput, error) {
	req, out := c.GetOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServicesInScope = "GetServicesInScope"

// GetServicesInScopeRequest generates a "aws/request.Request" representing the
// client's request for the GetServicesInScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServicesInScope for more information on using the GetServicesInScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServicesInScopeRequest method.
//    req, resp := client.GetServicesInScopeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope
func (c *AuditManager) GetServicesInScopeRequest(input *GetServicesInScopeInput) (req *request.Request, output *GetServicesInScopeOutput) {
	op := &request.Operation{
		Name:       opGetServicesInScope,
		HTTPMethod: "GET",
		HTTPPath:   "/services",
	}

	if input == nil {
		input = &GetServicesInScopeInput{}
	}

	output = &GetServicesInScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServicesInScope API operation for AWS Audit Manager.
//
// Returns a list of the in-scope AWS services for the specified assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetServicesInScope for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope
func (c *AuditManager) GetServicesInScope(input *GetServicesInScopeInput) (*GetServicesInScopeOutput, error) {
	req, out := c.GetServicesInScopeRequest(input)
	return out, req.Send()
}

// GetServicesInScopeWithContext is the same as GetServicesInScope with the addition of
// the ability to pass a context and additional request options.
//
// See GetServicesInScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetServicesInScopeWithContext(ctx aws.Context, input *GetServicesInScopeInput, opts ...request.Option) (*GetServicesInScopeOutput, error) {
	req, out := c.GetServicesInScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSettings = "GetSettings"

// GetSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSettings for more information on using the GetSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSettingsRequest method.
//    req, resp := client.GetSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings
func (c *AuditManager) GetSettingsRequest(input *GetSettingsInput) (req *request.Request, output *GetSettingsOutput) {
	op := &request.Operation{
		Name:       opGetSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings/{attribute}",
	}

	if input == nil {
		input = &GetSettingsInput{}
	}

	output = &GetSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSettings API operation for AWS Audit Manager.
//
// Returns the settings for the specified AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation GetSettings for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings
func (c *AuditManager) GetSettings(input *GetSettingsInput) (*GetSettingsOutput, error) {
	req, out := c.GetSettingsRequest(input)
	return out, req.Send()
}

// GetSettingsWithContext is the same as GetSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) GetSettingsWithContext(ctx aws.Context, input *GetSettingsInput, opts ...request.Option) (*GetSettingsOutput, error) {
	req, out := c.GetSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssessmentFrameworks = "ListAssessmentFrameworks"

// ListAssessmentFrameworksRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessmentFrameworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessmentFrameworks for more information on using the ListAssessmentFrameworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentFrameworksRequest method.
//    req, resp := client.ListAssessmentFrameworksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks
func (c *AuditManager) ListAssessmentFrameworksRequest(input *ListAssessmentFrameworksInput) (req *request.Request, output *ListAssessmentFrameworksOutput) {
	op := &request.Operation{
		Name:       opListAssessmentFrameworks,
		HTTPMethod: "GET",
		HTTPPath:   "/assessmentFrameworks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentFrameworksInput{}
	}

	output = &ListAssessmentFrameworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessmentFrameworks API operation for AWS Audit Manager.
//
// Returns a list of the frameworks available in the AWS Audit Manager framework
// library.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListAssessmentFrameworks for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks
func (c *AuditManager) ListAssessmentFrameworks(input *ListAssessmentFrameworksInput) (*ListAssessmentFrameworksOutput, error) {
	req, out := c.ListAssessmentFrameworksRequest(input)
	return out, req.Send()
}

// ListAssessmentFrameworksWithContext is the same as ListAssessmentFrameworks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessmentFrameworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListAssessmentFrameworksWithContext(ctx aws.Context, input *ListAssessmentFrameworksInput, opts ...request.Option) (*ListAssessmentFrameworksOutput, error) {
	req, out := c.ListAssessmentFrameworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentFrameworksPages iterates over the pages of a ListAssessmentFrameworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessmentFrameworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessmentFrameworks operation.
//    pageNum := 0
//    err := client.ListAssessmentFrameworksPages(params,
//        func(page *auditmanager.ListAssessmentFrameworksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) ListAssessmentFrameworksPages(input *ListAssessmentFrameworksInput, fn func(*ListAssessmentFrameworksOutput, bool) bool) error {
	return c.ListAssessmentFrameworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentFrameworksPagesWithContext same as ListAssessmentFrameworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListAssessmentFrameworksPagesWithContext(ctx aws.Context, input *ListAssessmentFrameworksInput, fn func(*ListAssessmentFrameworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentFrameworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentFrameworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssessmentFrameworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssessmentReports = "ListAssessmentReports"

// ListAssessmentReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessmentReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessmentReports for more information on using the ListAssessmentReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentReportsRequest method.
//    req, resp := client.ListAssessmentReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports
func (c *AuditManager) ListAssessmentReportsRequest(input *ListAssessmentReportsInput) (req *request.Request, output *ListAssessmentReportsOutput) {
	op := &request.Operation{
		Name:       opListAssessmentReports,
		HTTPMethod: "GET",
		HTTPPath:   "/assessmentReports",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentReportsInput{}
	}

	output = &ListAssessmentReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessmentReports API operation for AWS Audit Manager.
//
// Returns a list of assessment reports created in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListAssessmentReports for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports
func (c *AuditManager) ListAssessmentReports(input *ListAssessmentReportsInput) (*ListAssessmentReportsOutput, error) {
	req, out := c.ListAssessmentReportsRequest(input)
	return out, req.Send()
}

// ListAssessmentReportsWithContext is the same as ListAssessmentReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessmentReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListAssessmentReportsWithContext(ctx aws.Context, input *ListAssessmentReportsInput, opts ...request.Option) (*ListAssessmentReportsOutput, error) {
	req, out := c.ListAssessmentReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentReportsPages iterates over the pages of a ListAssessmentReports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessmentReports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessmentReports operation.
//    pageNum := 0
//    err := client.ListAssessmentReportsPages(params,
//        func(page *auditmanager.ListAssessmentReportsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) ListAssessmentReportsPages(input *ListAssessmentReportsInput, fn func(*ListAssessmentReportsOutput, bool) bool) error {
	return c.ListAssessmentReportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentReportsPagesWithContext same as ListAssessmentReportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListAssessmentReportsPagesWithContext(ctx aws.Context, input *ListAssessmentReportsInput, fn func(*ListAssessmentReportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentReportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentReportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssessmentReportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssessments = "ListAssessments"

// ListAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssessments for more information on using the ListAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssessmentsRequest method.
//    req, resp := client.ListAssessmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments
func (c *AuditManager) ListAssessmentsRequest(input *ListAssessmentsInput) (req *request.Request, output *ListAssessmentsOutput) {
	op := &request.Operation{
		Name:       opListAssessments,
		HTTPMethod: "GET",
		HTTPPath:   "/assessments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentsInput{}
	}

	output = &ListAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssessments API operation for AWS Audit Manager.
//
// Returns a list of current and past assessments from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListAssessments for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments
func (c *AuditManager) ListAssessments(input *ListAssessmentsInput) (*ListAssessmentsOutput, error) {
	req, out := c.ListAssessmentsRequest(input)
	return out, req.Send()
}

// ListAssessmentsWithContext is the same as ListAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListAssessmentsWithContext(ctx aws.Context, input *ListAssessmentsInput, opts ...request.Option) (*ListAssessmentsOutput, error) {
	req, out := c.ListAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssessmentsPages iterates over the pages of a ListAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssessments operation.
//    pageNum := 0
//    err := client.ListAssessmentsPages(params,
//        func(page *auditmanager.ListAssessmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) ListAssessmentsPages(input *ListAssessmentsInput, fn func(*ListAssessmentsOutput, bool) bool) error {
	return c.ListAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssessmentsPagesWithContext same as ListAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListAssessmentsPagesWithContext(ctx aws.Context, input *ListAssessmentsInput, fn func(*ListAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListControls = "ListControls"

// ListControlsRequest generates a "aws/request.Request" representing the
// client's request for the ListControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListControls for more information on using the ListControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListControlsRequest method.
//    req, resp := client.ListControlsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls
func (c *AuditManager) ListControlsRequest(input *ListControlsInput) (req *request.Request, output *ListControlsOutput) {
	op := &request.Operation{
		Name:       opListControls,
		HTTPMethod: "GET",
		HTTPPath:   "/controls",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListControlsInput{}
	}

	output = &ListControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListControls API operation for AWS Audit Manager.
//
// Returns a list of controls from AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListControls for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls
func (c *AuditManager) ListControls(input *ListControlsInput) (*ListControlsOutput, error) {
	req, out := c.ListControlsRequest(input)
	return out, req.Send()
}

// ListControlsWithContext is the same as ListControls with the addition of
// the ability to pass a context and additional request options.
//
// See ListControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListControlsWithContext(ctx aws.Context, input *ListControlsInput, opts ...request.Option) (*ListControlsOutput, error) {
	req, out := c.ListControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListControlsPages iterates over the pages of a ListControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListControls operation.
//    pageNum := 0
//    err := client.ListControlsPages(params,
//        func(page *auditmanager.ListControlsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) ListControlsPages(input *ListControlsInput, fn func(*ListControlsOutput, bool) bool) error {
	return c.ListControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListControlsPagesWithContext same as ListControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListControlsPagesWithContext(ctx aws.Context, input *ListControlsInput, fn func(*ListControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeywordsForDataSource = "ListKeywordsForDataSource"

// ListKeywordsForDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the ListKeywordsForDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeywordsForDataSource for more information on using the ListKeywordsForDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListKeywordsForDataSourceRequest method.
//    req, resp := client.ListKeywordsForDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource
func (c *AuditManager) ListKeywordsForDataSourceRequest(input *ListKeywordsForDataSourceInput) (req *request.Request, output *ListKeywordsForDataSourceOutput) {
	op := &request.Operation{
		Name:       opListKeywordsForDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/dataSourceKeywords",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeywordsForDataSourceInput{}
	}

	output = &ListKeywordsForDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeywordsForDataSource API operation for AWS Audit Manager.
//
// Returns a list of keywords that pre-mapped to the specified control data
// source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListKeywordsForDataSource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource
func (c *AuditManager) ListKeywordsForDataSource(input *ListKeywordsForDataSourceInput) (*ListKeywordsForDataSourceOutput, error) {
	req, out := c.ListKeywordsForDataSourceRequest(input)
	return out, req.Send()
}

// ListKeywordsForDataSourceWithContext is the same as ListKeywordsForDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeywordsForDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListKeywordsForDataSourceWithContext(ctx aws.Context, input *ListKeywordsForDataSourceInput, opts ...request.Option) (*ListKeywordsForDataSourceOutput, error) {
	req, out := c.ListKeywordsForDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeywordsForDataSourcePages iterates over the pages of a ListKeywordsForDataSource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeywordsForDataSource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKeywordsForDataSource operation.
//    pageNum := 0
//    err := client.ListKeywordsForDataSourcePages(params,
//        func(page *auditmanager.ListKeywordsForDataSourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) ListKeywordsForDataSourcePages(input *ListKeywordsForDataSourceInput, fn func(*ListKeywordsForDataSourceOutput, bool) bool) error {
	return c.ListKeywordsForDataSourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeywordsForDataSourcePagesWithContext same as ListKeywordsForDataSourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListKeywordsForDataSourcePagesWithContext(ctx aws.Context, input *ListKeywordsForDataSourceInput, fn func(*ListKeywordsForDataSourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeywordsForDataSourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeywordsForDataSourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeywordsForDataSourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotifications = "ListNotifications"

// ListNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotifications for more information on using the ListNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotificationsRequest method.
//    req, resp := client.ListNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications
func (c *AuditManager) ListNotificationsRequest(input *ListNotificationsInput) (req *request.Request, output *ListNotificationsOutput) {
	op := &request.Operation{
		Name:       opListNotifications,
		HTTPMethod: "GET",
		HTTPPath:   "/notifications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationsInput{}
	}

	output = &ListNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotifications API operation for AWS Audit Manager.
//
// Returns a list of all AWS Audit Manager notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListNotifications for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications
func (c *AuditManager) ListNotifications(input *ListNotificationsInput) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	return out, req.Send()
}

// ListNotificationsWithContext is the same as ListNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListNotificationsWithContext(ctx aws.Context, input *ListNotificationsInput, opts ...request.Option) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationsPages iterates over the pages of a ListNotifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotifications operation.
//    pageNum := 0
//    err := client.ListNotificationsPages(params,
//        func(page *auditmanager.ListNotificationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AuditManager) ListNotificationsPages(input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool) error {
	return c.ListNotificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationsPagesWithContext same as ListNotificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListNotificationsPagesWithContext(ctx aws.Context, input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource
func (c *AuditManager) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Audit Manager.
//
// Returns a list of tags for the specified resource in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource
func (c *AuditManager) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterAccount = "RegisterAccount"

// RegisterAccountRequest generates a "aws/request.Request" representing the
// client's request for the RegisterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterAccount for more information on using the RegisterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterAccountRequest method.
//    req, resp := client.RegisterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount
func (c *AuditManager) RegisterAccountRequest(input *RegisterAccountInput) (req *request.Request, output *RegisterAccountOutput) {
	op := &request.Operation{
		Name:       opRegisterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/account/registerAccount",
	}

	if input == nil {
		input = &RegisterAccountInput{}
	}

	output = &RegisterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterAccount API operation for AWS Audit Manager.
//
// Enables AWS Audit Manager for the specified AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation RegisterAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount
func (c *AuditManager) RegisterAccount(input *RegisterAccountInput) (*RegisterAccountOutput, error) {
	req, out := c.RegisterAccountRequest(input)
	return out, req.Send()
}

// RegisterAccountWithContext is the same as RegisterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) RegisterAccountWithContext(ctx aws.Context, input *RegisterAccountInput, opts ...request.Option) (*RegisterAccountOutput, error) {
	req, out := c.RegisterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterOrganizationAdminAccount = "RegisterOrganizationAdminAccount"

// RegisterOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the RegisterOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterOrganizationAdminAccount for more information on using the RegisterOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterOrganizationAdminAccountRequest method.
//    req, resp := client.RegisterOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount
func (c *AuditManager) RegisterOrganizationAdminAccountRequest(input *RegisterOrganizationAdminAccountInput) (req *request.Request, output *RegisterOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opRegisterOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/account/registerOrganizationAdminAccount",
	}

	if input == nil {
		input = &RegisterOrganizationAdminAccountInput{}
	}

	output = &RegisterOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterOrganizationAdminAccount API operation for AWS Audit Manager.
//
// Enables an AWS account within the organization as the delegated administrator
// for AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation RegisterOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount
func (c *AuditManager) RegisterOrganizationAdminAccount(input *RegisterOrganizationAdminAccountInput) (*RegisterOrganizationAdminAccountOutput, error) {
	req, out := c.RegisterOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// RegisterOrganizationAdminAccountWithContext is the same as RegisterOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) RegisterOrganizationAdminAccountWithContext(ctx aws.Context, input *RegisterOrganizationAdminAccountInput, opts ...request.Option) (*RegisterOrganizationAdminAccountOutput, error) {
	req, out := c.RegisterOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource
func (c *AuditManager) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Audit Manager.
//
// Tags the specified resource in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource
func (c *AuditManager) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource
func (c *AuditManager) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Audit Manager.
//
// Removes a tag from a resource in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource
func (c *AuditManager) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssessment = "UpdateAssessment"

// UpdateAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssessment for more information on using the UpdateAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssessmentRequest method.
//    req, resp := client.UpdateAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment
func (c *AuditManager) UpdateAssessmentRequest(input *UpdateAssessmentInput) (req *request.Request, output *UpdateAssessmentOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessment,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}",
	}

	if input == nil {
		input = &UpdateAssessmentInput{}
	}

	output = &UpdateAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssessment API operation for AWS Audit Manager.
//
// Edits an AWS Audit Manager assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateAssessment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment
func (c *AuditManager) UpdateAssessment(input *UpdateAssessmentInput) (*UpdateAssessmentOutput, error) {
	req, out := c.UpdateAssessmentRequest(input)
	return out, req.Send()
}

// UpdateAssessmentWithContext is the same as UpdateAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateAssessmentWithContext(ctx aws.Context, input *UpdateAssessmentInput, opts ...request.Option) (*UpdateAssessmentOutput, error) {
	req, out := c.UpdateAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssessmentControl = "UpdateAssessmentControl"

// UpdateAssessmentControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssessmentControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssessmentControl for more information on using the UpdateAssessmentControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssessmentControlRequest method.
//    req, resp := client.UpdateAssessmentControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl
func (c *AuditManager) UpdateAssessmentControlRequest(input *UpdateAssessmentControlInput) (req *request.Request, output *UpdateAssessmentControlOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessmentControl,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}",
	}

	if input == nil {
		input = &UpdateAssessmentControlInput{}
	}

	output = &UpdateAssessmentControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssessmentControl API operation for AWS Audit Manager.
//
// Updates a control within an assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateAssessmentControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl
func (c *AuditManager) UpdateAssessmentControl(input *UpdateAssessmentControlInput) (*UpdateAssessmentControlOutput, error) {
	req, out := c.UpdateAssessmentControlRequest(input)
	return out, req.Send()
}

// UpdateAssessmentControlWithContext is the same as UpdateAssessmentControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssessmentControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateAssessmentControlWithContext(ctx aws.Context, input *UpdateAssessmentControlInput, opts ...request.Option) (*UpdateAssessmentControlOutput, error) {
	req, out := c.UpdateAssessmentControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssessmentControlSetStatus = "UpdateAssessmentControlSetStatus"

// UpdateAssessmentControlSetStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssessmentControlSetStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssessmentControlSetStatus for more information on using the UpdateAssessmentControlSetStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssessmentControlSetStatusRequest method.
//    req, resp := client.UpdateAssessmentControlSetStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus
func (c *AuditManager) UpdateAssessmentControlSetStatusRequest(input *UpdateAssessmentControlSetStatusInput) (req *request.Request, output *UpdateAssessmentControlSetStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessmentControlSetStatus,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/controlSets/{controlSetId}/status",
	}

	if input == nil {
		input = &UpdateAssessmentControlSetStatusInput{}
	}

	output = &UpdateAssessmentControlSetStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssessmentControlSetStatus API operation for AWS Audit Manager.
//
// Updates the status of a control set in an AWS Audit Manager assessment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateAssessmentControlSetStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus
func (c *AuditManager) UpdateAssessmentControlSetStatus(input *UpdateAssessmentControlSetStatusInput) (*UpdateAssessmentControlSetStatusOutput, error) {
	req, out := c.UpdateAssessmentControlSetStatusRequest(input)
	return out, req.Send()
}

// UpdateAssessmentControlSetStatusWithContext is the same as UpdateAssessmentControlSetStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssessmentControlSetStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateAssessmentControlSetStatusWithContext(ctx aws.Context, input *UpdateAssessmentControlSetStatusInput, opts ...request.Option) (*UpdateAssessmentControlSetStatusOutput, error) {
	req, out := c.UpdateAssessmentControlSetStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssessmentFramework = "UpdateAssessmentFramework"

// UpdateAssessmentFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssessmentFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssessmentFramework for more information on using the UpdateAssessmentFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssessmentFrameworkRequest method.
//    req, resp := client.UpdateAssessmentFrameworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework
func (c *AuditManager) UpdateAssessmentFrameworkRequest(input *UpdateAssessmentFrameworkInput) (req *request.Request, output *UpdateAssessmentFrameworkOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessmentFramework,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessmentFrameworks/{frameworkId}",
	}

	if input == nil {
		input = &UpdateAssessmentFrameworkInput{}
	}

	output = &UpdateAssessmentFrameworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssessmentFramework API operation for AWS Audit Manager.
//
// Updates a custom framework in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateAssessmentFramework for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework
func (c *AuditManager) UpdateAssessmentFramework(input *UpdateAssessmentFrameworkInput) (*UpdateAssessmentFrameworkOutput, error) {
	req, out := c.UpdateAssessmentFrameworkRequest(input)
	return out, req.Send()
}

// UpdateAssessmentFrameworkWithContext is the same as UpdateAssessmentFramework with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssessmentFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateAssessmentFrameworkWithContext(ctx aws.Context, input *UpdateAssessmentFrameworkInput, opts ...request.Option) (*UpdateAssessmentFrameworkOutput, error) {
	req, out := c.UpdateAssessmentFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssessmentStatus = "UpdateAssessmentStatus"

// UpdateAssessmentStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssessmentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssessmentStatus for more information on using the UpdateAssessmentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssessmentStatusRequest method.
//    req, resp := client.UpdateAssessmentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus
func (c *AuditManager) UpdateAssessmentStatusRequest(input *UpdateAssessmentStatusInput) (req *request.Request, output *UpdateAssessmentStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessmentStatus,
		HTTPMethod: "PUT",
		HTTPPath:   "/assessments/{assessmentId}/status",
	}

	if input == nil {
		input = &UpdateAssessmentStatusInput{}
	}

	output = &UpdateAssessmentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssessmentStatus API operation for AWS Audit Manager.
//
// Updates the status of an assessment in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateAssessmentStatus for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus
func (c *AuditManager) UpdateAssessmentStatus(input *UpdateAssessmentStatusInput) (*UpdateAssessmentStatusOutput, error) {
	req, out := c.UpdateAssessmentStatusRequest(input)
	return out, req.Send()
}

// UpdateAssessmentStatusWithContext is the same as UpdateAssessmentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssessmentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateAssessmentStatusWithContext(ctx aws.Context, input *UpdateAssessmentStatusInput, opts ...request.Option) (*UpdateAssessmentStatusOutput, error) {
	req, out := c.UpdateAssessmentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateControl = "UpdateControl"

// UpdateControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateControl for more information on using the UpdateControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateControlRequest method.
//    req, resp := client.UpdateControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl
func (c *AuditManager) UpdateControlRequest(input *UpdateControlInput) (req *request.Request, output *UpdateControlOutput) {
	op := &request.Operation{
		Name:       opUpdateControl,
		HTTPMethod: "PUT",
		HTTPPath:   "/controls/{controlId}",
	}

	if input == nil {
		input = &UpdateControlInput{}
	}

	output = &UpdateControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateControl API operation for AWS Audit Manager.
//
// Updates a custom control in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateControl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl
func (c *AuditManager) UpdateControl(input *UpdateControlInput) (*UpdateControlOutput, error) {
	req, out := c.UpdateControlRequest(input)
	return out, req.Send()
}

// UpdateControlWithContext is the same as UpdateControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateControlWithContext(ctx aws.Context, input *UpdateControlInput, opts ...request.Option) (*UpdateControlOutput, error) {
	req, out := c.UpdateControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSettings = "UpdateSettings"

// UpdateSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSettings for more information on using the UpdateSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSettingsRequest method.
//    req, resp := client.UpdateSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings
func (c *AuditManager) UpdateSettingsRequest(input *UpdateSettingsInput) (req *request.Request, output *UpdateSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &UpdateSettingsInput{}
	}

	output = &UpdateSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSettings API operation for AWS Audit Manager.
//
// Updates AWS Audit Manager settings for the current user account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation UpdateSettings for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings
func (c *AuditManager) UpdateSettings(input *UpdateSettingsInput) (*UpdateSettingsOutput, error) {
	req, out := c.UpdateSettingsRequest(input)
	return out, req.Send()
}

// UpdateSettingsWithContext is the same as UpdateSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) UpdateSettingsWithContext(ctx aws.Context, input *UpdateSettingsInput, opts ...request.Option) (*UpdateSettingsOutput, error) {
	req, out := c.UpdateSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateAssessmentReportIntegrity = "ValidateAssessmentReportIntegrity"

// ValidateAssessmentReportIntegrityRequest generates a "aws/request.Request" representing the
// client's request for the ValidateAssessmentReportIntegrity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateAssessmentReportIntegrity for more information on using the ValidateAssessmentReportIntegrity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateAssessmentReportIntegrityRequest method.
//    req, resp := client.ValidateAssessmentReportIntegrityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity
func (c *AuditManager) ValidateAssessmentReportIntegrityRequest(input *ValidateAssessmentReportIntegrityInput) (req *request.Request, output *ValidateAssessmentReportIntegrityOutput) {
	op := &request.Operation{
		Name:       opValidateAssessmentReportIntegrity,
		HTTPMethod: "POST",
		HTTPPath:   "/assessmentReports/integrity",
	}

	if input == nil {
		input = &ValidateAssessmentReportIntegrityInput{}
	}

	output = &ValidateAssessmentReportIntegrityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateAssessmentReportIntegrity API operation for AWS Audit Manager.
//
// Validates the integrity of an assessment report in AWS Audit Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Audit Manager's
// API operation ValidateAssessmentReportIntegrity for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * AccessDeniedException
//   Your account is not registered with AWS Audit Manager. Check the delegated
//   administrator setup on the AWS Audit Manager settings page, and try again.
//
//   * InternalServerException
//   An internal service error occurred during the processing of your request.
//   Try again later.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity
func (c *AuditManager) ValidateAssessmentReportIntegrity(input *ValidateAssessmentReportIntegrityInput) (*ValidateAssessmentReportIntegrityOutput, error) {
	req, out := c.ValidateAssessmentReportIntegrityRequest(input)
	return out, req.Send()
}

// ValidateAssessmentReportIntegrityWithContext is the same as ValidateAssessmentReportIntegrity with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateAssessmentReportIntegrity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AuditManager) ValidateAssessmentReportIntegrityWithContext(ctx aws.Context, input *ValidateAssessmentReportIntegrityInput, opts ...request.Option) (*ValidateAssessmentReportIntegrityOutput, error) {
	req, out := c.ValidateAssessmentReportIntegrityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The wrapper of AWS account details, such as account ID, email address, and
// so on.
type AWSAccount struct {
	_ struct{} `type:"structure"`

	// The email address associated with the specified AWS account.
	EmailAddress *string `locationName:"emailAddress" min:"1" type:"string"`

	// The identifier for the specified AWS account.
	Id *string `locationName:"id" min:"12" type:"string"`

	// The name of the specified AWS account.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s AWSAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AWSAccount) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AWSAccount) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AWSAccount"}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}
	if s.Id != nil && len(*s.Id) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 12))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *AWSAccount) SetEmailAddress(v string) *AWSAccount {
	s.EmailAddress = &v
	return s
}

// SetId sets the Id field's value.
func (s *AWSAccount) SetId(v string) *AWSAccount {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AWSAccount) SetName(v string) *AWSAccount {
	s.Name = &v
	return s
}

// An AWS service such as Amazon S3, AWS CloudTrail, and so on.
type AWSService struct {
	_ struct{} `type:"structure"`

	// The name of the AWS service.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`
}

// String returns the string representation
func (s AWSService) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AWSService) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AWSService) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AWSService"}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *AWSService) SetServiceName(v string) *AWSService {
	s.ServiceName = &v
	return s
}

// Your account is not registered with AWS Audit Manager. Check the delegated
// administrator setup on the AWS Audit Manager settings page, and try again.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An entity that defines the scope of audit evidence collected by AWS Audit
// Manager. An AWS Audit Manager assessment is an implementation of an AWS Audit
// Manager framework.
type Assessment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the assessment.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The AWS account associated with the assessment.
	AwsAccount *AWSAccount `locationName:"awsAccount" type:"structure"`

	// The framework from which the assessment was created.
	Framework *AssessmentFramework `locationName:"framework" type:"structure"`

	// The metadata for the specified assessment.
	Metadata *AssessmentMetadata `locationName:"metadata" type:"structure"`

	// The tags associated with the assessment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Assessment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Assessment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Assessment) SetArn(v string) *Assessment {
	s.Arn = &v
	return s
}

// SetAwsAccount sets the AwsAccount field's value.
func (s *Assessment) SetAwsAccount(v *AWSAccount) *Assessment {
	s.AwsAccount = v
	return s
}

// SetFramework sets the Framework field's value.
func (s *Assessment) SetFramework(v *AssessmentFramework) *Assessment {
	s.Framework = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Assessment) SetMetadata(v *AssessmentMetadata) *Assessment {
	s.Metadata = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Assessment) SetTags(v map[string]*string) *Assessment {
	s.Tags = v
	return s
}

// The control entity that represents a standard or custom control used in an
// AWS Audit Manager assessment.
type AssessmentControl struct {
	_ struct{} `type:"structure"`

	// The amount of evidence in the assessment report.
	AssessmentReportEvidenceCount *int64 `locationName:"assessmentReportEvidenceCount" type:"integer"`

	// The list of comments attached to the specified control.
	Comments []*ControlComment `locationName:"comments" type:"list"`

	// The description of the specified control.
	Description *string `locationName:"description" type:"string"`

	// The amount of evidence generated for the control.
	EvidenceCount *int64 `locationName:"evidenceCount" type:"integer"`

	// The list of data sources for the specified evidence.
	EvidenceSources []*string `locationName:"evidenceSources" type:"list"`

	// The identifier for the specified control.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the specified control.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The response of the specified control.
	Response *string `locationName:"response" type:"string" enum:"ControlResponse"`

	// The status of the specified control.
	Status *string `locationName:"status" type:"string" enum:"ControlStatus"`
}

// String returns the string representation
func (s AssessmentControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentControl) GoString() string {
	return s.String()
}

// SetAssessmentReportEvidenceCount sets the AssessmentReportEvidenceCount field's value.
func (s *AssessmentControl) SetAssessmentReportEvidenceCount(v int64) *AssessmentControl {
	s.AssessmentReportEvidenceCount = &v
	return s
}

// SetComments sets the Comments field's value.
func (s *AssessmentControl) SetComments(v []*ControlComment) *AssessmentControl {
	s.Comments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssessmentControl) SetDescription(v string) *AssessmentControl {
	s.Description = &v
	return s
}

// SetEvidenceCount sets the EvidenceCount field's value.
func (s *AssessmentControl) SetEvidenceCount(v int64) *AssessmentControl {
	s.EvidenceCount = &v
	return s
}

// SetEvidenceSources sets the EvidenceSources field's value.
func (s *AssessmentControl) SetEvidenceSources(v []*string) *AssessmentControl {
	s.EvidenceSources = v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentControl) SetId(v string) *AssessmentControl {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentControl) SetName(v string) *AssessmentControl {
	s.Name = &v
	return s
}

// SetResponse sets the Response field's value.
func (s *AssessmentControl) SetResponse(v string) *AssessmentControl {
	s.Response = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssessmentControl) SetStatus(v string) *AssessmentControl {
	s.Status = &v
	return s
}

// Represents a set of controls in an AWS Audit Manager assessment.
type AssessmentControlSet struct {
	_ struct{} `type:"structure"`

	// The list of controls contained with the control set.
	Controls []*AssessmentControl `locationName:"controls" type:"list"`

	// The delegations associated with the control set.
	Delegations []*Delegation `locationName:"delegations" type:"list"`

	// The description for the control set.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The identifier of the control set in the assessment. This is the control
	// set name in a plain string format.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The total number of evidence objects uploaded manually to the control set.
	ManualEvidenceCount *int64 `locationName:"manualEvidenceCount" type:"integer"`

	// The roles associated with the control set.
	Roles []*Role `locationName:"roles" type:"list"`

	// Specifies the current status of the control set.
	Status *string `locationName:"status" type:"string" enum:"ControlSetStatus"`

	// The total number of evidence objects retrieved automatically for the control
	// set.
	SystemEvidenceCount *int64 `locationName:"systemEvidenceCount" type:"integer"`
}

// String returns the string representation
func (s AssessmentControlSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentControlSet) GoString() string {
	return s.String()
}

// SetControls sets the Controls field's value.
func (s *AssessmentControlSet) SetControls(v []*AssessmentControl) *AssessmentControlSet {
	s.Controls = v
	return s
}

// SetDelegations sets the Delegations field's value.
func (s *AssessmentControlSet) SetDelegations(v []*Delegation) *AssessmentControlSet {
	s.Delegations = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssessmentControlSet) SetDescription(v string) *AssessmentControlSet {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentControlSet) SetId(v string) *AssessmentControlSet {
	s.Id = &v
	return s
}

// SetManualEvidenceCount sets the ManualEvidenceCount field's value.
func (s *AssessmentControlSet) SetManualEvidenceCount(v int64) *AssessmentControlSet {
	s.ManualEvidenceCount = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *AssessmentControlSet) SetRoles(v []*Role) *AssessmentControlSet {
	s.Roles = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssessmentControlSet) SetStatus(v string) *AssessmentControlSet {
	s.Status = &v
	return s
}

// SetSystemEvidenceCount sets the SystemEvidenceCount field's value.
func (s *AssessmentControlSet) SetSystemEvidenceCount(v int64) *AssessmentControlSet {
	s.SystemEvidenceCount = &v
	return s
}

// The folder in which AWS Audit Manager stores evidence for an assessment.
type AssessmentEvidenceFolder struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	AssessmentId *string `locationName:"assessmentId" min:"36" type:"string"`

	// The total count of evidence included in the assessment report.
	AssessmentReportSelectionCount *int64 `locationName:"assessmentReportSelectionCount" type:"integer"`

	// The name of the user who created the evidence folder.
	Author *string `locationName:"author" type:"string"`

	// The unique identifier for the specified control.
	ControlId *string `locationName:"controlId" min:"36" type:"string"`

	// The name of the control.
	ControlName *string `locationName:"controlName" min:"1" type:"string"`

	// The identifier for the control set.
	ControlSetId *string `locationName:"controlSetId" min:"1" type:"string"`

	// The AWS service from which the evidence was collected.
	DataSource *string `locationName:"dataSource" type:"string"`

	// The date when the first evidence was added to the evidence folder.
	Date *time.Time `locationName:"date" type:"timestamp"`

	// The total number of AWS resources assessed to generate the evidence.
	EvidenceAwsServiceSourceCount *int64 `locationName:"evidenceAwsServiceSourceCount" type:"integer"`

	// The number of evidence that falls under the compliance check category. This
	// evidence is collected from AWS Config or AWS Security Hub.
	EvidenceByTypeComplianceCheckCount *int64 `locationName:"evidenceByTypeComplianceCheckCount" type:"integer"`

	// The total number of issues that were reported directly from AWS Security
	// Hub, AWS Config, or both.
	EvidenceByTypeComplianceCheckIssuesCount *int64 `locationName:"evidenceByTypeComplianceCheckIssuesCount" type:"integer"`

	// The number of evidence that falls under the configuration data category.
	// This evidence is collected from configuration snapshots of other AWS services
	// such as Amazon EC2, Amazon S3, or IAM.
	EvidenceByTypeConfigurationDataCount *int64 `locationName:"evidenceByTypeConfigurationDataCount" type:"integer"`

	// The number of evidence that falls under the manual category. This evidence
	// is imported manually.
	EvidenceByTypeManualCount *int64 `locationName:"evidenceByTypeManualCount" type:"integer"`

	// The number of evidence that falls under the user activity category. This
	// evidence is collected from AWS CloudTrail logs.
	EvidenceByTypeUserActivityCount *int64 `locationName:"evidenceByTypeUserActivityCount" type:"integer"`

	// The amount of evidence included in the evidence folder.
	EvidenceResourcesIncludedCount *int64 `locationName:"evidenceResourcesIncludedCount" type:"integer"`

	// The identifier for the folder in which evidence is stored.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the specified evidence folder.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The total amount of evidence in the evidence folder.
	TotalEvidence *int64 `locationName:"totalEvidence" type:"integer"`
}

// String returns the string representation
func (s AssessmentEvidenceFolder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentEvidenceFolder) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *AssessmentEvidenceFolder) SetAssessmentId(v string) *AssessmentEvidenceFolder {
	s.AssessmentId = &v
	return s
}

// SetAssessmentReportSelectionCount sets the AssessmentReportSelectionCount field's value.
func (s *AssessmentEvidenceFolder) SetAssessmentReportSelectionCount(v int64) *AssessmentEvidenceFolder {
	s.AssessmentReportSelectionCount = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *AssessmentEvidenceFolder) SetAuthor(v string) *AssessmentEvidenceFolder {
	s.Author = &v
	return s
}

// SetControlId sets the ControlId field's value.
func (s *AssessmentEvidenceFolder) SetControlId(v string) *AssessmentEvidenceFolder {
	s.ControlId = &v
	return s
}

// SetControlName sets the ControlName field's value.
func (s *AssessmentEvidenceFolder) SetControlName(v string) *AssessmentEvidenceFolder {
	s.ControlName = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *AssessmentEvidenceFolder) SetControlSetId(v string) *AssessmentEvidenceFolder {
	s.ControlSetId = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *AssessmentEvidenceFolder) SetDataSource(v string) *AssessmentEvidenceFolder {
	s.DataSource = &v
	return s
}

// SetDate sets the Date field's value.
func (s *AssessmentEvidenceFolder) SetDate(v time.Time) *AssessmentEvidenceFolder {
	s.Date = &v
	return s
}

// SetEvidenceAwsServiceSourceCount sets the EvidenceAwsServiceSourceCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceAwsServiceSourceCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceAwsServiceSourceCount = &v
	return s
}

// SetEvidenceByTypeComplianceCheckCount sets the EvidenceByTypeComplianceCheckCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceByTypeComplianceCheckCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceByTypeComplianceCheckCount = &v
	return s
}

// SetEvidenceByTypeComplianceCheckIssuesCount sets the EvidenceByTypeComplianceCheckIssuesCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceByTypeComplianceCheckIssuesCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceByTypeComplianceCheckIssuesCount = &v
	return s
}

// SetEvidenceByTypeConfigurationDataCount sets the EvidenceByTypeConfigurationDataCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceByTypeConfigurationDataCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceByTypeConfigurationDataCount = &v
	return s
}

// SetEvidenceByTypeManualCount sets the EvidenceByTypeManualCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceByTypeManualCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceByTypeManualCount = &v
	return s
}

// SetEvidenceByTypeUserActivityCount sets the EvidenceByTypeUserActivityCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceByTypeUserActivityCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceByTypeUserActivityCount = &v
	return s
}

// SetEvidenceResourcesIncludedCount sets the EvidenceResourcesIncludedCount field's value.
func (s *AssessmentEvidenceFolder) SetEvidenceResourcesIncludedCount(v int64) *AssessmentEvidenceFolder {
	s.EvidenceResourcesIncludedCount = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentEvidenceFolder) SetId(v string) *AssessmentEvidenceFolder {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentEvidenceFolder) SetName(v string) *AssessmentEvidenceFolder {
	s.Name = &v
	return s
}

// SetTotalEvidence sets the TotalEvidence field's value.
func (s *AssessmentEvidenceFolder) SetTotalEvidence(v int64) *AssessmentEvidenceFolder {
	s.TotalEvidence = &v
	return s
}

// The file used to structure and automate AWS Audit Manager assessments for
// a given compliance standard.
type AssessmentFramework struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified framework.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The control sets associated with the framework.
	ControlSets []*AssessmentControlSet `locationName:"controlSets" type:"list"`

	// The unique identifier for the framework.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The metadata of a framework, such as the name, ID, description, and so on.
	Metadata *FrameworkMetadata `locationName:"metadata" type:"structure"`
}

// String returns the string representation
func (s AssessmentFramework) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentFramework) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssessmentFramework) SetArn(v string) *AssessmentFramework {
	s.Arn = &v
	return s
}

// SetControlSets sets the ControlSets field's value.
func (s *AssessmentFramework) SetControlSets(v []*AssessmentControlSet) *AssessmentFramework {
	s.ControlSets = v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentFramework) SetId(v string) *AssessmentFramework {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AssessmentFramework) SetMetadata(v *FrameworkMetadata) *AssessmentFramework {
	s.Metadata = v
	return s
}

// The metadata associated with a standard or custom framework.
type AssessmentFrameworkMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the framework.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The compliance type that the new custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// The number of control sets associated with the specified framework.
	ControlSetsCount *int64 `locationName:"controlSetsCount" type:"integer"`

	// The number of controls associated with the specified framework.
	ControlsCount *int64 `locationName:"controlsCount" type:"integer"`

	// Specifies when the framework was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description of the specified framework.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identified for the specified framework.
	Id *string `locationName:"id" min:"36" type:"string"`

	// Specifies when the framework was most recently updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The logo associated with the framework.
	Logo *string `locationName:"logo" min:"1" type:"string"`

	// The name of the specified framework.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The framework type, such as standard or custom.
	Type *string `locationName:"type" type:"string" enum:"FrameworkType"`
}

// String returns the string representation
func (s AssessmentFrameworkMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentFrameworkMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssessmentFrameworkMetadata) SetArn(v string) *AssessmentFrameworkMetadata {
	s.Arn = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AssessmentFrameworkMetadata) SetComplianceType(v string) *AssessmentFrameworkMetadata {
	s.ComplianceType = &v
	return s
}

// SetControlSetsCount sets the ControlSetsCount field's value.
func (s *AssessmentFrameworkMetadata) SetControlSetsCount(v int64) *AssessmentFrameworkMetadata {
	s.ControlSetsCount = &v
	return s
}

// SetControlsCount sets the ControlsCount field's value.
func (s *AssessmentFrameworkMetadata) SetControlsCount(v int64) *AssessmentFrameworkMetadata {
	s.ControlsCount = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssessmentFrameworkMetadata) SetCreatedAt(v time.Time) *AssessmentFrameworkMetadata {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssessmentFrameworkMetadata) SetDescription(v string) *AssessmentFrameworkMetadata {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentFrameworkMetadata) SetId(v string) *AssessmentFrameworkMetadata {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *AssessmentFrameworkMetadata) SetLastUpdatedAt(v time.Time) *AssessmentFrameworkMetadata {
	s.LastUpdatedAt = &v
	return s
}

// SetLogo sets the Logo field's value.
func (s *AssessmentFrameworkMetadata) SetLogo(v string) *AssessmentFrameworkMetadata {
	s.Logo = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentFrameworkMetadata) SetName(v string) *AssessmentFrameworkMetadata {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssessmentFrameworkMetadata) SetType(v string) *AssessmentFrameworkMetadata {
	s.Type = &v
	return s
}

// The metadata associated with the specified assessment.
type AssessmentMetadata struct {
	_ struct{} `type:"structure"`

	// The destination in which evidence reports are stored for the specified assessment.
	AssessmentReportsDestination *AssessmentReportsDestination `locationName:"assessmentReportsDestination" type:"structure"`

	// The name of a compliance standard related to the assessment, such as PCI-DSS.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// Specifies when the assessment was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The delegations associated with the assessment.
	Delegations []*Delegation `locationName:"delegations" type:"list"`

	// The description of the assessment.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier for the assessment.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The time of the most recent update.
	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp"`

	// The name of the assessment.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The roles associated with the assessment.
	Roles []*Role `locationName:"roles" type:"list"`

	// The wrapper of AWS accounts and services in scope for the assessment.
	Scope *Scope `locationName:"scope" type:"structure"`

	// The overall status of the assessment.
	Status *string `locationName:"status" type:"string" enum:"AssessmentStatus"`
}

// String returns the string representation
func (s AssessmentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentMetadata) GoString() string {
	return s.String()
}

// SetAssessmentReportsDestination sets the AssessmentReportsDestination field's value.
func (s *AssessmentMetadata) SetAssessmentReportsDestination(v *AssessmentReportsDestination) *AssessmentMetadata {
	s.AssessmentReportsDestination = v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AssessmentMetadata) SetComplianceType(v string) *AssessmentMetadata {
	s.ComplianceType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AssessmentMetadata) SetCreationTime(v time.Time) *AssessmentMetadata {
	s.CreationTime = &v
	return s
}

// SetDelegations sets the Delegations field's value.
func (s *AssessmentMetadata) SetDelegations(v []*Delegation) *AssessmentMetadata {
	s.Delegations = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssessmentMetadata) SetDescription(v string) *AssessmentMetadata {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentMetadata) SetId(v string) *AssessmentMetadata {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *AssessmentMetadata) SetLastUpdated(v time.Time) *AssessmentMetadata {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentMetadata) SetName(v string) *AssessmentMetadata {
	s.Name = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *AssessmentMetadata) SetRoles(v []*Role) *AssessmentMetadata {
	s.Roles = v
	return s
}

// SetScope sets the Scope field's value.
func (s *AssessmentMetadata) SetScope(v *Scope) *AssessmentMetadata {
	s.Scope = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssessmentMetadata) SetStatus(v string) *AssessmentMetadata {
	s.Status = &v
	return s
}

// A metadata object associated with an assessment in AWS Audit Manager.
type AssessmentMetadataItem struct {
	_ struct{} `type:"structure"`

	// The name of the compliance standard related to the assessment, such as PCI-DSS.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// Specifies when the assessment was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The delegations associated with the assessment.
	Delegations []*Delegation `locationName:"delegations" type:"list"`

	// The unique identifier for the assessment.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The time of the most recent update.
	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp"`

	// The name of the assessment.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The roles associated with the assessment.
	Roles []*Role `locationName:"roles" type:"list"`

	// The current status of the assessment.
	Status *string `locationName:"status" type:"string" enum:"AssessmentStatus"`
}

// String returns the string representation
func (s AssessmentMetadataItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentMetadataItem) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AssessmentMetadataItem) SetComplianceType(v string) *AssessmentMetadataItem {
	s.ComplianceType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AssessmentMetadataItem) SetCreationTime(v time.Time) *AssessmentMetadataItem {
	s.CreationTime = &v
	return s
}

// SetDelegations sets the Delegations field's value.
func (s *AssessmentMetadataItem) SetDelegations(v []*Delegation) *AssessmentMetadataItem {
	s.Delegations = v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentMetadataItem) SetId(v string) *AssessmentMetadataItem {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *AssessmentMetadataItem) SetLastUpdated(v time.Time) *AssessmentMetadataItem {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentMetadataItem) SetName(v string) *AssessmentMetadataItem {
	s.Name = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *AssessmentMetadataItem) SetRoles(v []*Role) *AssessmentMetadataItem {
	s.Roles = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssessmentMetadataItem) SetStatus(v string) *AssessmentMetadataItem {
	s.Status = &v
	return s
}

// A finalized document generated from an AWS Audit Manager assessment. These
// reports summarize the relevant evidence collected for your audit, and link
// to the relevant evidence folders which are named and organized according
// to the controls specified in your assessment.
type AssessmentReport struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	AssessmentId *string `locationName:"assessmentId" min:"36" type:"string"`

	// The name of the associated assessment.
	AssessmentName *string `locationName:"assessmentName" min:"1" type:"string"`

	// The name of the user who created the assessment report.
	Author *string `locationName:"author" min:"1" type:"string"`

	// The identifier for the specified AWS account.
	AwsAccountId *string `locationName:"awsAccountId" min:"12" type:"string"`

	// Specifies when the assessment report was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the specified assessment report.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier for the specified assessment report.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name given to the assessment report.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The current status of the specified assessment report.
	Status *string `locationName:"status" type:"string" enum:"AssessmentReportStatus"`
}

// String returns the string representation
func (s AssessmentReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentReport) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *AssessmentReport) SetAssessmentId(v string) *AssessmentReport {
	s.AssessmentId = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *AssessmentReport) SetAssessmentName(v string) *AssessmentReport {
	s.AssessmentName = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *AssessmentReport) SetAuthor(v string) *AssessmentReport {
	s.Author = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AssessmentReport) SetAwsAccountId(v string) *AssessmentReport {
	s.AwsAccountId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AssessmentReport) SetCreationTime(v time.Time) *AssessmentReport {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssessmentReport) SetDescription(v string) *AssessmentReport {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentReport) SetId(v string) *AssessmentReport {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentReport) SetName(v string) *AssessmentReport {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssessmentReport) SetStatus(v string) *AssessmentReport {
	s.Status = &v
	return s
}

// An error entity for the AssessmentReportEvidence API. This is used to provide
// more meaningful errors than a simple string message.
type AssessmentReportEvidenceError struct {
	_ struct{} `type:"structure"`

	// The error code returned by the AssessmentReportEvidence API.
	ErrorCode *string `locationName:"errorCode" min:"3" type:"string"`

	// The error message returned by the AssessmentReportEvidence API.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The identifier for the evidence.
	EvidenceId *string `locationName:"evidenceId" min:"36" type:"string"`
}

// String returns the string representation
func (s AssessmentReportEvidenceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentReportEvidenceError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AssessmentReportEvidenceError) SetErrorCode(v string) *AssessmentReportEvidenceError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AssessmentReportEvidenceError) SetErrorMessage(v string) *AssessmentReportEvidenceError {
	s.ErrorMessage = &v
	return s
}

// SetEvidenceId sets the EvidenceId field's value.
func (s *AssessmentReportEvidenceError) SetEvidenceId(v string) *AssessmentReportEvidenceError {
	s.EvidenceId = &v
	return s
}

// The metadata objects associated with the specified assessment report.
type AssessmentReportMetadata struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the associated assessment.
	AssessmentId *string `locationName:"assessmentId" min:"36" type:"string"`

	// The name of the associated assessment.
	AssessmentName *string `locationName:"assessmentName" min:"1" type:"string"`

	// The name of the user who created the assessment report.
	Author *string `locationName:"author" min:"1" type:"string"`

	// Specifies when the assessment report was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the specified assessment report.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier for the assessment report.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the assessment report.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The current status of the assessment report.
	Status *string `locationName:"status" type:"string" enum:"AssessmentReportStatus"`
}

// String returns the string representation
func (s AssessmentReportMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentReportMetadata) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *AssessmentReportMetadata) SetAssessmentId(v string) *AssessmentReportMetadata {
	s.AssessmentId = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *AssessmentReportMetadata) SetAssessmentName(v string) *AssessmentReportMetadata {
	s.AssessmentName = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *AssessmentReportMetadata) SetAuthor(v string) *AssessmentReportMetadata {
	s.Author = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AssessmentReportMetadata) SetCreationTime(v time.Time) *AssessmentReportMetadata {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssessmentReportMetadata) SetDescription(v string) *AssessmentReportMetadata {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssessmentReportMetadata) SetId(v string) *AssessmentReportMetadata {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssessmentReportMetadata) SetName(v string) *AssessmentReportMetadata {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssessmentReportMetadata) SetStatus(v string) *AssessmentReportMetadata {
	s.Status = &v
	return s
}

// The location in which AWS Audit Manager saves assessment reports for the
// given assessment.
type AssessmentReportsDestination struct {
	_ struct{} `type:"structure"`

	// The destination of the assessment report.
	Destination *string `locationName:"destination" min:"1" type:"string"`

	// The destination type, such as Amazon S3.
	DestinationType *string `locationName:"destinationType" type:"string" enum:"AssessmentReportDestinationType"`
}

// String returns the string representation
func (s AssessmentReportsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentReportsDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssessmentReportsDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssessmentReportsDestination"}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *AssessmentReportsDestination) SetDestination(v string) *AssessmentReportsDestination {
	s.Destination = &v
	return s
}

// SetDestinationType sets the DestinationType field's value.
func (s *AssessmentReportsDestination) SetDestinationType(v string) *AssessmentReportsDestination {
	s.DestinationType = &v
	return s
}

type AssociateAssessmentReportEvidenceFolderInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the folder in which evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateAssessmentReportEvidenceFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAssessmentReportEvidenceFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAssessmentReportEvidenceFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAssessmentReportEvidenceFolderInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *AssociateAssessmentReportEvidenceFolderInput) SetAssessmentId(v string) *AssociateAssessmentReportEvidenceFolderInput {
	s.AssessmentId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *AssociateAssessmentReportEvidenceFolderInput) SetEvidenceFolderId(v string) *AssociateAssessmentReportEvidenceFolderInput {
	s.EvidenceFolderId = &v
	return s
}

type AssociateAssessmentReportEvidenceFolderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateAssessmentReportEvidenceFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAssessmentReportEvidenceFolderOutput) GoString() string {
	return s.String()
}

type BatchAssociateAssessmentReportEvidenceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the folder in which the evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`

	// The list of evidence identifiers.
	//
	// EvidenceIds is a required field
	EvidenceIds []*string `locationName:"evidenceIds" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAssociateAssessmentReportEvidenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAssociateAssessmentReportEvidenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateAssessmentReportEvidenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateAssessmentReportEvidenceInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}
	if s.EvidenceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *BatchAssociateAssessmentReportEvidenceInput) SetAssessmentId(v string) *BatchAssociateAssessmentReportEvidenceInput {
	s.AssessmentId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *BatchAssociateAssessmentReportEvidenceInput) SetEvidenceFolderId(v string) *BatchAssociateAssessmentReportEvidenceInput {
	s.EvidenceFolderId = &v
	return s
}

// SetEvidenceIds sets the EvidenceIds field's value.
func (s *BatchAssociateAssessmentReportEvidenceInput) SetEvidenceIds(v []*string) *BatchAssociateAssessmentReportEvidenceInput {
	s.EvidenceIds = v
	return s
}

type BatchAssociateAssessmentReportEvidenceOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors returned by the BatchAssociateAssessmentReportEvidence API.
	Errors []*AssessmentReportEvidenceError `locationName:"errors" type:"list"`

	// The identifier for the evidence.
	EvidenceIds []*string `locationName:"evidenceIds" type:"list"`
}

// String returns the string representation
func (s BatchAssociateAssessmentReportEvidenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAssociateAssessmentReportEvidenceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchAssociateAssessmentReportEvidenceOutput) SetErrors(v []*AssessmentReportEvidenceError) *BatchAssociateAssessmentReportEvidenceOutput {
	s.Errors = v
	return s
}

// SetEvidenceIds sets the EvidenceIds field's value.
func (s *BatchAssociateAssessmentReportEvidenceOutput) SetEvidenceIds(v []*string) *BatchAssociateAssessmentReportEvidenceOutput {
	s.EvidenceIds = v
	return s
}

// An error entity for the BatchCreateDelegationByAssessment API. This is used
// to provide more meaningful errors than a simple string message.
type BatchCreateDelegationByAssessmentError struct {
	_ struct{} `type:"structure"`

	// The API request to batch create delegations in AWS Audit Manager.
	CreateDelegationRequest *CreateDelegationRequest `locationName:"createDelegationRequest" type:"structure"`

	// The error code returned by the BatchCreateDelegationByAssessment API.
	ErrorCode *string `locationName:"errorCode" min:"3" type:"string"`

	// The error message returned by the BatchCreateDelegationByAssessment API.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s BatchCreateDelegationByAssessmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateDelegationByAssessmentError) GoString() string {
	return s.String()
}

// SetCreateDelegationRequest sets the CreateDelegationRequest field's value.
func (s *BatchCreateDelegationByAssessmentError) SetCreateDelegationRequest(v *CreateDelegationRequest) *BatchCreateDelegationByAssessmentError {
	s.CreateDelegationRequest = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchCreateDelegationByAssessmentError) SetErrorCode(v string) *BatchCreateDelegationByAssessmentError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchCreateDelegationByAssessmentError) SetErrorMessage(v string) *BatchCreateDelegationByAssessmentError {
	s.ErrorMessage = &v
	return s
}

type BatchCreateDelegationByAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The API request to batch create delegations in AWS Audit Manager.
	//
	// CreateDelegationRequests is a required field
	CreateDelegationRequests []*CreateDelegationRequest `locationName:"createDelegationRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchCreateDelegationByAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateDelegationByAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateDelegationByAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateDelegationByAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.CreateDelegationRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateDelegationRequests"))
	}
	if s.CreateDelegationRequests != nil && len(s.CreateDelegationRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreateDelegationRequests", 1))
	}
	if s.CreateDelegationRequests != nil {
		for i, v := range s.CreateDelegationRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateDelegationRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *BatchCreateDelegationByAssessmentInput) SetAssessmentId(v string) *BatchCreateDelegationByAssessmentInput {
	s.AssessmentId = &v
	return s
}

// SetCreateDelegationRequests sets the CreateDelegationRequests field's value.
func (s *BatchCreateDelegationByAssessmentInput) SetCreateDelegationRequests(v []*CreateDelegationRequest) *BatchCreateDelegationByAssessmentInput {
	s.CreateDelegationRequests = v
	return s
}

type BatchCreateDelegationByAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The delegations associated with the assessment.
	Delegations []*Delegation `locationName:"delegations" type:"list"`

	// A list of errors returned by the BatchCreateDelegationByAssessment API.
	Errors []*BatchCreateDelegationByAssessmentError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchCreateDelegationByAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateDelegationByAssessmentOutput) GoString() string {
	return s.String()
}

// SetDelegations sets the Delegations field's value.
func (s *BatchCreateDelegationByAssessmentOutput) SetDelegations(v []*Delegation) *BatchCreateDelegationByAssessmentOutput {
	s.Delegations = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateDelegationByAssessmentOutput) SetErrors(v []*BatchCreateDelegationByAssessmentError) *BatchCreateDelegationByAssessmentOutput {
	s.Errors = v
	return s
}

// An error entity for the BatchDeleteDelegationByAssessment API. This is used
// to provide more meaningful errors than a simple string message.
type BatchDeleteDelegationByAssessmentError struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified delegation.
	DelegationId *string `locationName:"delegationId" min:"36" type:"string"`

	// The error code returned by the BatchDeleteDelegationByAssessment API.
	ErrorCode *string `locationName:"errorCode" min:"3" type:"string"`

	// The error message returned by the BatchDeleteDelegationByAssessment API.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s BatchDeleteDelegationByAssessmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteDelegationByAssessmentError) GoString() string {
	return s.String()
}

// SetDelegationId sets the DelegationId field's value.
func (s *BatchDeleteDelegationByAssessmentError) SetDelegationId(v string) *BatchDeleteDelegationByAssessmentError {
	s.DelegationId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchDeleteDelegationByAssessmentError) SetErrorCode(v string) *BatchDeleteDelegationByAssessmentError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchDeleteDelegationByAssessmentError) SetErrorMessage(v string) *BatchDeleteDelegationByAssessmentError {
	s.ErrorMessage = &v
	return s
}

type BatchDeleteDelegationByAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifiers for the specified delegations.
	//
	// DelegationIds is a required field
	DelegationIds []*string `locationName:"delegationIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteDelegationByAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteDelegationByAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteDelegationByAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteDelegationByAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.DelegationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DelegationIds"))
	}
	if s.DelegationIds != nil && len(s.DelegationIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DelegationIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *BatchDeleteDelegationByAssessmentInput) SetAssessmentId(v string) *BatchDeleteDelegationByAssessmentInput {
	s.AssessmentId = &v
	return s
}

// SetDelegationIds sets the DelegationIds field's value.
func (s *BatchDeleteDelegationByAssessmentInput) SetDelegationIds(v []*string) *BatchDeleteDelegationByAssessmentInput {
	s.DelegationIds = v
	return s
}

type BatchDeleteDelegationByAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors returned by the BatchDeleteDelegationByAssessment API.
	Errors []*BatchDeleteDelegationByAssessmentError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchDeleteDelegationByAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteDelegationByAssessmentOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteDelegationByAssessmentOutput) SetErrors(v []*BatchDeleteDelegationByAssessmentError) *BatchDeleteDelegationByAssessmentOutput {
	s.Errors = v
	return s
}

type BatchDisassociateAssessmentReportEvidenceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the folder in which evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`

	// The list of evidence identifiers.
	//
	// EvidenceIds is a required field
	EvidenceIds []*string `locationName:"evidenceIds" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDisassociateAssessmentReportEvidenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisassociateAssessmentReportEvidenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateAssessmentReportEvidenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateAssessmentReportEvidenceInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}
	if s.EvidenceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *BatchDisassociateAssessmentReportEvidenceInput) SetAssessmentId(v string) *BatchDisassociateAssessmentReportEvidenceInput {
	s.AssessmentId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *BatchDisassociateAssessmentReportEvidenceInput) SetEvidenceFolderId(v string) *BatchDisassociateAssessmentReportEvidenceInput {
	s.EvidenceFolderId = &v
	return s
}

// SetEvidenceIds sets the EvidenceIds field's value.
func (s *BatchDisassociateAssessmentReportEvidenceInput) SetEvidenceIds(v []*string) *BatchDisassociateAssessmentReportEvidenceInput {
	s.EvidenceIds = v
	return s
}

type BatchDisassociateAssessmentReportEvidenceOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors returned by the BatchDisassociateAssessmentReportEvidence
	// API.
	Errors []*AssessmentReportEvidenceError `locationName:"errors" type:"list"`

	// The identifier for the evidence.
	EvidenceIds []*string `locationName:"evidenceIds" type:"list"`
}

// String returns the string representation
func (s BatchDisassociateAssessmentReportEvidenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisassociateAssessmentReportEvidenceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDisassociateAssessmentReportEvidenceOutput) SetErrors(v []*AssessmentReportEvidenceError) *BatchDisassociateAssessmentReportEvidenceOutput {
	s.Errors = v
	return s
}

// SetEvidenceIds sets the EvidenceIds field's value.
func (s *BatchDisassociateAssessmentReportEvidenceOutput) SetEvidenceIds(v []*string) *BatchDisassociateAssessmentReportEvidenceOutput {
	s.EvidenceIds = v
	return s
}

// An error entity for the BatchImportEvidenceToAssessmentControl API. This
// is used to provide more meaningful errors than a simple string message.
type BatchImportEvidenceToAssessmentControlError struct {
	_ struct{} `type:"structure"`

	// The error code returned by the BatchImportEvidenceToAssessmentControl API.
	ErrorCode *string `locationName:"errorCode" min:"3" type:"string"`

	// The error message returned by the BatchImportEvidenceToAssessmentControl
	// API.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Manual evidence that cannot be collected automatically by AWS Audit Manager.
	ManualEvidence *ManualEvidence `locationName:"manualEvidence" type:"structure"`
}

// String returns the string representation
func (s BatchImportEvidenceToAssessmentControlError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportEvidenceToAssessmentControlError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchImportEvidenceToAssessmentControlError) SetErrorCode(v string) *BatchImportEvidenceToAssessmentControlError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchImportEvidenceToAssessmentControlError) SetErrorMessage(v string) *BatchImportEvidenceToAssessmentControlError {
	s.ErrorMessage = &v
	return s
}

// SetManualEvidence sets the ManualEvidence field's value.
func (s *BatchImportEvidenceToAssessmentControlError) SetManualEvidence(v *ManualEvidence) *BatchImportEvidenceToAssessmentControlError {
	s.ManualEvidence = v
	return s
}

type BatchImportEvidenceToAssessmentControlInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control.
	//
	// ControlId is a required field
	ControlId *string `location:"uri" locationName:"controlId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" min:"1" type:"string" required:"true"`

	// The list of manual evidence objects.
	//
	// ManualEvidence is a required field
	ManualEvidence []*ManualEvidence `locationName:"manualEvidence" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchImportEvidenceToAssessmentControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportEvidenceToAssessmentControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchImportEvidenceToAssessmentControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchImportEvidenceToAssessmentControlInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlId"))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.ManualEvidence == nil {
		invalidParams.Add(request.NewErrParamRequired("ManualEvidence"))
	}
	if s.ManualEvidence != nil && len(s.ManualEvidence) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManualEvidence", 1))
	}
	if s.ManualEvidence != nil {
		for i, v := range s.ManualEvidence {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ManualEvidence", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *BatchImportEvidenceToAssessmentControlInput) SetAssessmentId(v string) *BatchImportEvidenceToAssessmentControlInput {
	s.AssessmentId = &v
	return s
}

// SetControlId sets the ControlId field's value.
func (s *BatchImportEvidenceToAssessmentControlInput) SetControlId(v string) *BatchImportEvidenceToAssessmentControlInput {
	s.ControlId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *BatchImportEvidenceToAssessmentControlInput) SetControlSetId(v string) *BatchImportEvidenceToAssessmentControlInput {
	s.ControlSetId = &v
	return s
}

// SetManualEvidence sets the ManualEvidence field's value.
func (s *BatchImportEvidenceToAssessmentControlInput) SetManualEvidence(v []*ManualEvidence) *BatchImportEvidenceToAssessmentControlInput {
	s.ManualEvidence = v
	return s
}

type BatchImportEvidenceToAssessmentControlOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors returned by the BatchImportEvidenceToAssessmentControl API.
	Errors []*BatchImportEvidenceToAssessmentControlError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchImportEvidenceToAssessmentControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportEvidenceToAssessmentControlOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchImportEvidenceToAssessmentControlOutput) SetErrors(v []*BatchImportEvidenceToAssessmentControlError) *BatchImportEvidenceToAssessmentControlOutput {
	s.Errors = v
	return s
}

// The record of a change within AWS Audit Manager, such as a modified assessment,
// a delegated control set, and so on.
type ChangeLog struct {
	_ struct{} `type:"structure"`

	// The action performed.
	Action *string `locationName:"action" type:"string" enum:"ActionEnum"`

	// The time of creation for the changelog object.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The IAM user or role that performed the action.
	CreatedBy *string `locationName:"createdBy" min:"20" type:"string"`

	// The name of the changelog object.
	ObjectName *string `locationName:"objectName" min:"1" type:"string"`

	// The changelog object type, such as an assessment, control, or control set.
	ObjectType *string `locationName:"objectType" type:"string" enum:"ObjectTypeEnum"`
}

// String returns the string representation
func (s ChangeLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeLog) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ChangeLog) SetAction(v string) *ChangeLog {
	s.Action = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ChangeLog) SetCreatedAt(v time.Time) *ChangeLog {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ChangeLog) SetCreatedBy(v string) *ChangeLog {
	s.CreatedBy = &v
	return s
}

// SetObjectName sets the ObjectName field's value.
func (s *ChangeLog) SetObjectName(v string) *ChangeLog {
	s.ObjectName = &v
	return s
}

// SetObjectType sets the ObjectType field's value.
func (s *ChangeLog) SetObjectType(v string) *ChangeLog {
	s.ObjectType = &v
	return s
}

// A control in AWS Audit Manager.
type Control struct {
	_ struct{} `type:"structure"`

	// The recommended actions to carry out if the control is not fulfilled.
	ActionPlanInstructions *string `locationName:"actionPlanInstructions" type:"string"`

	// The title of the action plan for remediating the control.
	ActionPlanTitle *string `locationName:"actionPlanTitle" type:"string"`

	// The Amazon Resource Name (ARN) of the specified control.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The data mapping sources for the specified control.
	ControlMappingSources []*ControlMappingSource `locationName:"controlMappingSources" min:"1" type:"list"`

	// The data source that determines from where AWS Audit Manager collects evidence
	// for the control.
	ControlSources *string `locationName:"controlSources" min:"1" type:"string"`

	// Specifies when the control was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The IAM user or role that created the control.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The description of the specified control.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier for the control.
	Id *string `locationName:"id" min:"36" type:"string"`

	// Specifies when the control was most recently updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The IAM user or role that most recently updated the control.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" min:"1" type:"string"`

	// The name of the specified control.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The tags associated with the control.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The steps to follow to determine if the control has been satisfied.
	TestingInformation *string `locationName:"testingInformation" type:"string"`

	// The type of control, such as custom or standard.
	Type *string `locationName:"type" type:"string" enum:"ControlType"`
}

// String returns the string representation
func (s Control) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Control) GoString() string {
	return s.String()
}

// SetActionPlanInstructions sets the ActionPlanInstructions field's value.
func (s *Control) SetActionPlanInstructions(v string) *Control {
	s.ActionPlanInstructions = &v
	return s
}

// SetActionPlanTitle sets the ActionPlanTitle field's value.
func (s *Control) SetActionPlanTitle(v string) *Control {
	s.ActionPlanTitle = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Control) SetArn(v string) *Control {
	s.Arn = &v
	return s
}

// SetControlMappingSources sets the ControlMappingSources field's value.
func (s *Control) SetControlMappingSources(v []*ControlMappingSource) *Control {
	s.ControlMappingSources = v
	return s
}

// SetControlSources sets the ControlSources field's value.
func (s *Control) SetControlSources(v string) *Control {
	s.ControlSources = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Control) SetCreatedAt(v time.Time) *Control {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Control) SetCreatedBy(v string) *Control {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Control) SetDescription(v string) *Control {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Control) SetId(v string) *Control {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Control) SetLastUpdatedAt(v time.Time) *Control {
	s.LastUpdatedAt = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *Control) SetLastUpdatedBy(v string) *Control {
	s.LastUpdatedBy = &v
	return s
}

// SetName sets the Name field's value.
func (s *Control) SetName(v string) *Control {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Control) SetTags(v map[string]*string) *Control {
	s.Tags = v
	return s
}

// SetTestingInformation sets the TestingInformation field's value.
func (s *Control) SetTestingInformation(v string) *Control {
	s.TestingInformation = &v
	return s
}

// SetType sets the Type field's value.
func (s *Control) SetType(v string) *Control {
	s.Type = &v
	return s
}

// A comment posted by a user on a control. This includes the author's name,
// the comment text, and a timestamp.
type ControlComment struct {
	_ struct{} `type:"structure"`

	// The name of the user who authored the comment.
	AuthorName *string `locationName:"authorName" min:"1" type:"string"`

	// The body text of a control comment.
	CommentBody *string `locationName:"commentBody" type:"string"`

	// The time when the comment was posted.
	PostedDate *time.Time `locationName:"postedDate" type:"timestamp"`
}

// String returns the string representation
func (s ControlComment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ControlComment) GoString() string {
	return s.String()
}

// SetAuthorName sets the AuthorName field's value.
func (s *ControlComment) SetAuthorName(v string) *ControlComment {
	s.AuthorName = &v
	return s
}

// SetCommentBody sets the CommentBody field's value.
func (s *ControlComment) SetCommentBody(v string) *ControlComment {
	s.CommentBody = &v
	return s
}

// SetPostedDate sets the PostedDate field's value.
func (s *ControlComment) SetPostedDate(v time.Time) *ControlComment {
	s.PostedDate = &v
	return s
}

// The data source that determines from where AWS Audit Manager collects evidence
// for the control.
type ControlMappingSource struct {
	_ struct{} `type:"structure"`

	// The description of the specified source.
	SourceDescription *string `locationName:"sourceDescription" type:"string"`

	// The frequency of evidence collection for the specified control mapping source.
	SourceFrequency *string `locationName:"sourceFrequency" type:"string" enum:"SourceFrequency"`

	// The unique identifier for the specified source.
	SourceId *string `locationName:"sourceId" min:"36" type:"string"`

	// The keyword to search for in AWS CloudTrail logs, AWS Config rules, AWS Security
	// Hub checks, and AWS API names.
	SourceKeyword *SourceKeyword `locationName:"sourceKeyword" type:"structure"`

	// The name of the specified source.
	SourceName *string `locationName:"sourceName" min:"1" type:"string"`

	// The setup option for the data source, which reflects if the evidence collection
	// is automated or manual.
	SourceSetUpOption *string `locationName:"sourceSetUpOption" type:"string" enum:"SourceSetUpOption"`

	// Specifies one of the five types of data sources for evidence collection.
	SourceType *string `locationName:"sourceType" type:"string" enum:"SourceType"`

	// The instructions for troubleshooting the specified control.
	TroubleshootingText *string `locationName:"troubleshootingText" type:"string"`
}

// String returns the string representation
func (s ControlMappingSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ControlMappingSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ControlMappingSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ControlMappingSource"}
	if s.SourceId != nil && len(*s.SourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SourceId", 36))
	}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}
	if s.SourceKeyword != nil {
		if err := s.SourceKeyword.Validate(); err != nil {
			invalidParams.AddNested("SourceKeyword", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDescription sets the SourceDescription field's value.
func (s *ControlMappingSource) SetSourceDescription(v string) *ControlMappingSource {
	s.SourceDescription = &v
	return s
}

// SetSourceFrequency sets the SourceFrequency field's value.
func (s *ControlMappingSource) SetSourceFrequency(v string) *ControlMappingSource {
	s.SourceFrequency = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *ControlMappingSource) SetSourceId(v string) *ControlMappingSource {
	s.SourceId = &v
	return s
}

// SetSourceKeyword sets the SourceKeyword field's value.
func (s *ControlMappingSource) SetSourceKeyword(v *SourceKeyword) *ControlMappingSource {
	s.SourceKeyword = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *ControlMappingSource) SetSourceName(v string) *ControlMappingSource {
	s.SourceName = &v
	return s
}

// SetSourceSetUpOption sets the SourceSetUpOption field's value.
func (s *ControlMappingSource) SetSourceSetUpOption(v string) *ControlMappingSource {
	s.SourceSetUpOption = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ControlMappingSource) SetSourceType(v string) *ControlMappingSource {
	s.SourceType = &v
	return s
}

// SetTroubleshootingText sets the TroubleshootingText field's value.
func (s *ControlMappingSource) SetTroubleshootingText(v string) *ControlMappingSource {
	s.TroubleshootingText = &v
	return s
}

// The metadata associated with the specified standard or custom control.
type ControlMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified control.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The data source that determines from where AWS Audit Manager collects evidence
	// for the control.
	ControlSources *string `locationName:"controlSources" min:"1" type:"string"`

	// Specifies when the control was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The unique identifier for the specified control.
	Id *string `locationName:"id" min:"36" type:"string"`

	// Specifies when the control was most recently updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the specified control.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s ControlMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ControlMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ControlMetadata) SetArn(v string) *ControlMetadata {
	s.Arn = &v
	return s
}

// SetControlSources sets the ControlSources field's value.
func (s *ControlMetadata) SetControlSources(v string) *ControlMetadata {
	s.ControlSources = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ControlMetadata) SetCreatedAt(v time.Time) *ControlMetadata {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *ControlMetadata) SetId(v string) *ControlMetadata {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ControlMetadata) SetLastUpdatedAt(v time.Time) *ControlMetadata {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ControlMetadata) SetName(v string) *ControlMetadata {
	s.Name = &v
	return s
}

// A set of controls in AWS Audit Manager.
type ControlSet struct {
	_ struct{} `type:"structure"`

	// The list of controls within the control set.
	Controls []*Control `locationName:"controls" min:"1" type:"list"`

	// The identifier of the control set in the assessment. This is the control
	// set name in a plain string format.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the control set.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s ControlSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ControlSet) GoString() string {
	return s.String()
}

// SetControls sets the Controls field's value.
func (s *ControlSet) SetControls(v []*Control) *ControlSet {
	s.Controls = v
	return s
}

// SetId sets the Id field's value.
func (s *ControlSet) SetId(v string) *ControlSet {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ControlSet) SetName(v string) *ControlSet {
	s.Name = &v
	return s
}

// Control entity attributes that uniquely identify an existing control to be
// added to a framework in AWS Audit Manager.
type CreateAssessmentFrameworkControl struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the control.
	Id *string `locationName:"id" min:"36" type:"string"`
}

// String returns the string representation
func (s CreateAssessmentFrameworkControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentFrameworkControl) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentFrameworkControl) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentFrameworkControl"}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CreateAssessmentFrameworkControl) SetId(v string) *CreateAssessmentFrameworkControl {
	s.Id = &v
	return s
}

// A controlSet entity that represents a collection of controls in AWS Audit
// Manager. This does not contain the control set ID.
type CreateAssessmentFrameworkControlSet struct {
	_ struct{} `type:"structure"`

	// The list of controls within the control set. This does not contain the control
	// set ID.
	Controls []*CreateAssessmentFrameworkControl `locationName:"controls" min:"1" type:"list"`

	// The name of the specified control set.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAssessmentFrameworkControlSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentFrameworkControlSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentFrameworkControlSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentFrameworkControlSet"}
	if s.Controls != nil && len(s.Controls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Controls", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Controls != nil {
		for i, v := range s.Controls {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Controls", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControls sets the Controls field's value.
func (s *CreateAssessmentFrameworkControlSet) SetControls(v []*CreateAssessmentFrameworkControl) *CreateAssessmentFrameworkControlSet {
	s.Controls = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssessmentFrameworkControlSet) SetName(v string) *CreateAssessmentFrameworkControlSet {
	s.Name = &v
	return s
}

type CreateAssessmentFrameworkInput struct {
	_ struct{} `type:"structure"`

	// The compliance type that the new custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// The control sets to be associated with the framework.
	//
	// ControlSets is a required field
	ControlSets []*CreateAssessmentFrameworkControlSet `locationName:"controlSets" min:"1" type:"list" required:"true"`

	// An optional description for the new custom framework.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the new custom framework.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The tags associated with the framework.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateAssessmentFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentFrameworkInput"}
	if s.ControlSets == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSets"))
	}
	if s.ControlSets != nil && len(s.ControlSets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSets", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ControlSets != nil {
		for i, v := range s.ControlSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ControlSets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceType sets the ComplianceType field's value.
func (s *CreateAssessmentFrameworkInput) SetComplianceType(v string) *CreateAssessmentFrameworkInput {
	s.ComplianceType = &v
	return s
}

// SetControlSets sets the ControlSets field's value.
func (s *CreateAssessmentFrameworkInput) SetControlSets(v []*CreateAssessmentFrameworkControlSet) *CreateAssessmentFrameworkInput {
	s.ControlSets = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssessmentFrameworkInput) SetDescription(v string) *CreateAssessmentFrameworkInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssessmentFrameworkInput) SetName(v string) *CreateAssessmentFrameworkInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssessmentFrameworkInput) SetTags(v map[string]*string) *CreateAssessmentFrameworkInput {
	s.Tags = v
	return s
}

type CreateAssessmentFrameworkOutput struct {
	_ struct{} `type:"structure"`

	// The name of the new framework returned by the CreateAssessmentFramework API.
	Framework *Framework `locationName:"framework" type:"structure"`
}

// String returns the string representation
func (s CreateAssessmentFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentFrameworkOutput) GoString() string {
	return s.String()
}

// SetFramework sets the Framework field's value.
func (s *CreateAssessmentFrameworkOutput) SetFramework(v *Framework) *CreateAssessmentFrameworkOutput {
	s.Framework = v
	return s
}

type CreateAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The assessment report storage destination for the specified assessment that
	// is being created.
	//
	// AssessmentReportsDestination is a required field
	AssessmentReportsDestination *AssessmentReportsDestination `locationName:"assessmentReportsDestination" type:"structure" required:"true"`

	// The optional description of the assessment to be created.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the specified framework.
	//
	// FrameworkId is a required field
	FrameworkId *string `locationName:"frameworkId" min:"36" type:"string" required:"true"`

	// The name of the assessment to be created.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The list of roles for the specified assessment.
	//
	// Roles is a required field
	Roles []*Role `locationName:"roles" type:"list" required:"true"`

	// The wrapper that contains the AWS accounts and AWS services in scope for
	// the assessment.
	//
	// Scope is a required field
	Scope *Scope `locationName:"scope" type:"structure" required:"true"`

	// The tags associated with the assessment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentInput"}
	if s.AssessmentReportsDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentReportsDestination"))
	}
	if s.FrameworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkId"))
	}
	if s.FrameworkId != nil && len(*s.FrameworkId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Roles == nil {
		invalidParams.Add(request.NewErrParamRequired("Roles"))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.AssessmentReportsDestination != nil {
		if err := s.AssessmentReportsDestination.Validate(); err != nil {
			invalidParams.AddNested("AssessmentReportsDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.Roles != nil {
		for i, v := range s.Roles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Roles", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Scope != nil {
		if err := s.Scope.Validate(); err != nil {
			invalidParams.AddNested("Scope", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentReportsDestination sets the AssessmentReportsDestination field's value.
func (s *CreateAssessmentInput) SetAssessmentReportsDestination(v *AssessmentReportsDestination) *CreateAssessmentInput {
	s.AssessmentReportsDestination = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssessmentInput) SetDescription(v string) *CreateAssessmentInput {
	s.Description = &v
	return s
}

// SetFrameworkId sets the FrameworkId field's value.
func (s *CreateAssessmentInput) SetFrameworkId(v string) *CreateAssessmentInput {
	s.FrameworkId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssessmentInput) SetName(v string) *CreateAssessmentInput {
	s.Name = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *CreateAssessmentInput) SetRoles(v []*Role) *CreateAssessmentInput {
	s.Roles = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateAssessmentInput) SetScope(v *Scope) *CreateAssessmentInput {
	s.Scope = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssessmentInput) SetTags(v map[string]*string) *CreateAssessmentInput {
	s.Tags = v
	return s
}

type CreateAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// An entity that defines the scope of audit evidence collected by AWS Audit
	// Manager. An AWS Audit Manager assessment is an implementation of an AWS Audit
	// Manager framework.
	Assessment *Assessment `locationName:"assessment" type:"structure"`
}

// String returns the string representation
func (s CreateAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessment sets the Assessment field's value.
func (s *CreateAssessmentOutput) SetAssessment(v *Assessment) *CreateAssessmentOutput {
	s.Assessment = v
	return s
}

type CreateAssessmentReportInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The description of the assessment report.
	Description *string `locationName:"description" type:"string"`

	// The name of the new assessment report.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAssessmentReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssessmentReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssessmentReportInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *CreateAssessmentReportInput) SetAssessmentId(v string) *CreateAssessmentReportInput {
	s.AssessmentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssessmentReportInput) SetDescription(v string) *CreateAssessmentReportInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssessmentReportInput) SetName(v string) *CreateAssessmentReportInput {
	s.Name = &v
	return s
}

type CreateAssessmentReportOutput struct {
	_ struct{} `type:"structure"`

	// The new assessment report returned by the CreateAssessmentReport API.
	AssessmentReport *AssessmentReport `locationName:"assessmentReport" type:"structure"`
}

// String returns the string representation
func (s CreateAssessmentReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentReportOutput) GoString() string {
	return s.String()
}

// SetAssessmentReport sets the AssessmentReport field's value.
func (s *CreateAssessmentReportOutput) SetAssessmentReport(v *AssessmentReport) *CreateAssessmentReportOutput {
	s.AssessmentReport = v
	return s
}

type CreateControlInput struct {
	_ struct{} `type:"structure"`

	// The recommended actions to carry out if the control is not fulfilled.
	ActionPlanInstructions *string `locationName:"actionPlanInstructions" type:"string"`

	// The title of the action plan for remediating the control.
	ActionPlanTitle *string `locationName:"actionPlanTitle" type:"string"`

	// The data mapping sources for the specified control.
	//
	// ControlMappingSources is a required field
	ControlMappingSources []*CreateControlMappingSource `locationName:"controlMappingSources" min:"1" type:"list" required:"true"`

	// The description of the control.
	Description *string `locationName:"description" type:"string"`

	// The name of the control.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The tags associated with the control.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The steps to follow to determine if the control has been satisfied.
	TestingInformation *string `locationName:"testingInformation" type:"string"`
}

// String returns the string representation
func (s CreateControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateControlInput"}
	if s.ControlMappingSources == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlMappingSources"))
	}
	if s.ControlMappingSources != nil && len(s.ControlMappingSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlMappingSources", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ControlMappingSources != nil {
		for i, v := range s.ControlMappingSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ControlMappingSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionPlanInstructions sets the ActionPlanInstructions field's value.
func (s *CreateControlInput) SetActionPlanInstructions(v string) *CreateControlInput {
	s.ActionPlanInstructions = &v
	return s
}

// SetActionPlanTitle sets the ActionPlanTitle field's value.
func (s *CreateControlInput) SetActionPlanTitle(v string) *CreateControlInput {
	s.ActionPlanTitle = &v
	return s
}

// SetControlMappingSources sets the ControlMappingSources field's value.
func (s *CreateControlInput) SetControlMappingSources(v []*CreateControlMappingSource) *CreateControlInput {
	s.ControlMappingSources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateControlInput) SetDescription(v string) *CreateControlInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateControlInput) SetName(v string) *CreateControlInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateControlInput) SetTags(v map[string]*string) *CreateControlInput {
	s.Tags = v
	return s
}

// SetTestingInformation sets the TestingInformation field's value.
func (s *CreateControlInput) SetTestingInformation(v string) *CreateControlInput {
	s.TestingInformation = &v
	return s
}

// Control mapping fields that represent the source for evidence collection,
// along with related parameters and metadata. This does not contain mappingID.
type CreateControlMappingSource struct {
	_ struct{} `type:"structure"`

	// The description of the data source that determines from where AWS Audit Manager
	// collects evidence for the control.
	SourceDescription *string `locationName:"sourceDescription" type:"string"`

	// The frequency of evidence collection for the specified control mapping source.
	SourceFrequency *string `locationName:"sourceFrequency" type:"string" enum:"SourceFrequency"`

	// The keyword to search for in AWS CloudTrail logs, AWS Config rules, AWS Security
	// Hub checks, and AWS API names.
	SourceKeyword *SourceKeyword `locationName:"sourceKeyword" type:"structure"`

	// The name of the control mapping data source.
	SourceName *string `locationName:"sourceName" min:"1" type:"string"`

	// The setup option for the data source, which reflects if the evidence collection
	// is automated or manual.
	SourceSetUpOption *string `locationName:"sourceSetUpOption" type:"string" enum:"SourceSetUpOption"`

	// Specifies one of the five types of data sources for evidence collection.
	SourceType *string `locationName:"sourceType" type:"string" enum:"SourceType"`

	// The instructions for troubleshooting the specified control.
	TroubleshootingText *string `locationName:"troubleshootingText" type:"string"`
}

// String returns the string representation
func (s CreateControlMappingSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateControlMappingSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateControlMappingSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateControlMappingSource"}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}
	if s.SourceKeyword != nil {
		if err := s.SourceKeyword.Validate(); err != nil {
			invalidParams.AddNested("SourceKeyword", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDescription sets the SourceDescription field's value.
func (s *CreateControlMappingSource) SetSourceDescription(v string) *CreateControlMappingSource {
	s.SourceDescription = &v
	return s
}

// SetSourceFrequency sets the SourceFrequency field's value.
func (s *CreateControlMappingSource) SetSourceFrequency(v string) *CreateControlMappingSource {
	s.SourceFrequency = &v
	return s
}

// SetSourceKeyword sets the SourceKeyword field's value.
func (s *CreateControlMappingSource) SetSourceKeyword(v *SourceKeyword) *CreateControlMappingSource {
	s.SourceKeyword = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *CreateControlMappingSource) SetSourceName(v string) *CreateControlMappingSource {
	s.SourceName = &v
	return s
}

// SetSourceSetUpOption sets the SourceSetUpOption field's value.
func (s *CreateControlMappingSource) SetSourceSetUpOption(v string) *CreateControlMappingSource {
	s.SourceSetUpOption = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateControlMappingSource) SetSourceType(v string) *CreateControlMappingSource {
	s.SourceType = &v
	return s
}

// SetTroubleshootingText sets the TroubleshootingText field's value.
func (s *CreateControlMappingSource) SetTroubleshootingText(v string) *CreateControlMappingSource {
	s.TroubleshootingText = &v
	return s
}

type CreateControlOutput struct {
	_ struct{} `type:"structure"`

	// The new control returned by the CreateControl API.
	Control *Control `locationName:"control" type:"structure"`
}

// String returns the string representation
func (s CreateControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateControlOutput) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *CreateControlOutput) SetControl(v *Control) *CreateControlOutput {
	s.Control = v
	return s
}

// A collection of attributes used to create a delegation for an assessment
// in AWS Audit Manager.
type CreateDelegationRequest struct {
	_ struct{} `type:"structure"`

	// A comment related to the delegation request.
	Comment *string `locationName:"comment" type:"string"`

	// The unique identifier for the control set.
	ControlSetId *string `locationName:"controlSetId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The type of customer persona.
	//
	// In CreateAssessment, roleType can only be PROCESS_OWNER.
	//
	// In UpdateSettings, roleType can only be PROCESS_OWNER.
	//
	// In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
	RoleType *string `locationName:"roleType" type:"string" enum:"RoleType"`
}

// String returns the string representation
func (s CreateDelegationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDelegationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDelegationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDelegationRequest"}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CreateDelegationRequest) SetComment(v string) *CreateDelegationRequest {
	s.Comment = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *CreateDelegationRequest) SetControlSetId(v string) *CreateDelegationRequest {
	s.ControlSetId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDelegationRequest) SetRoleArn(v string) *CreateDelegationRequest {
	s.RoleArn = &v
	return s
}

// SetRoleType sets the RoleType field's value.
func (s *CreateDelegationRequest) SetRoleType(v string) *CreateDelegationRequest {
	s.RoleType = &v
	return s
}

// The assignment of a control set to a delegate for review.
type Delegation struct {
	_ struct{} `type:"structure"`

	// The identifier for the associated assessment.
	AssessmentId *string `locationName:"assessmentId" min:"36" type:"string"`

	// The name of the associated assessment.
	AssessmentName *string `locationName:"assessmentName" min:"1" type:"string"`

	// The comment related to the delegation.
	Comment *string `locationName:"comment" type:"string"`

	// The identifier for the associated control set.
	ControlSetId *string `locationName:"controlSetId" min:"1" type:"string"`

	// The IAM user or role that created the delegation.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// Specifies when the delegation was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The unique identifier for the delegation.
	Id *string `locationName:"id" min:"36" type:"string"`

	// Specifies when the delegation was last updated.
	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The type of customer persona.
	//
	// In CreateAssessment, roleType can only be PROCESS_OWNER.
	//
	// In UpdateSettings, roleType can only be PROCESS_OWNER.
	//
	// In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
	RoleType *string `locationName:"roleType" type:"string" enum:"RoleType"`

	// The status of the delegation.
	Status *string `locationName:"status" type:"string" enum:"DelegationStatus"`
}

// String returns the string representation
func (s Delegation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delegation) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *Delegation) SetAssessmentId(v string) *Delegation {
	s.AssessmentId = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *Delegation) SetAssessmentName(v string) *Delegation {
	s.AssessmentName = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *Delegation) SetComment(v string) *Delegation {
	s.Comment = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *Delegation) SetControlSetId(v string) *Delegation {
	s.ControlSetId = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Delegation) SetCreatedBy(v string) *Delegation {
	s.CreatedBy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Delegation) SetCreationTime(v time.Time) *Delegation {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Delegation) SetId(v string) *Delegation {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Delegation) SetLastUpdated(v time.Time) *Delegation {
	s.LastUpdated = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Delegation) SetRoleArn(v string) *Delegation {
	s.RoleArn = &v
	return s
}

// SetRoleType sets the RoleType field's value.
func (s *Delegation) SetRoleType(v string) *Delegation {
	s.RoleType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Delegation) SetStatus(v string) *Delegation {
	s.Status = &v
	return s
}

// The metadata associated with the specified delegation.
type DelegationMetadata struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the specified assessment.
	AssessmentId *string `locationName:"assessmentId" min:"36" type:"string"`

	// The name of the associated assessment.
	AssessmentName *string `locationName:"assessmentName" min:"1" type:"string"`

	// Specifies the name of the control set delegated for review.
	ControlSetName *string `locationName:"controlSetName" min:"1" type:"string"`

	// Specifies when the delegation was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The unique identifier for the delegation.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The current status of the delgation.
	Status *string `locationName:"status" type:"string" enum:"DelegationStatus"`
}

// String returns the string representation
func (s DelegationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegationMetadata) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *DelegationMetadata) SetAssessmentId(v string) *DelegationMetadata {
	s.AssessmentId = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *DelegationMetadata) SetAssessmentName(v string) *DelegationMetadata {
	s.AssessmentName = &v
	return s
}

// SetControlSetName sets the ControlSetName field's value.
func (s *DelegationMetadata) SetControlSetName(v string) *DelegationMetadata {
	s.ControlSetName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DelegationMetadata) SetCreationTime(v time.Time) *DelegationMetadata {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *DelegationMetadata) SetId(v string) *DelegationMetadata {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DelegationMetadata) SetRoleArn(v string) *DelegationMetadata {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DelegationMetadata) SetStatus(v string) *DelegationMetadata {
	s.Status = &v
	return s
}

type DeleteAssessmentFrameworkInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified framework.
	//
	// FrameworkId is a required field
	FrameworkId *string `location:"uri" locationName:"frameworkId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssessmentFrameworkInput"}
	if s.FrameworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkId"))
	}
	if s.FrameworkId != nil && len(*s.FrameworkId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameworkId sets the FrameworkId field's value.
func (s *DeleteAssessmentFrameworkInput) SetFrameworkId(v string) *DeleteAssessmentFrameworkInput {
	s.FrameworkId = &v
	return s
}

type DeleteAssessmentFrameworkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentFrameworkOutput) GoString() string {
	return s.String()
}

type DeleteAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *DeleteAssessmentInput) SetAssessmentId(v string) *DeleteAssessmentInput {
	s.AssessmentId = &v
	return s
}

type DeleteAssessmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentOutput) GoString() string {
	return s.String()
}

type DeleteAssessmentReportInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The unique identifier for the assessment report.
	//
	// AssessmentReportId is a required field
	AssessmentReportId *string `location:"uri" locationName:"assessmentReportId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssessmentReportInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.AssessmentReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentReportId"))
	}
	if s.AssessmentReportId != nil && len(*s.AssessmentReportId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentReportId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *DeleteAssessmentReportInput) SetAssessmentId(v string) *DeleteAssessmentReportInput {
	s.AssessmentId = &v
	return s
}

// SetAssessmentReportId sets the AssessmentReportId field's value.
func (s *DeleteAssessmentReportInput) SetAssessmentReportId(v string) *DeleteAssessmentReportInput {
	s.AssessmentReportId = &v
	return s
}

type DeleteAssessmentReportOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentReportOutput) GoString() string {
	return s.String()
}

type DeleteControlInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified control.
	//
	// ControlId is a required field
	ControlId *string `location:"uri" locationName:"controlId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteControlInput"}
	if s.ControlId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlId"))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlId sets the ControlId field's value.
func (s *DeleteControlInput) SetControlId(v string) *DeleteControlInput {
	s.ControlId = &v
	return s
}

type DeleteControlOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteControlOutput) GoString() string {
	return s.String()
}

type DeregisterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterAccountInput) GoString() string {
	return s.String()
}

type DeregisterAccountOutput struct {
	_ struct{} `type:"structure"`

	// The registration status of the account.
	Status *string `locationName:"status" type:"string" enum:"AccountStatus"`
}

// String returns the string representation
func (s DeregisterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterAccountOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeregisterAccountOutput) SetStatus(v string) *DeregisterAccountOutput {
	s.Status = &v
	return s
}

type DeregisterOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified administrator account.
	AdminAccountId *string `locationName:"adminAccountId" min:"12" type:"string"`
}

// String returns the string representation
func (s DeregisterOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterOrganizationAdminAccountInput"}
	if s.AdminAccountId != nil && len(*s.AdminAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AdminAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *DeregisterOrganizationAdminAccountInput) SetAdminAccountId(v string) *DeregisterOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type DeregisterOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

type DisassociateAssessmentReportEvidenceFolderInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the folder in which evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateAssessmentReportEvidenceFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAssessmentReportEvidenceFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAssessmentReportEvidenceFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAssessmentReportEvidenceFolderInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *DisassociateAssessmentReportEvidenceFolderInput) SetAssessmentId(v string) *DisassociateAssessmentReportEvidenceFolderInput {
	s.AssessmentId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *DisassociateAssessmentReportEvidenceFolderInput) SetEvidenceFolderId(v string) *DisassociateAssessmentReportEvidenceFolderInput {
	s.EvidenceFolderId = &v
	return s
}

type DisassociateAssessmentReportEvidenceFolderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAssessmentReportEvidenceFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAssessmentReportEvidenceFolderOutput) GoString() string {
	return s.String()
}

// A record that contains the information needed to demonstrate compliance with
// the requirements specified by a control. Examples of evidence include change
// activity triggered by a user, or a system configuration snapshot.
type Evidence struct {
	_ struct{} `type:"structure"`

	// Specifies whether the evidence is inclded in the assessment report.
	AssessmentReportSelection *string `locationName:"assessmentReportSelection" type:"string"`

	// The names and values used by the evidence event, including an attribute name
	// (such as allowUsersToChangePassword) and value (such as true or false).
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The identifier for the specified AWS account.
	AwsAccountId *string `locationName:"awsAccountId" min:"12" type:"string"`

	// The AWS account from which the evidence is collected, and its AWS organization
	// path.
	AwsOrganization *string `locationName:"awsOrganization" type:"string"`

	// The evaluation status for evidence that falls under the compliance check
	// category. For evidence collected from AWS Security Hub, a Pass or Fail result
	// is shown. For evidence collected from AWS Config, a Compliant or Noncompliant
	// result is shown.
	ComplianceCheck *string `locationName:"complianceCheck" type:"string"`

	// The data source from which the specified evidence was collected.
	DataSource *string `locationName:"dataSource" type:"string"`

	// The name of the specified evidence event.
	EventName *string `locationName:"eventName" type:"string"`

	// The AWS service from which the evidence is collected.
	EventSource *string `locationName:"eventSource" min:"1" type:"string"`

	// The identifier for the specified AWS account.
	EvidenceAwsAccountId *string `locationName:"evidenceAwsAccountId" min:"12" type:"string"`

	// The type of automated evidence.
	EvidenceByType *string `locationName:"evidenceByType" type:"string"`

	// The identifier for the folder in which the evidence is stored.
	EvidenceFolderId *string `locationName:"evidenceFolderId" min:"36" type:"string"`

	// The unique identifier for the IAM user or role associated with the evidence.
	IamId *string `locationName:"iamId" min:"20" type:"string"`

	// The identifier for the evidence.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The list of resources assessed to generate the evidence.
	ResourcesIncluded []*Resource `locationName:"resourcesIncluded" type:"list"`

	// The timestamp that represents when the evidence was collected.
	Time *time.Time `locationName:"time" type:"timestamp"`
}

// String returns the string representation
func (s Evidence) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Evidence) GoString() string {
	return s.String()
}

// SetAssessmentReportSelection sets the AssessmentReportSelection field's value.
func (s *Evidence) SetAssessmentReportSelection(v string) *Evidence {
	s.AssessmentReportSelection = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Evidence) SetAttributes(v map[string]*string) *Evidence {
	s.Attributes = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *Evidence) SetAwsAccountId(v string) *Evidence {
	s.AwsAccountId = &v
	return s
}

// SetAwsOrganization sets the AwsOrganization field's value.
func (s *Evidence) SetAwsOrganization(v string) *Evidence {
	s.AwsOrganization = &v
	return s
}

// SetComplianceCheck sets the ComplianceCheck field's value.
func (s *Evidence) SetComplianceCheck(v string) *Evidence {
	s.ComplianceCheck = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *Evidence) SetDataSource(v string) *Evidence {
	s.DataSource = &v
	return s
}

// SetEventName sets the EventName field's value.
func (s *Evidence) SetEventName(v string) *Evidence {
	s.EventName = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Evidence) SetEventSource(v string) *Evidence {
	s.EventSource = &v
	return s
}

// SetEvidenceAwsAccountId sets the EvidenceAwsAccountId field's value.
func (s *Evidence) SetEvidenceAwsAccountId(v string) *Evidence {
	s.EvidenceAwsAccountId = &v
	return s
}

// SetEvidenceByType sets the EvidenceByType field's value.
func (s *Evidence) SetEvidenceByType(v string) *Evidence {
	s.EvidenceByType = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *Evidence) SetEvidenceFolderId(v string) *Evidence {
	s.EvidenceFolderId = &v
	return s
}

// SetIamId sets the IamId field's value.
func (s *Evidence) SetIamId(v string) *Evidence {
	s.IamId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Evidence) SetId(v string) *Evidence {
	s.Id = &v
	return s
}

// SetResourcesIncluded sets the ResourcesIncluded field's value.
func (s *Evidence) SetResourcesIncluded(v []*Resource) *Evidence {
	s.ResourcesIncluded = v
	return s
}

// SetTime sets the Time field's value.
func (s *Evidence) SetTime(v time.Time) *Evidence {
	s.Time = &v
	return s
}

// The file used to structure and automate AWS Audit Manager assessments for
// a given compliance standard.
type Framework struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified framework.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The compliance type that the new custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// The control sets associated with the framework.
	ControlSets []*ControlSet `locationName:"controlSets" min:"1" type:"list"`

	// The sources from which AWS Audit Manager collects evidence for the control.
	ControlSources *string `locationName:"controlSources" min:"1" type:"string"`

	// Specifies when the framework was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The IAM user or role that created the framework.
	CreatedBy *string `locationName:"createdBy" min:"1" type:"string"`

	// The description of the specified framework.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier for the specified framework.
	Id *string `locationName:"id" min:"36" type:"string"`

	// Specifies when the framework was most recently updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The IAM user or role that most recently updated the framework.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" min:"1" type:"string"`

	// The logo associated with the framework.
	Logo *string `locationName:"logo" min:"1" type:"string"`

	// The name of the specified framework.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The tags associated with the framework.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The framework type, such as custom or standard.
	Type *string `locationName:"type" type:"string" enum:"FrameworkType"`
}

// String returns the string representation
func (s Framework) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Framework) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Framework) SetArn(v string) *Framework {
	s.Arn = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Framework) SetComplianceType(v string) *Framework {
	s.ComplianceType = &v
	return s
}

// SetControlSets sets the ControlSets field's value.
func (s *Framework) SetControlSets(v []*ControlSet) *Framework {
	s.ControlSets = v
	return s
}

// SetControlSources sets the ControlSources field's value.
func (s *Framework) SetControlSources(v string) *Framework {
	s.ControlSources = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Framework) SetCreatedAt(v time.Time) *Framework {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Framework) SetCreatedBy(v string) *Framework {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Framework) SetDescription(v string) *Framework {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Framework) SetId(v string) *Framework {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Framework) SetLastUpdatedAt(v time.Time) *Framework {
	s.LastUpdatedAt = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *Framework) SetLastUpdatedBy(v string) *Framework {
	s.LastUpdatedBy = &v
	return s
}

// SetLogo sets the Logo field's value.
func (s *Framework) SetLogo(v string) *Framework {
	s.Logo = &v
	return s
}

// SetName sets the Name field's value.
func (s *Framework) SetName(v string) *Framework {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Framework) SetTags(v map[string]*string) *Framework {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Framework) SetType(v string) *Framework {
	s.Type = &v
	return s
}

// The metadata of a framework, such as the name, ID, description, and so on.
type FrameworkMetadata struct {
	_ struct{} `type:"structure"`

	// The compliance standard associated with the framework, such as PCI-DSS or
	// HIPAA.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// The description of the framework.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The logo associated with the framework.
	Logo *string `locationName:"logo" min:"1" type:"string"`

	// The name of the framework.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s FrameworkMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FrameworkMetadata) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *FrameworkMetadata) SetComplianceType(v string) *FrameworkMetadata {
	s.ComplianceType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FrameworkMetadata) SetDescription(v string) *FrameworkMetadata {
	s.Description = &v
	return s
}

// SetLogo sets the Logo field's value.
func (s *FrameworkMetadata) SetLogo(v string) *FrameworkMetadata {
	s.Logo = &v
	return s
}

// SetName sets the Name field's value.
func (s *FrameworkMetadata) SetName(v string) *FrameworkMetadata {
	s.Name = &v
	return s
}

type GetAccountStatusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountStatusInput) GoString() string {
	return s.String()
}

type GetAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the specified AWS account.
	Status *string `locationName:"status" type:"string" enum:"AccountStatus"`
}

// String returns the string representation
func (s GetAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountStatusOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetAccountStatusOutput) SetStatus(v string) *GetAccountStatusOutput {
	s.Status = &v
	return s
}

type GetAssessmentFrameworkInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified framework.
	//
	// FrameworkId is a required field
	FrameworkId *string `location:"uri" locationName:"frameworkId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssessmentFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssessmentFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssessmentFrameworkInput"}
	if s.FrameworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkId"))
	}
	if s.FrameworkId != nil && len(*s.FrameworkId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameworkId sets the FrameworkId field's value.
func (s *GetAssessmentFrameworkInput) SetFrameworkId(v string) *GetAssessmentFrameworkInput {
	s.FrameworkId = &v
	return s
}

type GetAssessmentFrameworkOutput struct {
	_ struct{} `type:"structure"`

	// The framework returned by the GetAssessmentFramework API.
	Framework *Framework `locationName:"framework" type:"structure"`
}

// String returns the string representation
func (s GetAssessmentFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentFrameworkOutput) GoString() string {
	return s.String()
}

// SetFramework sets the Framework field's value.
func (s *GetAssessmentFrameworkOutput) SetFramework(v *Framework) *GetAssessmentFrameworkOutput {
	s.Framework = v
	return s
}

type GetAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetAssessmentInput) SetAssessmentId(v string) *GetAssessmentInput {
	s.AssessmentId = &v
	return s
}

type GetAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// An entity that defines the scope of audit evidence collected by AWS Audit
	// Manager. An AWS Audit Manager assessment is an implementation of an AWS Audit
	// Manager framework.
	Assessment *Assessment `locationName:"assessment" type:"structure"`

	// The wrapper that contains the AWS Audit Manager role information of the current
	// user, such as the role type and IAM Amazon Resource Name (ARN).
	UserRole *Role `locationName:"userRole" type:"structure"`
}

// String returns the string representation
func (s GetAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessment sets the Assessment field's value.
func (s *GetAssessmentOutput) SetAssessment(v *Assessment) *GetAssessmentOutput {
	s.Assessment = v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *GetAssessmentOutput) SetUserRole(v *Role) *GetAssessmentOutput {
	s.UserRole = v
	return s
}

type GetAssessmentReportUrlInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the assessment report.
	//
	// AssessmentReportId is a required field
	AssessmentReportId *string `location:"uri" locationName:"assessmentReportId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssessmentReportUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentReportUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssessmentReportUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssessmentReportUrlInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.AssessmentReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentReportId"))
	}
	if s.AssessmentReportId != nil && len(*s.AssessmentReportId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentReportId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetAssessmentReportUrlInput) SetAssessmentId(v string) *GetAssessmentReportUrlInput {
	s.AssessmentId = &v
	return s
}

// SetAssessmentReportId sets the AssessmentReportId field's value.
func (s *GetAssessmentReportUrlInput) SetAssessmentReportId(v string) *GetAssessmentReportUrlInput {
	s.AssessmentReportId = &v
	return s
}

type GetAssessmentReportUrlOutput struct {
	_ struct{} `type:"structure"`

	// A uniform resource locator, used as a unique identifier to locate a resource
	// on the internet.
	PreSignedUrl *URL `locationName:"preSignedUrl" type:"structure"`
}

// String returns the string representation
func (s GetAssessmentReportUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentReportUrlOutput) GoString() string {
	return s.String()
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *GetAssessmentReportUrlOutput) SetPreSignedUrl(v *URL) *GetAssessmentReportUrlOutput {
	s.PreSignedUrl = v
	return s
}

type GetChangeLogsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control.
	ControlId *string `location:"querystring" locationName:"controlId" min:"36" type:"string"`

	// The identifier for the specified control set.
	ControlSetId *string `location:"querystring" locationName:"controlSetId" min:"1" type:"string"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetChangeLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChangeLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChangeLogsInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetChangeLogsInput) SetAssessmentId(v string) *GetChangeLogsInput {
	s.AssessmentId = &v
	return s
}

// SetControlId sets the ControlId field's value.
func (s *GetChangeLogsInput) SetControlId(v string) *GetChangeLogsInput {
	s.ControlId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *GetChangeLogsInput) SetControlSetId(v string) *GetChangeLogsInput {
	s.ControlSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetChangeLogsInput) SetMaxResults(v int64) *GetChangeLogsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetChangeLogsInput) SetNextToken(v string) *GetChangeLogsInput {
	s.NextToken = &v
	return s
}

type GetChangeLogsOutput struct {
	_ struct{} `type:"structure"`

	// The list of user activity for the control.
	ChangeLogs []*ChangeLog `locationName:"changeLogs" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetChangeLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeLogsOutput) GoString() string {
	return s.String()
}

// SetChangeLogs sets the ChangeLogs field's value.
func (s *GetChangeLogsOutput) SetChangeLogs(v []*ChangeLog) *GetChangeLogsOutput {
	s.ChangeLogs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetChangeLogsOutput) SetNextToken(v string) *GetChangeLogsOutput {
	s.NextToken = &v
	return s
}

type GetControlInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified control.
	//
	// ControlId is a required field
	ControlId *string `location:"uri" locationName:"controlId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetControlInput"}
	if s.ControlId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlId"))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlId sets the ControlId field's value.
func (s *GetControlInput) SetControlId(v string) *GetControlInput {
	s.ControlId = &v
	return s
}

type GetControlOutput struct {
	_ struct{} `type:"structure"`

	// The name of the control returned by the GetControl API.
	Control *Control `locationName:"control" type:"structure"`
}

// String returns the string representation
func (s GetControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetControlOutput) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *GetControlOutput) SetControl(v *Control) *GetControlOutput {
	s.Control = v
	return s
}

type GetDelegationsInput struct {
	_ struct{} `type:"structure"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetDelegationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDelegationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDelegationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDelegationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDelegationsInput) SetMaxResults(v int64) *GetDelegationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDelegationsInput) SetNextToken(v string) *GetDelegationsInput {
	s.NextToken = &v
	return s
}

type GetDelegationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of delegations returned by the GetDelegations API.
	Delegations []*DelegationMetadata `locationName:"delegations" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetDelegationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDelegationsOutput) GoString() string {
	return s.String()
}

// SetDelegations sets the Delegations field's value.
func (s *GetDelegationsOutput) SetDelegations(v []*DelegationMetadata) *GetDelegationsOutput {
	s.Delegations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDelegationsOutput) SetNextToken(v string) *GetDelegationsOutput {
	s.NextToken = &v
	return s
}

type GetEvidenceByEvidenceFolderInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" min:"1" type:"string" required:"true"`

	// The unique identifier for the folder in which the evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `location:"uri" locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEvidenceByEvidenceFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceByEvidenceFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvidenceByEvidenceFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvidenceByEvidenceFolderInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetEvidenceByEvidenceFolderInput) SetAssessmentId(v string) *GetEvidenceByEvidenceFolderInput {
	s.AssessmentId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *GetEvidenceByEvidenceFolderInput) SetControlSetId(v string) *GetEvidenceByEvidenceFolderInput {
	s.ControlSetId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *GetEvidenceByEvidenceFolderInput) SetEvidenceFolderId(v string) *GetEvidenceByEvidenceFolderInput {
	s.EvidenceFolderId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEvidenceByEvidenceFolderInput) SetMaxResults(v int64) *GetEvidenceByEvidenceFolderInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEvidenceByEvidenceFolderInput) SetNextToken(v string) *GetEvidenceByEvidenceFolderInput {
	s.NextToken = &v
	return s
}

type GetEvidenceByEvidenceFolderOutput struct {
	_ struct{} `type:"structure"`

	// The list of evidence returned by the GetEvidenceByEvidenceFolder API.
	Evidence []*Evidence `locationName:"evidence" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEvidenceByEvidenceFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceByEvidenceFolderOutput) GoString() string {
	return s.String()
}

// SetEvidence sets the Evidence field's value.
func (s *GetEvidenceByEvidenceFolderOutput) SetEvidence(v []*Evidence) *GetEvidenceByEvidenceFolderOutput {
	s.Evidence = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEvidenceByEvidenceFolderOutput) SetNextToken(v string) *GetEvidenceByEvidenceFolderOutput {
	s.NextToken = &v
	return s
}

type GetEvidenceFolderInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" min:"1" type:"string" required:"true"`

	// The identifier for the folder in which the evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `location:"uri" locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEvidenceFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvidenceFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvidenceFolderInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetEvidenceFolderInput) SetAssessmentId(v string) *GetEvidenceFolderInput {
	s.AssessmentId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *GetEvidenceFolderInput) SetControlSetId(v string) *GetEvidenceFolderInput {
	s.ControlSetId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *GetEvidenceFolderInput) SetEvidenceFolderId(v string) *GetEvidenceFolderInput {
	s.EvidenceFolderId = &v
	return s
}

type GetEvidenceFolderOutput struct {
	_ struct{} `type:"structure"`

	// The folder in which evidence is stored.
	EvidenceFolder *AssessmentEvidenceFolder `locationName:"evidenceFolder" type:"structure"`
}

// String returns the string representation
func (s GetEvidenceFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceFolderOutput) GoString() string {
	return s.String()
}

// SetEvidenceFolder sets the EvidenceFolder field's value.
func (s *GetEvidenceFolderOutput) SetEvidenceFolder(v *AssessmentEvidenceFolder) *GetEvidenceFolderOutput {
	s.EvidenceFolder = v
	return s
}

type GetEvidenceFoldersByAssessmentControlInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control.
	//
	// ControlId is a required field
	ControlId *string `location:"uri" locationName:"controlId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" min:"1" type:"string" required:"true"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEvidenceFoldersByAssessmentControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceFoldersByAssessmentControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvidenceFoldersByAssessmentControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvidenceFoldersByAssessmentControlInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlId"))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetEvidenceFoldersByAssessmentControlInput) SetAssessmentId(v string) *GetEvidenceFoldersByAssessmentControlInput {
	s.AssessmentId = &v
	return s
}

// SetControlId sets the ControlId field's value.
func (s *GetEvidenceFoldersByAssessmentControlInput) SetControlId(v string) *GetEvidenceFoldersByAssessmentControlInput {
	s.ControlId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *GetEvidenceFoldersByAssessmentControlInput) SetControlSetId(v string) *GetEvidenceFoldersByAssessmentControlInput {
	s.ControlSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEvidenceFoldersByAssessmentControlInput) SetMaxResults(v int64) *GetEvidenceFoldersByAssessmentControlInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEvidenceFoldersByAssessmentControlInput) SetNextToken(v string) *GetEvidenceFoldersByAssessmentControlInput {
	s.NextToken = &v
	return s
}

type GetEvidenceFoldersByAssessmentControlOutput struct {
	_ struct{} `type:"structure"`

	// The list of evidence folders returned by the GetEvidenceFoldersByAssessmentControl
	// API.
	EvidenceFolders []*AssessmentEvidenceFolder `locationName:"evidenceFolders" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEvidenceFoldersByAssessmentControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceFoldersByAssessmentControlOutput) GoString() string {
	return s.String()
}

// SetEvidenceFolders sets the EvidenceFolders field's value.
func (s *GetEvidenceFoldersByAssessmentControlOutput) SetEvidenceFolders(v []*AssessmentEvidenceFolder) *GetEvidenceFoldersByAssessmentControlOutput {
	s.EvidenceFolders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEvidenceFoldersByAssessmentControlOutput) SetNextToken(v string) *GetEvidenceFoldersByAssessmentControlOutput {
	s.NextToken = &v
	return s
}

type GetEvidenceFoldersByAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEvidenceFoldersByAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceFoldersByAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvidenceFoldersByAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvidenceFoldersByAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetEvidenceFoldersByAssessmentInput) SetAssessmentId(v string) *GetEvidenceFoldersByAssessmentInput {
	s.AssessmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEvidenceFoldersByAssessmentInput) SetMaxResults(v int64) *GetEvidenceFoldersByAssessmentInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEvidenceFoldersByAssessmentInput) SetNextToken(v string) *GetEvidenceFoldersByAssessmentInput {
	s.NextToken = &v
	return s
}

type GetEvidenceFoldersByAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The list of evidence folders returned by the GetEvidenceFoldersByAssessment
	// API.
	EvidenceFolders []*AssessmentEvidenceFolder `locationName:"evidenceFolders" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetEvidenceFoldersByAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceFoldersByAssessmentOutput) GoString() string {
	return s.String()
}

// SetEvidenceFolders sets the EvidenceFolders field's value.
func (s *GetEvidenceFoldersByAssessmentOutput) SetEvidenceFolders(v []*AssessmentEvidenceFolder) *GetEvidenceFoldersByAssessmentOutput {
	s.EvidenceFolders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEvidenceFoldersByAssessmentOutput) SetNextToken(v string) *GetEvidenceFoldersByAssessmentOutput {
	s.NextToken = &v
	return s
}

type GetEvidenceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" min:"1" type:"string" required:"true"`

	// The identifier for the folder in which the evidence is stored.
	//
	// EvidenceFolderId is a required field
	EvidenceFolderId *string `location:"uri" locationName:"evidenceFolderId" min:"36" type:"string" required:"true"`

	// The identifier for the evidence.
	//
	// EvidenceId is a required field
	EvidenceId *string `location:"uri" locationName:"evidenceId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEvidenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvidenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvidenceInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.EvidenceFolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceFolderId"))
	}
	if s.EvidenceFolderId != nil && len(*s.EvidenceFolderId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceFolderId", 36))
	}
	if s.EvidenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvidenceId"))
	}
	if s.EvidenceId != nil && len(*s.EvidenceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("EvidenceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *GetEvidenceInput) SetAssessmentId(v string) *GetEvidenceInput {
	s.AssessmentId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *GetEvidenceInput) SetControlSetId(v string) *GetEvidenceInput {
	s.ControlSetId = &v
	return s
}

// SetEvidenceFolderId sets the EvidenceFolderId field's value.
func (s *GetEvidenceInput) SetEvidenceFolderId(v string) *GetEvidenceInput {
	s.EvidenceFolderId = &v
	return s
}

// SetEvidenceId sets the EvidenceId field's value.
func (s *GetEvidenceInput) SetEvidenceId(v string) *GetEvidenceInput {
	s.EvidenceId = &v
	return s
}

type GetEvidenceOutput struct {
	_ struct{} `type:"structure"`

	// The evidence returned by the GetEvidenceResponse API.
	Evidence *Evidence `locationName:"evidence" type:"structure"`
}

// String returns the string representation
func (s GetEvidenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvidenceOutput) GoString() string {
	return s.String()
}

// SetEvidence sets the Evidence field's value.
func (s *GetEvidenceOutput) SetEvidence(v *Evidence) *GetEvidenceOutput {
	s.Evidence = v
	return s
}

type GetOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

type GetOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified administrator account.
	AdminAccountId *string `locationName:"adminAccountId" min:"12" type:"string"`

	// The identifier for the specified organization.
	OrganizationId *string `locationName:"organizationId" min:"12" type:"string"`
}

// String returns the string representation
func (s GetOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *GetOrganizationAdminAccountOutput) SetAdminAccountId(v string) *GetOrganizationAdminAccountOutput {
	s.AdminAccountId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *GetOrganizationAdminAccountOutput) SetOrganizationId(v string) *GetOrganizationAdminAccountOutput {
	s.OrganizationId = &v
	return s
}

type GetServicesInScopeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetServicesInScopeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServicesInScopeInput) GoString() string {
	return s.String()
}

type GetServicesInScopeOutput struct {
	_ struct{} `type:"structure"`

	// The metadata associated with the aAWS service.
	ServiceMetadata []*ServiceMetadata `locationName:"serviceMetadata" type:"list"`
}

// String returns the string representation
func (s GetServicesInScopeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServicesInScopeOutput) GoString() string {
	return s.String()
}

// SetServiceMetadata sets the ServiceMetadata field's value.
func (s *GetServicesInScopeOutput) SetServiceMetadata(v []*ServiceMetadata) *GetServicesInScopeOutput {
	s.ServiceMetadata = v
	return s
}

type GetSettingsInput struct {
	_ struct{} `type:"structure"`

	// The list of SettingAttribute enum values.
	//
	// Attribute is a required field
	Attribute *string `location:"uri" locationName:"attribute" type:"string" required:"true" enum:"SettingAttribute"`
}

// String returns the string representation
func (s GetSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSettingsInput"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attribute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *GetSettingsInput) SetAttribute(v string) *GetSettingsInput {
	s.Attribute = &v
	return s
}

type GetSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The settings object that holds all supported AWS Audit Manager settings.
	Settings *Settings `locationName:"settings" type:"structure"`
}

// String returns the string representation
func (s GetSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSettingsOutput) GoString() string {
	return s.String()
}

// SetSettings sets the Settings field's value.
func (s *GetSettingsOutput) SetSettings(v *Settings) *GetSettingsOutput {
	s.Settings = v
	return s
}

// An internal service error occurred during the processing of your request.
// Try again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAssessmentFrameworksInput struct {
	_ struct{} `type:"structure"`

	// The type of framework, such as standard or custom.
	//
	// FrameworkType is a required field
	FrameworkType *string `location:"querystring" locationName:"frameworkType" type:"string" required:"true" enum:"FrameworkType"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentFrameworksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentFrameworksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentFrameworksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentFrameworksInput"}
	if s.FrameworkType == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameworkType sets the FrameworkType field's value.
func (s *ListAssessmentFrameworksInput) SetFrameworkType(v string) *ListAssessmentFrameworksInput {
	s.FrameworkType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentFrameworksInput) SetMaxResults(v int64) *ListAssessmentFrameworksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentFrameworksInput) SetNextToken(v string) *ListAssessmentFrameworksInput {
	s.NextToken = &v
	return s
}

type ListAssessmentFrameworksOutput struct {
	_ struct{} `type:"structure"`

	// The list of metadata objects for the specified framework.
	FrameworkMetadataList []*AssessmentFrameworkMetadata `locationName:"frameworkMetadataList" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentFrameworksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentFrameworksOutput) GoString() string {
	return s.String()
}

// SetFrameworkMetadataList sets the FrameworkMetadataList field's value.
func (s *ListAssessmentFrameworksOutput) SetFrameworkMetadataList(v []*AssessmentFrameworkMetadata) *ListAssessmentFrameworksOutput {
	s.FrameworkMetadataList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentFrameworksOutput) SetNextToken(v string) *ListAssessmentFrameworksOutput {
	s.NextToken = &v
	return s
}

type ListAssessmentReportsInput struct {
	_ struct{} `type:"structure"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentReportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentReportsInput) SetMaxResults(v int64) *ListAssessmentReportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentReportsInput) SetNextToken(v string) *ListAssessmentReportsInput {
	s.NextToken = &v
	return s
}

type ListAssessmentReportsOutput struct {
	_ struct{} `type:"structure"`

	// The list of assessment reports returned by the ListAssessmentReports API.
	AssessmentReports []*AssessmentReportMetadata `locationName:"assessmentReports" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentReportsOutput) GoString() string {
	return s.String()
}

// SetAssessmentReports sets the AssessmentReports field's value.
func (s *ListAssessmentReportsOutput) SetAssessmentReports(v []*AssessmentReportMetadata) *ListAssessmentReportsOutput {
	s.AssessmentReports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentReportsOutput) SetNextToken(v string) *ListAssessmentReportsOutput {
	s.NextToken = &v
	return s
}

type ListAssessmentsInput struct {
	_ struct{} `type:"structure"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssessmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssessmentsInput) SetMaxResults(v int64) *ListAssessmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentsInput) SetNextToken(v string) *ListAssessmentsInput {
	s.NextToken = &v
	return s
}

type ListAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// The metadata associated with the assessment.
	AssessmentMetadata []*AssessmentMetadataItem `locationName:"assessmentMetadata" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentsOutput) GoString() string {
	return s.String()
}

// SetAssessmentMetadata sets the AssessmentMetadata field's value.
func (s *ListAssessmentsOutput) SetAssessmentMetadata(v []*AssessmentMetadataItem) *ListAssessmentsOutput {
	s.AssessmentMetadata = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssessmentsOutput) SetNextToken(v string) *ListAssessmentsOutput {
	s.NextToken = &v
	return s
}

type ListControlsInput struct {
	_ struct{} `type:"structure"`

	// The type of control, such as standard or custom.
	//
	// ControlType is a required field
	ControlType *string `location:"querystring" locationName:"controlType" type:"string" required:"true" enum:"ControlType"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListControlsInput"}
	if s.ControlType == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlType sets the ControlType field's value.
func (s *ListControlsInput) SetControlType(v string) *ListControlsInput {
	s.ControlType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListControlsInput) SetMaxResults(v int64) *ListControlsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListControlsInput) SetNextToken(v string) *ListControlsInput {
	s.NextToken = &v
	return s
}

type ListControlsOutput struct {
	_ struct{} `type:"structure"`

	// The list of control metadata objects returned by the ListControls API.
	ControlMetadataList []*ControlMetadata `locationName:"controlMetadataList" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListControlsOutput) GoString() string {
	return s.String()
}

// SetControlMetadataList sets the ControlMetadataList field's value.
func (s *ListControlsOutput) SetControlMetadataList(v []*ControlMetadata) *ListControlsOutput {
	s.ControlMetadataList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListControlsOutput) SetNextToken(v string) *ListControlsOutput {
	s.NextToken = &v
	return s
}

type ListKeywordsForDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The control mapping data source to which the keywords apply.
	//
	// Source is a required field
	Source *string `location:"querystring" locationName:"source" type:"string" required:"true" enum:"SourceType"`
}

// String returns the string representation
func (s ListKeywordsForDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeywordsForDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeywordsForDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeywordsForDataSourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeywordsForDataSourceInput) SetMaxResults(v int64) *ListKeywordsForDataSourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeywordsForDataSourceInput) SetNextToken(v string) *ListKeywordsForDataSourceInput {
	s.NextToken = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ListKeywordsForDataSourceInput) SetSource(v string) *ListKeywordsForDataSourceInput {
	s.Source = &v
	return s
}

type ListKeywordsForDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of keywords for the specified event mapping source.
	Keywords []*string `locationName:"keywords" type:"list"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeywordsForDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeywordsForDataSourceOutput) GoString() string {
	return s.String()
}

// SetKeywords sets the Keywords field's value.
func (s *ListKeywordsForDataSourceOutput) SetKeywords(v []*string) *ListKeywordsForDataSourceOutput {
	s.Keywords = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeywordsForDataSourceOutput) SetNextToken(v string) *ListKeywordsForDataSourceOutput {
	s.NextToken = &v
	return s
}

type ListNotificationsInput struct {
	_ struct{} `type:"structure"`

	// Represents the maximum number of results per page, or per API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNotificationsInput) SetMaxResults(v int64) *ListNotificationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationsInput) SetNextToken(v string) *ListNotificationsInput {
	s.NextToken = &v
	return s
}

type ListNotificationsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used to fetch the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The returned list of notifications.
	Notifications []*Notification `locationName:"notifications" type:"list"`
}

// String returns the string representation
func (s ListNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotificationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationsOutput) SetNextToken(v string) *ListNotificationsOutput {
	s.NextToken = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *ListNotificationsOutput) SetNotifications(v []*Notification) *ListNotificationsOutput {
	s.Notifications = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags returned by the ListTagsForResource API.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Evidence that is uploaded to AWS Audit Manager manually.
type ManualEvidence struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 URL that points to a manual evidence object.
	S3ResourcePath *string `locationName:"s3ResourcePath" min:"1" type:"string"`
}

// String returns the string representation
func (s ManualEvidence) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManualEvidence) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManualEvidence) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManualEvidence"}
	if s.S3ResourcePath != nil && len(*s.S3ResourcePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ResourcePath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3ResourcePath sets the S3ResourcePath field's value.
func (s *ManualEvidence) SetS3ResourcePath(v string) *ManualEvidence {
	s.S3ResourcePath = &v
	return s
}

// The notification used to inform a user of an update in AWS Audit Manager.
// For example, this includes the notification that is sent when a control set
// is delegated for review.
type Notification struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	AssessmentId *string `locationName:"assessmentId" min:"36" type:"string"`

	// The name of the related assessment.
	AssessmentName *string `locationName:"assessmentName" min:"1" type:"string"`

	// The identifier for the specified control set.
	ControlSetId *string `locationName:"controlSetId" min:"1" type:"string"`

	// Specifies the name of the control set that the notification is about.
	ControlSetName *string `locationName:"controlSetName" min:"1" type:"string"`

	// The description of the notification.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time when the notification was sent.
	EventTime *time.Time `locationName:"eventTime" type:"timestamp"`

	// The unique identifier for the notification.
	Id *string `locationName:"id" min:"47" type:"string"`

	// The sender of the notification.
	Source *string `locationName:"source" min:"1" type:"string"`
}

// String returns the string representation
func (s Notification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Notification) GoString() string {
	return s.String()
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *Notification) SetAssessmentId(v string) *Notification {
	s.AssessmentId = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *Notification) SetAssessmentName(v string) *Notification {
	s.AssessmentName = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *Notification) SetControlSetId(v string) *Notification {
	s.ControlSetId = &v
	return s
}

// SetControlSetName sets the ControlSetName field's value.
func (s *Notification) SetControlSetName(v string) *Notification {
	s.ControlSetName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Notification) SetDescription(v string) *Notification {
	s.Description = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Notification) SetEventTime(v time.Time) *Notification {
	s.EventTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Notification) SetId(v string) *Notification {
	s.Id = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Notification) SetSource(v string) *Notification {
	s.Source = &v
	return s
}

type RegisterAccountInput struct {
	_ struct{} `type:"structure"`

	// The delegated administrator account for AWS Audit Manager.
	DelegatedAdminAccount *string `locationName:"delegatedAdminAccount" min:"12" type:"string"`

	// The AWS KMS key details.
	KmsKey *string `locationName:"kmsKey" min:"7" type:"string"`
}

// String returns the string representation
func (s RegisterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterAccountInput"}
	if s.DelegatedAdminAccount != nil && len(*s.DelegatedAdminAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DelegatedAdminAccount", 12))
	}
	if s.KmsKey != nil && len(*s.KmsKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKey", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelegatedAdminAccount sets the DelegatedAdminAccount field's value.
func (s *RegisterAccountInput) SetDelegatedAdminAccount(v string) *RegisterAccountInput {
	s.DelegatedAdminAccount = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *RegisterAccountInput) SetKmsKey(v string) *RegisterAccountInput {
	s.KmsKey = &v
	return s
}

type RegisterAccountOutput struct {
	_ struct{} `type:"structure"`

	// The status of the account registration request.
	Status *string `locationName:"status" type:"string" enum:"AccountStatus"`
}

// String returns the string representation
func (s RegisterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterAccountOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *RegisterAccountOutput) SetStatus(v string) *RegisterAccountOutput {
	s.Status = &v
	return s
}

type RegisterOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified delegated administrator account.
	//
	// AdminAccountId is a required field
	AdminAccountId *string `locationName:"adminAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}
	if s.AdminAccountId != nil && len(*s.AdminAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AdminAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *RegisterOrganizationAdminAccountInput) SetAdminAccountId(v string) *RegisterOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type RegisterOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified delegated administrator account.
	AdminAccountId *string `locationName:"adminAccountId" min:"12" type:"string"`

	// The identifier for the specified AWS organization.
	OrganizationId *string `locationName:"organizationId" min:"12" type:"string"`
}

// String returns the string representation
func (s RegisterOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *RegisterOrganizationAdminAccountOutput) SetAdminAccountId(v string) *RegisterOrganizationAdminAccountOutput {
	s.AdminAccountId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *RegisterOrganizationAdminAccountOutput) SetOrganizationId(v string) *RegisterOrganizationAdminAccountOutput {
	s.OrganizationId = &v
	return s
}

// A system asset that is evaluated in an AWS Audit Manager assessment.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the specified resource.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The value of the specified resource.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Resource) SetArn(v string) *Resource {
	s.Arn = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Resource) SetValue(v string) *Resource {
	s.Value = &v
	return s
}

// The resource specified in the request cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The unique identifier for the specified resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource affected by the error.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The wrapper that contains the AWS Audit Manager role information of the current
// user, such as the role type and IAM Amazon Resource Name (ARN).
type Role struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The type of customer persona.
	//
	// In CreateAssessment, roleType can only be PROCESS_OWNER.
	//
	// In UpdateSettings, roleType can only be PROCESS_OWNER.
	//
	// In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
	RoleType *string `locationName:"roleType" type:"string" enum:"RoleType"`
}

// String returns the string representation
func (s Role) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Role) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Role) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Role"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *Role) SetRoleArn(v string) *Role {
	s.RoleArn = &v
	return s
}

// SetRoleType sets the RoleType field's value.
func (s *Role) SetRoleType(v string) *Role {
	s.RoleType = &v
	return s
}

// The wrapper that contains the AWS accounts and AWS services in scope for
// the assessment.
type Scope struct {
	_ struct{} `type:"structure"`

	// The AWS accounts included in the scope of the assessment.
	AwsAccounts []*AWSAccount `locationName:"awsAccounts" type:"list"`

	// The AWS services included in the scope of the assessment.
	AwsServices []*AWSService `locationName:"awsServices" type:"list"`
}

// String returns the string representation
func (s Scope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scope) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scope) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scope"}
	if s.AwsAccounts != nil {
		for i, v := range s.AwsAccounts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AwsAccounts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AwsServices != nil {
		for i, v := range s.AwsServices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AwsServices", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccounts sets the AwsAccounts field's value.
func (s *Scope) SetAwsAccounts(v []*AWSAccount) *Scope {
	s.AwsAccounts = v
	return s
}

// SetAwsServices sets the AwsServices field's value.
func (s *Scope) SetAwsServices(v []*AWSService) *Scope {
	s.AwsServices = v
	return s
}

// The metadata associated with the specified AWS service.
type ServiceMetadata struct {
	_ struct{} `type:"structure"`

	// The category in which the AWS service belongs, such as compute, storage,
	// database, and so on.
	Category *string `locationName:"category" min:"1" type:"string"`

	// The description of the specified AWS service.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The display name of the AWS service.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The name of the AWS service.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s ServiceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceMetadata) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *ServiceMetadata) SetCategory(v string) *ServiceMetadata {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceMetadata) SetDescription(v string) *ServiceMetadata {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ServiceMetadata) SetDisplayName(v string) *ServiceMetadata {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceMetadata) SetName(v string) *ServiceMetadata {
	s.Name = &v
	return s
}

// The settings object that holds all supported AWS Audit Manager settings.
type Settings struct {
	_ struct{} `type:"structure"`

	// The default storage destination for assessment reports.
	DefaultAssessmentReportsDestination *AssessmentReportsDestination `locationName:"defaultAssessmentReportsDestination" type:"structure"`

	// The designated default audit owners.
	DefaultProcessOwners []*Role `locationName:"defaultProcessOwners" type:"list"`

	// Specifies whether AWS Organizations is enabled.
	IsAwsOrgEnabled *bool `locationName:"isAwsOrgEnabled" type:"boolean"`

	// The AWS KMS key details.
	KmsKey *string `locationName:"kmsKey" min:"7" type:"string"`

	// The designated Amazon Simple Notification Service (Amazon SNS) topic.
	SnsTopic *string `locationName:"snsTopic" min:"1" type:"string"`
}

// String returns the string representation
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Settings) GoString() string {
	return s.String()
}

// SetDefaultAssessmentReportsDestination sets the DefaultAssessmentReportsDestination field's value.
func (s *Settings) SetDefaultAssessmentReportsDestination(v *AssessmentReportsDestination) *Settings {
	s.DefaultAssessmentReportsDestination = v
	return s
}

// SetDefaultProcessOwners sets the DefaultProcessOwners field's value.
func (s *Settings) SetDefaultProcessOwners(v []*Role) *Settings {
	s.DefaultProcessOwners = v
	return s
}

// SetIsAwsOrgEnabled sets the IsAwsOrgEnabled field's value.
func (s *Settings) SetIsAwsOrgEnabled(v bool) *Settings {
	s.IsAwsOrgEnabled = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *Settings) SetKmsKey(v string) *Settings {
	s.KmsKey = &v
	return s
}

// SetSnsTopic sets the SnsTopic field's value.
func (s *Settings) SetSnsTopic(v string) *Settings {
	s.SnsTopic = &v
	return s
}

// The keyword to search for in AWS CloudTrail logs, AWS Config rules, AWS Security
// Hub checks, and AWS API names.
type SourceKeyword struct {
	_ struct{} `type:"structure"`

	// The method of input for the specified keyword.
	KeywordInputType *string `locationName:"keywordInputType" type:"string" enum:"KeywordInputType"`

	// The value of the keyword used to search AWS CloudTrail logs, AWS Config rules,
	// AWS Security Hub checks, and AWS API names when mapping a control data source.
	KeywordValue *string `locationName:"keywordValue" min:"1" type:"string"`
}

// String returns the string representation
func (s SourceKeyword) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceKeyword) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceKeyword) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceKeyword"}
	if s.KeywordValue != nil && len(*s.KeywordValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeywordValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeywordInputType sets the KeywordInputType field's value.
func (s *SourceKeyword) SetKeywordInputType(v string) *SourceKeyword {
	s.KeywordInputType = &v
	return s
}

// SetKeywordValue sets the KeywordValue field's value.
func (s *SourceKeyword) SetKeywordValue(v string) *SourceKeyword {
	s.KeywordValue = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tags to be associated with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A uniform resource locator, used as a unique identifier to locate a resource
// on the internet.
type URL struct {
	_ struct{} `type:"structure"`

	// The name or word used as a hyperlink to the URL.
	HyperlinkName *string `locationName:"hyperlinkName" min:"1" type:"string"`

	// The unique identifier for the internet resource.
	Link *string `locationName:"link" min:"1" type:"string"`
}

// String returns the string representation
func (s URL) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s URL) GoString() string {
	return s.String()
}

// SetHyperlinkName sets the HyperlinkName field's value.
func (s *URL) SetHyperlinkName(v string) *URL {
	s.HyperlinkName = &v
	return s
}

// SetLink sets the Link field's value.
func (s *URL) SetLink(v string) *URL {
	s.Link = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The name or key of the tag.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAssessmentControlInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The comment body text for the specified control.
	CommentBody *string `locationName:"commentBody" type:"string"`

	// The identifier for the specified control.
	//
	// ControlId is a required field
	ControlId *string `location:"uri" locationName:"controlId" min:"36" type:"string" required:"true"`

	// The identifier for the specified control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" min:"1" type:"string" required:"true"`

	// The status of the specified control.
	ControlStatus *string `locationName:"controlStatus" type:"string" enum:"ControlStatus"`
}

// String returns the string representation
func (s UpdateAssessmentControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentControlInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.ControlId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlId"))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *UpdateAssessmentControlInput) SetAssessmentId(v string) *UpdateAssessmentControlInput {
	s.AssessmentId = &v
	return s
}

// SetCommentBody sets the CommentBody field's value.
func (s *UpdateAssessmentControlInput) SetCommentBody(v string) *UpdateAssessmentControlInput {
	s.CommentBody = &v
	return s
}

// SetControlId sets the ControlId field's value.
func (s *UpdateAssessmentControlInput) SetControlId(v string) *UpdateAssessmentControlInput {
	s.ControlId = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *UpdateAssessmentControlInput) SetControlSetId(v string) *UpdateAssessmentControlInput {
	s.ControlSetId = &v
	return s
}

// SetControlStatus sets the ControlStatus field's value.
func (s *UpdateAssessmentControlInput) SetControlStatus(v string) *UpdateAssessmentControlInput {
	s.ControlStatus = &v
	return s
}

type UpdateAssessmentControlOutput struct {
	_ struct{} `type:"structure"`

	// The name of the updated control set returned by the UpdateAssessmentControl
	// API.
	Control *AssessmentControl `locationName:"control" type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentControlOutput) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *UpdateAssessmentControlOutput) SetControl(v *AssessmentControl) *UpdateAssessmentControlOutput {
	s.Control = v
	return s
}

type UpdateAssessmentControlSetStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The comment related to the status update.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The identifier for the specified control set.
	//
	// ControlSetId is a required field
	ControlSetId *string `location:"uri" locationName:"controlSetId" type:"string" required:"true"`

	// The status of the control set that is being updated.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ControlSetStatus"`
}

// String returns the string representation
func (s UpdateAssessmentControlSetStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentControlSetStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentControlSetStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentControlSetStatusInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.ControlSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSetId"))
	}
	if s.ControlSetId != nil && len(*s.ControlSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlSetId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *UpdateAssessmentControlSetStatusInput) SetAssessmentId(v string) *UpdateAssessmentControlSetStatusInput {
	s.AssessmentId = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *UpdateAssessmentControlSetStatusInput) SetComment(v string) *UpdateAssessmentControlSetStatusInput {
	s.Comment = &v
	return s
}

// SetControlSetId sets the ControlSetId field's value.
func (s *UpdateAssessmentControlSetStatusInput) SetControlSetId(v string) *UpdateAssessmentControlSetStatusInput {
	s.ControlSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateAssessmentControlSetStatusInput) SetStatus(v string) *UpdateAssessmentControlSetStatusInput {
	s.Status = &v
	return s
}

type UpdateAssessmentControlSetStatusOutput struct {
	_ struct{} `type:"structure"`

	// The name of the updated control set returned by the UpdateAssessmentControlSetStatus
	// API.
	ControlSet *AssessmentControlSet `locationName:"controlSet" type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentControlSetStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentControlSetStatusOutput) GoString() string {
	return s.String()
}

// SetControlSet sets the ControlSet field's value.
func (s *UpdateAssessmentControlSetStatusOutput) SetControlSet(v *AssessmentControlSet) *UpdateAssessmentControlSetStatusOutput {
	s.ControlSet = v
	return s
}

// A controlSet entity that represents a collection of controls in AWS Audit
// Manager. This does not contain the control set ID.
type UpdateAssessmentFrameworkControlSet struct {
	_ struct{} `type:"structure"`

	// The list of controls contained within the control set.
	Controls []*CreateAssessmentFrameworkControl `locationName:"controls" min:"1" type:"list"`

	// The unique identifier for the control set.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the control set.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAssessmentFrameworkControlSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentFrameworkControlSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentFrameworkControlSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentFrameworkControlSet"}
	if s.Controls != nil && len(s.Controls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Controls", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Controls != nil {
		for i, v := range s.Controls {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Controls", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControls sets the Controls field's value.
func (s *UpdateAssessmentFrameworkControlSet) SetControls(v []*CreateAssessmentFrameworkControl) *UpdateAssessmentFrameworkControlSet {
	s.Controls = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateAssessmentFrameworkControlSet) SetId(v string) *UpdateAssessmentFrameworkControlSet {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAssessmentFrameworkControlSet) SetName(v string) *UpdateAssessmentFrameworkControlSet {
	s.Name = &v
	return s
}

type UpdateAssessmentFrameworkInput struct {
	_ struct{} `type:"structure"`

	// The compliance type that the new custom framework supports, such as CIS or
	// HIPAA.
	ComplianceType *string `locationName:"complianceType" type:"string"`

	// The control sets associated with the framework.
	//
	// ControlSets is a required field
	ControlSets []*UpdateAssessmentFrameworkControlSet `locationName:"controlSets" type:"list" required:"true"`

	// The description of the framework that is to be updated.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The identifier for the specified framework.
	//
	// FrameworkId is a required field
	FrameworkId *string `location:"uri" locationName:"frameworkId" min:"36" type:"string" required:"true"`

	// The name of the framework to be updated.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAssessmentFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentFrameworkInput"}
	if s.ControlSets == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlSets"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FrameworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkId"))
	}
	if s.FrameworkId != nil && len(*s.FrameworkId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ControlSets != nil {
		for i, v := range s.ControlSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ControlSets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceType sets the ComplianceType field's value.
func (s *UpdateAssessmentFrameworkInput) SetComplianceType(v string) *UpdateAssessmentFrameworkInput {
	s.ComplianceType = &v
	return s
}

// SetControlSets sets the ControlSets field's value.
func (s *UpdateAssessmentFrameworkInput) SetControlSets(v []*UpdateAssessmentFrameworkControlSet) *UpdateAssessmentFrameworkInput {
	s.ControlSets = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAssessmentFrameworkInput) SetDescription(v string) *UpdateAssessmentFrameworkInput {
	s.Description = &v
	return s
}

// SetFrameworkId sets the FrameworkId field's value.
func (s *UpdateAssessmentFrameworkInput) SetFrameworkId(v string) *UpdateAssessmentFrameworkInput {
	s.FrameworkId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAssessmentFrameworkInput) SetName(v string) *UpdateAssessmentFrameworkInput {
	s.Name = &v
	return s
}

type UpdateAssessmentFrameworkOutput struct {
	_ struct{} `type:"structure"`

	// The name of the specified framework.
	Framework *Framework `locationName:"framework" type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentFrameworkOutput) GoString() string {
	return s.String()
}

// SetFramework sets the Framework field's value.
func (s *UpdateAssessmentFrameworkOutput) SetFramework(v *Framework) *UpdateAssessmentFrameworkOutput {
	s.Framework = v
	return s
}

type UpdateAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The description of the specified assessment.
	AssessmentDescription *string `locationName:"assessmentDescription" type:"string"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The name of the specified assessment to be updated.
	AssessmentName *string `locationName:"assessmentName" min:"1" type:"string"`

	// The assessment report storage destination for the specified assessment that
	// is being updated.
	AssessmentReportsDestination *AssessmentReportsDestination `locationName:"assessmentReportsDestination" type:"structure"`

	// The list of roles for the specified assessment.
	Roles []*Role `locationName:"roles" type:"list"`

	// The scope of the specified assessment.
	//
	// Scope is a required field
	Scope *Scope `locationName:"scope" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.AssessmentName != nil && len(*s.AssessmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentName", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.AssessmentReportsDestination != nil {
		if err := s.AssessmentReportsDestination.Validate(); err != nil {
			invalidParams.AddNested("AssessmentReportsDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.Roles != nil {
		for i, v := range s.Roles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Roles", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Scope != nil {
		if err := s.Scope.Validate(); err != nil {
			invalidParams.AddNested("Scope", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentDescription sets the AssessmentDescription field's value.
func (s *UpdateAssessmentInput) SetAssessmentDescription(v string) *UpdateAssessmentInput {
	s.AssessmentDescription = &v
	return s
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *UpdateAssessmentInput) SetAssessmentId(v string) *UpdateAssessmentInput {
	s.AssessmentId = &v
	return s
}

// SetAssessmentName sets the AssessmentName field's value.
func (s *UpdateAssessmentInput) SetAssessmentName(v string) *UpdateAssessmentInput {
	s.AssessmentName = &v
	return s
}

// SetAssessmentReportsDestination sets the AssessmentReportsDestination field's value.
func (s *UpdateAssessmentInput) SetAssessmentReportsDestination(v *AssessmentReportsDestination) *UpdateAssessmentInput {
	s.AssessmentReportsDestination = v
	return s
}

// SetRoles sets the Roles field's value.
func (s *UpdateAssessmentInput) SetRoles(v []*Role) *UpdateAssessmentInput {
	s.Roles = v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateAssessmentInput) SetScope(v *Scope) *UpdateAssessmentInput {
	s.Scope = v
	return s
}

type UpdateAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The response object (name of the updated assessment) for the UpdateAssessmentRequest
	// API.
	Assessment *Assessment `locationName:"assessment" type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentOutput) GoString() string {
	return s.String()
}

// SetAssessment sets the Assessment field's value.
func (s *UpdateAssessmentOutput) SetAssessment(v *Assessment) *UpdateAssessmentOutput {
	s.Assessment = v
	return s
}

type UpdateAssessmentStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the specified assessment.
	//
	// AssessmentId is a required field
	AssessmentId *string `location:"uri" locationName:"assessmentId" min:"36" type:"string" required:"true"`

	// The current status of the specified assessment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AssessmentStatus"`
}

// String returns the string representation
func (s UpdateAssessmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssessmentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssessmentStatusInput"}
	if s.AssessmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentId"))
	}
	if s.AssessmentId != nil && len(*s.AssessmentId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssessmentId", 36))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentId sets the AssessmentId field's value.
func (s *UpdateAssessmentStatusInput) SetAssessmentId(v string) *UpdateAssessmentStatusInput {
	s.AssessmentId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateAssessmentStatusInput) SetStatus(v string) *UpdateAssessmentStatusInput {
	s.Status = &v
	return s
}

type UpdateAssessmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The name of the updated assessment returned by the UpdateAssessmentStatus
	// API.
	Assessment *Assessment `locationName:"assessment" type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentStatusOutput) GoString() string {
	return s.String()
}

// SetAssessment sets the Assessment field's value.
func (s *UpdateAssessmentStatusOutput) SetAssessment(v *Assessment) *UpdateAssessmentStatusOutput {
	s.Assessment = v
	return s
}

type UpdateControlInput struct {
	_ struct{} `type:"structure"`

	// The recommended actions to carry out if the control is not fulfilled.
	ActionPlanInstructions *string `locationName:"actionPlanInstructions" type:"string"`

	// The title of the action plan for remediating the control.
	ActionPlanTitle *string `locationName:"actionPlanTitle" type:"string"`

	// The identifier for the specified control.
	//
	// ControlId is a required field
	ControlId *string `location:"uri" locationName:"controlId" min:"36" type:"string" required:"true"`

	// The data mapping sources for the specified control.
	//
	// ControlMappingSources is a required field
	ControlMappingSources []*ControlMappingSource `locationName:"controlMappingSources" min:"1" type:"list" required:"true"`

	// The optional description of the control.
	Description *string `locationName:"description" type:"string"`

	// The name of the control to be updated.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The steps that to follow to determine if the control has been satisfied.
	TestingInformation *string `locationName:"testingInformation" type:"string"`
}

// String returns the string representation
func (s UpdateControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateControlInput"}
	if s.ControlId == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlId"))
	}
	if s.ControlId != nil && len(*s.ControlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ControlId", 36))
	}
	if s.ControlMappingSources == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlMappingSources"))
	}
	if s.ControlMappingSources != nil && len(s.ControlMappingSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlMappingSources", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ControlMappingSources != nil {
		for i, v := range s.ControlMappingSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ControlMappingSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionPlanInstructions sets the ActionPlanInstructions field's value.
func (s *UpdateControlInput) SetActionPlanInstructions(v string) *UpdateControlInput {
	s.ActionPlanInstructions = &v
	return s
}

// SetActionPlanTitle sets the ActionPlanTitle field's value.
func (s *UpdateControlInput) SetActionPlanTitle(v string) *UpdateControlInput {
	s.ActionPlanTitle = &v
	return s
}

// SetControlId sets the ControlId field's value.
func (s *UpdateControlInput) SetControlId(v string) *UpdateControlInput {
	s.ControlId = &v
	return s
}

// SetControlMappingSources sets the ControlMappingSources field's value.
func (s *UpdateControlInput) SetControlMappingSources(v []*ControlMappingSource) *UpdateControlInput {
	s.ControlMappingSources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateControlInput) SetDescription(v string) *UpdateControlInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateControlInput) SetName(v string) *UpdateControlInput {
	s.Name = &v
	return s
}

// SetTestingInformation sets the TestingInformation field's value.
func (s *UpdateControlInput) SetTestingInformation(v string) *UpdateControlInput {
	s.TestingInformation = &v
	return s
}

type UpdateControlOutput struct {
	_ struct{} `type:"structure"`

	// The name of the updated control set returned by the UpdateControl API.
	Control *Control `locationName:"control" type:"structure"`
}

// String returns the string representation
func (s UpdateControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateControlOutput) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *UpdateControlOutput) SetControl(v *Control) *UpdateControlOutput {
	s.Control = v
	return s
}

type UpdateSettingsInput struct {
	_ struct{} `type:"structure"`

	// The default storage destination for assessment reports.
	DefaultAssessmentReportsDestination *AssessmentReportsDestination `locationName:"defaultAssessmentReportsDestination" type:"structure"`

	// A list of the default audit owners.
	DefaultProcessOwners []*Role `locationName:"defaultProcessOwners" type:"list"`

	// The AWS KMS key details.
	KmsKey *string `locationName:"kmsKey" min:"7" type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) topic to which AWS Audit
	// Manager sends notifications.
	SnsTopic *string `locationName:"snsTopic" min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSettingsInput"}
	if s.KmsKey != nil && len(*s.KmsKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKey", 7))
	}
	if s.SnsTopic != nil && len(*s.SnsTopic) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SnsTopic", 20))
	}
	if s.DefaultAssessmentReportsDestination != nil {
		if err := s.DefaultAssessmentReportsDestination.Validate(); err != nil {
			invalidParams.AddNested("DefaultAssessmentReportsDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.DefaultProcessOwners != nil {
		for i, v := range s.DefaultProcessOwners {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultProcessOwners", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultAssessmentReportsDestination sets the DefaultAssessmentReportsDestination field's value.
func (s *UpdateSettingsInput) SetDefaultAssessmentReportsDestination(v *AssessmentReportsDestination) *UpdateSettingsInput {
	s.DefaultAssessmentReportsDestination = v
	return s
}

// SetDefaultProcessOwners sets the DefaultProcessOwners field's value.
func (s *UpdateSettingsInput) SetDefaultProcessOwners(v []*Role) *UpdateSettingsInput {
	s.DefaultProcessOwners = v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *UpdateSettingsInput) SetKmsKey(v string) *UpdateSettingsInput {
	s.KmsKey = &v
	return s
}

// SetSnsTopic sets the SnsTopic field's value.
func (s *UpdateSettingsInput) SetSnsTopic(v string) *UpdateSettingsInput {
	s.SnsTopic = &v
	return s
}

type UpdateSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The current list of settings.
	Settings *Settings `locationName:"settings" type:"structure"`
}

// String returns the string representation
func (s UpdateSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSettingsOutput) GoString() string {
	return s.String()
}

// SetSettings sets the Settings field's value.
func (s *UpdateSettingsOutput) SetSettings(v *Settings) *UpdateSettingsOutput {
	s.Settings = v
	return s
}

type ValidateAssessmentReportIntegrityInput struct {
	_ struct{} `type:"structure"`

	// The relative path of the specified Amazon S3 bucket in which the assessment
	// report is stored.
	//
	// S3RelativePath is a required field
	S3RelativePath *string `locationName:"s3RelativePath" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidateAssessmentReportIntegrityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateAssessmentReportIntegrityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateAssessmentReportIntegrityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateAssessmentReportIntegrityInput"}
	if s.S3RelativePath == nil {
		invalidParams.Add(request.NewErrParamRequired("S3RelativePath"))
	}
	if s.S3RelativePath != nil && len(*s.S3RelativePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3RelativePath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3RelativePath sets the S3RelativePath field's value.
func (s *ValidateAssessmentReportIntegrityInput) SetS3RelativePath(v string) *ValidateAssessmentReportIntegrityInput {
	s.S3RelativePath = &v
	return s
}

type ValidateAssessmentReportIntegrityOutput struct {
	_ struct{} `type:"structure"`

	// The signature algorithm used to code sign the assessment report file.
	SignatureAlgorithm *string `locationName:"signatureAlgorithm" type:"string"`

	// The date and time signature that specifies when the assessment report was
	// created.
	SignatureDateTime *string `locationName:"signatureDateTime" type:"string"`

	// The unique identifier for the validation signature key.
	SignatureKeyId *string `locationName:"signatureKeyId" type:"string"`

	// Specifies whether the signature key is valid.
	SignatureValid *bool `locationName:"signatureValid" type:"boolean"`

	// Represents any errors that occurred when validating the assessment report.
	ValidationErrors []*string `locationName:"validationErrors" type:"list"`
}

// String returns the string representation
func (s ValidateAssessmentReportIntegrityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateAssessmentReportIntegrityOutput) GoString() string {
	return s.String()
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *ValidateAssessmentReportIntegrityOutput) SetSignatureAlgorithm(v string) *ValidateAssessmentReportIntegrityOutput {
	s.SignatureAlgorithm = &v
	return s
}

// SetSignatureDateTime sets the SignatureDateTime field's value.
func (s *ValidateAssessmentReportIntegrityOutput) SetSignatureDateTime(v string) *ValidateAssessmentReportIntegrityOutput {
	s.SignatureDateTime = &v
	return s
}

// SetSignatureKeyId sets the SignatureKeyId field's value.
func (s *ValidateAssessmentReportIntegrityOutput) SetSignatureKeyId(v string) *ValidateAssessmentReportIntegrityOutput {
	s.SignatureKeyId = &v
	return s
}

// SetSignatureValid sets the SignatureValid field's value.
func (s *ValidateAssessmentReportIntegrityOutput) SetSignatureValid(v bool) *ValidateAssessmentReportIntegrityOutput {
	s.SignatureValid = &v
	return s
}

// SetValidationErrors sets the ValidationErrors field's value.
func (s *ValidateAssessmentReportIntegrityOutput) SetValidationErrors(v []*string) *ValidateAssessmentReportIntegrityOutput {
	s.ValidationErrors = v
	return s
}

// The request has invalid or missing parameters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error, if applicable.
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason the request failed validation.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates that the request has invalid or missing parameters for the specified
// field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The body of the error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation error.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AccountStatusActive is a AccountStatus enum value
	AccountStatusActive = "ACTIVE"

	// AccountStatusInactive is a AccountStatus enum value
	AccountStatusInactive = "INACTIVE"

	// AccountStatusPendingActivation is a AccountStatus enum value
	AccountStatusPendingActivation = "PENDING_ACTIVATION"
)

// AccountStatus_Values returns all elements of the AccountStatus enum
func AccountStatus_Values() []string {
	return []string{
		AccountStatusActive,
		AccountStatusInactive,
		AccountStatusPendingActivation,
	}
}

const (
	// ActionEnumCreate is a ActionEnum enum value
	ActionEnumCreate = "CREATE"

	// ActionEnumUpdateMetadata is a ActionEnum enum value
	ActionEnumUpdateMetadata = "UPDATE_METADATA"

	// ActionEnumActive is a ActionEnum enum value
	ActionEnumActive = "ACTIVE"

	// ActionEnumInactive is a ActionEnum enum value
	ActionEnumInactive = "INACTIVE"

	// ActionEnumDelete is a ActionEnum enum value
	ActionEnumDelete = "DELETE"

	// ActionEnumUnderReview is a ActionEnum enum value
	ActionEnumUnderReview = "UNDER_REVIEW"

	// ActionEnumReviewed is a ActionEnum enum value
	ActionEnumReviewed = "REVIEWED"

	// ActionEnumImportEvidence is a ActionEnum enum value
	ActionEnumImportEvidence = "IMPORT_EVIDENCE"
)

// ActionEnum_Values returns all elements of the ActionEnum enum
func ActionEnum_Values() []string {
	return []string{
		ActionEnumCreate,
		ActionEnumUpdateMetadata,
		ActionEnumActive,
		ActionEnumInactive,
		ActionEnumDelete,
		ActionEnumUnderReview,
		ActionEnumReviewed,
		ActionEnumImportEvidence,
	}
}

const (
	// AssessmentReportDestinationTypeS3 is a AssessmentReportDestinationType enum value
	AssessmentReportDestinationTypeS3 = "S3"
)

// AssessmentReportDestinationType_Values returns all elements of the AssessmentReportDestinationType enum
func AssessmentReportDestinationType_Values() []string {
	return []string{
		AssessmentReportDestinationTypeS3,
	}
}

const (
	// AssessmentReportStatusComplete is a AssessmentReportStatus enum value
	AssessmentReportStatusComplete = "COMPLETE"

	// AssessmentReportStatusInProgress is a AssessmentReportStatus enum value
	AssessmentReportStatusInProgress = "IN_PROGRESS"

	// AssessmentReportStatusFailed is a AssessmentReportStatus enum value
	AssessmentReportStatusFailed = "FAILED"
)

// AssessmentReportStatus_Values returns all elements of the AssessmentReportStatus enum
func AssessmentReportStatus_Values() []string {
	return []string{
		AssessmentReportStatusComplete,
		AssessmentReportStatusInProgress,
		AssessmentReportStatusFailed,
	}
}

const (
	// AssessmentStatusActive is a AssessmentStatus enum value
	AssessmentStatusActive = "ACTIVE"

	// AssessmentStatusInactive is a AssessmentStatus enum value
	AssessmentStatusInactive = "INACTIVE"
)

// AssessmentStatus_Values returns all elements of the AssessmentStatus enum
func AssessmentStatus_Values() []string {
	return []string{
		AssessmentStatusActive,
		AssessmentStatusInactive,
	}
}

const (
	// ControlResponseManual is a ControlResponse enum value
	ControlResponseManual = "MANUAL"

	// ControlResponseAutomate is a ControlResponse enum value
	ControlResponseAutomate = "AUTOMATE"

	// ControlResponseDefer is a ControlResponse enum value
	ControlResponseDefer = "DEFER"

	// ControlResponseIgnore is a ControlResponse enum value
	ControlResponseIgnore = "IGNORE"
)

// ControlResponse_Values returns all elements of the ControlResponse enum
func ControlResponse_Values() []string {
	return []string{
		ControlResponseManual,
		ControlResponseAutomate,
		ControlResponseDefer,
		ControlResponseIgnore,
	}
}

const (
	// ControlSetStatusActive is a ControlSetStatus enum value
	ControlSetStatusActive = "ACTIVE"

	// ControlSetStatusUnderReview is a ControlSetStatus enum value
	ControlSetStatusUnderReview = "UNDER_REVIEW"

	// ControlSetStatusReviewed is a ControlSetStatus enum value
	ControlSetStatusReviewed = "REVIEWED"
)

// ControlSetStatus_Values returns all elements of the ControlSetStatus enum
func ControlSetStatus_Values() []string {
	return []string{
		ControlSetStatusActive,
		ControlSetStatusUnderReview,
		ControlSetStatusReviewed,
	}
}

const (
	// ControlStatusUnderReview is a ControlStatus enum value
	ControlStatusUnderReview = "UNDER_REVIEW"

	// ControlStatusReviewed is a ControlStatus enum value
	ControlStatusReviewed = "REVIEWED"

	// ControlStatusInactive is a ControlStatus enum value
	ControlStatusInactive = "INACTIVE"
)

// ControlStatus_Values returns all elements of the ControlStatus enum
func ControlStatus_Values() []string {
	return []string{
		ControlStatusUnderReview,
		ControlStatusReviewed,
		ControlStatusInactive,
	}
}

const (
	// ControlTypeStandard is a ControlType enum value
	ControlTypeStandard = "Standard"

	// ControlTypeCustom is a ControlType enum value
	ControlTypeCustom = "Custom"
)

// ControlType_Values returns all elements of the ControlType enum
func ControlType_Values() []string {
	return []string{
		ControlTypeStandard,
		ControlTypeCustom,
	}
}

const (
	// DelegationStatusInProgress is a DelegationStatus enum value
	DelegationStatusInProgress = "IN_PROGRESS"

	// DelegationStatusUnderReview is a DelegationStatus enum value
	DelegationStatusUnderReview = "UNDER_REVIEW"

	// DelegationStatusComplete is a DelegationStatus enum value
	DelegationStatusComplete = "COMPLETE"
)

// DelegationStatus_Values returns all elements of the DelegationStatus enum
func DelegationStatus_Values() []string {
	return []string{
		DelegationStatusInProgress,
		DelegationStatusUnderReview,
		DelegationStatusComplete,
	}
}

const (
	// FrameworkTypeStandard is a FrameworkType enum value
	FrameworkTypeStandard = "Standard"

	// FrameworkTypeCustom is a FrameworkType enum value
	FrameworkTypeCustom = "Custom"
)

// FrameworkType_Values returns all elements of the FrameworkType enum
func FrameworkType_Values() []string {
	return []string{
		FrameworkTypeStandard,
		FrameworkTypeCustom,
	}
}

const (
	// KeywordInputTypeSelectFromList is a KeywordInputType enum value
	KeywordInputTypeSelectFromList = "SELECT_FROM_LIST"
)

// KeywordInputType_Values returns all elements of the KeywordInputType enum
func KeywordInputType_Values() []string {
	return []string{
		KeywordInputTypeSelectFromList,
	}
}

const (
	// ObjectTypeEnumAssessment is a ObjectTypeEnum enum value
	ObjectTypeEnumAssessment = "ASSESSMENT"

	// ObjectTypeEnumControlSet is a ObjectTypeEnum enum value
	ObjectTypeEnumControlSet = "CONTROL_SET"

	// ObjectTypeEnumControl is a ObjectTypeEnum enum value
	ObjectTypeEnumControl = "CONTROL"

	// ObjectTypeEnumDelegation is a ObjectTypeEnum enum value
	ObjectTypeEnumDelegation = "DELEGATION"

	// ObjectTypeEnumAssessmentReport is a ObjectTypeEnum enum value
	ObjectTypeEnumAssessmentReport = "ASSESSMENT_REPORT"
)

// ObjectTypeEnum_Values returns all elements of the ObjectTypeEnum enum
func ObjectTypeEnum_Values() []string {
	return []string{
		ObjectTypeEnumAssessment,
		ObjectTypeEnumControlSet,
		ObjectTypeEnumControl,
		ObjectTypeEnumDelegation,
		ObjectTypeEnumAssessmentReport,
	}
}

const (
	// RoleTypeProcessOwner is a RoleType enum value
	RoleTypeProcessOwner = "PROCESS_OWNER"

	// RoleTypeResourceOwner is a RoleType enum value
	RoleTypeResourceOwner = "RESOURCE_OWNER"
)

// RoleType_Values returns all elements of the RoleType enum
func RoleType_Values() []string {
	return []string{
		RoleTypeProcessOwner,
		RoleTypeResourceOwner,
	}
}

const (
	// SettingAttributeAll is a SettingAttribute enum value
	SettingAttributeAll = "ALL"

	// SettingAttributeIsAwsOrgEnabled is a SettingAttribute enum value
	SettingAttributeIsAwsOrgEnabled = "IS_AWS_ORG_ENABLED"

	// SettingAttributeSnsTopic is a SettingAttribute enum value
	SettingAttributeSnsTopic = "SNS_TOPIC"

	// SettingAttributeDefaultAssessmentReportsDestination is a SettingAttribute enum value
	SettingAttributeDefaultAssessmentReportsDestination = "DEFAULT_ASSESSMENT_REPORTS_DESTINATION"

	// SettingAttributeDefaultProcessOwners is a SettingAttribute enum value
	SettingAttributeDefaultProcessOwners = "DEFAULT_PROCESS_OWNERS"
)

// SettingAttribute_Values returns all elements of the SettingAttribute enum
func SettingAttribute_Values() []string {
	return []string{
		SettingAttributeAll,
		SettingAttributeIsAwsOrgEnabled,
		SettingAttributeSnsTopic,
		SettingAttributeDefaultAssessmentReportsDestination,
		SettingAttributeDefaultProcessOwners,
	}
}

const (
	// SourceFrequencyDaily is a SourceFrequency enum value
	SourceFrequencyDaily = "DAILY"

	// SourceFrequencyWeekly is a SourceFrequency enum value
	SourceFrequencyWeekly = "WEEKLY"

	// SourceFrequencyMonthly is a SourceFrequency enum value
	SourceFrequencyMonthly = "MONTHLY"
)

// SourceFrequency_Values returns all elements of the SourceFrequency enum
func SourceFrequency_Values() []string {
	return []string{
		SourceFrequencyDaily,
		SourceFrequencyWeekly,
		SourceFrequencyMonthly,
	}
}

const (
	// SourceSetUpOptionSystemControlsMapping is a SourceSetUpOption enum value
	SourceSetUpOptionSystemControlsMapping = "System_Controls_Mapping"

	// SourceSetUpOptionProceduralControlsMapping is a SourceSetUpOption enum value
	SourceSetUpOptionProceduralControlsMapping = "Procedural_Controls_Mapping"
)

// SourceSetUpOption_Values returns all elements of the SourceSetUpOption enum
func SourceSetUpOption_Values() []string {
	return []string{
		SourceSetUpOptionSystemControlsMapping,
		SourceSetUpOptionProceduralControlsMapping,
	}
}

const (
	// SourceTypeAwsCloudtrail is a SourceType enum value
	SourceTypeAwsCloudtrail = "AWS_Cloudtrail"

	// SourceTypeAwsConfig is a SourceType enum value
	SourceTypeAwsConfig = "AWS_Config"

	// SourceTypeAwsSecurityHub is a SourceType enum value
	SourceTypeAwsSecurityHub = "AWS_Security_Hub"

	// SourceTypeAwsApiCall is a SourceType enum value
	SourceTypeAwsApiCall = "AWS_API_Call"

	// SourceTypeManual is a SourceType enum value
	SourceTypeManual = "MANUAL"
)

// SourceType_Values returns all elements of the SourceType enum
func SourceType_Values() []string {
	return []string{
		SourceTypeAwsCloudtrail,
		SourceTypeAwsConfig,
		SourceTypeAwsSecurityHub,
		SourceTypeAwsApiCall,
		SourceTypeManual,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
