+++
[menu.docs]
name = "H2"
parent = "backends"
weight = 2
+++


# H2 Backend

To use H2 as the persistent storage for Reaper, the `storageType` setting must be set to **h2** in the Reaper configuration YAML file. When using H2 storage, the database will be automatically created under the path configured in the configuration YAML file. An example of how to configure H2 as persistent storage for Reaper can be found in the *[cassandra-reaper-h2.yaml](https://github.com/thelastpickle/cassandra-reaper/blob/master/src/packaging/resource/cassandra-reaper-h2.yaml)*.


```yaml
storageType: h2
h2:
  # H2 JDBC settings
  url: jdbc:h2:~/reaper-db/db;MODE=PostgreSQL
  user:
  password:
  
```
