#!/bin/bash

# Create the diversions
for mod in !!MODLIST!! ; do
  echo "Diverting kernel module $(basename $mod)"
  dpkg-divert --add --package !!PACKAGE!! --rename --divert "$mod.orig" "$mod"
  rc=$?
  if [ $rc -ne 0 ] ; then
    echo "Error $rc while diverting $mod"
    exit $rc
  fi
done

# If a prior kernel-modules is installed, divert the qed binary
qed_bin='/lib/firmware/qed/qed_init_values_zipped-8.50.16.0.bin'
if [[ -e $qed_bin ]]; then
  dpkg-divert --add --package !!PACKAGE!! --rename --divert "$qed_bin.orig" "$qed_bin"
fi
