#
# spec file for package db1 (Version 1.85)
#
# Copyright (c) 2006 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# usedforbuild    aaa_base acl attr audit-libs autoconf automake bash bind-libs bind-utils binutils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db diffutils e2fsprogs file filesystem fillup findutils flex gawk gcc gdbm gdbm-devel gettext gettext-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv klogd less libacl libattr libcom_err libgcc libnscd libstdc++ libtool libxcrypt libzio m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch perl permissions popt procinfo procps psmisc pwdutils rcs readline rpm sed strace sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel

Name:           db1
Summary:        Berkeley DB Database Library Version 1.85
Version:        1.85
Release:        97
Source:         http://www.sleepycat.com/update/%{version}/db.%{version}.tar.gz
Patch0:         db.%{version}.patch
Patch1:         db.%{version}.fPIC.diff
Patch2:         db.%{version}.nodebug.patch
Patch3:         db.%{version}.hash.diff
Patch4:         db.%{version}.__P.diff
URL:            http://www.sleepycat.com
License:        BSD
Group:          System/Libraries
PreReq:         /sbin/ldconfig
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Prefix:         %{_prefix}
Conflicts:      glibc < 2.3.2
%debug_package
%package devel
Summary:        Include Files and Libraries for the old Berkeley DB library Version 1.85
Group:          Development/Libraries/C and C++
Prefix:         %{_prefix}
Requires:       db1 = %{version}
Conflicts:      glibc-devel < 2.3.2

%description
The Berkeley DB Database is a programmatic toolkit that provides
database support for applications.

This package contains the necessary runtime libraries for the old 1.85
release.




%description devel
The Berkeley DB Database is a programmatic toolkit that provides
database support for applications.

This package contains the header files, libraries, and documentation
for building programs which need the old Berkeley DB version 1.85. If
possible you should convert your program to work with the new Berkeley
DB version. This version will be removed in a future release.



%prep
%setup -q -n db.%{version}
%patch0 -p1 
%patch1
%patch2 -p1
%patch3
%patch4

%build
gzip -9 docs/*.ps
cd PORT/linux
make OORG="$RPM_OPT_FLAGS -Wall -W -fno-strict-aliasing"

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/{include/db1,%{_lib},bin}
sed -n '/^\/\*-/,/^ \*\//s/^.\*.\?//p' include/db.h | grep -v '^@.*db\.h' > LICENSE
cd PORT/linux
sover=`echo libdb.so.* | sed 's/libdb.so.//'`
install -m644 libdb.a		$RPM_BUILD_ROOT/%{_prefix}/%{_lib}/libdb-%{version}.a
ln -sf libdb-%{version}.a	$RPM_BUILD_ROOT/%{_prefix}/%{_lib}/libdb1.a
install -m755 libdb.so.$sover	$RPM_BUILD_ROOT/%{_prefix}/%{_lib}/libdb-%{version}.so
ldconfig -n $RPM_BUILD_ROOT/%{_prefix}/%{_lib}/
ln -sf libdb-%{version}.so 	$RPM_BUILD_ROOT/%{_prefix}/%{_lib}/libdb1.so
install -m644 ../../include/db.h	$RPM_BUILD_ROOT/%{_prefix}/include/db1/
install -m644 ../../include/mpool.h	$RPM_BUILD_ROOT/%{_prefix}/include/db1/
install -m755 db_dump185	$RPM_BUILD_ROOT/%{_prefix}/bin/db1_dump185

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
%{run_ldconfig}

%postun
%{run_ldconfig}

%files
%defattr(-,root,root,755)
%doc README LICENSE
%{_prefix}/%{_lib}/libdb-%{version}.so
%{_prefix}/%{_lib}/libdb.so.*
%{_prefix}/bin/db1_dump185

%files devel
%defattr(644,root,root,755)
%{_prefix}/include/db1
%{_prefix}/%{_lib}/libdb-%{version}.a
%{_prefix}/%{_lib}/libdb1.a
%{_prefix}/%{_lib}/libdb1.so

%changelog -n db1
* Wed Jan 25 2006 - mls@suse.de
- converted neededforbuild to BuildRequires
* Sat Sep 11 2004 - kukuk@suse.de
- Fix usage of __P
* Sat Sep 27 2003 - kukuk@suse.de
- Fix ldconfig warnings
* Fri Sep 26 2003 - kukuk@suse.de
- Initial version (branch from glibc) for compatibility
